/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source.model;

import dev.gradleplugins.documentationkit.dsl.source.model.AbstractLanguageElement;
import dev.gradleplugins.documentationkit.dsl.source.model.EnumConstantMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeContainer;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import dev.gradleplugins.documentationkit.model.Attachable;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.util.GUtil;

public class ClassMetaData
extends AbstractLanguageElement
implements Serializable,
Attachable<ClassMetaData>,
TypeContainer {
    private final String className;
    private String superClassName;
    private final String packageName;
    private final MetaType metaType;
    private final boolean isGroovy;
    private final List<String> imports = new ArrayList<String>();
    private final List<String> interfaceNames = new ArrayList<String>();
    private final Map<String, PropertyMetaData> declaredProperties = new HashMap<String, PropertyMetaData>();
    private final Set<MethodMetaData> declaredMethods = new HashSet<MethodMetaData>();
    private final List<String> innerClassNames = new ArrayList<String>();
    private String outerClassName;
    private transient ClassMetaDataRepository<ClassMetaData> metaDataRepository;
    public final HashMap<String, String> constants = new HashMap();
    private final List<EnumConstantMetaData> enumConstants = new ArrayList<EnumConstantMetaData>();

    public ClassMetaData(String className, String packageName, MetaType metaType, boolean isGroovy, String rawClassComment) {
        super(rawClassComment);
        this.className = className;
        this.packageName = packageName;
        this.metaType = metaType;
        this.isGroovy = isGroovy;
    }

    public ClassMetaData(String className) {
        this(className, StringUtils.substringBeforeLast((String)className, (String)"."), MetaType.CLASS, false, "");
    }

    public String toString() {
        return this.className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        return StringUtils.substringAfterLast((String)this.className, (String)".");
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isInterface() {
        return this.metaType == MetaType.INTERFACE;
    }

    public boolean isGroovy() {
        return this.isGroovy;
    }

    public boolean isEnum() {
        return this.metaType == MetaType.ENUM;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public ClassMetaData getSuperClass() {
        return this.superClassName == null ? null : this.metaDataRepository.find(this.superClassName);
    }

    public List<String> getInterfaceNames() {
        return this.interfaceNames;
    }

    public void addInterfaceName(String name) {
        this.interfaceNames.add(name);
    }

    public List<ClassMetaData> getInterfaces() {
        ArrayList<ClassMetaData> interfaces = new ArrayList<ClassMetaData>();
        for (String interfaceName : this.interfaceNames) {
            ClassMetaData interfaceMetaData = this.metaDataRepository.find(interfaceName);
            if (interfaceMetaData == null) continue;
            interfaces.add(interfaceMetaData);
        }
        return interfaces;
    }

    public List<String> getInnerClassNames() {
        return this.innerClassNames;
    }

    public void addInnerClassName(String innerClassName) {
        this.innerClassNames.add(innerClassName);
    }

    public String getOuterClassName() {
        return this.outerClassName;
    }

    public void setOuterClassName(String outerClassName) {
        this.outerClassName = outerClassName;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void addImport(String importName) {
        this.imports.add(importName);
    }

    public PropertyMetaData addReadableProperty(String name, TypeMetaData type, String rawCommentText, MethodMetaData getterMethod) {
        PropertyMetaData property = this.getProperty(name);
        property.setType(type);
        property.setRawCommentText(rawCommentText);
        property.setGetter(getterMethod);
        return property;
    }

    public PropertyMetaData addWriteableProperty(String name, TypeMetaData type, String rawCommentText, MethodMetaData setterMethod) {
        PropertyMetaData property = this.getProperty(name);
        if (property.getType() == null) {
            property.setType(type);
        }
        if (!GUtil.isTrue((Object)property.getRawCommentText())) {
            property.setRawCommentText(rawCommentText);
        }
        property.setSetter(setterMethod);
        return property;
    }

    public PropertyMetaData findDeclaredProperty(String name) {
        return this.declaredProperties.get(name);
    }

    public Set<String> getDeclaredPropertyNames() {
        return this.declaredProperties.keySet();
    }

    public Set<PropertyMetaData> getDeclaredProperties() {
        return new HashSet<PropertyMetaData>(this.declaredProperties.values());
    }

    public Set<MethodMetaData> getDeclaredMethods() {
        return this.declaredMethods;
    }

    public Set<String> getDeclaredMethodNames() {
        HashSet<String> names = new HashSet<String>();
        for (MethodMetaData declaredMethod : this.declaredMethods) {
            names.add(declaredMethod.getName());
        }
        return names;
    }

    public MethodMetaData findDeclaredMethod(String signature) {
        for (MethodMetaData method : this.declaredMethods) {
            if (!method.getOverrideSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public List<MethodMetaData> findDeclaredMethods(String name) {
        ArrayList<MethodMetaData> methods = new ArrayList<MethodMetaData>();
        for (MethodMetaData method : this.declaredMethods) {
            if (!method.getName().equals(name)) continue;
            methods.add(method);
        }
        return methods;
    }

    public PropertyMetaData findProperty(String name) {
        PropertyMetaData propertyMetaData = this.declaredProperties.get(name);
        if (propertyMetaData != null) {
            return propertyMetaData;
        }
        ClassMetaData superClass = this.getSuperClass();
        if (superClass != null) {
            return superClass.findProperty(name);
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        TreeSet<String> propertyNames = new TreeSet<String>();
        propertyNames.addAll(this.declaredProperties.keySet());
        ClassMetaData superClass = this.getSuperClass();
        if (superClass != null) {
            propertyNames.addAll(superClass.getPropertyNames());
        }
        return propertyNames;
    }

    private PropertyMetaData getProperty(String name) {
        PropertyMetaData property = this.declaredProperties.get(name);
        if (property == null) {
            property = new PropertyMetaData(name, this);
            this.declaredProperties.put(name, property);
        }
        return property;
    }

    public Map<String, String> getConstants() {
        return this.constants;
    }

    public void addEnumConstant(String name) {
        this.enumConstants.add(new EnumConstantMetaData(name, this));
    }

    public List<EnumConstantMetaData> getEnumConstants() {
        return this.enumConstants;
    }

    public EnumConstantMetaData getEnumConstant(String name) {
        for (EnumConstantMetaData enumConstant : this.enumConstants) {
            if (!enumConstant.getName().equals(name)) continue;
            return enumConstant;
        }
        return null;
    }

    @Override
    public void attach(ClassMetaDataRepository<ClassMetaData> metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    public MethodMetaData addMethod(String name, TypeMetaData returnType, String rawCommentText) {
        MethodMetaData method = new MethodMetaData(name, this);
        this.declaredMethods.add(method);
        method.setReturnType(returnType);
        method.setRawCommentText(rawCommentText);
        return method;
    }

    @Override
    public void resolveTypes(Transformer<String, String> transformer) {
        super.resolveTypes(transformer);
        if (this.superClassName != null) {
            this.superClassName = (String)transformer.transform((Object)this.superClassName);
        }
        for (int i = 0; i < this.interfaceNames.size(); ++i) {
            this.interfaceNames.set(i, (String)transformer.transform((Object)this.interfaceNames.get(i)));
        }
        for (PropertyMetaData propertyMetaData : this.declaredProperties.values()) {
            propertyMetaData.resolveTypes(transformer);
        }
        for (MethodMetaData methodMetaData : this.declaredMethods) {
            methodMetaData.resolveTypes(transformer);
        }
    }

    @Override
    public void visitTypes(Action<TypeMetaData> action) {
        for (PropertyMetaData propertyMetaData : this.declaredProperties.values()) {
            propertyMetaData.visitTypes(action);
        }
        for (MethodMetaData methodMetaData : this.declaredMethods) {
            methodMetaData.visitTypes(action);
        }
    }

    public static enum MetaType {
        CLASS,
        INTERFACE,
        ENUM,
        ANNOTATION;

    }
}

