/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import dev.gradleplugins.documentationkit.DocGenerationException;
import dev.gradleplugins.documentationkit.dsl.source.SourceMetaDataVisitor;
import dev.gradleplugins.documentationkit.dsl.source.TypeNameResolver;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import dev.gradleplugins.documentationkit.model.SimpleClassMetaDataRepository;
import groovy.time.TimeCategory;
import groovy.time.TimeDuration;
import java.io.File;
import java.util.Date;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ExtractDslMetaDataTask
extends SourceTask {
    @OutputFile
    public abstract RegularFileProperty getDestinationFile();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @TaskAction
    private void extract() {
        Date start = new Date();
        SimpleClassMetaDataRepository<ClassMetaData> repository = new SimpleClassMetaDataRepository<ClassMetaData>();
        int counter = 0;
        for (File f : this.getSource()) {
            this.parse(f, repository);
            ++counter;
        }
        final TypeNameResolver resolver = new TypeNameResolver(repository);
        repository.each(new Action<ClassMetaData>(){

            public void execute(ClassMetaData metaData) {
                ExtractDslMetaDataTask.this.fullyQualifyAllTypeNames(metaData, resolver);
            }
        });
        repository.store(((RegularFile)this.getDestinationFile().get()).getAsFile());
        Date stop = new Date();
        TimeDuration elapsedTime = TimeCategory.minus((Date)stop, (Date)start);
        System.out.println(String.format("Parsed %d classes in %s", counter, elapsedTime));
    }

    void parse(File sourceFile, ClassMetaDataRepository<ClassMetaData> repository) {
        if (!sourceFile.getName().endsWith(".java")) {
            throw new DocGenerationException("Parsing non-Java files is not supported: " + sourceFile.getAbsolutePath());
        }
        try {
            new SourceMetaDataVisitor().visit((CompilationUnit)new JavaParser().parse(sourceFile).getResult().get(), repository);
        }
        catch (Exception e) {
            throw new DocGenerationException("Could not parse '$sourceFile'.", e);
        }
    }

    void fullyQualifyAllTypeNames(final ClassMetaData classMetaData, final TypeNameResolver resolver) {
        try {
            classMetaData.resolveTypes(new Transformer<String, String>(){

                public String transform(String i) {
                    return resolver.resolve(i, classMetaData);
                }
            });
            classMetaData.visitTypes(new Action<TypeMetaData>(){

                public void execute(TypeMetaData t) {
                    resolver.resolve(t, classMetaData);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resolve types in class '" + classMetaData.getClassName() + "'.", e);
        }
    }
}

