/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source;

import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.model.SimpleClassMetaDataRepository;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;

public class ClassMetaDataUtil {
    public static void extractFromMetadata(File metaData, Set<String> excludedPackagePatterns, final Action<ClassMetaData> extractor) {
        SimpleClassMetaDataRepository<ClassMetaData> repository = new SimpleClassMetaDataRepository<ClassMetaData>();
        repository.load(metaData);
        final HashSet<String> excludedPrefixes = new HashSet<String>();
        final HashSet<String> excludedPackages = new HashSet<String>();
        for (String excludePattern : excludedPackagePatterns) {
            if (excludePattern.endsWith(".**")) {
                String baseName = excludePattern.substring(0, excludePattern.length() - 3);
                excludedPrefixes.add(baseName + '.');
                excludedPackages.add(baseName);
                continue;
            }
            excludedPackages.add(excludePattern);
        }
        repository.each(new Action<ClassMetaData>(){

            public void execute(ClassMetaData classMetaData) {
                if (classMetaData.getOuterClassName() != null) {
                    return;
                }
                String packageName = classMetaData.getPackageName();
                if (excludedPackages.contains(packageName)) {
                    return;
                }
                for (String excludedPrefix : excludedPrefixes) {
                    if (!packageName.startsWith(excludedPrefix)) continue;
                    return;
                }
                extractor.execute((Object)classMetaData);
            }
        });
    }
}

