/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook.model;

import com.google.common.collect.ImmutableSet;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ExtensionMetaData;
import dev.gradleplugins.documentationkit.dsl.docbook.model.MixinMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ClassExtensionMetaData {
    private final String targetClass;
    private final Set<MixinMetaData> mixinClasses;
    private final Set<ExtensionMetaData> extensionClasses;

    public ClassExtensionMetaData(String targetClass) {
        this(targetClass, (Set<MixinMetaData>)ImmutableSet.of(), (Set<ExtensionMetaData>)ImmutableSet.of());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public Set<MixinMetaData> getMixinClasses() {
        return this.mixinClasses;
    }

    public Set<ExtensionMetaData> getExtensionClasses() {
        return this.extensionClasses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassExtensionMetaData)) {
            return false;
        }
        ClassExtensionMetaData other = (ClassExtensionMetaData)o;
        String this$targetClass = this.getTargetClass();
        String other$targetClass = other.getTargetClass();
        if (this$targetClass == null ? other$targetClass != null : !this$targetClass.equals(other$targetClass)) {
            return false;
        }
        Set<MixinMetaData> this$mixinClasses = this.getMixinClasses();
        Set<MixinMetaData> other$mixinClasses = other.getMixinClasses();
        if (this$mixinClasses == null ? other$mixinClasses != null : !((Object)this$mixinClasses).equals(other$mixinClasses)) {
            return false;
        }
        Set<ExtensionMetaData> this$extensionClasses = this.getExtensionClasses();
        Set<ExtensionMetaData> other$extensionClasses = other.getExtensionClasses();
        return !(this$extensionClasses == null ? other$extensionClasses != null : !((Object)this$extensionClasses).equals(other$extensionClasses));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetClass = this.getTargetClass();
        result = result * 59 + ($targetClass == null ? 43 : $targetClass.hashCode());
        Set<MixinMetaData> $mixinClasses = this.getMixinClasses();
        result = result * 59 + ($mixinClasses == null ? 43 : ((Object)$mixinClasses).hashCode());
        Set<ExtensionMetaData> $extensionClasses = this.getExtensionClasses();
        result = result * 59 + ($extensionClasses == null ? 43 : ((Object)$extensionClasses).hashCode());
        return result;
    }

    public String toString() {
        return "ClassExtensionMetaData(targetClass=" + this.getTargetClass() + ", mixinClasses=" + this.getMixinClasses() + ", extensionClasses=" + this.getExtensionClasses() + ")";
    }

    public ClassExtensionMetaData(String targetClass, Set<MixinMetaData> mixinClasses, Set<ExtensionMetaData> extensionClasses) {
        this.targetClass = targetClass;
        this.mixinClasses = mixinClasses;
        this.extensionClasses = extensionClasses;
    }

    public static class Builder {
        private String targetClass;
        private ArrayList<MixinMetaData> mixinClasses;
        private ArrayList<ExtensionMetaData> extensionClasses;

        Builder() {
        }

        public Builder targetClass(String targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder mixinClass(MixinMetaData mixinClass) {
            if (this.mixinClasses == null) {
                this.mixinClasses = new ArrayList();
            }
            this.mixinClasses.add(mixinClass);
            return this;
        }

        public Builder mixinClasses(Collection<? extends MixinMetaData> mixinClasses) {
            if (mixinClasses == null) {
                throw new NullPointerException("mixinClasses cannot be null");
            }
            if (this.mixinClasses == null) {
                this.mixinClasses = new ArrayList();
            }
            this.mixinClasses.addAll(mixinClasses);
            return this;
        }

        public Builder clearMixinClasses() {
            if (this.mixinClasses != null) {
                this.mixinClasses.clear();
            }
            return this;
        }

        public Builder extensionClass(ExtensionMetaData extensionClass) {
            if (this.extensionClasses == null) {
                this.extensionClasses = new ArrayList();
            }
            this.extensionClasses.add(extensionClass);
            return this;
        }

        public Builder extensionClasses(Collection<? extends ExtensionMetaData> extensionClasses) {
            if (extensionClasses == null) {
                throw new NullPointerException("extensionClasses cannot be null");
            }
            if (this.extensionClasses == null) {
                this.extensionClasses = new ArrayList();
            }
            this.extensionClasses.addAll(extensionClasses);
            return this;
        }

        public Builder clearExtensionClasses() {
            if (this.extensionClasses != null) {
                this.extensionClasses.clear();
            }
            return this;
        }

        public ClassExtensionMetaData build() {
            Set<ExtensionMetaData> extensionClasses;
            Set<Object> mixinClasses;
            switch (this.mixinClasses == null ? 0 : this.mixinClasses.size()) {
                case 0: {
                    mixinClasses = Collections.emptySet();
                    break;
                }
                case 1: {
                    mixinClasses = Collections.singleton(this.mixinClasses.get(0));
                    break;
                }
                default: {
                    mixinClasses = new LinkedHashSet(this.mixinClasses.size() < 0x40000000 ? 1 + this.mixinClasses.size() + (this.mixinClasses.size() - 3) / 3 : Integer.MAX_VALUE);
                    mixinClasses.addAll(this.mixinClasses);
                    mixinClasses = Collections.unmodifiableSet(mixinClasses);
                }
            }
            switch (this.extensionClasses == null ? 0 : this.extensionClasses.size()) {
                case 0: {
                    extensionClasses = Collections.emptySet();
                    break;
                }
                case 1: {
                    extensionClasses = Collections.singleton(this.extensionClasses.get(0));
                    break;
                }
                default: {
                    extensionClasses = new LinkedHashSet(this.extensionClasses.size() < 0x40000000 ? 1 + this.extensionClasses.size() + (this.extensionClasses.size() - 3) / 3 : Integer.MAX_VALUE);
                    extensionClasses.addAll(this.extensionClasses);
                    extensionClasses = Collections.unmodifiableSet(extensionClasses);
                }
            }
            return new ClassExtensionMetaData(this.targetClass, mixinClasses, extensionClasses);
        }

        public String toString() {
            return "ClassExtensionMetaData.Builder(targetClass=" + this.targetClass + ", mixinClasses=" + this.mixinClasses + ", extensionClasses=" + this.extensionClasses + ")";
        }
    }
}

