/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook.model;

import dev.gradleplugins.documentationkit.dsl.docbook.model.BlockDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.MethodDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.PropertyDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassExtensionDoc {
    private final Set<ClassDoc> mixinClasses = new LinkedHashSet<ClassDoc>();
    private final Map<String, ClassDoc> extensionClasses = new LinkedHashMap<String, ClassDoc>();
    private final String pluginId;
    private final ClassMetaData targetClassMetaData;
    private final List<PropertyDoc> extraProperties = new ArrayList<PropertyDoc>();
    private final List<BlockDoc> extraBlocks = new ArrayList<BlockDoc>();

    public ClassExtensionDoc(String pluginId, ClassMetaData targetClassMetaData) {
        this.pluginId = pluginId;
        this.targetClassMetaData = targetClassMetaData;
    }

    public List<PropertyDoc> getExtensionProperties() {
        ArrayList<PropertyDoc> properties = new ArrayList<PropertyDoc>();
        this.mixinClasses.forEach(mixin -> mixin.getClassProperties().forEach(prop -> properties.add(prop.forClass(this.targetClassMetaData))));
        this.extraProperties.forEach(prop -> properties.add(prop.forClass(this.targetClassMetaData)));
        Collections.sort(properties, Comparator.comparing(PropertyDoc::getName));
        return properties;
    }

    public List<MethodDoc> getExtensionMethods() {
        ArrayList<MethodDoc> methods = new ArrayList<MethodDoc>();
        this.mixinClasses.forEach(mixin -> mixin.getClassMethods().forEach(method -> methods.add(method.forClass(this.targetClassMetaData))));
        Collections.sort(methods, Comparator.comparing(it -> it.getMetaData().getOverrideSignature()));
        return methods;
    }

    public List<BlockDoc> getExtensionBlocks() {
        ArrayList<BlockDoc> blocks = new ArrayList<BlockDoc>();
        this.mixinClasses.forEach(mixin -> mixin.getClassBlocks().forEach(block -> blocks.add(block.forClass(this.targetClassMetaData))));
        this.extraBlocks.forEach(block -> blocks.add(block.forClass(this.targetClassMetaData)));
        Collections.sort(blocks, Comparator.comparing(BlockDoc::getName));
        return blocks;
    }

    public Set<ClassDoc> getMixinClasses() {
        return this.mixinClasses;
    }

    public Map<String, ClassDoc> getExtensionClasses() {
        return this.extensionClasses;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public ClassMetaData getTargetClassMetaData() {
        return this.targetClassMetaData;
    }

    public List<PropertyDoc> getExtraProperties() {
        return this.extraProperties;
    }

    public List<BlockDoc> getExtraBlocks() {
        return this.extraBlocks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassExtensionDoc)) {
            return false;
        }
        ClassExtensionDoc other = (ClassExtensionDoc)o;
        Set<ClassDoc> this$mixinClasses = this.getMixinClasses();
        Set<ClassDoc> other$mixinClasses = other.getMixinClasses();
        if (this$mixinClasses == null ? other$mixinClasses != null : !((Object)this$mixinClasses).equals(other$mixinClasses)) {
            return false;
        }
        Map<String, ClassDoc> this$extensionClasses = this.getExtensionClasses();
        Map<String, ClassDoc> other$extensionClasses = other.getExtensionClasses();
        if (this$extensionClasses == null ? other$extensionClasses != null : !((Object)this$extensionClasses).equals(other$extensionClasses)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        ClassMetaData this$targetClassMetaData = this.getTargetClassMetaData();
        ClassMetaData other$targetClassMetaData = other.getTargetClassMetaData();
        if (this$targetClassMetaData == null ? other$targetClassMetaData != null : !((Object)this$targetClassMetaData).equals(other$targetClassMetaData)) {
            return false;
        }
        List<PropertyDoc> this$extraProperties = this.getExtraProperties();
        List<PropertyDoc> other$extraProperties = other.getExtraProperties();
        if (this$extraProperties == null ? other$extraProperties != null : !((Object)this$extraProperties).equals(other$extraProperties)) {
            return false;
        }
        List<BlockDoc> this$extraBlocks = this.getExtraBlocks();
        List<BlockDoc> other$extraBlocks = other.getExtraBlocks();
        return !(this$extraBlocks == null ? other$extraBlocks != null : !((Object)this$extraBlocks).equals(other$extraBlocks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<ClassDoc> $mixinClasses = this.getMixinClasses();
        result = result * 59 + ($mixinClasses == null ? 43 : ((Object)$mixinClasses).hashCode());
        Map<String, ClassDoc> $extensionClasses = this.getExtensionClasses();
        result = result * 59 + ($extensionClasses == null ? 43 : ((Object)$extensionClasses).hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        ClassMetaData $targetClassMetaData = this.getTargetClassMetaData();
        result = result * 59 + ($targetClassMetaData == null ? 43 : ((Object)$targetClassMetaData).hashCode());
        List<PropertyDoc> $extraProperties = this.getExtraProperties();
        result = result * 59 + ($extraProperties == null ? 43 : ((Object)$extraProperties).hashCode());
        List<BlockDoc> $extraBlocks = this.getExtraBlocks();
        result = result * 59 + ($extraBlocks == null ? 43 : ((Object)$extraBlocks).hashCode());
        return result;
    }

    public String toString() {
        return "ClassExtensionDoc(mixinClasses=" + this.getMixinClasses() + ", extensionClasses=" + this.getExtensionClasses() + ", pluginId=" + this.getPluginId() + ", targetClassMetaData=" + this.getTargetClassMetaData() + ", extraProperties=" + this.getExtraProperties() + ", extraBlocks=" + this.getExtraBlocks() + ")";
    }
}

