/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.gradleplugins.documentationkit.dsl.docbook.DslDocModel;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class ClassDocSuperTypes {
    private final ClassDoc superClass;
    @NonNull
    private final List<ClassDoc> interfaces;

    public Optional<ClassDoc> getSuperClass() {
        return Optional.ofNullable(this.superClass);
    }

    public List<ClassDoc> getSuperTypes() {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)((Iterable)this.getSuperClass().map(ImmutableList::of).orElse(ImmutableList.of())), this.interfaces));
    }

    public static ClassDocSuperTypes of(ClassMetaData metaData, DslDocModel model) {
        Builder builder = ClassDocSuperTypes.builder();
        String superClassName = metaData.getSuperClassName();
        if (superClassName != null) {
            ClassDoc superClass = model.getClassDoc(superClassName);
            builder.withSuperClass(superClass);
        }
        List<String> interfaceNames = metaData.getInterfaceNames();
        for (String interfaceName : interfaceNames) {
            ClassDoc superInterface = model.findClassDoc(interfaceName);
            if (superInterface == null) continue;
            builder.withInterface(superInterface);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public List<ClassDoc> getInterfaces() {
        return this.interfaces;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDocSuperTypes)) {
            return false;
        }
        ClassDocSuperTypes other = (ClassDocSuperTypes)o;
        Optional<ClassDoc> this$superClass = this.getSuperClass();
        Optional<ClassDoc> other$superClass = other.getSuperClass();
        if (this$superClass == null ? other$superClass != null : !((Object)this$superClass).equals(other$superClass)) {
            return false;
        }
        List<ClassDoc> this$interfaces = this.getInterfaces();
        List<ClassDoc> other$interfaces = other.getInterfaces();
        return !(this$interfaces == null ? other$interfaces != null : !((Object)this$interfaces).equals(other$interfaces));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<ClassDoc> $superClass = this.getSuperClass();
        result = result * 59 + ($superClass == null ? 43 : ((Object)$superClass).hashCode());
        List<ClassDoc> $interfaces = this.getInterfaces();
        result = result * 59 + ($interfaces == null ? 43 : ((Object)$interfaces).hashCode());
        return result;
    }

    public String toString() {
        return "ClassDocSuperTypes(superClass=" + this.getSuperClass() + ", interfaces=" + this.getInterfaces() + ")";
    }

    private ClassDocSuperTypes(ClassDoc superClass, @NonNull List<ClassDoc> interfaces) {
        if (interfaces == null) {
            throw new NullPointerException("interfaces is marked non-null but is null");
        }
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    public static class Builder {
        private ClassDoc superClass;
        private ArrayList<ClassDoc> interfaces;

        Builder() {
        }

        public Builder withSuperClass(ClassDoc superClass) {
            this.superClass = superClass;
            return this;
        }

        public Builder withInterface(ClassDoc classDoc) {
            if (this.interfaces == null) {
                this.interfaces = new ArrayList();
            }
            this.interfaces.add(classDoc);
            return this;
        }

        public Builder withInterfaces(Collection<? extends ClassDoc> interfaces) {
            if (interfaces == null) {
                throw new NullPointerException("interfaces cannot be null");
            }
            if (this.interfaces == null) {
                this.interfaces = new ArrayList();
            }
            this.interfaces.addAll(interfaces);
            return this;
        }

        public Builder clearInterfaces() {
            if (this.interfaces != null) {
                this.interfaces.clear();
            }
            return this;
        }

        public ClassDocSuperTypes build() {
            List<Object> interfaces;
            switch (this.interfaces == null ? 0 : this.interfaces.size()) {
                case 0: {
                    interfaces = Collections.emptyList();
                    break;
                }
                case 1: {
                    interfaces = Collections.singletonList(this.interfaces.get(0));
                    break;
                }
                default: {
                    interfaces = Collections.unmodifiableList(new ArrayList<ClassDoc>(this.interfaces));
                }
            }
            return new ClassDocSuperTypes(this.superClass, interfaces);
        }

        public String toString() {
            return "ClassDocSuperTypes.Builder(superClass=" + this.superClass + ", interfaces=" + this.interfaces + ")";
        }
    }
}

