/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook.model;

import dev.gradleplugins.documentationkit.dsl.docbook.DocComment;
import dev.gradleplugins.documentationkit.dsl.docbook.model.BlockDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDocSuperTypes;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassExtensionDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassExtensionMetaData;
import dev.gradleplugins.documentationkit.dsl.docbook.model.DslElementDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.MethodDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.PropertyDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public final class ClassDoc
implements DslElementDoc {
    @NonNull
    private final String className;
    @NonNull
    private final ClassMetaData metaData;
    @NonNull
    private final ClassExtensionMetaData extensionMetaData;
    @NonNull
    private final List<PropertyDoc> classProperties;
    @NonNull
    private final List<MethodDoc> classMethods;
    @NonNull
    private final List<BlockDoc> classBlocks;
    @NonNull
    private final List<ClassExtensionDoc> classExtensions;
    @NonNull
    private final ClassDocSuperTypes superTypes;
    @NonNull
    private final DocComment comment;
    @NonNull
    private final Map<String, String> additionalData;

    @Override
    public String getId() {
        return this.className;
    }

    public String getName() {
        return this.className;
    }

    public List<ClassDoc> getInterfaces() {
        return this.superTypes.getInterfaces();
    }

    public String getSimpleName() {
        return StringUtils.substringAfterLast((String)this.className, (String)".");
    }

    @Override
    public boolean isDeprecated() {
        return this.metaData.isDeprecated();
    }

    @Override
    public boolean isIncubating() {
        return this.metaData.isIncubating();
    }

    @Override
    public boolean isReplaced() {
        return this.metaData.isReplaced();
    }

    @Override
    public String getReplacement() {
        return this.metaData.getReplacement();
    }

    Optional<ClassDoc> getSuperClass() {
        return this.superTypes.getSuperClass();
    }

    List<ClassDoc> getSuperTypes() {
        return this.superTypes.getSuperTypes();
    }

    Optional<PropertyDoc> findProperty(String name) {
        return this.classProperties.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    BlockDoc getBlock(String name) {
        return this.classBlocks.stream().filter(it -> it.getName().equals(name)).findFirst().orElseGet(() -> this.classExtensions.stream().flatMap(it -> it.getExtensionBlocks().stream()).filter(it -> it.getName().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("Class " + this.className + " does not have a script block '" + name + "'.")));
    }

    @Override
    public String getDescription() {
        return this.comment.getDocbook().stream().filter(it -> it.getNodeName().equals("para")).map(Node::getTextContent).findFirst().orElse(null);
    }

    ClassDoc(@NonNull String className, @NonNull ClassMetaData metaData, @NonNull ClassExtensionMetaData extensionMetaData, @NonNull List<PropertyDoc> classProperties, @NonNull List<MethodDoc> classMethods, @NonNull List<BlockDoc> classBlocks, @NonNull List<ClassExtensionDoc> classExtensions, @NonNull ClassDocSuperTypes superTypes, @NonNull DocComment comment, @NonNull Map<String, String> additionalData) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        if (extensionMetaData == null) {
            throw new NullPointerException("extensionMetaData is marked non-null but is null");
        }
        if (classProperties == null) {
            throw new NullPointerException("classProperties is marked non-null but is null");
        }
        if (classMethods == null) {
            throw new NullPointerException("classMethods is marked non-null but is null");
        }
        if (classBlocks == null) {
            throw new NullPointerException("classBlocks is marked non-null but is null");
        }
        if (classExtensions == null) {
            throw new NullPointerException("classExtensions is marked non-null but is null");
        }
        if (superTypes == null) {
            throw new NullPointerException("superTypes is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        if (additionalData == null) {
            throw new NullPointerException("additionalData is marked non-null but is null");
        }
        this.className = className;
        this.metaData = metaData;
        this.extensionMetaData = extensionMetaData;
        this.classProperties = classProperties;
        this.classMethods = classMethods;
        this.classBlocks = classBlocks;
        this.classExtensions = classExtensions;
        this.superTypes = superTypes;
        this.comment = comment;
        this.additionalData = additionalData;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public ClassMetaData getMetaData() {
        return this.metaData;
    }

    @NonNull
    public ClassExtensionMetaData getExtensionMetaData() {
        return this.extensionMetaData;
    }

    @NonNull
    public List<PropertyDoc> getClassProperties() {
        return this.classProperties;
    }

    @NonNull
    public List<MethodDoc> getClassMethods() {
        return this.classMethods;
    }

    @NonNull
    public List<BlockDoc> getClassBlocks() {
        return this.classBlocks;
    }

    @NonNull
    public List<ClassExtensionDoc> getClassExtensions() {
        return this.classExtensions;
    }

    @Override
    @NonNull
    public DocComment getComment() {
        return this.comment;
    }

    @NonNull
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDoc)) {
            return false;
        }
        ClassDoc other = (ClassDoc)o;
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        ClassMetaData this$metaData = this.getMetaData();
        ClassMetaData other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        ClassExtensionMetaData this$extensionMetaData = this.getExtensionMetaData();
        ClassExtensionMetaData other$extensionMetaData = other.getExtensionMetaData();
        if (this$extensionMetaData == null ? other$extensionMetaData != null : !((Object)this$extensionMetaData).equals(other$extensionMetaData)) {
            return false;
        }
        List<PropertyDoc> this$classProperties = this.getClassProperties();
        List<PropertyDoc> other$classProperties = other.getClassProperties();
        if (this$classProperties == null ? other$classProperties != null : !((Object)this$classProperties).equals(other$classProperties)) {
            return false;
        }
        List<MethodDoc> this$classMethods = this.getClassMethods();
        List<MethodDoc> other$classMethods = other.getClassMethods();
        if (this$classMethods == null ? other$classMethods != null : !((Object)this$classMethods).equals(other$classMethods)) {
            return false;
        }
        List<BlockDoc> this$classBlocks = this.getClassBlocks();
        List<BlockDoc> other$classBlocks = other.getClassBlocks();
        if (this$classBlocks == null ? other$classBlocks != null : !((Object)this$classBlocks).equals(other$classBlocks)) {
            return false;
        }
        List<ClassExtensionDoc> this$classExtensions = this.getClassExtensions();
        List<ClassExtensionDoc> other$classExtensions = other.getClassExtensions();
        if (this$classExtensions == null ? other$classExtensions != null : !((Object)this$classExtensions).equals(other$classExtensions)) {
            return false;
        }
        List<ClassDoc> this$superTypes = this.getSuperTypes();
        List<ClassDoc> other$superTypes = other.getSuperTypes();
        if (this$superTypes == null ? other$superTypes != null : !((Object)this$superTypes).equals(other$superTypes)) {
            return false;
        }
        DocComment this$comment = this.getComment();
        DocComment other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$additionalData = this.getAdditionalData();
        Map<String, String> other$additionalData = other.getAdditionalData();
        return !(this$additionalData == null ? other$additionalData != null : !((Object)this$additionalData).equals(other$additionalData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        ClassMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        ClassExtensionMetaData $extensionMetaData = this.getExtensionMetaData();
        result = result * 59 + ($extensionMetaData == null ? 43 : ((Object)$extensionMetaData).hashCode());
        List<PropertyDoc> $classProperties = this.getClassProperties();
        result = result * 59 + ($classProperties == null ? 43 : ((Object)$classProperties).hashCode());
        List<MethodDoc> $classMethods = this.getClassMethods();
        result = result * 59 + ($classMethods == null ? 43 : ((Object)$classMethods).hashCode());
        List<BlockDoc> $classBlocks = this.getClassBlocks();
        result = result * 59 + ($classBlocks == null ? 43 : ((Object)$classBlocks).hashCode());
        List<ClassExtensionDoc> $classExtensions = this.getClassExtensions();
        result = result * 59 + ($classExtensions == null ? 43 : ((Object)$classExtensions).hashCode());
        List<ClassDoc> $superTypes = this.getSuperTypes();
        result = result * 59 + ($superTypes == null ? 43 : ((Object)$superTypes).hashCode());
        DocComment $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $additionalData = this.getAdditionalData();
        result = result * 59 + ($additionalData == null ? 43 : ((Object)$additionalData).hashCode());
        return result;
    }

    public String toString() {
        return "ClassDoc(className=" + this.getClassName() + ", metaData=" + this.getMetaData() + ", extensionMetaData=" + this.getExtensionMetaData() + ", classProperties=" + this.getClassProperties() + ", classMethods=" + this.getClassMethods() + ", classBlocks=" + this.getClassBlocks() + ", classExtensions=" + this.getClassExtensions() + ", superTypes=" + this.getSuperTypes() + ", comment=" + this.getComment() + ", additionalData=" + this.getAdditionalData() + ")";
    }

    @NonNull
    private String getClassName() {
        return this.className;
    }

    public static class Builder {
        private String className;
        private ClassMetaData metaData;
        private ClassExtensionMetaData extensionMetaData;
        private ArrayList<PropertyDoc> classProperties;
        private ArrayList<MethodDoc> classMethods;
        private ArrayList<BlockDoc> classBlocks;
        private ArrayList<ClassExtensionDoc> classExtensions;
        private ClassDocSuperTypes superTypes;
        private DocComment comment;
        private Map<String, String> additionalData;

        Builder() {
        }

        public Builder withClassName(@NonNull String className) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            this.className = className;
            return this;
        }

        public Builder withMetaData(@NonNull ClassMetaData metaData) {
            if (metaData == null) {
                throw new NullPointerException("metaData is marked non-null but is null");
            }
            this.metaData = metaData;
            return this;
        }

        public Builder withExtensionMetaData(@NonNull ClassExtensionMetaData extensionMetaData) {
            if (extensionMetaData == null) {
                throw new NullPointerException("extensionMetaData is marked non-null but is null");
            }
            this.extensionMetaData = extensionMetaData;
            return this;
        }

        public Builder withClassProperty(PropertyDoc classProperty) {
            if (this.classProperties == null) {
                this.classProperties = new ArrayList();
            }
            this.classProperties.add(classProperty);
            return this;
        }

        public Builder withClassProperties(Collection<? extends PropertyDoc> classProperties) {
            if (classProperties == null) {
                throw new NullPointerException("classProperties cannot be null");
            }
            if (this.classProperties == null) {
                this.classProperties = new ArrayList();
            }
            this.classProperties.addAll(classProperties);
            return this;
        }

        public Builder clearClassProperties() {
            if (this.classProperties != null) {
                this.classProperties.clear();
            }
            return this;
        }

        public Builder withClassMethod(MethodDoc classMethod) {
            if (this.classMethods == null) {
                this.classMethods = new ArrayList();
            }
            this.classMethods.add(classMethod);
            return this;
        }

        public Builder withClassMethods(Collection<? extends MethodDoc> classMethods) {
            if (classMethods == null) {
                throw new NullPointerException("classMethods cannot be null");
            }
            if (this.classMethods == null) {
                this.classMethods = new ArrayList();
            }
            this.classMethods.addAll(classMethods);
            return this;
        }

        public Builder clearClassMethods() {
            if (this.classMethods != null) {
                this.classMethods.clear();
            }
            return this;
        }

        public Builder withClassBlock(BlockDoc classBlock) {
            if (this.classBlocks == null) {
                this.classBlocks = new ArrayList();
            }
            this.classBlocks.add(classBlock);
            return this;
        }

        public Builder withClassBlocks(Collection<? extends BlockDoc> classBlocks) {
            if (classBlocks == null) {
                throw new NullPointerException("classBlocks cannot be null");
            }
            if (this.classBlocks == null) {
                this.classBlocks = new ArrayList();
            }
            this.classBlocks.addAll(classBlocks);
            return this;
        }

        public Builder clearClassBlocks() {
            if (this.classBlocks != null) {
                this.classBlocks.clear();
            }
            return this;
        }

        public Builder withClassExtension(ClassExtensionDoc classExtension) {
            if (this.classExtensions == null) {
                this.classExtensions = new ArrayList();
            }
            this.classExtensions.add(classExtension);
            return this;
        }

        public Builder withClassExtensions(Collection<? extends ClassExtensionDoc> classExtensions) {
            if (classExtensions == null) {
                throw new NullPointerException("classExtensions cannot be null");
            }
            if (this.classExtensions == null) {
                this.classExtensions = new ArrayList();
            }
            this.classExtensions.addAll(classExtensions);
            return this;
        }

        public Builder clearClassExtensions() {
            if (this.classExtensions != null) {
                this.classExtensions.clear();
            }
            return this;
        }

        public Builder withSuperTypes(@NonNull ClassDocSuperTypes superTypes) {
            if (superTypes == null) {
                throw new NullPointerException("superTypes is marked non-null but is null");
            }
            this.superTypes = superTypes;
            return this;
        }

        public Builder withComment(@NonNull DocComment comment) {
            if (comment == null) {
                throw new NullPointerException("comment is marked non-null but is null");
            }
            this.comment = comment;
            return this;
        }

        public Builder withAdditionalData(@NonNull Map<String, String> additionalData) {
            if (additionalData == null) {
                throw new NullPointerException("additionalData is marked non-null but is null");
            }
            this.additionalData = additionalData;
            return this;
        }

        public ClassDoc build() {
            List<ClassExtensionDoc> classExtensions;
            List<BlockDoc> classBlocks;
            List<MethodDoc> classMethods;
            List<PropertyDoc> classProperties;
            switch (this.classProperties == null ? 0 : this.classProperties.size()) {
                case 0: {
                    classProperties = Collections.emptyList();
                    break;
                }
                case 1: {
                    classProperties = Collections.singletonList(this.classProperties.get(0));
                    break;
                }
                default: {
                    classProperties = Collections.unmodifiableList(new ArrayList<PropertyDoc>(this.classProperties));
                }
            }
            switch (this.classMethods == null ? 0 : this.classMethods.size()) {
                case 0: {
                    classMethods = Collections.emptyList();
                    break;
                }
                case 1: {
                    classMethods = Collections.singletonList(this.classMethods.get(0));
                    break;
                }
                default: {
                    classMethods = Collections.unmodifiableList(new ArrayList<MethodDoc>(this.classMethods));
                }
            }
            switch (this.classBlocks == null ? 0 : this.classBlocks.size()) {
                case 0: {
                    classBlocks = Collections.emptyList();
                    break;
                }
                case 1: {
                    classBlocks = Collections.singletonList(this.classBlocks.get(0));
                    break;
                }
                default: {
                    classBlocks = Collections.unmodifiableList(new ArrayList<BlockDoc>(this.classBlocks));
                }
            }
            switch (this.classExtensions == null ? 0 : this.classExtensions.size()) {
                case 0: {
                    classExtensions = Collections.emptyList();
                    break;
                }
                case 1: {
                    classExtensions = Collections.singletonList(this.classExtensions.get(0));
                    break;
                }
                default: {
                    classExtensions = Collections.unmodifiableList(new ArrayList<ClassExtensionDoc>(this.classExtensions));
                }
            }
            return new ClassDoc(this.className, this.metaData, this.extensionMetaData, classProperties, classMethods, classBlocks, classExtensions, this.superTypes, this.comment, this.additionalData);
        }

        public String toString() {
            return "ClassDoc.Builder(className=" + this.className + ", metaData=" + this.metaData + ", extensionMetaData=" + this.extensionMetaData + ", classProperties=" + this.classProperties + ", classMethods=" + this.classMethods + ", classBlocks=" + this.classBlocks + ", classExtensions=" + this.classExtensions + ", superTypes=" + this.superTypes + ", comment=" + this.comment + ", additionalData=" + this.additionalData + ")";
        }
    }
}

