/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.UncheckedException;

class JavadocScanner {
    private final StringBuilder input = new StringBuilder();
    private int pos;
    private int markPos;

    JavadocScanner(String rawCommentText) {
        this.pushText(rawCommentText);
    }

    public String toString() {
        return this.input.substring(this.pos);
    }

    public boolean isEmpty() {
        return this.pos == this.input.length();
    }

    public void mark() {
        this.markPos = this.pos;
    }

    public void next() {
        this.next(1);
    }

    public void next(int n) {
        this.pos += n;
    }

    public boolean lookingAt(char c) {
        return this.input.charAt(this.pos) == c;
    }

    public boolean lookingAt(CharSequence prefix) {
        int i = 0;
        for (int cpos = this.pos; i < prefix.length() && cpos < this.input.length(); ++i, ++cpos) {
            if (prefix.charAt(i) == this.input.charAt(cpos)) continue;
            return false;
        }
        return true;
    }

    public boolean lookingAt(Pattern pattern) {
        Matcher m = pattern.matcher(this.input);
        m.region(this.pos, this.input.length());
        return m.lookingAt();
    }

    public String region() {
        return this.input.substring(this.markPos, this.pos);
    }

    public void find(char c) {
        int cpos;
        for (cpos = this.pos; cpos < this.input.length() && this.input.charAt(cpos) != c; ++cpos) {
        }
        this.pos = cpos;
    }

    public void find(Pattern pattern) {
        Matcher m = pattern.matcher(this.input);
        m.region(this.pos, this.input.length());
        this.pos = m.find() ? m.start() : this.input.length();
    }

    public void skip(Pattern pattern) {
        Matcher m = pattern.matcher(this.input);
        m.region(this.pos, this.input.length());
        if (m.lookingAt()) {
            this.pos = m.end();
        }
    }

    public void pushText(String rawCommentText) {
        if (rawCommentText == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(rawCommentText));
            while ((line = reader.readLine()) != null && !(line = line.replaceFirst("\\s*\\* ?", "")).startsWith("@")) {
                builder.append(line);
                builder.append("\n");
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.input.insert(this.pos, builder.toString().trim());
    }

    public char getFirst() {
        return this.input.charAt(this.pos);
    }
}

