/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.documentationkit.dsl.docbook.ReferencedTypeBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassExtensionMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DslDocModel {
    private final List<File> classDocbookDirs;
    private final Map<String, ClassDoc> classes = new HashMap<String, ClassDoc>();
    private final ClassMetaDataRepository<ClassMetaData> classMetaData;
    private final Map<String, ClassExtensionMetaData> extensionMetaData;
    private final LinkedList<String> currentlyBuilding = new LinkedList();

    public DslDocModel(Set<File> classDocbookDirs, ClassMetaDataRepository<ClassMetaData> classMetaData, Map<String, ClassExtensionMetaData> extensionMetaData) {
        this.classDocbookDirs = ImmutableList.copyOf(classDocbookDirs);
        this.classMetaData = classMetaData;
        this.extensionMetaData = extensionMetaData;
    }

    public Collection<ClassDoc> getClasses() {
        return this.classes.values().stream().filter(it -> !it.getName().contains(".internal.")).collect(Collectors.toList());
    }

    public Set<String> getKeys() {
        return this.classes.keySet();
    }

    public boolean isKnownType(String className) {
        return this.classMetaData.find(className) != null;
    }

    public ClassDoc findClassDoc(String className) {
        ClassDoc classDoc = this.classes.get(className);
        if (classDoc == null && this.getFileForClass(className).isPresent()) {
            return this.getClassDoc(className);
        }
        return classDoc;
    }

    public ClassDoc getClassDoc(String className) {
        ClassDoc classDoc = this.classes.get(className);
        if (classDoc == null) {
            classDoc = this.loadClassDoc(className);
            this.classes.put(className, classDoc);
            new ReferencedTypeBuilder(this).build(classDoc);
        }
        return classDoc;
    }

    /*
     * Exception decompiling
     */
    private ClassDoc loadClassDoc(String className) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<File> getFileForClass(String className) {
        return this.classDocbookDirs.stream().map(classDocbookDir -> new File((File)classDocbookDir, String.format("%s.json", className))).filter(File::isFile).findFirst();
    }

    static final class ClassFile {
        private final String category;
        private final List<String> properties;
        private final List<String> methods;

        static ClassFile parse(File classFile) {
            Map v = (Map)new JsonSlurper().parse(classFile);
            return new ClassFile((String)v.get("category"), (List)v.get("properties"), (List)v.get("methods"));
        }

        public ClassFile(String category, List<String> properties, List<String> methods) {
            this.category = category;
            this.properties = properties;
            this.methods = methods;
        }

        public String getCategory() {
            return this.category;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public List<String> getMethods() {
            return this.methods;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassFile)) {
                return false;
            }
            ClassFile other = (ClassFile)o;
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            List<String> this$properties = this.getProperties();
            List<String> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            List<String> this$methods = this.getMethods();
            List<String> other$methods = other.getMethods();
            return !(this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            List<String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            List<String> $methods = this.getMethods();
            result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
            return result;
        }

        public String toString() {
            return "DslDocModel.ClassFile(category=" + this.getCategory() + ", properties=" + this.getProperties() + ", methods=" + this.getMethods() + ")";
        }

        static /* synthetic */ String access$000(ClassFile x0) {
            return x0.category;
        }
    }
}

