/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.documentationkit.dsl.docbook.DocComment;
import dev.gradleplugins.documentationkit.dsl.docbook.DslDocModel;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocConverter;
import dev.gradleplugins.documentationkit.dsl.docbook.model.BlockDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDocSuperTypes;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ExtraAttributeDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.MethodDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.PropertyDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import groovy.lang.Closure;
import java.util.HashSet;
import java.util.List;

public class ClassDocMethodsBuilder {
    private final JavadocConverter javadocConverter;
    private final GenerationListener listener;
    private final DslDocModel.ClassFile classFile;
    private final ClassMetaData classMetaData;
    private final DslDocModel model;

    public void build(ClassDoc.Builder builder) {
        HashSet<String> signatures = new HashSet<String>();
        for (String methodName : this.classFile.getMethods()) {
            List<MethodMetaData> methods = this.classMetaData.findDeclaredMethods(methodName);
            if (methods.isEmpty()) {
                throw new RuntimeException(String.format("No metadata for method '%s.%s()'. Available methods: %s", this.classMetaData.getClassName(), methodName, this.classMetaData.getDeclaredMethodNames()));
            }
            for (MethodMetaData methodMetaData : methods) {
                DocComment docComment;
                MethodDoc methodDoc = new MethodDoc(this.classMetaData, methodMetaData, docComment = this.javadocConverter.parse(methodMetaData, this.listener));
                if (methodDoc.getDescription() == null && methodDoc.getMetaData().getParameters().stream().noneMatch(it -> it.getType().equals(new TypeMetaData("groovy.lang.Closure")))) {
                    throw new RuntimeException(String.format("Docbook content for '%s %s' does not contain a description paragraph.", this.classMetaData.getClassName(), methodMetaData.getSignature()));
                }
                PropertyMetaData property = this.classMetaData.findProperty(methodName);
                boolean multiValued = false;
                if (property != null && methodMetaData.getParameters().size() == 1 && methodMetaData.getParameters().get(0).getType().getSignature().equals(Closure.class.getName())) {
                    TypeMetaData type = property.getType();
                    if (type.getName().equals("java.util.List") || type.getName().equals("java.util.Collection") || type.getName().equals("java.util.Set") || type.getName().equals("java.util.Iterable")) {
                        type = type.getTypeArgs().get(0);
                        multiValued = true;
                    }
                    builder.withClassBlock(new BlockDoc(methodDoc, new PropertyDoc(this.classMetaData, property, this.javadocConverter.parse(property, this.listener), (List<ExtraAttributeDoc>)ImmutableList.of()), type, multiValued));
                    continue;
                }
                builder.withClassMethod(methodDoc);
                signatures.add(methodMetaData.getOverrideSignature());
            }
        }
        List<ClassDoc> superTypes = ClassDocSuperTypes.of(this.classMetaData, this.model).getSuperTypes();
        for (ClassDoc supertype : superTypes) {
            for (MethodDoc methodDoc : supertype.getClassMethods()) {
                if (!signatures.add(methodDoc.getMetaData().getOverrideSignature())) continue;
                builder.withClassMethod(methodDoc);
            }
        }
    }

    public ClassDocMethodsBuilder(JavadocConverter javadocConverter, GenerationListener listener, DslDocModel.ClassFile classFile, ClassMetaData classMetaData, DslDocModel model) {
        this.javadocConverter = javadocConverter;
        this.listener = listener;
        this.classFile = classFile;
        this.classMetaData = classMetaData;
        this.model = model;
    }
}

