/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.JavadocLexer;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocScanner;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

class BasicJavadocLexer
implements JavadocLexer {
    private static final Pattern HTML_ELEMENT = Pattern.compile("(?s)<\\\\?[^<]+?>");
    private static final Pattern ELEMENT_ATTRIBUTE = Pattern.compile("(?s)\\w+(\\s*=\\s*('.*?')|(\".*?\"))?");
    private static final Pattern END_ATTRIBUTE_NAME = Pattern.compile("=|(\\s)|(/>)|>");
    private static final Pattern ATTRIBUTE_SEPARATOR = Pattern.compile("\\s*=\\s*");
    private static final Pattern END_ELEMENT_NAME = Pattern.compile("\\s+|(/>)|>");
    private static final Pattern END_ELEMENT = Pattern.compile("(/>)|>");
    private static final Pattern HTML_ENCODED_CHAR = Pattern.compile("&#\\d+;");
    private static final Pattern HTML_ENTITY = Pattern.compile("&.+?;");
    private static final Pattern TAG = Pattern.compile("(?s)\\{@.+?\\}");
    private static final Pattern END_TAG_NAME = Pattern.compile("(?s)\\s|}");
    private static final Pattern WHITESPACE_WITH_EOL = Pattern.compile("(?s)\\s+");
    private static final String START_HTML_COMMENT = "<!--";
    private static final String END_HTML_COMMENT = "-->";
    private static final Map<String, String> ENTITIES = new HashMap<String, String>();
    private final JavadocScanner scanner;

    BasicJavadocLexer(JavadocScanner scanner) {
        this.scanner = scanner;
    }

    public void pushText(String rawCommentText) {
        this.scanner.pushText(rawCommentText);
    }

    @Override
    public void visit(JavadocLexer.TokenVisitor visitor) {
        while (!this.scanner.isEmpty()) {
            if (this.scanner.lookingAt(START_HTML_COMMENT)) {
                this.skipComment();
                continue;
            }
            if (this.scanner.lookingAt(HTML_ELEMENT)) {
                this.parseStartElement(visitor);
                continue;
            }
            if (this.scanner.lookingAt(TAG)) {
                this.parseJavadocTag(visitor);
                continue;
            }
            StringBuilder text = new StringBuilder();
            while (!this.scanner.isEmpty()) {
                if (this.scanner.lookingAt(START_HTML_COMMENT)) {
                    this.skipComment();
                    continue;
                }
                if (this.scanner.lookingAt(HTML_ELEMENT) || this.scanner.lookingAt(TAG)) break;
                if (this.scanner.lookingAt(HTML_ENCODED_CHAR)) {
                    this.parseHtmlEncodedChar(text);
                    continue;
                }
                if (this.scanner.lookingAt(HTML_ENTITY)) {
                    this.parseHtmlEntity(text);
                    continue;
                }
                text.append(this.scanner.getFirst());
                this.scanner.next();
            }
            visitor.onText(text.toString());
        }
        visitor.onEnd();
    }

    private void skipComment() {
        this.scanner.next(4);
        while (!this.scanner.isEmpty() && !this.scanner.lookingAt(END_HTML_COMMENT)) {
            this.scanner.next();
        }
        if (!this.scanner.isEmpty()) {
            this.scanner.next(3);
        }
    }

    private void parseHtmlEntity(StringBuilder buffer) {
        this.scanner.next();
        this.scanner.mark();
        this.scanner.find(';');
        String value = ENTITIES.get(this.scanner.region().toLowerCase());
        buffer.append(value);
        this.scanner.next();
    }

    private void parseHtmlEncodedChar(StringBuilder buffer) {
        this.scanner.next(2);
        this.scanner.mark();
        this.scanner.find(';');
        String value = new String(new char[]{(char)Integer.parseInt(this.scanner.region())});
        buffer.append(value);
        this.scanner.next();
    }

    private void parseJavadocTag(JavadocLexer.TokenVisitor visitor) {
        this.scanner.next(2);
        this.scanner.mark();
        this.scanner.find(END_TAG_NAME);
        String tagName = this.scanner.region();
        visitor.onStartJavadocTag(tagName);
        this.scanner.skip(WHITESPACE_WITH_EOL);
        if (!this.scanner.lookingAt('}')) {
            this.scanner.mark();
            this.scanner.find('}');
            String value = this.scanner.region();
            visitor.onText(value);
        }
        if (this.scanner.lookingAt('}')) {
            visitor.onEndJavadocTag(tagName);
            this.scanner.next();
        }
    }

    private void parseStartElement(JavadocLexer.TokenVisitor visitor) {
        this.scanner.next();
        boolean isEnd = false;
        if (this.scanner.lookingAt('/')) {
            isEnd = true;
            this.scanner.next();
        }
        this.scanner.skip(WHITESPACE_WITH_EOL);
        this.scanner.mark();
        this.scanner.find(END_ELEMENT_NAME);
        String elementName = this.scanner.region().toLowerCase();
        if (isEnd) {
            visitor.onEndHtmlElement(elementName);
        } else {
            visitor.onStartHtmlElement(elementName);
        }
        this.scanner.skip(WHITESPACE_WITH_EOL);
        while (!this.scanner.isEmpty() && this.scanner.lookingAt(ELEMENT_ATTRIBUTE)) {
            this.scanner.mark();
            this.scanner.find(END_ATTRIBUTE_NAME);
            String attrName = this.scanner.region();
            this.scanner.skip(ATTRIBUTE_SEPARATOR);
            char quote = this.scanner.getFirst();
            this.scanner.next();
            StringBuilder attrValue = new StringBuilder();
            while (!this.scanner.isEmpty() && !this.scanner.lookingAt(quote)) {
                if (this.scanner.lookingAt(HTML_ENCODED_CHAR)) {
                    this.parseHtmlEncodedChar(attrValue);
                    continue;
                }
                if (this.scanner.lookingAt(HTML_ENTITY)) {
                    this.parseHtmlEntity(attrValue);
                    continue;
                }
                attrValue.append(this.scanner.getFirst());
                this.scanner.next();
            }
            visitor.onHtmlElementAttribute(attrName, attrValue.toString());
            this.scanner.next();
            this.scanner.skip(WHITESPACE_WITH_EOL);
        }
        if (!isEnd) {
            visitor.onStartHtmlElementComplete(elementName);
        }
        if (this.scanner.lookingAt('/')) {
            visitor.onEndHtmlElement(elementName);
        }
        this.scanner.skip(END_ELEMENT);
    }

    static {
        ENTITIES.put("amp", "&");
        ENTITIES.put("lt", "<");
        ENTITIES.put("gt", ">");
        ENTITIES.put("quot", "\"");
        ENTITIES.put("apos", "'");
    }
}

