/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.DocComment;
import dev.gradleplugins.documentationkit.dsl.docbook.DocLink;
import dev.gradleplugins.documentationkit.dsl.docbook.Renderable;
import dev.gradleplugins.documentationkit.dsl.docbook.Renderer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AsciidoctorRenderer
implements Renderer<String> {
    private int literalCount = 0;

    public String render(List<Element> elements) {
        return elements.stream().map(this::render).collect(Collectors.joining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String render(Node e) {
        switch (e.getNodeName()) {
            case "para": {
                return this.render(e.getChildNodes()) + "\n\n";
            }
            case "ulink": {
                String url = e.getAttributes().getNamedItem("url").getTextContent();
                return "link:" + url + "[" + this.render(e.getChildNodes()) + "]";
            }
            case "apilink": {
                String className = e.getAttributes().getNamedItem("class").getTextContent();
                Node methodNode = e.getAttributes().getNamedItem("method");
                if (methodNode == null) {
                    return String.format("link:../javadoc/%s.html[%s]", className.replace('.', '/'), StringUtils.substringAfterLast((String)className, (String)"."));
                }
                return String.format("link:../javadoc/%s.html#%s[%s]", className.replace('.', '/'), methodNode.getTextContent().replace('(', '-').replace(')', '-'), StringUtils.substringAfterLast((String)className, (String)"."));
            }
            case "programlisting": {
                return String.format("[.listing]\n----\n%s\n----\n", this.render(e.getChildNodes()));
            }
            case "#text": {
                return e.getTextContent();
            }
            case "literal": {
                ++this.literalCount;
                try {
                    if (this.literalCount == 1) {
                        String string = "`" + this.render(e.getChildNodes()) + "`";
                        return string;
                    }
                    String string = this.render(e.getChildNodes());
                    return string;
                }
                finally {
                    --this.literalCount;
                }
            }
            case "emphasis": {
                return "*" + this.render(e.getChildNodes()) + "*";
            }
            case "blockquote": {
                return Arrays.stream(StringUtils.stripStart((String)this.render(e.getChildNodes()), null).split("\n", -1)).map(it -> "> " + it).collect(Collectors.joining("\n")) + "\n\n";
            }
        }
        return this.render(e.getChildNodes());
    }

    private String render(NodeList list) {
        return IntStream.range(0, list.getLength()).mapToObj(list::item).map(this::render).collect(Collectors.joining());
    }

    @Override
    public String render(Renderable obj) {
        if (this.literalCount != 0) {
            System.out.println(String.format("Literal count not zero! (%d)", this.literalCount));
            this.literalCount = 0;
        }
        if (obj instanceof DocComment) {
            return this.render(((DocComment)obj).getDocbook());
        }
        if (obj instanceof DocLink) {
            return this.render(((DocLink)obj).getDocbook());
        }
        throw new IllegalArgumentException("unknown renderable type");
    }
}

