/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.internal;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.gradleplugins.documentationkit.ApiReferenceDocumentation;
import dev.gradleplugins.documentationkit.DependenciesLoader;
import dev.gradleplugins.documentationkit.JavadocApiReference;
import dev.gradleplugins.documentationkit.JavadocApiReferenceNodeRegistrationFactory;
import dev.gradleplugins.documentationkit.TaskNamingScheme;
import dev.gradleplugins.documentationkit.TaskRegistry;
import dev.nokee.language.base.LanguageSourceSet;
import dev.nokee.model.DomainObjectProvider;
import dev.nokee.model.KnownDomainObject;
import dev.nokee.model.internal.core.ModelAction;
import dev.nokee.model.internal.core.ModelActions;
import dev.nokee.model.internal.core.ModelNode;
import dev.nokee.model.internal.core.ModelNodes;
import dev.nokee.model.internal.core.ModelPath;
import dev.nokee.model.internal.core.NodeAction;
import dev.nokee.model.internal.core.NodePredicate;
import dev.nokee.model.internal.registry.ModelLookup;
import dev.nokee.model.internal.type.ModelType;
import dev.nokee.platform.base.ComponentContainer;
import dev.nokee.platform.base.internal.tasks.TaskName;
import dev.nokee.utils.TransformerUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RelativePath;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class JavadocRenderPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().withPlugin("dev.gradleplugins.documentation.api-reference", appliedPlugin -> {
            ComponentContainer components = (ComponentContainer)project.getExtensions().getByType(ComponentContainer.class);
            ConfigurationContainer configurations = project.getConfigurations();
            ModelLookup lookup = (ModelLookup)project.getExtensions().getByType(ModelLookup.class);
            ModelNode apiReference = lookup.get(ModelPath.path((String)"components.apiReference"));
            TaskRegistry taskRegistry = new TaskRegistry(project.getTasks(), TaskNamingScheme.forComponent("apiReference"));
            JavadocApiReferenceNodeRegistrationFactory javadocFactory = new JavadocApiReferenceNodeRegistrationFactory(project.getObjects());
            DomainObjectProvider javadocArtifact = apiReference.register(javadocFactory.create("javadoc"));
            ModelNodes.of((Object)javadocArtifact).applyTo(JavadocRenderPlugin.onJavadocArtifactDiscovered(taskRegistry, project.getLayout(), project.getObjects()));
            components.configure("apiReference", ApiReferenceDocumentation.class, component -> javadocArtifact.configure(javadoc -> {
                javadoc.getSources().from(new Object[]{JavadocRenderPlugin.thisManifestArtifact(component)});
                javadoc.getSources().from(new Object[]{JavadocRenderPlugin.sourcesOfOtherManifestArtifact(component)});
                javadoc.getClasspath().from(new Object[]{JavadocRenderPlugin.classpathOfOtherManifestArtifact(component, DependenciesLoader.forProject(project))});
                javadoc.getClasspath().from(new Object[]{JavadocRenderPlugin.compileClasspathIfAvailable(configurations)});
                javadoc.getPermalink().set((Object)"javadoc");
                javadoc.getLinks().add(project.getProviders().gradleProperty("minimumJavaVersion").orElse((Object)"8").map(version -> project.uri((Object)("https://docs.oracle.com/javase/" + version + "/docs/api"))));
                javadoc.getLinks().addAll(project.getProviders().gradleProperty("minimumGradleVersion").map(version -> ImmutableList.of((Object)project.uri((Object)("https://docs.gradle.org/" + version + "/javadoc/")))).orElse((Object)ImmutableList.of()));
            }));
        });
    }

    private static Object thisManifestArtifact(ApiReferenceDocumentation component) {
        return component.getManifest().getDestinationLocation().dir("sources");
    }

    private static Object sourcesOfOtherManifestArtifact(ApiReferenceDocumentation component) {
        return ((ApiReferenceDocumentation.Dependencies)component.getDependencies()).getManifest().getAsLenientFileCollection().getElements().map((Transformer)TransformerUtils.transformEach(it -> new File(it.getAsFile(), "sources")));
    }

    private static Callable<Object> classpathOfOtherManifestArtifact(ApiReferenceDocumentation component, DependenciesLoader dependencyLoader) {
        return JavadocRenderPlugin.memoizeCallable(() -> ((ApiReferenceDocumentation.Dependencies)component.getDependencies()).getManifest().getAsLenientFileCollection().getElements().map((Transformer)TransformerUtils.transformEach(it -> new File(it.getAsFile(), "dependencies.manifest"))).map((Transformer)TransformerUtils.transformEach(dependencyLoader::load)));
    }

    private static <T> Callable<T> memoizeCallable(final Callable<T> callable) {
        return () -> ((com.google.common.base.Supplier)Suppliers.memoize((com.google.common.base.Supplier)new com.google.common.base.Supplier<T>(){

            public T get() {
                return callable.call();
            }
        })).get();
    }

    private static Callable<Object> compileClasspathIfAvailable(ConfigurationContainer configurations) {
        return () -> {
            Configuration compileClasspath = (Configuration)configurations.findByName("compileClasspath");
            if (compileClasspath == null) {
                return ImmutableList.of();
            }
            return compileClasspath;
        };
    }

    private static NodeAction onJavadocArtifactDiscovered(TaskRegistry taskRegistry, final ProjectLayout projectLayout, final ObjectFactory objects) {
        return NodePredicate.self((ModelAction)ModelActions.discover(context -> {
            final KnownDomainObject artifact = context.projectionOf(ModelType.of(JavadocApiReference.class));
            TaskProvider<Javadoc> javadocTask = taskRegistry.register(TaskName.of((String)"generate", (String)"javadoc"), Javadoc.class, new Consumer<Javadoc>(){

                @Override
                public void accept(Javadoc task) {
                    Provider temporaryDirectory = projectLayout.getBuildDirectory().dir("tmp/" + task.getName());
                    Provider sources = artifact.flatMap(it -> it.getSources().getAsFileTree().getElements());
                    task.getInputs().files(new Object[]{sources});
                    task.source(new Object[]{sources.map(JavadocRenderPlugin.ifNonEmpty((Transformer)TransformerUtils.forSupplier(this.fromDummyFileToAvoidNoSourceTaskOutcomeBecauseUsingSourcepathJavadocOption((Directory)temporaryDirectory.get()))))});
                    task.setDestinationDir(((Directory)temporaryDirectory.get()).dir("docs").getAsFile());
                    task.setClasspath((FileCollection)objects.fileCollection().from(new Object[]{this.classpathFromArtifact()}));
                    StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)task.getOptions();
                    options.setEncoding("utf-8");
                    options.setDocEncoding("utf-8");
                    options.setCharSet("utf-8");
                    ListProperty args = objects.listProperty(String.class);
                    args.addAll(this.linksFromArtifact().map((Transformer)TransformerUtils.flatTransformEach(it -> ImmutableList.of((Object)"-link", (Object)it))));
                    args.addAll(this.sourcePathsFromArtifactSources().map(JavadocRenderPlugin.ifNonEmpty(it -> ImmutableList.of((Object)"-sourcepath", (Object)String.join((CharSequence)File.pathSeparator, it)))));
                    args.addAll(this.guessSubPackages().map(JavadocRenderPlugin.ifNonEmpty(it -> ImmutableList.of((Object)"-subpackages", (Object)String.join((CharSequence)File.pathSeparator, it)))));
                    args.addAll(this.excludesInternalPackages().map(JavadocRenderPlugin.ifNonEmpty(it -> ImmutableList.of((Object)"-exclude", (Object)String.join((CharSequence)File.pathSeparator, it)))));
                    args.addAll(artifact.flatMap(JavadocApiReference::getTitle).map(it -> ImmutableList.of((Object)"-doctitle", (Object)JavadocRenderPlugin.quote(it), (Object)"-windowtitle", (Object)JavadocRenderPlugin.quote(it))).orElse((Object)ImmutableList.of()));
                    task.getInputs().property("additionalArgs", (Object)args);
                    task.doFirst(t -> {
                        try {
                            FileUtils.write((File)((Directory)temporaryDirectory.get()).file("additionalArgs.options").getAsFile(), (CharSequence)String.join((CharSequence)System.lineSeparator(), (Iterable)args.get()), (Charset)StandardCharsets.UTF_8);
                            options.optionFiles(new File[]{((Directory)temporaryDirectory.get()).file("additionalArgs.options").getAsFile()});
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }

                private Supplier<Iterable<File>> fromDummyFileToAvoidNoSourceTaskOutcomeBecauseUsingSourcepathJavadocOption(final Directory temporaryDirectory) {
                    return new Supplier<Iterable<File>>(){

                        @Override
                        public Iterable<File> get() {
                            File result = temporaryDirectory.file("Foo.java").getAsFile();
                            FileUtils.write((File)result, (CharSequence)"package internal;\n class Foo {}\n", (Charset)StandardCharsets.UTF_8);
                            return ImmutableList.of((Object)result);
                        }
                    };
                }

                private Provider<List<String>> linksFromArtifact() {
                    return artifact.flatMap(JavadocApiReference::getLinks).map((Transformer)TransformerUtils.transformEach(URI::toString).andThen((Transformer)TransformerUtils.toListTransformer()));
                }

                private Provider<Set<FileSystemLocation>> classpathFromArtifact() {
                    return artifact.flatMap(JavadocRenderPlugin.elementsOf(JavadocApiReference::getClasspath));
                }

                private Provider<List<String>> sourcePathsFromArtifactSources() {
                    return artifact.map(JavadocApiReference::getSources).flatMap(JavadocRenderPlugin.elementsOf(LanguageSourceSet::getSourceDirectories)).map((Transformer)TransformerUtils.transformEach((Transformer)JavadocRenderPlugin.asFile(File::getAbsolutePath)).andThen((Transformer)TransformerUtils.toListTransformer()));
                }

                private Provider<List<String>> guessSubPackages() {
                    return artifact.map(JavadocApiReference::getSources).map(LanguageSourceSet::getAsFileTree).map(files -> {
                        GuessSubPackageVisitor visitor = new GuessSubPackageVisitor();
                        files.visit((FileVisitor)visitor);
                        return ImmutableList.copyOf((Collection)visitor.result);
                    });
                }

                private Provider<List<String>> excludesInternalPackages() {
                    return artifact.map(JavadocApiReference::getSources).map(LanguageSourceSet::getAsFileTree).map(files -> {
                        ExcludesInternalPackages visitor = new ExcludesInternalPackages();
                        files.visit((FileVisitor)visitor);
                        return visitor.packageToExcludes;
                    });
                }
            });
            TaskProvider<Sync> syncTask = taskRegistry.register(TaskName.of((String)"assemble", (String)"javadoc"), Sync.class, task -> {
                task.from((Object)javadocTask.map(Javadoc::getDestinationDir), spec -> spec.into((Object)artifact.flatMap(JavadocApiReference::getPermalink)));
                task.setDestinationDir(((Directory)projectLayout.getBuildDirectory().dir("tmp/" + task.getName()).get()).getAsFile());
            });
            artifact.configure(it -> it.getDestinationDirectory().fileProvider(syncTask.map(Sync::getDestinationDir)).disallowChanges());
            TaskProvider<Task> assembleTask = taskRegistry.register("assemble", Task.class, task -> {
                task.dependsOn(new Object[]{syncTask});
                task.setGroup("documentation");
            });
        }));
    }

    private static String quote(String valueToQuote) {
        return "\"" + valueToQuote + "\"";
    }

    private static <OUT, IN extends FileSystemLocation> Transformer<OUT, IN> asFile(final Function<File, ? extends OUT> mapper) {
        return new Transformer<OUT, IN>(){

            public OUT transform(IN in) {
                return mapper.apply(in.getAsFile());
            }
        };
    }

    private static <IN> Transformer<Provider<Set<FileSystemLocation>>, IN> elementsOf(final Function<IN, ? extends FileCollection> mapper) {
        return new Transformer<Provider<Set<FileSystemLocation>>, IN>(){

            public Provider<Set<FileSystemLocation>> transform(IN in) {
                return ((FileCollection)mapper.apply(in)).getElements();
            }
        };
    }

    private static <OUT, IN extends Iterable<T>, T> Transformer<Iterable<OUT>, IN> ifNonEmpty(final Transformer<? extends Iterable<OUT>, ? super IN> mapper) {
        return new Transformer<Iterable<OUT>, IN>(){

            public Iterable<OUT> transform(IN ts) {
                if (Iterables.isEmpty(ts)) {
                    return ImmutableList.of();
                }
                return (Iterable)mapper.transform(ts);
            }
        };
    }

    private static final class ExcludesInternalPackages
    implements FileVisitor {
        private final List<String> packageToExcludes = new ArrayList<String>();

        private ExcludesInternalPackages() {
        }

        public void visitDir(FileVisitDetails details) {
            if (details.getName().equals("internal")) {
                this.packageToExcludes.add(this.toPackage(details.getRelativePath()));
            }
        }

        private String toPackage(RelativePath path) {
            return String.join((CharSequence)".", path.getSegments());
        }

        public void visitFile(FileVisitDetails details) {
        }
    }

    private static final class GuessSubPackageVisitor
    implements FileVisitor {
        private final List<String> result = new ArrayList<String>();

        private GuessSubPackageVisitor() {
        }

        public void visitDir(FileVisitDetails details) {
            this.result.add(details.getRelativePath().getSegments()[0]);
            details.stopVisiting();
        }

        public void visitFile(FileVisitDetails details) {
        }
    }
}

