/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source.model;

import dev.gradleplugins.documentationkit.dsl.source.model.TypeContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Action;

public class TypeMetaData
implements Serializable,
TypeContainer {
    public static final TypeMetaData VOID = new TypeMetaData("void");
    public static final TypeMetaData OBJECT = new TypeMetaData("java.lang.Object");
    private String name;
    private int arrayDimensions;
    private boolean varargs;
    private List<TypeMetaData> typeArgs;
    private boolean wildcard;
    private TypeMetaData upperBounds;
    private TypeMetaData lowerBounds;

    public TypeMetaData(String name) {
        this.name = name;
    }

    public TypeMetaData() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions + (this.varargs ? 1 : 0);
    }

    public TypeMetaData setArrayDimensions(int arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
        return this;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public TypeMetaData setVarargs() {
        this.varargs = true;
        return this;
    }

    public List<TypeMetaData> getTypeArgs() {
        return this.typeArgs;
    }

    public TypeMetaData getRawType() {
        if (this.wildcard || this.lowerBounds != null) {
            return OBJECT;
        }
        if (this.upperBounds != null) {
            return this.upperBounds.getRawType();
        }
        TypeMetaData rawType = new TypeMetaData(this.name);
        rawType.arrayDimensions = this.arrayDimensions;
        if (this.varargs) {
            ++rawType.arrayDimensions;
        }
        return rawType;
    }

    public String getSignature() {
        final StringBuilder builder = new StringBuilder();
        this.visitSignature(new SignatureVisitor(){

            @Override
            public void visitText(String text) {
                builder.append(text);
            }

            @Override
            public void visitType(String name) {
                builder.append(name);
            }
        });
        return builder.toString();
    }

    public String getArraySuffix() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.arrayDimensions; ++i) {
            builder.append("[]");
        }
        if (this.varargs) {
            builder.append("...");
        }
        return builder.toString();
    }

    public TypeMetaData addTypeArg(TypeMetaData typeArg) {
        if (this.typeArgs == null) {
            this.typeArgs = new ArrayList<TypeMetaData>();
        }
        this.typeArgs.add(typeArg);
        return this;
    }

    @Override
    public void visitTypes(Action<TypeMetaData> action) {
        if (this.wildcard) {
            return;
        }
        if (this.upperBounds != null) {
            this.upperBounds.visitTypes(action);
            return;
        }
        if (this.lowerBounds != null) {
            this.lowerBounds.visitTypes(action);
            return;
        }
        action.execute((Object)this);
        if (this.typeArgs != null) {
            for (TypeMetaData typeArg : this.typeArgs) {
                typeArg.visitTypes(action);
            }
        }
    }

    public void visitSignature(SignatureVisitor visitor) {
        if (this.wildcard) {
            visitor.visitText("?");
        } else if (this.upperBounds != null) {
            visitor.visitText("? extends ");
            this.upperBounds.visitSignature(visitor);
        } else if (this.lowerBounds != null) {
            visitor.visitText("? super ");
            this.lowerBounds.visitSignature(visitor);
        } else {
            String suffix;
            visitor.visitType(this.name);
            if (this.typeArgs != null) {
                visitor.visitText("<");
                for (int i = 0; i < this.typeArgs.size(); ++i) {
                    if (i > 0) {
                        visitor.visitText(", ");
                    }
                    TypeMetaData typeArg = this.typeArgs.get(i);
                    typeArg.visitSignature(visitor);
                }
                visitor.visitText(">");
            }
            if ((suffix = this.getArraySuffix()).length() > 0) {
                visitor.visitText(suffix);
            }
        }
    }

    public TypeMetaData setWildcard() {
        this.wildcard = true;
        return this;
    }

    public TypeMetaData setUpperBounds(TypeMetaData upperBounds) {
        this.upperBounds = upperBounds;
        return this;
    }

    public TypeMetaData setLowerBounds(TypeMetaData lowerBounds) {
        this.lowerBounds = lowerBounds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMetaData that = (TypeMetaData)o;
        return this.arrayDimensions == that.arrayDimensions && this.varargs == that.varargs && this.wildcard == that.wildcard && Objects.equals(this.name, that.name) && Objects.equals(this.typeArgs, that.typeArgs) && Objects.equals(this.upperBounds, that.upperBounds) && Objects.equals(this.lowerBounds, that.lowerBounds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arrayDimensions, this.varargs, this.typeArgs, this.wildcard, this.upperBounds, this.lowerBounds);
    }

    public String toString() {
        return "TypeMetaData(name=" + this.getName() + ", arrayDimensions=" + this.getArrayDimensions() + ", varargs=" + this.isVarargs() + ", typeArgs=" + this.getTypeArgs() + ", wildcard=" + this.wildcard + ", upperBounds=" + this.upperBounds + ", lowerBounds=" + this.lowerBounds + ")";
    }

    public static interface SignatureVisitor {
        public void visitText(String var1);

        public void visitType(String var1);
    }
}

