/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source.model;

import dev.gradleplugins.documentationkit.dsl.source.model.LanguageElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Transformer;

public abstract class AbstractLanguageElement
implements LanguageElement,
Serializable {
    private String rawCommentText;
    private final List<String> annotationNames = new ArrayList<String>();
    private String replacement;

    protected AbstractLanguageElement() {
    }

    protected AbstractLanguageElement(String rawCommentText) {
        this.rawCommentText = rawCommentText;
    }

    @Override
    public String getRawCommentText() {
        return this.rawCommentText;
    }

    public void setRawCommentText(String rawCommentText) {
        this.rawCommentText = rawCommentText;
    }

    @Override
    public List<String> getAnnotationTypeNames() {
        return this.annotationNames;
    }

    public void addAnnotationTypeName(String annotationType) {
        this.annotationNames.add(annotationType);
    }

    @Override
    public boolean isDeprecated() {
        return this.annotationNames.contains(Deprecated.class.getName());
    }

    @Override
    public boolean isIncubating() {
        return this.annotationNames.contains("org.gradle.api.Incubating");
    }

    public boolean isReplaced() {
        return this.annotationNames.contains("org.gradle.api.model.ReplacedBy");
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public void resolveTypes(Transformer<String, String> transformer) {
        for (int i = 0; i < this.annotationNames.size(); ++i) {
            this.annotationNames.set(i, (String)transformer.transform((Object)this.annotationNames.get(i)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLanguageElement that = (AbstractLanguageElement)o;
        return Objects.equals(this.rawCommentText, that.rawCommentText) && Objects.equals(this.annotationNames, that.annotationNames);
    }

    public int hashCode() {
        return Objects.hash(this.rawCommentText, this.annotationNames);
    }
}

