/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source;

import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;

public class TypeNameResolver {
    private final Set<String> primitiveTypes = new HashSet<String>();
    private final List<String> groovyImplicitImportPackages = new ArrayList<String>();
    private final List<String> groovyImplicitTypes = new ArrayList<String>();
    private final ClassMetaDataRepository<ClassMetaData> metaDataRepository;

    public TypeNameResolver(ClassMetaDataRepository<ClassMetaData> metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
        this.primitiveTypes.add("boolean");
        this.primitiveTypes.add("byte");
        this.primitiveTypes.add("char");
        this.primitiveTypes.add("short");
        this.primitiveTypes.add("int");
        this.primitiveTypes.add("long");
        this.primitiveTypes.add("float");
        this.primitiveTypes.add("double");
        this.primitiveTypes.add("void");
        this.groovyImplicitImportPackages.add("java.util.");
        this.groovyImplicitImportPackages.add("java.io.");
        this.groovyImplicitImportPackages.add("java.net.");
        this.groovyImplicitImportPackages.add("groovy.lang.");
        this.groovyImplicitImportPackages.add("groovy.util.");
        this.groovyImplicitTypes.add("java.math.BigDecimal");
        this.groovyImplicitTypes.add("java.math.BigInteger");
        try {
            this.getClass().getClassLoader().loadClass("groovy.lang.Closure");
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void resolve(TypeMetaData type, final ClassMetaData classMetaData) {
        type.visitTypes(new Action<TypeMetaData>(){

            public void execute(TypeMetaData t) {
                t.setName(TypeNameResolver.this.resolve(t.getName(), classMetaData));
            }
        });
    }

    public String resolve(String name, ClassMetaData classMetaData) {
        String candidateClassName;
        if (this.primitiveTypes.contains(name)) {
            return name;
        }
        String[] innerNames = name.split("\\.");
        ClassMetaData pos = classMetaData;
        for (int i = 0; i < innerNames.length; ++i) {
            String innerName = innerNames[i];
            candidateClassName = pos.getClassName() + '.' + innerName;
            if (!pos.getInnerClassNames().contains(candidateClassName)) break;
            if (i == innerNames.length - 1) {
                return candidateClassName;
            }
            pos = this.metaDataRepository.get(candidateClassName);
        }
        String outerClassName = classMetaData.getOuterClassName();
        while (outerClassName != null) {
            if (name.equals(StringUtils.substringAfterLast((String)outerClassName, (String)"."))) {
                return outerClassName;
            }
            ClassMetaData outerClass = this.metaDataRepository.get(outerClassName);
            candidateClassName = outerClassName + '.' + name;
            if (outerClass.getInnerClassNames().contains(candidateClassName)) {
                return candidateClassName;
            }
            outerClassName = outerClass.getOuterClassName();
        }
        if (name.contains(".")) {
            return name;
        }
        for (String importedClass : classMetaData.getImports()) {
            String baseName = StringUtils.substringAfterLast((String)importedClass, (String)".");
            if (baseName.equals("*")) {
                candidateClassName = StringUtils.substringBeforeLast((String)importedClass, (String)".") + "." + name;
                if (this.metaDataRepository.find(candidateClassName) != null) {
                    return candidateClassName;
                }
                if (!importedClass.startsWith("java.") || !this.isVisibleSystemClass(candidateClassName)) continue;
                return candidateClassName;
            }
            if (!name.equals(baseName)) continue;
            return importedClass;
        }
        candidateClassName = classMetaData.getPackageName() + "." + name;
        if (this.metaDataRepository.find(candidateClassName) != null) {
            return candidateClassName;
        }
        candidateClassName = "java.lang." + name;
        if (this.isVisibleSystemClass(candidateClassName)) {
            return candidateClassName;
        }
        if (classMetaData.isGroovy()) {
            candidateClassName = "java.math." + name;
            if (this.groovyImplicitTypes.contains(candidateClassName)) {
                return candidateClassName;
            }
            for (String prefix : this.groovyImplicitImportPackages) {
                candidateClassName = prefix + name;
                if (!this.isVisibleSystemClass(candidateClassName)) continue;
                return candidateClassName;
            }
        }
        return name;
    }

    private boolean isVisibleSystemClass(String candidateClassName) {
        try {
            this.getClass().getClassLoader().loadClass(candidateClassName);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

