/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithExtends;
import com.github.javaparser.ast.nodeTypes.NodeWithImplements;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import dev.gradleplugins.documentationkit.dsl.source.model.AbstractLanguageElement;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceMetaDataVisitor
extends VoidVisitorAdapter<ClassMetaDataRepository<ClassMetaData>> {
    private static final Pattern GETTER_METHOD_NAME = Pattern.compile("(get|is)(.+)");
    private static final Pattern SETTER_METHOD_NAME = Pattern.compile("set(.+)");
    private final List<ClassMetaData> allClasses = new ArrayList<ClassMetaData>();
    private final Deque<ClassMetaData> classStack = new LinkedList<ClassMetaData>();
    private String packageName;

    public void visit(CompilationUnit compilationUnit, ClassMetaDataRepository<ClassMetaData> repository) {
        super.visit(compilationUnit, repository);
        compilationUnit.getImports().stream().filter(anImport -> !anImport.isStatic()).map(anImport -> anImport.getNameAsString() + (anImport.isAsterisk() ? ".*" : "")).forEach(anImport -> this.allClasses.forEach(classMetaData -> classMetaData.addImport((String)anImport)));
    }

    public void visit(PackageDeclaration packageDeclaration, ClassMetaDataRepository<ClassMetaData> repository) {
        this.packageName = packageDeclaration.getNameAsString();
        super.visit(packageDeclaration, repository);
    }

    public void visit(ClassOrInterfaceDeclaration classDeclaration, ClassMetaDataRepository<ClassMetaData> repository) {
        this.visitTypeDeclaration((TypeDeclaration<?>)classDeclaration, repository, classDeclaration.isInterface() ? ClassMetaData.MetaType.INTERFACE : ClassMetaData.MetaType.CLASS, () -> {
            this.visitExtendedTypes((NodeWithExtends<?>)classDeclaration);
            this.visitImplementedTypes((NodeWithImplements<?>)classDeclaration);
            super.visit(classDeclaration, (Object)repository);
        });
    }

    public void visit(EnumDeclaration enumDeclaration, ClassMetaDataRepository<ClassMetaData> repository) {
        this.visitTypeDeclaration((TypeDeclaration<?>)enumDeclaration, repository, ClassMetaData.MetaType.ENUM, () -> {
            this.visitImplementedTypes((NodeWithImplements<?>)enumDeclaration);
            enumDeclaration.getEntries().forEach(entry -> this.getCurrentClass().addEnumConstant(entry.getNameAsString()));
            super.visit(enumDeclaration, (Object)repository);
        });
    }

    public void visit(AnnotationDeclaration annotationDeclaration, ClassMetaDataRepository<ClassMetaData> repository) {
        this.visitTypeDeclaration((TypeDeclaration<?>)annotationDeclaration, repository, ClassMetaData.MetaType.ANNOTATION, () -> super.visit(annotationDeclaration, (Object)repository));
    }

    private void visitTypeDeclaration(TypeDeclaration<?> typeDeclaration, ClassMetaDataRepository<ClassMetaData> repository, ClassMetaData.MetaType metaType, Runnable action) {
        ClassMetaData outerClass = this.classStack.isEmpty() ? null : this.getCurrentClass();
        String baseName = typeDeclaration.getNameAsString();
        String className = outerClass == null ? this.packageName + '.' + baseName : outerClass.getClassName() + '.' + baseName;
        String comment = this.getJavadocComment((NodeWithJavadoc<?>)typeDeclaration);
        ClassMetaData currentClass = new ClassMetaData(className, this.packageName, metaType, false, comment);
        if (outerClass != null) {
            outerClass.addInnerClassName(className);
            currentClass.setOuterClassName(outerClass.getClassName());
        }
        this.findAnnotations((NodeWithAnnotations<?>)typeDeclaration, currentClass);
        this.allClasses.add(currentClass);
        repository.put(className, currentClass);
        this.classStack.push(currentClass);
        action.run();
        this.classStack.pop();
    }

    private ClassMetaData getCurrentClass() {
        return this.classStack.peek();
    }

    private void visitExtendedTypes(NodeWithExtends<?> node) {
        ClassMetaData currentClass = this.getCurrentClass();
        for (ClassOrInterfaceType extendedType : node.getExtendedTypes()) {
            if (currentClass.isInterface()) {
                currentClass.addInterfaceName(this.extractName(extendedType));
                continue;
            }
            currentClass.setSuperClassName(this.extractName(extendedType));
        }
    }

    private void visitImplementedTypes(NodeWithImplements<?> node) {
        ClassMetaData currentClass = this.getCurrentClass();
        for (ClassOrInterfaceType implementedType : node.getImplementedTypes()) {
            currentClass.addInterfaceName(this.extractName(implementedType));
        }
    }

    public void visit(MethodDeclaration methodDeclaration, ClassMetaDataRepository<ClassMetaData> repository) {
        String name = methodDeclaration.getNameAsString();
        String rawCommentText = this.getJavadocComment((NodeWithJavadoc<?>)methodDeclaration);
        TypeMetaData returnType = this.extractTypeName(methodDeclaration.getType());
        MethodMetaData methodMetaData = this.getCurrentClass().addMethod(name, returnType, rawCommentText);
        this.findAnnotations((NodeWithAnnotations<?>)methodDeclaration, methodMetaData);
        this.extractParameters(methodDeclaration, methodMetaData);
        Matcher matcher = GETTER_METHOD_NAME.matcher(name);
        if (matcher.matches()) {
            int startName = matcher.start(2);
            String propName = name.substring(startName, startName + 1).toLowerCase() + name.substring(startName + 1);
            PropertyMetaData property = this.getCurrentClass().addReadableProperty(propName, returnType, rawCommentText, methodMetaData);
            methodMetaData.getAnnotationTypeNames().forEach(property::addAnnotationTypeName);
            property.setReplacement(methodMetaData.getReplacement());
            return;
        }
        if (methodMetaData.getParameters().size() != 1) {
            return;
        }
        matcher = SETTER_METHOD_NAME.matcher(name);
        if (matcher.matches()) {
            int startName = matcher.start(1);
            String propName = name.substring(startName, startName + 1).toLowerCase() + name.substring(startName + 1);
            TypeMetaData type = methodMetaData.getParameters().get(0).getType();
            this.getCurrentClass().addWriteableProperty(propName, type, rawCommentText, methodMetaData);
        }
    }

    private void extractParameters(MethodDeclaration n, MethodMetaData method) {
        for (Parameter parameter : n.getParameters()) {
            TypeMetaData typeMetaData = this.extractTypeName(parameter.getType());
            if (parameter.isVarArgs()) {
                typeMetaData.setVarargs();
            }
            method.addParameter(parameter.getNameAsString(), typeMetaData);
        }
    }

    public void visit(FieldDeclaration fieldDeclaration, ClassMetaDataRepository<ClassMetaData> arg) {
        boolean isConst;
        boolean bl = isConst = this.getCurrentClass().isInterface() || fieldDeclaration.isStatic() && fieldDeclaration.isFinal();
        if (isConst) {
            fieldDeclaration.getVariables().forEach(variableDeclarator -> {
                String constName = variableDeclarator.getNameAsString();
                String value = variableDeclarator.getInitializer().filter(Expression::isLiteralStringValueExpr).map(Expression::asLiteralStringValueExpr).map(LiteralStringValueExpr::getValue).orElse(null);
                this.getCurrentClass().getConstants().put(constName, value);
            });
        }
    }

    private TypeMetaData extractTypeName(Type type) {
        TypeMetaData typeMetaData = new TypeMetaData();
        type.ifArrayType(arrayType -> typeMetaData.setArrayDimensions(arrayType.getArrayLevel()));
        this.extractElementTypeName(type.getElementType(), typeMetaData);
        return typeMetaData;
    }

    private void extractElementTypeName(Type elementType, TypeMetaData typeMetaData) {
        elementType.ifVoidType(voidType -> typeMetaData.setName("void"));
        elementType.ifPrimitiveType(primitiveType -> typeMetaData.setName(primitiveType.asString()));
        elementType.ifWildcardType(wildcardType -> {
            if (!wildcardType.getExtendedType().isPresent() && !wildcardType.getSuperType().isPresent()) {
                typeMetaData.setWildcard();
            } else {
                wildcardType.getExtendedType().ifPresent(referenceType -> typeMetaData.setUpperBounds(this.extractTypeName((Type)referenceType)));
                wildcardType.getSuperType().ifPresent(referenceType -> typeMetaData.setLowerBounds(this.extractTypeName((Type)referenceType)));
            }
        });
        elementType.ifClassOrInterfaceType(classOrInterfaceType -> {
            typeMetaData.setName(this.extractName((ClassOrInterfaceType)classOrInterfaceType));
            classOrInterfaceType.getTypeArguments().ifPresent(typeArguments -> typeArguments.forEach(arg -> typeMetaData.addTypeArg(this.extractTypeName((Type)arg))));
        });
    }

    private void findAnnotations(NodeWithAnnotations<?> node, AbstractLanguageElement currentElement) {
        for (AnnotationExpr child : node.getAnnotations()) {
            if (child instanceof SingleMemberAnnotationExpr && child.getNameAsString().endsWith("ReplacedBy")) {
                currentElement.setReplacement(((SingleMemberAnnotationExpr)child).getMemberValue().asLiteralStringValueExpr().getValue());
            }
            currentElement.addAnnotationTypeName(child.getNameAsString());
        }
    }

    private String extractName(ClassOrInterfaceType type) {
        if (type.getScope().isPresent()) {
            return this.extractName((ClassOrInterfaceType)type.getScope().get()) + "." + type.getNameAsString();
        }
        return type.getNameAsString();
    }

    private String getJavadocComment(NodeWithJavadoc<?> node) {
        return node.getJavadocComment().map(Comment::getContent).orElse("");
    }
}

