/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.links;

import dev.gradleplugins.documentationkit.dsl.links.LinkMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.EnumConstantMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.model.Attachable;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gradle.util.CollectionUtils;

public class ClassLinkMetaData
implements Serializable,
Attachable<ClassLinkMetaData> {
    private final String className;
    private final String simpleName;
    private final String packageName;
    private LinkMetaData.Style style;
    private final Map<String, MethodLinkMetaData> methods = new HashMap<String, MethodLinkMetaData>();

    public ClassLinkMetaData(ClassMetaData classMetaData) {
        this.className = classMetaData.getClassName();
        this.simpleName = classMetaData.getSimpleName();
        this.packageName = classMetaData.getPackageName();
        this.style = LinkMetaData.Style.Javadoc;
        for (MethodMetaData method : classMetaData.getDeclaredMethods()) {
            this.addMethod(method, this.style);
        }
        for (EnumConstantMetaData enumConstant : classMetaData.getEnumConstants()) {
            this.addEnumConstant(enumConstant, this.style);
        }
    }

    public LinkMetaData getClassLink() {
        return new LinkMetaData(this.style, this.simpleName, null);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public LinkMetaData getMethod(String method) {
        MethodLinkMetaData methodMetaData = this.findMethod(method);
        String urlFragment = methodMetaData.getUrlFragment(this.className);
        String displayName = String.format("%s.%s", this.simpleName, methodMetaData.getDisplayName());
        return new LinkMetaData(methodMetaData.style, displayName, urlFragment);
    }

    private MethodLinkMetaData findMethod(String method) {
        String message;
        MethodLinkMetaData metaData;
        if (method.endsWith("...)")) {
            method = method.substring(0, method.length() - 4) + "[])";
        }
        if ((metaData = this.methods.get(method)) != null) {
            return metaData;
        }
        ArrayList<MethodLinkMetaData> candidates = new ArrayList<MethodLinkMetaData>();
        for (MethodLinkMetaData methodLinkMetaData : this.methods.values()) {
            if (!methodLinkMetaData.name.equals(method)) continue;
            candidates.add(methodLinkMetaData);
        }
        if (candidates.isEmpty()) {
            message = String.format("No method '%s' found for class '%s'.\nFound the following methods:", method, this.className);
            for (MethodLinkMetaData methodLinkMetaData : this.methods.values()) {
                message = message + "\n  " + methodLinkMetaData;
            }
            message = message + "\nThis problem may happen when some apilink from docbook template xmls refers to unknown method.\nExample: <apilink class=\"org.gradle.api.Project\" method=\"someMethodThatDoesNotExist\"/>";
            throw new RuntimeException(message);
        }
        if (candidates.size() != 1) {
            message = String.format("Found multiple methods called '%s' in class '%s'. Candidates: %s", method, this.className, CollectionUtils.join((String)", ", candidates));
            message = message + "\nThis problem may happen when some apilink from docbook template xmls is incorrect. Example:\nIncorrect: <apilink class=\"org.gradle.api.Project\" method=\"tarTree\"/>\nCorrect:   <apilink class=\"org.gradle.api.Project\" method=\"tarTree(Object)\"/>";
            throw new RuntimeException(message);
        }
        return (MethodLinkMetaData)candidates.get(0);
    }

    public LinkMetaData.Style getStyle() {
        return this.style;
    }

    public void setStyle(LinkMetaData.Style style) {
        this.style = style;
    }

    public void addMethod(MethodMetaData method, LinkMetaData.Style style) {
        this.methods.put(method.getOverrideSignature(), new MethodLinkMetaData(method.getName(), method.getOverrideSignature(), style));
    }

    public void addEnumConstant(EnumConstantMetaData enumConstant, LinkMetaData.Style style) {
        String name = enumConstant.getName();
        this.methods.put(name, new EnumConstantLinkMetaData(name, style));
    }

    public void addBlockMethod(MethodMetaData method) {
        this.methods.put(method.getOverrideSignature(), new BlockLinkMetaData(method.getName(), method.getOverrideSignature()));
    }

    public void addPropertyAccessorMethod(String propertyName, MethodMetaData getterOrSetter) {
        this.methods.put(getterOrSetter.getOverrideSignature(), new PropertyLinkMetaData(propertyName, getterOrSetter.getName(), getterOrSetter.getOverrideSignature()));
    }

    @Override
    public void attach(ClassMetaDataRepository<ClassLinkMetaData> linkMetaDataClassMetaDataRepository) {
    }

    public String toString() {
        return "ClassLinkMetaData(className=" + this.className + ", simpleName=" + this.simpleName + ", packageName=" + this.getPackageName() + ", style=" + (Object)((Object)this.getStyle()) + ", methods=" + this.methods + ")";
    }

    private static class EnumConstantLinkMetaData
    extends MethodLinkMetaData {
        private EnumConstantLinkMetaData(String name, LinkMetaData.Style style) {
            super(name, name, style);
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }
    }

    private static class PropertyLinkMetaData
    extends MethodLinkMetaData {
        private final String propertyName;

        private PropertyLinkMetaData(String propertyName, String methodName, String signature) {
            super(methodName, signature, LinkMetaData.Style.Dsldoc);
            this.propertyName = propertyName;
        }

        @Override
        public String getUrlFragment(String className) {
            return String.format("%s:%s", className, this.propertyName);
        }
    }

    private static class BlockLinkMetaData
    extends MethodLinkMetaData {
        private BlockLinkMetaData(String name, String signature) {
            super(name, signature, LinkMetaData.Style.Dsldoc);
        }

        @Override
        public String getDisplayName() {
            return String.format("%s{}", this.name);
        }
    }

    private static class MethodLinkMetaData
    implements Serializable {
        final String name;
        final String signature;
        final LinkMetaData.Style style;

        private MethodLinkMetaData(String name, String signature, LinkMetaData.Style style) {
            this.name = name;
            this.signature = signature;
            this.style = style;
        }

        public String getDisplayName() {
            return this.signature;
        }

        public String getUrlFragment(String className) {
            return this.style == LinkMetaData.Style.Dsldoc ? String.format("%s:%s", className, this.signature) : this.signature.replace('(', '-').replace(')', '-');
        }

        public String toString() {
            return this.signature;
        }
    }
}

