/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook.model;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.documentationkit.dsl.docbook.DocComment;
import dev.gradleplugins.documentationkit.dsl.docbook.model.DslElementDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ExtraAttributeDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Node;

public final class PropertyDoc
implements DslElementDoc {
    private final ClassMetaData referringClass;
    private final PropertyMetaData metaData;
    private final DocComment comment;
    private final List<ExtraAttributeDoc> additionalValues;

    @Override
    public String getId() {
        return this.referringClass.getClassName() + ":" + this.metaData.getName();
    }

    public String getName() {
        return this.metaData.getName();
    }

    @Override
    public String getDescription() {
        return this.comment.getDocbook().stream().filter(it -> it.getNodeName().equals("para")).map(Node::getTextContent).findFirst().orElse(null);
    }

    @Override
    public boolean isDeprecated() {
        return this.metaData.isDeprecated() && !this.referringClass.isDeprecated();
    }

    @Override
    public boolean isIncubating() {
        return this.metaData.isIncubating() || this.metaData.getOwnerClass().isIncubating();
    }

    @Override
    public boolean isReplaced() {
        return this.metaData.isReplaced();
    }

    @Override
    public String getReplacement() {
        return this.metaData.getReplacement();
    }

    public boolean isReadOnly() {
        return !this.metaData.isWriteable() && !this.metaData.getType().getName().contains("Property");
    }

    public boolean isWriteOnly() {
        return !this.metaData.isProviderApi() && this.metaData.isWriteable();
    }

    public PropertyDoc forClass(ClassMetaData refererMetaData) {
        return this.forClass(refererMetaData, (Collection<ExtraAttributeDoc>)ImmutableList.of());
    }

    public PropertyDoc forClass(ClassMetaData refererMetaData, Collection<ExtraAttributeDoc> additionalValues) {
        if (refererMetaData == this.getReferringClass() && additionalValues.isEmpty()) {
            return this;
        }
        return new PropertyDoc(refererMetaData, this.metaData, this.comment, (List<ExtraAttributeDoc>)ImmutableList.copyOf(additionalValues));
    }

    public PropertyDoc(ClassMetaData referringClass, PropertyMetaData metaData, DocComment comment, List<ExtraAttributeDoc> additionalValues) {
        this.referringClass = referringClass;
        this.metaData = metaData;
        this.comment = comment;
        this.additionalValues = additionalValues;
    }

    public ClassMetaData getReferringClass() {
        return this.referringClass;
    }

    public PropertyMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public DocComment getComment() {
        return this.comment;
    }

    public List<ExtraAttributeDoc> getAdditionalValues() {
        return this.additionalValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyDoc)) {
            return false;
        }
        PropertyDoc other = (PropertyDoc)o;
        ClassMetaData this$referringClass = this.getReferringClass();
        ClassMetaData other$referringClass = other.getReferringClass();
        if (this$referringClass == null ? other$referringClass != null : !((Object)this$referringClass).equals(other$referringClass)) {
            return false;
        }
        PropertyMetaData this$metaData = this.getMetaData();
        PropertyMetaData other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        DocComment this$comment = this.getComment();
        DocComment other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<ExtraAttributeDoc> this$additionalValues = this.getAdditionalValues();
        List<ExtraAttributeDoc> other$additionalValues = other.getAdditionalValues();
        return !(this$additionalValues == null ? other$additionalValues != null : !((Object)this$additionalValues).equals(other$additionalValues));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassMetaData $referringClass = this.getReferringClass();
        result = result * 59 + ($referringClass == null ? 43 : ((Object)$referringClass).hashCode());
        PropertyMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        DocComment $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<ExtraAttributeDoc> $additionalValues = this.getAdditionalValues();
        result = result * 59 + ($additionalValues == null ? 43 : ((Object)$additionalValues).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyDoc(referringClass=" + this.getReferringClass() + ", metaData=" + this.getMetaData() + ", comment=" + this.getComment() + ", additionalValues=" + this.getAdditionalValues() + ")";
    }
}

