/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook.model;

import dev.gradleplugins.documentationkit.dsl.docbook.DocComment;
import dev.gradleplugins.documentationkit.dsl.docbook.model.DslElementDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import org.w3c.dom.Node;

public final class MethodDoc
implements DslElementDoc {
    private final ClassMetaData referringClass;
    private final MethodMetaData metaData;
    private final DocComment comment;

    public MethodDoc forClass(ClassMetaData refererMetaData) {
        if (refererMetaData == this.referringClass) {
            return this;
        }
        return new MethodDoc(refererMetaData, this.metaData, this.comment);
    }

    @Override
    public String getId() {
        return this.referringClass.getClassName() + ":" + this.metaData.getOverrideSignature();
    }

    public String getName() {
        return this.metaData.getName();
    }

    @Override
    public boolean isDeprecated() {
        return this.metaData.isDeprecated() && !this.referringClass.isDeprecated();
    }

    @Override
    public boolean isIncubating() {
        return this.metaData.isIncubating() || this.metaData.getOwnerClass().isIncubating();
    }

    @Override
    public boolean isReplaced() {
        return this.metaData.isReplaced();
    }

    @Override
    public String getReplacement() {
        return this.metaData.getReplacement();
    }

    @Override
    public String getDescription() {
        return this.comment.getDocbook().stream().filter(it -> it.getNodeName().equals("para")).map(Node::getTextContent).findFirst().orElse(null);
    }

    public MethodDoc(ClassMetaData referringClass, MethodMetaData metaData, DocComment comment) {
        this.referringClass = referringClass;
        this.metaData = metaData;
        this.comment = comment;
    }

    public ClassMetaData getReferringClass() {
        return this.referringClass;
    }

    public MethodMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public DocComment getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodDoc)) {
            return false;
        }
        MethodDoc other = (MethodDoc)o;
        ClassMetaData this$referringClass = this.getReferringClass();
        ClassMetaData other$referringClass = other.getReferringClass();
        if (this$referringClass == null ? other$referringClass != null : !((Object)this$referringClass).equals(other$referringClass)) {
            return false;
        }
        MethodMetaData this$metaData = this.getMetaData();
        MethodMetaData other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        DocComment this$comment = this.getComment();
        DocComment other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassMetaData $referringClass = this.getReferringClass();
        result = result * 59 + ($referringClass == null ? 43 : ((Object)$referringClass).hashCode());
        MethodMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        DocComment $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "MethodDoc(referringClass=" + this.getReferringClass() + ", metaData=" + this.getMetaData() + ", comment=" + this.getComment() + ")";
    }
}

