/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.DocLinkBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.source.TypeNameResolver;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavadocLinkConverter {
    private static final Pattern LINK_PATTERN = Pattern.compile("(?s)\\s*([\\w\\.]*)(#(\\w+)(\\((.*)\\))?)?.*");
    private static final Pattern TYPE_PATTERN = Pattern.compile("(\\w+)\\s*(.*?)\\s*");
    private static final Pattern PARAM_DELIMITER = Pattern.compile(",\\s*");
    private final Document document;
    private final TypeNameResolver typeNameResolver;
    private final DocLinkBuilder docLinkBuilder;
    private final ClassMetaDataRepository<ClassMetaData> repository;

    public JavadocLinkConverter(Document document, TypeNameResolver typeNameResolver, DocLinkBuilder docLinkBuilder, ClassMetaDataRepository<ClassMetaData> repository) {
        this.document = document;
        this.typeNameResolver = typeNameResolver;
        this.docLinkBuilder = docLinkBuilder;
        this.repository = repository;
    }

    public Node resolve(String link, ClassMetaData classMetaData, GenerationListener listener) {
        Node node = this.doResolve(link, classMetaData, listener);
        if (node != null) {
            return node;
        }
        listener.warning(String.format("Could not convert Javadoc link '%s'", link));
        Element element = this.document.createElement("UNHANDLED-LINK");
        element.appendChild(this.document.createTextNode(link));
        return element;
    }

    private Node doResolve(String link, ClassMetaData classMetaData, GenerationListener listener) {
        ClassMetaData targetClass;
        Matcher matcher = LINK_PATTERN.matcher(link);
        if (!matcher.matches()) {
            return null;
        }
        String className = null;
        if (matcher.group(1).length() > 0 && (className = this.typeNameResolver.resolve(matcher.group(1), classMetaData)) == null) {
            return null;
        }
        if (matcher.group(2) == null) {
            return this.docLinkBuilder.link(new TypeMetaData(className), listener).getDocbook();
        }
        if (className != null) {
            targetClass = this.repository.find(className);
            if (targetClass == null) {
                return null;
            }
        } else {
            targetClass = classMetaData;
        }
        String methodSignature = matcher.group(3);
        if (matcher.group(5) != null) {
            StringBuilder signature = new StringBuilder();
            signature.append(methodSignature);
            signature.append("(");
            if (matcher.group(5).length() > 0) {
                String[] types = PARAM_DELIMITER.split(matcher.group(5));
                for (int i = 0; i < types.length; ++i) {
                    String type = types[i];
                    Matcher typeMatcher = TYPE_PATTERN.matcher(type);
                    if (!typeMatcher.matches()) {
                        return null;
                    }
                    if (i > 0) {
                        signature.append(", ");
                    }
                    signature.append(this.typeNameResolver.resolve(typeMatcher.group(1), classMetaData));
                    String suffix = typeMatcher.group(2);
                    if (suffix.equals("...")) {
                        suffix = "[]";
                    }
                    signature.append(suffix);
                }
            }
            signature.append(")");
            methodSignature = signature.toString();
        }
        if (targetClass.isEnum() && targetClass.getEnumConstant(methodSignature) != null) {
            return this.docLinkBuilder.link(targetClass.getEnumConstant(methodSignature), listener).getDocbook();
        }
        MethodMetaData method = this.findMethod(methodSignature, targetClass);
        if (method == null) {
            return null;
        }
        return this.docLinkBuilder.link(method, listener).getDocbook();
    }

    private MethodMetaData findMethod(String name, ClassMetaData targetClass) {
        ArrayList<MethodMetaData> candidates = new ArrayList<MethodMetaData>();
        for (MethodMetaData methodMetaData : targetClass.getDeclaredMethods()) {
            if (name.equals(methodMetaData.getOverrideSignature())) {
                return methodMetaData;
            }
            if (!name.equals(methodMetaData.getName())) continue;
            candidates.add(methodMetaData);
        }
        if (candidates.size() != 1) {
            return null;
        }
        return (MethodMetaData)candidates.get(0);
    }

    public Node resolveValue(String fieldName, ClassMetaData classMetaData, GenerationListener listener) {
        String value;
        ClassMetaData targetClass;
        String[] parts = fieldName.split("#");
        if (parts[0].length() > 0) {
            String targetClassName = this.typeNameResolver.resolve(parts[0], classMetaData);
            targetClass = this.repository.find(targetClassName);
            if (targetClass == null) {
                listener.warning(String.format("Could not locate target class '%s' for field value link '%s'", targetClass, fieldName));
                Element element = this.document.createElement("UNHANDLED-VALUE");
                element.appendChild(this.document.createTextNode(targetClassName + ":" + parts[1]));
                return element;
            }
        } else {
            targetClass = classMetaData;
        }
        if ((value = targetClass.getConstants().get(parts[1])) == null) {
            listener.warning(String.format("Field '%s' does not have any value", fieldName));
            Element element = this.document.createElement("NO-VALUE-FOR_FIELD");
            element.appendChild(this.document.createTextNode(targetClass.getClassName() + ":" + parts[1]));
            return element;
        }
        return this.createLiteralNode(value);
    }

    private Node createLiteralNode(String value) {
        Element element = this.document.createElement("literal");
        element.appendChild(this.document.createTextNode(value));
        return element;
    }
}

