/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.BasicJavadocLexer;
import dev.gradleplugins.documentationkit.dsl.docbook.DocBookBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.DocComment;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.HtmlToXmlJavadocLexer;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocLexer;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocLinkConverter;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocScanner;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JavadocConverter {
    private static final Pattern HEADER_PATTERN = Pattern.compile("h(\\d)", 2);
    private static final Pattern ACCESSOR_COMMENT_PATTERN = Pattern.compile("(?:returns|sets)\\s+(the|whether)\\s+", 2);
    private final Document document;
    private final JavadocLinkConverter linkConverter;

    public JavadocConverter(Document document, JavadocLinkConverter linkConverter) {
        this.document = document;
        this.linkConverter = linkConverter;
    }

    public DocComment parse(ClassMetaData classMetaData, GenerationListener listener) {
        listener.start(String.format("class %s", classMetaData));
        try {
            String rawCommentText = classMetaData.getRawCommentText();
            try {
                DocCommentImpl docCommentImpl = this.parse(rawCommentText, classMetaData, new NoOpCommentSource(), listener);
                return docCommentImpl;
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not convert javadoc comment to docbook.%nClass: %s%nComment: %s", classMetaData, rawCommentText), (Throwable)e);
            }
        }
        finally {
            listener.finish();
        }
    }

    public DocComment parse(PropertyMetaData propertyMetaData, GenerationListener listener) {
        listener.start(String.format("property %s", propertyMetaData));
        try {
            ClassMetaData ownerClass = propertyMetaData.getOwnerClass();
            String rawCommentText = propertyMetaData.getRawCommentText();
            try {
                InheritedPropertyCommentSource commentSource = new InheritedPropertyCommentSource(propertyMetaData, listener);
                DocCommentImpl docComment = this.parse(rawCommentText, ownerClass, commentSource, listener);
                this.adjustAccessorComment(docComment);
                DocCommentImpl docCommentImpl = docComment;
                return docCommentImpl;
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not convert javadoc comment to docbook.%nClass: %s%nProperty: %s%nComment: %s", ownerClass.getClassName(), propertyMetaData.getName(), rawCommentText), (Throwable)e);
            }
        }
        finally {
            listener.finish();
        }
    }

    public DocComment parse(MethodMetaData methodMetaData, GenerationListener listener) {
        listener.start(String.format("method %s", methodMetaData));
        try {
            ClassMetaData ownerClass = methodMetaData.getOwnerClass();
            String rawCommentText = methodMetaData.getRawCommentText();
            try {
                InheritedMethodCommentSource commentSource = new InheritedMethodCommentSource(listener, methodMetaData);
                DocCommentImpl docCommentImpl = this.parse(rawCommentText, ownerClass, commentSource, listener);
                return docCommentImpl;
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not convert javadoc comment to docbook.%nClass: %s%nMethod: %s%nComment: %s", ownerClass.getClassName(), methodMetaData.getSignature(), rawCommentText), (Throwable)e);
            }
        }
        finally {
            listener.finish();
        }
    }

    private void adjustAccessorComment(DocCommentImpl docComment) {
        List<Element> nodes = docComment.getDocbook();
        if (nodes.isEmpty()) {
            return;
        }
        Element firstNode = nodes.get(0);
        if (!firstNode.getNodeName().equals("para") || !(firstNode.getFirstChild() instanceof Text)) {
            return;
        }
        Text comment = (Text)firstNode.getFirstChild();
        Matcher matcher = ACCESSOR_COMMENT_PATTERN.matcher(comment.getData());
        if (matcher.lookingAt()) {
            String theOrWhether = matcher.group(1).toLowerCase(Locale.US);
            comment.setData(StringUtils.capitalize((String)theOrWhether) + " " + comment.getData().substring(matcher.end()));
        }
    }

    private DocCommentImpl parse(String rawCommentText, ClassMetaData classMetaData, CommentSource inheritedCommentSource, GenerationListener listener) {
        HtmlToXmlJavadocLexer lexer = new HtmlToXmlJavadocLexer(new BasicJavadocLexer(new JavadocScanner(rawCommentText)));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DocBookBuilder nodes = new DocBookBuilder(document);
        HtmlGeneratingTokenHandler handler = new HtmlGeneratingTokenHandler(nodes, document);
        handler.add(new HtmlElementTranslatingHandler(nodes, document));
        handler.add(new PreElementHandler(nodes, document));
        handler.add(new JavadocTagToElementTranslatingHandler(nodes, document));
        handler.add(new HeaderHandler(nodes, document));
        handler.add(new LinkHandler(nodes, this.linkConverter, classMetaData, listener));
        handler.add(new InheritDocHandler(nodes, inheritedCommentSource));
        handler.add(new ValueTagHandler(nodes, this.linkConverter, classMetaData, listener));
        handler.add(new LiteralTagHandler(nodes));
        handler.add(new TableHandler(nodes, document));
        handler.add(new DlElementHandler(nodes, document));
        handler.add(new AnchorElementHandler(nodes, document, classMetaData));
        handler.add(new AToLinkTranslatingHandler(nodes, document, classMetaData));
        handler.add(new AToUlinkTranslatingHandler(nodes, document));
        handler.add(new UnknownJavadocTagHandler(nodes, document, listener));
        handler.add(new UnknownHtmlElementHandler(nodes, document, listener));
        lexer.visit(handler);
        return new DocCommentImpl(nodes.getElements());
    }

    private class InheritedMethodCommentSource
    implements CommentSource {
        private final GenerationListener listener;
        private final MethodMetaData methodMetaData;

        public InheritedMethodCommentSource(GenerationListener listener, MethodMetaData methodMetaData) {
            this.listener = listener;
            this.methodMetaData = methodMetaData;
        }

        @Override
        public Iterable<? extends Node> getCommentText() {
            MethodMetaData overriddenMethod = this.methodMetaData.getOverriddenMethod();
            if (overriddenMethod == null) {
                this.listener.warning("No inherited javadoc comment found.");
                return Arrays.asList(JavadocConverter.this.document.createTextNode("!!NO INHERITED DOC COMMENT!!"));
            }
            return JavadocConverter.this.parse(overriddenMethod, this.listener).getDocbook();
        }
    }

    private class InheritedPropertyCommentSource
    implements CommentSource {
        private final PropertyMetaData propertyMetaData;
        private final GenerationListener listener;

        public InheritedPropertyCommentSource(PropertyMetaData propertyMetaData, GenerationListener listener) {
            this.propertyMetaData = propertyMetaData;
            this.listener = listener;
        }

        @Override
        public Iterable<? extends Node> getCommentText() {
            PropertyMetaData overriddenProperty = this.propertyMetaData.getOverriddenProperty();
            if (overriddenProperty == null) {
                this.listener.warning("No inherited javadoc comment found.");
                return Arrays.asList(JavadocConverter.this.document.createTextNode("!!NO INHERITED DOC COMMENT!!"));
            }
            return JavadocConverter.this.parse(overriddenProperty, this.listener).getDocbook();
        }
    }

    private static class NoOpCommentSource
    implements CommentSource {
        private NoOpCommentSource() {
        }

        public List<? extends Node> getCommentText() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface CommentSource {
        public Iterable<? extends Node> getCommentText();
    }

    private static class InheritDocHandler
    implements JavadocTagHandler {
        private final CommentSource source;
        private final DocBookBuilder nodeStack;

        private InheritDocHandler(DocBookBuilder nodeStack, CommentSource source) {
            this.nodeStack = nodeStack;
            this.source = source;
        }

        @Override
        public boolean onJavadocTag(String tag, String value) {
            if (!tag.equals("inheritDoc")) {
                return false;
            }
            for (Node node : this.source.getCommentText()) {
                this.nodeStack.appendChild(node);
            }
            return true;
        }
    }

    private static class LinkHandler
    implements JavadocTagHandler {
        private final DocBookBuilder nodes;
        private final JavadocLinkConverter linkConverter;
        private final ClassMetaData classMetaData;
        private final GenerationListener listener;

        private LinkHandler(DocBookBuilder nodes, JavadocLinkConverter linkConverter, ClassMetaData classMetaData, GenerationListener listener) {
            this.nodes = nodes;
            this.linkConverter = linkConverter;
            this.classMetaData = classMetaData;
            this.listener = listener;
        }

        @Override
        public boolean onJavadocTag(String tag, String value) {
            if (!tag.equals("link")) {
                return false;
            }
            this.nodes.appendChild(this.linkConverter.resolve(value, this.classMetaData, this.listener));
            return true;
        }
    }

    private static class LiteralTagHandler
    implements JavadocTagHandler {
        private final DocBookBuilder nodes;

        private LiteralTagHandler(DocBookBuilder nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean onJavadocTag(String tag, String value) {
            if (!tag.equals("literal")) {
                return false;
            }
            this.nodes.appendChild(value);
            return true;
        }
    }

    private static class ValueTagHandler
    implements JavadocTagHandler {
        private final JavadocLinkConverter linkConverter;
        private final ClassMetaData classMetaData;
        private final DocBookBuilder nodes;
        private final GenerationListener listener;

        public ValueTagHandler(DocBookBuilder nodes, JavadocLinkConverter linkConverter, ClassMetaData classMetaData, GenerationListener listener) {
            this.nodes = nodes;
            this.linkConverter = linkConverter;
            this.classMetaData = classMetaData;
            this.listener = listener;
        }

        @Override
        public boolean onJavadocTag(String tag, String value) {
            if (!tag.equals("value")) {
                return false;
            }
            this.nodes.appendChild(this.linkConverter.resolveValue(value, this.classMetaData, this.listener));
            return true;
        }
    }

    private static class DlElementHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private Element currentList;
        private Element currentItem;

        public DlElementHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
        }

        @Override
        public boolean onStartElement(String elementName, Map<String, String> attributes) {
            if (elementName.equals("dl")) {
                if (this.currentList != null) {
                    throw new UnsupportedOperationException("<dl> within a <dl> is not supported.");
                }
                this.currentList = this.document.createElement("variablelist");
                this.nodes.push(this.currentList);
                return true;
            }
            if (elementName.equals("dt")) {
                if (this.currentItem != null) {
                    this.nodes.pop();
                }
                this.currentItem = this.document.createElement("varlistentry");
                this.nodes.push(this.currentItem);
                this.nodes.push(this.document.createElement("term"));
                return true;
            }
            if (elementName.equals("dd")) {
                if (this.currentItem == null) {
                    throw new IllegalStateException("No <dt> element preceding <dd> element.");
                }
                this.nodes.push(this.document.createElement("listitem"));
                return true;
            }
            return false;
        }

        @Override
        public void onEndElement(String element) {
            if (element.equals("dl")) {
                this.currentList = null;
                if (this.currentItem != null) {
                    this.currentItem = null;
                    this.nodes.pop();
                }
                this.nodes.pop();
            }
            if (element.equals("dt")) {
                this.nodes.pop();
            }
            if (element.equals("dd")) {
                this.nodes.pop();
            }
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }
    }

    private static class AToUlinkTranslatingHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;

        private AToUlinkTranslatingHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
        }

        @Override
        public boolean onStartElement(String elementName, Map<String, String> attributes) {
            if (!elementName.equals("a") || !attributes.containsKey("href")) {
                return false;
            }
            String href = attributes.get("href");
            if (href.startsWith("#")) {
                return false;
            }
            Element element = this.document.createElement("ulink");
            element.setAttribute("url", href);
            this.nodes.push(element);
            return true;
        }

        @Override
        public void onEndElement(String element) {
            this.nodes.pop();
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }
    }

    private static class AToLinkTranslatingHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private final ClassMetaData classMetaData;

        private AToLinkTranslatingHandler(DocBookBuilder nodes, Document document, ClassMetaData classMetaData) {
            this.nodes = nodes;
            this.document = document;
            this.classMetaData = classMetaData;
        }

        @Override
        public boolean onStartElement(String elementName, Map<String, String> attributes) {
            if (!elementName.equals("a") || !attributes.containsKey("href")) {
                return false;
            }
            String href = attributes.get("href");
            if (!href.startsWith("#")) {
                return false;
            }
            Element element = this.document.createElement("link");
            String targetId = String.format("%s.%s", this.classMetaData.getClassName(), href.substring(1));
            element.setAttribute("linkend", targetId);
            this.nodes.push(element);
            return true;
        }

        @Override
        public void onEndElement(String element) {
            this.nodes.pop();
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }
    }

    private static class AnchorElementHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private final ClassMetaData classMetaData;

        private AnchorElementHandler(DocBookBuilder nodes, Document document, ClassMetaData classMetaData) {
            this.nodes = nodes;
            this.document = document;
            this.classMetaData = classMetaData;
        }

        @Override
        public boolean onStartElement(String elementName, Map<String, String> attributes) {
            if (!elementName.equals("a") || !attributes.containsKey("name")) {
                return false;
            }
            Element element = this.document.createElement("anchor");
            String id = String.format("%s.%s", this.classMetaData.getClassName(), attributes.get("name"));
            element.setAttribute("id", id);
            this.nodes.appendChild(element);
            return true;
        }

        @Override
        public void onEndElement(String element) {
        }

        @Override
        public void onText(String text) {
        }
    }

    private static class TableHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private Element currentTable;
        private Element currentRow;
        private Element header;

        public TableHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
        }

        @Override
        public boolean onStartElement(String elementName, Map<String, String> attributes) {
            if (elementName.equals("table")) {
                if (this.currentTable != null) {
                    throw new UnsupportedOperationException("A table within a table is not supported.");
                }
                this.currentTable = this.document.createElement("table");
                this.nodes.push(this.currentTable);
                return true;
            }
            if (elementName.equals("tr")) {
                this.currentRow = this.document.createElement("tr");
                this.nodes.push(this.currentRow);
                return true;
            }
            if (elementName.equals("th")) {
                if (this.header == null) {
                    this.header = this.document.createElement("thead");
                    this.currentTable.insertBefore(this.header, null);
                    this.header.appendChild(this.currentRow);
                }
                this.nodes.push(this.document.createElement("td"));
                return true;
            }
            if (elementName.equals("td")) {
                this.nodes.push(this.document.createElement("td"));
                return true;
            }
            return false;
        }

        @Override
        public void onEndElement(String elementName) {
            if (elementName.equals("table")) {
                this.currentTable = null;
                this.header = null;
            }
            if (elementName.equals("tr")) {
                this.currentRow = null;
            }
            this.nodes.pop();
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }
    }

    private static class HeaderHandler
    implements HtmlElementHandler {
        final DocBookBuilder nodes;
        final Document document;
        int sectionDepth;

        private HeaderHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
        }

        @Override
        public boolean onStartElement(String element, Map<String, String> attributes) {
            Matcher matcher = HEADER_PATTERN.matcher(element);
            if (!matcher.matches()) {
                return false;
            }
            int depth = Integer.parseInt(matcher.group(1));
            if (this.sectionDepth == 0) {
                this.sectionDepth = depth - 1;
            }
            while (this.sectionDepth >= depth) {
                this.nodes.pop();
                --this.sectionDepth;
            }
            Element section = this.document.createElement("section");
            while (this.sectionDepth < depth) {
                this.nodes.push(section);
                ++this.sectionDepth;
            }
            this.nodes.push(this.document.createElement("title"));
            this.sectionDepth = depth;
            return true;
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }

        @Override
        public void onEndElement(String element) {
            this.nodes.pop();
        }
    }

    private static class PreElementHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;

        private PreElementHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
        }

        @Override
        public boolean onStartElement(String element, Map<String, String> attributes) {
            if (!"pre".equals(element)) {
                return false;
            }
            Element newElement = this.document.createElement("programlisting");
            newElement.setAttribute("language", "java");
            this.nodes.push(newElement);
            return true;
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }

        @Override
        public void onEndElement(String element) {
            this.nodes.pop();
        }
    }

    private static class HtmlElementTranslatingHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private final Map<String, String> elementToElementMap = new HashMap<String, String>();

        private HtmlElementTranslatingHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
            this.elementToElementMap.put("p", "para");
            this.elementToElementMap.put("ul", "itemizedlist");
            this.elementToElementMap.put("ol", "orderedlist");
            this.elementToElementMap.put("li", "listitem");
            this.elementToElementMap.put("em", "emphasis");
            this.elementToElementMap.put("strong", "emphasis");
            this.elementToElementMap.put("i", "emphasis");
            this.elementToElementMap.put("b", "emphasis");
            this.elementToElementMap.put("code", "literal");
            this.elementToElementMap.put("tt", "literal");
            this.elementToElementMap.put("blockquote", "blockquote");
            this.elementToElementMap.put("span", "span");
        }

        @Override
        public boolean onStartElement(String element, Map<String, String> attributes) {
            String newElementName = this.elementToElementMap.get(element);
            if (newElementName == null) {
                return false;
            }
            this.nodes.push(this.document.createElement(newElementName));
            return true;
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }

        @Override
        public void onEndElement(String element) {
            this.nodes.pop();
        }
    }

    private static class JavadocTagToElementTranslatingHandler
    implements JavadocTagHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private final Map<String, String> tagToElementMap = new HashMap<String, String>();

        private JavadocTagToElementTranslatingHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
            this.tagToElementMap.put("code", "literal");
        }

        @Override
        public boolean onJavadocTag(String tag, String value) {
            String elementName = this.tagToElementMap.get(tag);
            if (elementName == null) {
                return false;
            }
            Element element = this.document.createElement(elementName);
            element.appendChild(this.document.createTextNode(value));
            this.nodes.appendChild(element);
            return true;
        }
    }

    private static class UnknownHtmlElementHandler
    implements HtmlElementHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private final GenerationListener listener;

        private UnknownHtmlElementHandler(DocBookBuilder nodes, Document document, GenerationListener listener) {
            this.nodes = nodes;
            this.document = document;
            this.listener = listener;
        }

        @Override
        public boolean onStartElement(String elementName, Map<String, String> attributes) {
            this.listener.warning(String.format("Unsupported HTML element <%s>", elementName));
            Element element = this.document.createElement("UNHANDLED-ELEMENT");
            element.appendChild(this.document.createTextNode(String.format("<%s>", elementName)));
            this.nodes.push(element);
            return true;
        }

        @Override
        public void onText(String text) {
            this.nodes.appendChild(text);
        }

        @Override
        public void onEndElement(String elementName) {
            this.nodes.appendChild(String.format("</%s>", elementName));
            this.nodes.pop();
        }
    }

    private static class UnknownJavadocTagHandler
    implements JavadocTagHandler {
        private final DocBookBuilder nodes;
        private final Document document;
        private final GenerationListener listener;

        private UnknownJavadocTagHandler(DocBookBuilder nodes, Document document, GenerationListener listener) {
            this.nodes = nodes;
            this.document = document;
            this.listener = listener;
        }

        @Override
        public boolean onJavadocTag(String tag, String value) {
            this.listener.warning(String.format("Unsupported Javadoc tag '%s'", tag));
            Element element = this.document.createElement("UNHANDLED-TAG");
            element.appendChild(this.document.createTextNode(String.format("{@%s %s}", tag, value)));
            this.nodes.appendChild(element);
            return true;
        }
    }

    private static interface HtmlElementHandler {
        public boolean onStartElement(String var1, Map<String, String> var2);

        public void onText(String var1);

        public void onEndElement(String var1);
    }

    private static interface JavadocTagHandler {
        public boolean onJavadocTag(String var1, String var2);
    }

    private static class HtmlGeneratingTokenHandler
    extends JavadocLexer.TokenVisitor {
        final DocBookBuilder nodes;
        final List<HtmlElementHandler> elementHandlers = new ArrayList<HtmlElementHandler>();
        final List<JavadocTagHandler> tagHandlers = new ArrayList<JavadocTagHandler>();
        final LinkedList<HtmlElementHandler> handlerStack = new LinkedList();
        final LinkedList<String> tagStack = new LinkedList();
        final Map<String, String> attributes = new HashMap<String, String>();
        StringBuilder tagValue;
        final Document document;

        public HtmlGeneratingTokenHandler(DocBookBuilder nodes, Document document) {
            this.nodes = nodes;
            this.document = document;
        }

        public void add(HtmlElementHandler handler) {
            this.elementHandlers.add(handler);
        }

        public void add(JavadocTagHandler handler) {
            this.tagHandlers.add(handler);
        }

        @Override
        void onStartHtmlElement(String name) {
            this.attributes.clear();
        }

        @Override
        void onHtmlElementAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        @Override
        void onStartHtmlElementComplete(String name) {
            for (HtmlElementHandler handler : this.elementHandlers) {
                if (!handler.onStartElement(name, this.attributes)) continue;
                this.handlerStack.addFirst(handler);
                this.tagStack.addFirst(name);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        void onEndHtmlElement(String name) {
            if (!this.tagStack.isEmpty() && this.tagStack.getFirst().equals(name)) {
                this.tagStack.removeFirst();
                this.handlerStack.removeFirst().onEndElement(name);
            }
        }

        @Override
        void onStartJavadocTag(String name) {
            this.tagValue = new StringBuilder();
        }

        @Override
        public void onText(String text) {
            if (this.tagValue != null) {
                this.tagValue.append(text);
                return;
            }
            if (!this.handlerStack.isEmpty()) {
                this.handlerStack.getFirst().onText(text);
                return;
            }
            this.nodes.appendChild(text);
        }

        @Override
        void onEndJavadocTag(String name) {
            for (JavadocTagHandler handler : this.tagHandlers) {
                if (!handler.onJavadocTag(name, this.tagValue.toString())) continue;
                this.tagValue = null;
                return;
            }
            throw new UnsupportedOperationException();
        }
    }

    public static final class DocCommentImpl
    implements DocComment {
        private final List<Element> docbook;

        public DocCommentImpl(List<Element> docbook) {
            this.docbook = docbook;
        }

        @Override
        public List<Element> getDocbook() {
            return this.docbook;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocCommentImpl)) {
                return false;
            }
            DocCommentImpl other = (DocCommentImpl)o;
            List<Element> this$docbook = this.getDocbook();
            List<Element> other$docbook = other.getDocbook();
            return !(this$docbook == null ? other$docbook != null : !((Object)this$docbook).equals(other$docbook));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Element> $docbook = this.getDocbook();
            result = result * 59 + ($docbook == null ? 43 : ((Object)$docbook).hashCode());
            return result;
        }

        public String toString() {
            return "JavadocConverter.DocCommentImpl(docbook=" + this.getDocbook() + ")";
        }
    }
}

