/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.JavadocLexer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class HtmlToXmlJavadocLexer
implements JavadocLexer {
    private final JavadocLexer lexer;
    private final Set<String> blockElements = new HashSet<String>();
    private final Set<String> blockContent = new HashSet<String>();

    public HtmlToXmlJavadocLexer(JavadocLexer lexer) {
        this.lexer = lexer;
        this.blockElements.add("p");
        this.blockElements.add("pre");
        this.blockElements.add("ul");
        this.blockElements.add("ol");
        this.blockElements.add("li");
        this.blockElements.add("h1");
        this.blockElements.add("h2");
        this.blockElements.add("h3");
        this.blockElements.add("h4");
        this.blockElements.add("h5");
        this.blockElements.add("h6");
        this.blockElements.add("table");
        this.blockElements.add("thead");
        this.blockElements.add("tbody");
        this.blockElements.add("tr");
        this.blockElements.add("dl");
        this.blockElements.add("dt");
        this.blockElements.add("dd");
        this.blockElements.add("blockquote");
        this.blockElements.add("span");
        this.blockContent.add("ul");
        this.blockContent.add("ol");
        this.blockContent.add("table");
        this.blockContent.add("thead");
        this.blockContent.add("tbody");
        this.blockContent.add("tr");
        this.blockContent.add("dl");
    }

    @Override
    public void visit(JavadocLexer.TokenVisitor visitor) {
        this.lexer.visit(new VisitorImpl(visitor));
    }

    private class VisitorImpl
    extends JavadocLexer.TokenVisitor {
        private final JavadocLexer.TokenVisitor visitor;
        private final LinkedList<String> elementStack = new LinkedList();
        private final Map<String, String> attributes = new HashMap<String, String>();

        public VisitorImpl(JavadocLexer.TokenVisitor visitor) {
            this.visitor = visitor;
        }

        private void unwindTo(String element, JavadocLexer.TokenVisitor visitor) {
            if (this.elementStack.contains(element)) {
                while (!this.elementStack.getFirst().equals(element)) {
                    visitor.onEndHtmlElement(this.elementStack.removeFirst());
                }
                this.elementStack.removeFirst();
                visitor.onEndHtmlElement(element);
            }
        }

        private void unwindTo(Collection<String> ancestors, JavadocLexer.TokenVisitor visitor) {
            for (int i = 0; i < this.elementStack.size(); ++i) {
                if (!ancestors.contains(this.elementStack.get(i))) continue;
                while (i > 0) {
                    visitor.onEndHtmlElement(this.elementStack.removeFirst());
                    --i;
                }
                break;
            }
        }

        @Override
        public void onStartHtmlElement(String name) {
            this.attributes.clear();
        }

        @Override
        public void onHtmlElementAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        @Override
        public void onStartHtmlElementComplete(String name) {
            if (name.equals("li")) {
                this.unwindTo(Arrays.asList("ul", "ol"), this.visitor);
            } else if (name.equals("dt") || name.endsWith("dd")) {
                this.unwindTo(Arrays.asList("dl"), this.visitor);
            } else if (name.equals("tr")) {
                this.unwindTo(Arrays.asList("table", "thead", "tbody"), this.visitor);
            } else if (name.equals("th") || name.endsWith("td")) {
                this.unwindTo(Arrays.asList("tr", "table", "thead", "tbody"), this.visitor);
            } else if (HtmlToXmlJavadocLexer.this.blockElements.contains(name)) {
                this.unwindTo("p", this.visitor);
            } else if (!(HtmlToXmlJavadocLexer.this.blockContent.contains(name) || name.equals("a") && this.attributes.containsKey("name"))) {
                this.onInlineContent();
            }
            this.elementStack.addFirst(name);
            this.visitor.onStartHtmlElement(name);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                this.visitor.onHtmlElementAttribute(entry.getKey(), entry.getValue());
            }
            this.attributes.clear();
            this.visitor.onStartHtmlElementComplete(name);
        }

        @Override
        public void onEndHtmlElement(String name) {
            this.unwindTo(name, this.visitor);
        }

        private void onInlineContent() {
            if (this.elementStack.isEmpty() || HtmlToXmlJavadocLexer.this.blockContent.contains(this.elementStack.getFirst())) {
                this.elementStack.addFirst("p");
                this.visitor.onStartHtmlElement("p");
                this.visitor.onStartHtmlElementComplete("p");
            }
        }

        @Override
        public void onStartJavadocTag(String name) {
            this.onInlineContent();
            this.visitor.onStartJavadocTag(name);
        }

        @Override
        public void onEndJavadocTag(String name) {
            this.onInlineContent();
            this.visitor.onEndJavadocTag(name);
        }

        @Override
        public void onText(String text) {
            boolean ws = text.matches("\\s*");
            if (!ws) {
                this.onInlineContent();
                this.visitor.onText(text);
            } else if (!this.elementStack.isEmpty() && !HtmlToXmlJavadocLexer.this.blockContent.contains(this.elementStack.getFirst())) {
                this.visitor.onText(text);
            }
        }

        @Override
        void onEnd() {
            while (!this.elementStack.isEmpty()) {
                this.visitor.onEndHtmlElement(this.elementStack.removeFirst());
            }
            this.visitor.onEnd();
        }
    }
}

