/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.DefaultGenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.DocLink;
import dev.gradleplugins.documentationkit.dsl.docbook.DslDocModel;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.source.model.EnumConstantMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import groovy.lang.GroovySystem;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocLinkBuilder {
    private final Document document;
    private final DslDocModel model;
    private final Set<String> primitiveTypes = new HashSet<String>();
    private final String groovyVersion;
    private final String javaVersion;

    public DocLinkBuilder(DslDocModel model, String groovyVersion, String javaVersion) {
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.model = model;
        this.groovyVersion = groovyVersion;
        this.javaVersion = javaVersion;
        this.primitiveTypes.add("boolean");
        this.primitiveTypes.add("byte");
        this.primitiveTypes.add("short");
        this.primitiveTypes.add("int");
        this.primitiveTypes.add("long");
        this.primitiveTypes.add("char");
        this.primitiveTypes.add("float");
        this.primitiveTypes.add("double");
        this.primitiveTypes.add("void");
    }

    public DocLinkBuilder(DslDocModel model) {
        this(model, GroovySystem.getVersion(), "8");
    }

    public DocLink link(TypeMetaData type) {
        return this.link(type, (GenerationListener)new DefaultGenerationListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocLink link(TypeMetaData type, final GenerationListener listener) {
        listener.start(String.format("type %s", type.getSignature()));
        try {
            final Element linkElement = this.document.createElement("classname");
            type.visitSignature(new TypeMetaData.SignatureVisitor(){

                @Override
                public void visitText(String text) {
                    linkElement.appendChild(DocLinkBuilder.this.document.createTextNode(text));
                }

                @Override
                public void visitType(String name) {
                    linkElement.appendChild(DocLinkBuilder.this.addType(name, listener));
                }
            });
            linkElement.normalize();
            if (linkElement.getChildNodes().getLength() == 1 && linkElement.getFirstChild() instanceof Element) {
                DocLinkImpl docLinkImpl = new DocLinkImpl((Element)linkElement.getFirstChild());
                return docLinkImpl;
            }
            DocLinkImpl docLinkImpl = new DocLinkImpl(linkElement);
            return docLinkImpl;
        }
        finally {
            listener.finish();
        }
    }

    private Node addType(String className, GenerationListener listener) {
        if (this.model.isKnownType(className)) {
            Element linkElement = this.document.createElement("apilink");
            linkElement.setAttribute("class", className);
            return linkElement;
        }
        if (this.primitiveTypes.contains(className)) {
            Element classNameElement = this.document.createElement("classname");
            classNameElement.appendChild(this.document.createTextNode(className));
            return classNameElement;
        }
        if (className.startsWith("java.")) {
            Element linkElement = this.document.createElement("ulink");
            linkElement.setAttribute("url", String.format("https://docs.oracle.com/javase/%s/docs/api/%s.html", this.javaVersion, className.replace(".", "/")));
            Element classNameElement = this.document.createElement("classname");
            classNameElement.appendChild(this.document.createTextNode(StringUtils.substringAfterLast((String)className, (String)".")));
            linkElement.appendChild(classNameElement);
            return linkElement;
        }
        if (className.startsWith("groovy.")) {
            Element linkElement = this.document.createElement("ulink");
            linkElement.setAttribute("url", String.format("https://docs.groovy-lang.org/%s/html/gapi/%s.html", this.groovyVersion, className.replace(".", "/")));
            Element classNameElement = this.document.createElement("classname");
            classNameElement.appendChild(this.document.createTextNode(StringUtils.substringAfterLast((String)className, (String)".")));
            linkElement.appendChild(classNameElement);
            return linkElement;
        }
        if (className.startsWith("org.gradle.")) {
            Element linkElement = this.document.createElement("ulink");
            linkElement.setAttribute("url", String.format("https://docs.gradle.org/%s/javadoc/%s.html", "6.2.1", className.replace(".", "/")));
            Element classNameElement = this.document.createElement("classname");
            classNameElement.appendChild(this.document.createTextNode(StringUtils.substringAfterLast((String)className, (String)".")));
            linkElement.appendChild(classNameElement);
            return linkElement;
        }
        if (className.length() > 1) {
            listener.warning(String.format("Could not generate link for unknown class '%s'", className));
        }
        Element element = this.document.createElement("classname");
        element.appendChild(this.document.createTextNode(className));
        return element;
    }

    public DocLink link(MethodMetaData method) {
        return this.link(method, (GenerationListener)new DefaultGenerationListener());
    }

    public DocLink link(MethodMetaData method, GenerationListener listener) {
        if (this.model.isKnownType(method.getOwnerClass().getClassName())) {
            Element apilink = this.document.createElement("apilink");
            apilink.setAttribute("class", method.getOwnerClass().getClassName());
            apilink.setAttribute("method", method.getOverrideSignature());
            return new DocLinkImpl(apilink);
        }
        listener.warning(String.format("Could not generate link for method %s", method));
        Element element = this.document.createElement("UNKNOWN-METHOD");
        element.appendChild(this.document.createTextNode(String.format("%s.%s()", method.getOwnerClass().getClassName(), method.getName())));
        return new DocLinkImpl(element);
    }

    public DocLink link(EnumConstantMetaData enumConstant, GenerationListener listener) {
        if (this.model.isKnownType(enumConstant.getOwnerClass().getClassName())) {
            Element apilink = this.document.createElement("apilink");
            apilink.setAttribute("class", enumConstant.getOwnerClass().getClassName());
            apilink.setAttribute("method", enumConstant.getName());
            return new DocLinkImpl(apilink);
        }
        listener.warning(String.format("Could not generate link for enum constant %s", enumConstant));
        Element element = this.document.createElement("UNKNOWN-ENUM");
        element.appendChild(this.document.createTextNode(enumConstant.toString()));
        return new DocLinkImpl(element);
    }

    public static final class DocLinkImpl
    implements DocLink {
        private final Element docbook;

        public DocLinkImpl(Element docbook) {
            this.docbook = docbook;
        }

        @Override
        public Element getDocbook() {
            return this.docbook;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocLinkImpl)) {
                return false;
            }
            DocLinkImpl other = (DocLinkImpl)o;
            Element this$docbook = this.getDocbook();
            Element other$docbook = other.getDocbook();
            return !(this$docbook == null ? other$docbook != null : !this$docbook.equals(other$docbook));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Element $docbook = this.getDocbook();
            result = result * 59 + ($docbook == null ? 43 : $docbook.hashCode());
            return result;
        }

        public String toString() {
            return "DocLinkBuilder.DocLinkImpl(docbook=" + this.getDocbook() + ")";
        }
    }
}

