/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class DocBookBuilder {
    final LinkedList<Element> stack = new LinkedList();
    final Document document;

    DocBookBuilder(Document document) {
        this.document = document;
        this.stack.addFirst(document.createElement("root"));
    }

    List<Element> getElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node node = this.stack.getLast().getFirstChild(); node != null; node = node.getNextSibling()) {
            elements.add((Element)node);
        }
        return elements;
    }

    public void appendChild(String text) {
        this.appendChild(this.document.createTextNode(text));
    }

    public void appendChild(Node node) {
        Element element;
        boolean inPara = false;
        if (node instanceof Element && (element = (Element)node).getTagName().equals("para") && this.stack.getFirst().getTagName().equals("para")) {
            this.pop();
            inPara = true;
        }
        this.stack.getFirst().appendChild(this.document.importNode(node, true));
        if (inPara) {
            Element para = this.document.createElement("para");
            this.push(para);
        }
    }

    public void push(Element element) {
        this.stack.getFirst().appendChild(element);
        this.stack.addFirst(element);
    }

    public Element pop() {
        Element element = this.stack.removeFirst();
        if (this.emptyPara(element)) {
            element.getParentNode().removeChild(element);
        }
        return element;
    }

    private boolean emptyPara(Element element) {
        if (!element.getTagName().equals("para")) {
            return false;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) {
                return false;
            }
            Text text = (Text)node;
            if (text.getTextContent().matches("\\s*")) continue;
            return false;
        }
        return true;
    }
}

