/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.documentationkit.dsl.docbook.DslDocModel;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocConverter;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDocSuperTypes;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ExtraAttributeDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.PropertyDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ClassDocPropertiesBuilder {
    private static final Logger LOG = Logging.getLogger(ClassDocPropertiesBuilder.class);
    private final JavadocConverter javadocConverter;
    private final GenerationListener listener;
    private final DslDocModel.ClassFile classFile;
    private final DslDocModel model;
    private final ClassMetaData classMetaData;

    void build(ClassDoc.Builder builder) {
        List<ClassDoc> superTypes = ClassDocSuperTypes.of(this.classMetaData, this.model).getSuperTypes();
        TreeMap<String, PropertyDoc> props = new TreeMap<String, PropertyDoc>();
        for (ClassDoc superType : superTypes) {
            LOG.info("Getting properties for {}", (Object)superType.getName());
            for (PropertyDoc propertyDoc : superType.getClassProperties()) {
                LinkedHashMap<String, ExtraAttributeDoc> additionalValues = new LinkedHashMap<String, ExtraAttributeDoc>();
                for (ExtraAttributeDoc attributeDoc : propertyDoc.getAdditionalValues()) {
                    String key = attributeDoc.getKey();
                    additionalValues.put(key, attributeDoc);
                }
                props.put(propertyDoc.getName(), propertyDoc.forClass(this.classMetaData, additionalValues.values()));
            }
        }
        for (String propName : this.classFile.getProperties()) {
            PropertyDoc overriddenProp;
            PropertyMetaData property = this.classMetaData.findProperty(propName);
            if (property == null) {
                throw new RuntimeException(String.format("No metadata for property '%s.%s'. Available properties: %s", this.classMetaData.getClassName(), propName, this.classMetaData.getPropertyNames()));
            }
            LinkedHashMap<String, ExtraAttributeDoc> additionalValues = new LinkedHashMap<String, ExtraAttributeDoc>();
            if (!superTypes.isEmpty() && (overriddenProp = (PropertyDoc)props.get(propName)) != null) {
                for (ExtraAttributeDoc attributeDoc : overriddenProp.getAdditionalValues()) {
                    additionalValues.put(attributeDoc.getKey(), attributeDoc);
                }
            }
            PropertyDoc propertyDoc = new PropertyDoc(this.classMetaData, property, this.javadocConverter.parse(property, this.listener), (List<ExtraAttributeDoc>)ImmutableList.copyOf(additionalValues.values()));
            props.put(propName, propertyDoc);
        }
        for (PropertyDoc propertyDoc : props.values()) {
            builder.withClassProperty(propertyDoc);
        }
    }

    public ClassDocPropertiesBuilder(JavadocConverter javadocConverter, GenerationListener listener, DslDocModel.ClassFile classFile, DslDocModel model, ClassMetaData classMetaData) {
        this.javadocConverter = javadocConverter;
        this.listener = listener;
        this.classFile = classFile;
        this.model = model;
        this.classMetaData = classMetaData;
    }
}

