/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.DocLinkBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.DslDocModel;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocConverter;
import dev.gradleplugins.documentationkit.dsl.docbook.model.BlockDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassExtensionDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassExtensionMetaData;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ExtensionMetaData;
import dev.gradleplugins.documentationkit.dsl.docbook.model.MethodDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.MixinMetaData;
import dev.gradleplugins.documentationkit.dsl.docbook.model.PropertyDoc;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.PropertyMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClassDocExtensionsBuilder {
    private final DslDocModel model;
    private final GenerationListener listener;
    private final ClassExtensionMetaData classExtensionMetaData;
    private final ClassMetaData classMetaData;

    public void build(ClassDoc.Builder builder) {
        ClassExtensionDoc classExtensionDoc;
        String pluginId;
        HashMap<String, ClassExtensionDoc> plugins = new HashMap<String, ClassExtensionDoc>();
        for (MixinMetaData mixin : this.classExtensionMetaData.getMixinClasses()) {
            pluginId = mixin.getPluginId();
            classExtensionDoc = (ClassExtensionDoc)plugins.get(pluginId);
            if (classExtensionDoc == null) {
                classExtensionDoc = new ClassExtensionDoc(pluginId, this.classMetaData);
                plugins.put(pluginId, classExtensionDoc);
            }
            classExtensionDoc.getMixinClasses().add(this.model.getClassDoc(mixin.getMixinClass()));
        }
        for (ExtensionMetaData extension : this.classExtensionMetaData.getExtensionClasses()) {
            pluginId = extension.getPluginId();
            classExtensionDoc = (ClassExtensionDoc)plugins.get(pluginId);
            if (classExtensionDoc == null) {
                classExtensionDoc = new ClassExtensionDoc(pluginId, this.classMetaData);
                plugins.put(pluginId, classExtensionDoc);
            }
            classExtensionDoc.getExtensionClasses().put(extension.getExtensionId(), this.model.getClassDoc(extension.getExtensionClass()));
        }
        for (ClassExtensionDoc extensionDoc : plugins.values()) {
            this.build(extensionDoc);
            builder.withClassExtension(extensionDoc);
        }
    }

    private void build(ClassExtensionDoc extensionDoc) {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DocLinkBuilder docLinkBuilder = new DocLinkBuilder(this.model);
        for (Map.Entry<String, ClassDoc> entry : extensionDoc.getExtensionClasses().entrySet()) {
            String id = entry.getKey();
            ClassDoc type = entry.getValue();
            PropertyMetaData propertyMetaData = new PropertyMetaData(id, extensionDoc.getTargetClassMetaData());
            propertyMetaData.setType(new TypeMetaData(type.getName()));
            Element para = doc.createElement("para");
            para.appendChild(doc.createTextNode("The "));
            para.appendChild(docLinkBuilder.link(propertyMetaData.getType(), this.listener).getDocbook());
            para.appendChild(doc.createTextNode(String.format(" added by the %s plugin.", extensionDoc.getPluginId())));
            JavadocConverter.DocCommentImpl commentProperty = new JavadocConverter.DocCommentImpl(Collections.singletonList(para));
            PropertyDoc propertyDoc = new PropertyDoc(this.classMetaData, propertyMetaData, commentProperty, Collections.emptyList());
            extensionDoc.getExtraProperties().add(propertyDoc);
            para = doc.createElement("para");
            para.appendChild(doc.createTextNode("Configures the "));
            para.appendChild(docLinkBuilder.link(propertyMetaData.getType(), this.listener).getDocbook());
            para.appendChild(doc.createTextNode(String.format(" added by the %s plugin.", extensionDoc.getPluginId())));
            JavadocConverter.DocCommentImpl commentMethod = new JavadocConverter.DocCommentImpl(Collections.singletonList(para));
            MethodMetaData methodMetaData = new MethodMetaData(id, extensionDoc.getTargetClassMetaData());
            methodMetaData.addParameter("configClosure", new TypeMetaData(Closure.class.getName()));
            MethodDoc methodDoc = new MethodDoc(this.classMetaData, methodMetaData, commentMethod);
            extensionDoc.getExtraBlocks().add(new BlockDoc(methodDoc, propertyDoc, propertyMetaData.getType(), false));
        }
    }

    public ClassDocExtensionsBuilder(DslDocModel model, GenerationListener listener, ClassExtensionMetaData classExtensionMetaData, ClassMetaData classMetaData) {
        this.model = model;
        this.listener = listener;
        this.classExtensionMetaData = classExtensionMetaData;
        this.classMetaData = classMetaData;
    }
}

