/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.docbook;

import dev.gradleplugins.documentationkit.dsl.docbook.ClassDocExtensionsBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.ClassDocMethodsBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.ClassDocPropertiesBuilder;
import dev.gradleplugins.documentationkit.dsl.docbook.DefaultGenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.DslDocModel;
import dev.gradleplugins.documentationkit.dsl.docbook.GenerationListener;
import dev.gradleplugins.documentationkit.dsl.docbook.JavadocConverter;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassDoc;
import dev.gradleplugins.documentationkit.dsl.docbook.model.ClassExtensionMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;

public class ClassDocBuilder {
    private final GenerationListener listener = new DefaultGenerationListener();
    private final ClassDocPropertiesBuilder propertiesBuilder;
    private final ClassDocMethodsBuilder methodsBuilder;
    private final ClassDocExtensionsBuilder extensionsBuilder;
    private final ClassMetaData classMetaData;

    public ClassDocBuilder(DslDocModel model, JavadocConverter javadocConverter, ClassMetaData classMetaData, DslDocModel.ClassFile classFile, ClassExtensionMetaData classExtensionMetaData) {
        this.classMetaData = classMetaData;
        this.propertiesBuilder = new ClassDocPropertiesBuilder(javadocConverter, this.listener, classFile, model, classMetaData);
        this.methodsBuilder = new ClassDocMethodsBuilder(javadocConverter, this.listener, classFile, classMetaData, model);
        this.extensionsBuilder = new ClassDocExtensionsBuilder(model, this.listener, classExtensionMetaData, classMetaData);
    }

    void build(ClassDoc.Builder classDoc) {
        this.listener.start(String.format("class %s", this.classMetaData.getClassName()));
        try {
            this.propertiesBuilder.build(classDoc);
            this.methodsBuilder.build(classDoc);
            this.extensionsBuilder.build(classDoc);
        }
        finally {
            this.listener.finish();
        }
    }
}

