/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit;

import dev.gradleplugins.documentationkit.TaskNamingScheme;
import dev.nokee.model.internal.core.ModelNode;
import dev.nokee.model.internal.core.ModelNodeContext;
import dev.nokee.platform.base.internal.tasks.TaskName;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public final class TaskRegistry {
    private final TaskContainer taskContainer;
    private final TaskNamingScheme namingScheme;

    public TaskRegistry(TaskContainer taskContainer) {
        this(taskContainer, TaskNamingScheme.identity());
    }

    public TaskRegistry(TaskContainer taskContainer, TaskNamingScheme namingScheme) {
        this.taskContainer = taskContainer;
        this.namingScheme = namingScheme;
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type) {
        return this.taskContainer.register(this.namingScheme.taskName(TaskName.of((String)name)), type, TaskRegistry.realizeNodeWhenGraphBuilt(type)::accept);
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type, Consumer<? super T> action) {
        return this.taskContainer.register(this.namingScheme.taskName(TaskName.of((String)name)), type, TaskRegistry.realizeNodeWhenGraphBuilt(type).andThen(action)::accept);
    }

    public <T extends Task> TaskProvider<T> register(TaskName name, Class<T> type) {
        return this.taskContainer.register(this.namingScheme.taskName(name), type, TaskRegistry.realizeNodeWhenGraphBuilt(type)::accept);
    }

    public <T extends Task> TaskProvider<T> register(TaskName name, Class<T> type, Consumer<? super T> action) {
        return this.taskContainer.register(this.namingScheme.taskName(name), type, TaskRegistry.realizeNodeWhenGraphBuilt(type).andThen(action)::accept);
    }

    private static <T extends Task> Consumer<T> realizeNodeWhenGraphBuilt(Class<T> type) {
        ModelNode node = ModelNodeContext.getCurrentModelNode();
        return task -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = TaskRegistry.alwaysReturnsEmptyList(() -> ((ModelNode)node).realize());
            task.dependsOn(objectArray);
        };
    }

    private static <T> Callable<List<T>> alwaysReturnsEmptyList(Supplier<?> supplier) {
        return () -> {
            supplier.get();
            return Collections.emptyList();
        };
    }
}

