/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.CamelCaseStyle;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Style;

public final class DependencySerializer {
    private final DependencyHandler dependencyFactory;

    public DependencySerializer(DependencyHandler dependencyFactory) {
        this.dependencyFactory = dependencyFactory;
    }

    public void serialize(List<Dependency> dependencies, File outputFile) throws Exception {
        CamelCaseStyle style = new CamelCaseStyle(false, false);
        Format format = new Format(3, "<?xml version=\"1.0\" encoding=\"utf-8\"?>", (Style)style);
        Registry registry = new Registry();
        RegistryStrategy strategy = new RegistryStrategy(registry);
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write((Object)Dependencies.of(dependencies), outputFile);
    }

    public List<Dependency> deserialize(File inputFile) throws Exception {
        CamelCaseStyle style = new CamelCaseStyle(false, false);
        Format format = new Format(3, "<?xml version=\"1.0\" encoding=\"utf-8\"?>", (Style)style);
        Registry registry = new Registry();
        RegistryStrategy strategy = new RegistryStrategy(registry);
        Persister serializer = new Persister((Strategy)strategy, format);
        return ((Dependencies)serializer.read(Dependencies.class, inputFile)).get().stream().map(it -> this.dependencyFactory.create((Object)String.format("%s:%s:%s", it.getGroupId(), it.getArtifactId(), it.getVersion()))).collect(Collectors.toList());
    }

    @Root
    public static final class Dependencies {
        @ElementList(inline=true, type=Dependency.class)
        private List<Dependency> dependencies;

        public Dependencies() {
        }

        public Dependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        public static Dependencies of(List<org.gradle.api.artifacts.Dependency> dependencies) {
            return new Dependencies(dependencies.stream().map(it -> new Dependency(it.getGroup(), it.getName(), it.getVersion())).collect(Collectors.toList()));
        }

        public List<Dependency> get() {
            return this.dependencies;
        }

        public String toString() {
            return "DependencySerializer.Dependencies(dependencies=" + this.dependencies + ")";
        }

        @Root
        public static final class Dependency {
            @Element
            private String groupId;
            @Element
            private String artifactId;
            @Element
            @Nullable
            private String version;

            public Dependency() {
            }

            public Dependency(String groupId, String artifactId, @Nullable String version) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
            }

            public String getGroupId() {
                return this.groupId;
            }

            public String getArtifactId() {
                return this.artifactId;
            }

            @Nullable
            public String getVersion() {
                return this.version;
            }

            public void setGroupId(String groupId) {
                this.groupId = groupId;
            }

            public void setArtifactId(String artifactId) {
                this.artifactId = artifactId;
            }

            public void setVersion(@Nullable String version) {
                this.version = version;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dependency)) {
                    return false;
                }
                Dependency other = (Dependency)o;
                String this$groupId = this.getGroupId();
                String other$groupId = other.getGroupId();
                if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                    return false;
                }
                String this$artifactId = this.getArtifactId();
                String other$artifactId = other.getArtifactId();
                if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $groupId = this.getGroupId();
                result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
                String $artifactId = this.getArtifactId();
                result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            public String toString() {
                return "DependencySerializer.Dependencies.Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
            }
        }
    }
}

