/*
 * Decompiled with CFR 0.152.
 */
package dev.gradienttim.ungh;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import dev.gradienttim.ungh.UnghEndpoint;
import dev.gradienttim.ungh.types.Branch;
import dev.gradienttim.ungh.types.BranchDto;
import dev.gradienttim.ungh.types.BranchFileDto;
import dev.gradienttim.ungh.types.BranchFilesDto;
import dev.gradienttim.ungh.types.Contributor;
import dev.gradienttim.ungh.types.ContributorDto;
import dev.gradienttim.ungh.types.Organization;
import dev.gradienttim.ungh.types.OrganizationDto;
import dev.gradienttim.ungh.types.OrganizationRepositoriesDto;
import dev.gradienttim.ungh.types.Release;
import dev.gradienttim.ungh.types.ReleaseDto;
import dev.gradienttim.ungh.types.ReleasesDto;
import dev.gradienttim.ungh.types.Repository;
import dev.gradienttim.ungh.types.RepositoryDto;
import dev.gradienttim.ungh.types.RepositoryReadMe;
import dev.gradienttim.ungh.types.StarsDto;
import dev.gradienttim.ungh.types.User;
import dev.gradienttim.ungh.types.UserDto;
import dev.gradienttim.ungh.types.UserQueryDto;
import dev.gradienttim.ungh.types.UserRepositoriesDto;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020(J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010.\u001a\u00020(J\u0018\u00102\u001a\u0004\u0018\u0001012\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(J(\u00104\u001a\u0004\u0018\u00010\u00162\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(2\u0006\u00105\u001a\u00020(2\u0006\u00106\u001a\u00020(J \u00107\u001a\u0004\u0018\u00010\u00142\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(2\u0006\u00105\u001a\u00020(J\u001c\u00108\u001a\b\u0012\u0004\u0012\u000209002\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020;002\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(J\u0018\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(J\u0018\u0010>\u001a\u0004\u0018\u00010\u00182\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020=002\u0006\u0010.\u001a\u00020(2\u0006\u00103\u001a\u00020(J\u0010\u0010@\u001a\u0004\u0018\u00010\u001e2\u0006\u00102\u001a\u00020(J\u0016\u0010@\u001a\u0004\u0018\u00010\u001e2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020(0BJ\u0010\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020(J\u0010\u0010F\u001a\u0004\u0018\u00010D2\u0006\u0010G\u001a\u00020(J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010E\u001a\u00020(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00100\u0010 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00120\u0012 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00140\u0014 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00160\u0016 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00180\u0018 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0019\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001a0\u001a \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001c0\u001c \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001d\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001e0\u001e \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001f\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010 0  \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010 0 \u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010!\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\"0\" \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\"0\"\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010#\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010$0$ \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010$0$\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Ldev/gradienttim/ungh/Ungh;", "", "()V", "HTTP_CLIENT", "Lokhttp3/OkHttpClient;", "MOSHI", "Lcom/squareup/moshi/Moshi;", "ORGANIZATION_ADAPTER", "Lcom/squareup/moshi/JsonAdapter;", "Ldev/gradienttim/ungh/types/OrganizationDto;", "kotlin.jvm.PlatformType", "ORGANIZATION_REPOSITORIES_ADAPTER", "Ldev/gradienttim/ungh/types/OrganizationRepositoriesDto;", "REPOSITORY_ADAPTER", "Ldev/gradienttim/ungh/types/RepositoryDto;", "REPOSITORY_BRANCHES_ADAPTER", "Ldev/gradienttim/ungh/types/BranchDto;", "REPOSITORY_CONTRIBUTORS_ADAPTER", "Ldev/gradienttim/ungh/types/ContributorDto;", "REPOSITORY_FILES_ADAPTER", "Ldev/gradienttim/ungh/types/BranchFilesDto;", "REPOSITORY_FILE_ADAPTER", "Ldev/gradienttim/ungh/types/BranchFileDto;", "REPOSITORY_README_ADAPTER", "Ldev/gradienttim/ungh/types/RepositoryReadMe;", "REPOSITORY_RELEASES_ADAPTER", "Ldev/gradienttim/ungh/types/ReleasesDto;", "REPOSITORY_RELEASE_ADAPTER", "Ldev/gradienttim/ungh/types/ReleaseDto;", "STARS_ADAPTER", "Ldev/gradienttim/ungh/types/StarsDto;", "USER_ADAPTER", "Ldev/gradienttim/ungh/types/UserDto;", "USER_QUERY_ADAPTER", "Ldev/gradienttim/ungh/types/UserQueryDto;", "USER_REPOSITORIES_ADAPTER", "Ldev/gradienttim/ungh/types/UserRepositoriesDto;", "createRequest", "Lokhttp3/Request;", "method", "", "url", "body", "Lokhttp3/RequestBody;", "organization", "Ldev/gradienttim/ungh/types/Organization;", "owner", "organizationRepositories", "", "Ldev/gradienttim/ungh/types/Repository;", "repository", "name", "repositoryBranchFile", "branch", "path", "repositoryBranchFiles", "repositoryBranches", "Ldev/gradienttim/ungh/types/Branch;", "repositoryContributors", "Ldev/gradienttim/ungh/types/Contributor;", "repositoryLatestRelease", "Ldev/gradienttim/ungh/types/Release;", "repositoryReadMe", "repositoryReleases", "stars", "repositories", "", "user", "Ldev/gradienttim/ungh/types/User;", "username", "userQuery", "query", "userRepositories", "ungh-kt"})
public final class Ungh {
    @NotNull
    public static final Ungh INSTANCE = new Ungh();
    @NotNull
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().build();
    @NotNull
    private static final Moshi MOSHI;
    private static final JsonAdapter<RepositoryDto> REPOSITORY_ADAPTER;
    private static final JsonAdapter<ContributorDto> REPOSITORY_CONTRIBUTORS_ADAPTER;
    private static final JsonAdapter<BranchDto> REPOSITORY_BRANCHES_ADAPTER;
    private static final JsonAdapter<BranchFilesDto> REPOSITORY_FILES_ADAPTER;
    private static final JsonAdapter<BranchFileDto> REPOSITORY_FILE_ADAPTER;
    private static final JsonAdapter<RepositoryReadMe> REPOSITORY_README_ADAPTER;
    private static final JsonAdapter<ReleasesDto> REPOSITORY_RELEASES_ADAPTER;
    private static final JsonAdapter<ReleaseDto> REPOSITORY_RELEASE_ADAPTER;
    private static final JsonAdapter<OrganizationDto> ORGANIZATION_ADAPTER;
    private static final JsonAdapter<OrganizationRepositoriesDto> ORGANIZATION_REPOSITORIES_ADAPTER;
    private static final JsonAdapter<StarsDto> STARS_ADAPTER;
    private static final JsonAdapter<UserDto> USER_ADAPTER;
    private static final JsonAdapter<UserRepositoriesDto> USER_REPOSITORIES_ADAPTER;
    private static final JsonAdapter<UserQueryDto> USER_QUERY_ADAPTER;

    private Ungh() {
    }

    private final Request createRequest(String method, String url, RequestBody body) {
        return new Request.Builder().addHeader("User-Agent", "UnghKt/1.0").method(method, body).url(url).build();
    }

    static /* synthetic */ Request createRequest$default(Ungh ungh, String string, String string2, RequestBody requestBody, int n, Object object) {
        if ((n & 4) != 0) {
            requestBody = null;
        }
        return ungh.createRequest(string, string2, requestBody);
    }

    @Nullable
    public final Repository repository(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            RepositoryDto repositoryDto = REPOSITORY_ADAPTER.fromJson(body.source());
            if (repositoryDto == null) {
                return null;
            }
            RepositoryDto dto = repositoryDto;
            return dto.getRepo();
        }
        return null;
    }

    @NotNull
    public final List<Contributor> repositoryContributors(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_CONTRIBUTORS.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return new ArrayList();
            }
            ResponseBody body = responseBody;
            ContributorDto contributorDto = REPOSITORY_CONTRIBUTORS_ADAPTER.fromJson(body.source());
            if (contributorDto == null) {
                return new ArrayList();
            }
            ContributorDto dto = contributorDto;
            return dto.getContributors();
        }
        return new ArrayList();
    }

    @Nullable
    public final BranchFilesDto repositoryBranchFiles(@NotNull String owner, @NotNull String name, @NotNull String branch) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(branch, "branch");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name), TuplesKt.to("branch", branch)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_FILES.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            return REPOSITORY_FILES_ADAPTER.fromJson(body.source());
        }
        return null;
    }

    @Nullable
    public final BranchFileDto repositoryBranchFile(@NotNull String owner, @NotNull String name, @NotNull String branch, @NotNull String path) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(branch, "branch");
        Intrinsics.checkNotNullParameter(path, "path");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name), TuplesKt.to("branch", branch), TuplesKt.to("path", path)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_FILE.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            return REPOSITORY_FILE_ADAPTER.fromJson(body.source());
        }
        return null;
    }

    @Nullable
    public final RepositoryReadMe repositoryReadMe(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_README.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            return REPOSITORY_README_ADAPTER.fromJson(body.source());
        }
        return null;
    }

    @NotNull
    public final List<Release> repositoryReleases(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_RELEASES.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return new ArrayList();
            }
            ResponseBody body = responseBody;
            ReleasesDto releasesDto = REPOSITORY_RELEASES_ADAPTER.fromJson(body.source());
            if (releasesDto == null) {
                return new ArrayList();
            }
            ReleasesDto dto = releasesDto;
            return dto.getReleases();
        }
        return new ArrayList();
    }

    @Nullable
    public final Release repositoryLatestRelease(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_RELEASES_LATEST.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            ReleaseDto releaseDto = REPOSITORY_RELEASE_ADAPTER.fromJson(body.source());
            if (releaseDto == null) {
                return null;
            }
            ReleaseDto dto = releaseDto;
            return dto.getRelease();
        }
        return null;
    }

    @NotNull
    public final List<Branch> repositoryBranches(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner), TuplesKt.to("name", name)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.REPOSITORY_BRANCHES.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return new ArrayList();
            }
            ResponseBody body = responseBody;
            BranchDto branchDto = REPOSITORY_BRANCHES_ADAPTER.fromJson(body.source());
            if (branchDto == null) {
                return new ArrayList();
            }
            BranchDto dto = branchDto;
            return dto.getBranches();
        }
        return new ArrayList();
    }

    @Nullable
    public final Organization organization(@NotNull String owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.ORGANISATION.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            OrganizationDto organizationDto = ORGANIZATION_ADAPTER.fromJson(body.source());
            if (organizationDto == null) {
                return null;
            }
            OrganizationDto dto = organizationDto;
            return dto.getOrg();
        }
        return null;
    }

    @NotNull
    public final List<Repository> organizationRepositories(@NotNull String owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Pair[] pairArray = new Pair[]{TuplesKt.to("owner", owner)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.ORGANISATION_REPOSITORIES.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return new ArrayList();
            }
            ResponseBody body = responseBody;
            OrganizationRepositoriesDto organizationRepositoriesDto = ORGANIZATION_REPOSITORIES_ADAPTER.fromJson(body.source());
            if (organizationRepositoriesDto == null) {
                return new ArrayList();
            }
            OrganizationRepositoriesDto dto = organizationRepositoriesDto;
            return dto.getRepos();
        }
        return new ArrayList();
    }

    @Nullable
    public final StarsDto stars(@NotNull String repository) {
        Intrinsics.checkNotNullParameter(repository, "repository");
        return this.stars(CollectionsKt.listOf(repository));
    }

    @Nullable
    public final StarsDto stars(@NotNull List<String> repositories) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        String urlQuery = CollectionsKt.joinToString$default(repositories, "+", null, null, 0, null, null, 62, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to("repositories", urlQuery)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.STARS_REPOSITORIES.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            return STARS_ADAPTER.fromJson(body.source());
        }
        return null;
    }

    @Nullable
    public final User user(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        Pair[] pairArray = new Pair[]{TuplesKt.to("username", username)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.USER.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            UserDto userDto = USER_ADAPTER.fromJson(body.source());
            if (userDto == null) {
                return null;
            }
            UserDto dto = userDto;
            return dto.getUser();
        }
        return null;
    }

    @NotNull
    public final List<Repository> userRepositories(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        Pair[] pairArray = new Pair[]{TuplesKt.to("username", username)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.USER_REPOSITORIES.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return new ArrayList();
            }
            ResponseBody body = responseBody;
            UserRepositoriesDto userRepositoriesDto = USER_REPOSITORIES_ADAPTER.fromJson(body.source());
            if (userRepositoriesDto == null) {
                return new ArrayList();
            }
            UserRepositoriesDto dto = userRepositoriesDto;
            return dto.getRepos();
        }
        return new ArrayList();
    }

    @Nullable
    public final User userQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter(query, "query");
        Pair[] pairArray = new Pair[]{TuplesKt.to("query", query)};
        Request request = Ungh.createRequest$default(this, "GET", UnghEndpoint.USER_QUERY.format(pairArray), null, 4, null);
        Response response = HTTP_CLIENT.newCall(request).execute();
        if (response.code() == 200) {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            ResponseBody body = responseBody;
            UserQueryDto userQueryDto = USER_QUERY_ADAPTER.fromJson(body.source());
            if (userQueryDto == null) {
                return null;
            }
            UserQueryDto dto = userQueryDto;
            return dto.getUser();
        }
        return null;
    }

    static {
        Moshi moshi = new Moshi.Builder().addLast(new KotlinJsonAdapterFactory()).build();
        Intrinsics.checkNotNullExpressionValue(moshi, "build(...)");
        MOSHI = moshi;
        REPOSITORY_ADAPTER = MOSHI.adapter(RepositoryDto.class);
        REPOSITORY_CONTRIBUTORS_ADAPTER = MOSHI.adapter(ContributorDto.class);
        REPOSITORY_BRANCHES_ADAPTER = MOSHI.adapter(BranchDto.class);
        REPOSITORY_FILES_ADAPTER = MOSHI.adapter(BranchFilesDto.class);
        REPOSITORY_FILE_ADAPTER = MOSHI.adapter(BranchFileDto.class);
        REPOSITORY_README_ADAPTER = MOSHI.adapter(RepositoryReadMe.class);
        REPOSITORY_RELEASES_ADAPTER = MOSHI.adapter(ReleasesDto.class);
        REPOSITORY_RELEASE_ADAPTER = MOSHI.adapter(ReleaseDto.class);
        ORGANIZATION_ADAPTER = MOSHI.adapter(OrganizationDto.class);
        ORGANIZATION_REPOSITORIES_ADAPTER = MOSHI.adapter(OrganizationRepositoriesDto.class);
        STARS_ADAPTER = MOSHI.adapter(StarsDto.class);
        USER_ADAPTER = MOSHI.adapter(UserDto.class);
        USER_REPOSITORIES_ADAPTER = MOSHI.adapter(UserRepositoriesDto.class);
        USER_QUERY_ADAPTER = MOSHI.adapter(UserQueryDto.class);
    }
}

