/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

abstract class CollectionJsonAdapter<C extends Collection<T>, T>
extends JsonAdapter<C> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        @Nullable
        public JsonAdapter<?> create(Type type2, Set<? extends Annotation> annotations2, Moshi moshi) {
            Class<?> rawType = Types.getRawType(type2);
            if (!annotations2.isEmpty()) {
                return null;
            }
            if (rawType == List.class || rawType == Collection.class) {
                return CollectionJsonAdapter.newArrayListAdapter(type2, moshi).nullSafe();
            }
            if (rawType == Set.class) {
                return CollectionJsonAdapter.newLinkedHashSetAdapter(type2, moshi).nullSafe();
            }
            return null;
        }
    };
    private final JsonAdapter<T> elementAdapter;

    private CollectionJsonAdapter(JsonAdapter<T> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    static <T> JsonAdapter<Collection<T>> newArrayListAdapter(Type type2, Moshi moshi) {
        Type elementType = Types.collectionElementType(type2, Collection.class);
        JsonAdapter elementAdapter = moshi.adapter(elementType);
        return new CollectionJsonAdapter<Collection<T>, T>(elementAdapter){

            @Override
            Collection<T> newCollection() {
                return new ArrayList();
            }
        };
    }

    static <T> JsonAdapter<Set<T>> newLinkedHashSetAdapter(Type type2, Moshi moshi) {
        Type elementType = Types.collectionElementType(type2, Collection.class);
        JsonAdapter elementAdapter = moshi.adapter(elementType);
        return new CollectionJsonAdapter<Set<T>, T>(elementAdapter){

            @Override
            Set<T> newCollection() {
                return new LinkedHashSet();
            }
        };
    }

    abstract C newCollection();

    @Override
    public C fromJson(JsonReader reader) throws IOException {
        C result = this.newCollection();
        reader.beginArray();
        while (reader.hasNext()) {
            result.add(this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        return result;
    }

    @Override
    public void toJson(JsonWriter writer, C value) throws IOException {
        writer.beginArray();
        for (Object element : value) {
            this.elementAdapter.toJson(writer, element);
        }
        writer.endArray();
    }

    public String toString() {
        return this.elementAdapter + ".collection()";
    }
}

