@file:Suppress("unused")

package dev.fritz2.core

import kotlinx.coroutines.flow.Flow
import org.w3c.dom.*
import org.w3c.fetch.RequestDestination

fun SvgTag.viewBox(value: String) = attr("viewBox", value)
fun SvgTag.viewBox(value: Flow<String>) = attr("viewBox", value)

fun SvgTag.fill(value: String) = attr("fill", value)
fun SvgTag.fill(value: Flow<String>) = attr("fill", value)

fun SvgTag.d(value: String) = attr("d", value)
fun SvgTag.d(value: Flow<String>) = attr("d", value)

/*
 * Generated by https://github.com/chausknecht/HtmlTagAttributesExtractor
 * Pay attention to local modifications before pasting an updated output here!
 * Add manual extensions above this section (like the SVG attributes).
 */

/*
 * HTMLElement attributes
 */
fun Tag<HTMLElement>.title(value: String) = attr("title", value)
fun Tag<HTMLElement>.title(value: Flow<String>) = attr("title", value)

fun Tag<HTMLElement>.lang(value: String) = attr("lang", value)
fun Tag<HTMLElement>.lang(value: Flow<String>) = attr("lang", value)

fun Tag<HTMLElement>.translate(value: Boolean, trueValue: String = "") = attr("translate", value, trueValue)
fun Tag<HTMLElement>.translate(value: Flow<Boolean>, trueValue: String = "") = attr("translate", value, trueValue)

fun Tag<HTMLElement>.dir(value: String) = attr("dir", value)
fun Tag<HTMLElement>.dir(value: Flow<String>) = attr("dir", value)

fun Tag<HTMLElement>.hidden(value: Boolean, trueValue: String = "") = attr("hidden", value, trueValue)
fun Tag<HTMLElement>.hidden(value: Flow<Boolean>, trueValue: String = "") = attr("hidden", value, trueValue)

fun Tag<HTMLElement>.tabIndex(value: Int) = attr("tabindex", value)
fun Tag<HTMLElement>.tabIndex(value: Flow<Int>) = attr("tabindex", value)

fun Tag<HTMLElement>.accessKey(value: String) = attr("accesskey", value)
fun Tag<HTMLElement>.accessKey(value: Flow<String>) = attr("accesskey", value)

fun Tag<HTMLElement>.draggable(value: Boolean, trueValue: String = "") = attr("draggable", value, trueValue)
fun Tag<HTMLElement>.draggable(value: Flow<Boolean>, trueValue: String = "") = attr("draggable", value, trueValue)

fun Tag<HTMLElement>.contextMenu(value: HTMLMenuElement?) = attr("contextmenu", value)
fun Tag<HTMLElement>.contextMenu(value: Flow<HTMLMenuElement?>) = attr("contextmenu", value)

fun Tag<HTMLElement>.spellcheck(value: Boolean, trueValue: String = "") = attr("spellcheck", value, trueValue)
fun Tag<HTMLElement>.spellcheck(value: Flow<Boolean>, trueValue: String = "") = attr("spellcheck", value, trueValue)

fun Tag<HTMLElement>.innerText(value: String) = attr("innertext", value)
fun Tag<HTMLElement>.innerText(value: Flow<String>) = attr("innertext", value)

// inherited attributes from supertype Element
fun Tag<HTMLElement>.id(value: String) = attr("id", value)
fun Tag<HTMLElement>.id(value: Flow<String>) = attr("id", value)

fun Tag<HTMLElement>.slot(value: String) = attr("slot", value)
fun Tag<HTMLElement>.slot(value: Flow<String>) = attr("slot", value)

fun Tag<HTMLElement>.scrollTop(value: Double) = attr("scrolltop", value)
fun Tag<HTMLElement>.scrollTop(value: Flow<Double>) = attr("scrolltop", value)

fun Tag<HTMLElement>.scrollLeft(value: Double) = attr("scrollleft", value)
fun Tag<HTMLElement>.scrollLeft(value: Flow<Double>) = attr("scrollleft", value)

fun Tag<HTMLElement>.innerHTML(value: String) = attr("innerhtml", value)
fun Tag<HTMLElement>.innerHTML(value: Flow<String>) = attr("innerhtml", value)

fun Tag<HTMLElement>.outerHTML(value: String) = attr("outerhtml", value)
fun Tag<HTMLElement>.outerHTML(value: Flow<String>) = attr("outerhtml", value)

// inherited attributes from supertype Node
fun Tag<HTMLElement>.nodeValue(value: String?) = attr("nodevalue", value)
fun Tag<HTMLElement>.nodeValue(value: Flow<String?>) = attr("nodevalue", value)

fun Tag<HTMLElement>.textContent(value: String?) = attr("textcontent", value)
fun Tag<HTMLElement>.textContent(value: Flow<String?>) = attr("textcontent", value)

// inherited attributes from supertype ElementContentEditable
fun Tag<HTMLElement>.contentEditable(value: String) = attr("contenteditable", value)
fun Tag<HTMLElement>.contentEditable(value: Flow<String>) = attr("contenteditable", value)


/*
 * HTMLBaseElement attributes
 */
fun Tag<HTMLBaseElement>.href(value: String) = attr("href", value)
fun Tag<HTMLBaseElement>.href(value: Flow<String>) = attr("href", value)

fun Tag<HTMLBaseElement>.target(value: String) = attr("target", value)
fun Tag<HTMLBaseElement>.target(value: Flow<String>) = attr("target", value)


/*
 * HTMLLinkElement attributes
 */
fun Tag<HTMLLinkElement>.href(value: String) = attr("href", value)
fun Tag<HTMLLinkElement>.href(value: Flow<String>) = attr("href", value)

fun Tag<HTMLLinkElement>.crossOrigin(value: String?) = attr("crossorigin", value)
fun Tag<HTMLLinkElement>.crossOrigin(value: Flow<String?>) = attr("crossorigin", value)

fun Tag<HTMLLinkElement>.rel(value: String) = attr("rel", value)
fun Tag<HTMLLinkElement>.rel(value: Flow<String>) = attr("rel", value)

fun Tag<HTMLLinkElement>.`as`(value: RequestDestination) = attr("as", value)
fun Tag<HTMLLinkElement>.`as`(value: Flow<RequestDestination>) = attr("as", value)

fun Tag<HTMLLinkElement>.media(value: String) = attr("media", value)
fun Tag<HTMLLinkElement>.media(value: Flow<String>) = attr("media", value)

fun Tag<HTMLLinkElement>.nonce(value: String) = attr("nonce", value)
fun Tag<HTMLLinkElement>.nonce(value: Flow<String>) = attr("nonce", value)

fun Tag<HTMLLinkElement>.hreflang(value: String) = attr("hreflang", value)
fun Tag<HTMLLinkElement>.hreflang(value: Flow<String>) = attr("hreflang", value)

fun Tag<HTMLLinkElement>.type(value: String) = attr("type", value)
fun Tag<HTMLLinkElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLLinkElement>.referrerPolicy(value: String) = attr("referrerpolicy", value)
fun Tag<HTMLLinkElement>.referrerPolicy(value: Flow<String>) = attr("referrerpolicy", value)

fun Tag<HTMLLinkElement>.charset(value: String) = attr("charset", value)
fun Tag<HTMLLinkElement>.charset(value: Flow<String>) = attr("charset", value)

fun Tag<HTMLLinkElement>.rev(value: String) = attr("rev", value)
fun Tag<HTMLLinkElement>.rev(value: Flow<String>) = attr("rev", value)

fun Tag<HTMLLinkElement>.target(value: String) = attr("target", value)
fun Tag<HTMLLinkElement>.target(value: Flow<String>) = attr("target", value)

fun Tag<HTMLLinkElement>.scope(value: String) = attr("scope", value)
fun Tag<HTMLLinkElement>.scope(value: Flow<String>) = attr("scope", value)

fun Tag<HTMLLinkElement>.workerType(value: WorkerType) = attr("workertype", value)
fun Tag<HTMLLinkElement>.workerType(value: Flow<WorkerType>) = attr("workertype", value)


/*
 * HTMLMetaElement attributes
 */
fun Tag<HTMLMetaElement>.name(value: String) = attr("name", value)
fun Tag<HTMLMetaElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLMetaElement>.httpEquiv(value: String) = attr("httpequiv", value)
fun Tag<HTMLMetaElement>.httpEquiv(value: Flow<String>) = attr("httpequiv", value)

fun Tag<HTMLMetaElement>.content(value: String) = attr("content", value)
fun Tag<HTMLMetaElement>.content(value: Flow<String>) = attr("content", value)

fun Tag<HTMLMetaElement>.scheme(value: String) = attr("scheme", value)
fun Tag<HTMLMetaElement>.scheme(value: Flow<String>) = attr("scheme", value)


/*
 * HTMLStyleElement attributes
 */
fun Tag<HTMLStyleElement>.media(value: String) = attr("media", value)
fun Tag<HTMLStyleElement>.media(value: Flow<String>) = attr("media", value)

fun Tag<HTMLStyleElement>.nonce(value: String) = attr("nonce", value)
fun Tag<HTMLStyleElement>.nonce(value: Flow<String>) = attr("nonce", value)

fun Tag<HTMLStyleElement>.type(value: String) = attr("type", value)
fun Tag<HTMLStyleElement>.type(value: Flow<String>) = attr("type", value)


/*
 * HTMLBodyElement attributes
 */
fun Tag<HTMLBodyElement>.link(value: String) = attr("link", value)
fun Tag<HTMLBodyElement>.link(value: Flow<String>) = attr("link", value)

fun Tag<HTMLBodyElement>.vLink(value: String) = attr("vlink", value)
fun Tag<HTMLBodyElement>.vLink(value: Flow<String>) = attr("vlink", value)

fun Tag<HTMLBodyElement>.aLink(value: String) = attr("alink", value)
fun Tag<HTMLBodyElement>.aLink(value: Flow<String>) = attr("alink", value)

fun Tag<HTMLBodyElement>.bgColor(value: String) = attr("bgcolor", value)
fun Tag<HTMLBodyElement>.bgColor(value: Flow<String>) = attr("bgcolor", value)

fun Tag<HTMLBodyElement>.background(value: String) = attr("background", value)
fun Tag<HTMLBodyElement>.background(value: Flow<String>) = attr("background", value)


/*
 * HTMLHeadingElement attributes
 */
fun Tag<HTMLHeadingElement>.align(value: String) = attr("align", value)
fun Tag<HTMLHeadingElement>.align(value: Flow<String>) = attr("align", value)


/*
 * HTMLParagraphElement attributes
 */
fun Tag<HTMLParagraphElement>.align(value: String) = attr("align", value)
fun Tag<HTMLParagraphElement>.align(value: Flow<String>) = attr("align", value)


/*
 * HTMLHRElement attributes
 */
fun Tag<HTMLHRElement>.align(value: String) = attr("align", value)
fun Tag<HTMLHRElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLHRElement>.color(value: String) = attr("color", value)
fun Tag<HTMLHRElement>.color(value: Flow<String>) = attr("color", value)

fun Tag<HTMLHRElement>.noShade(value: Boolean, trueValue: String = "") = attr("noshade", value, trueValue)
fun Tag<HTMLHRElement>.noShade(value: Flow<Boolean>, trueValue: String = "") = attr("noshade", value, trueValue)

fun Tag<HTMLHRElement>.size(value: String) = attr("size", value)
fun Tag<HTMLHRElement>.size(value: Flow<String>) = attr("size", value)

fun Tag<HTMLHRElement>.width(value: String) = attr("width", value)
fun Tag<HTMLHRElement>.width(value: Flow<String>) = attr("width", value)


/*
 * HTMLPreElement attributes
 */
fun Tag<HTMLPreElement>.width(value: Int) = attr("width", value)
fun Tag<HTMLPreElement>.width(value: Flow<Int>) = attr("width", value)


/*
 * HTMLQuoteElement attributes
 */
fun Tag<HTMLQuoteElement>.cite(value: String) = attr("cite", value)
fun Tag<HTMLQuoteElement>.cite(value: Flow<String>) = attr("cite", value)


/*
 * HTMLOListElement attributes
 */
fun Tag<HTMLOListElement>.reversed(value: Boolean, trueValue: String = "") = attr("reversed", value, trueValue)
fun Tag<HTMLOListElement>.reversed(value: Flow<Boolean>, trueValue: String = "") = attr("reversed", value, trueValue)

fun Tag<HTMLOListElement>.start(value: Int) = attr("start", value)
fun Tag<HTMLOListElement>.start(value: Flow<Int>) = attr("start", value)

fun Tag<HTMLOListElement>.type(value: String) = attr("type", value)
fun Tag<HTMLOListElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLOListElement>.compact(value: Boolean, trueValue: String = "") = attr("compact", value, trueValue)
fun Tag<HTMLOListElement>.compact(value: Flow<Boolean>, trueValue: String = "") = attr("compact", value, trueValue)


/*
 * HTMLUListElement attributes
 */
fun Tag<HTMLUListElement>.compact(value: Boolean, trueValue: String = "") = attr("compact", value, trueValue)
fun Tag<HTMLUListElement>.compact(value: Flow<Boolean>, trueValue: String = "") = attr("compact", value, trueValue)

fun Tag<HTMLUListElement>.type(value: String) = attr("type", value)
fun Tag<HTMLUListElement>.type(value: Flow<String>) = attr("type", value)


/*
 * HTMLLIElement attributes
 */
fun Tag<HTMLLIElement>.value(value: Int) = attr("value", value)
fun Tag<HTMLLIElement>.value(value: Flow<Int>) = attr("value", value)

fun Tag<HTMLLIElement>.type(value: String) = attr("type", value)
fun Tag<HTMLLIElement>.type(value: Flow<String>) = attr("type", value)


/*
 * HTMLDListElement attributes
 */
fun Tag<HTMLDListElement>.compact(value: Boolean, trueValue: String = "") = attr("compact", value, trueValue)
fun Tag<HTMLDListElement>.compact(value: Flow<Boolean>, trueValue: String = "") = attr("compact", value, trueValue)


/*
 * HTMLDivElement attributes
 */
fun Tag<HTMLDivElement>.align(value: String) = attr("align", value)
fun Tag<HTMLDivElement>.align(value: Flow<String>) = attr("align", value)


/*
 * HTMLAnchorElement attributes
 */
fun Tag<HTMLAnchorElement>.target(value: String) = attr("target", value)
fun Tag<HTMLAnchorElement>.target(value: Flow<String>) = attr("target", value)

fun Tag<HTMLAnchorElement>.download(value: String) = attr("download", value)
fun Tag<HTMLAnchorElement>.download(value: Flow<String>) = attr("download", value)

fun Tag<HTMLAnchorElement>.ping(value: String) = attr("ping", value)
fun Tag<HTMLAnchorElement>.ping(value: Flow<String>) = attr("ping", value)

fun Tag<HTMLAnchorElement>.rel(value: String) = attr("rel", value)
fun Tag<HTMLAnchorElement>.rel(value: Flow<String>) = attr("rel", value)

fun Tag<HTMLAnchorElement>.hreflang(value: String) = attr("hreflang", value)
fun Tag<HTMLAnchorElement>.hreflang(value: Flow<String>) = attr("hreflang", value)

fun Tag<HTMLAnchorElement>.type(value: String) = attr("type", value)
fun Tag<HTMLAnchorElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLAnchorElement>.referrerPolicy(value: String) = attr("referrerpolicy", value)
fun Tag<HTMLAnchorElement>.referrerPolicy(value: Flow<String>) = attr("referrerpolicy", value)

fun Tag<HTMLAnchorElement>.coords(value: String) = attr("coords", value)
fun Tag<HTMLAnchorElement>.coords(value: Flow<String>) = attr("coords", value)

fun Tag<HTMLAnchorElement>.charset(value: String) = attr("charset", value)
fun Tag<HTMLAnchorElement>.charset(value: Flow<String>) = attr("charset", value)

fun Tag<HTMLAnchorElement>.name(value: String) = attr("name", value)
fun Tag<HTMLAnchorElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLAnchorElement>.rev(value: String) = attr("rev", value)
fun Tag<HTMLAnchorElement>.rev(value: Flow<String>) = attr("rev", value)

fun Tag<HTMLAnchorElement>.shape(value: String) = attr("shape", value)
fun Tag<HTMLAnchorElement>.shape(value: Flow<String>) = attr("shape", value)

// inherited attributes from supertype HTMLHyperlinkElementUtils
fun Tag<HTMLAnchorElement>.href(value: String) = attr("href", value)
fun Tag<HTMLAnchorElement>.href(value: Flow<String>) = attr("href", value)

fun Tag<HTMLAnchorElement>.protocol(value: String) = attr("protocol", value)
fun Tag<HTMLAnchorElement>.protocol(value: Flow<String>) = attr("protocol", value)

fun Tag<HTMLAnchorElement>.username(value: String) = attr("username", value)
fun Tag<HTMLAnchorElement>.username(value: Flow<String>) = attr("username", value)

fun Tag<HTMLAnchorElement>.password(value: String) = attr("password", value)
fun Tag<HTMLAnchorElement>.password(value: Flow<String>) = attr("password", value)

fun Tag<HTMLAnchorElement>.host(value: String) = attr("host", value)
fun Tag<HTMLAnchorElement>.host(value: Flow<String>) = attr("host", value)

fun Tag<HTMLAnchorElement>.hostname(value: String) = attr("hostname", value)
fun Tag<HTMLAnchorElement>.hostname(value: Flow<String>) = attr("hostname", value)

fun Tag<HTMLAnchorElement>.port(value: String) = attr("port", value)
fun Tag<HTMLAnchorElement>.port(value: Flow<String>) = attr("port", value)

fun Tag<HTMLAnchorElement>.pathname(value: String) = attr("pathname", value)
fun Tag<HTMLAnchorElement>.pathname(value: Flow<String>) = attr("pathname", value)

fun Tag<HTMLAnchorElement>.search(value: String) = attr("search", value)
fun Tag<HTMLAnchorElement>.search(value: Flow<String>) = attr("search", value)

fun Tag<HTMLAnchorElement>.hash(value: String) = attr("hash", value)
fun Tag<HTMLAnchorElement>.hash(value: Flow<String>) = attr("hash", value)


/*
 * HTMLDataElement attributes
 */
fun Tag<HTMLDataElement>.value(value: String) = attr("value", value)
fun Tag<HTMLDataElement>.value(value: Flow<String>) = attr("value", value)


/*
 * HTMLTimeElement attributes
 */
fun Tag<HTMLTimeElement>.dateTime(value: String) = attr("datetime", value)
fun Tag<HTMLTimeElement>.dateTime(value: Flow<String>) = attr("datetime", value)


/*
 * HTMLBRElement attributes
 */
fun Tag<HTMLBRElement>.clear(value: String) = attr("clear", value)
fun Tag<HTMLBRElement>.clear(value: Flow<String>) = attr("clear", value)


/*
 * HTMLModElement attributes
 */
fun Tag<HTMLModElement>.cite(value: String) = attr("cite", value)
fun Tag<HTMLModElement>.cite(value: Flow<String>) = attr("cite", value)

fun Tag<HTMLModElement>.dateTime(value: String) = attr("datetime", value)
fun Tag<HTMLModElement>.dateTime(value: Flow<String>) = attr("datetime", value)


/*
 * HTMLSourceElement attributes
 */
fun Tag<HTMLSourceElement>.src(value: String) = attr("src", value)
fun Tag<HTMLSourceElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLSourceElement>.type(value: String) = attr("type", value)
fun Tag<HTMLSourceElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLSourceElement>.srcset(value: String) = attr("srcset", value)
fun Tag<HTMLSourceElement>.srcset(value: Flow<String>) = attr("srcset", value)

fun Tag<HTMLSourceElement>.sizes(value: String) = attr("sizes", value)
fun Tag<HTMLSourceElement>.sizes(value: Flow<String>) = attr("sizes", value)

fun Tag<HTMLSourceElement>.media(value: String) = attr("media", value)
fun Tag<HTMLSourceElement>.media(value: Flow<String>) = attr("media", value)


/*
 * HTMLImageElement attributes
 */
fun Tag<HTMLImageElement>.alt(value: String) = attr("alt", value)
fun Tag<HTMLImageElement>.alt(value: Flow<String>) = attr("alt", value)

fun Tag<HTMLImageElement>.src(value: String) = attr("src", value)
fun Tag<HTMLImageElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLImageElement>.srcset(value: String) = attr("srcset", value)
fun Tag<HTMLImageElement>.srcset(value: Flow<String>) = attr("srcset", value)

fun Tag<HTMLImageElement>.sizes(value: String) = attr("sizes", value)
fun Tag<HTMLImageElement>.sizes(value: Flow<String>) = attr("sizes", value)

fun Tag<HTMLImageElement>.crossOrigin(value: String?) = attr("crossorigin", value)
fun Tag<HTMLImageElement>.crossOrigin(value: Flow<String?>) = attr("crossorigin", value)

fun Tag<HTMLImageElement>.useMap(value: String) = attr("usemap", value)
fun Tag<HTMLImageElement>.useMap(value: Flow<String>) = attr("usemap", value)

fun Tag<HTMLImageElement>.isMap(value: Boolean, trueValue: String = "") = attr("ismap", value, trueValue)
fun Tag<HTMLImageElement>.isMap(value: Flow<Boolean>, trueValue: String = "") = attr("ismap", value, trueValue)

fun Tag<HTMLImageElement>.width(value: Int) = attr("width", value)
fun Tag<HTMLImageElement>.width(value: Flow<Int>) = attr("width", value)

fun Tag<HTMLImageElement>.height(value: Int) = attr("height", value)
fun Tag<HTMLImageElement>.height(value: Flow<Int>) = attr("height", value)

fun Tag<HTMLImageElement>.referrerPolicy(value: String) = attr("referrerpolicy", value)
fun Tag<HTMLImageElement>.referrerPolicy(value: Flow<String>) = attr("referrerpolicy", value)

fun Tag<HTMLImageElement>.name(value: String) = attr("name", value)
fun Tag<HTMLImageElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLImageElement>.lowsrc(value: String) = attr("lowsrc", value)
fun Tag<HTMLImageElement>.lowsrc(value: Flow<String>) = attr("lowsrc", value)

fun Tag<HTMLImageElement>.align(value: String) = attr("align", value)
fun Tag<HTMLImageElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLImageElement>.hspace(value: Int) = attr("hspace", value)
fun Tag<HTMLImageElement>.hspace(value: Flow<Int>) = attr("hspace", value)

fun Tag<HTMLImageElement>.vspace(value: Int) = attr("vspace", value)
fun Tag<HTMLImageElement>.vspace(value: Flow<Int>) = attr("vspace", value)

fun Tag<HTMLImageElement>.longDesc(value: String) = attr("longdesc", value)
fun Tag<HTMLImageElement>.longDesc(value: Flow<String>) = attr("longdesc", value)

fun Tag<HTMLImageElement>.border(value: String) = attr("border", value)
fun Tag<HTMLImageElement>.border(value: Flow<String>) = attr("border", value)


/*
 * HTMLIFrameElement attributes
 */
fun Tag<HTMLIFrameElement>.src(value: String) = attr("src", value)
fun Tag<HTMLIFrameElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLIFrameElement>.srcdoc(value: String) = attr("srcdoc", value)
fun Tag<HTMLIFrameElement>.srcdoc(value: Flow<String>) = attr("srcdoc", value)

fun Tag<HTMLIFrameElement>.name(value: String) = attr("name", value)
fun Tag<HTMLIFrameElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLIFrameElement>.allowFullscreen(value: Boolean, trueValue: String = "") = attr("allowfullscreen", value, trueValue)
fun Tag<HTMLIFrameElement>.allowFullscreen(value: Flow<Boolean>, trueValue: String = "") = attr("allowfullscreen", value, trueValue)

fun Tag<HTMLIFrameElement>.allowUserMedia(value: Boolean, trueValue: String = "") = attr("allowusermedia", value, trueValue)
fun Tag<HTMLIFrameElement>.allowUserMedia(value: Flow<Boolean>, trueValue: String = "") = attr("allowusermedia", value, trueValue)

fun Tag<HTMLIFrameElement>.width(value: String) = attr("width", value)
fun Tag<HTMLIFrameElement>.width(value: Flow<String>) = attr("width", value)

fun Tag<HTMLIFrameElement>.height(value: String) = attr("height", value)
fun Tag<HTMLIFrameElement>.height(value: Flow<String>) = attr("height", value)

fun Tag<HTMLIFrameElement>.referrerPolicy(value: String) = attr("referrerpolicy", value)
fun Tag<HTMLIFrameElement>.referrerPolicy(value: Flow<String>) = attr("referrerpolicy", value)

fun Tag<HTMLIFrameElement>.align(value: String) = attr("align", value)
fun Tag<HTMLIFrameElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLIFrameElement>.scrolling(value: String) = attr("scrolling", value)
fun Tag<HTMLIFrameElement>.scrolling(value: Flow<String>) = attr("scrolling", value)

fun Tag<HTMLIFrameElement>.frameBorder(value: String) = attr("frameborder", value)
fun Tag<HTMLIFrameElement>.frameBorder(value: Flow<String>) = attr("frameborder", value)

fun Tag<HTMLIFrameElement>.longDesc(value: String) = attr("longdesc", value)
fun Tag<HTMLIFrameElement>.longDesc(value: Flow<String>) = attr("longdesc", value)

fun Tag<HTMLIFrameElement>.marginHeight(value: String) = attr("marginheight", value)
fun Tag<HTMLIFrameElement>.marginHeight(value: Flow<String>) = attr("marginheight", value)

fun Tag<HTMLIFrameElement>.marginWidth(value: String) = attr("marginwidth", value)
fun Tag<HTMLIFrameElement>.marginWidth(value: Flow<String>) = attr("marginwidth", value)


/*
 * HTMLEmbedElement attributes
 */
fun Tag<HTMLEmbedElement>.src(value: String) = attr("src", value)
fun Tag<HTMLEmbedElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLEmbedElement>.type(value: String) = attr("type", value)
fun Tag<HTMLEmbedElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLEmbedElement>.width(value: String) = attr("width", value)
fun Tag<HTMLEmbedElement>.width(value: Flow<String>) = attr("width", value)

fun Tag<HTMLEmbedElement>.height(value: String) = attr("height", value)
fun Tag<HTMLEmbedElement>.height(value: Flow<String>) = attr("height", value)

fun Tag<HTMLEmbedElement>.align(value: String) = attr("align", value)
fun Tag<HTMLEmbedElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLEmbedElement>.name(value: String) = attr("name", value)
fun Tag<HTMLEmbedElement>.name(value: Flow<String>) = attr("name", value)


/*
 * HTMLObjectElement attributes
 */
fun Tag<HTMLObjectElement>.data(value: String) = attr("data", value)
fun Tag<HTMLObjectElement>.data(value: Flow<String>) = attr("data", value)

fun Tag<HTMLObjectElement>.type(value: String) = attr("type", value)
fun Tag<HTMLObjectElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLObjectElement>.typeMustMatch(value: Boolean, trueValue: String = "") = attr("typemustmatch", value, trueValue)
fun Tag<HTMLObjectElement>.typeMustMatch(value: Flow<Boolean>, trueValue: String = "") = attr("typemustmatch", value, trueValue)

fun Tag<HTMLObjectElement>.name(value: String) = attr("name", value)
fun Tag<HTMLObjectElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLObjectElement>.useMap(value: String) = attr("usemap", value)
fun Tag<HTMLObjectElement>.useMap(value: Flow<String>) = attr("usemap", value)

fun Tag<HTMLObjectElement>.width(value: String) = attr("width", value)
fun Tag<HTMLObjectElement>.width(value: Flow<String>) = attr("width", value)

fun Tag<HTMLObjectElement>.height(value: String) = attr("height", value)
fun Tag<HTMLObjectElement>.height(value: Flow<String>) = attr("height", value)

fun Tag<HTMLObjectElement>.align(value: String) = attr("align", value)
fun Tag<HTMLObjectElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLObjectElement>.archive(value: String) = attr("archive", value)
fun Tag<HTMLObjectElement>.archive(value: Flow<String>) = attr("archive", value)

fun Tag<HTMLObjectElement>.code(value: String) = attr("code", value)
fun Tag<HTMLObjectElement>.code(value: Flow<String>) = attr("code", value)

fun Tag<HTMLObjectElement>.declare(value: Boolean, trueValue: String = "") = attr("declare", value, trueValue)
fun Tag<HTMLObjectElement>.declare(value: Flow<Boolean>, trueValue: String = "") = attr("declare", value, trueValue)

fun Tag<HTMLObjectElement>.hspace(value: Int) = attr("hspace", value)
fun Tag<HTMLObjectElement>.hspace(value: Flow<Int>) = attr("hspace", value)

fun Tag<HTMLObjectElement>.standby(value: String) = attr("standby", value)
fun Tag<HTMLObjectElement>.standby(value: Flow<String>) = attr("standby", value)

fun Tag<HTMLObjectElement>.vspace(value: Int) = attr("vspace", value)
fun Tag<HTMLObjectElement>.vspace(value: Flow<Int>) = attr("vspace", value)

fun Tag<HTMLObjectElement>.codeBase(value: String) = attr("codebase", value)
fun Tag<HTMLObjectElement>.codeBase(value: Flow<String>) = attr("codebase", value)

fun Tag<HTMLObjectElement>.codeType(value: String) = attr("codetype", value)
fun Tag<HTMLObjectElement>.codeType(value: Flow<String>) = attr("codetype", value)

fun Tag<HTMLObjectElement>.border(value: String) = attr("border", value)
fun Tag<HTMLObjectElement>.border(value: Flow<String>) = attr("border", value)


/*
 * HTMLParamElement attributes
 */
fun Tag<HTMLParamElement>.name(value: String) = attr("name", value)
fun Tag<HTMLParamElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLParamElement>.value(value: String) = attr("value", value)
fun Tag<HTMLParamElement>.value(value: Flow<String>) = attr("value", value)

fun Tag<HTMLParamElement>.type(value: String) = attr("type", value)
fun Tag<HTMLParamElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLParamElement>.valueType(value: String) = attr("valuetype", value)
fun Tag<HTMLParamElement>.valueType(value: Flow<String>) = attr("valuetype", value)


/*
 * HTMLVideoElement attributes
 */
fun Tag<HTMLVideoElement>.width(value: Int) = attr("width", value)
fun Tag<HTMLVideoElement>.width(value: Flow<Int>) = attr("width", value)

fun Tag<HTMLVideoElement>.height(value: Int) = attr("height", value)
fun Tag<HTMLVideoElement>.height(value: Flow<Int>) = attr("height", value)

fun Tag<HTMLVideoElement>.poster(value: String) = attr("poster", value)
fun Tag<HTMLVideoElement>.poster(value: Flow<String>) = attr("poster", value)

fun Tag<HTMLVideoElement>.playsInline(value: Boolean, trueValue: String = "") = attr("playsinline", value, trueValue)
fun Tag<HTMLVideoElement>.playsInline(value: Flow<Boolean>, trueValue: String = "") = attr("playsinline", value, trueValue)


/*
 * HTMLTrackElement attributes
 */
fun Tag<HTMLTrackElement>.kind(value: String) = attr("kind", value)
fun Tag<HTMLTrackElement>.kind(value: Flow<String>) = attr("kind", value)

fun Tag<HTMLTrackElement>.src(value: String) = attr("src", value)
fun Tag<HTMLTrackElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLTrackElement>.srclang(value: String) = attr("srclang", value)
fun Tag<HTMLTrackElement>.srclang(value: Flow<String>) = attr("srclang", value)

fun Tag<HTMLTrackElement>.label(value: String) = attr("label", value)
fun Tag<HTMLTrackElement>.label(value: Flow<String>) = attr("label", value)

fun Tag<HTMLTrackElement>.default(value: Boolean, trueValue: String = "") = attr("default", value, trueValue)
fun Tag<HTMLTrackElement>.default(value: Flow<Boolean>, trueValue: String = "") = attr("default", value, trueValue)


/*
 * HTMLMediaElement attributes
 */
fun Tag<HTMLMediaElement>.src(value: String) = attr("src", value)
fun Tag<HTMLMediaElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLMediaElement>.srcObject(value: MediaProvider?) = attr("srcobject", value)
fun Tag<HTMLMediaElement>.srcObject(value: Flow<MediaProvider?>) = attr("srcobject", value)

fun Tag<HTMLMediaElement>.crossOrigin(value: String?) = attr("crossorigin", value)
fun Tag<HTMLMediaElement>.crossOrigin(value: Flow<String?>) = attr("crossorigin", value)

fun Tag<HTMLMediaElement>.preload(value: String) = attr("preload", value)
fun Tag<HTMLMediaElement>.preload(value: Flow<String>) = attr("preload", value)

fun Tag<HTMLMediaElement>.currentTime(value: Double) = attr("currenttime", value)
fun Tag<HTMLMediaElement>.currentTime(value: Flow<Double>) = attr("currenttime", value)

fun Tag<HTMLMediaElement>.defaultPlaybackRate(value: Double) = attr("defaultplaybackrate", value)
fun Tag<HTMLMediaElement>.defaultPlaybackRate(value: Flow<Double>) = attr("defaultplaybackrate", value)

fun Tag<HTMLMediaElement>.playbackRate(value: Double) {
    domNode.playbackRate = value
    domNode.defaultPlaybackRate = value
    domNode.setAttribute("playbackrate", value.toString())
}

fun Tag<HTMLMediaElement>.playbackRate(value: Flow<Double>) {
    mountSimple(job, value) { v -> playbackRate(v) }
}

fun Tag<HTMLMediaElement>.autoplay(value: Boolean, trueValue: String = "") = attr("autoplay", value, trueValue)
fun Tag<HTMLMediaElement>.autoplay(value: Flow<Boolean>, trueValue: String = "") = attr("autoplay", value, trueValue)

fun Tag<HTMLMediaElement>.loop(value: Boolean, trueValue: String = "") = attr("loop", value, trueValue)
fun Tag<HTMLMediaElement>.loop(value: Flow<Boolean>, trueValue: String = "") = attr("loop", value, trueValue)

fun Tag<HTMLMediaElement>.controls(value: Boolean, trueValue: String = "") = attr("controls", value, trueValue)
fun Tag<HTMLMediaElement>.controls(value: Flow<Boolean>, trueValue: String = "") = attr("controls", value, trueValue)

fun Tag<HTMLMediaElement>.volume(value: Double) = attr("volume", value)
fun Tag<HTMLMediaElement>.volume(value: Flow<Double>) = attr("volume", value)

fun Tag<HTMLMediaElement>.muted(value: Boolean, trueValue: String = "") {
    domNode.muted = value
    domNode.defaultMuted = value
    if (value) domNode.setAttribute("muted", trueValue)
    else domNode.removeAttribute("muted")
}

fun Tag<HTMLMediaElement>.muted(value: Flow<Boolean>, trueValue: String = "") {
    mountSimple(job, value) { v -> muted(v, trueValue) }
}

fun Tag<HTMLMediaElement>.defaultMuted(value: Boolean, trueValue: String = "") = attr("defaultmuted", value, trueValue)
fun Tag<HTMLMediaElement>.defaultMuted(value: Flow<Boolean>, trueValue: String = "") = attr("defaultmuted", value, trueValue)


/*
 * HTMLMapElement attributes
 */
fun Tag<HTMLMapElement>.name(value: String) = attr("name", value)
fun Tag<HTMLMapElement>.name(value: Flow<String>) = attr("name", value)


/*
 * HTMLAreaElement attributes
 */
fun Tag<HTMLAreaElement>.alt(value: String) = attr("alt", value)
fun Tag<HTMLAreaElement>.alt(value: Flow<String>) = attr("alt", value)

fun Tag<HTMLAreaElement>.coords(value: String) = attr("coords", value)
fun Tag<HTMLAreaElement>.coords(value: Flow<String>) = attr("coords", value)

fun Tag<HTMLAreaElement>.shape(value: String) = attr("shape", value)
fun Tag<HTMLAreaElement>.shape(value: Flow<String>) = attr("shape", value)

fun Tag<HTMLAreaElement>.target(value: String) = attr("target", value)
fun Tag<HTMLAreaElement>.target(value: Flow<String>) = attr("target", value)

fun Tag<HTMLAreaElement>.download(value: String) = attr("download", value)
fun Tag<HTMLAreaElement>.download(value: Flow<String>) = attr("download", value)

fun Tag<HTMLAreaElement>.ping(value: String) = attr("ping", value)
fun Tag<HTMLAreaElement>.ping(value: Flow<String>) = attr("ping", value)

fun Tag<HTMLAreaElement>.rel(value: String) = attr("rel", value)
fun Tag<HTMLAreaElement>.rel(value: Flow<String>) = attr("rel", value)

fun Tag<HTMLAreaElement>.referrerPolicy(value: String) = attr("referrerpolicy", value)
fun Tag<HTMLAreaElement>.referrerPolicy(value: Flow<String>) = attr("referrerpolicy", value)

fun Tag<HTMLAreaElement>.noHref(value: Boolean, trueValue: String = "") = attr("nohref", value, trueValue)
fun Tag<HTMLAreaElement>.noHref(value: Flow<Boolean>, trueValue: String = "") = attr("nohref", value, trueValue)

// inherited attributes from supertype HTMLHyperlinkElementUtils
fun Tag<HTMLAreaElement>.href(value: String) = attr("href", value)
fun Tag<HTMLAreaElement>.href(value: Flow<String>) = attr("href", value)

fun Tag<HTMLAreaElement>.protocol(value: String) = attr("protocol", value)
fun Tag<HTMLAreaElement>.protocol(value: Flow<String>) = attr("protocol", value)

fun Tag<HTMLAreaElement>.username(value: String) = attr("username", value)
fun Tag<HTMLAreaElement>.username(value: Flow<String>) = attr("username", value)

fun Tag<HTMLAreaElement>.password(value: String) = attr("password", value)
fun Tag<HTMLAreaElement>.password(value: Flow<String>) = attr("password", value)

fun Tag<HTMLAreaElement>.host(value: String) = attr("host", value)
fun Tag<HTMLAreaElement>.host(value: Flow<String>) = attr("host", value)

fun Tag<HTMLAreaElement>.hostname(value: String) = attr("hostname", value)
fun Tag<HTMLAreaElement>.hostname(value: Flow<String>) = attr("hostname", value)

fun Tag<HTMLAreaElement>.port(value: String) = attr("port", value)
fun Tag<HTMLAreaElement>.port(value: Flow<String>) = attr("port", value)

fun Tag<HTMLAreaElement>.pathname(value: String) = attr("pathname", value)
fun Tag<HTMLAreaElement>.pathname(value: Flow<String>) = attr("pathname", value)

fun Tag<HTMLAreaElement>.search(value: String) = attr("search", value)
fun Tag<HTMLAreaElement>.search(value: Flow<String>) = attr("search", value)

fun Tag<HTMLAreaElement>.hash(value: String) = attr("hash", value)
fun Tag<HTMLAreaElement>.hash(value: Flow<String>) = attr("hash", value)


/*
 * HTMLTableElement attributes
 */
fun Tag<HTMLTableElement>.caption(value: HTMLTableCaptionElement?) = attr("caption", value)
fun Tag<HTMLTableElement>.caption(value: Flow<HTMLTableCaptionElement?>) = attr("caption", value)

fun Tag<HTMLTableElement>.tHead(value: HTMLTableSectionElement?) = attr("thead", value)
fun Tag<HTMLTableElement>.tHead(value: Flow<HTMLTableSectionElement?>) = attr("thead", value)

fun Tag<HTMLTableElement>.tFoot(value: HTMLTableSectionElement?) = attr("tfoot", value)
fun Tag<HTMLTableElement>.tFoot(value: Flow<HTMLTableSectionElement?>) = attr("tfoot", value)

fun Tag<HTMLTableElement>.align(value: String) = attr("align", value)
fun Tag<HTMLTableElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLTableElement>.border(value: String) = attr("border", value)
fun Tag<HTMLTableElement>.border(value: Flow<String>) = attr("border", value)

fun Tag<HTMLTableElement>.frame(value: String) = attr("frame", value)
fun Tag<HTMLTableElement>.frame(value: Flow<String>) = attr("frame", value)

fun Tag<HTMLTableElement>.rules(value: String) = attr("rules", value)
fun Tag<HTMLTableElement>.rules(value: Flow<String>) = attr("rules", value)

fun Tag<HTMLTableElement>.summary(value: String) = attr("summary", value)
fun Tag<HTMLTableElement>.summary(value: Flow<String>) = attr("summary", value)

fun Tag<HTMLTableElement>.width(value: String) = attr("width", value)
fun Tag<HTMLTableElement>.width(value: Flow<String>) = attr("width", value)

fun Tag<HTMLTableElement>.bgColor(value: String) = attr("bgcolor", value)
fun Tag<HTMLTableElement>.bgColor(value: Flow<String>) = attr("bgcolor", value)

fun Tag<HTMLTableElement>.cellPadding(value: String) = attr("cellpadding", value)
fun Tag<HTMLTableElement>.cellPadding(value: Flow<String>) = attr("cellpadding", value)

fun Tag<HTMLTableElement>.cellSpacing(value: String) = attr("cellspacing", value)
fun Tag<HTMLTableElement>.cellSpacing(value: Flow<String>) = attr("cellspacing", value)


/*
 * HTMLTableCaptionElement attributes
 */
fun Tag<HTMLTableCaptionElement>.align(value: String) = attr("align", value)
fun Tag<HTMLTableCaptionElement>.align(value: Flow<String>) = attr("align", value)


/*
 * HTMLTableColElement attributes
 */
fun Tag<HTMLTableColElement>.span(value: Int) = attr("span", value)
fun Tag<HTMLTableColElement>.span(value: Flow<Int>) = attr("span", value)

fun Tag<HTMLTableColElement>.align(value: String) = attr("align", value)
fun Tag<HTMLTableColElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLTableColElement>.ch(value: String) = attr("ch", value)
fun Tag<HTMLTableColElement>.ch(value: Flow<String>) = attr("ch", value)

fun Tag<HTMLTableColElement>.chOff(value: String) = attr("choff", value)
fun Tag<HTMLTableColElement>.chOff(value: Flow<String>) = attr("choff", value)

fun Tag<HTMLTableColElement>.vAlign(value: String) = attr("valign", value)
fun Tag<HTMLTableColElement>.vAlign(value: Flow<String>) = attr("valign", value)

fun Tag<HTMLTableColElement>.width(value: String) = attr("width", value)
fun Tag<HTMLTableColElement>.width(value: Flow<String>) = attr("width", value)


/*
 * HTMLTableSectionElement attributes
 */
fun Tag<HTMLTableSectionElement>.align(value: String) = attr("align", value)
fun Tag<HTMLTableSectionElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLTableSectionElement>.ch(value: String) = attr("ch", value)
fun Tag<HTMLTableSectionElement>.ch(value: Flow<String>) = attr("ch", value)

fun Tag<HTMLTableSectionElement>.chOff(value: String) = attr("choff", value)
fun Tag<HTMLTableSectionElement>.chOff(value: Flow<String>) = attr("choff", value)

fun Tag<HTMLTableSectionElement>.vAlign(value: String) = attr("valign", value)
fun Tag<HTMLTableSectionElement>.vAlign(value: Flow<String>) = attr("valign", value)


/*
 * HTMLTableRowElement attributes
 */
fun Tag<HTMLTableRowElement>.align(value: String) = attr("align", value)
fun Tag<HTMLTableRowElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLTableRowElement>.ch(value: String) = attr("ch", value)
fun Tag<HTMLTableRowElement>.ch(value: Flow<String>) = attr("ch", value)

fun Tag<HTMLTableRowElement>.chOff(value: String) = attr("choff", value)
fun Tag<HTMLTableRowElement>.chOff(value: Flow<String>) = attr("choff", value)

fun Tag<HTMLTableRowElement>.vAlign(value: String) = attr("valign", value)
fun Tag<HTMLTableRowElement>.vAlign(value: Flow<String>) = attr("valign", value)

fun Tag<HTMLTableRowElement>.bgColor(value: String) = attr("bgcolor", value)
fun Tag<HTMLTableRowElement>.bgColor(value: Flow<String>) = attr("bgcolor", value)


/*
 * HTMLTableCellElement attributes
 */
fun Tag<HTMLTableCellElement>.colSpan(value: Int) = attr("colspan", value)
fun Tag<HTMLTableCellElement>.colSpan(value: Flow<Int>) = attr("colspan", value)

fun Tag<HTMLTableCellElement>.rowSpan(value: Int) = attr("rowspan", value)
fun Tag<HTMLTableCellElement>.rowSpan(value: Flow<Int>) = attr("rowspan", value)

fun Tag<HTMLTableCellElement>.headers(value: String) = attr("headers", value)
fun Tag<HTMLTableCellElement>.headers(value: Flow<String>) = attr("headers", value)

fun Tag<HTMLTableCellElement>.scope(value: String) = attr("scope", value)
fun Tag<HTMLTableCellElement>.scope(value: Flow<String>) = attr("scope", value)

fun Tag<HTMLTableCellElement>.abbr(value: String) = attr("abbr", value)
fun Tag<HTMLTableCellElement>.abbr(value: Flow<String>) = attr("abbr", value)

fun Tag<HTMLTableCellElement>.align(value: String) = attr("align", value)
fun Tag<HTMLTableCellElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLTableCellElement>.axis(value: String) = attr("axis", value)
fun Tag<HTMLTableCellElement>.axis(value: Flow<String>) = attr("axis", value)

fun Tag<HTMLTableCellElement>.height(value: String) = attr("height", value)
fun Tag<HTMLTableCellElement>.height(value: Flow<String>) = attr("height", value)

fun Tag<HTMLTableCellElement>.width(value: String) = attr("width", value)
fun Tag<HTMLTableCellElement>.width(value: Flow<String>) = attr("width", value)

fun Tag<HTMLTableCellElement>.ch(value: String) = attr("ch", value)
fun Tag<HTMLTableCellElement>.ch(value: Flow<String>) = attr("ch", value)

fun Tag<HTMLTableCellElement>.chOff(value: String) = attr("choff", value)
fun Tag<HTMLTableCellElement>.chOff(value: Flow<String>) = attr("choff", value)

fun Tag<HTMLTableCellElement>.noWrap(value: Boolean, trueValue: String = "") = attr("nowrap", value, trueValue)
fun Tag<HTMLTableCellElement>.noWrap(value: Flow<Boolean>, trueValue: String = "") = attr("nowrap", value, trueValue)

fun Tag<HTMLTableCellElement>.vAlign(value: String) = attr("valign", value)
fun Tag<HTMLTableCellElement>.vAlign(value: Flow<String>) = attr("valign", value)

fun Tag<HTMLTableCellElement>.bgColor(value: String) = attr("bgcolor", value)
fun Tag<HTMLTableCellElement>.bgColor(value: Flow<String>) = attr("bgcolor", value)


/*
 * HTMLFormElement attributes
 */
fun Tag<HTMLFormElement>.acceptCharset(value: String) = attr("acceptcharset", value)
fun Tag<HTMLFormElement>.acceptCharset(value: Flow<String>) = attr("acceptcharset", value)

fun Tag<HTMLFormElement>.action(value: String) = attr("action", value)
fun Tag<HTMLFormElement>.action(value: Flow<String>) = attr("action", value)

fun Tag<HTMLFormElement>.autocomplete(value: String) = attr("autocomplete", value)
fun Tag<HTMLFormElement>.autocomplete(value: Flow<String>) = attr("autocomplete", value)

fun Tag<HTMLFormElement>.enctype(value: String) = attr("enctype", value)
fun Tag<HTMLFormElement>.enctype(value: Flow<String>) = attr("enctype", value)

fun Tag<HTMLFormElement>.encoding(value: String) = attr("encoding", value)
fun Tag<HTMLFormElement>.encoding(value: Flow<String>) = attr("encoding", value)

fun Tag<HTMLFormElement>.method(value: String) = attr("method", value)
fun Tag<HTMLFormElement>.method(value: Flow<String>) = attr("method", value)

fun Tag<HTMLFormElement>.name(value: String) = attr("name", value)
fun Tag<HTMLFormElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLFormElement>.noValidate(value: Boolean, trueValue: String = "") = attr("novalidate", value, trueValue)
fun Tag<HTMLFormElement>.noValidate(value: Flow<Boolean>, trueValue: String = "") = attr("novalidate", value, trueValue)

fun Tag<HTMLFormElement>.target(value: String) = attr("target", value)
fun Tag<HTMLFormElement>.target(value: Flow<String>) = attr("target", value)


/*
 * HTMLLabelElement attributes
 */
fun Tag<HTMLLabelElement>.`for`(value: String) = attr("for", value)
fun Tag<HTMLLabelElement>.`for`(value: Flow<String>) = attr("for", value)


/*
 * HTMLInputElement attributes
 */
fun Tag<HTMLInputElement>.accept(value: String) = attr("accept", value)
fun Tag<HTMLInputElement>.accept(value: Flow<String>) = attr("accept", value)

fun Tag<HTMLInputElement>.alt(value: String) = attr("alt", value)
fun Tag<HTMLInputElement>.alt(value: Flow<String>) = attr("alt", value)

fun Tag<HTMLInputElement>.autocomplete(value: String) = attr("autocomplete", value)
fun Tag<HTMLInputElement>.autocomplete(value: Flow<String>) = attr("autocomplete", value)

fun Tag<HTMLInputElement>.autofocus(value: Boolean, trueValue: String = "") = attr("autofocus", value, trueValue)
fun Tag<HTMLInputElement>.autofocus(value: Flow<Boolean>, trueValue: String = "") = attr("autofocus", value, trueValue)

fun Tag<HTMLInputElement>.defaultChecked(value: Boolean, trueValue: String = "") = attr("defaultchecked", value, trueValue)
fun Tag<HTMLInputElement>.defaultChecked(value: Flow<Boolean>, trueValue: String = "") = attr("defaultchecked", value, trueValue)

fun Tag<HTMLInputElement>.checked(value: Boolean, trueValue: String = "") {
    domNode.checked = value
    domNode.defaultChecked = value
    if (value) domNode.setAttribute("checked", trueValue)
    else domNode.removeAttribute("checked")
}

fun Tag<HTMLInputElement>.checked(value: Flow<Boolean>, trueValue: String = "") {
    mountSimple(job, value) { v -> checked(v, trueValue) }
}

fun Tag<HTMLInputElement>.dirName(value: String) = attr("dirname", value)
fun Tag<HTMLInputElement>.dirName(value: Flow<String>) = attr("dirname", value)

fun Tag<HTMLInputElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLInputElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLInputElement>.formAction(value: String) = attr("formaction", value)
fun Tag<HTMLInputElement>.formAction(value: Flow<String>) = attr("formaction", value)

fun Tag<HTMLInputElement>.formEnctype(value: String) = attr("formenctype", value)
fun Tag<HTMLInputElement>.formEnctype(value: Flow<String>) = attr("formenctype", value)

fun Tag<HTMLInputElement>.formMethod(value: String) = attr("formmethod", value)
fun Tag<HTMLInputElement>.formMethod(value: Flow<String>) = attr("formmethod", value)

fun Tag<HTMLInputElement>.formNoValidate(value: Boolean, trueValue: String = "") = attr("formnovalidate", value, trueValue)
fun Tag<HTMLInputElement>.formNoValidate(value: Flow<Boolean>, trueValue: String = "") = attr("formnovalidate", value, trueValue)

fun Tag<HTMLInputElement>.formTarget(value: String) = attr("formtarget", value)
fun Tag<HTMLInputElement>.formTarget(value: Flow<String>) = attr("formtarget", value)

fun Tag<HTMLInputElement>.height(value: Int) = attr("height", value)
fun Tag<HTMLInputElement>.height(value: Flow<Int>) = attr("height", value)

fun Tag<HTMLInputElement>.indeterminate(value: Boolean, trueValue: String = "") = attr("indeterminate", value, trueValue)
fun Tag<HTMLInputElement>.indeterminate(value: Flow<Boolean>, trueValue: String = "") = attr("indeterminate", value, trueValue)

fun Tag<HTMLInputElement>.inputMode(value: String) = attr("inputmode", value)
fun Tag<HTMLInputElement>.inputMode(value: Flow<String>) = attr("inputmode", value)

fun Tag<HTMLInputElement>.max(value: String) = attr("max", value)
fun Tag<HTMLInputElement>.max(value: Flow<String>) = attr("max", value)

fun Tag<HTMLInputElement>.maxLength(value: Int) = attr("maxlength", value)
fun Tag<HTMLInputElement>.maxLength(value: Flow<Int>) = attr("maxlength", value)

fun Tag<HTMLInputElement>.min(value: String) = attr("min", value)
fun Tag<HTMLInputElement>.min(value: Flow<String>) = attr("min", value)

fun Tag<HTMLInputElement>.minLength(value: Int) = attr("minlength", value)
fun Tag<HTMLInputElement>.minLength(value: Flow<Int>) = attr("minlength", value)

fun Tag<HTMLInputElement>.multiple(value: Boolean, trueValue: String = "") = attr("multiple", value, trueValue)
fun Tag<HTMLInputElement>.multiple(value: Flow<Boolean>, trueValue: String = "") = attr("multiple", value, trueValue)

fun Tag<HTMLInputElement>.name(value: String) = attr("name", value)
fun Tag<HTMLInputElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLInputElement>.pattern(value: String) = attr("pattern", value)
fun Tag<HTMLInputElement>.pattern(value: Flow<String>) = attr("pattern", value)

fun Tag<HTMLInputElement>.placeholder(value: String) = attr("placeholder", value)
fun Tag<HTMLInputElement>.placeholder(value: Flow<String>) = attr("placeholder", value)

fun Tag<HTMLInputElement>.readOnly(value: Boolean, trueValue: String = "") = attr("readonly", value, trueValue)
fun Tag<HTMLInputElement>.readOnly(value: Flow<Boolean>, trueValue: String = "") = attr("readonly", value, trueValue)

fun Tag<HTMLInputElement>.required(value: Boolean, trueValue: String = "") = attr("required", value, trueValue)
fun Tag<HTMLInputElement>.required(value: Flow<Boolean>, trueValue: String = "") = attr("required", value, trueValue)

fun Tag<HTMLInputElement>.size(value: Int) = attr("size", value)
fun Tag<HTMLInputElement>.size(value: Flow<Int>) = attr("size", value)

fun Tag<HTMLInputElement>.src(value: String) = attr("src", value)
fun Tag<HTMLInputElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLInputElement>.step(value: String) = attr("step", value)
fun Tag<HTMLInputElement>.step(value: Flow<String>) = attr("step", value)

fun Tag<HTMLInputElement>.type(value: String) = attr("type", value)
fun Tag<HTMLInputElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLInputElement>.defaultValue(value: String) = attr("defaultvalue", value)
fun Tag<HTMLInputElement>.defaultValue(value: Flow<String>) = attr("defaultvalue", value)

fun Tag<HTMLInputElement>.value(value: String) {
    domNode.value = value
    domNode.defaultValue = value
    domNode.setAttribute("value", value)
}

fun Tag<HTMLInputElement>.value(value: Flow<String>) {
    mountSimple(job, value) { v -> value(v) }
}

fun Tag<HTMLInputElement>.valueAsDate(value: String) = attr("valueasdate", value)
fun Tag<HTMLInputElement>.valueAsDate(value: Flow<String>) = attr("valueasdate", value)

fun Tag<HTMLInputElement>.valueAsNumber(value: Double) = attr("valueasnumber", value)
fun Tag<HTMLInputElement>.valueAsNumber(value: Flow<Double>) = attr("valueasnumber", value)

fun Tag<HTMLInputElement>.width(value: Int) = attr("width", value)
fun Tag<HTMLInputElement>.width(value: Flow<Int>) = attr("width", value)

fun Tag<HTMLInputElement>.selectionStart(value: Int?) = attr("selectionstart", value)
fun Tag<HTMLInputElement>.selectionStart(value: Flow<Int?>) = attr("selectionstart", value)

fun Tag<HTMLInputElement>.selectionEnd(value: Int?) = attr("selectionend", value)
fun Tag<HTMLInputElement>.selectionEnd(value: Flow<Int?>) = attr("selectionend", value)

fun Tag<HTMLInputElement>.selectionDirection(value: String?) = attr("selectiondirection", value)
fun Tag<HTMLInputElement>.selectionDirection(value: Flow<String?>) = attr("selectiondirection", value)

fun Tag<HTMLInputElement>.align(value: String) = attr("align", value)
fun Tag<HTMLInputElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLInputElement>.useMap(value: String) = attr("usemap", value)
fun Tag<HTMLInputElement>.useMap(value: Flow<String>) = attr("usemap", value)


/*
 * HTMLButtonElement attributes
 */
fun Tag<HTMLButtonElement>.autofocus(value: Boolean, trueValue: String = "") = attr("autofocus", value, trueValue)
fun Tag<HTMLButtonElement>.autofocus(value: Flow<Boolean>, trueValue: String = "") = attr("autofocus", value, trueValue)

fun Tag<HTMLButtonElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLButtonElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLButtonElement>.formAction(value: String) = attr("formaction", value)
fun Tag<HTMLButtonElement>.formAction(value: Flow<String>) = attr("formaction", value)

fun Tag<HTMLButtonElement>.formEnctype(value: String) = attr("formenctype", value)
fun Tag<HTMLButtonElement>.formEnctype(value: Flow<String>) = attr("formenctype", value)

fun Tag<HTMLButtonElement>.formMethod(value: String) = attr("formmethod", value)
fun Tag<HTMLButtonElement>.formMethod(value: Flow<String>) = attr("formmethod", value)

fun Tag<HTMLButtonElement>.formNoValidate(value: Boolean, trueValue: String = "") = attr("formnovalidate", value, trueValue)
fun Tag<HTMLButtonElement>.formNoValidate(value: Flow<Boolean>, trueValue: String = "") = attr("formnovalidate", value, trueValue)

fun Tag<HTMLButtonElement>.formTarget(value: String) = attr("formtarget", value)
fun Tag<HTMLButtonElement>.formTarget(value: Flow<String>) = attr("formtarget", value)

fun Tag<HTMLButtonElement>.name(value: String) = attr("name", value)
fun Tag<HTMLButtonElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLButtonElement>.type(value: String) = attr("type", value)
fun Tag<HTMLButtonElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLButtonElement>.value(value: String) = attr("value", value)
fun Tag<HTMLButtonElement>.value(value: Flow<String>) = attr("value", value)

fun Tag<HTMLButtonElement>.menu(value: HTMLMenuElement?) = attr("menu", value)
fun Tag<HTMLButtonElement>.menu(value: Flow<HTMLMenuElement?>) = attr("menu", value)


/*
 * HTMLSelectElement attributes
 */
fun Tag<HTMLSelectElement>.autocomplete(value: String) = attr("autocomplete", value)
fun Tag<HTMLSelectElement>.autocomplete(value: Flow<String>) = attr("autocomplete", value)

fun Tag<HTMLSelectElement>.autofocus(value: Boolean, trueValue: String = "") = attr("autofocus", value, trueValue)
fun Tag<HTMLSelectElement>.autofocus(value: Flow<Boolean>, trueValue: String = "") = attr("autofocus", value, trueValue)

fun Tag<HTMLSelectElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLSelectElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLSelectElement>.multiple(value: Boolean, trueValue: String = "") = attr("multiple", value, trueValue)
fun Tag<HTMLSelectElement>.multiple(value: Flow<Boolean>, trueValue: String = "") = attr("multiple", value, trueValue)

fun Tag<HTMLSelectElement>.name(value: String) = attr("name", value)
fun Tag<HTMLSelectElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLSelectElement>.required(value: Boolean, trueValue: String = "") = attr("required", value, trueValue)
fun Tag<HTMLSelectElement>.required(value: Flow<Boolean>, trueValue: String = "") = attr("required", value, trueValue)

fun Tag<HTMLSelectElement>.size(value: Int) = attr("size", value)
fun Tag<HTMLSelectElement>.size(value: Flow<Int>) = attr("size", value)

fun Tag<HTMLSelectElement>.length(value: Int) = attr("length", value)
fun Tag<HTMLSelectElement>.length(value: Flow<Int>) = attr("length", value)

fun Tag<HTMLSelectElement>.selectedIndex(value: Int) = attr("selectedindex", value)
fun Tag<HTMLSelectElement>.selectedIndex(value: Flow<Int>) = attr("selectedindex", value)

fun Tag<HTMLSelectElement>.value(value: String) = attr("value", value)
fun Tag<HTMLSelectElement>.value(value: Flow<String>) = attr("value", value)


/*
 * HTMLOptGroupElement attributes
 */
fun Tag<HTMLOptGroupElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLOptGroupElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLOptGroupElement>.label(value: String) = attr("label", value)
fun Tag<HTMLOptGroupElement>.label(value: Flow<String>) = attr("label", value)


/*
 * HTMLOptionElement attributes
 */
fun Tag<HTMLOptionElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLOptionElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLOptionElement>.label(value: String) = attr("label", value)
fun Tag<HTMLOptionElement>.label(value: Flow<String>) = attr("label", value)

fun Tag<HTMLOptionElement>.defaultSelected(value: Boolean, trueValue: String = "") = attr("defaultselected", value, trueValue)
fun Tag<HTMLOptionElement>.defaultSelected(value: Flow<Boolean>, trueValue: String = "") = attr("defaultselected", value, trueValue)

fun Tag<HTMLOptionElement>.selected(value: Boolean, trueValue: String = "") {
    domNode.selected = value
    domNode.defaultSelected = value
    if (value) domNode.setAttribute("selected", trueValue)
    else domNode.removeAttribute("selected")
}

fun Tag<HTMLOptionElement>.selected(value: Flow<Boolean>, trueValue: String = "") {
    mountSimple(job, value) { v -> selected(v, trueValue) }
}

fun Tag<HTMLOptionElement>.value(value: String) = attr("value", value)
fun Tag<HTMLOptionElement>.value(value: Flow<String>) = attr("value", value)

/*
 * HTMLTextAreaElement attributes
 */
fun Tag<HTMLTextAreaElement>.autocomplete(value: String) = attr("autocomplete", value)
fun Tag<HTMLTextAreaElement>.autocomplete(value: Flow<String>) = attr("autocomplete", value)

fun Tag<HTMLTextAreaElement>.autofocus(value: Boolean, trueValue: String = "") = attr("autofocus", value, trueValue)
fun Tag<HTMLTextAreaElement>.autofocus(value: Flow<Boolean>, trueValue: String = "") = attr("autofocus", value, trueValue)

fun Tag<HTMLTextAreaElement>.cols(value: Int) = attr("cols", value)
fun Tag<HTMLTextAreaElement>.cols(value: Flow<Int>) = attr("cols", value)

fun Tag<HTMLTextAreaElement>.dirName(value: String) = attr("dirname", value)
fun Tag<HTMLTextAreaElement>.dirName(value: Flow<String>) = attr("dirname", value)

fun Tag<HTMLTextAreaElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLTextAreaElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLTextAreaElement>.inputMode(value: String) = attr("inputmode", value)
fun Tag<HTMLTextAreaElement>.inputMode(value: Flow<String>) = attr("inputmode", value)

fun Tag<HTMLTextAreaElement>.maxLength(value: Int) = attr("maxlength", value)
fun Tag<HTMLTextAreaElement>.maxLength(value: Flow<Int>) = attr("maxlength", value)

fun Tag<HTMLTextAreaElement>.minLength(value: Int) = attr("minlength", value)
fun Tag<HTMLTextAreaElement>.minLength(value: Flow<Int>) = attr("minlength", value)

fun Tag<HTMLTextAreaElement>.name(value: String) = attr("name", value)
fun Tag<HTMLTextAreaElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLTextAreaElement>.placeholder(value: String) = attr("placeholder", value)
fun Tag<HTMLTextAreaElement>.placeholder(value: Flow<String>) = attr("placeholder", value)

fun Tag<HTMLTextAreaElement>.readOnly(value: Boolean, trueValue: String = "") = attr("readonly", value, trueValue)
fun Tag<HTMLTextAreaElement>.readOnly(value: Flow<Boolean>, trueValue: String = "") = attr("readonly", value, trueValue)

fun Tag<HTMLTextAreaElement>.required(value: Boolean, trueValue: String = "") = attr("required", value, trueValue)
fun Tag<HTMLTextAreaElement>.required(value: Flow<Boolean>, trueValue: String = "") = attr("required", value, trueValue)

fun Tag<HTMLTextAreaElement>.rows(value: Int) = attr("rows", value)
fun Tag<HTMLTextAreaElement>.rows(value: Flow<Int>) = attr("rows", value)

fun Tag<HTMLTextAreaElement>.wrap(value: String) = attr("wrap", value)
fun Tag<HTMLTextAreaElement>.wrap(value: Flow<String>) = attr("wrap", value)

fun Tag<HTMLTextAreaElement>.defaultValue(value: String) = attr("defaultvalue", value)
fun Tag<HTMLTextAreaElement>.defaultValue(value: Flow<String>) = attr("defaultvalue", value)

fun Tag<HTMLTextAreaElement>.value(value: String) {
    domNode.value = value
    domNode.defaultValue = value
    domNode.setAttribute("value", value)
}

fun Tag<HTMLTextAreaElement>.value(value: Flow<String>) {
    mountSimple(job, value) { v -> value(v) }
}

fun Tag<HTMLTextAreaElement>.selectionStart(value: Int?) = attr("selectionstart", value)
fun Tag<HTMLTextAreaElement>.selectionStart(value: Flow<Int?>) = attr("selectionstart", value)

fun Tag<HTMLTextAreaElement>.selectionEnd(value: Int?) = attr("selectionend", value)
fun Tag<HTMLTextAreaElement>.selectionEnd(value: Flow<Int?>) = attr("selectionend", value)

fun Tag<HTMLTextAreaElement>.selectionDirection(value: String?) = attr("selectiondirection", value)
fun Tag<HTMLTextAreaElement>.selectionDirection(value: Flow<String?>) = attr("selectiondirection", value)


/*
 * HTMLKeygenElement attributes
 */
fun Tag<HTMLKeygenElement>.autofocus(value: Boolean, trueValue: String = "") = attr("autofocus", value, trueValue)
fun Tag<HTMLKeygenElement>.autofocus(value: Flow<Boolean>, trueValue: String = "") = attr("autofocus", value, trueValue)

fun Tag<HTMLKeygenElement>.challenge(value: String) = attr("challenge", value)
fun Tag<HTMLKeygenElement>.challenge(value: Flow<String>) = attr("challenge", value)

fun Tag<HTMLKeygenElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLKeygenElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLKeygenElement>.keytype(value: String) = attr("keytype", value)
fun Tag<HTMLKeygenElement>.keytype(value: Flow<String>) = attr("keytype", value)

fun Tag<HTMLKeygenElement>.name(value: String) = attr("name", value)
fun Tag<HTMLKeygenElement>.name(value: Flow<String>) = attr("name", value)


/*
 * HTMLOutputElement attributes
 */
fun Tag<HTMLOutputElement>.name(value: String) = attr("name", value)
fun Tag<HTMLOutputElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLOutputElement>.defaultValue(value: String) = attr("defaultvalue", value)
fun Tag<HTMLOutputElement>.defaultValue(value: Flow<String>) = attr("defaultvalue", value)

fun Tag<HTMLOutputElement>.value(value: String) {
    domNode.value = value
    domNode.defaultValue = value
    domNode.setAttribute("value", value)
}

fun Tag<HTMLOutputElement>.value(value: Flow<String>) {
    mountSimple(job, value) { v -> value(v) }
}


/*
 * HTMLProgressElement attributes
 */
fun Tag<HTMLProgressElement>.value(value: Double) = attr("value", value)
fun Tag<HTMLProgressElement>.value(value: Flow<Double>) = attr("value", value)

fun Tag<HTMLProgressElement>.max(value: Double) = attr("max", value)
fun Tag<HTMLProgressElement>.max(value: Flow<Double>) = attr("max", value)


/*
 * HTMLMeterElement attributes
 */
fun Tag<HTMLMeterElement>.value(value: Double) = attr("value", value)
fun Tag<HTMLMeterElement>.value(value: Flow<Double>) = attr("value", value)

fun Tag<HTMLMeterElement>.min(value: Double) = attr("min", value)
fun Tag<HTMLMeterElement>.min(value: Flow<Double>) = attr("min", value)

fun Tag<HTMLMeterElement>.max(value: Double) = attr("max", value)
fun Tag<HTMLMeterElement>.max(value: Flow<Double>) = attr("max", value)

fun Tag<HTMLMeterElement>.low(value: Double) = attr("low", value)
fun Tag<HTMLMeterElement>.low(value: Flow<Double>) = attr("low", value)

fun Tag<HTMLMeterElement>.high(value: Double) = attr("high", value)
fun Tag<HTMLMeterElement>.high(value: Flow<Double>) = attr("high", value)

fun Tag<HTMLMeterElement>.optimum(value: Double) = attr("optimum", value)
fun Tag<HTMLMeterElement>.optimum(value: Flow<Double>) = attr("optimum", value)


/*
 * HTMLFieldSetElement attributes
 */
fun Tag<HTMLFieldSetElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLFieldSetElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLFieldSetElement>.name(value: String) = attr("name", value)
fun Tag<HTMLFieldSetElement>.name(value: Flow<String>) = attr("name", value)


/*
 * HTMLLegendElement attributes
 */
fun Tag<HTMLLegendElement>.align(value: String) = attr("align", value)
fun Tag<HTMLLegendElement>.align(value: Flow<String>) = attr("align", value)


/*
 * HTMLDetailsElement attributes
 */
fun Tag<HTMLDetailsElement>.open(value: Boolean, trueValue: String = "") = attr("open", value, trueValue)
fun Tag<HTMLDetailsElement>.open(value: Flow<Boolean>, trueValue: String = "") = attr("open", value, trueValue)


/*
 * HTMLMenuElement attributes
 */
fun Tag<HTMLMenuElement>.type(value: String) = attr("type", value)
fun Tag<HTMLMenuElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLMenuElement>.label(value: String) = attr("label", value)
fun Tag<HTMLMenuElement>.label(value: Flow<String>) = attr("label", value)

fun Tag<HTMLMenuElement>.compact(value: Boolean, trueValue: String = "") = attr("compact", value, trueValue)
fun Tag<HTMLMenuElement>.compact(value: Flow<Boolean>, trueValue: String = "") = attr("compact", value, trueValue)


/*
 * HTMLMenuItemElement attributes
 */
fun Tag<HTMLMenuItemElement>.type(value: String) = attr("type", value)
fun Tag<HTMLMenuItemElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLMenuItemElement>.label(value: String) = attr("label", value)
fun Tag<HTMLMenuItemElement>.label(value: Flow<String>) = attr("label", value)

fun Tag<HTMLMenuItemElement>.icon(value: String) = attr("icon", value)
fun Tag<HTMLMenuItemElement>.icon(value: Flow<String>) = attr("icon", value)

fun Tag<HTMLMenuItemElement>.disabled(value: Boolean, trueValue: String = "") = attr("disabled", value, trueValue)
fun Tag<HTMLMenuItemElement>.disabled(value: Flow<Boolean>, trueValue: String = "") = attr("disabled", value, trueValue)

fun Tag<HTMLMenuItemElement>.checked(value: Boolean, trueValue: String = "") = attr("checked", value, trueValue)
fun Tag<HTMLMenuItemElement>.checked(value: Flow<Boolean>, trueValue: String = "") = attr("checked", value, trueValue)

fun Tag<HTMLMenuItemElement>.radiogroup(value: String) = attr("radiogroup", value)
fun Tag<HTMLMenuItemElement>.radiogroup(value: Flow<String>) = attr("radiogroup", value)

fun Tag<HTMLMenuItemElement>.default(value: Boolean, trueValue: String = "") = attr("default", value, trueValue)
fun Tag<HTMLMenuItemElement>.default(value: Flow<Boolean>, trueValue: String = "") = attr("default", value, trueValue)


/*
 * HTMLDialogElement attributes
 */
fun Tag<HTMLDialogElement>.open(value: Boolean, trueValue: String = "") = attr("open", value, trueValue)
fun Tag<HTMLDialogElement>.open(value: Flow<Boolean>, trueValue: String = "") = attr("open", value, trueValue)

fun Tag<HTMLDialogElement>.returnValue(value: String) = attr("returnvalue", value)
fun Tag<HTMLDialogElement>.returnValue(value: Flow<String>) = attr("returnvalue", value)


/*
 * HTMLScriptElement attributes
 */
fun Tag<HTMLScriptElement>.src(value: String) = attr("src", value)
fun Tag<HTMLScriptElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLScriptElement>.type(value: String) = attr("type", value)
fun Tag<HTMLScriptElement>.type(value: Flow<String>) = attr("type", value)

fun Tag<HTMLScriptElement>.charset(value: String) = attr("charset", value)
fun Tag<HTMLScriptElement>.charset(value: Flow<String>) = attr("charset", value)

fun Tag<HTMLScriptElement>.async(value: Boolean, trueValue: String = "") = attr("async", value, trueValue)
fun Tag<HTMLScriptElement>.async(value: Flow<Boolean>, trueValue: String = "") = attr("async", value, trueValue)

fun Tag<HTMLScriptElement>.defer(value: Boolean, trueValue: String = "") = attr("defer", value, trueValue)
fun Tag<HTMLScriptElement>.defer(value: Flow<Boolean>, trueValue: String = "") = attr("defer", value, trueValue)

fun Tag<HTMLScriptElement>.crossOrigin(value: String?) = attr("crossorigin", value)
fun Tag<HTMLScriptElement>.crossOrigin(value: Flow<String?>) = attr("crossorigin", value)

fun Tag<HTMLScriptElement>.nonce(value: String) = attr("nonce", value)
fun Tag<HTMLScriptElement>.nonce(value: Flow<String>) = attr("nonce", value)

fun Tag<HTMLScriptElement>.event(value: String) = attr("event", value)
fun Tag<HTMLScriptElement>.event(value: Flow<String>) = attr("event", value)

fun Tag<HTMLScriptElement>.`for`(value: String) = attr("for", value)
fun Tag<HTMLScriptElement>.`for`(value: Flow<String>) = attr("for", value)


/*
 * HTMLSlotElement attributes
 */
fun Tag<HTMLSlotElement>.name(value: String) = attr("name", value)
fun Tag<HTMLSlotElement>.name(value: Flow<String>) = attr("name", value)


/*
 * HTMLCanvasElement attributes
 */
fun Tag<HTMLCanvasElement>.width(value: Int) = attr("width", value)
fun Tag<HTMLCanvasElement>.width(value: Flow<Int>) = attr("width", value)

fun Tag<HTMLCanvasElement>.height(value: Int) = attr("height", value)
fun Tag<HTMLCanvasElement>.height(value: Flow<Int>) = attr("height", value)


/*
 * HTMLAppletElement attributes
 */
fun Tag<HTMLAppletElement>.align(value: String) = attr("align", value)
fun Tag<HTMLAppletElement>.align(value: Flow<String>) = attr("align", value)

fun Tag<HTMLAppletElement>.alt(value: String) = attr("alt", value)
fun Tag<HTMLAppletElement>.alt(value: Flow<String>) = attr("alt", value)

fun Tag<HTMLAppletElement>.archive(value: String) = attr("archive", value)
fun Tag<HTMLAppletElement>.archive(value: Flow<String>) = attr("archive", value)

fun Tag<HTMLAppletElement>.code(value: String) = attr("code", value)
fun Tag<HTMLAppletElement>.code(value: Flow<String>) = attr("code", value)

fun Tag<HTMLAppletElement>.codeBase(value: String) = attr("codebase", value)
fun Tag<HTMLAppletElement>.codeBase(value: Flow<String>) = attr("codebase", value)

fun Tag<HTMLAppletElement>.height(value: String) = attr("height", value)
fun Tag<HTMLAppletElement>.height(value: Flow<String>) = attr("height", value)

fun Tag<HTMLAppletElement>.hspace(value: Int) = attr("hspace", value)
fun Tag<HTMLAppletElement>.hspace(value: Flow<Int>) = attr("hspace", value)

fun Tag<HTMLAppletElement>.name(value: String) = attr("name", value)
fun Tag<HTMLAppletElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLAppletElement>.`object`(value: String) = attr("object", value)
fun Tag<HTMLAppletElement>.`object`(value: Flow<String>) = attr("object", value)

fun Tag<HTMLAppletElement>.vspace(value: Int) = attr("vspace", value)
fun Tag<HTMLAppletElement>.vspace(value: Flow<Int>) = attr("vspace", value)

fun Tag<HTMLAppletElement>.width(value: String) = attr("width", value)
fun Tag<HTMLAppletElement>.width(value: Flow<String>) = attr("width", value)


/*
 * HTMLMarqueeElement attributes
 */
fun Tag<HTMLMarqueeElement>.behavior(value: String) = attr("behavior", value)
fun Tag<HTMLMarqueeElement>.behavior(value: Flow<String>) = attr("behavior", value)

fun Tag<HTMLMarqueeElement>.bgColor(value: String) = attr("bgcolor", value)
fun Tag<HTMLMarqueeElement>.bgColor(value: Flow<String>) = attr("bgcolor", value)

fun Tag<HTMLMarqueeElement>.direction(value: String) = attr("direction", value)
fun Tag<HTMLMarqueeElement>.direction(value: Flow<String>) = attr("direction", value)

fun Tag<HTMLMarqueeElement>.height(value: String) = attr("height", value)
fun Tag<HTMLMarqueeElement>.height(value: Flow<String>) = attr("height", value)

fun Tag<HTMLMarqueeElement>.hspace(value: Int) = attr("hspace", value)
fun Tag<HTMLMarqueeElement>.hspace(value: Flow<Int>) = attr("hspace", value)

fun Tag<HTMLMarqueeElement>.loop(value: Int) = attr("loop", value)
fun Tag<HTMLMarqueeElement>.loop(value: Flow<Int>) = attr("loop", value)

fun Tag<HTMLMarqueeElement>.scrollAmount(value: Int) = attr("scrollamount", value)
fun Tag<HTMLMarqueeElement>.scrollAmount(value: Flow<Int>) = attr("scrollamount", value)

fun Tag<HTMLMarqueeElement>.scrollDelay(value: Int) = attr("scrolldelay", value)
fun Tag<HTMLMarqueeElement>.scrollDelay(value: Flow<Int>) = attr("scrolldelay", value)

fun Tag<HTMLMarqueeElement>.trueSpeed(value: Boolean, trueValue: String = "") = attr("truespeed", value, trueValue)
fun Tag<HTMLMarqueeElement>.trueSpeed(value: Flow<Boolean>, trueValue: String = "") = attr("truespeed", value, trueValue)

fun Tag<HTMLMarqueeElement>.vspace(value: Int) = attr("vspace", value)
fun Tag<HTMLMarqueeElement>.vspace(value: Flow<Int>) = attr("vspace", value)

fun Tag<HTMLMarqueeElement>.width(value: String) = attr("width", value)
fun Tag<HTMLMarqueeElement>.width(value: Flow<String>) = attr("width", value)


/*
 * HTMLFrameSetElement attributes
 */
fun Tag<HTMLFrameSetElement>.cols(value: String) = attr("cols", value)
fun Tag<HTMLFrameSetElement>.cols(value: Flow<String>) = attr("cols", value)

fun Tag<HTMLFrameSetElement>.rows(value: String) = attr("rows", value)
fun Tag<HTMLFrameSetElement>.rows(value: Flow<String>) = attr("rows", value)


/*
 * HTMLFrameElement attributes
 */
fun Tag<HTMLFrameElement>.name(value: String) = attr("name", value)
fun Tag<HTMLFrameElement>.name(value: Flow<String>) = attr("name", value)

fun Tag<HTMLFrameElement>.scrolling(value: String) = attr("scrolling", value)
fun Tag<HTMLFrameElement>.scrolling(value: Flow<String>) = attr("scrolling", value)

fun Tag<HTMLFrameElement>.src(value: String) = attr("src", value)
fun Tag<HTMLFrameElement>.src(value: Flow<String>) = attr("src", value)

fun Tag<HTMLFrameElement>.frameBorder(value: String) = attr("frameborder", value)
fun Tag<HTMLFrameElement>.frameBorder(value: Flow<String>) = attr("frameborder", value)

fun Tag<HTMLFrameElement>.longDesc(value: String) = attr("longdesc", value)
fun Tag<HTMLFrameElement>.longDesc(value: Flow<String>) = attr("longdesc", value)

fun Tag<HTMLFrameElement>.noResize(value: Boolean, trueValue: String = "") = attr("noresize", value, trueValue)
fun Tag<HTMLFrameElement>.noResize(value: Flow<Boolean>, trueValue: String = "") = attr("noresize", value, trueValue)

fun Tag<HTMLFrameElement>.marginHeight(value: String) = attr("marginheight", value)
fun Tag<HTMLFrameElement>.marginHeight(value: Flow<String>) = attr("marginheight", value)

fun Tag<HTMLFrameElement>.marginWidth(value: String) = attr("marginwidth", value)
fun Tag<HTMLFrameElement>.marginWidth(value: Flow<String>) = attr("marginwidth", value)


/*
 * HTMLDirectoryElement attributes
 */
fun Tag<HTMLDirectoryElement>.compact(value: Boolean, trueValue: String = "") = attr("compact", value, trueValue)
fun Tag<HTMLDirectoryElement>.compact(value: Flow<Boolean>, trueValue: String = "") = attr("compact", value, trueValue)


/*
 * HTMLFontElement attributes
 */
fun Tag<HTMLFontElement>.color(value: String) = attr("color", value)
fun Tag<HTMLFontElement>.color(value: Flow<String>) = attr("color", value)

fun Tag<HTMLFontElement>.face(value: String) = attr("face", value)
fun Tag<HTMLFontElement>.face(value: Flow<String>) = attr("face", value)

fun Tag<HTMLFontElement>.size(value: String) = attr("size", value)
fun Tag<HTMLFontElement>.size(value: Flow<String>) = attr("size", value)
