(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'fritz2-core-jsLegacy', 'fritz2-styling-jsLegacy', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('fritz2-core-jsLegacy'), require('fritz2-styling-jsLegacy'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-jsLegacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'fritz2-components-jsLegacy'.");
    }if (typeof this['fritz2-core-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-jsLegacy'. Its dependency 'fritz2-core-jsLegacy' was not found. Please, check whether 'fritz2-core-jsLegacy' is loaded prior to 'fritz2-components-jsLegacy'.");
    }if (typeof this['fritz2-styling-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-jsLegacy'. Its dependency 'fritz2-styling-jsLegacy' was not found. Please, check whether 'fritz2-styling-jsLegacy' is loaded prior to 'fritz2-components-jsLegacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-jsLegacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'fritz2-components-jsLegacy'.");
    }root['fritz2-components-jsLegacy'] = factory(typeof this['fritz2-components-jsLegacy'] === 'undefined' ? {} : this['fritz2-components-jsLegacy'], kotlin, this['fritz2-core-jsLegacy'], this['fritz2-styling-jsLegacy'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$fritz2_core_jsLegacy, $module$fritz2_styling_jsLegacy, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var ValidationMessage = $module$fritz2_core_jsLegacy.dev.fritz2.validation.ValidationMessage;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var Validator = $module$fritz2_core_jsLegacy.dev.fritz2.validation.Validator;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Theme = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.theme.Theme;
  var getCallableRef = Kotlin.getCallableRef;
  var Unit = Kotlin.kotlin.Unit;
  var styled = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.params.styled_2u3y5o$;
  var flowOf = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.flowOf_mh5how$;
  var StyleClass = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.StyleClass;
  var trimIndent = Kotlin.kotlin.text.trimIndent_pdl1vz$;
  var staticStyle = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.staticStyle_61zpoe$;
  var whenever = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.whenever_lyupls$;
  var get_name = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.get_name_s0usf7$;
  var params = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.params;
  var styled_0 = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.params.styled_i4v08u$;
  var storeOf = $module$fritz2_core_jsLegacy.dev.fritz2.binding.storeOf_le71cu$;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var staticStyle_0 = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.staticStyle_puj7f4$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var states = $module$fritz2_core_jsLegacy.dev.fritz2.dom.states_2p6s6c$;
  var uniqueId = $module$fritz2_core_jsLegacy.dev.fritz2.identification.uniqueId;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var distinctUntilChanged = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.distinctUntilChanged_x2ftfk$;
  var toString = Kotlin.toString;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var wrapFunction = Kotlin.wrapFunction;
  var Flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.Flow;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var style = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.style_wlso4w$;
  var equals = Kotlin.equals;
  var emptyFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.emptyFlow_287e2$;
  var RootStore = $module$fritz2_core_jsLegacy.dev.fritz2.binding.RootStore;
  var minus = Kotlin.kotlin.collections.minus_2ws7j4$;
  var plus = Kotlin.kotlin.collections.plus_qloxvw$;
  var indexOf = Kotlin.kotlin.text.indexOf_l5u8uk$;
  var numberToLong = Kotlin.numberToLong;
  var awaitClose = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.awaitClose_msfyrq$;
  var callbackFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.callbackFlow_b9ud7o$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var transformLatest = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.transformLatest_ig04k9$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var toList_0 = Kotlin.kotlin.collections.toList_7wnvza$;
  var combineInternal = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.internal.combineInternal_tbd5el$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var Pair = Kotlin.kotlin.Pair;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var maxOrNull = Kotlin.kotlin.collections.maxOrNull_exjks8$;
  var sequenceOf = Kotlin.kotlin.sequences.sequenceOf_i5x0yv$;
  var BoxParams = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.params.BoxParams;
  var throwCCE = Kotlin.throwCCE;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var Map = Kotlin.kotlin.collections.Map;
  var Tag = $module$fritz2_core_jsLegacy.dev.fritz2.dom.Tag;
  var EventContext = $module$fritz2_core_jsLegacy.dev.fritz2.dom.EventContext;
  var IconDefinition = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.theme.IconDefinition;
  var values = $module$fritz2_core_jsLegacy.dev.fritz2.dom.values_2p6s6c$;
  var Div = $module$fritz2_core_jsLegacy.dev.fritz2.dom.html.Div;
  var Random = Kotlin.kotlin.random.Random;
  var UInt = Kotlin.kotlin.UInt;
  var nextUInt = Kotlin.kotlin.random.nextUInt_3yup1w$;
  var dropLast = Kotlin.kotlin.collections.dropLast_yzln2o$;
  var Job = $module$kotlinx_coroutines_core.kotlinx.coroutines.Job_5dx9e$;
  var withIndex = Kotlin.kotlin.collections.withIndex_7wnvza$;
  var watch = $module$fritz2_core_jsLegacy.dev.fritz2.binding.watch_wegvf8$;
  var staticStyle_1 = $module$fritz2_styling_jsLegacy.dev.fritz2.styling.staticStyle_wlso4w$;
  var dom = $module$fritz2_core_jsLegacy.dev.fritz2.dom;
  var Keys = $module$fritz2_core_jsLegacy.dev.fritz2.dom.html.Keys;
  var Exception = Kotlin.kotlin.Exception;
  var L200 = Kotlin.Long.fromInt(200);
  var debounce = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.debounce_6bsce5$;
  var Flow_0 = $module$fritz2_core_jsLegacy.$$importsForInline$$['kotlinx-coroutines-core'].kotlinx.coroutines.flow.Flow;
  var indexOf_0 = Kotlin.kotlin.collections.indexOf_bv23uc$;
  var selectedValue = $module$fritz2_core_jsLegacy.dev.fritz2.dom.selectedValue_avuryo$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var values_0 = $module$fritz2_core_jsLegacy.dev.fritz2.dom.values_wbjycy$;
  var setOf = Kotlin.kotlin.collections.setOf_i5x0yv$;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var asReversed = Kotlin.kotlin.collections.asReversed_2p1efm$;
  var MainScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.MainScope;
  var plus_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.plus_7n4184$;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var L5000 = Kotlin.Long.fromInt(5000);
  var Store = $module$fritz2_core_jsLegacy.dev.fritz2.binding.Store;
  var SubStore = $module$fritz2_core_jsLegacy.dev.fritz2.binding.SubStore;
  Severity.prototype = Object.create(Enum.prototype);
  Severity.prototype.constructor = Severity;
  ComponentValidator.prototype = Object.create(Validator.prototype);
  ComponentValidator.prototype.constructor = ComponentValidator;
  PushButtonComponent$IconPlacement.prototype = Object.create(Enum.prototype);
  PushButtonComponent$IconPlacement.prototype.constructor = PushButtonComponent$IconPlacement;
  InputFormMixin.prototype = Object.create(FormMixin.prototype);
  InputFormMixin.prototype.constructor = InputFormMixin;
  MultiSelectionStore.prototype = Object.create(RootStore.prototype);
  MultiSelectionStore.prototype.constructor = MultiSelectionStore;
  SingleSelectionStore.prototype = Object.create(RootStore.prototype);
  SingleSelectionStore.prototype.constructor = SingleSelectionStore;
  SingleFileSelectionComponent.prototype = Object.create(FileSelectionBaseComponent.prototype);
  SingleFileSelectionComponent.prototype.constructor = SingleFileSelectionComponent;
  MultiFileSelectionComponent.prototype = Object.create(FileSelectionBaseComponent.prototype);
  MultiFileSelectionComponent.prototype.constructor = MultiFileSelectionComponent;
  FormControlComponent$FormSizeContext$FormSizeSpecifier.prototype = Object.create(Enum.prototype);
  FormControlComponent$FormSizeContext$FormSizeSpecifier.prototype.constructor = FormControlComponent$FormSizeContext$FormSizeSpecifier;
  Svg.prototype = Object.create(Tag.prototype);
  Svg.prototype.constructor = Svg;
  OverlayMethod.prototype = Object.create(Enum.prototype);
  OverlayMethod.prototype.constructor = OverlayMethod;
  ModalComponent$ModalsStack.prototype = Object.create(RootStore.prototype);
  ModalComponent$ModalsStack.prototype.constructor = ModalComponent$ModalsStack;
  PopoverComponent$render$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  PopoverComponent$render$ObjectLiteral.prototype.constructor = PopoverComponent$render$ObjectLiteral;
  StackUpComponent.prototype = Object.create(StackComponent.prototype);
  StackUpComponent.prototype.constructor = StackUpComponent;
  LineUpComponent.prototype = Object.create(StackComponent.prototype);
  LineUpComponent.prototype.constructor = LineUpComponent;
  ToastComponent$ToastStore.prototype = Object.create(RootStore.prototype);
  ToastComponent$ToastStore.prototype.constructor = ToastComponent$ToastStore;
  ToastComponent$Companion$closeAllToasts$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  ToastComponent$Companion$closeAllToasts$ObjectLiteral.prototype.constructor = ToastComponent$Companion$closeAllToasts$ObjectLiteral;
  ToastComponent$Companion$closeLastToast$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  ToastComponent$Companion$closeLastToast$ObjectLiteral.prototype.constructor = ToastComponent$Companion$closeLastToast$ObjectLiteral;
  toast$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  toast$ObjectLiteral.prototype.constructor = toast$ObjectLiteral;
  function File(name, type, size, content) {
    this.name = name;
    this.type = type;
    this.size = size;
    this.content = content;
  }
  File.prototype.toString = function () {
    return 'File(name=' + this.name + ', type=' + this.type + ', size=' + this.size.toString() + ', content: ' + this.content + ')';
  };
  File.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'File',
    interfaces: []
  };
  function ComponentValidationMessage(id, severity, message, details) {
    if (details === void 0)
      details = null;
    this.id = id;
    this.severity = severity;
    this.message = message;
    this.details = details;
  }
  ComponentValidationMessage.prototype.isError = function () {
    return this.severity.compareTo_11rb$(Severity$Warning_getInstance()) > 0;
  };
  ComponentValidationMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentValidationMessage',
    interfaces: [ValidationMessage]
  };
  ComponentValidationMessage.prototype.component1 = function () {
    return this.id;
  };
  ComponentValidationMessage.prototype.component2 = function () {
    return this.severity;
  };
  ComponentValidationMessage.prototype.component3 = function () {
    return this.message;
  };
  ComponentValidationMessage.prototype.component4 = function () {
    return this.details;
  };
  ComponentValidationMessage.prototype.copy_tw295j$ = function (id, severity, message, details) {
    return new ComponentValidationMessage(id === void 0 ? this.id : id, severity === void 0 ? this.severity : severity, message === void 0 ? this.message : message, details === void 0 ? this.details : details);
  };
  ComponentValidationMessage.prototype.toString = function () {
    return 'ComponentValidationMessage(id=' + Kotlin.toString(this.id) + (', severity=' + Kotlin.toString(this.severity)) + (', message=' + Kotlin.toString(this.message)) + (', details=' + Kotlin.toString(this.details)) + ')';
  };
  ComponentValidationMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.severity) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    result = result * 31 + Kotlin.hashCode(this.details) | 0;
    return result;
  };
  ComponentValidationMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.severity, other.severity) && Kotlin.equals(this.message, other.message) && Kotlin.equals(this.details, other.details)))));
  };
  function Severity(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Severity_initFields() {
    Severity_initFields = function () {
    };
    Severity$Info_instance = new Severity('Info', 0);
    Severity$Success_instance = new Severity('Success', 1);
    Severity$Warning_instance = new Severity('Warning', 2);
    Severity$Error_instance = new Severity('Error', 3);
  }
  var Severity$Info_instance;
  function Severity$Info_getInstance() {
    Severity_initFields();
    return Severity$Info_instance;
  }
  var Severity$Success_instance;
  function Severity$Success_getInstance() {
    Severity_initFields();
    return Severity$Success_instance;
  }
  var Severity$Warning_instance;
  function Severity$Warning_getInstance() {
    Severity_initFields();
    return Severity$Warning_instance;
  }
  var Severity$Error_instance;
  function Severity$Error_getInstance() {
    Severity_initFields();
    return Severity$Error_instance;
  }
  Severity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Severity',
    interfaces: [Enum]
  };
  function Severity$values() {
    return [Severity$Info_getInstance(), Severity$Success_getInstance(), Severity$Warning_getInstance(), Severity$Error_getInstance()];
  }
  Severity.values = Severity$values;
  function Severity$valueOf(name) {
    switch (name) {
      case 'Info':
        return Severity$Info_getInstance();
      case 'Success':
        return Severity$Success_getInstance();
      case 'Warning':
        return Severity$Warning_getInstance();
      case 'Error':
        return Severity$Error_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.validation.Severity.' + name);
    }
  }
  Severity.valueOf_61zpoe$ = Severity$valueOf;
  function infoMessage(id, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(id, Severity$Info_getInstance(), message, details);
  }
  function successMessage(id, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(id, Severity$Success_getInstance(), message, details);
  }
  function warningMessage(id, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(id, Severity$Warning_getInstance(), message, details);
  }
  function errorMessage(id, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(id, Severity$Error_getInstance(), message, details);
  }
  function ComponentValidator() {
    Validator.call(this);
  }
  ComponentValidator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentValidator',
    interfaces: [Validator]
  };
  function AlertComponent() {
    AlertComponent$Companion_getInstance();
    this.sizes = new ComponentProperty(AlertComponent$sizes$lambda);
    this.stacking = new ComponentProperty(AlertComponent$stacking$lambda);
    this.severity = new ComponentProperty(AlertComponent$severity$lambda);
    this.variant = new ComponentProperty(AlertComponent$variant$lambda);
    this.icon = new ComponentProperty(null);
    this.title_x0rjp9$_0 = null;
    this.content_45m4zg$_0 = null;
  }
  function AlertComponent$Companion() {
    AlertComponent$Companion_instance = this;
    this.accentDecorationThickness_0 = '4px';
  }
  AlertComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AlertComponent$Companion_instance = null;
  function AlertComponent$Companion_getInstance() {
    if (AlertComponent$Companion_instance === null) {
      new AlertComponent$Companion();
    }return AlertComponent$Companion_instance;
  }
  Object.defineProperty(AlertComponent.prototype, 'variantStyles', {
    configurable: true,
    get: function () {
      var alertSeverity = this.severity.value(Theme.Companion.invoke().alert.severities);
      var alertVariantFactory = this.variant.value(Theme.Companion.invoke().alert.variants);
      return alertVariantFactory(alertSeverity.color);
    }
  });
  AlertComponent.prototype.title_izurti$ = function (value) {
    this.title_x0rjp9$_0 = value;
  };
  function AlertComponent$title$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.smaller;
  }
  function AlertComponent$title$lambda$lambda$lambda($receiver) {
    $receiver.right_bcpvvc$(AlertComponent$title$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AlertComponent$title$lambda$lambda$lambda_0($receiver) {
    return $receiver.bold;
  }
  function AlertComponent$title$lambda$lambda($receiver) {
    $receiver.margins_ptb4s1$(AlertComponent$title$lambda$lambda$lambda);
    $receiver.fontWeight_wyjwgc$(AlertComponent$title$lambda$lambda$lambda_0);
    return Unit;
  }
  function AlertComponent$title$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function AlertComponent$title$lambda(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('span', function ($receiver, p1, p2, p3) {
        return $receiver.span_wes3oc$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$title$lambda$lambda)($receiver, AlertComponent$title$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  AlertComponent.prototype.title_p81yox$ = function (value) {
    this.title_izurti$(AlertComponent$title$lambda(value));
  };
  AlertComponent.prototype.title_61zpoe$ = function (value) {
    this.title_p81yox$(flowOf(value));
  };
  AlertComponent.prototype.content_izurti$ = function (value) {
    this.content_45m4zg$_0 = value;
  };
  function AlertComponent$content$lambda$lambda($receiver) {
    return Unit;
  }
  function AlertComponent$content$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function AlertComponent$content$lambda(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('span', function ($receiver, p1, p2, p3) {
        return $receiver.span_wes3oc$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$content$lambda$lambda)($receiver, AlertComponent$content$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  AlertComponent.prototype.content_p81yox$ = function (value) {
    this.content_izurti$(AlertComponent$content$lambda(value));
  };
  AlertComponent.prototype.content_61zpoe$ = function (value) {
    this.content_p81yox$(flowOf(value));
  };
  function AlertComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.flex;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda_0($receiver) {
    $receiver.relative_dkjn9d$(AlertComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AlertComponent$render$lambda$lambda(closure$styling, closure$styles) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(closure$styling);
      $receiver.display_1gh9wc$(AlertComponent$render$lambda$lambda$lambda);
      $receiver.position_wp9r2r$(AlertComponent$render$lambda$lambda$lambda_0);
      $receiver.invoke_qkhqzy$(closure$styles.background);
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_0($receiver) {
    return '100%';
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_1($receiver) {
    return AlertComponent$Companion_getInstance().accentDecorationThickness_0;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_2($receiver) {
    $receiver.absolute_dkjn9d$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda_1(closure$styles) {
    return function ($receiver) {
      $receiver.width_wpghq5$(AlertComponent$render$lambda$lambda$lambda$lambda_0);
      $receiver.height_wpghq5$(AlertComponent$render$lambda$lambda$lambda$lambda_1);
      $receiver.position_wp9r2r$(AlertComponent$render$lambda$lambda$lambda$lambda_2);
      $receiver.invoke_qkhqzy$(closure$styles.decorationTop);
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda_2($receiver) {
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_3($receiver) {
    return AlertComponent$Companion_getInstance().accentDecorationThickness_0;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_4($receiver) {
    return '100%';
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_5($receiver) {
    $receiver.absolute_dkjn9d$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda_3(closure$styles) {
    return function ($receiver) {
      $receiver.width_wpghq5$(AlertComponent$render$lambda$lambda$lambda$lambda_3);
      $receiver.height_wpghq5$(AlertComponent$render$lambda$lambda$lambda$lambda_4);
      $receiver.position_wp9r2r$(AlertComponent$render$lambda$lambda$lambda$lambda_5);
      $receiver.invoke_qkhqzy$(closure$styles.decorationLeft);
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda_4($receiver) {
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_6($receiver) {
    return $receiver.flex;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_7($receiver) {
    return $receiver.center;
  }
  function AlertComponent$render$lambda$lambda$lambda_5(this$AlertComponent) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(AlertComponent$render$lambda$lambda$lambda$lambda_6);
      $receiver.css_61zpoe$('flex-direction: row');
      $receiver.alignItems_tsd917$(AlertComponent$render$lambda$lambda$lambda$lambda_7);
      $receiver.invoke_qkhqzy$(this$AlertComponent.sizes.value(Theme.Companion.invoke().alert.sizes));
      $receiver.invoke_qkhqzy$(this$AlertComponent.stacking.value(Theme.Companion.invoke().alert.stacking));
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_8(closure$styles) {
    return function ($receiver) {
      $receiver.css_61zpoe$('margin-right: var(--al-icon-margin)');
      $receiver.invoke_qkhqzy$(closure$styles.accent);
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    $receiver.css_61zpoe$('width: var(--al-icon-size)');
    $receiver.css_61zpoe$('height: var(--al-icon-size)');
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(this$AlertComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this$AlertComponent.icon.value) != null ? tmp$(Theme.Companion.invoke().icons) : null) != null ? tmp$_0 : this$AlertComponent.severity.value(Theme.Companion.invoke().alert.severities).icon;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_2(this$AlertComponent) {
    return function ($receiver) {
      $receiver.fromTheme_q0wvou$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(this$AlertComponent));
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_9(this$AlertComponent) {
    return function ($receiver) {
      icon($receiver, AlertComponent$render$lambda$lambda$lambda$lambda$lambda_1, void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda$lambda$lambda_2(this$AlertComponent));
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_3($receiver) {
    return $receiver.inlineBlock;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_4($receiver) {
    return $receiver.middle;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_5($receiver) {
    return '100%';
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda_6($receiver) {
    return '1.2em';
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_10(closure$styles) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda_3);
      $receiver.verticalAlign_qe4rxr$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda_4);
      $receiver.width_wpghq5$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda_5);
      $receiver.lineHeight_bcpvvc$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda_6);
      $receiver.invoke_qkhqzy$(closure$styles.text);
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_11(this$AlertComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      (tmp$ = this$AlertComponent.title_x0rjp9$_0) != null ? tmp$($receiver) : null;
      (tmp$_0 = this$AlertComponent.content_45m4zg$_0) != null ? tmp$_0($receiver) : null;
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda_6(closure$styles, this$AlertComponent) {
    return function ($receiver) {
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda$lambda_8(closure$styles))($receiver, AlertComponent$render$lambda$lambda$lambda$lambda_9(this$AlertComponent));
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda$lambda_10(closure$styles))($receiver, AlertComponent$render$lambda$lambda$lambda$lambda_11(this$AlertComponent));
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda_0(closure$styles, this$AlertComponent) {
    return function ($receiver) {
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda_1(closure$styles))($receiver, AlertComponent$render$lambda$lambda$lambda_2);
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda_3(closure$styles))($receiver, AlertComponent$render$lambda$lambda$lambda_4);
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda_5(this$AlertComponent))($receiver, AlertComponent$render$lambda$lambda$lambda_6(closure$styles, this$AlertComponent));
      return Unit;
    };
  }
  AlertComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var styles = this.variantStyles;
    styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), baseClass, id, prefix, AlertComponent$render$lambda$lambda(styling, styles))(context, AlertComponent$render$lambda$lambda_0(styles, this));
    return Unit;
  };
  function AlertComponent$sizes$lambda($receiver) {
    return $receiver.normal;
  }
  function AlertComponent$stacking$lambda($receiver) {
    return $receiver.separated;
  }
  function AlertComponent$severity$lambda($receiver) {
    return $receiver.info;
  }
  function AlertComponent$variant$lambda($receiver) {
    return $receiver.solid;
  }
  AlertComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AlertComponent',
    interfaces: [Component]
  };
  function alert$lambda($receiver) {
    return Unit;
  }
  function alert($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = alert$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'alert';
    var $receiver_0 = new AlertComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function asAlert$lambda($receiver) {
    return $receiver.normal;
  }
  function asAlert$lambda_0($receiver) {
    return $receiver.separated;
  }
  function asAlert$lambda$lambda(closure$receiver) {
    return function ($receiver) {
      switch (closure$receiver.severity.name) {
        case 'Info':
          return $receiver.info;
        case 'Success':
          return $receiver.success;
        case 'Warning':
          return $receiver.warning;
        case 'Error':
          return $receiver.error;
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function asAlert$lambda$lambda_0($receiver) {
    return $receiver.discreet;
  }
  function asAlert$lambda$lambda_1(closure$size) {
    return function ($receiver) {
      return closure$size($receiver);
    };
  }
  function asAlert$lambda$lambda_2(closure$stacking) {
    return function ($receiver) {
      return closure$stacking($receiver);
    };
  }
  function asAlert$lambda_1(closure$receiver, closure$size, closure$stacking, this$asAlert) {
    return function ($receiver) {
      $receiver.severity.invoke_11rb$(asAlert$lambda$lambda(closure$receiver));
      $receiver.variant.invoke_11rb$(asAlert$lambda$lambda_0);
      $receiver.sizes.invoke_11rb$(asAlert$lambda$lambda_1(closure$size));
      $receiver.stacking.invoke_11rb$(asAlert$lambda$lambda_2(closure$stacking));
      $receiver.content_61zpoe$(this$asAlert.message);
      return Unit;
    };
  }
  function asAlert($receiver, renderContext, size, stacking) {
    if (size === void 0)
      size = asAlert$lambda;
    if (stacking === void 0)
      stacking = asAlert$lambda_0;
    var receiver = $receiver;
    alert(renderContext, void 0, void 0, void 0, void 0, asAlert$lambda_1(receiver, size, stacking, $receiver));
  }
  function AppFrameComponent() {
    AppFrameComponent$Companion_getInstance();
    this.sidebarStatus_wvkhbv$_0 = storeOf(false);
    this.toggleSidebar_6hd9tr$_0 = this.sidebarStatus_wvkhbv$_0.handle_7ib3lp$(void 0, AppFrameComponent$toggleSidebar$lambda);
    this.openSideBar_kgdxw7$_0 = staticStyle_0('open-sidebar', trimIndent('\n' + '            @media (max-width: ' + Theme.Companion.invoke().breakPoints.md + ') {' + '\n' + '                transform: translateX(0) !important;' + '\n' + '         }'));
    this.showBackdrop_us9888$_0 = staticStyle_0('show-backdrop', trimIndent('\n' + '            @media (max-width: ' + Theme.Companion.invoke().breakPoints.md + ') {' + '\n' + '                left : 0 !important;' + '\n' + '                opacity: 1 !important;' + '\n' + '            }' + '\n' + '        '));
    this.brand = new ComponentProperty(AppFrameComponent$brand$lambda);
    this.header = new ComponentProperty(AppFrameComponent$header$lambda);
    this.actions = new ComponentProperty(AppFrameComponent$actions$lambda);
    this.sidebarToggle = new ComponentProperty(AppFrameComponent$sidebarToggle$lambda);
    this.nav = new ComponentProperty(AppFrameComponent$nav$lambda);
    this.main = new ComponentProperty(AppFrameComponent$main$lambda);
    this.footer = new ComponentProperty(null);
    this.tabs = new ComponentProperty(null);
  }
  function AppFrameComponent$Companion() {
    AppFrameComponent$Companion_instance = this;
    staticStyle(trimIndent('\n' + '                body {' + '\n' + '                    height: 100vh;' + '\n' + '                    max-height: -webkit-fill-available;' + '\n' + '                    width: 100vw;' + '\n' + '                    display: grid;' + '\n' + '                    grid-template-areas:' + '\n' + '                        ' + '"' + 'brand header' + '"' + '\n' + '                        ' + '"' + 'sidebar main' + '"' + '\n' + '                        ' + '"' + 'sidebar footer' + '"' + ';' + '\n' + '                    grid-template-rows: ' + Theme.Companion.invoke().appFrame.headerHeight + ' 1fr min-content;' + '\n' + '                    grid-auto-columns: min-content 1fr;' + '\n' + '                    padding: 0;' + '\n' + '                    margin: 0; ' + '\n' + '                }' + '\n' + '             '));
  }
  AppFrameComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AppFrameComponent$Companion_instance = null;
  function AppFrameComponent$Companion_getInstance() {
    if (AppFrameComponent$Companion_instance === null) {
      new AppFrameComponent$Companion();
    }return AppFrameComponent$Companion_instance;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda($receiver) {
    return '5000';
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_0($receiver) {
    return Theme.Companion.invoke().appFrame.mobileSidebarWidth;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_1($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda(closure$topPosition) {
    return function ($receiver) {
      return closure$topPosition;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda(closure$topPosition) {
    return function ($receiver) {
      $receiver.top_bcpvvc$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda(closure$topPosition));
      return Unit;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_2(closure$topPosition) {
    return function ($receiver) {
      $receiver.fixed_dkjn9d$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda(closure$topPosition));
      return Unit;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda_0($receiver) {
    $receiver.top_bcpvvc$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_3($receiver) {
    $receiver.relative_dkjn9d$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_4($receiver) {
    return $receiver.flat;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_5($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$mobileSidebar$lambda(closure$topPosition) {
    return function ($receiver) {
      $receiver.zIndex_yiflju$(AppFrameComponent$mobileSidebar$lambda$lambda);
      $receiver.width_5la74k$(AppFrameComponent$mobileSidebar$lambda$lambda_0, AppFrameComponent$mobileSidebar$lambda$lambda_1);
      $receiver.css_d8n4vg$('transform: translateX(-110vw);', 'transform: unset;');
      $receiver.position_vgpajw$(AppFrameComponent$mobileSidebar$lambda$lambda_2(closure$topPosition), AppFrameComponent$mobileSidebar$lambda$lambda_3);
      $receiver.css_61zpoe$(trimIndent('\n            max-height: -webkit-fill-available;\n            will-change: transform;\n            transition: \n                transform .4s ease-in,\n                visibility .4s linear;        \n            '));
      $receiver.boxShadow_h2dnmw$(AppFrameComponent$mobileSidebar$lambda$lambda_4, AppFrameComponent$mobileSidebar$lambda$lambda_5);
      return Unit;
    };
  }
  AppFrameComponent.prototype.mobileSidebar_jpw01d$_0 = function (topPosition) {
    return AppFrameComponent$mobileSidebar$lambda(topPosition);
  };
  function AppFrameComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.block;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_1($receiver) {
    return '0';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda($receiver) {
    return 'rgba(0,0,0,0.8)';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_2($receiver) {
    $receiver.color_jl9ed9$(AppFrameComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '0';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return '-110vh';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_0($receiver) {
    $receiver.top_bcpvvc$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda);
    $receiver.left_bcpvvc$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_3($receiver) {
    $receiver.fixed_dkjn9d$(AppFrameComponent$render$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_4($receiver) {
    return '100vw';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_5($receiver) {
    return 'min(100vh, 100%)';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_6($receiver) {
    return '4000';
  }
  function AppFrameComponent$render$lambda$lambda($receiver) {
    $receiver.display_76osno$(AppFrameComponent$render$lambda$lambda$lambda, AppFrameComponent$render$lambda$lambda$lambda_0);
    $receiver.opacity_y3j6id$(AppFrameComponent$render$lambda$lambda$lambda_1);
    $receiver.background_f5fcq6$(AppFrameComponent$render$lambda$lambda$lambda_2);
    $receiver.position_wp9r2r$(AppFrameComponent$render$lambda$lambda$lambda_3);
    $receiver.width_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda_4);
    $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda_5);
    $receiver.css_61zpoe$('height: -webkit-fill-available;');
    $receiver.zIndex_yiflju$(AppFrameComponent$render$lambda$lambda$lambda_6);
    $receiver.css_61zpoe$(trimIndent('\n            transition: \n                opacity .3s ease-in;        \n        '));
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda_0(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(whenever(this$AppFrameComponent.showBackdrop_us9888$_0, this$AppFrameComponent.sidebarStatus_wvkhbv$_0.data)));
      $receiver.handledBy_jora5j$($receiver.clicks, this$AppFrameComponent.toggleSidebar_6hd9tr$_0);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_1() {
    return 'header';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_7($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_2() {
    return 'brand';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_8($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_2);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_9($receiver) {
    return Theme.Companion.invoke().appFrame.headerHeight;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_10($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent$render$lambda$lambda_1(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.grid_jhf0yc$(AppFrameComponent$render$lambda$lambda$lambda_7, AppFrameComponent$render$lambda$lambda$lambda_8);
      $receiver.invoke_qkhqzy$(this$AppFrameComponent.mobileSidebar_jpw01d$_0('none'));
      $receiver.height_5la74k$(AppFrameComponent$render$lambda$lambda$lambda_9, AppFrameComponent$render$lambda$lambda$lambda_10);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_3($receiver) {
    return Theme.Companion.invoke().appFrame.headerHeight;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_11($receiver) {
    $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_3);
    $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.brand);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_12(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.brand.value($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_2(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(whenever(this$AppFrameComponent.openSideBar_kgdxw7$_0, this$AppFrameComponent.sidebarStatus_wvkhbv$_0.data)));
      flexBox($receiver, AppFrameComponent$render$lambda$lambda$lambda_11, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda_12(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_4() {
    return 'header';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_13($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_4);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda_3($receiver) {
    $receiver.grid_5hf0eu$(AppFrameComponent$render$lambda$lambda$lambda_13);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_5($receiver) {
    return Theme.Companion.invoke().appFrame.headerHeight;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_14($receiver) {
    $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_5);
    $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.header);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    return $receiver.center;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_6($receiver) {
    $receiver.alignItems_tsd917$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_2($receiver) {
    return $receiver.tiny;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_3(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.sidebarToggle.value($receiver, this$AppFrameComponent.toggleSidebar_6hd9tr$_0);
      this$AppFrameComponent.header.value($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_7(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_2);
      $receiver.items.invoke_11rb$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_3(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_8(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.actions.value($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda_15(this$AppFrameComponent) {
    return function ($receiver) {
      lineUp($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda_6, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda_7(this$AppFrameComponent));
      $receiver.section_viepbn$(void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda_8(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_4(this$AppFrameComponent) {
    return function ($receiver) {
      flexBox($receiver, AppFrameComponent$render$lambda$lambda$lambda_14, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda_15(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_9() {
    return 'main';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_16($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_9);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_10() {
    return 'sidebar';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_17($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_10);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_18($receiver) {
    return $receiver.hidden;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_19($receiver) {
    return 'calc(100% - ' + Theme.Companion.invoke().appFrame.headerHeight + ')';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_20($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent$render$lambda$lambda_5(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.grid_jhf0yc$(AppFrameComponent$render$lambda$lambda$lambda_16, AppFrameComponent$render$lambda$lambda$lambda_17);
      $receiver.invoke_qkhqzy$(this$AppFrameComponent.mobileSidebar_jpw01d$_0(Theme.Companion.invoke().appFrame.headerHeight));
      $receiver.overflow_c5t1z2$(AppFrameComponent$render$lambda$lambda$lambda_18);
      $receiver.height_5la74k$(AppFrameComponent$render$lambda$lambda$lambda_19, AppFrameComponent$render$lambda$lambda$lambda_20);
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.sidebar);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_11($receiver) {
    return $receiver.column;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_12($receiver) {
    return $receiver.stretch;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_13($receiver) {
    return $receiver.spaceBetween;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_14($receiver) {
    return $receiver.full;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_15($receiver) {
    return '-webkit-fill-available';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_16($receiver) {
    return $receiver.auto;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_21($receiver) {
    $receiver.direction_la6ffj$(AppFrameComponent$render$lambda$lambda$lambda$lambda_11);
    $receiver.alignItems_tsd917$(AppFrameComponent$render$lambda$lambda$lambda$lambda_12);
    $receiver.justifyContent_vlnw1j$(AppFrameComponent$render$lambda$lambda$lambda$lambda_13);
    $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_14);
    $receiver.maxHeight_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_15);
    $receiver.overflow_c5t1z2$(AppFrameComponent$render$lambda$lambda$lambda$lambda_16);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_17($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.nav);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_18(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.nav.value($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_4($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.footer);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_5(closure$footer) {
    return function ($receiver) {
      closure$footer($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda_22(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      styled(getCallableRef('section', function ($receiver, p1, p2, p3) {
        return $receiver.section_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda_17)($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda_18(this$AppFrameComponent));
      if ((tmp$ = this$AppFrameComponent.footer.value) != null) {
        styled(getCallableRef('section', function ($receiver, p1, p2, p3) {
          return $receiver.section_viepbn$(p1, p2, p3);
        }.bind(null, $receiver)), void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_4)($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_5(tmp$));
      }return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_6(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(whenever(this$AppFrameComponent.openSideBar_kgdxw7$_0, this$AppFrameComponent.sidebarStatus_wvkhbv$_0.data)));
      flexBox($receiver, AppFrameComponent$render$lambda$lambda$lambda_21, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda_22(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_19() {
    return 'main';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_23($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_19);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_24($receiver) {
    return params.OverflowValues.auto;
  }
  function AppFrameComponent$render$lambda$lambda_7(closure$styling) {
    return function ($receiver) {
      $receiver.grid_5hf0eu$(AppFrameComponent$render$lambda$lambda$lambda_23);
      $receiver.overflow_c5t1z2$(AppFrameComponent$render$lambda$lambda$lambda_24);
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.main);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_8(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.main.value($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_6() {
    return 'footer';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_20($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_6);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_21($receiver) {
    return $receiver.row;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_22($receiver) {
    return $receiver.center;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_23($receiver) {
    return $receiver.spaceEvenly;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_25($receiver) {
    $receiver.grid_5hf0eu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_20);
    $receiver.direction_la6ffj$(AppFrameComponent$render$lambda$lambda$lambda$lambda_21);
    $receiver.alignItems_tsd917$(AppFrameComponent$render$lambda$lambda$lambda$lambda_22);
    $receiver.justifyContent_vlnw1j$(AppFrameComponent$render$lambda$lambda$lambda$lambda_23);
    $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.tabs);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_26(closure$tabs) {
    return function ($receiver) {
      closure$tabs($receiver);
      return Unit;
    };
  }
  AppFrameComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var tmp$;
    box(context, AppFrameComponent$render$lambda$lambda, void 0, void 0, 'backdrop', AppFrameComponent$render$lambda$lambda_0(this));
    styled(getCallableRef('header', function ($receiver, p1, p2, p3) {
      return $receiver.header_viepbn$(p1, p2, p3);
    }.bind(null, context)), void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda_1(this))(context, AppFrameComponent$render$lambda$lambda_2(this));
    styled(getCallableRef('header', function ($receiver, p1, p2, p3) {
      return $receiver.header_viepbn$(p1, p2, p3);
    }.bind(null, context)), void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda_3)(context, AppFrameComponent$render$lambda$lambda_4(this));
    styled(getCallableRef('aside', function ($receiver, p1, p2, p3) {
      return $receiver.aside_viepbn$(p1, p2, p3);
    }.bind(null, context)), void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda_5(this))(context, AppFrameComponent$render$lambda$lambda_6(this));
    styled_0(getCallableRef('main', function ($receiver, p1, p2, p3) {
      return $receiver.main_viepbn$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass, id, prefix, AppFrameComponent$render$lambda$lambda_7(styling))(context, AppFrameComponent$render$lambda$lambda_8(this));
    if ((tmp$ = this.tabs.value) != null) {
      flexBox(context, AppFrameComponent$render$lambda$lambda$lambda_25, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda_26(tmp$));
    }return Unit;
  };
  function Coroutine$AppFrameComponent$toggleSidebar$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$AppFrameComponent$toggleSidebar$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$AppFrameComponent$toggleSidebar$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$AppFrameComponent$toggleSidebar$lambda.prototype.constructor = Coroutine$AppFrameComponent$toggleSidebar$lambda;
  Coroutine$AppFrameComponent$toggleSidebar$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function AppFrameComponent$toggleSidebar$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$AppFrameComponent$toggleSidebar$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function AppFrameComponent$brand$lambda($receiver) {
    return Unit;
  }
  function AppFrameComponent$header$lambda($receiver) {
    return Unit;
  }
  function AppFrameComponent$actions$lambda($receiver) {
    return Unit;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda$lambda($receiver) {
    return '-.5rem';
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda_1($receiver) {
    $receiver.left_bcpvvc$(AppFrameComponent$sidebarToggle$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda($receiver) {
    $receiver.display_76osno$(void 0, AppFrameComponent$sidebarToggle$lambda$lambda$lambda);
    $receiver.padding_bcpvvc$(AppFrameComponent$sidebarToggle$lambda$lambda$lambda_0);
    $receiver.margins_ptb4s1$(AppFrameComponent$sidebarToggle$lambda$lambda$lambda_1);
    return Unit;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda_2($receiver) {
    return $receiver.link;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.menu;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda$lambda_3($receiver) {
    $receiver.fromTheme_q0wvou$(AppFrameComponent$sidebarToggle$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda_0($receiver) {
    $receiver.variant.invoke_11rb$(AppFrameComponent$sidebarToggle$lambda$lambda$lambda_2);
    $receiver.icon_8nbis2$(void 0, void 0, void 0, void 0, AppFrameComponent$sidebarToggle$lambda$lambda$lambda_3);
    return Unit;
  }
  function AppFrameComponent$sidebarToggle$lambda($receiver, sidebarToggle) {
    $receiver.handledBy_jora5j$(clickButton($receiver, AppFrameComponent$sidebarToggle$lambda$lambda, void 0, void 0, void 0, AppFrameComponent$sidebarToggle$lambda$lambda_0), sidebarToggle);
    return Unit;
  }
  function AppFrameComponent$nav$lambda($receiver) {
    return Unit;
  }
  function AppFrameComponent$main$lambda($receiver) {
    return Unit;
  }
  AppFrameComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AppFrameComponent',
    interfaces: [Component]
  };
  function appFrame$lambda($receiver) {
    return Unit;
  }
  function appFrame$lambda_0($receiver) {
    return Unit;
  }
  function appFrame($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = appFrame$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'app';
    if (build === void 0)
      build = appFrame$lambda_0;
    var $receiver_0 = new AppFrameComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function box$lambda($receiver) {
    return Unit;
  }
  function box$lambda_0($receiver) {
    return Unit;
  }
  function box($receiver, styling, baseClass, id, prefix, init) {
    if (styling === void 0)
      styling = box$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'box';
    return styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, $receiver)), styling, baseClass, id, prefix, box$lambda_0)($receiver, init);
  }
  function flexBox$lambda($receiver) {
    return Unit;
  }
  function flexBox$lambda_0($receiver) {
    $receiver.css_61zpoe$('display: flex;');
    return Unit;
  }
  function flexBox($receiver, styling, baseClass, id, prefix, init) {
    if (styling === void 0)
      styling = flexBox$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'flex-box';
    return styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, $receiver)), styling, baseClass, id, prefix, flexBox$lambda_0)($receiver, init);
  }
  function gridBox$lambda($receiver) {
    return Unit;
  }
  function gridBox$lambda_0($receiver) {
    $receiver.css_61zpoe$('display: grid;');
    return Unit;
  }
  function gridBox($receiver, styling, baseClass, id, prefix, init) {
    if (styling === void 0)
      styling = gridBox$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'grid-box';
    return styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, $receiver)), styling, baseClass, id, prefix, gridBox$lambda_0)($receiver, init);
  }
  function plus$lambda(this$plus, closure$other) {
    return function ($receiver) {
      this$plus($receiver);
      closure$other($receiver);
      return Unit;
    };
  }
  function PushButtonComponent() {
    PushButtonComponent$Companion_getInstance();
    this.$delegate_fr0ikh$_0 = new EventMixin();
    this.$delegate_fr0ikh$_1 = new ElementMixin();
    this.$delegate_fr0ikh$_2 = new FormMixin();
    this.iconSize_iolxhr$_0 = '1.15em';
    this.marginToText_k0emvf$_0 = '0.35rem';
    this.marginToBorder_ry2g6i$_0 = '-0.2rem';
    this.centerIconStyle = PushButtonComponent$centerIconStyle$lambda;
    this.centerSpinnerStyle = PushButtonComponent$centerSpinnerStyle$lambda(this);
    this.leftSpinnerStyle = PushButtonComponent$leftSpinnerStyle$lambda(this);
    this.rightSpinnerStyle = PushButtonComponent$rightSpinnerStyle$lambda(this);
    this.leftIconStyle = PushButtonComponent$leftIconStyle$lambda(this);
    this.rightIconStyle = PushButtonComponent$rightIconStyle$lambda(this);
    this.colorField_1kh8wk$_0 = this.buildColor_cs4xwo$_0(Theme.Companion.invoke().colors.primary.base);
    this.variant = new ComponentProperty(PushButtonComponent$variant$lambda);
    this.size = new ComponentProperty(PushButtonComponent$size$lambda);
    this.text_us8h6m$_0 = null;
    this.loadingText_mfsiow$_0 = null;
    this.loading_89v1pv$_0 = null;
    this.icon_um59v6$_0 = null;
    this.iconPlacement = new ComponentProperty(PushButtonComponent$iconPlacement$lambda);
  }
  function PushButtonComponent$Companion() {
    PushButtonComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('button', '\n                appearance: none;\n                display: inline-flex;\n                align-items : center;\n                justify-content: center;\n                transition: all 250ms;\n                user-select: none;\n                white-space: nowrap;\n                vertical-align: middle;\n                outline: none;\n                text-overflow: ellipsis;\n                \n                &:disabled {\n                    opacity: 0.4;\n                    cursor: not-allowed;\n                    boxShadow: none;\n                }\n            ');
    this.hidden_8be2vx$ = staticStyle_0('hidden', 'visibility: hidden;');
    this.iconPlacementContext = new PushButtonComponent$IconPlacementContext();
  }
  PushButtonComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PushButtonComponent$Companion_instance = null;
  function PushButtonComponent$Companion_getInstance() {
    if (PushButtonComponent$Companion_instance === null) {
      new PushButtonComponent$Companion();
    }return PushButtonComponent$Companion_instance;
  }
  function PushButtonComponent$buildColor$lambda(closure$value) {
    return function ($receiver) {
      $receiver.css_61zpoe$('--main-color: ' + closure$value + ';');
      return Unit;
    };
  }
  PushButtonComponent.prototype.buildColor_cs4xwo$_0 = function (value) {
    return PushButtonComponent$buildColor$lambda(value);
  };
  PushButtonComponent.prototype.color_jl9ed9$ = function (value) {
    this.colorField_1kh8wk$_0 = this.buildColor_cs4xwo$_0(value(Theme.Companion.invoke().colors));
  };
  function PushButtonComponent$text$lambda$lambda(closure$value, closure$hide) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      if (closure$hide)
        $receiver.className_61zpoe$(PushButtonComponent$Companion_getInstance().hidden_8be2vx$.name);
      return Unit;
    };
  }
  function PushButtonComponent$text$lambda(closure$value) {
    return function ($receiver, hide) {
      $receiver.span_wes3oc$(void 0, void 0, PushButtonComponent$text$lambda$lambda(closure$value, hide));
      return Unit;
    };
  }
  PushButtonComponent.prototype.text_61zpoe$ = function (value) {
    this.text_us8h6m$_0 = PushButtonComponent$text$lambda(value);
  };
  function PushButtonComponent$text$lambda$lambda_0(closure$value, closure$hide) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      if (closure$hide)
        $receiver.className_61zpoe$(PushButtonComponent$Companion_getInstance().hidden_8be2vx$.name);
      return Unit;
    };
  }
  function PushButtonComponent$text$lambda_0(closure$value) {
    return function ($receiver, hide) {
      $receiver.span_wes3oc$(void 0, void 0, PushButtonComponent$text$lambda$lambda_0(closure$value, hide));
      return Unit;
    };
  }
  PushButtonComponent.prototype.text_p81yox$ = function (value) {
    this.text_us8h6m$_0 = PushButtonComponent$text$lambda_0(value);
  };
  function PushButtonComponent$loadingText$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  function PushButtonComponent$loadingText$lambda(closure$value) {
    return function ($receiver) {
      $receiver.span_wes3oc$(void 0, void 0, PushButtonComponent$loadingText$lambda$lambda(closure$value));
      return Unit;
    };
  }
  PushButtonComponent.prototype.loadingText_61zpoe$ = function (value) {
    this.loadingText_mfsiow$_0 = PushButtonComponent$loadingText$lambda(value);
  };
  function PushButtonComponent$loadingText$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function PushButtonComponent$loadingText$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_wes3oc$(void 0, void 0, PushButtonComponent$loadingText$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PushButtonComponent.prototype.loadingText_p81yox$ = function (value) {
    this.loadingText_mfsiow$_0 = PushButtonComponent$loadingText$lambda_0(value);
  };
  PushButtonComponent.prototype.loading_433wua$ = function (value) {
    this.loading_89v1pv$_0 = value;
  };
  function PushButtonComponent$icon$lambda($receiver) {
    return Unit;
  }
  function PushButtonComponent$icon$lambda_0($receiver) {
    return Unit;
  }
  function PushButtonComponent$icon$lambda_1(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build) {
    return function (context, iconStyle) {
      icon(context, plus$lambda(closure$styling, iconStyle), closure$baseClass, closure$id, closure$prefix, closure$build);
      return Unit;
    };
  }
  PushButtonComponent.prototype.icon_8nbis2$ = function (styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = PushButtonComponent$icon$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = IconComponent$Companion_getInstance().prefix;
    if (build === void 0)
      build = PushButtonComponent$icon$lambda_0;
    this.icon_um59v6$_0 = PushButtonComponent$icon$lambda_1(styling, baseClass, id, prefix, build);
  };
  function PushButtonComponent$IconPlacement(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PushButtonComponent$IconPlacement_initFields() {
    PushButtonComponent$IconPlacement_initFields = function () {
    };
    PushButtonComponent$IconPlacement$Right_instance = new PushButtonComponent$IconPlacement('Right', 0);
    PushButtonComponent$IconPlacement$Left_instance = new PushButtonComponent$IconPlacement('Left', 1);
  }
  var PushButtonComponent$IconPlacement$Right_instance;
  function PushButtonComponent$IconPlacement$Right_getInstance() {
    PushButtonComponent$IconPlacement_initFields();
    return PushButtonComponent$IconPlacement$Right_instance;
  }
  var PushButtonComponent$IconPlacement$Left_instance;
  function PushButtonComponent$IconPlacement$Left_getInstance() {
    PushButtonComponent$IconPlacement_initFields();
    return PushButtonComponent$IconPlacement$Left_instance;
  }
  PushButtonComponent$IconPlacement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IconPlacement',
    interfaces: [Enum]
  };
  function PushButtonComponent$IconPlacement$values() {
    return [PushButtonComponent$IconPlacement$Right_getInstance(), PushButtonComponent$IconPlacement$Left_getInstance()];
  }
  PushButtonComponent$IconPlacement.values = PushButtonComponent$IconPlacement$values;
  function PushButtonComponent$IconPlacement$valueOf(name) {
    switch (name) {
      case 'Right':
        return PushButtonComponent$IconPlacement$Right_getInstance();
      case 'Left':
        return PushButtonComponent$IconPlacement$Left_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.PushButtonComponent.IconPlacement.' + name);
    }
  }
  PushButtonComponent$IconPlacement.valueOf_61zpoe$ = PushButtonComponent$IconPlacement$valueOf;
  function PushButtonComponent$IconPlacementContext() {
    this.right = PushButtonComponent$IconPlacement$Right_getInstance();
    this.left = PushButtonComponent$IconPlacement$Left_getInstance();
  }
  PushButtonComponent$IconPlacementContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IconPlacementContext',
    interfaces: []
  };
  function PushButtonComponent$render$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$PushButtonComponent.colorField_1kh8wk$_0);
      $receiver.invoke_qkhqzy$(this$PushButtonComponent.variant.value(Theme.Companion.invoke().button.variants));
      $receiver.invoke_qkhqzy$(this$PushButtonComponent.size.value(Theme.Companion.invoke().button.sizes));
      return Unit;
    };
  }
  function PushButtonComponent$render$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.disabled_f1igrw$(this$PushButtonComponent.disabled.values);
      if (this$PushButtonComponent.text_us8h6m$_0 == null) {
        this$PushButtonComponent.renderIcon_w39yh$_0($receiver, this$PushButtonComponent.centerIconStyle, this$PushButtonComponent.centerSpinnerStyle);
      } else {
        if (this$PushButtonComponent.icon_um59v6$_0 != null && this$PushButtonComponent.iconPlacement.value(PushButtonComponent$Companion_getInstance().iconPlacementContext) === PushButtonComponent$IconPlacement$Left_getInstance()) {
          this$PushButtonComponent.renderIcon_w39yh$_0($receiver, this$PushButtonComponent.leftIconStyle, this$PushButtonComponent.leftSpinnerStyle);
        }this$PushButtonComponent.renderText_rl3h9x$_0($receiver);
        if (this$PushButtonComponent.icon_um59v6$_0 != null && this$PushButtonComponent.iconPlacement.value(PushButtonComponent$Companion_getInstance().iconPlacementContext) === PushButtonComponent$IconPlacement$Right_getInstance()) {
          this$PushButtonComponent.renderIcon_w39yh$_0($receiver, this$PushButtonComponent.rightIconStyle, this$PushButtonComponent.rightSpinnerStyle);
        }}
      this$PushButtonComponent.events.value($receiver);
      this$PushButtonComponent.element.value($receiver);
      return Unit;
    };
  }
  PushButtonComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    styled_0(getCallableRef('button', function ($receiver, p1, p2, p3) {
      return $receiver.button_jk96ic$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass.plus_fox8kt$(PushButtonComponent$Companion_getInstance().staticCss), id, prefix, PushButtonComponent$render$lambda$lambda(this))(context, PushButtonComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  function PushButtonComponent$renderIcon$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function PushButtonComponent$renderIcon$lambda$lambda(closure$spinnerStyle, this$PushButtonComponent, closure$iconStyle) {
    return function ($receiver, running) {
      var tmp$;
      if (running) {
        spinner($receiver, closure$spinnerStyle, void 0, void 0, void 0, PushButtonComponent$renderIcon$lambda$lambda$lambda);
      } else {
        (tmp$ = this$PushButtonComponent.icon_um59v6$_0) != null ? tmp$($receiver, closure$iconStyle) : null;
      }
      return Unit;
    };
  }
  PushButtonComponent.prototype.renderIcon_w39yh$_0 = function (renderContext, iconStyle, spinnerStyle) {
    var tmp$;
    if (this.loading_89v1pv$_0 == null) {
      (tmp$ = this.icon_um59v6$_0) != null ? tmp$(renderContext, iconStyle) : null;
    } else {
      var tmp$_0;
      (tmp$_0 = this.loading_89v1pv$_0) != null ? (renderContext.render_8vs4x2$(tmp$_0, PushButtonComponent$renderIcon$lambda$lambda(spinnerStyle, this, iconStyle)), Unit) : null;
    }
  };
  function PushButtonComponent$renderText$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      if (this$PushButtonComponent.loadingText_mfsiow$_0 == null) {
        $receiver.css_61zpoe$('position: absolute;');
        $receiver.invoke_qkhqzy$(this$PushButtonComponent.centerSpinnerStyle);
      } else
        $receiver.invoke_qkhqzy$(this$PushButtonComponent.leftSpinnerStyle);
      return Unit;
    };
  }
  function PushButtonComponent$renderText$lambda$lambda$lambda_0($receiver) {
    return Unit;
  }
  function PushButtonComponent$renderText$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver, running) {
      var tmp$, tmp$_0;
      if (running) {
        spinner($receiver, PushButtonComponent$renderText$lambda$lambda$lambda(this$PushButtonComponent), void 0, void 0, void 0, PushButtonComponent$renderText$lambda$lambda$lambda_0);
        if (this$PushButtonComponent.loadingText_mfsiow$_0 != null) {
          ensureNotNull(this$PushButtonComponent.loadingText_mfsiow$_0)($receiver);
        } else {
          (tmp$ = this$PushButtonComponent.text_us8h6m$_0) != null ? tmp$($receiver, true) : null;
        }
      } else {
        (tmp$_0 = this$PushButtonComponent.text_us8h6m$_0) != null ? tmp$_0($receiver, false) : null;
      }
      return Unit;
    };
  }
  PushButtonComponent.prototype.renderText_rl3h9x$_0 = function (renderContext) {
    var tmp$;
    if (this.loading_89v1pv$_0 == null || this.icon_um59v6$_0 != null) {
      (tmp$ = this.text_us8h6m$_0) != null ? tmp$(renderContext, false) : null;
    } else {
      var tmp$_0;
      (tmp$_0 = this.loading_89v1pv$_0) != null ? (renderContext.render_8vs4x2$(tmp$_0, PushButtonComponent$renderText$lambda$lambda(this)), Unit) : null;
    }
  };
  Object.defineProperty(PushButtonComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_fr0ikh$_0.events;
    }
  });
  Object.defineProperty(PushButtonComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_fr0ikh$_1.element;
    }
  });
  Object.defineProperty(PushButtonComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_fr0ikh$_2.disabled;
    }
  });
  PushButtonComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_fr0ikh$_2.enabled_6taknv$(value);
  };
  PushButtonComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_fr0ikh$_2.enabled_433wua$(value);
  };
  function PushButtonComponent$centerIconStyle$lambda$lambda($receiver) {
    return '1.5em';
  }
  function PushButtonComponent$centerIconStyle$lambda$lambda_0($receiver) {
    return '1.5em';
  }
  function PushButtonComponent$centerIconStyle$lambda($receiver) {
    $receiver.width_wpghq5$(PushButtonComponent$centerIconStyle$lambda$lambda);
    $receiver.height_wpghq5$(PushButtonComponent$centerIconStyle$lambda$lambda_0);
    return Unit;
  }
  function PushButtonComponent$centerSpinnerStyle$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_iolxhr$_0;
    };
  }
  function PushButtonComponent$centerSpinnerStyle$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_iolxhr$_0;
    };
  }
  function PushButtonComponent$centerSpinnerStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$centerSpinnerStyle$lambda$lambda(this$PushButtonComponent));
      $receiver.height_wpghq5$(PushButtonComponent$centerSpinnerStyle$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda_0($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_ry2g6i$_0;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_k0emvf$_0;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.right_bcpvvc$(PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$leftSpinnerStyle$lambda$lambda);
      $receiver.height_wpghq5$(PushButtonComponent$leftSpinnerStyle$lambda$lambda_0);
      $receiver.margins_ptb4s1$(PushButtonComponent$leftSpinnerStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda_0($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_k0emvf$_0;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_ry2g6i$_0;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.right_bcpvvc$(PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$rightSpinnerStyle$lambda$lambda);
      $receiver.height_wpghq5$(PushButtonComponent$rightSpinnerStyle$lambda$lambda_0);
      $receiver.margins_ptb4s1$(PushButtonComponent$rightSpinnerStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_iolxhr$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_iolxhr$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_ry2g6i$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_k0emvf$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(PushButtonComponent$leftIconStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.right_bcpvvc$(PushButtonComponent$leftIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$leftIconStyle$lambda$lambda(this$PushButtonComponent));
      $receiver.height_wpghq5$(PushButtonComponent$leftIconStyle$lambda$lambda_0(this$PushButtonComponent));
      $receiver.margins_ptb4s1$(PushButtonComponent$leftIconStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_iolxhr$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_iolxhr$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_ry2g6i$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_k0emvf$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.right_bcpvvc$(PushButtonComponent$rightIconStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.left_bcpvvc$(PushButtonComponent$rightIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$rightIconStyle$lambda$lambda(this$PushButtonComponent));
      $receiver.height_wpghq5$(PushButtonComponent$rightIconStyle$lambda$lambda_0(this$PushButtonComponent));
      $receiver.margins_ptb4s1$(PushButtonComponent$rightIconStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$variant$lambda($receiver) {
    return Theme.Companion.invoke().button.variants.solid;
  }
  function PushButtonComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().button.sizes.normal;
  }
  function PushButtonComponent$iconPlacement$lambda($receiver) {
    return PushButtonComponent$IconPlacement$Left_getInstance();
  }
  PushButtonComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PushButtonComponent',
    interfaces: [FormProperties, ElementProperties, EventProperties, Component]
  };
  function pushButton$lambda($receiver) {
    return Unit;
  }
  function pushButton$lambda_0($receiver) {
    return Unit;
  }
  function pushButton($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = pushButton$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'push-button';
    if (build === void 0)
      build = pushButton$lambda_0;
    var $receiver_0 = new PushButtonComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function clickButton$lambda($receiver) {
    return Unit;
  }
  function clickButton$lambda_0($receiver) {
    return Unit;
  }
  function clickButton$lambda$lambda(closure$clickEvents) {
    return function ($receiver) {
      closure$clickEvents.v = $receiver.clicks;
      return Unit;
    };
  }
  function clickButton$lambda_1(closure$build, closure$clickEvents) {
    return function ($receiver) {
      closure$build($receiver);
      $receiver.events.invoke_11rb$(clickButton$lambda$lambda(closure$clickEvents));
      return Unit;
    };
  }
  function clickButton($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = clickButton$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'push-button';
    if (build === void 0)
      build = clickButton$lambda_0;
    var clickEvents = {v: null};
    pushButton($receiver, styling, baseClass, id, prefix, clickButton$lambda_1(build, clickEvents));
    return ensureNotNull(clickEvents.v);
  }
  function CheckboxComponent(store) {
    CheckboxComponent$Companion_getInstance();
    this.store = store;
    this.$delegate_e77820$_0 = new EventMixin();
    this.$delegate_e77820$_1 = new ElementMixin();
    this.$delegate_e77820$_2 = new InputFormMixin();
    this.$delegate_e77820$_3 = new SeverityMixin();
    this.size = new ComponentProperty(CheckboxComponent$size$lambda);
    this.icon = new ComponentProperty(CheckboxComponent$icon$lambda);
    this.labelField_6jiggi$_0 = null;
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.label);
    this.checked = new DynamicComponentProperty(flowOf(false));
    this.checkedStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.checked);
  }
  function CheckboxComponent$Companion() {
    CheckboxComponent$Companion_instance = this;
    this.checkboxInputStaticCss = staticStyle_0('checkbox', '\n            position: absolute;\n            height: 1px;                \n            width: 1px;                \n            overflow: hidden;\n            clip: rect(1px 1px 1px 1px); /* IE6, IE7 */\n            clip: rect(1px, 1px, 1px, 1px);\n            outline: none;           \n            &:focus{\n                outline: none;\n            }           \n            ');
  }
  CheckboxComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CheckboxComponent$Companion_instance = null;
  function CheckboxComponent$Companion_getInstance() {
    if (CheckboxComponent$Companion_instance === null) {
      new CheckboxComponent$Companion();
    }return CheckboxComponent$Companion_instance;
  }
  function CheckboxComponent$label$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  function CheckboxComponent$label$lambda(closure$value) {
    return function ($receiver) {
      $receiver.span_wes3oc$(void 0, void 0, CheckboxComponent$label$lambda$lambda(closure$value));
      return Unit;
    };
  }
  CheckboxComponent.prototype.label_61zpoe$ = function (value) {
    this.labelField_6jiggi$_0 = CheckboxComponent$label$lambda(value);
  };
  function CheckboxComponent$label$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function CheckboxComponent$label$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_wes3oc$(void 0, void 0, CheckboxComponent$label$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  CheckboxComponent.prototype.label_p81yox$ = function (value) {
    this.labelField_6jiggi$_0 = CheckboxComponent$label$lambda_0(value);
  };
  CheckboxComponent.prototype.label_izurti$ = function (value) {
    this.labelField_6jiggi$_0 = value;
  };
  function CheckboxComponent$render$lambda$lambda(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CheckboxComponent.size.value(Theme.Companion.invoke().checkbox.sizes));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CheckboxComponent.checkedStyle.value);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().checkbox.input);
      $receiver.children_qlrppv$('&[checked] + div', CheckboxComponent$render$lambda$lambda$lambda$lambda(this$CheckboxComponent));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_0(this$CheckboxComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.disabled_f1igrw$(this$CheckboxComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$CheckboxComponent.readonly.values);
      $receiver.type_61zpoe$('checkbox');
      $receiver.checked_f1igrw$((tmp$_0 = (tmp$ = this$CheckboxComponent.store) != null ? tmp$.data : null) != null ? tmp$_0 : this$CheckboxComponent.checked.values);
      $receiver.className_p81yox$(get_name(this$CheckboxComponent.severityClassOf_i6436e$(Theme.Companion.invoke().checkbox.severity)));
      if ((tmp$_1 = this$CheckboxComponent.store) != null) {
        $receiver.handledBy_ytah3h$(states($receiver.changes), tmp$_1.update);
      }this$CheckboxComponent.events.value($receiver);
      this$CheckboxComponent.element.value($receiver);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_1(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().checkbox.default);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_0($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().checkbox.icon);
    return Unit;
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_1(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(this$CheckboxComponent.icon.value(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_2(this$CheckboxComponent) {
    return function ($receiver) {
      icon($receiver, CheckboxComponent$render$lambda$lambda$lambda$lambda_0, void 0, void 0, void 0, CheckboxComponent$render$lambda$lambda$lambda$lambda_1(this$CheckboxComponent));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_2(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CheckboxComponent.labelStyle.value);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_3(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda_0(closure$id, closure$prefix, this$CheckboxComponent, closure$styling) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      var inputId = closure$id != null ? closure$id + '-input' : null;
      if (inputId != null) {
        $receiver.for_61zpoe$(inputId);
      }tmp$_1 = getCallableRef('input', function ($receiver, p1, p2, p3) {
        return $receiver.input_1ect6g$(p1, p2, p3);
      }.bind(null, $receiver));
      tmp$ = CheckboxComponent$Companion_getInstance().checkboxInputStaticCss;
      tmp$_0 = CheckboxComponent$render$lambda$lambda$lambda(this$CheckboxComponent);
      styled(tmp$_1, tmp$, inputId, closure$prefix, tmp$_0)($receiver, CheckboxComponent$render$lambda$lambda$lambda_0(this$CheckboxComponent));
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, CheckboxComponent$render$lambda$lambda$lambda_1(closure$styling))($receiver, CheckboxComponent$render$lambda$lambda$lambda_2(this$CheckboxComponent));
      if ((tmp$_2 = this$CheckboxComponent.labelField_6jiggi$_0) != null) {
        var this$CheckboxComponent_0 = this$CheckboxComponent;
        styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
          return $receiver.div_hhcm6n$(p1, p2, p3);
        }.bind(null, $receiver)), void 0, void 0, void 0, CheckboxComponent$render$lambda$lambda$lambda$lambda_2(this$CheckboxComponent_0))($receiver, CheckboxComponent$render$lambda$lambda$lambda$lambda_3(tmp$_2));
      }return Unit;
    };
  }
  CheckboxComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    return styled(getCallableRef('label', function ($receiver, p1, p2, p3) {
      return $receiver.label_6gkvle$(p1, p2, p3);
    }.bind(null, context)), baseClass, id, prefix, CheckboxComponent$render$lambda$lambda(this))(context, CheckboxComponent$render$lambda$lambda_0(id, prefix, this, styling));
  };
  Object.defineProperty(CheckboxComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_e77820$_0.events;
    }
  });
  Object.defineProperty(CheckboxComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_e77820$_1.element;
    }
  });
  Object.defineProperty(CheckboxComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_e77820$_2.disabled;
    }
  });
  Object.defineProperty(CheckboxComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_e77820$_2.readonly;
    }
  });
  CheckboxComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_e77820$_2.enabled_6taknv$(value);
  };
  CheckboxComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_e77820$_2.enabled_433wua$(value);
  };
  Object.defineProperty(CheckboxComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_e77820$_3.severity;
    }
  });
  CheckboxComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_e77820$_3.severity_9dec1s$(value);
  };
  CheckboxComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_e77820$_3.severityClassOf_i6436e$(severityStyle);
  };
  function CheckboxComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().checkbox.sizes.normal;
  }
  function CheckboxComponent$icon$lambda($receiver) {
    return Theme.Companion.invoke().icons.check;
  }
  CheckboxComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CheckboxComponent',
    interfaces: [SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function checkbox$lambda($receiver) {
    return Unit;
  }
  function checkbox$lambda_0($receiver) {
    return Unit;
  }
  function checkbox($receiver, styling, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = checkbox$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'checkboxComponent';
    if (build === void 0)
      build = checkbox$lambda_0;
    var $receiver_0 = new CheckboxComponent(store);
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$.prototype.constructor = Coroutine$collect_42ocv1$;
  Coroutine$collect_42ocv1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda;
  Coroutine$unsafeTransform$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda.prototype.constructor = Coroutine$map$lambda;
  Coroutine$map$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function CheckboxGroupComponent(items, store) {
    CheckboxGroupComponent$Companion_getInstance();
    this.items = items;
    this.store = store;
    this.$delegate_rzw1ar$_0 = new InputFormMixin();
    this.$delegate_rzw1ar$_1 = new SeverityMixin();
    this.icon = new ComponentProperty(CheckboxGroupComponent$icon$lambda);
    this.label = new ComponentProperty(CheckboxGroupComponent$label$lambda);
    this.size = new ComponentProperty(CheckboxGroupComponent$size$lambda);
    this.direction = new ComponentProperty(CheckboxGroupComponent$direction$lambda);
    this.itemStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.default);
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.label);
    this.checkedStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.checked);
    this.selectedItems = new DynamicComponentProperty(flowOf(emptyList()));
    this.events = new ComponentProperty(CheckboxGroupComponent$events$lambda);
  }
  function CheckboxGroupComponent$Companion() {
    CheckboxGroupComponent$Companion_instance = this;
  }
  function CheckboxGroupComponent$Companion$CheckboxGroupLayouts() {
    CheckboxGroupComponent$Companion$CheckboxGroupLayouts_instance = this;
    this.column = CheckboxGroupComponent$Companion$CheckboxGroupLayouts$column$lambda;
    this.row = CheckboxGroupComponent$Companion$CheckboxGroupLayouts$row$lambda;
  }
  function CheckboxGroupComponent$Companion$CheckboxGroupLayouts$column$lambda$lambda($receiver) {
    return $receiver.inlineGrid;
  }
  function CheckboxGroupComponent$Companion$CheckboxGroupLayouts$column$lambda($receiver) {
    $receiver.display_1gh9wc$(CheckboxGroupComponent$Companion$CheckboxGroupLayouts$column$lambda$lambda);
    return Unit;
  }
  function CheckboxGroupComponent$Companion$CheckboxGroupLayouts$row$lambda$lambda($receiver) {
    return $receiver.inlineFlex;
  }
  function CheckboxGroupComponent$Companion$CheckboxGroupLayouts$row$lambda($receiver) {
    $receiver.display_1gh9wc$(CheckboxGroupComponent$Companion$CheckboxGroupLayouts$row$lambda$lambda);
    return Unit;
  }
  CheckboxGroupComponent$Companion$CheckboxGroupLayouts.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CheckboxGroupLayouts',
    interfaces: []
  };
  var CheckboxGroupComponent$Companion$CheckboxGroupLayouts_instance = null;
  function CheckboxGroupComponent$Companion$CheckboxGroupLayouts_getInstance() {
    if (CheckboxGroupComponent$Companion$CheckboxGroupLayouts_instance === null) {
      new CheckboxGroupComponent$Companion$CheckboxGroupLayouts();
    }return CheckboxGroupComponent$Companion$CheckboxGroupLayouts_instance;
  }
  CheckboxGroupComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CheckboxGroupComponent$Companion_instance = null;
  function CheckboxGroupComponent$Companion_getInstance() {
    if (CheckboxGroupComponent$Companion_instance === null) {
      new CheckboxGroupComponent$Companion();
    }return CheckboxGroupComponent$Companion_instance;
  }
  function CheckboxGroupComponent$EventsContext(selected) {
    this.selected = selected;
  }
  CheckboxGroupComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: []
  };
  function CheckboxGroupComponent$render$lambda$lambda(this$CheckboxGroupComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CheckboxGroupComponent.direction.value(CheckboxGroupComponent$Companion$CheckboxGroupLayouts_getInstance()));
      return Unit;
    };
  }
  function Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$item = closure$item_0;
    this.local$it = it_0;
  }
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.contains_11rb$(this.local$closure$item);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(closure$item_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$CheckboxGroupComponent) {
    return function ($receiver) {
      return this$CheckboxGroupComponent.size.value(Theme.Companion.invoke().checkbox.sizes);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent) {
    return function ($receiver) {
      return this$CheckboxGroupComponent.icon.value(Theme.Companion.invoke().icons);
    };
  }
  function Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$item = closure$item_0;
  }
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$item;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_1(closure$item, closure$multiSelectionStore) {
    return function ($receiver) {
      var $receiver_0 = states($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item)), $receiver_0)), closure$multiSelectionStore.toggle);
      return Unit;
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent, closure$item, closure$checkedFlow, closure$multiSelectionStore) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$CheckboxGroupComponent));
      $receiver.icon.invoke_11rb$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent));
      $receiver.labelStyle.invoke_11rb$(this$CheckboxGroupComponent.labelStyle.value);
      $receiver.checkedStyle.invoke_11rb$(this$CheckboxGroupComponent.checkedStyle.value);
      $receiver.label_61zpoe$(this$CheckboxGroupComponent.label.value(closure$item));
      $receiver.checked.invoke_ror2s8$(closure$checkedFlow);
      $receiver.disabled.invoke_ror2s8$(this$CheckboxGroupComponent.disabled.values);
      $receiver.severity.invoke_ror2s8$(this$CheckboxGroupComponent.severity.values);
      $receiver.events.invoke_11rb$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_1(closure$item, closure$multiSelectionStore));
      return Unit;
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda_0(this$CheckboxGroupComponent, closure$multiSelectionStore, closure$grpId) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      $receiver.handledBy_ytah3h$((tmp$_0 = (tmp$ = this$CheckboxGroupComponent.store) != null ? tmp$.data : null) != null ? tmp$_0 : this$CheckboxGroupComponent.selectedItems.values, closure$multiSelectionStore.update);
      var $receiver_0 = this$CheckboxGroupComponent.items;
      var tmp$_1;
      tmp$_1 = $receiver_0.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        var closure$multiSelectionStore_0 = closure$multiSelectionStore;
        var this$CheckboxGroupComponent_0 = this$CheckboxGroupComponent;
        var closure$grpId_0 = closure$grpId;
        var $receiver_1 = closure$multiSelectionStore_0.data;
        var checkedFlow = distinctUntilChanged(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(element)), $receiver_1)));
        checkbox($receiver, this$CheckboxGroupComponent_0.itemStyle.value, void 0, void 0, closure$grpId_0 + '-grp-item-' + uniqueId(), void 0, CheckboxGroupComponent$render$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent_0, element, checkedFlow, closure$multiSelectionStore_0));
      }
      var $receiver_2 = new CheckboxGroupComponent$EventsContext(closure$multiSelectionStore.toggle);
      var this$CheckboxGroupComponent_1 = this$CheckboxGroupComponent;
      var tmp$_2;
      this$CheckboxGroupComponent_1.events.value($receiver_2);
      if ((tmp$_2 = this$CheckboxGroupComponent_1.store) != null) {
        $receiver.handledBy_ytah3h$($receiver_2.selected, tmp$_2.update);
      }return Unit;
    };
  }
  CheckboxGroupComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var multiSelectionStore = new MultiSelectionStore();
    var grpId = id != null ? id : uniqueId();
    styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass, id, prefix, CheckboxGroupComponent$render$lambda$lambda(this))(context, CheckboxGroupComponent$render$lambda$lambda_0(this, multiSelectionStore, grpId));
    return Unit;
  };
  Object.defineProperty(CheckboxGroupComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_rzw1ar$_0.disabled;
    }
  });
  Object.defineProperty(CheckboxGroupComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_rzw1ar$_0.readonly;
    }
  });
  CheckboxGroupComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_rzw1ar$_0.enabled_6taknv$(value);
  };
  CheckboxGroupComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_rzw1ar$_0.enabled_433wua$(value);
  };
  Object.defineProperty(CheckboxGroupComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_rzw1ar$_1.severity;
    }
  });
  CheckboxGroupComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_rzw1ar$_1.severity_9dec1s$(value);
  };
  CheckboxGroupComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_rzw1ar$_1.severityClassOf_i6436e$(severityStyle);
  };
  function CheckboxGroupComponent$icon$lambda($receiver) {
    return Theme.Companion.invoke().icons.check;
  }
  function CheckboxGroupComponent$label$lambda(it) {
    return toString(it);
  }
  function CheckboxGroupComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().checkbox.sizes.normal;
  }
  function CheckboxGroupComponent$direction$lambda($receiver) {
    return $receiver.column;
  }
  function CheckboxGroupComponent$events$lambda($receiver) {
    return Unit;
  }
  CheckboxGroupComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CheckboxGroupComponent',
    interfaces: [SeverityProperties, InputFormProperties, Component]
  };
  function checkboxGroup$lambda($receiver) {
    return Unit;
  }
  function checkboxGroup$lambda_0($receiver) {
    return Unit;
  }
  function checkboxGroup($receiver, styling, items, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = checkboxGroup$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'checkboxGroupComponent';
    if (build === void 0)
      build = checkboxGroup$lambda_0;
    var $receiver_0 = new CheckboxGroupComponent(items, store);
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_0(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_0($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_0.prototype.constructor = Coroutine$collect_42ocv1$_0;
  Coroutine$collect_42ocv1$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_0.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_0(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_0.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_0.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_0;
  Coroutine$unsafeTransform$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_0 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_0(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_0(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_0.prototype.constructor = Coroutine$map$lambda_0;
  Coroutine$map$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_0(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_0(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ComponentProperty(value) {
    this.value = value;
  }
  ComponentProperty.prototype.invoke_11rb$ = function (newValue) {
    this.value = newValue;
  };
  ComponentProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentProperty',
    interfaces: []
  };
  function DynamicComponentProperty(values) {
    this.values = values;
  }
  DynamicComponentProperty.prototype.invoke_11rb$ = function (newValue) {
    this.values = flowOf(newValue);
  };
  DynamicComponentProperty.prototype.invoke_ror2s8$ = function (newValues) {
    this.values = newValues;
  };
  DynamicComponentProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DynamicComponentProperty',
    interfaces: []
  };
  function NullableDynamicComponentProperty(values) {
    this.values = values;
  }
  NullableDynamicComponentProperty.prototype.invoke_11rb$ = function (newValue) {
    this.values = flowOf(newValue);
  };
  NullableDynamicComponentProperty.prototype.invoke_ror2s8$ = function (newValues) {
    this.values = newValues;
  };
  NullableDynamicComponentProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NullableDynamicComponentProperty',
    interfaces: []
  };
  function Component() {
  }
  Component.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Component',
    interfaces: []
  };
  function ElementProperties() {
  }
  ElementProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ElementProperties',
    interfaces: []
  };
  function ElementMixin() {
    this.element_z3i8c5$_0 = new ComponentProperty(ElementMixin$element$lambda);
  }
  Object.defineProperty(ElementMixin.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.element_z3i8c5$_0;
    }
  });
  function ElementMixin$element$lambda($receiver) {
    return Unit;
  }
  ElementMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ElementMixin',
    interfaces: [ElementProperties]
  };
  function EventProperties() {
  }
  EventProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EventProperties',
    interfaces: []
  };
  function EventMixin() {
    this.events_6e7oy4$_0 = new ComponentProperty(EventMixin$events$lambda);
  }
  Object.defineProperty(EventMixin.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.events_6e7oy4$_0;
    }
  });
  function EventMixin$events$lambda($receiver) {
    return Unit;
  }
  EventMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventMixin',
    interfaces: [EventProperties]
  };
  function FormProperties() {
  }
  function Coroutine$FormProperties$enabled$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$FormProperties$enabled$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FormProperties$enabled$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FormProperties$enabled$lambda.prototype.constructor = Coroutine$FormProperties$enabled$lambda;
  Coroutine$FormProperties$enabled$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FormProperties$enabled$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$FormProperties$enabled$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  FormProperties.prototype.enabled_433wua$ = function (value) {
    this.disabled.invoke_ror2s8$(new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(FormProperties$enabled$lambda), value)));
  };
  FormProperties.prototype.enabled_6taknv$ = function (value) {
    this.enabled_433wua$(flowOf(value));
  };
  FormProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'FormProperties',
    interfaces: []
  };
  function FormMixin() {
    this.disabled_47g0mz$_0 = new DynamicComponentProperty(flowOf(false));
  }
  Object.defineProperty(FormMixin.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.disabled_47g0mz$_0;
    }
  });
  FormMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormMixin',
    interfaces: [FormProperties]
  };
  function InputFormProperties() {
  }
  InputFormProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InputFormProperties',
    interfaces: [FormProperties]
  };
  function InputFormMixin() {
    FormMixin.call(this);
    this.readonly_6oqran$_0 = new DynamicComponentProperty(flowOf(false));
  }
  Object.defineProperty(InputFormMixin.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.readonly_6oqran$_0;
    }
  });
  InputFormMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InputFormMixin',
    interfaces: [FormMixin, InputFormProperties]
  };
  function SeverityProperties() {
  }
  function SeverityProperties$SeverityContext() {
    this.info = Severity$Info_getInstance();
    this.success = Severity$Success_getInstance();
    this.warning = Severity$Warning_getInstance();
    this.error = Severity$Error_getInstance();
  }
  SeverityProperties$SeverityContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SeverityContext',
    interfaces: []
  };
  SeverityProperties.prototype.severity_9dec1s$ = function (value) {
    this.severity.invoke_11rb$(value(new SeverityProperties$SeverityContext()));
  };
  function Coroutine$SeverityProperties$severityClassOf$lambda(closure$severityStyle_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$severityStyle = closure$severityStyle_0;
    this.local$it = it_0;
  }
  Coroutine$SeverityProperties$severityClassOf$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SeverityProperties$severityClassOf$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SeverityProperties$severityClassOf$lambda.prototype.constructor = Coroutine$SeverityProperties$severityClassOf$lambda;
  Coroutine$SeverityProperties$severityClassOf$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (equals(this.local$it, Severity$Info_getInstance()))
              return style('severity-info', this.local$closure$severityStyle.info);
            else if (equals(this.local$it, Severity$Success_getInstance()))
              return style('severity-success', this.local$closure$severityStyle.success);
            else if (equals(this.local$it, Severity$Warning_getInstance()))
              return style('severity-warning', this.local$closure$severityStyle.warning);
            else if (equals(this.local$it, Severity$Error_getInstance()))
              return style('severity-error', this.local$closure$severityStyle.error);
            else
              return StyleClass.Companion.None;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SeverityProperties$severityClassOf$lambda(closure$severityStyle_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SeverityProperties$severityClassOf$lambda(closure$severityStyle_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  SeverityProperties.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    var $receiver = this.severity.values;
    return new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(SeverityProperties$severityClassOf$lambda(severityStyle)), $receiver));
  };
  SeverityProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SeverityProperties',
    interfaces: []
  };
  function SeverityMixin() {
    this.severity_ri2anz$_0 = new NullableDynamicComponentProperty(emptyFlow());
  }
  Object.defineProperty(SeverityMixin.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.severity_ri2anz$_0;
    }
  });
  SeverityMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SeverityMixin',
    interfaces: [SeverityProperties]
  };
  function MultiSelectionStore() {
    RootStore.call(this, emptyList());
    this.toggle = this.handleAndEmit_6gppb5$(void 0, MultiSelectionStore$toggle$lambda);
  }
  function Coroutine$MultiSelectionStore$toggle$lambda($receiver_0, selectedRows_0, new_1, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$newSelection = void 0;
    this.local$$receiver = $receiver_0;
    this.local$selectedRows = selectedRows_0;
    this.local$new = new_1;
  }
  Coroutine$MultiSelectionStore$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiSelectionStore$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiSelectionStore$toggle$lambda.prototype.constructor = Coroutine$MultiSelectionStore$toggle$lambda;
  Coroutine$MultiSelectionStore$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$newSelection = this.local$selectedRows.contains_11rb$(this.local$new) ? minus(this.local$selectedRows, this.local$new) : plus(this.local$selectedRows, this.local$new);
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(this.local$newSelection, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$newSelection;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiSelectionStore$toggle$lambda($receiver_0, selectedRows_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$MultiSelectionStore$toggle$lambda($receiver_0, selectedRows_0, new_1, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  MultiSelectionStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultiSelectionStore',
    interfaces: [RootStore]
  };
  function SingleSelectionStore() {
    RootStore.call(this, null);
    this.toggle = this.handleAndEmit_6gppb5$(void 0, SingleSelectionStore$toggle$lambda);
  }
  function Coroutine$SingleSelectionStore$toggle$lambda($receiver_0, f_0, new_1, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$new = new_1;
  }
  Coroutine$SingleSelectionStore$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SingleSelectionStore$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SingleSelectionStore$toggle$lambda.prototype.constructor = Coroutine$SingleSelectionStore$toggle$lambda;
  Coroutine$SingleSelectionStore$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(this.local$new, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$new;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SingleSelectionStore$toggle$lambda($receiver_0, f_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$SingleSelectionStore$toggle$lambda($receiver_0, f_0, new_1, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  SingleSelectionStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleSelectionStore',
    interfaces: [RootStore]
  };
  function CloseButtonProperty() {
  }
  CloseButtonProperty.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CloseButtonProperty',
    interfaces: []
  };
  function CloseButtonMixin(closeButtonPrefix, defaultStyle) {
    if (closeButtonPrefix === void 0)
      closeButtonPrefix = 'close-button';
    this.closeButtonPrefix_nxijlv$_0 = closeButtonPrefix;
    this.defaultStyle_0 = defaultStyle;
    this.closeButtonStyle_kohor6$_0 = new ComponentProperty(CloseButtonMixin$closeButtonStyle$lambda);
    this.closeButtonIcon_um5q4k$_0 = new ComponentProperty(CloseButtonMixin$closeButtonIcon$lambda);
    this.hasCloseButton_3wyvlx$_0 = new ComponentProperty(true);
    this.closeButtonRendering_wfhisz$_0 = new ComponentProperty(CloseButtonMixin$closeButtonRendering$lambda(this));
  }
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonPrefix', {
    get: function () {
      return this.closeButtonPrefix_nxijlv$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.closeButtonStyle_kohor6$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.closeButtonIcon_um5q4k$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.hasCloseButton_3wyvlx$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.closeButtonRendering_wfhisz$_0;
    }
  });
  function CloseButtonMixin$closeButtonStyle$lambda($receiver) {
    return Unit;
  }
  function CloseButtonMixin$closeButtonIcon$lambda($receiver) {
    return Theme.Companion.invoke().icons.close;
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda(this$CloseButtonMixin) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CloseButtonMixin.defaultStyle_0);
      $receiver.invoke_qkhqzy$(this$CloseButtonMixin.closeButtonStyle.value);
      return Unit;
    };
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda($receiver) {
    return $receiver.ghost;
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda_0(this$CloseButtonMixin) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(this$CloseButtonMixin.closeButtonIcon.value(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda_0(this$CloseButtonMixin) {
    return function ($receiver) {
      $receiver.variant.invoke_11rb$(CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda);
      $receiver.icon_8nbis2$(void 0, void 0, void 0, void 0, CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda_0(this$CloseButtonMixin));
      return Unit;
    };
  }
  function CloseButtonMixin$closeButtonRendering$lambda(this$CloseButtonMixin) {
    return function ($receiver) {
      return clickButton($receiver, CloseButtonMixin$closeButtonRendering$lambda$lambda(this$CloseButtonMixin), void 0, 'close-button-' + uniqueId(), this$CloseButtonMixin.closeButtonPrefix, CloseButtonMixin$closeButtonRendering$lambda$lambda_0(this$CloseButtonMixin));
    };
  }
  CloseButtonMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CloseButtonMixin',
    interfaces: [CloseButtonProperty]
  };
  function unsafeFlow$ObjectLiteral_1(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_1($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_1.prototype.constructor = Coroutine$collect_42ocv1$_1;
  Coroutine$collect_42ocv1$_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_1.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_1(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_1.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_1.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_1;
  Coroutine$unsafeTransform$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_1 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_1(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$mapNotNull$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$tmp$ = void 0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$mapNotNull$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$mapNotNull$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$mapNotNull$lambda.prototype.constructor = Coroutine$mapNotNull$lambda;
  Coroutine$mapNotNull$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            if (this.local$tmp$ == null) {
              return;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            var transformed = this.local$tmp$;
            this.state_0 = 4;
            this.result_0 = this.local$$receiver.emit_11rb$(transformed, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function mapNotNull$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$mapNotNull$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var flatMapLatest$lambda = wrapFunction(function () {
    function Coroutine$flatMapLatest$lambda(closure$transform_0, $receiver_0, it_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$$receiver = $receiver_0;
      this.local$it = it_0;
    }
    Coroutine$flatMapLatest$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$flatMapLatest$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$flatMapLatest$lambda.prototype.constructor = Coroutine$flatMapLatest$lambda;
    Coroutine$flatMapLatest$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$closure$transform(this.local$it, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              this.state_0 = 3;
              this.result_0 = this.result_0.collect_42ocv1$(this.local$$receiver, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 3:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0) {
      return function ($receiver_0, it_0, continuation_0, suspended) {
        var instance = new Coroutine$flatMapLatest$lambda(closure$transform_0, $receiver_0, it_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function unsafeFlow$ObjectLiteral_2(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_2($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_2.prototype.constructor = Coroutine$collect_42ocv1$_2;
  Coroutine$collect_42ocv1$_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_2.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_2(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_2.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function combine$lambda$lambda(closure$flowArray) {
    return function () {
      return Kotlin.newArray(closure$flowArray.length, null);
    };
  }
  function Coroutine$combine$lambda$lambda(closure$transform_0, $receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$it = it_0;
  }
  Coroutine$combine$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$combine$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$combine$lambda$lambda.prototype.constructor = Coroutine$combine$lambda$lambda;
  Coroutine$combine$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$it, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function combine$lambda$lambda_0(closure$transform_0) {
    return function ($receiver_0, it_0, continuation_0, suspended) {
      var instance = new Coroutine$combine$lambda$lambda(closure$transform_0, $receiver_0, it_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$combine$lambda(closure$flowArray_0, closure$transform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$flowArray = closure$flowArray_0;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$combine$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$combine$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$combine$lambda.prototype.constructor = Coroutine$combine$lambda;
  Coroutine$combine$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = combineInternal(this.local$$receiver, this.local$closure$flowArray, combine$lambda$lambda(this.local$closure$flowArray), combine$lambda$lambda_0(this.local$closure$transform), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function combine$lambda(closure$flowArray_0, closure$transform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$combine$lambda(closure$flowArray_0, closure$transform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FileSelectionBaseComponent() {
    FileSelectionBaseComponent$Companion_getInstance();
    this.accept = null;
    this.base64 = FileSelectionBaseComponent$base64$lambda;
    this.plainText = FileSelectionBaseComponent$plainText$lambda;
    this.fileReadingStrategy = new ComponentProperty(FileSelectionBaseComponent$fileReadingStrategy$lambda);
    this.context = FileSelectionBaseComponent$context$lambda;
  }
  function FileSelectionBaseComponent$Companion() {
    FileSelectionBaseComponent$Companion_instance = this;
    this.eventName = 'loadend';
    this.inputStyle = staticStyle_0('file-input', 'display: none;');
  }
  FileSelectionBaseComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FileSelectionBaseComponent$Companion_instance = null;
  function FileSelectionBaseComponent$Companion_getInstance() {
    if (FileSelectionBaseComponent$Companion_instance === null) {
      new FileSelectionBaseComponent$Companion();
    }return FileSelectionBaseComponent$Companion_instance;
  }
  function FileSelectionBaseComponent$accept$lambda(closure$value) {
    return function ($receiver) {
      $receiver.attr_puj7f4$('accept', closure$value);
      return Unit;
    };
  }
  FileSelectionBaseComponent.prototype.accept_61zpoe$ = function (value) {
    this.accept = FileSelectionBaseComponent$accept$lambda(value);
  };
  function FileSelectionBaseComponent$accept$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.attr_i7f8q9$('accept', closure$value);
      return Unit;
    };
  }
  FileSelectionBaseComponent.prototype.accept_p81yox$ = function (value) {
    this.accept = FileSelectionBaseComponent$accept$lambda_0(value);
  };
  function FileSelectionBaseComponent$encoding$lambda(closure$value) {
    return function ($receiver) {
      return $receiver.plainText(closure$value);
    };
  }
  FileSelectionBaseComponent.prototype.encoding_61zpoe$ = function (value) {
    this.fileReadingStrategy.invoke_11rb$(FileSelectionBaseComponent$encoding$lambda(value));
  };
  function FileSelectionBaseComponent$button$lambda$lambda$lambda$lambda(closure$input) {
    return function (it) {
      closure$input.click();
      return Unit;
    };
  }
  function FileSelectionBaseComponent$button$lambda$lambda$lambda(closure$input) {
    return function ($receiver) {
      $receiver.domNode.onclick = FileSelectionBaseComponent$button$lambda$lambda$lambda$lambda(closure$input);
      return Unit;
    };
  }
  function FileSelectionBaseComponent$button$lambda$lambda(closure$build, closure$input) {
    return function ($receiver) {
      closure$build($receiver);
      $receiver.element.invoke_11rb$(FileSelectionBaseComponent$button$lambda$lambda$lambda(closure$input));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$button$lambda(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build) {
    return function ($receiver, input) {
      pushButton($receiver, closure$styling, closure$baseClass, closure$id, closure$prefix, FileSelectionBaseComponent$button$lambda$lambda(closure$build, input));
      return Unit;
    };
  }
  FileSelectionBaseComponent.prototype.button_ceberj$$default = function (styling, baseClass, id, prefix, build) {
    this.context = FileSelectionBaseComponent$button$lambda(styling, baseClass, id, prefix, build);
  };
  function FileSelectionBaseComponent$button$lambda_0($receiver) {
    return Unit;
  }
  function FileSelectionBaseComponent$button$lambda_1($receiver) {
    return Unit;
  }
  FileSelectionBaseComponent.prototype.button_ceberj$ = function (styling, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FileSelectionBaseComponent$button$lambda_0;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'file-button';
    if (build === void 0)
      build = FileSelectionBaseComponent$button$lambda_1;
    callback$default ? callback$default(styling, baseClass, id, prefix, build) : this.button_ceberj$$default(styling, baseClass, id, prefix, build);
  };
  function FileSelectionBaseComponent$base64$lambda$lambda$lambda(closure$reader, closure$file, this$) {
    return function (f) {
      var content = closure$reader.result.toString();
      var index = indexOf(content, 'base64,');
      if (index > -1) {
        var $receiver = content;
        var startIndex = index + 7 | 0;
        content = $receiver.substring(startIndex);
      }this$.offer_11rb$(new File(closure$file.name, closure$file.type, numberToLong(closure$file.size), content));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$base64$lambda$lambda$lambda_0(closure$reader, closure$listener) {
    return function () {
      closure$reader.removeEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, closure$listener);
      return Unit;
    };
  }
  function Coroutine$FileSelectionBaseComponent$base64$lambda$lambda(closure$file_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$file = closure$file_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.prototype.constructor = Coroutine$FileSelectionBaseComponent$base64$lambda$lambda;
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var reader = new FileReader();
            var listener = FileSelectionBaseComponent$base64$lambda$lambda$lambda(reader, this.local$closure$file, this.local$$receiver);
            reader.addEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, listener);
            reader.readAsDataURL(this.local$closure$file);
            this.state_0 = 2;
            this.result_0 = awaitClose(this.local$$receiver, FileSelectionBaseComponent$base64$lambda$lambda$lambda_0(reader, listener), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FileSelectionBaseComponent$base64$lambda$lambda(closure$file_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$FileSelectionBaseComponent$base64$lambda$lambda(closure$file_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FileSelectionBaseComponent$base64$lambda(file) {
    return callbackFlow(FileSelectionBaseComponent$base64$lambda$lambda(file));
  }
  function FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda(closure$file, closure$reader, this$) {
    return function (f) {
      this$.offer_11rb$(new File(closure$file.name, closure$file.type, numberToLong(closure$file.size), closure$reader.result.toString()));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda_0(closure$reader, closure$listener) {
    return function () {
      closure$reader.removeEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, closure$listener);
      return Unit;
    };
  }
  function Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda(closure$file_0, closure$encoding_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$file = closure$file_0;
    this.local$closure$encoding = closure$encoding_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.prototype.constructor = Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda;
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var reader = new FileReader();
            var listener = FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda(this.local$closure$file, reader, this.local$$receiver);
            reader.addEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, listener);
            reader.readAsText(this.local$closure$file, this.local$closure$encoding);
            this.state_0 = 2;
            this.result_0 = awaitClose(this.local$$receiver, FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda_0(reader, listener), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FileSelectionBaseComponent$plainText$lambda$lambda$lambda(closure$file_0, closure$encoding_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda(closure$file_0, closure$encoding_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FileSelectionBaseComponent$plainText$lambda$lambda(closure$encoding) {
    return function (file) {
      return callbackFlow(FileSelectionBaseComponent$plainText$lambda$lambda$lambda(file, closure$encoding));
    };
  }
  function FileSelectionBaseComponent$plainText$lambda(encoding) {
    return FileSelectionBaseComponent$plainText$lambda$lambda(encoding);
  }
  function FileSelectionBaseComponent$fileReadingStrategy$lambda($receiver) {
    return $receiver.base64;
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.cloudUpload;
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda($receiver) {
    $receiver.fromTheme_q0wvou$(FileSelectionBaseComponent$context$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda$lambda_0(closure$input) {
    return function (it) {
      closure$input.click();
      return Unit;
    };
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda_0(closure$input) {
    return function ($receiver) {
      $receiver.domNode.onclick = FileSelectionBaseComponent$context$lambda$lambda$lambda$lambda_0(closure$input);
      return Unit;
    };
  }
  function FileSelectionBaseComponent$context$lambda$lambda(closure$input) {
    return function ($receiver) {
      $receiver.icon_8nbis2$(void 0, void 0, void 0, void 0, FileSelectionBaseComponent$context$lambda$lambda$lambda);
      $receiver.element.invoke_11rb$(FileSelectionBaseComponent$context$lambda$lambda$lambda_0(closure$input));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$context$lambda($receiver, input) {
    pushButton($receiver, void 0, void 0, void 0, 'file-button', FileSelectionBaseComponent$context$lambda$lambda(input));
    return Unit;
  }
  FileSelectionBaseComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSelectionBaseComponent',
    interfaces: []
  };
  function SingleFileSelectionComponent() {
    FileSelectionBaseComponent.call(this);
  }
  function SingleFileSelectionComponent$render$lambda$lambda($receiver) {
    return Unit;
  }
  function Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
  }
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return (tmp$ = this.local$this$.domNode.files) != null ? tmp$.item(0) : null;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, this$SingleFileSelectionComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$this$SingleFileSelectionComponent = this$SingleFileSelectionComponent_0;
    this.local$it = it_0;
  }
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0;
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$this$.domNode.value = '';
            return this.local$this$SingleFileSelectionComponent.fileReadingStrategy.value(this.local$this$SingleFileSelectionComponent)(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, this$SingleFileSelectionComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, this$SingleFileSelectionComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SingleFileSelectionComponent$render$lambda$lambda$lambda(this$SingleFileSelectionComponent, closure$file) {
    return function ($receiver) {
      var tmp$;
      $receiver.type_61zpoe$('file');
      (tmp$ = this$SingleFileSelectionComponent.accept) != null ? tmp$($receiver) : null;
      var tmp$_0 = closure$file;
      var $receiver_0 = $receiver.changes.events;
      tmp$_0.v = transformLatest(new unsafeFlow$ObjectLiteral_1(unsafeTransform$lambda_1(mapNotNull$lambda(SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda($receiver)), $receiver_0)), flatMapLatest$lambda(SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0($receiver, this$SingleFileSelectionComponent)));
      return Unit;
    };
  }
  function SingleFileSelectionComponent$render$lambda$lambda_0(this$SingleFileSelectionComponent, closure$file) {
    return function ($receiver) {
      var inputElement = $receiver.input_1ect6g$(FileSelectionBaseComponent$Companion_getInstance().inputStyle.name, void 0, SingleFileSelectionComponent$render$lambda$lambda$lambda(this$SingleFileSelectionComponent, closure$file)).domNode;
      this$SingleFileSelectionComponent.context($receiver, inputElement);
      return Unit;
    };
  }
  SingleFileSelectionComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var file = {v: null};
    styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass, id, prefix, SingleFileSelectionComponent$render$lambda$lambda)(context, SingleFileSelectionComponent$render$lambda$lambda_0(this, file));
    return ensureNotNull(file.v);
  };
  SingleFileSelectionComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleFileSelectionComponent',
    interfaces: [Component, FileSelectionBaseComponent]
  };
  function MultiFileSelectionComponent() {
    FileSelectionBaseComponent.call(this);
  }
  function MultiFileSelectionComponent$render$lambda$lambda($receiver) {
    return Unit;
  }
  function Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, this$MultiFileSelectionComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$this$MultiFileSelectionComponent = this$MultiFileSelectionComponent_0;
  }
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var list = this.local$this$.domNode.files;
            if (list != null) {
              var $receiver = ArrayList_init();
              var this$MultiFileSelectionComponent = this.local$this$MultiFileSelectionComponent;
              var tmp$;
              tmp$ = list.length;
              for (var i = 0; i <= tmp$; i++) {
                var file = list.item(i);
                if (file != null)
                  $receiver.add_11rb$(this$MultiFileSelectionComponent.fileReadingStrategy.value(this$MultiFileSelectionComponent)(file));
              }
              return $receiver.build();
            } else
              return null;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, this$MultiFileSelectionComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, this$MultiFileSelectionComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda;
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return toList(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, files_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$files = files_0;
  }
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0;
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$this$.domNode.value = '';
            var flowArray = copyToArray(toList_0(this.local$files));
            return new unsafeFlow$ObjectLiteral_2(combine$lambda(flowArray, MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda));
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0) {
    return function (files_0, continuation_0, suspended) {
      var instance = new Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, files_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function MultiFileSelectionComponent$render$lambda$lambda$lambda(this$MultiFileSelectionComponent, closure$files) {
    return function ($receiver) {
      var tmp$;
      $receiver.type_61zpoe$('file');
      $receiver.multiple_8kj6y5$(true);
      (tmp$ = this$MultiFileSelectionComponent.accept) != null ? tmp$($receiver) : null;
      var tmp$_0 = closure$files;
      var $receiver_0 = $receiver.changes.events;
      tmp$_0.v = transformLatest(new unsafeFlow$ObjectLiteral_1(unsafeTransform$lambda_1(mapNotNull$lambda(MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda($receiver, this$MultiFileSelectionComponent)), $receiver_0)), flatMapLatest$lambda(MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0($receiver)));
      return Unit;
    };
  }
  function MultiFileSelectionComponent$render$lambda$lambda_0(this$MultiFileSelectionComponent, closure$files) {
    return function ($receiver) {
      var inputElement = $receiver.input_1ect6g$(FileSelectionBaseComponent$Companion_getInstance().inputStyle.name, void 0, MultiFileSelectionComponent$render$lambda$lambda$lambda(this$MultiFileSelectionComponent, closure$files)).domNode;
      this$MultiFileSelectionComponent.context($receiver, inputElement);
      return Unit;
    };
  }
  MultiFileSelectionComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var files = {v: null};
    styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass, id, prefix, MultiFileSelectionComponent$render$lambda$lambda)(context, MultiFileSelectionComponent$render$lambda$lambda_0(this, files));
    return ensureNotNull(files.v);
  };
  MultiFileSelectionComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultiFileSelectionComponent',
    interfaces: [Component, FileSelectionBaseComponent]
  };
  function file$lambda($receiver) {
    return Unit;
  }
  function file$lambda_0($receiver) {
    return Unit;
  }
  function file($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = file$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'file';
    if (build === void 0)
      build = file$lambda_0;
    var $receiver_0 = new SingleFileSelectionComponent();
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function files$lambda($receiver) {
    return Unit;
  }
  function files$lambda_0($receiver) {
    return Unit;
  }
  function files($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = files$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'file';
    if (build === void 0)
      build = files$lambda_0;
    var $receiver_0 = new MultiFileSelectionComponent();
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_3(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_3($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_3.prototype.constructor = Coroutine$collect_42ocv1$_3;
  Coroutine$collect_42ocv1$_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_3.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_3(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_3.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_2.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_2;
  Coroutine$unsafeTransform$lambda$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_2 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_2(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_1(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_1.prototype.constructor = Coroutine$map$lambda_1;
  Coroutine$map$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_1(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_1(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FormControlComponent() {
    FormControlComponent$Companion_getInstance();
    this.$delegate_43alo6$_0 = new FormMixin();
    this.renderStrategies_cd5j51$_0 = LinkedHashMap_init();
    this.control_awpzuz$_0 = new FormControlComponent$Control();
    this.size = new ComponentProperty(FormControlComponent$size$lambda);
    this.sizeBuilder = FormControlComponent$sizeBuilder$lambda(this);
    this.label = new ComponentProperty('');
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().formControl.label);
    this.helperText = new ComponentProperty(null);
    this.helperTextStyle = new ComponentProperty(Theme.Companion.invoke().formControl.helperText);
    this.validationMessagesBuilder = null;
    this.validationMessage = new ComponentProperty(FormControlComponent$validationMessage$lambda);
    this.validationMessages = new ComponentProperty(FormControlComponent$validationMessages$lambda);
    this.validationMessageRendering = new ComponentProperty(FormControlComponent$validationMessageRendering$lambda(this));
    var singleRenderer = new SingleControlRenderer(this);
    var groupRenderer = new ControlGroupRenderer(this);
    var tmp$;
    tmp$ = sequenceOf([FormControlComponent$Companion$ControlNames_getInstance().inputField, FormControlComponent$Companion$ControlNames_getInstance().switch, FormControlComponent$Companion$ControlNames_getInstance().textArea, FormControlComponent$Companion$ControlNames_getInstance().selectField, FormControlComponent$Companion$ControlNames_getInstance().checkbox]).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.registerRenderStrategy_frecgw$(element, singleRenderer);
    }
    this.registerRenderStrategy_frecgw$(FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup, groupRenderer);
    this.registerRenderStrategy_frecgw$(FormControlComponent$Companion$ControlNames_getInstance().radioGroup, groupRenderer);
  }
  function FormControlComponent$Companion() {
    FormControlComponent$Companion_instance = this;
  }
  function FormControlComponent$Companion$ControlNames() {
    FormControlComponent$Companion$ControlNames_instance = this;
    this.inputField = 'inputField';
    this.textArea = 'textArea';
    this.switch = 'switch';
    this.selectField = 'selectField';
    this.radioGroup = 'radioGroup';
    this.checkbox = 'checkbox';
    this.checkboxGroup = 'checkboxGroup';
  }
  FormControlComponent$Companion$ControlNames.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ControlNames',
    interfaces: []
  };
  var FormControlComponent$Companion$ControlNames_instance = null;
  function FormControlComponent$Companion$ControlNames_getInstance() {
    if (FormControlComponent$Companion$ControlNames_instance === null) {
      new FormControlComponent$Companion$ControlNames();
    }return FormControlComponent$Companion$ControlNames_instance;
  }
  FormControlComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FormControlComponent$Companion_instance = null;
  function FormControlComponent$Companion_getInstance() {
    if (FormControlComponent$Companion_instance === null) {
      new FormControlComponent$Companion();
    }return FormControlComponent$Companion_instance;
  }
  function FormControlComponent$Control() {
    this.overflows_0 = ArrayList_init();
    this.assignee = null;
  }
  FormControlComponent$Control.prototype.set_rwdb8o$ = function (controlName, component) {
    if (this.assignee == null) {
      this.assignee = new Pair(controlName, component);
      return true;
    } else {
      this.overflows_0.add_11rb$(controlName);
    }
    return false;
  };
  FormControlComponent$Control.prototype.assert = function () {
    var tmp$, tmp$_0;
    if (!this.overflows_0.isEmpty()) {
      tmp$_0 = UnsupportedOperationException_init('Only one control within a formControl is allowed! Accepted control: ' + toString((tmp$ = this.assignee) != null ? tmp$.first : null) + ' The following controls are not applied and overflow this form: ' + joinToString(this.overflows_0, ', ') + ' Please remove those!');
      console.error(tmp$_0);
    }};
  FormControlComponent$Control.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Control',
    interfaces: []
  };
  function FormControlComponent$registerControl$lambda($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.registerControl_b17nx$ = function (controlName, component, onSuccess) {
    if (onSuccess === void 0)
      onSuccess = FormControlComponent$registerControl$lambda;
    if (this.control_awpzuz$_0.set_rwdb8o$(controlName, component)) {
      onSuccess(this);
    }};
  FormControlComponent.prototype.registerRenderStrategy_frecgw$ = function (controlName, renderer) {
    this.renderStrategies_cd5j51$_0.put_xwzc9p$(controlName, renderer);
  };
  function FormControlComponent$FormSizeContext() {
    FormControlComponent$FormSizeContext_instance = this;
    this.small = FormControlComponent$FormSizeContext$FormSizeSpecifier$small_getInstance();
    this.normal = FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_getInstance();
    this.large = FormControlComponent$FormSizeContext$FormSizeSpecifier$large_getInstance();
  }
  function FormControlComponent$FormSizeContext$FormSizeSpecifier(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields = function () {
    };
    FormControlComponent$FormSizeContext$FormSizeSpecifier$small_instance = new FormControlComponent$FormSizeContext$FormSizeSpecifier('small', 0);
    FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_instance = new FormControlComponent$FormSizeContext$FormSizeSpecifier('normal', 1);
    FormControlComponent$FormSizeContext$FormSizeSpecifier$large_instance = new FormControlComponent$FormSizeContext$FormSizeSpecifier('large', 2);
  }
  var FormControlComponent$FormSizeContext$FormSizeSpecifier$small_instance;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$small_getInstance() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields();
    return FormControlComponent$FormSizeContext$FormSizeSpecifier$small_instance;
  }
  var FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_instance;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_getInstance() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields();
    return FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_instance;
  }
  var FormControlComponent$FormSizeContext$FormSizeSpecifier$large_instance;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$large_getInstance() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields();
    return FormControlComponent$FormSizeContext$FormSizeSpecifier$large_instance;
  }
  FormControlComponent$FormSizeContext$FormSizeSpecifier.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormSizeSpecifier',
    interfaces: [Enum]
  };
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$values() {
    return [FormControlComponent$FormSizeContext$FormSizeSpecifier$small_getInstance(), FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_getInstance(), FormControlComponent$FormSizeContext$FormSizeSpecifier$large_getInstance()];
  }
  FormControlComponent$FormSizeContext$FormSizeSpecifier.values = FormControlComponent$FormSizeContext$FormSizeSpecifier$values;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$valueOf(name) {
    switch (name) {
      case 'small':
        return FormControlComponent$FormSizeContext$FormSizeSpecifier$small_getInstance();
      case 'normal':
        return FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_getInstance();
      case 'large':
        return FormControlComponent$FormSizeContext$FormSizeSpecifier$large_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.FormControlComponent.FormSizeContext.FormSizeSpecifier.' + name);
    }
  }
  FormControlComponent$FormSizeContext$FormSizeSpecifier.valueOf_61zpoe$ = FormControlComponent$FormSizeContext$FormSizeSpecifier$valueOf;
  FormControlComponent$FormSizeContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'FormSizeContext',
    interfaces: []
  };
  var FormControlComponent$FormSizeContext_instance = null;
  function FormControlComponent$FormSizeContext_getInstance() {
    if (FormControlComponent$FormSizeContext_instance === null) {
      new FormControlComponent$FormSizeContext();
    }return FormControlComponent$FormSizeContext_instance;
  }
  FormControlComponent.prototype.ownSize = function () {
    switch (this.size.value(FormControlComponent$FormSizeContext_getInstance()).name) {
      case 'small':
        return Theme.Companion.invoke().formControl.sizes.small;
      case 'normal':
        return Theme.Companion.invoke().formControl.sizes.normal;
      case 'large':
        return Theme.Companion.invoke().formControl.sizes.large;
      default:return Kotlin.noWhenBranchMatched();
    }
  };
  function FormControlComponent$ValidationResult(messages) {
    FormControlComponent$ValidationResult$Companion_getInstance();
    this.messages = messages;
  }
  function FormControlComponent$ValidationResult$Companion() {
    FormControlComponent$ValidationResult$Companion_instance = this;
  }
  function Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.prototype.constructor = Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda;
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it == null ? emptyList() : listOf(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function FormControlComponent$ValidationResult$Companion$builderOf$lambda(closure$formControl, closure$store) {
    return function () {
      var tmp$, tmp$_0, tmp$_1;
      return new FormControlComponent$ValidationResult((tmp$_1 = (tmp$_0 = (tmp$ = closure$formControl.validationMessage.value()) != null ? new unsafeFlow$ObjectLiteral_3(unsafeTransform$lambda_2(map$lambda_1(FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda), tmp$)) : null) != null ? tmp$_0 : closure$formControl.validationMessages.value()) != null ? tmp$_1 : closure$store != null ? validationMessages(closure$store) : null);
    };
  }
  FormControlComponent$ValidationResult$Companion.prototype.builderOf_4w43vn$ = function (formControl, store) {
    if (store === void 0)
      store = null;
    return FormControlComponent$ValidationResult$Companion$builderOf$lambda(formControl, store);
  };
  FormControlComponent$ValidationResult$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FormControlComponent$ValidationResult$Companion_instance = null;
  function FormControlComponent$ValidationResult$Companion_getInstance() {
    if (FormControlComponent$ValidationResult$Companion_instance === null) {
      new FormControlComponent$ValidationResult$Companion();
    }return FormControlComponent$ValidationResult$Companion_instance;
  }
  function Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda(messages_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$messages = messages_0;
  }
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.prototype.constructor = Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda;
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var destination = ArrayList_init_0(collectionSizeOrDefault(this.local$messages, 10));
            var tmp$;
            tmp$ = this.local$messages.iterator();
            while (tmp$.hasNext()) {
              var item = tmp$.next();
              destination.add_11rb$(item.severity);
            }

            return maxOrNull(destination);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda(messages_0, continuation_0, suspended) {
    var instance = new Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda(messages_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  Object.defineProperty(FormControlComponent$ValidationResult.prototype, 'hasSeverity', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this.messages) != null ? new unsafeFlow$ObjectLiteral_3(unsafeTransform$lambda_2(map$lambda_1(FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda), tmp$)) : null) != null ? tmp$_0 : flowOf(null);
    }
  });
  FormControlComponent$ValidationResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ValidationResult',
    interfaces: []
  };
  function FormControlComponent$inputField$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$inputField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$inputField$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$inputField$lambda(closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      inputField($receiver, closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$inputField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$inputField$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.inputField_86weak$$default = function (styling, store, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().inputField, FormControlComponent$inputField$lambda(styling, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$inputField$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$inputField$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$inputField$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.inputField_86weak$ = function (styling, store, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$inputField$lambda_1;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().inputField;
    if (build === void 0)
      build = FormControlComponent$inputField$lambda_2;
    callback$default ? callback$default(styling, store, baseClass, id, prefix, build) : this.inputField_86weak$$default(styling, store, baseClass, id, prefix, build);
  };
  function FormControlComponent$switch$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$switch$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$switch$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$switch$lambda(closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      switch_0($receiver, closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$switch$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$switch$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.switch_j0vqu5$$default = function (styling, store, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().inputField, FormControlComponent$switch$lambda(styling, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$switch$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$switch$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$switch$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.switch_j0vqu5$ = function (styling, store, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$switch$lambda_1;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().switch;
    if (build === void 0)
      build = FormControlComponent$switch$lambda_2;
    callback$default ? callback$default(styling, store, baseClass, id, prefix, build) : this.switch_j0vqu5$$default(styling, store, baseClass, id, prefix, build);
  };
  function FormControlComponent$textArea$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$textArea$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$textArea$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$textArea$lambda(closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      textArea($receiver, closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$textArea$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$textArea$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.textArea_g8etaq$$default = function (styling, store, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().textArea, FormControlComponent$textArea$lambda(styling, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$textArea$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$textArea$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$textArea$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.textArea_g8etaq$ = function (styling, store, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$textArea$lambda_1;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().textArea;
    if (build === void 0)
      build = FormControlComponent$textArea$lambda_2;
    callback$default ? callback$default(styling, store, baseClass, id, prefix, build) : this.textArea_g8etaq$$default(styling, store, baseClass, id, prefix, build);
  };
  function FormControlComponent$checkbox$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(closure$styling);
      return Unit;
    };
  }
  function FormControlComponent$checkbox$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$checkbox$lambda$lambda_0(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$checkbox$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$checkbox$lambda(closure$styling, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      checkbox($receiver, FormControlComponent$checkbox$lambda$lambda(closure$styling), closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$checkbox$lambda$lambda_0(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$checkbox$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.checkbox_btfocy$$default = function (styling, baseClass, store, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().checkbox, FormControlComponent$checkbox$lambda(styling, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$checkbox$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$checkbox$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$checkbox$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.checkbox_btfocy$ = function (styling, baseClass, store, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$checkbox$lambda_1;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (store === void 0)
      store = null;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().checkbox;
    if (build === void 0)
      build = FormControlComponent$checkbox$lambda_2;
    callback$default ? callback$default(styling, baseClass, store, id, prefix, build) : this.checkbox_btfocy$$default(styling, baseClass, store, id, prefix, build);
  };
  function FormControlComponent$checkboxGroup$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$checkboxGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$checkboxGroup$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$checkboxGroup$lambda(closure$styling, closure$items, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      checkboxGroup($receiver, closure$styling, closure$items, closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$checkboxGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$checkboxGroup$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.checkboxGroup_dy8bia$$default = function (styling, items, store, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup, FormControlComponent$checkboxGroup$lambda(styling, items, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$checkboxGroup$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$checkboxGroup$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$checkboxGroup$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.checkboxGroup_dy8bia$ = function (styling, items, store, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$checkboxGroup$lambda_1;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup;
    if (build === void 0)
      build = FormControlComponent$checkboxGroup$lambda_2;
    callback$default ? callback$default(styling, items, store, baseClass, id, prefix, build) : this.checkboxGroup_dy8bia$$default(styling, items, store, baseClass, id, prefix, build);
  };
  function FormControlComponent$radioGroup$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$radioGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$radioGroup$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$radioGroup$lambda(closure$styling, closure$items, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      radioGroup($receiver, closure$styling, closure$items, closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$radioGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$radioGroup$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.radioGroup_jn4dg7$$default = function (styling, items, store, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().radioGroup, FormControlComponent$radioGroup$lambda(styling, items, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$radioGroup$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$radioGroup$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$radioGroup$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.radioGroup_jn4dg7$ = function (styling, items, store, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$radioGroup$lambda_1;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().radioGroup;
    if (build === void 0)
      build = FormControlComponent$radioGroup$lambda_2;
    callback$default ? callback$default(styling, items, store, baseClass, id, prefix, build) : this.radioGroup_jn4dg7$$default(styling, items, store, baseClass, id, prefix, build);
  };
  function FormControlComponent$selectField$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$selectField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$selectField$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$selectField$lambda(closure$styling, closure$items, closure$store, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      selectField($receiver, closure$styling, closure$items, closure$store, closure$baseClass, closure$id, closure$prefix, FormControlComponent$selectField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
      return Unit;
    };
  }
  function FormControlComponent$selectField$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.selectField_fhab61$$default = function (styling, items, store, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_4w43vn$(this, store);
    this.registerControl_b17nx$(FormControlComponent$Companion$ControlNames_getInstance().selectField, FormControlComponent$selectField$lambda(styling, items, store, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$selectField$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$selectField$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$selectField$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.selectField_fhab61$ = function (styling, items, store, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FormControlComponent$selectField$lambda_1;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().selectField;
    if (build === void 0)
      build = FormControlComponent$selectField$lambda_2;
    callback$default ? callback$default(styling, items, store, baseClass, id, prefix, build) : this.selectField_fhab61$$default(styling, items, store, baseClass, id, prefix, build);
  };
  function FormControlComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  FormControlComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var tmp$, tmp$_0;
    if ((tmp$_0 = (tmp$ = this.control_awpzuz$_0.assignee) != null ? tmp$.second : null) != null) {
      var tmp$_1, tmp$_2, tmp$_3;
      tmp$_2 = this.renderStrategies_cd5j51$_0;
      var key = (tmp$_1 = this.control_awpzuz$_0.assignee) != null ? tmp$_1.first : null;
      var tmp$_4;
      (tmp$_3 = (Kotlin.isType(tmp$_4 = tmp$_2, Map) ? tmp$_4 : throwCCE()).get_11rb$(key)) != null && (tmp$_3.render_ibxmnd$(FormControlComponent$render$lambda$lambda(styling), baseClass, id, prefix, context, tmp$_0), Unit);
    }this.control_awpzuz$_0.assert();
    return Unit;
  };
  function FormControlComponent$renderHelperText$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$FormControlComponent.helperTextStyle.value);
      return Unit;
    };
  }
  function FormControlComponent$renderHelperText$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$it);
      return Unit;
    };
  }
  FormControlComponent.prototype.renderHelperText_f2fcv$ = function (renderContext) {
    var tmp$;
    if ((tmp$ = this.helperText.value) != null) {
      styled(getCallableRef('p', function ($receiver, p1, p2, p3) {
        return $receiver.p_4bejqm$(p1, p2, p3);
      }.bind(null, renderContext)), void 0, void 0, void 0, FormControlComponent$renderHelperText$lambda$lambda$lambda(this))(renderContext, FormControlComponent$renderHelperText$lambda$lambda$lambda_0(tmp$));
    }};
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda($receiver) {
    return '100%';
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda($receiver) {
    $receiver.width_wpghq5$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda);
    return Unit;
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '100%';
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.width_wpghq5$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda_0(this$FormControlComponent, closure$message) {
    return function ($receiver) {
      this$FormControlComponent.validationMessageRendering.value($receiver, closure$message);
      return Unit;
    };
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver, message) {
      return box($receiver, FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda, void 0, void 0, void 0, FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda_0(this$FormControlComponent, message));
    };
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda_1(this$FormControlComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      (tmp$_1 = (tmp$_0 = (tmp$ = this$FormControlComponent.validationMessagesBuilder) != null ? tmp$() : null) != null ? tmp$_0.messages : null) != null ? ($receiver.renderEach_tk0399$(tmp$_1, FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda(this$FormControlComponent)), Unit) : null;
      return Unit;
    };
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda_0(this$FormControlComponent) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda_0);
      $receiver.items.invoke_11rb$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda_1(this$FormControlComponent));
      return Unit;
    };
  }
  FormControlComponent.prototype.renderValidationMessages_f2fcv$ = function (renderContext) {
    stackUp(renderContext, FormControlComponent$renderValidationMessages$lambda$lambda, void 0, void 0, void 0, FormControlComponent$renderValidationMessages$lambda$lambda_0(this));
  };
  Object.defineProperty(FormControlComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_43alo6$_0.disabled;
    }
  });
  FormControlComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_43alo6$_0.enabled_6taknv$(value);
  };
  FormControlComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_43alo6$_0.enabled_433wua$(value);
  };
  function FormControlComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function FormControlComponent$sizeBuilder$lambda(this$FormControlComponent) {
    return function (sizes) {
      switch (this$FormControlComponent.size.value(FormControlComponent$FormSizeContext_getInstance()).name) {
        case 'small':
          return sizes.small;
        case 'normal':
          return sizes.normal;
        case 'large':
          return sizes.large;
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function FormControlComponent$validationMessage$lambda() {
    return null;
  }
  function FormControlComponent$validationMessages$lambda() {
    return null;
  }
  function FormControlComponent$validationMessageRendering$lambda$lambda($receiver) {
    return $receiver.compact;
  }
  function FormControlComponent$validationMessageRendering$lambda(this$FormControlComponent) {
    return function ($receiver, message) {
      asAlert(message, $receiver, this$FormControlComponent.sizeBuilder, FormControlComponent$validationMessageRendering$lambda$lambda);
      return Unit;
    };
  }
  FormControlComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormControlComponent',
    interfaces: [FormProperties, Component]
  };
  function ControlRenderer() {
  }
  function ControlRenderer$render$lambda($receiver) {
    return Unit;
  }
  ControlRenderer.prototype.render_ibxmnd$ = function (styling, baseClass, id, prefix, renderContext, control, callback$default) {
    if (styling === void 0)
      styling = ControlRenderer$render$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'formControl';
    callback$default ? callback$default(styling, baseClass, id, prefix, renderContext, control) : this.render_ibxmnd$$default(styling, baseClass, id, prefix, renderContext, control);
  };
  ControlRenderer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ControlRenderer',
    interfaces: []
  };
  function SingleControlRenderer(component) {
    this.component_0 = component;
  }
  function SingleControlRenderer$render$lambda$lambda($receiver) {
    return $receiver.start;
  }
  function SingleControlRenderer$render$lambda$lambda_0($receiver) {
    return $receiver.full;
  }
  function SingleControlRenderer$render$lambda(this$SingleControlRenderer, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.alignItems_tsd917$(SingleControlRenderer$render$lambda$lambda);
      $receiver.width_wpghq5$(SingleControlRenderer$render$lambda$lambda_0);
      $receiver.invoke_qkhqzy$(this$SingleControlRenderer.component_0.ownSize());
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda_1($receiver) {
    return $receiver.tiny;
  }
  function SingleControlRenderer$render$lambda$lambda$lambda(this$SingleControlRenderer) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SingleControlRenderer.component_0.labelStyle.value);
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda$lambda_0(this$SingleControlRenderer) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$SingleControlRenderer.component_0.label.value);
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda_2(this$SingleControlRenderer, closure$control) {
    return function ($receiver) {
      styled(getCallableRef('label', function ($receiver, p1, p2, p3) {
        return $receiver.label_6gkvle$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, SingleControlRenderer$render$lambda$lambda$lambda(this$SingleControlRenderer))($receiver, SingleControlRenderer$render$lambda$lambda$lambda_0(this$SingleControlRenderer));
      closure$control($receiver);
      this$SingleControlRenderer.component_0.renderHelperText_f2fcv$($receiver);
      this$SingleControlRenderer.component_0.renderValidationMessages_f2fcv$($receiver);
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda_0(this$SingleControlRenderer, closure$control) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(SingleControlRenderer$render$lambda$lambda_1);
      $receiver.items.invoke_11rb$(SingleControlRenderer$render$lambda$lambda_2(this$SingleControlRenderer, closure$control));
      return Unit;
    };
  }
  SingleControlRenderer.prototype.render_ibxmnd$$default = function (styling, baseClass, id, prefix, renderContext, control) {
    stackUp(renderContext, SingleControlRenderer$render$lambda(this, styling), baseClass, id, prefix, SingleControlRenderer$render$lambda_0(this, control));
  };
  SingleControlRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleControlRenderer',
    interfaces: [ControlRenderer]
  };
  function ControlGroupRenderer(component) {
    this.component_0 = component;
  }
  function ControlGroupRenderer$render$lambda$lambda($receiver) {
    return $receiver.full;
  }
  function ControlGroupRenderer$render$lambda($receiver) {
    $receiver.width_wpghq5$(ControlGroupRenderer$render$lambda$lambda);
    return Unit;
  }
  function ControlGroupRenderer$render$lambda$lambda_0(this$ControlGroupRenderer, closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$ControlGroupRenderer.component_0.ownSize());
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda(this$ControlGroupRenderer) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$ControlGroupRenderer.component_0.labelStyle.value);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda_0(this$ControlGroupRenderer) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$ControlGroupRenderer.component_0.label.value);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda_1(this$ControlGroupRenderer, closure$control) {
    return function ($receiver) {
      styled(getCallableRef('legend', function ($receiver, p1, p2, p3) {
        return $receiver.legend_cutgnt$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, ControlGroupRenderer$render$lambda$lambda$lambda(this$ControlGroupRenderer))($receiver, ControlGroupRenderer$render$lambda$lambda$lambda_0(this$ControlGroupRenderer));
      closure$control($receiver);
      this$ControlGroupRenderer.component_0.renderHelperText_f2fcv$($receiver);
      this$ControlGroupRenderer.component_0.renderValidationMessages_f2fcv$($receiver);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda_0(closure$baseClass, closure$id, closure$prefix, this$ControlGroupRenderer, closure$styling, closure$control) {
    return function ($receiver) {
      styled(getCallableRef('fieldset', function ($receiver, p1, p2, p3) {
        return $receiver.fieldset_kcy17m$(p1, p2, p3);
      }.bind(null, $receiver)), closure$baseClass, closure$id, closure$prefix, ControlGroupRenderer$render$lambda$lambda_0(this$ControlGroupRenderer, closure$styling))($receiver, ControlGroupRenderer$render$lambda$lambda_1(this$ControlGroupRenderer, closure$control));
      return Unit;
    };
  }
  ControlGroupRenderer.prototype.render_ibxmnd$$default = function (styling, baseClass, id, prefix, renderContext, control) {
    box(renderContext, ControlGroupRenderer$render$lambda, void 0, void 0, void 0, ControlGroupRenderer$render$lambda_0(baseClass, id, prefix, this, styling, control));
  };
  ControlGroupRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ControlGroupRenderer',
    interfaces: [ControlRenderer]
  };
  function formControl$lambda($receiver) {
    return Unit;
  }
  function formControl$lambda_0($receiver) {
    return Unit;
  }
  function formControl($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = formControl$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'formControl';
    if (build === void 0)
      build = formControl$lambda_0;
    var $receiver_0 = new FormControlComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  var xmlns;
  function createIconSvgElement(baseClass) {
    var elem = document.createElementNS(xmlns, 'svg');
    if (baseClass != null) {
      elem.setAttributeNS(null, 'class', baseClass);
    }return elem;
  }
  function Svg(id, baseClass, domNode, job) {
    if (id === void 0)
      id = null;
    if (baseClass === void 0)
      baseClass = null;
    if (domNode === void 0)
      domNode = createIconSvgElement(baseClass);
    Tag.call(this, '', id, void 0, job, domNode);
    this.domNode_6fom5q$_0 = domNode;
  }
  Object.defineProperty(Svg.prototype, 'domNode', {
    get: function () {
      return this.domNode_6fom5q$_0;
    }
  });
  Svg.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Svg',
    interfaces: [Tag]
  };
  function svg($receiver, baseClass, id, init) {
    return $receiver.register_x3phfy$(new Svg(id, baseClass, void 0, $receiver.job), init);
  }
  function IconComponent() {
    IconComponent$Companion_getInstance();
    this.$delegate_a3h6ky$_0 = new EventMixin();
    this.def = new ComponentProperty(null);
    this.displayName = new ComponentProperty(null);
    this.viewBox = new ComponentProperty('0 0 24 24');
    this.svg = new ComponentProperty(null);
  }
  function IconComponent$Companion() {
    IconComponent$Companion_instance = this;
    this.prefix = 'icon';
    this.staticCss = staticStyle_0(this.prefix, '\n                width: 1.25rem;\n                height: 1.25rem;\n                color: currentColor;\n                display: inline-block;\n                vertical-align: middle;\n                flex-shrink: 0;\n                backface-visibility: hidden;\n            ');
  }
  IconComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var IconComponent$Companion_instance = null;
  function IconComponent$Companion_getInstance() {
    if (IconComponent$Companion_instance === null) {
      new IconComponent$Companion();
    }return IconComponent$Companion_instance;
  }
  IconComponent.prototype.fromTheme_q0wvou$ = function (value) {
    this.def.invoke_11rb$(value(Theme.Companion.invoke().icons));
  };
  function IconComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function IconComponent$render$lambda$lambda_0(this$IconComponent) {
    return function ($receiver) {
      var tmp$;
      if ((tmp$ = this$IconComponent.def.value) != null) {
        $receiver.domNode.setAttributeNS(null, 'viewBox', tmp$.viewBox);
        $receiver.domNode.setAttributeNS(null, 'focusable', 'false');
        $receiver.domNode.setAttributeNS(null, 'role', 'presentation');
        $receiver.domNode.innerHTML = tmp$.svg;
      }this$IconComponent.events.value($receiver);
      return Unit;
    };
  }
  IconComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    styled(getCallableRef('svg', function ($receiver, p1, p2, p3) {
      return svg($receiver, p1, p2, p3);
    }.bind(null, context)), baseClass.plus_fox8kt$(IconComponent$Companion_getInstance().staticCss), id, prefix, IconComponent$render$lambda$lambda(styling))(context, IconComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  Object.defineProperty(IconComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_a3h6ky$_0.events;
    }
  });
  IconComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IconComponent',
    interfaces: [EventProperties, Component]
  };
  function icon$lambda($receiver) {
    return Unit;
  }
  function icon$lambda_0($receiver) {
    return Unit;
  }
  function icon($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = icon$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = IconComponent$Companion_getInstance().prefix;
    if (build === void 0)
      build = icon$lambda_0;
    var $receiver_0 = new IconComponent();
    build($receiver_0);
    if ($receiver_0.displayName.value != null && $receiver_0.svg.value != null) {
      $receiver_0.def.invoke_11rb$(new IconDefinition(ensureNotNull($receiver_0.displayName.value), $receiver_0.viewBox.value, ensureNotNull($receiver_0.svg.value)));
    }$receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function InputFieldComponent(store) {
    InputFieldComponent$Companion_getInstance();
    this.store = store;
    this.$delegate_rceexn$_0 = new EventMixin();
    this.$delegate_rceexn$_1 = new ElementMixin();
    this.$delegate_rceexn$_2 = new InputFormMixin();
    this.$delegate_rceexn$_3 = new SeverityMixin();
    this.variant = new ComponentProperty(InputFieldComponent$variant$lambda);
    this.size = new ComponentProperty(InputFieldComponent$size$lambda);
    this.value = new DynamicComponentProperty(flowOf(''));
    this.placeholder = new DynamicComponentProperty(flowOf(''));
    this.type = new DynamicComponentProperty(flowOf(''));
    this.step = new DynamicComponentProperty(flowOf(''));
  }
  function InputFieldComponent$Companion() {
    InputFieldComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('inputBox', '\n                display: inline-flex;\n                position: relative;\n                vertical-align: middle;\n                height: 2.5rem;\n                appearance: none;\n                align-items : center;\n                justify-content: center;\n                transition: all 250ms;\n                white-space: nowrap;\n                outline: none;\n                width: 100%\n            ');
  }
  InputFieldComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InputFieldComponent$Companion_instance = null;
  function InputFieldComponent$Companion_getInstance() {
    if (InputFieldComponent$Companion_instance === null) {
      new InputFieldComponent$Companion();
    }return InputFieldComponent$Companion_instance;
  }
  function InputFieldComponent$render$lambda$lambda(this$InputFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$InputFieldComponent.size.value(Theme.Companion.invoke().input.sizes));
      $receiver.invoke_qkhqzy$(this$InputFieldComponent.variant.value(Theme.Companion.invoke().input.variants));
      return Unit;
    };
  }
  function InputFieldComponent$render$lambda$lambda_0(this$InputFieldComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.disabled_f1igrw$(this$InputFieldComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$InputFieldComponent.readonly.values);
      $receiver.placeholder_p81yox$(this$InputFieldComponent.placeholder.values);
      $receiver.value_p81yox$(this$InputFieldComponent.value.values);
      $receiver.type_p81yox$(this$InputFieldComponent.type.values);
      $receiver.step_p81yox$(this$InputFieldComponent.step.values);
      $receiver.className_p81yox$(get_name(this$InputFieldComponent.severityClassOf_i6436e$(Theme.Companion.invoke().input.severity)));
      if ((tmp$ = this$InputFieldComponent.store) != null) {
        $receiver.value_p81yox$(tmp$.data);
        $receiver.handledBy_ytah3h$(values($receiver.changes), tmp$.update);
      }this$InputFieldComponent.events.value($receiver);
      this$InputFieldComponent.element.value($receiver);
      return Unit;
    };
  }
  InputFieldComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    styled_0(getCallableRef('input', function ($receiver, p1, p2, p3) {
      return $receiver.input_1ect6g$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass.plus_fox8kt$(InputFieldComponent$Companion_getInstance().staticCss), id, prefix, InputFieldComponent$render$lambda$lambda(this))(context, InputFieldComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  Object.defineProperty(InputFieldComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_rceexn$_0.events;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_rceexn$_1.element;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_rceexn$_2.disabled;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_rceexn$_2.readonly;
    }
  });
  InputFieldComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_rceexn$_2.enabled_6taknv$(value);
  };
  InputFieldComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_rceexn$_2.enabled_433wua$(value);
  };
  Object.defineProperty(InputFieldComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_rceexn$_3.severity;
    }
  });
  InputFieldComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_rceexn$_3.severity_9dec1s$(value);
  };
  InputFieldComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_rceexn$_3.severityClassOf_i6436e$(severityStyle);
  };
  function InputFieldComponent$variant$lambda($receiver) {
    return Theme.Companion.invoke().input.variants.outline;
  }
  function InputFieldComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().input.sizes.normal;
  }
  InputFieldComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InputFieldComponent',
    interfaces: [SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function inputField$lambda($receiver) {
    return Unit;
  }
  function inputField$lambda_0($receiver) {
    return Unit;
  }
  function inputField($receiver, styling, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = inputField$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'inputField';
    if (build === void 0)
      build = inputField$lambda_0;
    var $receiver_0 = new InputFieldComponent(store);
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function ManagedComponent() {
    ManagedComponent$Companion_getInstance();
  }
  function ManagedComponent$Companion() {
    ManagedComponent$Companion_instance = this;
  }
  ManagedComponent$Companion.prototype.managedRenderContext_ue0xbo$ = function (id, job) {
    var tmp$, tmp$_0;
    console.log('neue managedRenderContext Methode aufgerufen...');
    var element = document.getElementById(id);
    if (element != null) {
      tmp$_0 = new Tag('div', element.id, void 0, job, Kotlin.isType(tmp$ = element, HTMLElement) ? tmp$ : throwCCE());
    } else {
      var $receiver = new Div(id, void 0, job);
      var tmp$_1;
      (tmp$_1 = document.body) != null ? tmp$_1.appendChild($receiver.domNode) : null;
      tmp$_0 = $receiver;
    }
    var $receiver_0 = tmp$_0;
    $receiver_0.domNode.innerHTML = '';
    return $receiver_0;
  };
  ManagedComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ManagedComponent$Companion_instance = null;
  function ManagedComponent$Companion_getInstance() {
    if (ManagedComponent$Companion_instance === null) {
      new ManagedComponent$Companion();
    }return ManagedComponent$Companion_instance;
  }
  ManagedComponent.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ManagedComponent',
    interfaces: []
  };
  function randomId() {
    var random = nextUInt(Random.Default, new UInt(10000), new UInt(99999)).toString();
    var time = (new Date()).getMilliseconds().toString();
    var startIndex = time.length - 3 | 0;
    return random + time.substring(startIndex);
  }
  function unsafeFlow$ObjectLiteral_4(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_4($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_4.prototype.constructor = Coroutine$collect_42ocv1$_4;
  Coroutine$collect_42ocv1$_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_4.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_4(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_4.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_3.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_3;
  Coroutine$unsafeTransform$lambda$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_3 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_3(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_2(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_2.prototype.constructor = Coroutine$map$lambda_2;
  Coroutine$map$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_2(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_2(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function OverlayMethod(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OverlayMethod_initFields() {
    OverlayMethod_initFields = function () {
    };
    OverlayMethod$CoveringTopMost_instance = new OverlayMethod('CoveringTopMost', 0);
    OverlayMethod$CoveringEach_instance = new OverlayMethod('CoveringEach', 1);
  }
  var OverlayMethod$CoveringTopMost_instance;
  function OverlayMethod$CoveringTopMost_getInstance() {
    OverlayMethod_initFields();
    return OverlayMethod$CoveringTopMost_instance;
  }
  var OverlayMethod$CoveringEach_instance;
  function OverlayMethod$CoveringEach_getInstance() {
    OverlayMethod_initFields();
    return OverlayMethod$CoveringEach_instance;
  }
  OverlayMethod.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OverlayMethod',
    interfaces: [Enum]
  };
  function OverlayMethod$values() {
    return [OverlayMethod$CoveringTopMost_getInstance(), OverlayMethod$CoveringEach_getInstance()];
  }
  OverlayMethod.values = OverlayMethod$values;
  function OverlayMethod$valueOf(name) {
    switch (name) {
      case 'CoveringTopMost':
        return OverlayMethod$CoveringTopMost_getInstance();
      case 'CoveringEach':
        return OverlayMethod$CoveringEach_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.OverlayMethod.' + name);
    }
  }
  OverlayMethod.valueOf_61zpoe$ = OverlayMethod$valueOf;
  function Overlay() {
  }
  Overlay.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Overlay',
    interfaces: []
  };
  function DefaultOverlay(method, styling) {
    if (method === void 0)
      method = OverlayMethod$CoveringTopMost_getInstance();
    if (styling === void 0)
      styling = Theme.Companion.invoke().modal.overlay;
    this.method_pnlkok$_0 = method;
    this.styling_qe4bdl$_0 = styling;
  }
  Object.defineProperty(DefaultOverlay.prototype, 'method', {
    get: function () {
      return this.method_pnlkok$_0;
    }
  });
  Object.defineProperty(DefaultOverlay.prototype, 'styling', {
    get: function () {
      return this.styling_qe4bdl$_0;
    }
  });
  function DefaultOverlay$render$lambda$lambda(closure$level) {
    return function ($receiver) {
      return $receiver.modal_vux9f0$(closure$level, -1);
    };
  }
  function DefaultOverlay$render$lambda(closure$level, this$DefaultOverlay) {
    return function ($receiver) {
      $receiver.zIndex_yiflju$(DefaultOverlay$render$lambda$lambda(closure$level));
      $receiver.invoke_qkhqzy$(this$DefaultOverlay.styling);
      return Unit;
    };
  }
  function DefaultOverlay$render$lambda_0($receiver) {
    return Unit;
  }
  DefaultOverlay.prototype.render_shxkx9$ = function (renderContext, level) {
    box(renderContext, DefaultOverlay$render$lambda(level, this), void 0, void 0, 'modal-overlay', DefaultOverlay$render$lambda_0);
  };
  DefaultOverlay.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultOverlay',
    interfaces: [Overlay]
  };
  function ModalComponent(build) {
    ModalComponent$Companion_getInstance();
    this.build = build;
    this.$delegate_4ibmgy$_0 = new CloseButtonMixin('modal-close-button', ModalComponent_init$lambda);
    this.content = new ComponentProperty(null);
    this.size = new ComponentProperty(ModalComponent$size$lambda);
    this.variant = new ComponentProperty(ModalComponent$variant$lambda);
  }
  function ModalComponent$ModalsStack() {
    RootStore.call(this, emptyList());
    this.pop = this.handle_7ib3lp$(void 0, ModalComponent$ModalsStack$pop$lambda);
  }
  function Coroutine$ModalComponent$ModalsStack$push$lambda(closure$dialog_0, stack_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$dialog = closure$dialog_0;
    this.local$stack = stack_0;
  }
  Coroutine$ModalComponent$ModalsStack$push$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ModalComponent$ModalsStack$push$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ModalComponent$ModalsStack$push$lambda.prototype.constructor = Coroutine$ModalComponent$ModalsStack$push$lambda;
  Coroutine$ModalComponent$ModalsStack$push$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return plus(this.local$stack, this.local$closure$dialog);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ModalComponent$ModalsStack$push$lambda(closure$dialog_0) {
    return function (stack_0, continuation_0, suspended) {
      var instance = new Coroutine$ModalComponent$ModalsStack$push$lambda(closure$dialog_0, stack_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ModalComponent$ModalsStack.prototype.push_fw14vz$ = function (dialog) {
    return this.handle_7ib3lp$(void 0, ModalComponent$ModalsStack$push$lambda(dialog));
  };
  function Coroutine$ModalComponent$ModalsStack$pop$lambda(stack_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$stack = stack_0;
  }
  Coroutine$ModalComponent$ModalsStack$pop$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ModalComponent$ModalsStack$pop$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ModalComponent$ModalsStack$pop$lambda.prototype.constructor = Coroutine$ModalComponent$ModalsStack$pop$lambda;
  Coroutine$ModalComponent$ModalsStack$pop$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return dropLast(this.local$stack, 1);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ModalComponent$ModalsStack$pop$lambda(stack_0, continuation_0, suspended) {
    var instance = new Coroutine$ModalComponent$ModalsStack$pop$lambda(stack_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ModalComponent$ModalsStack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModalsStack',
    interfaces: [RootStore]
  };
  function ModalComponent$Companion() {
    ModalComponent$Companion_instance = this;
    this.stack_0 = new ModalComponent$ModalsStack();
    this.overlay = storeOf(new DefaultOverlay());
    this.job_0 = Job();
    this.globalId_0 = 'f2c-modals-' + randomId();
    var $receiver = this.stack_0.data;
    watch(new unsafeFlow$ObjectLiteral_4(unsafeTransform$lambda_3(map$lambda_2(ModalComponent$ModalComponent$Companion_init$lambda(this)), $receiver)));
  }
  ModalComponent$Companion.prototype.setOverlayHandler_hynfmm$ = function (overlay) {
    ModalComponent$Companion_getInstance().overlay.update.invoke_11rb$(overlay);
  };
  function ModalComponent$ModalComponent$Companion_init$lambda$lambda$lambda$lambda(closure$currentOverlay, closure$index, closure$modal) {
    return function ($receiver) {
      closure$currentOverlay.render_shxkx9$($receiver, closure$index + 1 | 0);
      closure$modal($receiver, closure$index + 1 | 0);
      return Unit;
    };
  }
  function Coroutine$ModalComponent$ModalComponent$Companion_init$lambda(this$ModalComponent$_0, modals_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ModalComponent$ = this$ModalComponent$_0;
    this.local$modals = modals_0;
  }
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.prototype.constructor = Coroutine$ModalComponent$ModalComponent$Companion_init$lambda;
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var $receiver = ManagedComponent$Companion_getInstance().managedRenderContext_ue0xbo$(this.local$this$ModalComponent$.globalId_0, this.local$this$ModalComponent$.job_0);
            var currentOverlay = this.local$this$ModalComponent$.overlay.current;
            var tmp$ = currentOverlay.method === OverlayMethod$CoveringTopMost_getInstance();
            if (tmp$) {
              tmp$ = !this.local$modals.isEmpty();
            }
            if (tmp$) {
              currentOverlay.render_shxkx9$($receiver, this.local$modals.size);
            }
            var tmp$_0;
            tmp$_0 = toList_0(withIndex(this.local$modals)).iterator();
            while (tmp$_0.hasNext()) {
              var element = tmp$_0.next();
              var index = element.component1()
              , modal = element.component2();
              if (currentOverlay.method === OverlayMethod$CoveringEach_getInstance()) {
                $receiver.div_hhcm6n$(void 0, void 0, ModalComponent$ModalComponent$Companion_init$lambda$lambda$lambda$lambda(currentOverlay, index, modal));
              } else
                modal($receiver, index + 1 | 0);
            }

            return $receiver;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ModalComponent$ModalComponent$Companion_init$lambda(this$ModalComponent$_0) {
    return function (modals_0, continuation_0, suspended) {
      var instance = new Coroutine$ModalComponent$ModalComponent$Companion_init$lambda(this$ModalComponent$_0, modals_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ModalComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ModalComponent$Companion_instance = null;
  function ModalComponent$Companion_getInstance() {
    if (ModalComponent$Companion_instance === null) {
      new ModalComponent$Companion();
    }return ModalComponent$Companion_instance;
  }
  function ModalComponent$render$lambda$lambda$lambda(closure$level) {
    return function ($receiver) {
      return $receiver.modal_za3lpa$(closure$level);
    };
  }
  function ModalComponent$render$lambda$lambda(closure$level, closure$component, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.css_61zpoe$('--main-level: ' + closure$level + 'rem;');
      $receiver.zIndex_yiflju$(ModalComponent$render$lambda$lambda$lambda(closure$level));
      $receiver.invoke_qkhqzy$(closure$component.size.value(Theme.Companion.invoke().modal.sizes));
      $receiver.invoke_qkhqzy$(closure$component.variant.value(Theme.Companion.invoke().modal.variants));
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function ModalComponent$render$lambda$lambda_0(closure$component, closure$close) {
    return function ($receiver) {
      var tmp$;
      if (closure$component.hasCloseButton.value) {
        $receiver.handledBy_jora5j$(closure$component.closeButtonRendering.value($receiver), closure$close);
      }if ((tmp$ = closure$component.content.value) != null) {
        tmp$($receiver);
      }return Unit;
    };
  }
  function ModalComponent$render$lambda(closure$component, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$close) {
    return function ($receiver, level) {
      return box($receiver, ModalComponent$render$lambda$lambda(level, closure$component, closure$styling), closure$baseClass, closure$id, closure$prefix, ModalComponent$render$lambda$lambda_0(closure$component, closure$close));
    };
  }
  ModalComponent.prototype.render_n7482o$ = function (styling, baseClass, id, prefix) {
    var close = ModalComponent$Companion_getInstance().stack_0.pop;
    this.build(this, close);
    var component = this;
    var modal = ModalComponent$render$lambda(component, styling, baseClass, id, prefix, close);
    return ModalComponent$Companion_getInstance().stack_0.push_fw14vz$(modal);
  };
  Object.defineProperty(ModalComponent.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_4ibmgy$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_4ibmgy$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_4ibmgy$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_4ibmgy$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_4ibmgy$_0.hasCloseButton;
    }
  });
  function ModalComponent_init$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.none;
  }
  function ModalComponent_init$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function ModalComponent_init$lambda$lambda$lambda($receiver) {
    $receiver.right_bcpvvc$(ModalComponent_init$lambda$lambda$lambda$lambda);
    $receiver.top_bcpvvc$(ModalComponent_init$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function ModalComponent_init$lambda$lambda($receiver) {
    $receiver.absolute_dkjn9d$(ModalComponent_init$lambda$lambda$lambda);
    return Unit;
  }
  function ModalComponent_init$lambda($receiver) {
    $receiver.position_wp9r2r$(ModalComponent_init$lambda$lambda);
    return Unit;
  }
  function ModalComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().modal.sizes.normal;
  }
  function ModalComponent$variant$lambda($receiver) {
    return Theme.Companion.invoke().modal.variants.auto;
  }
  ModalComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModalComponent',
    interfaces: [CloseButtonProperty, ManagedComponent]
  };
  function modal$lambda($receiver) {
    return Unit;
  }
  function modal(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = modal$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'modal';
    return (new ModalComponent(build)).render_n7482o$(styling, baseClass, id, prefix);
  }
  function NavLinkComponent() {
    NavLinkComponent$Companion_getInstance();
    this.icon = new ComponentProperty(NavLinkComponent$icon$lambda);
    this.text = new DynamicComponentProperty(flowOf('Navigation Link'));
    this.active = new ComponentProperty(null);
  }
  function NavLinkComponent$Companion() {
    NavLinkComponent$Companion_instance = this;
    this.activeStyle = staticStyle_1('navlink-active', NavLinkComponent$Companion$activeStyle$lambda);
  }
  function NavLinkComponent$Companion$activeStyle$lambda($receiver) {
    $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.activeNavLink);
    return Unit;
  }
  NavLinkComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var NavLinkComponent$Companion_instance = null;
  function NavLinkComponent$Companion_getInstance() {
    if (NavLinkComponent$Companion_instance === null) {
      new NavLinkComponent$Companion();
    }return NavLinkComponent$Companion_instance;
  }
  function NavLinkComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.navLink);
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function NavLinkComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.small;
  }
  function NavLinkComponent$render$lambda$lambda$lambda$lambda(this$NavLinkComponent) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(this$NavLinkComponent.text.values);
      return Unit;
    };
  }
  function NavLinkComponent$render$lambda$lambda$lambda_0(this$NavLinkComponent) {
    return function ($receiver) {
      var tmp$;
      if ((tmp$ = this$NavLinkComponent.active.value) != null) {
        $receiver.className_p81yox$(get_name(whenever(NavLinkComponent$Companion_getInstance().activeStyle, tmp$)));
      }icon($receiver, void 0, void 0, void 0, void 0, this$NavLinkComponent.icon.value);
      $receiver.a_eie6ox$(void 0, void 0, NavLinkComponent$render$lambda$lambda$lambda$lambda(this$NavLinkComponent));
      return Unit;
    };
  }
  function NavLinkComponent$render$lambda$lambda$lambda_1(closure$clickEvents) {
    return function ($receiver) {
      closure$clickEvents.v = $receiver.clicks.stopImmediatePropagation();
      return Unit;
    };
  }
  function NavLinkComponent$render$lambda$lambda_0(this$NavLinkComponent, closure$clickEvents) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(NavLinkComponent$render$lambda$lambda$lambda);
      $receiver.items.invoke_11rb$(NavLinkComponent$render$lambda$lambda$lambda_0(this$NavLinkComponent));
      $receiver.events.invoke_11rb$(NavLinkComponent$render$lambda$lambda$lambda_1(closure$clickEvents));
      return Unit;
    };
  }
  NavLinkComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var clickEvents = {v: null};
    lineUp(context, NavLinkComponent$render$lambda$lambda(styling), baseClass, id, prefix, NavLinkComponent$render$lambda$lambda_0(this, clickEvents));
    return ensureNotNull(clickEvents.v);
  };
  function NavLinkComponent$icon$lambda$lambda($receiver) {
    return $receiver.bookmark;
  }
  function NavLinkComponent$icon$lambda($receiver) {
    $receiver.fromTheme_q0wvou$(NavLinkComponent$icon$lambda$lambda);
    return Unit;
  }
  NavLinkComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NavLinkComponent',
    interfaces: [Component]
  };
  function navLink$lambda($receiver) {
    return Unit;
  }
  function navLink$lambda_0($receiver) {
    return Unit;
  }
  function navLink($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = navLink$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'navlink';
    if (build === void 0)
      build = navLink$lambda_0;
    var $receiver_0 = new NavLinkComponent();
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function navSection$lambda($receiver) {
    return Unit;
  }
  function navSection$lambda_0(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.navSection);
      $receiver.invoke_qkhqzy$(closure$styling);
      return Unit;
    };
  }
  function navSection$lambda_1(closure$text) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$text);
      return Unit;
    };
  }
  function navSection($receiver, text, styling, baseClass, id, prefix) {
    if (styling === void 0)
      styling = navSection$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'navsection';
    styled(getCallableRef('h3', function ($receiver, p1, p2, p3) {
      return $receiver.h3_hya6au$(p1, p2, p3);
    }.bind(null, $receiver)), baseClass, id, prefix, navSection$lambda_0(styling))($receiver, navSection$lambda_1(text));
  }
  function NavbarComponent() {
    NavbarComponent$Companion_getInstance();
    this.brand = new ComponentProperty(NavbarComponent$brand$lambda);
    this.actions = new ComponentProperty(NavbarComponent$actions$lambda);
  }
  function NavbarComponent$Companion() {
    NavbarComponent$Companion_instance = this;
    this.staticHeaderCss = staticStyle_0('navbar-header', '\n                transition: box-shadow 0.2s;\n                position: fixed;\n                top: 0;\n                z-index: 199;\n                background: #FFFFFF;\n                left: 0;\n                right: 0;\n                width: 100%;\n            ');
    this.staticContentCss = staticStyle_0('navbar-content', '\n                display: flex;\n                align-items: center;\n                justify-content: space-between;\n                height: 4.5rem;\n                width: 100%;\n                padding-left: 1.5rem;\n                padding-right: 1.5rem;\n            ');
    this.staticBrandCss = staticStyle_0('navbar-brand', '\n                display: flex;\n                align-items: center;\n            ');
    this.staticActionsCss = staticStyle_0('navbar-actions', '\n                display: flex;\n                align-items: center;\n            ');
  }
  NavbarComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var NavbarComponent$Companion_instance = null;
  function NavbarComponent$Companion_getInstance() {
    if (NavbarComponent$Companion_instance === null) {
      new NavbarComponent$Companion();
    }return NavbarComponent$Companion_instance;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '6px';
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.solid;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    return $receiver.primary.base;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.width_qwzhsr$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda);
    $receiver.style_hw5xj$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0);
    $receiver.color_jl9ed9$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_2($receiver) {
    return '2px';
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_3($receiver) {
    return $receiver.solid;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_4($receiver) {
    return $receiver.gray300;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    $receiver.width_qwzhsr$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_2);
    $receiver.style_hw5xj$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_3);
    $receiver.color_jl9ed9$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_4);
    return Unit;
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda($receiver) {
    $receiver.top_4a22k0$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda);
    $receiver.bottom_4a22k0$(NavbarComponent$render$lambda$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function NavbarComponent$render$lambda$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.borders_9iuei5$(NavbarComponent$render$lambda$lambda$lambda$lambda);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda_0(this$NavbarComponent) {
    return function ($receiver) {
      this$NavbarComponent.brand.value($receiver);
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda_1(this$NavbarComponent) {
    return function ($receiver) {
      this$NavbarComponent.actions.value($receiver);
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda$lambda_0(this$NavbarComponent) {
    return function ($receiver) {
      $receiver.div_hhcm6n$(NavbarComponent$Companion_getInstance().staticBrandCss.name, void 0, NavbarComponent$render$lambda$lambda$lambda$lambda_0(this$NavbarComponent));
      $receiver.div_hhcm6n$(NavbarComponent$Companion_getInstance().staticActionsCss.name, void 0, NavbarComponent$render$lambda$lambda$lambda$lambda_1(this$NavbarComponent));
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda(closure$prefix, closure$styling, this$NavbarComponent) {
    return function ($receiver) {
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), NavbarComponent$Companion_getInstance().staticContentCss, void 0, closure$prefix, NavbarComponent$render$lambda$lambda$lambda(closure$styling))($receiver, NavbarComponent$render$lambda$lambda$lambda_0(this$NavbarComponent));
      return Unit;
    };
  }
  NavbarComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    context.nav_viepbn$(NavbarComponent$Companion_getInstance().staticHeaderCss.plus_fox8kt$(baseClass).name, id, NavbarComponent$render$lambda$lambda(prefix, styling, this));
    return Unit;
  };
  function NavbarComponent$brand$lambda($receiver) {
    return Unit;
  }
  function NavbarComponent$actions$lambda($receiver) {
    return Unit;
  }
  NavbarComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NavbarComponent',
    interfaces: [Component]
  };
  function navBar$lambda($receiver) {
    return Unit;
  }
  function navBar$lambda_0($receiver) {
    return Unit;
  }
  function navBar($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = navBar$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'navbar';
    if (build === void 0)
      build = navBar$lambda_0;
    var $receiver_0 = new NavbarComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_5(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_5($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_5.prototype.constructor = Coroutine$collect_42ocv1$_5;
  Coroutine$collect_42ocv1$_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_5.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_5(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_5.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_4(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_4.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_4;
  Coroutine$unsafeTransform$lambda$lambda_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_4(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_4(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_4 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_4(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_3(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_3.prototype.constructor = Coroutine$map$lambda_3;
  Coroutine$map$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_3(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_3(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_6(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_6($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_6.prototype.constructor = Coroutine$collect_42ocv1$_6;
  Coroutine$collect_42ocv1$_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_6.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_6(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_6.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow_0]};
  function Coroutine$unsafeTransform$lambda$lambda_5(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_5.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_5;
  Coroutine$unsafeTransform$lambda$lambda_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_5(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_5(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_5 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$fritz2_core_jsLegacy.$$importsForInline$$['kotlinx-coroutines-core'].kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_5(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_4(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_4.prototype.constructor = Coroutine$map$lambda_4;
  Coroutine$map$lambda_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_4(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_4(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function PopoverComponent() {
    PopoverComponent$Companion_getInstance();
    this.$delegate_677i8a$_0 = new CloseButtonMixin('popover-close-button', Theme.Companion.invoke().popover.closeButton);
    this.size = new ComponentProperty(PopoverComponent$size$lambda);
    this.placementStyle_nwfc3a$_0 = PopoverComponent$placementStyle$lambda;
    this.closeOnBlur = new ComponentProperty(true);
    this.closeOnEscape = new ComponentProperty(true);
    this.hasArrow = new ComponentProperty(true);
    this.arrowPlacement = new ComponentProperty(PopoverComponent$arrowPlacement$lambda);
    this.toggle = new ComponentProperty(null);
    this.header_huufl5$_0 = null;
    this.footer_6jikth$_0 = null;
    this.content_5mgsl7$_0 = null;
  }
  function PopoverComponent$Companion() {
    PopoverComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('popover', '\n                  display: inline-block;\n                  position: relative;  \n            ');
  }
  PopoverComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PopoverComponent$Companion_instance = null;
  function PopoverComponent$Companion_getInstance() {
    if (PopoverComponent$Companion_instance === null) {
      new PopoverComponent$Companion();
    }return PopoverComponent$Companion_instance;
  }
  function PopoverComponent$placement$lambda($receiver) {
    return $receiver.bottom;
  }
  function PopoverComponent$placement$lambda_0($receiver) {
    return $receiver.left;
  }
  function PopoverComponent$placement$lambda_1($receiver) {
    return $receiver.top;
  }
  function PopoverComponent$placement$lambda_2($receiver) {
    return $receiver.right;
  }
  PopoverComponent.prototype.placement_aes0rj$ = function (value) {
    var tmp$;
    tmp$ = value(Theme.Companion.invoke().popover.placement);
    if (equals(tmp$, Theme.Companion.invoke().popover.placement.top))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda);
    else if (equals(tmp$, Theme.Companion.invoke().popover.placement.right))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda_0);
    else if (equals(tmp$, Theme.Companion.invoke().popover.placement.bottom))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda_1);
    else if (equals(tmp$, Theme.Companion.invoke().popover.placement.left))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda_2);
    this.placementStyle_nwfc3a$_0 = value;
  };
  function PopoverComponent$header$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.header);
    return Unit;
  }
  function PopoverComponent$header$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      closure$value($receiver);
      return Unit;
    };
  }
  function PopoverComponent$header$lambda(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('header', function ($receiver, p1, p2, p3) {
        return $receiver.header_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'popover-header', PopoverComponent$header$lambda$lambda)($receiver, PopoverComponent$header$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.header_izurti$ = function (value) {
    this.header_huufl5$_0 = PopoverComponent$header$lambda(value);
  };
  PopoverComponent.prototype.header_61zpoe$ = function (value) {
    this.header_p81yox$(flowOf(value));
  };
  function PopoverComponent$header$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.header);
    return Unit;
  }
  function PopoverComponent$header$lambda$lambda_2(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function PopoverComponent$header$lambda_0(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('header', function ($receiver, p1, p2, p3) {
        return $receiver.header_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'popover-header', PopoverComponent$header$lambda$lambda_1)($receiver, PopoverComponent$header$lambda$lambda_2(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.header_p81yox$ = function (value) {
    this.header_huufl5$_0 = PopoverComponent$header$lambda_0(value);
  };
  function PopoverComponent$footer$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.footer);
    return Unit;
  }
  function PopoverComponent$footer$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      closure$value($receiver);
      return Unit;
    };
  }
  function PopoverComponent$footer$lambda(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('footer', function ($receiver, p1, p2, p3) {
        return $receiver.footer_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'popover-footer', PopoverComponent$footer$lambda$lambda)($receiver, PopoverComponent$footer$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.footer_izurti$ = function (value) {
    this.footer_6jikth$_0 = PopoverComponent$footer$lambda(value);
  };
  PopoverComponent.prototype.footer_61zpoe$ = function (value) {
    this.footer_p81yox$(flowOf(value));
  };
  function PopoverComponent$footer$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.footer);
    return Unit;
  }
  function PopoverComponent$footer$lambda$lambda_2(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function PopoverComponent$footer$lambda_0(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('footer', function ($receiver, p1, p2, p3) {
        return $receiver.footer_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'popover-footer', PopoverComponent$footer$lambda$lambda_1)($receiver, PopoverComponent$footer$lambda$lambda_2(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.footer_p81yox$ = function (value) {
    this.footer_6jikth$_0 = PopoverComponent$footer$lambda_0(value);
  };
  function PopoverComponent$content$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.section);
    return Unit;
  }
  function PopoverComponent$content$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      closure$value($receiver);
      return Unit;
    };
  }
  function PopoverComponent$content$lambda(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('section', function ($receiver, p1, p2, p3) {
        return $receiver.section_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'popover-content', PopoverComponent$content$lambda$lambda)($receiver, PopoverComponent$content$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.content_izurti$ = function (value) {
    this.content_5mgsl7$_0 = PopoverComponent$content$lambda(value);
  };
  PopoverComponent.prototype.content_61zpoe$ = function (value) {
    this.content_p81yox$(flowOf(value));
  };
  function PopoverComponent$content$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.section);
    return Unit;
  }
  function PopoverComponent$content$lambda$lambda_2(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  function PopoverComponent$content$lambda_0(closure$value) {
    return function ($receiver) {
      styled(getCallableRef('section', function ($receiver, p1, p2, p3) {
        return $receiver.section_viepbn$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'popover-content', PopoverComponent$content$lambda$lambda_1)($receiver, PopoverComponent$content$lambda$lambda_2(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.content_p81yox$ = function (value) {
    this.content_5mgsl7$_0 = PopoverComponent$content$lambda_0(value);
  };
  function PopoverComponent$render$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.toggle = this.handle_7ib3lp$(void 0, PopoverComponent$render$ObjectLiteral$toggle$lambda);
    this.close = this.handleAndEmit_6gppb5$(void 0, PopoverComponent$render$ObjectLiteral$close$lambda);
    this.handledBy_ytah3h$(this.close, this.toggle);
  }
  function Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda.prototype.constructor = Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda;
  Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$ObjectLiteral$toggle$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$render$ObjectLiteral$toggle$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda($receiver_0, open_0, close_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$open = open_0;
    this.local$close = close_0;
  }
  Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda.prototype.constructor = Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda;
  Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$open && this.local$close) {
              this.state_0 = 2;
              this.result_0 = this.local$$receiver.emit_11rb$(Unit, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            return this.local$open;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$ObjectLiteral$close$lambda($receiver_0, open_0, close_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$render$ObjectLiteral$close$lambda($receiver_0, open_0, close_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  PopoverComponent$render$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  function Coroutine$PopoverComponent$render$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$PopoverComponent$render$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$lambda$lambda.prototype.constructor = Coroutine$PopoverComponent$render$lambda$lambda;
  Coroutine$PopoverComponent$render$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.keyCode === Keys.Escape.code;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$render$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function PopoverComponent$render$lambda$lambda_0($receiver) {
    return Unit;
  }
  function PopoverComponent$render$lambda$lambda_1($receiver) {
    return Unit;
  }
  function PopoverComponent$render$lambda$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.toggle);
    return Unit;
  }
  function Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function PopoverComponent$render$lambda$lambda$lambda_0(closure$popoverId, closure$clickStore, this$PopoverComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.attr_puj7f4$('data-popover-for', closure$popoverId);
      var $receiver_0 = $receiver.clicks.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_5(unsafeTransform$lambda_4(map$lambda_3(PopoverComponent$render$lambda$lambda$lambda$lambda), $receiver_0)), closure$clickStore.toggle);
      (tmp$ = this$PopoverComponent.toggle.value) != null ? tmp$($receiver) : null;
      return Unit;
    };
  }
  function PopoverComponent$render$lambda$lambda$lambda_1(this$PopoverComponent, closure$styling, closure$baseClass, closure$popoverId, closure$prefix, closure$clickStore) {
    return function ($receiver, it) {
      if (it) {
        this$PopoverComponent.renderPopover_c0w7o2$_0(closure$styling, closure$baseClass, closure$popoverId, closure$prefix, $receiver, closure$clickStore.toggle);
      }return Unit;
    };
  }
  function PopoverComponent$render$lambda$lambda$lambda_2(closure$popoverId) {
    return function ($receiver, it) {
      if (it) {
        try {
          document.getElementById(closure$popoverId).focus();
        } catch (e) {
          if (!Kotlin.isType(e, Exception))
            throw e;
        }
      }return Unit;
    };
  }
  function PopoverComponent$render$lambda$lambda_2(closure$popoverId, closure$clickStore, this$PopoverComponent, closure$styling, closure$baseClass, closure$prefix) {
    return function ($receiver) {
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, 'popover-toggle-' + closure$popoverId, 'popover-toggle', PopoverComponent$render$lambda$lambda$lambda)($receiver, PopoverComponent$render$lambda$lambda$lambda_0(closure$popoverId, closure$clickStore, this$PopoverComponent));
      $receiver.render_8vs4x2$(closure$clickStore.data, PopoverComponent$render$lambda$lambda$lambda_1(this$PopoverComponent, closure$styling, closure$baseClass, closure$popoverId, closure$prefix, closure$clickStore));
      $receiver.render_8vs4x2$(closure$clickStore.data, PopoverComponent$render$lambda$lambda$lambda_2(closure$popoverId));
      return Unit;
    };
  }
  PopoverComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var clickStore = new PopoverComponent$render$ObjectLiteral(false);
    var popoverId = id != null ? id : 'popover' + randomId();
    if (this.closeOnEscape.value) {
      var $receiver = dom.Window.keyups.events;
      context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_6(unsafeTransform$lambda_5(map$lambda_4(PopoverComponent$render$lambda$lambda), $receiver)), clickStore.close);
    }styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), PopoverComponent$render$lambda$lambda_0, PopoverComponent$Companion_getInstance().staticCss, null, prefix, PopoverComponent$render$lambda$lambda_1)(context, PopoverComponent$render$lambda$lambda_2(popoverId, clickStore, this, styling, baseClass, prefix));
    return Unit;
  };
  function PopoverComponent$renderPopover$lambda($receiver) {
    return Unit;
  }
  function PopoverComponent$renderPopover$lambda$lambda$lambda($receiver) {
    $receiver.css_61zpoe$('outline:none');
    return Unit;
  }
  function PopoverComponent$renderPopover$lambda$lambda(this$PopoverComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$PopoverComponent.placementStyle_nwfc3a$_0(Theme.Companion.invoke().popover.placement));
      $receiver.invoke_qkhqzy$(this$PopoverComponent.size.value(Theme.Companion.invoke().popover.size));
      $receiver.focus_xighi7$(PopoverComponent$renderPopover$lambda$lambda$lambda);
      return Unit;
    };
  }
  function Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.prototype.constructor = Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda;
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$renderPopover$lambda$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function PopoverComponent$renderPopover$lambda$lambda_0(this$PopoverComponent, closure$closeHandler) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.attr_puj7f4$('tabindex', '-1');
      if (this$PopoverComponent.hasArrow.value) {
        this$PopoverComponent.renderArrow_cpi9f0$_0($receiver);
      }if (this$PopoverComponent.hasCloseButton.value) {
        $receiver.handledBy_jora5j$(this$PopoverComponent.closeButtonRendering.value($receiver), closure$closeHandler);
      }(tmp$ = this$PopoverComponent.header_huufl5$_0) != null ? tmp$($receiver) : null;
      (tmp$_0 = this$PopoverComponent.content_5mgsl7$_0) != null ? tmp$_0($receiver) : null;
      (tmp$_1 = this$PopoverComponent.footer_6jikth$_0) != null ? tmp$_1($receiver) : null;
      if (this$PopoverComponent.closeOnBlur.value) {
        var $receiver_0 = debounce($receiver.blurs.events, L200);
        $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_5(unsafeTransform$lambda_4(map$lambda_3(PopoverComponent$renderPopover$lambda$lambda$lambda_0), $receiver_0)), closure$closeHandler);
      }return Unit;
    };
  }
  PopoverComponent.prototype.renderPopover_c0w7o2$_0 = function (styling, baseClass, id, prefix, RenderContext, closeHandler) {
    if (styling === void 0)
      styling = PopoverComponent$renderPopover$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'popover';
    styled_0(getCallableRef('section', function ($receiver, p1, p2, p3) {
      return $receiver.section_viepbn$(p1, p2, p3);
    }.bind(null, RenderContext)), styling, baseClass, id, prefix, PopoverComponent$renderPopover$lambda$lambda(this))(RenderContext, PopoverComponent$renderPopover$lambda$lambda_0(this, closeHandler));
  };
  function PopoverComponent$renderArrow$lambda$lambda(this$PopoverComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$PopoverComponent.arrowPlacement.value(Theme.Companion.invoke().popover.arrowPlacement));
      return Unit;
    };
  }
  function PopoverComponent$renderArrow$lambda$lambda_0($receiver) {
    return Unit;
  }
  PopoverComponent.prototype.renderArrow_cpi9f0$_0 = function (RenderContext) {
    styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, RenderContext)), void 0, void 0, 'popover-arrow', PopoverComponent$renderArrow$lambda$lambda(this))(RenderContext, PopoverComponent$renderArrow$lambda$lambda_0);
  };
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.hasCloseButton;
    }
  });
  function PopoverComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().popover.size.normal;
  }
  function PopoverComponent$placementStyle$lambda($receiver) {
    return Theme.Companion.invoke().popover.placement.top;
  }
  function PopoverComponent$arrowPlacement$lambda($receiver) {
    return Theme.Companion.invoke().popover.arrowPlacement.bottom;
  }
  PopoverComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PopoverComponent',
    interfaces: [CloseButtonProperty, Component]
  };
  function popover$lambda($receiver) {
    return Unit;
  }
  function popover$lambda_0($receiver) {
    return Unit;
  }
  function popover($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = popover$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'popover';
    if (build === void 0)
      build = popover$lambda_0;
    var $receiver_0 = new PopoverComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_7(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_7($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_7.prototype.constructor = Coroutine$collect_42ocv1$_7;
  Coroutine$collect_42ocv1$_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_7.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_7(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_7.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_6(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_6.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_6;
  Coroutine$unsafeTransform$lambda$lambda_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_6(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_6(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_6 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_6(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_5(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_5.prototype.constructor = Coroutine$map$lambda_5;
  Coroutine$map$lambda_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_5(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_5(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioComponent(store) {
    RadioComponent$Companion_getInstance();
    if (store === void 0)
      store = null;
    this.store = store;
    this.$delegate_3rlp1o$_0 = new EventMixin();
    this.$delegate_3rlp1o$_1 = new ElementMixin();
    this.$delegate_3rlp1o$_2 = new InputFormMixin();
    this.$delegate_3rlp1o$_3 = new SeverityMixin();
    this.size = new ComponentProperty(RadioComponent$size$lambda);
    this.label_9rpq8$_0 = null;
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().radio.label);
    this.selectedStyle = new ComponentProperty(Theme.Companion.invoke().radio.selected);
    this.selected = new DynamicComponentProperty(flowOf(false));
    this.groupName = new DynamicComponentProperty(flowOf(''));
  }
  function RadioComponent$Companion() {
    RadioComponent$Companion_instance = this;
    this.radioInputStaticCss = staticStyle_0('radioInput', '\n' + '            position: absolute;' + '\n' + '            height: 1px; ' + '\n' + '            width: 1px;' + '\n' + '            overflow: hidden;' + '\n' + '            clip: rect(1px 1px 1px 1px); /* IE6, IE7 */' + '\n' + '            clip: rect(1px, 1px, 1px, 1px);' + '\n' + '            outline: none;' + '\n' + '            &:focus{' + '\n' + '                outline: none;' + '\n' + '            }' + '\n' + '            &:focus + label::before {' + '\n' + '                box-shadow: 0 0 1px ' + Theme.Companion.invoke().colors.gray700 + ';' + '\n' + '            }' + '\n' + '            &:disabled + label {' + '\n' + '                color: ' + Theme.Companion.invoke().colors.disabled + ';' + '\n' + '                cursor: not-allowed;' + '\n' + '            }' + '\n' + '            &:disabled + label::before {' + '\n' + '                opacity: 0.3;' + '\n' + '                cursor: not-allowed;' + '\n' + '                boxShadow: none;' + '\n' + '                color: ' + Theme.Companion.invoke().colors.disabled + ';' + '\n' + '            }' + '\n' + '            ');
  }
  RadioComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RadioComponent$Companion_instance = null;
  function RadioComponent$Companion_getInstance() {
    if (RadioComponent$Companion_instance === null) {
      new RadioComponent$Companion();
    }return RadioComponent$Companion_instance;
  }
  function RadioComponent$label$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  RadioComponent.prototype.label_61zpoe$ = function (value) {
    this.label_9rpq8$_0 = RadioComponent$label$lambda(value);
  };
  function RadioComponent$label$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  RadioComponent.prototype.label_p81yox$ = function (value) {
    this.label_9rpq8$_0 = RadioComponent$label$lambda_0(value);
  };
  RadioComponent.prototype.label_wqyjv5$ = function (value) {
    this.label_9rpq8$_0 = value;
  };
  function Coroutine$RadioComponent$render$lambda(closure$alternativeGroupname_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$alternativeGroupname = closure$alternativeGroupname_0;
    this.local$it = it_0;
  }
  Coroutine$RadioComponent$render$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioComponent$render$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioComponent$render$lambda.prototype.constructor = Coroutine$RadioComponent$render$lambda;
  Coroutine$RadioComponent$render$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$it.length === 0) {
              return this.local$closure$alternativeGroupname != null ? this.local$closure$alternativeGroupname : '';
            } else {
              return this.local$it;
            }

          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioComponent$render$lambda(closure$alternativeGroupname_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioComponent$render$lambda(closure$alternativeGroupname_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioComponent$render$lambda$lambda(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$RadioComponent.size.value(Theme.Companion.invoke().radio.sizes));
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$RadioComponent.selectedStyle.value);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().radio.input);
      $receiver.children_qlrppv$('&[checked] + div', RadioComponent$render$lambda$lambda$lambda$lambda(this$RadioComponent));
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_0(this$RadioComponent, closure$inputName) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.disabled_f1igrw$(this$RadioComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$RadioComponent.readonly.values);
      $receiver.type_61zpoe$('radio');
      $receiver.name_p81yox$(closure$inputName);
      $receiver.checked_f1igrw$((tmp$_0 = (tmp$ = this$RadioComponent.store) != null ? tmp$.data : null) != null ? tmp$_0 : this$RadioComponent.selected.values);
      $receiver.value_61zpoe$('X');
      $receiver.className_p81yox$(get_name(this$RadioComponent.severityClassOf_i6436e$(Theme.Companion.invoke().radio.severity)));
      if ((tmp$_1 = this$RadioComponent.store) != null) {
        $receiver.handledBy_ytah3h$(states($receiver.changes), tmp$_1.update);
      }this$RadioComponent.events.value($receiver);
      this$RadioComponent.element.value($receiver);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_1(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().radio.default);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_2($receiver) {
    return Unit;
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda_0(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$RadioComponent.labelStyle.value);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda_1(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda_0(closure$inputId, closure$prefix, this$RadioComponent, closure$inputName, closure$styling) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      if (closure$inputId != null) {
        $receiver.for_61zpoe$(closure$inputId);
      }tmp$_1 = getCallableRef('input', function ($receiver, p1, p2, p3) {
        return $receiver.input_1ect6g$(p1, p2, p3);
      }.bind(null, $receiver));
      tmp$ = RadioComponent$Companion_getInstance().radioInputStaticCss;
      tmp$_0 = RadioComponent$render$lambda$lambda$lambda(this$RadioComponent);
      styled(tmp$_1, tmp$, closure$inputId, closure$prefix, tmp$_0)($receiver, RadioComponent$render$lambda$lambda$lambda_0(this$RadioComponent, closure$inputName));
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, RadioComponent$render$lambda$lambda$lambda_1(closure$styling))($receiver, RadioComponent$render$lambda$lambda$lambda_2);
      if ((tmp$_2 = this$RadioComponent.label_9rpq8$_0) != null) {
        var this$RadioComponent_0 = this$RadioComponent;
        styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
          return $receiver.div_hhcm6n$(p1, p2, p3);
        }.bind(null, $receiver)), void 0, void 0, void 0, RadioComponent$render$lambda$lambda$lambda$lambda_0(this$RadioComponent_0))($receiver, RadioComponent$render$lambda$lambda$lambda$lambda_1(tmp$_2));
      }return Unit;
    };
  }
  RadioComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var inputId = id != null ? id + '-input' : null;
    var alternativeGroupname = id != null ? id + '-groupName' : null;
    var $receiver = this.groupName.values;
    var inputName = new unsafeFlow$ObjectLiteral_7(unsafeTransform$lambda_6(map$lambda_5(RadioComponent$render$lambda(alternativeGroupname)), $receiver));
    return styled(getCallableRef('label', function ($receiver, p1, p2, p3) {
      return $receiver.label_6gkvle$(p1, p2, p3);
    }.bind(null, context)), baseClass, id, prefix, RadioComponent$render$lambda$lambda(this))(context, RadioComponent$render$lambda$lambda_0(inputId, prefix, this, inputName, styling));
  };
  Object.defineProperty(RadioComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_3rlp1o$_0.events;
    }
  });
  Object.defineProperty(RadioComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_3rlp1o$_1.element;
    }
  });
  Object.defineProperty(RadioComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_3rlp1o$_2.disabled;
    }
  });
  Object.defineProperty(RadioComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_3rlp1o$_2.readonly;
    }
  });
  RadioComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_3rlp1o$_2.enabled_6taknv$(value);
  };
  RadioComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_3rlp1o$_2.enabled_433wua$(value);
  };
  Object.defineProperty(RadioComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_3rlp1o$_3.severity;
    }
  });
  RadioComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_3rlp1o$_3.severity_9dec1s$(value);
  };
  RadioComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_3rlp1o$_3.severityClassOf_i6436e$(severityStyle);
  };
  function RadioComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().radio.sizes.normal;
  }
  RadioComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RadioComponent',
    interfaces: [SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function radio$lambda($receiver) {
    return Unit;
  }
  function radio$lambda_0($receiver) {
    return Unit;
  }
  function radio($receiver, styling, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = radio$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'radioComponent';
    if (build === void 0)
      build = radio$lambda_0;
    var $receiver_0 = new RadioComponent(store);
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_8(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_8($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_8.prototype.constructor = Coroutine$collect_42ocv1$_8;
  Coroutine$collect_42ocv1$_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_8.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_8(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_8.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_7(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_7.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_7;
  Coroutine$unsafeTransform$lambda$lambda_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_7(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_7(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_7 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_7(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_6(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_6.prototype.constructor = Coroutine$map$lambda_6;
  Coroutine$map$lambda_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_6(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_6(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent(items, store) {
    RadioGroupComponent$Companion_getInstance();
    if (store === void 0)
      store = null;
    this.items = items;
    this.store = store;
    this.$delegate_ftxl5l$_0 = new InputFormMixin();
    this.$delegate_ftxl5l$_1 = new SeverityMixin();
    this.label = new ComponentProperty(RadioGroupComponent$label$lambda);
    this.size = new ComponentProperty(RadioGroupComponent$size$lambda);
    this.direction = new ComponentProperty(RadioGroupComponent$direction$lambda);
    this.itemStyle = new ComponentProperty(Theme.Companion.invoke().radio.default);
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().radio.label);
    this.selectedStyle = new ComponentProperty(Theme.Companion.invoke().radio.selected);
    this.selectedItem = new NullableDynamicComponentProperty(emptyFlow());
    this.events = new ComponentProperty(RadioGroupComponent$events$lambda);
  }
  function RadioGroupComponent$Companion() {
    RadioGroupComponent$Companion_instance = this;
  }
  function RadioGroupComponent$Companion$RadioGroupLayouts() {
    RadioGroupComponent$Companion$RadioGroupLayouts_instance = this;
    this.column = RadioGroupComponent$Companion$RadioGroupLayouts$column$lambda;
    this.row = RadioGroupComponent$Companion$RadioGroupLayouts$row$lambda;
  }
  function RadioGroupComponent$Companion$RadioGroupLayouts$column$lambda$lambda($receiver) {
    return $receiver.inlineGrid;
  }
  function RadioGroupComponent$Companion$RadioGroupLayouts$column$lambda($receiver) {
    $receiver.display_1gh9wc$(RadioGroupComponent$Companion$RadioGroupLayouts$column$lambda$lambda);
    return Unit;
  }
  function RadioGroupComponent$Companion$RadioGroupLayouts$row$lambda$lambda($receiver) {
    return $receiver.inlineFlex;
  }
  function RadioGroupComponent$Companion$RadioGroupLayouts$row$lambda($receiver) {
    $receiver.display_1gh9wc$(RadioGroupComponent$Companion$RadioGroupLayouts$row$lambda$lambda);
    return Unit;
  }
  RadioGroupComponent$Companion$RadioGroupLayouts.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RadioGroupLayouts',
    interfaces: []
  };
  var RadioGroupComponent$Companion$RadioGroupLayouts_instance = null;
  function RadioGroupComponent$Companion$RadioGroupLayouts_getInstance() {
    if (RadioGroupComponent$Companion$RadioGroupLayouts_instance === null) {
      new RadioGroupComponent$Companion$RadioGroupLayouts();
    }return RadioGroupComponent$Companion$RadioGroupLayouts_instance;
  }
  RadioGroupComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RadioGroupComponent$Companion_instance = null;
  function RadioGroupComponent$Companion_getInstance() {
    if (RadioGroupComponent$Companion_instance === null) {
      new RadioGroupComponent$Companion();
    }return RadioGroupComponent$Companion_instance;
  }
  function RadioGroupComponent$EventsContext(selected) {
    this.selected = selected;
  }
  RadioGroupComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: []
  };
  function RadioGroupComponent$render$lambda$lambda(this$RadioGroupComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$RadioGroupComponent.direction.value(RadioGroupComponent$Companion$RadioGroupLayouts_getInstance()));
      return Unit;
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda(this$RadioGroupComponent_0, selectedItem_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$RadioGroupComponent = this$RadioGroupComponent_0;
    this.local$selectedItem = selectedItem_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var it = indexOf_0(this.local$this$RadioGroupComponent.items, this.local$selectedItem);
            return it === -1 ? null : it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda(this$RadioGroupComponent_0) {
    return function (selectedItem_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda(this$RadioGroupComponent_0, selectedItem_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$index = closure$index_0;
    this.local$it = it_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it === this.local$closure$index;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda(closure$index_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$RadioGroupComponent) {
    return function ($receiver) {
      return this$RadioGroupComponent.size.value(Theme.Companion.invoke().radio.sizes);
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$index = closure$index_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$index;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(closure$index, closure$internalStore) {
    return function ($receiver) {
      var $receiver_0 = states($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_8(unsafeTransform$lambda_7(map$lambda_6(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index)), $receiver_0)), closure$internalStore.toggle);
      return Unit;
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda_0(this$RadioGroupComponent, closure$item, closure$checkedFlow, closure$index, closure$internalStore) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$RadioGroupComponent));
      $receiver.labelStyle.invoke_11rb$(this$RadioGroupComponent.labelStyle.value);
      $receiver.selectedStyle.invoke_11rb$(this$RadioGroupComponent.selectedStyle.value);
      $receiver.label_61zpoe$(this$RadioGroupComponent.label.value(closure$item));
      $receiver.selected.invoke_ror2s8$(closure$checkedFlow);
      $receiver.disabled.invoke_ror2s8$(this$RadioGroupComponent.disabled.values);
      $receiver.severity.invoke_ror2s8$(this$RadioGroupComponent.severity.values);
      $receiver.events.invoke_11rb$(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(closure$index, closure$internalStore));
      return Unit;
    };
  }
  function RadioGroupComponent$render$lambda$lambda_0(this$RadioGroupComponent, closure$internalStore, closure$grpId) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      var $receiver_0 = (tmp$_0 = (tmp$ = this$RadioGroupComponent.store) != null ? tmp$.data : null) != null ? tmp$_0 : this$RadioGroupComponent.selectedItem.values;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_8(unsafeTransform$lambda_7(map$lambda_6(RadioGroupComponent$render$lambda$lambda$lambda(this$RadioGroupComponent)), $receiver_0)), closure$internalStore.update);
      var $receiver_1 = withIndex(this$RadioGroupComponent.items);
      var tmp$_1;
      tmp$_1 = $receiver_1.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        var closure$internalStore_0 = closure$internalStore;
        var this$RadioGroupComponent_0 = this$RadioGroupComponent;
        var closure$grpId_0 = closure$grpId;
        var index = element.component1()
        , item = element.component2();
        var $receiver_2 = closure$internalStore_0.data;
        var checkedFlow = distinctUntilChanged(new unsafeFlow$ObjectLiteral_8(unsafeTransform$lambda_7(map$lambda_6(RadioGroupComponent$render$lambda$lambda$lambda$lambda(index)), $receiver_2)));
        radio($receiver, this$RadioGroupComponent_0.itemStyle.value, void 0, void 0, closure$grpId_0 + '-grp-item-' + uniqueId(), void 0, RadioGroupComponent$render$lambda$lambda$lambda$lambda_0(this$RadioGroupComponent_0, item, checkedFlow, index, closure$internalStore_0));
      }
      return Unit;
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda(this$RadioGroupComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$RadioGroupComponent = this$RadioGroupComponent_0;
    this.local$it = it_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$RadioGroupComponent.items.get_za3lpa$(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda_1(this$RadioGroupComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda(this$RadioGroupComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  RadioGroupComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var internalStore = new SingleSelectionStore();
    var grpId = id != null ? id : uniqueId();
    styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass, id, prefix, RadioGroupComponent$render$lambda$lambda(this))(context, RadioGroupComponent$render$lambda$lambda_0(this, internalStore, grpId));
    var $receiver = internalStore.toggle;
    var $receiver_0 = new RadioGroupComponent$EventsContext(new unsafeFlow$ObjectLiteral_8(unsafeTransform$lambda_7(map$lambda_6(RadioGroupComponent$render$lambda$lambda_1(this)), $receiver)));
    var tmp$;
    this.events.value($receiver_0);
    if ((tmp$ = this.store) != null) {
      context.handledBy_ytah3h$($receiver_0.selected, tmp$.update);
    }return Unit;
  };
  Object.defineProperty(RadioGroupComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_ftxl5l$_0.disabled;
    }
  });
  Object.defineProperty(RadioGroupComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_ftxl5l$_0.readonly;
    }
  });
  RadioGroupComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_ftxl5l$_0.enabled_6taknv$(value);
  };
  RadioGroupComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_ftxl5l$_0.enabled_433wua$(value);
  };
  Object.defineProperty(RadioGroupComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_ftxl5l$_1.severity;
    }
  });
  RadioGroupComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_ftxl5l$_1.severity_9dec1s$(value);
  };
  RadioGroupComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_ftxl5l$_1.severityClassOf_i6436e$(severityStyle);
  };
  function RadioGroupComponent$label$lambda(it) {
    return toString(it);
  }
  function RadioGroupComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().radio.sizes.normal;
  }
  function RadioGroupComponent$direction$lambda($receiver) {
    return $receiver.column;
  }
  function RadioGroupComponent$events$lambda($receiver) {
    return Unit;
  }
  RadioGroupComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RadioGroupComponent',
    interfaces: [SeverityProperties, InputFormProperties, Component]
  };
  function radioGroup$lambda($receiver) {
    return Unit;
  }
  function radioGroup$lambda_0($receiver) {
    return Unit;
  }
  function radioGroup($receiver, styling, items, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = radioGroup$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'radioGroupComponent';
    if (build === void 0)
      build = radioGroup$lambda_0;
    var $receiver_0 = new RadioGroupComponent(items, store);
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_9(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_9($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_9.prototype.constructor = Coroutine$collect_42ocv1$_9;
  Coroutine$collect_42ocv1$_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_9.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_9(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_9.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_8(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_8.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_8;
  Coroutine$unsafeTransform$lambda$lambda_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_8(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_8(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_8 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_8(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_7(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_7.prototype.constructor = Coroutine$map$lambda_7;
  Coroutine$map$lambda_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_7(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_7(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent(items, store) {
    SelectFieldComponent$Companion_getInstance();
    if (store === void 0)
      store = null;
    this.items = items;
    this.store = store;
    this.$delegate_3yi00x$_0 = new InputFormMixin();
    this.$delegate_3yi00x$_1 = new SeverityMixin();
    this.basicSelectStyles = SelectFieldComponent$basicSelectStyles$lambda;
    this.iconWrapperStyle = SelectFieldComponent$iconWrapperStyle$lambda;
    this.iconStyle = SelectFieldComponent$iconStyle$lambda;
    this.placeholder = new ComponentProperty('...');
    this.variant = new ComponentProperty(SelectFieldComponent$variant$lambda);
    this.label = new ComponentProperty(SelectFieldComponent$label$lambda);
    this.size = new ComponentProperty(SelectFieldComponent$size$lambda);
    this.icon = new ComponentProperty(SelectFieldComponent$icon$lambda);
    this.selectedItem = new NullableDynamicComponentProperty(emptyFlow());
    this.events = new ComponentProperty(SelectFieldComponent$events$lambda);
  }
  function SelectFieldComponent$Companion() {
    SelectFieldComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('selectFieldContainer', '\n                  width: 100%;\n                  height: fit-content;\n                  position: relative;\n                  outline:none;\n                  appearance:none;\n              ');
  }
  SelectFieldComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SelectFieldComponent$Companion_instance = null;
  function SelectFieldComponent$Companion_getInstance() {
    if (SelectFieldComponent$Companion_instance === null) {
      new SelectFieldComponent$Companion();
    }return SelectFieldComponent$Companion_instance;
  }
  function SelectFieldComponent$EventsContext(selected) {
    this.selected = selected;
  }
  SelectFieldComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: []
  };
  function Coroutine$SelectFieldComponent$render$lambda$lambda(this$SelectFieldComponent_0, selectedItem_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$SelectFieldComponent = this$SelectFieldComponent_0;
    this.local$selectedItem = selectedItem_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var it = indexOf_0(this.local$this$SelectFieldComponent.items, this.local$selectedItem);
            return it === -1 ? null : it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda(this$SelectFieldComponent_0) {
    return function (selectedItem_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda(this$SelectFieldComponent_0, selectedItem_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent$render$lambda$lambda_0($receiver) {
    return Unit;
  }
  function SelectFieldComponent$render$lambda$lambda$lambda(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.basicSelectStyles);
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.variant.value(Theme.Companion.invoke().select.variants));
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.size.value(Theme.Companion.invoke().select.sizes));
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.value_61zpoe$('null');
      $receiver.selected_8kj6y5$(true);
      $receiver.unaryPlus_pdl1vz$(this$SelectFieldComponent.placeholder.value);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda(this$SelectFieldComponent) {
    return function ($receiver, it) {
      if (it == null) {
        $receiver.option_aupjj$(void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda(this$SelectFieldComponent));
      }return Unit;
    };
  }
  function Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$index = closure$index_0;
    this.local$it = it_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it === this.local$closure$index;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda_0(closure$index_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda_1(closure$index, closure$checkedFlow, this$SelectFieldComponent, closure$item) {
    return function ($receiver) {
      $receiver.value_61zpoe$(closure$index.toString());
      $receiver.selected_f1igrw$(closure$checkedFlow);
      $receiver.unaryPlus_pdl1vz$(this$SelectFieldComponent.label.value(closure$item));
      return Unit;
    };
  }
  function Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return toInt(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SelectFieldComponent$render$lambda$lambda$lambda_0(this$SelectFieldComponent, closure$internalStore) {
    return function ($receiver) {
      $receiver.disabled_f1igrw$(this$SelectFieldComponent.disabled.values);
      $receiver.render_8vs4x2$(closure$internalStore.data, SelectFieldComponent$render$lambda$lambda$lambda$lambda(this$SelectFieldComponent));
      var $receiver_0 = withIndex(this$SelectFieldComponent.items);
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var closure$internalStore_0 = closure$internalStore;
        var this$SelectFieldComponent_0 = this$SelectFieldComponent;
        var index = element.component1()
        , item = element.component2();
        var $receiver_1 = closure$internalStore_0.data;
        var checkedFlow = distinctUntilChanged(new unsafeFlow$ObjectLiteral_9(unsafeTransform$lambda_8(map$lambda_7(SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda_0(index)), $receiver_1)));
        $receiver.option_aupjj$(void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda_1(index, checkedFlow, this$SelectFieldComponent_0, item));
      }
      $receiver.className_p81yox$(get_name(this$SelectFieldComponent.severityClassOf_i6436e$(Theme.Companion.invoke().select.severity)));
      var $receiver_2 = selectedValue($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_9(unsafeTransform$lambda_8(map$lambda_7(SelectFieldComponent$render$lambda$lambda$lambda$lambda_0), $receiver_2)), closure$internalStore.toggle);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda_1(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.size.value(Theme.Companion.invoke().select.sizes));
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.iconWrapperStyle);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda_1(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.iconStyle);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda_2(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(this$SelectFieldComponent.icon.value(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda_2(this$SelectFieldComponent) {
    return function ($receiver) {
      icon($receiver, SelectFieldComponent$render$lambda$lambda$lambda$lambda_1(this$SelectFieldComponent), void 0, void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda$lambda_2(this$SelectFieldComponent));
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda_1(closure$styling, closure$baseClass, this$SelectFieldComponent, closure$internalStore) {
    return function ($receiver) {
      styled_0(getCallableRef('select', function ($receiver, p1, p2, p3) {
        return $receiver.select_5zw7hm$(p1, p2, p3);
      }.bind(null, $receiver)), closure$styling, closure$baseClass, void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda(this$SelectFieldComponent))($receiver, SelectFieldComponent$render$lambda$lambda$lambda_0(this$SelectFieldComponent, closure$internalStore));
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, 'icon-wrapper', SelectFieldComponent$render$lambda$lambda$lambda_1(this$SelectFieldComponent))($receiver, SelectFieldComponent$render$lambda$lambda$lambda_2(this$SelectFieldComponent));
      return Unit;
    };
  }
  function Coroutine$SelectFieldComponent$render$lambda$lambda_0(this$SelectFieldComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$SelectFieldComponent = this$SelectFieldComponent_0;
    this.local$it = it_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda_0.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda_0;
  Coroutine$SelectFieldComponent$render$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$SelectFieldComponent.items.get_za3lpa$(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda_2(this$SelectFieldComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda_0(this$SelectFieldComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  SelectFieldComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var internalStore = new SingleSelectionStore();
    var grpId = id != null ? id : uniqueId();
    var tmp$, tmp$_0;
    var $receiver = (tmp$_0 = (tmp$ = this.store) != null ? tmp$.data : null) != null ? tmp$_0 : this.selectedItem.values;
    context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_9(unsafeTransform$lambda_8(map$lambda_7(SelectFieldComponent$render$lambda$lambda(this)), $receiver)), internalStore.update);
    styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
      return $receiver.div_hhcm6n$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass.plus_fox8kt$(SelectFieldComponent$Companion_getInstance().staticCss), grpId, prefix, SelectFieldComponent$render$lambda$lambda_0)(context, SelectFieldComponent$render$lambda$lambda_1(styling, baseClass, this, internalStore));
    var $receiver_0 = internalStore.toggle;
    var $receiver_1 = new SelectFieldComponent$EventsContext(new unsafeFlow$ObjectLiteral_9(unsafeTransform$lambda_8(map$lambda_7(SelectFieldComponent$render$lambda$lambda_2(this)), $receiver_0)));
    var tmp$_1;
    this.events.value($receiver_1);
    if ((tmp$_1 = this.store) != null) {
      context.handledBy_ytah3h$($receiver_1.selected, tmp$_1.update);
    }return Unit;
  };
  Object.defineProperty(SelectFieldComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_3yi00x$_0.disabled;
    }
  });
  Object.defineProperty(SelectFieldComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_3yi00x$_0.readonly;
    }
  });
  SelectFieldComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_3yi00x$_0.enabled_6taknv$(value);
  };
  SelectFieldComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_3yi00x$_0.enabled_433wua$(value);
  };
  Object.defineProperty(SelectFieldComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_3yi00x$_1.severity;
    }
  });
  SelectFieldComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_3yi00x$_1.severity_9dec1s$(value);
  };
  SelectFieldComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_3yi00x$_1.severityClassOf_i6436e$(severityStyle);
  };
  function SelectFieldComponent$basicSelectStyles$lambda$lambda($receiver) {
    return $receiver.full;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda($receiver) {
    return '0.75rem';
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_0($receiver) {
    return '1.5rem';
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_1($receiver) {
    return '1px';
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_0($receiver) {
    $receiver.left_bcpvvc$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda);
    $receiver.right_bcpvvc$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_0);
    $receiver.bottom_bcpvvc$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_1);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_1($receiver) {
    return $receiver.normal;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_2($receiver) {
    return '1rem';
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_3($receiver) {
    return '2.5rem';
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_4($receiver) {
    return $receiver.normal;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.primary.base;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda($receiver) {
    $receiver.color_jl9ed9$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.outline;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_2($receiver) {
    $receiver.border_4a22k0$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda);
    $receiver.boxShadow_ihm9h8$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_5($receiver) {
    $receiver.focus_xighi7$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_2);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_1($receiver) {
    return $receiver.gray700;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_3($receiver) {
    $receiver.color_jl9ed9$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_6($receiver) {
    $receiver.border_4a22k0$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_3);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_2($receiver) {
    return $receiver.neutral;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_4($receiver) {
    $receiver.color_jl9ed9$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_2);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_5($receiver) {
    return $receiver.disabled;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.gray300;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_3($receiver) {
    $receiver.color_jl9ed9$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_6($receiver) {
    $receiver.border_4a22k0$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda$lambda_3);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_7($receiver) {
    $receiver.background_f5fcq6$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_4);
    $receiver.color_jl9ed9$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_5);
    $receiver.hover_xighi7$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_6);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_7($receiver) {
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_8($receiver) {
    $receiver.relative_dkjn9d$(SelectFieldComponent$basicSelectStyles$lambda$lambda$lambda_7);
    return Unit;
  }
  function SelectFieldComponent$basicSelectStyles$lambda$lambda_9($receiver) {
    return '2.5rem';
  }
  function SelectFieldComponent$basicSelectStyles$lambda($receiver) {
    $receiver.width_wpghq5$(SelectFieldComponent$basicSelectStyles$lambda$lambda);
    $receiver.paddings_ptb4s1$(SelectFieldComponent$basicSelectStyles$lambda$lambda_0);
    $receiver.lineHeight_bcpvvc$(SelectFieldComponent$basicSelectStyles$lambda$lambda_1);
    $receiver.fontSize_bcpvvc$(SelectFieldComponent$basicSelectStyles$lambda$lambda_2);
    $receiver.height_wpghq5$(SelectFieldComponent$basicSelectStyles$lambda$lambda_3);
    $receiver.radius_bcpvvc$(SelectFieldComponent$basicSelectStyles$lambda$lambda_4);
    $receiver.focus_xighi7$(SelectFieldComponent$basicSelectStyles$lambda$lambda_5);
    $receiver.hover_xighi7$(SelectFieldComponent$basicSelectStyles$lambda$lambda_6);
    $receiver.disabled_xighi7$(SelectFieldComponent$basicSelectStyles$lambda$lambda_7);
    $receiver.position_wp9r2r$(SelectFieldComponent$basicSelectStyles$lambda$lambda_8);
    $receiver.minWidth_wpghq5$(SelectFieldComponent$basicSelectStyles$lambda$lambda_9);
    $receiver.css_61zpoe$('outline: 0px;');
    $receiver.css_61zpoe$('appearance: none;');
    $receiver.css_61zpoe$('transition: all 0.2s ease 0s;');
    return Unit;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda$lambda($receiver) {
    $receiver.absolute_dkjn9d$(SelectFieldComponent$iconWrapperStyle$lambda$lambda$lambda);
    return Unit;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda$lambda_0($receiver) {
    return $receiver.inlineFlex;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda($receiver) {
    $receiver.position_wp9r2r$(SelectFieldComponent$iconWrapperStyle$lambda$lambda);
    $receiver.display_1gh9wc$(SelectFieldComponent$iconWrapperStyle$lambda$lambda_0);
    $receiver.css_61zpoe$('-webkit-box-align: center;');
    $receiver.css_61zpoe$('align-items: center;');
    $receiver.css_61zpoe$('-webkit-box-pack: center;');
    $receiver.css_61zpoe$('justify-content: center;');
    $receiver.css_61zpoe$('right: 0.5rem;');
    $receiver.css_61zpoe$('pointer-events: none;');
    $receiver.css_61zpoe$('top: 50%;');
    $receiver.css_61zpoe$('transform: translateY(-50%);');
    return Unit;
  }
  function SelectFieldComponent$iconStyle$lambda$lambda($receiver) {
    return 'var(--select-icon-size)';
  }
  function SelectFieldComponent$iconStyle$lambda($receiver) {
    $receiver.height_wpghq5$(SelectFieldComponent$iconStyle$lambda$lambda);
    return Unit;
  }
  function SelectFieldComponent$variant$lambda($receiver) {
    return $receiver.outline;
  }
  function SelectFieldComponent$label$lambda(it) {
    return toString(it);
  }
  function SelectFieldComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function SelectFieldComponent$icon$lambda($receiver) {
    return $receiver.chevronDown;
  }
  function SelectFieldComponent$events$lambda($receiver) {
    return Unit;
  }
  SelectFieldComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SelectFieldComponent',
    interfaces: [SeverityProperties, InputFormProperties, Component]
  };
  function selectField$lambda($receiver) {
    return Unit;
  }
  function selectField($receiver, styling, items, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = selectField$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'selectField';
    var $receiver_0 = new SelectFieldComponent(items, store);
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function SpinnerComponent() {
    SpinnerComponent$Companion_getInstance();
    this.$delegate_ixdsdm$_0 = new EventMixin();
    this.icon = new ComponentProperty(null);
    this.speed = new ComponentProperty('0.5s');
    this.thickness = new ComponentProperty(SpinnerComponent$thickness$lambda);
  }
  function SpinnerComponent$Companion() {
    SpinnerComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('spinner', ' \n            display: inline-block;\n            border-color: currentColor;\n            border-style: solid;\n            border-radius: 99999px;\n            border-bottom-color: transparent;\n            border-left-color: transparent;\n            color: currentColor;\n            \n            @keyframes loading {\n              to {transform: rotate(360deg);}\n            }            \n        ');
  }
  SpinnerComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SpinnerComponent$Companion_instance = null;
  function SpinnerComponent$Companion_getInstance() {
    if (SpinnerComponent$Companion_instance === null) {
      new SpinnerComponent$Companion();
    }return SpinnerComponent$Companion_instance;
  }
  function SpinnerComponent$render$lambda$lambda$lambda$lambda(this$SpinnerComponent) {
    return function ($receiver) {
      return this$SpinnerComponent.thickness.value(Theme.Companion.invoke().borderWidths);
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda(this$SpinnerComponent) {
    return function ($receiver) {
      $receiver.width_qwzhsr$(SpinnerComponent$render$lambda$lambda$lambda$lambda(this$SpinnerComponent));
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda_0($receiver) {
    return '1rem';
  }
  function SpinnerComponent$render$lambda$lambda$lambda_1($receiver) {
    return '1rem';
  }
  function SpinnerComponent$render$lambda$lambda(this$SpinnerComponent) {
    return function ($receiver) {
      $receiver.css_61zpoe$('animation: loading ' + this$SpinnerComponent.speed.value + ' linear infinite;');
      $receiver.border_4a22k0$(SpinnerComponent$render$lambda$lambda$lambda(this$SpinnerComponent));
      $receiver.width_wpghq5$(SpinnerComponent$render$lambda$lambda$lambda_0);
      $receiver.height_wpghq5$(SpinnerComponent$render$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda_0(this$SpinnerComponent) {
    return function ($receiver) {
      this$SpinnerComponent.events.value($receiver);
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda_2(this$SpinnerComponent, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.css_61zpoe$(trimIndent('\n' + '                @keyframes spinner {' + '\n' + '                  to {transform: rotate(360deg);}' + '\n' + '                }    ' + '\n' + '                animation: spinner ' + this$SpinnerComponent.speed.value + ' linear infinite;' + '\n' + '            '));
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda_3(this$SpinnerComponent) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(ensureNotNull(this$SpinnerComponent.icon.value)(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda_1(this$SpinnerComponent, closure$styling, closure$baseClass, closure$id, closure$prefix) {
    return function ($receiver) {
      icon($receiver, SpinnerComponent$render$lambda$lambda$lambda_2(this$SpinnerComponent, closure$styling), closure$baseClass, closure$id, closure$prefix, SpinnerComponent$render$lambda$lambda$lambda_3(this$SpinnerComponent));
      this$SpinnerComponent.events.value($receiver);
      return Unit;
    };
  }
  SpinnerComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    if (this.icon.value == null) {
      styled_0(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, context)), styling, baseClass.plus_fox8kt$(SpinnerComponent$Companion_getInstance().staticCss), id, prefix, SpinnerComponent$render$lambda$lambda(this))(context, SpinnerComponent$render$lambda$lambda_0(this));
    } else {
      context.div_hhcm6n$(void 0, void 0, SpinnerComponent$render$lambda$lambda_1(this, styling, baseClass, id, prefix));
    }
    return Unit;
  };
  Object.defineProperty(SpinnerComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_ixdsdm$_0.events;
    }
  });
  function SpinnerComponent$thickness$lambda($receiver) {
    return Theme.Companion.invoke().borderWidths.normal;
  }
  SpinnerComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SpinnerComponent',
    interfaces: [EventProperties, Component]
  };
  function spinner$lambda($receiver) {
    return Unit;
  }
  function spinner($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = spinner$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'spinner';
    var $receiver_0 = new SpinnerComponent();
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function StackComponent() {
    StackComponent$Companion_getInstance();
    this.$delegate_9jvcav$_0 = new EventMixin();
    this.reversed = new ComponentProperty(false);
    this.spacing = new ComponentProperty(StackComponent$spacing$lambda);
    this.items = new ComponentProperty(StackComponent$items$lambda);
  }
  function StackComponent$Companion() {
    StackComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('stack', 'align-items: flex-start;');
  }
  StackComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var StackComponent$Companion_instance = null;
  function StackComponent$Companion_getInstance() {
    if (StackComponent$Companion_instance === null) {
      new StackComponent$Companion();
    }return StackComponent$Companion_instance;
  }
  function StackComponent$render$lambda(this$StackComponent, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.invoke_5yoziz$(this$StackComponent.stackStyles);
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function StackComponent$render$lambda_0(this$StackComponent) {
    return function ($receiver) {
      this$StackComponent.items.value($receiver);
      this$StackComponent.events.value($receiver);
      return Unit;
    };
  }
  StackComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    return flexBox(context, StackComponent$render$lambda(this, styling), baseClass.plus_fox8kt$(StackComponent$Companion_getInstance().staticCss), id, prefix, StackComponent$render$lambda_0(this));
  };
  Object.defineProperty(StackComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_9jvcav$_0.events;
    }
  });
  function StackComponent$spacing$lambda($receiver) {
    return $receiver.normal;
  }
  function StackComponent$items$lambda($receiver) {
    return Unit;
  }
  StackComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StackComponent',
    interfaces: [EventProperties, Component]
  };
  function StackUpComponent() {
    StackComponent.call(this);
    this.stackStyles_s6uagi$_0 = StackUpComponent$stackStyles$lambda(this);
  }
  Object.defineProperty(StackUpComponent.prototype, 'stackStyles', {
    configurable: true,
    get: function () {
      return this.stackStyles_s6uagi$_0;
    }
  });
  function StackUpComponent$stackStyles$lambda$lambda($receiver) {
    return $receiver.columnReverse;
  }
  function StackUpComponent$stackStyles$lambda$lambda$lambda(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.bottom_bcpvvc$(this$StackUpComponent.spacing.value);
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda$lambda_0(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(StackUpComponent$stackStyles$lambda$lambda$lambda(this$StackUpComponent));
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda$lambda_1($receiver) {
    return $receiver.column;
  }
  function StackUpComponent$stackStyles$lambda$lambda$lambda_0(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.top_bcpvvc$(this$StackUpComponent.spacing.value);
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda$lambda_2(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(StackUpComponent$stackStyles$lambda$lambda$lambda_0(this$StackUpComponent));
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda(this$StackUpComponent) {
    return function ($receiver) {
      if (this$StackUpComponent.reversed.value) {
        $receiver.direction_la6ffj$(StackUpComponent$stackStyles$lambda$lambda);
        $receiver.children_qlrppv$(' > :not(:first-child)', StackUpComponent$stackStyles$lambda$lambda_0(this$StackUpComponent));
      } else {
        $receiver.direction_la6ffj$(StackUpComponent$stackStyles$lambda$lambda_1);
        $receiver.children_qlrppv$(' > :not(:first-child)', StackUpComponent$stackStyles$lambda$lambda_2(this$StackUpComponent));
      }
      return Unit;
    };
  }
  StackUpComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StackUpComponent',
    interfaces: [StackComponent]
  };
  function stackUp$lambda($receiver) {
    return Unit;
  }
  function stackUp$lambda_0($receiver) {
    return Unit;
  }
  function stackUp($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = stackUp$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'stack-up';
    if (build === void 0)
      build = stackUp$lambda_0;
    var $receiver_0 = new StackUpComponent();
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function LineUpComponent() {
    StackComponent.call(this);
    this.stackStyles_chw0zi$_0 = LineUpComponent$stackStyles$lambda(this);
  }
  Object.defineProperty(LineUpComponent.prototype, 'stackStyles', {
    configurable: true,
    get: function () {
      return this.stackStyles_chw0zi$_0;
    }
  });
  function LineUpComponent$stackStyles$lambda$lambda($receiver) {
    return $receiver.rowReverse;
  }
  function LineUpComponent$stackStyles$lambda$lambda$lambda(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.right_bcpvvc$(this$LineUpComponent.spacing.value);
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda$lambda_0(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(LineUpComponent$stackStyles$lambda$lambda$lambda(this$LineUpComponent));
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda$lambda_1($receiver) {
    return $receiver.row;
  }
  function LineUpComponent$stackStyles$lambda$lambda$lambda_0(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(this$LineUpComponent.spacing.value);
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda$lambda_2(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(LineUpComponent$stackStyles$lambda$lambda$lambda_0(this$LineUpComponent));
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda(this$LineUpComponent) {
    return function ($receiver) {
      if (this$LineUpComponent.reversed.value) {
        $receiver.direction_la6ffj$(LineUpComponent$stackStyles$lambda$lambda);
        $receiver.children_qlrppv$(' > :not(:first-child)', LineUpComponent$stackStyles$lambda$lambda_0(this$LineUpComponent));
      } else {
        $receiver.direction_la6ffj$(LineUpComponent$stackStyles$lambda$lambda_1);
        $receiver.children_qlrppv$(' > :not(:first-child)', LineUpComponent$stackStyles$lambda$lambda_2(this$LineUpComponent));
      }
      return Unit;
    };
  }
  LineUpComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineUpComponent',
    interfaces: [StackComponent]
  };
  function lineUp$lambda($receiver) {
    return Unit;
  }
  function lineUp$lambda_0($receiver) {
    return Unit;
  }
  function lineUp($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = lineUp$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'line-up';
    if (build === void 0)
      build = lineUp$lambda_0;
    var $receiver_0 = new LineUpComponent();
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function SwitchComponent(store) {
    SwitchComponent$Companion_getInstance();
    if (store === void 0)
      store = null;
    this.store = store;
    this.$delegate_alxqrb$_0 = new EventMixin();
    this.$delegate_alxqrb$_1 = new ElementMixin();
    this.$delegate_alxqrb$_2 = new InputFormMixin();
    this.$delegate_alxqrb$_3 = new SeverityMixin();
    this.size = new ComponentProperty(SwitchComponent$size$lambda);
    this.label_r8sqhv$_0 = null;
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().switch.label);
    this.dotStyle = new ComponentProperty(SwitchComponent$dotStyle$lambda);
    this.checkedStyle = new ComponentProperty(Theme.Companion.invoke().switch.checked);
    this.checked = new DynamicComponentProperty(flowOf(false));
  }
  function SwitchComponent$Companion() {
    SwitchComponent$Companion_instance = this;
    this.switchInputStaticCss = staticStyle_0('switch', '\n            position: absolute;\n            height: 1px;                \n            width: 1px;                \n            overflow: hidden;\n            clip: rect(1px 1px 1px 1px); /* IE6, IE7 */\n            clip: rect(1px, 1px, 1px, 1px);\n            outline: none;           \n            &:focus{\n                outline: none;\n            }           \n            ');
  }
  SwitchComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SwitchComponent$Companion_instance = null;
  function SwitchComponent$Companion_getInstance() {
    if (SwitchComponent$Companion_instance === null) {
      new SwitchComponent$Companion();
    }return SwitchComponent$Companion_instance;
  }
  function SwitchComponent$label$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  SwitchComponent.prototype.label_61zpoe$ = function (value) {
    this.label_r8sqhv$_0 = SwitchComponent$label$lambda(value);
  };
  function SwitchComponent$label$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.asText_lg9ri$(closure$value);
      return Unit;
    };
  }
  SwitchComponent.prototype.label_p81yox$ = function (value) {
    this.label_r8sqhv$_0 = SwitchComponent$label$lambda_0(value);
  };
  SwitchComponent.prototype.label_wqyjv5$ = function (value) {
    this.label_r8sqhv$_0 = value;
  };
  function SwitchComponent$render$lambda$lambda(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SwitchComponent.size.value(Theme.Companion.invoke().switch.sizes));
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SwitchComponent.checkedStyle.value);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().switch.input);
      $receiver.children_qlrppv$('&[checked] + div', SwitchComponent$render$lambda$lambda$lambda$lambda(this$SwitchComponent));
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda_0(this$SwitchComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.disabled_f1igrw$(this$SwitchComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$SwitchComponent.readonly.values);
      $receiver.type_61zpoe$('checkbox');
      $receiver.checked_f1igrw$((tmp$_0 = (tmp$ = this$SwitchComponent.store) != null ? tmp$.data : null) != null ? tmp$_0 : this$SwitchComponent.checked.values);
      this$SwitchComponent.events.value($receiver);
      if ((tmp$_1 = this$SwitchComponent.store) != null) {
        $receiver.handledBy_ytah3h$(states($receiver.changes), tmp$_1.update);
      }$receiver.className_p81yox$(get_name(this$SwitchComponent.severityClassOf_i6436e$(Theme.Companion.invoke().switch.severity)));
      this$SwitchComponent.element.value($receiver);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda_1(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().switch.default);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_0(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().switch.dot);
      $receiver.invoke_qkhqzy$(this$SwitchComponent.dotStyle.value);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_1($receiver) {
    return Unit;
  }
  function SwitchComponent$render$lambda$lambda$lambda_2(this$SwitchComponent) {
    return function ($receiver) {
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, SwitchComponent$render$lambda$lambda$lambda$lambda_0(this$SwitchComponent))($receiver, SwitchComponent$render$lambda$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_2(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SwitchComponent.labelStyle.value);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_3(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda_0(closure$inputId, closure$prefix, this$SwitchComponent, closure$styling) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      $receiver.for_61zpoe$(closure$inputId);
      tmp$_1 = getCallableRef('input', function ($receiver, p1, p2, p3) {
        return $receiver.input_1ect6g$(p1, p2, p3);
      }.bind(null, $receiver));
      tmp$ = SwitchComponent$Companion_getInstance().switchInputStaticCss;
      tmp$_0 = SwitchComponent$render$lambda$lambda$lambda(this$SwitchComponent);
      styled(tmp$_1, tmp$, closure$inputId, closure$prefix, tmp$_0)($receiver, SwitchComponent$render$lambda$lambda$lambda_0(this$SwitchComponent));
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, SwitchComponent$render$lambda$lambda$lambda_1(closure$styling))($receiver, SwitchComponent$render$lambda$lambda$lambda_2(this$SwitchComponent));
      if ((tmp$_2 = this$SwitchComponent.label_r8sqhv$_0) != null) {
        var this$SwitchComponent_0 = this$SwitchComponent;
        styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
          return $receiver.div_hhcm6n$(p1, p2, p3);
        }.bind(null, $receiver)), void 0, void 0, void 0, SwitchComponent$render$lambda$lambda$lambda$lambda_2(this$SwitchComponent_0))($receiver, SwitchComponent$render$lambda$lambda$lambda$lambda_3(tmp$_2));
      }return Unit;
    };
  }
  SwitchComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var inputId = (id != null ? id : uniqueId()) + '-input';
    return styled(getCallableRef('label', function ($receiver, p1, p2, p3) {
      return $receiver.label_6gkvle$(p1, p2, p3);
    }.bind(null, context)), baseClass, id, prefix, SwitchComponent$render$lambda$lambda(this))(context, SwitchComponent$render$lambda$lambda_0(inputId, prefix, this, styling));
  };
  Object.defineProperty(SwitchComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_alxqrb$_0.events;
    }
  });
  Object.defineProperty(SwitchComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_alxqrb$_1.element;
    }
  });
  Object.defineProperty(SwitchComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_alxqrb$_2.disabled;
    }
  });
  Object.defineProperty(SwitchComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_alxqrb$_2.readonly;
    }
  });
  SwitchComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_alxqrb$_2.enabled_6taknv$(value);
  };
  SwitchComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_alxqrb$_2.enabled_433wua$(value);
  };
  Object.defineProperty(SwitchComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_alxqrb$_3.severity;
    }
  });
  SwitchComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_alxqrb$_3.severity_9dec1s$(value);
  };
  SwitchComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_alxqrb$_3.severityClassOf_i6436e$(severityStyle);
  };
  function SwitchComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().switch.sizes.normal;
  }
  function SwitchComponent$dotStyle$lambda($receiver) {
    return Unit;
  }
  SwitchComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SwitchComponent',
    interfaces: [SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function switch$lambda($receiver) {
    return Unit;
  }
  function switch$lambda_0($receiver) {
    return Unit;
  }
  function switch_0($receiver, styling, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = switch$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'switchComponent';
    if (build === void 0)
      build = switch$lambda_0;
    var $receiver_0 = new SwitchComponent(store);
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function TextAreaComponent(store) {
    TextAreaComponent$Companion_getInstance();
    if (store === void 0)
      store = null;
    this.store = store;
    this.$delegate_bvvmc1$_0 = new EventMixin();
    this.$delegate_bvvmc1$_1 = new ElementMixin();
    this.$delegate_bvvmc1$_2 = new InputFormMixin();
    this.$delegate_bvvmc1$_3 = new SeverityMixin();
    this.basicInputStyles = TextAreaComponent$basicInputStyles$lambda;
    this.value = new DynamicComponentProperty(flowOf(''));
    this.placeholder = new DynamicComponentProperty(flowOf(''));
    this.resizeBehavior = new ComponentProperty(TextAreaComponent$resizeBehavior$lambda);
    this.size = new ComponentProperty(TextAreaComponent$size$lambda);
  }
  function TextAreaComponent$Companion() {
    TextAreaComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('textAreaContainer', '\n            outline: 0px;\n            position: relative;\n            appearance: none;\n            transition: all 0.2s ease 0s;\n            min-height: 80px;\n            \n            ');
  }
  TextAreaComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextAreaComponent$Companion_instance = null;
  function TextAreaComponent$Companion_getInstance() {
    if (TextAreaComponent$Companion_instance === null) {
      new TextAreaComponent$Companion();
    }return TextAreaComponent$Companion_instance;
  }
  function TextAreaComponent$render$lambda$lambda(this$TextAreaComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$TextAreaComponent.resizeBehavior.value(Theme.Companion.invoke().textArea.resize));
      $receiver.invoke_qkhqzy$(this$TextAreaComponent.size.value(Theme.Companion.invoke().textArea.sizes));
      $receiver.invoke_qkhqzy$(this$TextAreaComponent.basicInputStyles);
      return Unit;
    };
  }
  function TextAreaComponent$render$lambda$lambda_0(this$TextAreaComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.disabled_f1igrw$(this$TextAreaComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$TextAreaComponent.readonly.values);
      $receiver.placeholder_p81yox$(this$TextAreaComponent.placeholder.values);
      $receiver.value_p81yox$(this$TextAreaComponent.value.values);
      $receiver.className_p81yox$(get_name(this$TextAreaComponent.severityClassOf_i6436e$(Theme.Companion.invoke().textArea.severity)));
      if ((tmp$ = this$TextAreaComponent.store) != null) {
        $receiver.value_p81yox$(tmp$.data);
        $receiver.handledBy_ytah3h$(values_0($receiver.changes), tmp$.update);
      }this$TextAreaComponent.events.value($receiver);
      this$TextAreaComponent.element.value($receiver);
      return Unit;
    };
  }
  TextAreaComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    styled_0(getCallableRef('textarea', function ($receiver, p1, p2, p3) {
      return $receiver.textarea_kixj78$(p1, p2, p3);
    }.bind(null, context)), styling, baseClass.plus_fox8kt$(TextAreaComponent$Companion_getInstance().staticCss), id, prefix, TextAreaComponent$render$lambda$lambda(this))(context, TextAreaComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  Object.defineProperty(TextAreaComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_bvvmc1$_0.events;
    }
  });
  Object.defineProperty(TextAreaComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_bvvmc1$_1.element;
    }
  });
  Object.defineProperty(TextAreaComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_bvvmc1$_2.disabled;
    }
  });
  Object.defineProperty(TextAreaComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_bvvmc1$_2.readonly;
    }
  });
  TextAreaComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_bvvmc1$_2.enabled_6taknv$(value);
  };
  TextAreaComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_bvvmc1$_2.enabled_433wua$(value);
  };
  Object.defineProperty(TextAreaComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_bvvmc1$_3.severity;
    }
  });
  TextAreaComponent.prototype.severity_9dec1s$ = function (value) {
    return this.$delegate_bvvmc1$_3.severity_9dec1s$(value);
  };
  TextAreaComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_bvvmc1$_3.severityClassOf_i6436e$(severityStyle);
  };
  function TextAreaComponent$basicInputStyles$lambda$lambda($receiver) {
    return $receiver.normal;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda_0($receiver) {
    return $receiver.normal;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda($receiver) {
    return $receiver.thin;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_0($receiver) {
    return $receiver.solid;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_1($receiver) {
    return $receiver.gray300;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda_1($receiver) {
    $receiver.width_qwzhsr$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda);
    $receiver.style_hw5xj$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_0);
    $receiver.color_jl9ed9$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_1);
    return Unit;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_2($receiver) {
    return 'white';
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda_2($receiver) {
    $receiver.color_jl9ed9$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_2);
    return Unit;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.neutral;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_3($receiver) {
    $receiver.color_jl9ed9$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_4($receiver) {
    return $receiver.disabled;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda_3($receiver) {
    $receiver.background_f5fcq6$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_3);
    $receiver.color_jl9ed9$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_4);
    return Unit;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda$lambda_0($receiver) {
    return '#3182ce';
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_5($receiver) {
    $receiver.color_jl9ed9$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda$lambda_6($receiver) {
    return $receiver.outline;
  }
  function TextAreaComponent$basicInputStyles$lambda$lambda_4($receiver) {
    $receiver.border_4a22k0$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_5);
    $receiver.boxShadow_ihm9h8$(TextAreaComponent$basicInputStyles$lambda$lambda$lambda_6);
    return Unit;
  }
  function TextAreaComponent$basicInputStyles$lambda($receiver) {
    $receiver.radius_bcpvvc$(TextAreaComponent$basicInputStyles$lambda$lambda);
    $receiver.fontWeight_wyjwgc$(TextAreaComponent$basicInputStyles$lambda$lambda_0);
    $receiver.border_4a22k0$(TextAreaComponent$basicInputStyles$lambda$lambda_1);
    $receiver.background_f5fcq6$(TextAreaComponent$basicInputStyles$lambda$lambda_2);
    $receiver.disabled_xighi7$(TextAreaComponent$basicInputStyles$lambda$lambda_3);
    $receiver.focus_xighi7$(TextAreaComponent$basicInputStyles$lambda$lambda_4);
    return Unit;
  }
  function TextAreaComponent$resizeBehavior$lambda($receiver) {
    return Theme.Companion.invoke().textArea.resize.both;
  }
  function TextAreaComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().textArea.sizes.normal;
  }
  TextAreaComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextAreaComponent',
    interfaces: [SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function textArea$lambda($receiver) {
    return Unit;
  }
  function textArea($receiver, styling, store, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = textArea$lambda;
    if (store === void 0)
      store = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'textArea';
    var $receiver_0 = new TextAreaComponent(store);
    build($receiver_0);
    $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_10(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_10($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_10.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_10.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_10.prototype.constructor = Coroutine$collect_42ocv1$_10;
  Coroutine$collect_42ocv1$_10.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_10.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_10(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_10.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_9(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_9.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_9;
  Coroutine$unsafeTransform$lambda$lambda_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_9(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_9(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_9 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_9(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_8(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_8.prototype.constructor = Coroutine$map$lambda_8;
  Coroutine$map$lambda_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_8(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_8(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_11(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_11($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_11.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_11.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_11.prototype.constructor = Coroutine$collect_42ocv1$_11;
  Coroutine$collect_42ocv1$_11.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_11.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_11(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_11.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow_0]};
  function Coroutine$unsafeTransform$lambda$lambda_10(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_10.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_10.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_10.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_10;
  Coroutine$unsafeTransform$lambda$lambda_10.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_10(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_10(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda_10 = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$fritz2_core_jsLegacy.$$importsForInline$$['kotlinx-coroutines-core'].kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda_10(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$map$lambda_9(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_9.prototype.constructor = Coroutine$map$lambda_9;
  Coroutine$map$lambda_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_9(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_9(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ToastComponent() {
    ToastComponent$Companion_getInstance();
    this.$delegate_hxcwug$_0 = new CloseButtonMixin('toast-close-button', Theme.Companion.invoke().toast.closeButton.close);
    this.content = new ComponentProperty(null);
    this.placement = new ComponentProperty(ToastComponent$placement$lambda);
    this.duration = new ComponentProperty(L5000);
    this.background = new ComponentProperty(ToastComponent$background$lambda);
  }
  function ToastComponent$ToastFragment(id, placement, render) {
    this.id = id;
    this.placement = placement;
    this.render = render;
  }
  ToastComponent$ToastFragment.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ToastFragment',
    interfaces: []
  };
  ToastComponent$ToastFragment.prototype.component1 = function () {
    return this.id;
  };
  ToastComponent$ToastFragment.prototype.component2 = function () {
    return this.placement;
  };
  ToastComponent$ToastFragment.prototype.component3 = function () {
    return this.render;
  };
  ToastComponent$ToastFragment.prototype.copy_pt40hj$ = function (id, placement, render) {
    return new ToastComponent$ToastFragment(id === void 0 ? this.id : id, placement === void 0 ? this.placement : placement, render === void 0 ? this.render : render);
  };
  ToastComponent$ToastFragment.prototype.toString = function () {
    return 'ToastFragment(id=' + Kotlin.toString(this.id) + (', placement=' + Kotlin.toString(this.placement)) + (', render=' + Kotlin.toString(this.render)) + ')';
  };
  ToastComponent$ToastFragment.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.placement) | 0;
    result = result * 31 + Kotlin.hashCode(this.render) | 0;
    return result;
  };
  ToastComponent$ToastFragment.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.placement, other.placement) && Kotlin.equals(this.render, other.render)))));
  };
  function ToastComponent$Placement() {
    ToastComponent$Placement_instance = this;
    this.bottom = 'bottom';
    this.bottomLeft = 'bottomLeft';
    this.bottomRight = 'bottomRight';
    this.top = 'top';
    this.topLeft = 'topLeft';
    this.topRight = 'topRight';
    this.placements = listOf_0([this.bottom, this.bottomLeft, this.bottomRight, this.top, this.topLeft, this.topRight]);
  }
  ToastComponent$Placement.prototype.appearsFromBottom_55u87a$ = function (toasts) {
    return !toasts.isEmpty() && setOf([this.bottom, this.bottomRight, this.bottomLeft]).contains_11rb$(first(toasts).placement);
  };
  ToastComponent$Placement.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Placement',
    interfaces: []
  };
  var ToastComponent$Placement_instance = null;
  function ToastComponent$Placement_getInstance() {
    if (ToastComponent$Placement_instance === null) {
      new ToastComponent$Placement();
    }return ToastComponent$Placement_instance;
  }
  function ToastComponent$ToastStore() {
    ToastComponent$ToastStore_instance = this;
    RootStore.call(this, emptyList(), 'toast-store');
    this.add = this.handle_ajdi87$(void 0, ToastComponent$ToastStore$add$lambda);
    this.remove = this.handle_ajdi87$(void 0, ToastComponent$ToastStore$remove$lambda);
    this.removeAll = this.handle_7ib3lp$(void 0, ToastComponent$ToastStore$removeAll$lambda);
    this.removeLast = this.handle_7ib3lp$(void 0, ToastComponent$ToastStore$removeLast$lambda);
  }
  function Coroutine$ToastComponent$ToastStore$add$lambda(allToasts_0, newToast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$allToasts = allToasts_0;
    this.local$newToast = newToast_0;
  }
  Coroutine$ToastComponent$ToastStore$add$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$ToastStore$add$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$ToastStore$add$lambda.prototype.constructor = Coroutine$ToastComponent$ToastStore$add$lambda;
  Coroutine$ToastComponent$ToastStore$add$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return plus(this.local$allToasts, this.local$newToast);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$ToastStore$add$lambda(allToasts_0, newToast_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$ToastStore$add$lambda(allToasts_0, newToast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ToastComponent$ToastStore$remove$lambda(allToasts_0, toastId_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$allToasts = allToasts_0;
    this.local$toastId = toastId_0;
  }
  Coroutine$ToastComponent$ToastStore$remove$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$ToastStore$remove$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$ToastStore$remove$lambda.prototype.constructor = Coroutine$ToastComponent$ToastStore$remove$lambda;
  Coroutine$ToastComponent$ToastStore$remove$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            var firstOrNull$result;
            firstOrNull$break: do {
              var tmp$_1;
              tmp$_1 = this.local$allToasts.iterator();
              while (tmp$_1.hasNext()) {
                var element = tmp$_1.next();
                if (equals(element.id, this.local$toastId)) {
                  firstOrNull$result = element;
                  break firstOrNull$break;
                }}
              firstOrNull$result = null;
            }
             while (false);
            return (tmp$_0 = (tmp$ = firstOrNull$result) != null ? minus(this.local$allToasts, tmp$) : null) != null ? tmp$_0 : this.local$allToasts;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$ToastStore$remove$lambda(allToasts_0, toastId_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$ToastStore$remove$lambda(allToasts_0, toastId_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ToastComponent$ToastStore$removeAll$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ToastComponent$ToastStore$removeAll$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$ToastStore$removeAll$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$ToastStore$removeAll$lambda.prototype.constructor = Coroutine$ToastComponent$ToastStore$removeAll$lambda;
  Coroutine$ToastComponent$ToastStore$removeAll$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return emptyList();
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$ToastStore$removeAll$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$ToastStore$removeAll$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ToastComponent$ToastStore$removeLast$lambda(allToasts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$allToasts = allToasts_0;
  }
  Coroutine$ToastComponent$ToastStore$removeLast$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$ToastStore$removeLast$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$ToastStore$removeLast$lambda.prototype.constructor = Coroutine$ToastComponent$ToastStore$removeLast$lambda;
  Coroutine$ToastComponent$ToastStore$removeLast$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return dropLast(this.local$allToasts, 1);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$ToastStore$removeLast$lambda(allToasts_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$ToastStore$removeLast$lambda(allToasts_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ToastComponent$ToastStore.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ToastStore',
    interfaces: [RootStore]
  };
  var ToastComponent$ToastStore_instance = null;
  function ToastComponent$ToastStore_getInstance() {
    if (ToastComponent$ToastStore_instance === null) {
      new ToastComponent$ToastStore();
    }return ToastComponent$ToastStore_instance;
  }
  function ToastComponent$Companion() {
    ToastComponent$Companion_instance = this;
    this.toastContainerStaticCss_0 = staticStyle_0('toastContainer', '\n               position: fixed; \n               z-index: 5500;\n               pointer-events: none;\n               display: flex;\n               flex-direction: column;\n           \n               ');
    this.listStyle_0 = ToastComponent$Companion$listStyle$lambda;
    this.toastStyle_0 = ToastComponent$Companion$toastStyle$lambda;
    this.job_0 = Job();
    this.globalId_0 = 'f2c-modals-' + randomId();
    this.defaultToastContainerPrefix = 'ul-toast-container';
    var $receiver = ManagedComponent$Companion_getInstance().managedRenderContext_ue0xbo$(this.globalId_0, this.job_0);
    var tmp$;
    tmp$ = ToastComponent$Placement_getInstance().placements.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      switch (element) {
        case 'bottom':
          tmp$_0 = Theme.Companion.invoke().toast.placement.bottom;
          break;
        case 'bottomLeft':
          tmp$_0 = Theme.Companion.invoke().toast.placement.bottomLeft;
          break;
        case 'bottomRight':
          tmp$_0 = Theme.Companion.invoke().toast.placement.bottomRight;
          break;
        case 'top':
          tmp$_0 = Theme.Companion.invoke().toast.placement.top;
          break;
        case 'topLeft':
          tmp$_0 = Theme.Companion.invoke().toast.placement.topLeft;
          break;
        case 'topRight':
          tmp$_0 = Theme.Companion.invoke().toast.placement.topRight;
          break;
        default:tmp$_0 = Theme.Companion.invoke().toast.placement.bottom;
          break;
      }
      var placementStyle = tmp$_0;
      styled(getCallableRef('ul', function ($receiver, p1, p2, p3) {
        return $receiver.ul_k18lm9$(p1, p2, p3);
      }.bind(null, $receiver)), this.toastContainerStaticCss_0, uniqueId(), this.defaultToastContainerPrefix, ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda(placementStyle))($receiver, ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda_0(element));
    }
  }
  function ToastComponent$Companion$closeAllToasts$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.closeAll = this.handle_7ib3lp$(void 0, ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda);
  }
  function Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda.prototype.constructor = Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda;
  Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            ToastComponent$ToastStore_getInstance().removeAll.invoke();
            return this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$Companion$closeAllToasts$ObjectLiteral$closeAll$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ToastComponent$Companion$closeAllToasts$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  ToastComponent$Companion.prototype.closeAllToasts = function () {
    var store = new ToastComponent$Companion$closeAllToasts$ObjectLiteral('');
    return store.closeAll;
  };
  function ToastComponent$Companion$closeLastToast$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.closeLatest = this.handle_7ib3lp$(void 0, ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda);
  }
  function Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda.prototype.constructor = Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda;
  Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            ToastComponent$ToastStore_getInstance().removeLast.invoke();
            return this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$Companion$closeLastToast$ObjectLiteral$closeLatest$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ToastComponent$Companion$closeLastToast$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  ToastComponent$Companion.prototype.closeLastToast = function () {
    var store = new ToastComponent$Companion$closeLastToast$ObjectLiteral('');
    return store.closeLatest;
  };
  function ToastComponent$Companion$listStyle$lambda$lambda($receiver) {
    return $receiver.flex;
  }
  function ToastComponent$Companion$listStyle$lambda$lambda_0($receiver) {
    return '1';
  }
  function ToastComponent$Companion$listStyle$lambda$lambda_1($receiver) {
    return $receiver.auto;
  }
  function ToastComponent$Companion$listStyle$lambda($receiver) {
    $receiver.display_1gh9wc$(ToastComponent$Companion$listStyle$lambda$lambda);
    $receiver.css_61zpoe$('transform-origin: 50% 50% 0px;');
    $receiver.css_61zpoe$('flex-direction: column;');
    $receiver.opacity_y3j6id$(ToastComponent$Companion$listStyle$lambda$lambda_0);
    $receiver.css_61zpoe$('transition: opacity 1s ease-in-out;');
    $receiver.overflow_c5t1z2$(ToastComponent$Companion$listStyle$lambda$lambda_1);
    return Unit;
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda($receiver) {
    return $receiver.flex;
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda_0($receiver) {
    $receiver.relative_dkjn9d$(ToastComponent$Companion$toastStyle$lambda$lambda$lambda);
    return Unit;
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda_1($receiver) {
    return $receiver.hidden;
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda_2($receiver) {
    return '560px';
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda_3($receiver) {
    return '300px';
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda_4($receiver) {
    return '0.5rem';
  }
  function ToastComponent$Companion$toastStyle$lambda$lambda_5($receiver) {
    return '0.375rem';
  }
  function ToastComponent$Companion$toastStyle$lambda($receiver) {
    $receiver.display_1gh9wc$(ToastComponent$Companion$toastStyle$lambda$lambda);
    $receiver.css_61zpoe$('flex-direction: row');
    $receiver.position_wp9r2r$(ToastComponent$Companion$toastStyle$lambda$lambda_0);
    $receiver.overflow_c5t1z2$(ToastComponent$Companion$toastStyle$lambda$lambda_1);
    $receiver.maxWidth_wpghq5$(ToastComponent$Companion$toastStyle$lambda$lambda_2);
    $receiver.minWidth_wpghq5$(ToastComponent$Companion$toastStyle$lambda$lambda_3);
    $receiver.margin_bcpvvc$(ToastComponent$Companion$toastStyle$lambda$lambda_4);
    $receiver.radius_bcpvvc$(ToastComponent$Companion$toastStyle$lambda$lambda_5);
    $receiver.css_61zpoe$('pointer-events: auto;');
    $receiver.css_61zpoe$('  -webkit-box-align: start;');
    $receiver.css_61zpoe$(' align-items: start;');
    $receiver.css_61zpoe$(' box-shadow: rgba(0, 0, 0, 0.1) 0px 10px 15px -3px, rgba(0, 0, 0, 0.05) 0px 4px 6px -2px;');
    return Unit;
  }
  function ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda(closure$placementStyle) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(closure$placementStyle);
      return Unit;
    };
  }
  function Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda(closure$it_0, toasts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$it = closure$it_0;
    this.local$toasts = toasts_0;
  }
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda;
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var destination = ArrayList_init();
            var tmp$;
            tmp$ = this.local$toasts.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              if (equals(element.placement, this.local$closure$it))
                destination.add_11rb$(element);
            }

            return destination;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda(closure$it_0) {
    return function (toasts_0, continuation_0, suspended) {
      var instance = new Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda(closure$it_0, toasts_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0(toasts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$toasts = toasts_0;
  }
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0;
  Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (ToastComponent$Placement_getInstance().appearsFromBottom_55u87a$(this.local$toasts)) {
              return asReversed(this.local$toasts);
            } else {
              return this.local$toasts;
            }

          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0(toasts_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0(toasts_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_1($receiver, toast) {
    return toast.render($receiver);
  }
  function ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      var $receiver_0 = ToastComponent$ToastStore_getInstance().data;
      var $receiver_1 = new unsafeFlow$ObjectLiteral_10(unsafeTransform$lambda_9(map$lambda_8(ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda(closure$it)), $receiver_0));
      $receiver.renderEach_tk0399$(new unsafeFlow$ObjectLiteral_10(unsafeTransform$lambda_9(map$lambda_8(ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_0), $receiver_1)), ToastComponent$ToastComponent$Companion_init$lambda$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  ToastComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ToastComponent$Companion_instance = null;
  function ToastComponent$Companion_getInstance() {
    if (ToastComponent$Companion_instance === null) {
      new ToastComponent$Companion();
    }return ToastComponent$Companion_instance;
  }
  function Coroutine$ToastComponent$render$lambda(this$ToastComponent_0, closure$localId_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$ToastComponent = this$ToastComponent_0;
    this.local$closure$localId = closure$localId_0;
  }
  Coroutine$ToastComponent$render$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$render$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$render$lambda.prototype.constructor = Coroutine$ToastComponent$render$lambda;
  Coroutine$ToastComponent$render$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = delay(this.local$this$ToastComponent.duration.value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return ToastComponent$ToastStore_getInstance().remove.invoke_11rb$(this.local$closure$localId), Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$render$lambda(this$ToastComponent_0, closure$localId_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ToastComponent$render$lambda(this$ToastComponent_0, closure$localId_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ToastComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.center;
  }
  function ToastComponent$render$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(ToastComponent$Companion_getInstance().listStyle_0);
    $receiver.alignItems_tsd917$(ToastComponent$render$lambda$lambda$lambda);
    return Unit;
  }
  function ToastComponent$render$lambda$lambda$lambda$lambda(this$ToastComponent) {
    return function ($receiver) {
      $receiver.color_jl9ed9$(this$ToastComponent.background.value);
      return Unit;
    };
  }
  function ToastComponent$render$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.center;
  }
  function ToastComponent$render$lambda$lambda$lambda_0(this$ToastComponent, closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(ToastComponent$Companion_getInstance().toastStyle_0);
      $receiver.background_f5fcq6$(ToastComponent$render$lambda$lambda$lambda$lambda(this$ToastComponent));
      $receiver.alignItems_tsd917$(ToastComponent$render$lambda$lambda$lambda$lambda_0);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function ToastComponent$render$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.css_61zpoe$('flex: 1 1 0%;');
    return Unit;
  }
  function ToastComponent$render$lambda$lambda$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda(closure$localId_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$localId = closure$localId_0;
  }
  Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$localId;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponent$render$lambda$lambda$lambda$lambda_1(closure$localId_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$ToastComponent$render$lambda$lambda$lambda$lambda(closure$localId_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ToastComponent$render$lambda$lambda$lambda_1(this$ToastComponent, closure$localId) {
    return function ($receiver) {
      var tmp$;
      if ((tmp$ = this$ToastComponent.content.value) != null) {
        styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
          return $receiver.div_hhcm6n$(p1, p2, p3);
        }.bind(null, $receiver)), void 0, void 0, void 0, ToastComponent$render$lambda$lambda$lambda$lambda$lambda)($receiver, ToastComponent$render$lambda$lambda$lambda$lambda$lambda_0(tmp$));
      }if (this$ToastComponent.hasCloseButton.value) {
        var $this = this$ToastComponent.closeButtonRendering.value($receiver);
        var mapper = ToastComponent$render$lambda$lambda$lambda$lambda_1(closure$localId);
        var $receiver_0 = $this.events;
        $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_11(unsafeTransform$lambda_10(map$lambda_9(mapper), $receiver_0)), ToastComponent$ToastStore_getInstance().remove);
      }return Unit;
    };
  }
  function ToastComponent$render$lambda$lambda_0(this$ToastComponent, closure$styling, closure$localId) {
    return function ($receiver) {
      styled(getCallableRef('div', function ($receiver, p1, p2, p3) {
        return $receiver.div_hhcm6n$(p1, p2, p3);
      }.bind(null, $receiver)), void 0, void 0, void 0, ToastComponent$render$lambda$lambda$lambda_0(this$ToastComponent, closure$styling))($receiver, ToastComponent$render$lambda$lambda$lambda_1(this$ToastComponent, closure$localId));
      return Unit;
    };
  }
  function ToastComponent$render$lambda_0(closure$baseClass, closure$id, closure$prefix, this$ToastComponent, closure$styling, closure$localId) {
    return function ($receiver) {
      return styled(getCallableRef('li', function ($receiver, p1, p2, p3) {
        return $receiver.li_l872l3$(p1, p2, p3);
      }.bind(null, $receiver)), closure$baseClass, closure$id, closure$prefix, ToastComponent$render$lambda$lambda)($receiver, ToastComponent$render$lambda$lambda_0(this$ToastComponent, closure$styling, closure$localId));
    };
  }
  ToastComponent.prototype.render_n7482o$ = function (styling, baseClass, id, prefix) {
    var localId = id != null ? id : uniqueId();
    launch(plus_0(MainScope(), ToastComponent$Companion_getInstance().job_0), void 0, void 0, ToastComponent$render$lambda(this, localId));
    ToastComponent$ToastStore_getInstance().add.invoke_11rb$(new ToastComponent$ToastFragment(localId, this.placement.value(ToastComponent$Placement_getInstance()), ToastComponent$render$lambda_0(baseClass, id, prefix, this, styling, localId)));
    return Unit;
  };
  Object.defineProperty(ToastComponent.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_hxcwug$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(ToastComponent.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_hxcwug$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(ToastComponent.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_hxcwug$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(ToastComponent.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_hxcwug$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(ToastComponent.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_hxcwug$_0.hasCloseButton;
    }
  });
  function ToastComponent$placement$lambda($receiver) {
    return $receiver.bottomRight;
  }
  function ToastComponent$background$lambda($receiver) {
    return $receiver.info;
  }
  ToastComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ToastComponent',
    interfaces: [CloseButtonProperty, ManagedComponent]
  };
  function showToast$lambda($receiver) {
    return Unit;
  }
  function showToast(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = showToast$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = ToastComponent$Companion_getInstance().defaultToastContainerPrefix;
    var $receiver = new ToastComponent();
    build($receiver);
    $receiver.render_n7482o$(styling, baseClass, id, prefix);
  }
  function toast$lambda($receiver) {
    return Unit;
  }
  function toast$ObjectLiteral(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build, initialData, id) {
    RootStore.call(this, initialData, id);
    this.show = this.handle_7ib3lp$(void 0, toast$ObjectLiteral$show$lambda(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build));
  }
  function Coroutine$toast$ObjectLiteral$show$lambda(closure$styling_0, closure$baseClass_0, closure$id_0, closure$prefix_0, closure$build_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$styling = closure$styling_0;
    this.local$closure$baseClass = closure$baseClass_0;
    this.local$closure$id = closure$id_0;
    this.local$closure$prefix = closure$prefix_0;
    this.local$closure$build = closure$build_0;
  }
  Coroutine$toast$ObjectLiteral$show$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$toast$ObjectLiteral$show$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$toast$ObjectLiteral$show$lambda.prototype.constructor = Coroutine$toast$ObjectLiteral$show$lambda;
  Coroutine$toast$ObjectLiteral$show$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return showToast(this.local$closure$styling, this.local$closure$baseClass, this.local$closure$id, this.local$closure$prefix, this.local$closure$build), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function toast$ObjectLiteral$show$lambda(closure$styling_0, closure$baseClass_0, closure$id_0, closure$prefix_0, closure$build_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$toast$ObjectLiteral$show$lambda(closure$styling_0, closure$baseClass_0, closure$id_0, closure$prefix_0, closure$build_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  toast$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  function toast(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = toast$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = ToastComponent$Companion_getInstance().defaultToastContainerPrefix;
    var pendingToastStore = new toast$ObjectLiteral(styling, baseClass, id, prefix, build, Unit);
    return pendingToastStore.show;
  }
  function tooltip($receiver, text) {
    return Theme.Companion.invoke().tooltip.write_vqirvp$(text.slice());
  }
  function tooltip_0($receiver, text, tooltipPlacement) {
    return Theme.Companion.invoke().tooltip.write_39nqze$(text.slice(), tooltipPlacement);
  }
  function WithValidator() {
  }
  function Coroutine$WithValidator$validate$lambda(this$WithValidator_0, closure$metadata_0, old_0, new_1, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$WithValidator = this$WithValidator_0;
    this.local$closure$metadata = closure$metadata_0;
    this.local$old = old_0;
    this.local$new = new_1;
  }
  Coroutine$WithValidator$validate$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WithValidator$validate$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WithValidator$validate$lambda.prototype.constructor = Coroutine$WithValidator$validate$lambda;
  Coroutine$WithValidator$validate$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$WithValidator.validator.isValid_xwzc9o$(this.local$new, this.local$closure$metadata) ? this.local$new : this.local$old;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WithValidator$validate$lambda(this$WithValidator_0, closure$metadata_0) {
    return function (old_0, new_1, continuation_0, suspended) {
      var instance = new Coroutine$WithValidator$validate$lambda(this$WithValidator_0, closure$metadata_0, old_0, new_1, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  WithValidator.prototype.validate_11rc$ = function (metadata) {
    this.syncBy_z1l90o$(this.handle_ajdi87$(void 0, WithValidator$validate$lambda(this, metadata)));
  };
  WithValidator.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WithValidator',
    interfaces: [Store]
  };
  function validationMessage$lambda(this$validationMessage) {
    return function (it) {
      return equals(it.id, this$validationMessage.id);
    };
  }
  function validationMessage$lambda_0(this$validationMessage) {
    return function (it) {
      return equals(it.id, this$validationMessage.id);
    };
  }
  function validationMessage($receiver) {
    if (Kotlin.isType($receiver, RootStore))
      if (Kotlin.isType($receiver, WithValidator)) {
        return $receiver.validator.find_e8elvg$(validationMessage$lambda($receiver));
      } else {
        return null;
      }
     else if (Kotlin.isType($receiver, SubStore)) {
      var root = $receiver.root;
      if (Kotlin.isType(root, WithValidator)) {
        return root.validator.find_e8elvg$(validationMessage$lambda_0($receiver));
      } else
        return null;
    } else
      return null;
  }
  function validationMessages$lambda(this$validationMessages) {
    return function (it) {
      return equals(it.id, this$validationMessages.id);
    };
  }
  function validationMessages$lambda_0(this$validationMessages) {
    return function (it) {
      return equals(it.id, this$validationMessages.id);
    };
  }
  function validationMessages($receiver) {
    if (Kotlin.isType($receiver, RootStore))
      if (Kotlin.isType($receiver, WithValidator)) {
        return $receiver.validator.filter_e8elvg$(validationMessages$lambda($receiver));
      } else {
        return null;
      }
     else if (Kotlin.isType($receiver, SubStore)) {
      var root = $receiver.root;
      if (Kotlin.isType(root, WithValidator)) {
        return root.validator.filter_e8elvg$(validationMessages$lambda_0($receiver));
      } else
        return null;
    } else
      return null;
  }
  var package$dev = _.dev || (_.dev = {});
  var package$fritz2 = package$dev.fritz2 || (package$dev.fritz2 = {});
  var package$components = package$fritz2.components || (package$fritz2.components = {});
  var package$data = package$components.data || (package$components.data = {});
  package$data.File = File;
  var package$validation = package$components.validation || (package$components.validation = {});
  package$validation.ComponentValidationMessage = ComponentValidationMessage;
  Object.defineProperty(Severity, 'Info', {
    get: Severity$Info_getInstance
  });
  Object.defineProperty(Severity, 'Success', {
    get: Severity$Success_getInstance
  });
  Object.defineProperty(Severity, 'Warning', {
    get: Severity$Warning_getInstance
  });
  Object.defineProperty(Severity, 'Error', {
    get: Severity$Error_getInstance
  });
  package$validation.Severity = Severity;
  package$validation.infoMessage_buzeal$ = infoMessage;
  package$validation.successMessage_buzeal$ = successMessage;
  package$validation.warningMessage_buzeal$ = warningMessage;
  package$validation.errorMessage_buzeal$ = errorMessage;
  package$validation.ComponentValidator = ComponentValidator;
  Object.defineProperty(AlertComponent, 'Companion', {
    get: AlertComponent$Companion_getInstance
  });
  package$components.AlertComponent = AlertComponent;
  package$components.alert_9ste7x$ = alert;
  package$components.asAlert_3110bo$ = asAlert;
  Object.defineProperty(AppFrameComponent, 'Companion', {
    get: AppFrameComponent$Companion_getInstance
  });
  package$components.AppFrameComponent = AppFrameComponent;
  package$components.appFrame_vqpy6r$ = appFrame;
  package$components.box_1enr5j$ = box;
  package$components.flexBox_1enr5j$ = flexBox;
  package$components.gridBox_o4fnj0$ = gridBox;
  Object.defineProperty(PushButtonComponent, 'Companion', {
    get: PushButtonComponent$Companion_getInstance
  });
  $$importsForInline$$['fritz2-styling-jsLegacy'] = $module$fritz2_styling_jsLegacy;
  Object.defineProperty(PushButtonComponent$IconPlacement, 'Right', {
    get: PushButtonComponent$IconPlacement$Right_getInstance
  });
  Object.defineProperty(PushButtonComponent$IconPlacement, 'Left', {
    get: PushButtonComponent$IconPlacement$Left_getInstance
  });
  PushButtonComponent.IconPlacement = PushButtonComponent$IconPlacement;
  PushButtonComponent.IconPlacementContext = PushButtonComponent$IconPlacementContext;
  package$components.PushButtonComponent = PushButtonComponent;
  package$components.pushButton_35qw0d$ = pushButton;
  package$components.clickButton_35qw0d$ = clickButton;
  Object.defineProperty(CheckboxComponent, 'Companion', {
    get: CheckboxComponent$Companion_getInstance
  });
  package$components.CheckboxComponent = CheckboxComponent;
  package$components.checkbox_jjxt18$ = checkbox;
  Object.defineProperty(CheckboxGroupComponent$Companion.prototype, 'CheckboxGroupLayouts', {
    get: CheckboxGroupComponent$Companion$CheckboxGroupLayouts_getInstance
  });
  Object.defineProperty(CheckboxGroupComponent, 'Companion', {
    get: CheckboxGroupComponent$Companion_getInstance
  });
  CheckboxGroupComponent.EventsContext = CheckboxGroupComponent$EventsContext;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$components.CheckboxGroupComponent = CheckboxGroupComponent;
  package$components.checkboxGroup_7w0yk0$ = checkboxGroup;
  package$components.ComponentProperty = ComponentProperty;
  package$components.DynamicComponentProperty = DynamicComponentProperty;
  package$components.NullableDynamicComponentProperty = NullableDynamicComponentProperty;
  package$components.Component = Component;
  package$components.ElementProperties = ElementProperties;
  package$components.ElementMixin = ElementMixin;
  package$components.EventProperties = EventProperties;
  package$components.EventMixin = EventMixin;
  package$components.FormProperties = FormProperties;
  package$components.FormMixin = FormMixin;
  package$components.InputFormProperties = InputFormProperties;
  package$components.InputFormMixin = InputFormMixin;
  SeverityProperties.SeverityContext = SeverityProperties$SeverityContext;
  package$components.SeverityProperties = SeverityProperties;
  package$components.SeverityMixin = SeverityMixin;
  package$components.MultiSelectionStore = MultiSelectionStore;
  package$components.SingleSelectionStore = SingleSelectionStore;
  package$components.CloseButtonProperty = CloseButtonProperty;
  package$components.CloseButtonMixin = CloseButtonMixin;
  Object.defineProperty(FileSelectionBaseComponent, 'Companion', {
    get: FileSelectionBaseComponent$Companion_getInstance
  });
  package$components.FileSelectionBaseComponent = FileSelectionBaseComponent;
  package$components.SingleFileSelectionComponent = SingleFileSelectionComponent;
  package$components.MultiFileSelectionComponent = MultiFileSelectionComponent;
  package$components.file_a8viw8$ = file;
  package$components.files_a8viw8$ = files;
  Object.defineProperty(FormControlComponent$Companion.prototype, 'ControlNames', {
    get: FormControlComponent$Companion$ControlNames_getInstance
  });
  Object.defineProperty(FormControlComponent, 'Companion', {
    get: FormControlComponent$Companion_getInstance
  });
  FormControlComponent.Control = FormControlComponent$Control;
  Object.defineProperty(FormControlComponent$FormSizeContext$FormSizeSpecifier, 'small', {
    get: FormControlComponent$FormSizeContext$FormSizeSpecifier$small_getInstance
  });
  Object.defineProperty(FormControlComponent$FormSizeContext$FormSizeSpecifier, 'normal', {
    get: FormControlComponent$FormSizeContext$FormSizeSpecifier$normal_getInstance
  });
  Object.defineProperty(FormControlComponent$FormSizeContext$FormSizeSpecifier, 'large', {
    get: FormControlComponent$FormSizeContext$FormSizeSpecifier$large_getInstance
  });
  FormControlComponent$FormSizeContext.prototype.FormSizeSpecifier = FormControlComponent$FormSizeContext$FormSizeSpecifier;
  Object.defineProperty(FormControlComponent, 'FormSizeContext', {
    get: FormControlComponent$FormSizeContext_getInstance
  });
  Object.defineProperty(FormControlComponent$ValidationResult, 'Companion', {
    get: FormControlComponent$ValidationResult$Companion_getInstance
  });
  FormControlComponent.ValidationResult = FormControlComponent$ValidationResult;
  package$components.FormControlComponent = FormControlComponent;
  package$components.ControlRenderer = ControlRenderer;
  package$components.SingleControlRenderer = SingleControlRenderer;
  package$components.ControlGroupRenderer = ControlGroupRenderer;
  package$components.formControl_oikzcw$ = formControl;
  Object.defineProperty(package$components, 'xmlns', {
    get: function () {
      return xmlns;
    }
  });
  package$components.createIconSvgElement_pdl1vj$ = createIconSvgElement;
  package$components.Svg = Svg;
  package$components.svg_l1im99$ = svg;
  Object.defineProperty(IconComponent, 'Companion', {
    get: IconComponent$Companion_getInstance
  });
  package$components.IconComponent = IconComponent;
  package$components.icon_6xsmn4$ = icon;
  Object.defineProperty(InputFieldComponent, 'Companion', {
    get: InputFieldComponent$Companion_getInstance
  });
  package$components.InputFieldComponent = InputFieldComponent;
  package$components.inputField_azli42$ = inputField;
  Object.defineProperty(ManagedComponent, 'Companion', {
    get: ManagedComponent$Companion_getInstance
  });
  package$components.ManagedComponent = ManagedComponent;
  package$components.randomId = randomId;
  Object.defineProperty(OverlayMethod, 'CoveringTopMost', {
    get: OverlayMethod$CoveringTopMost_getInstance
  });
  Object.defineProperty(OverlayMethod, 'CoveringEach', {
    get: OverlayMethod$CoveringEach_getInstance
  });
  package$components.OverlayMethod = OverlayMethod;
  package$components.Overlay = Overlay;
  package$components.DefaultOverlay = DefaultOverlay;
  ModalComponent.ModalsStack = ModalComponent$ModalsStack;
  Object.defineProperty(ModalComponent, 'Companion', {
    get: ModalComponent$Companion_getInstance
  });
  package$components.ModalComponent = ModalComponent;
  package$components.modal_ilvnfg$ = modal;
  Object.defineProperty(NavLinkComponent, 'Companion', {
    get: NavLinkComponent$Companion_getInstance
  });
  _.NavLinkComponent = NavLinkComponent;
  _.navLink_qvobiu$ = navLink;
  _.navSection_u10ujd$ = navSection;
  Object.defineProperty(NavbarComponent, 'Companion', {
    get: NavbarComponent$Companion_getInstance
  });
  package$components.NavbarComponent = NavbarComponent;
  package$components.navBar_quoglz$ = navBar;
  Object.defineProperty(PopoverComponent, 'Companion', {
    get: PopoverComponent$Companion_getInstance
  });
  $$importsForInline$$['fritz2-core-jsLegacy'] = $module$fritz2_core_jsLegacy;
  package$components.PopoverComponent = PopoverComponent;
  package$components.popover_2g1iy4$ = popover;
  Object.defineProperty(RadioComponent, 'Companion', {
    get: RadioComponent$Companion_getInstance
  });
  package$components.RadioComponent = RadioComponent;
  package$components.radio_j2eyhk$ = radio;
  Object.defineProperty(RadioGroupComponent$Companion.prototype, 'RadioGroupLayouts', {
    get: RadioGroupComponent$Companion$RadioGroupLayouts_getInstance
  });
  Object.defineProperty(RadioGroupComponent, 'Companion', {
    get: RadioGroupComponent$Companion_getInstance
  });
  RadioGroupComponent.EventsContext = RadioGroupComponent$EventsContext;
  package$components.RadioGroupComponent = RadioGroupComponent;
  package$components.radioGroup_3p0pet$ = radioGroup;
  Object.defineProperty(SelectFieldComponent, 'Companion', {
    get: SelectFieldComponent$Companion_getInstance
  });
  SelectFieldComponent.EventsContext = SelectFieldComponent$EventsContext;
  _.SelectFieldComponent = SelectFieldComponent;
  _.selectField_tdz92h$ = selectField;
  Object.defineProperty(SpinnerComponent, 'Companion', {
    get: SpinnerComponent$Companion_getInstance
  });
  package$components.SpinnerComponent = SpinnerComponent;
  package$components.spinner_j279wg$ = spinner;
  Object.defineProperty(StackComponent, 'Companion', {
    get: StackComponent$Companion_getInstance
  });
  package$components.StackComponent = StackComponent;
  package$components.StackUpComponent = StackUpComponent;
  package$components.stackUp_6ai7wl$ = stackUp;
  package$components.LineUpComponent = LineUpComponent;
  package$components.lineUp_voxjgl$ = lineUp;
  Object.defineProperty(SwitchComponent, 'Companion', {
    get: SwitchComponent$Companion_getInstance
  });
  package$components.SwitchComponent = SwitchComponent;
  package$components.switch_3n4x0r$ = switch_0;
  Object.defineProperty(TextAreaComponent, 'Companion', {
    get: TextAreaComponent$Companion_getInstance
  });
  package$components.TextAreaComponent = TextAreaComponent;
  package$components.textArea_yf0j5o$ = textArea;
  ToastComponent.ToastFragment = ToastComponent$ToastFragment;
  Object.defineProperty(ToastComponent, 'Placement', {
    get: ToastComponent$Placement_getInstance
  });
  Object.defineProperty(ToastComponent, 'ToastStore', {
    get: ToastComponent$ToastStore_getInstance
  });
  Object.defineProperty(ToastComponent, 'Companion', {
    get: ToastComponent$Companion_getInstance
  });
  package$components.ToastComponent = ToastComponent;
  package$components.showToast_1xx7vk$ = showToast;
  package$components.toast_1xx7vk$ = toast;
  package$components.tooltip_jd85ez$ = tooltip;
  package$components.tooltip_h7un4w$ = tooltip_0;
  package$validation.WithValidator = WithValidator;
  package$validation.validationMessage_jmsv6x$ = validationMessage;
  package$validation.validationMessages_jmsv6x$ = validationMessages;
  InputFormProperties.prototype.enabled_433wua$ = FormProperties.prototype.enabled_433wua$;
  InputFormProperties.prototype.enabled_6taknv$ = FormProperties.prototype.enabled_6taknv$;
  FormMixin.prototype.enabled_433wua$ = FormProperties.prototype.enabled_433wua$;
  FormMixin.prototype.enabled_6taknv$ = FormProperties.prototype.enabled_6taknv$;
  InputFormMixin.prototype.enabled_433wua$ = InputFormProperties.prototype.enabled_433wua$;
  InputFormMixin.prototype.enabled_6taknv$ = InputFormProperties.prototype.enabled_6taknv$;
  SeverityMixin.prototype.severity_9dec1s$ = SeverityProperties.prototype.severity_9dec1s$;
  SeverityMixin.prototype.severityClassOf_i6436e$ = SeverityProperties.prototype.severityClassOf_i6436e$;
  SingleControlRenderer.prototype.render_ibxmnd$ = ControlRenderer.prototype.render_ibxmnd$;
  ControlGroupRenderer.prototype.render_ibxmnd$ = ControlRenderer.prototype.render_ibxmnd$;
  Svg.prototype.subscribe_c8pi8o$_0 = EventContext.prototype.subscribe_c8pi8o$_0;
  WithValidator.prototype.errorHandler_lu5nrm$ = Store.prototype.errorHandler_lu5nrm$;
  WithValidator.prototype.handle_7ib3lp$$default = Store.prototype.handle_7ib3lp$$default;
  WithValidator.prototype.handle_ajdi87$$default = Store.prototype.handle_ajdi87$$default;
  WithValidator.prototype.handleAndEmit_glvev7$$default = Store.prototype.handleAndEmit_glvev7$$default;
  WithValidator.prototype.handleAndEmit_6gppb5$$default = Store.prototype.handleAndEmit_6gppb5$$default;
  WithValidator.prototype.syncBy_z1l90o$ = Store.prototype.syncBy_z1l90o$;
  WithValidator.prototype.syncBy_ygwd8u$ = Store.prototype.syncBy_ygwd8u$;
  WithValidator.prototype.syncWith_teyra4$ = Store.prototype.syncWith_teyra4$;
  WithValidator.prototype.handledBy_jora5j$ = Store.prototype.handledBy_jora5j$;
  WithValidator.prototype.handledBy_hlmqex$ = Store.prototype.handledBy_hlmqex$;
  WithValidator.prototype.handledBy_ytah3h$ = Store.prototype.handledBy_ytah3h$;
  WithValidator.prototype.handle_7ib3lp$ = Store.prototype.handle_7ib3lp$;
  WithValidator.prototype.handle_ajdi87$ = Store.prototype.handle_ajdi87$;
  WithValidator.prototype.handleAndEmit_glvev7$ = Store.prototype.handleAndEmit_glvev7$;
  WithValidator.prototype.handleAndEmit_6gppb5$ = Store.prototype.handleAndEmit_6gppb5$;
  xmlns = 'http://www.w3.org/2000/svg';
  Kotlin.defineModule('fritz2-components-jsLegacy', _);
  return _;
}));

//# sourceMappingURL=fritz2-components-jsLegacy.js.map
