(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'fritz2-core-js-legacy', 'fritz2-styling-js-legacy', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('fritz2-core-js-legacy'), require('fritz2-styling-js-legacy'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'fritz2-components-js-legacy'.");
    }if (typeof this['fritz2-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-js-legacy'. Its dependency 'fritz2-core-js-legacy' was not found. Please, check whether 'fritz2-core-js-legacy' is loaded prior to 'fritz2-components-js-legacy'.");
    }if (typeof this['fritz2-styling-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-js-legacy'. Its dependency 'fritz2-styling-js-legacy' was not found. Please, check whether 'fritz2-styling-js-legacy' is loaded prior to 'fritz2-components-js-legacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'fritz2-components-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'fritz2-components-js-legacy'.");
    }root['fritz2-components-js-legacy'] = factory(typeof this['fritz2-components-js-legacy'] === 'undefined' ? {} : this['fritz2-components-js-legacy'], kotlin, this['fritz2-core-js-legacy'], this['fritz2-styling-js-legacy'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$fritz2_core_js_legacy, $module$fritz2_styling_js_legacy, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var ValidationMessage = $module$fritz2_core_js_legacy.dev.fritz2.validation.ValidationMessage;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var Validator = $module$fritz2_core_js_legacy.dev.fritz2.validation.Validator;
  var Unit = Kotlin.kotlin.Unit;
  var StyleClass = $module$fritz2_styling_js_legacy.dev.fritz2.styling.StyleClass;
  var style = $module$fritz2_styling_js_legacy.dev.fritz2.styling.style_wlso4w$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Theme = $module$fritz2_styling_js_legacy.dev.fritz2.styling.theme.Theme;
  var span = $module$fritz2_styling_js_legacy.dev.fritz2.styling.span_5grt12$;
  var flowOf = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.flowOf_mh5how$;
  var div = $module$fritz2_styling_js_legacy.dev.fritz2.styling.div_nab73x$;
  var trimIndent = Kotlin.kotlin.text.trimIndent_pdl1vz$;
  var staticStyle = $module$fritz2_styling_js_legacy.dev.fritz2.styling.staticStyle_61zpoe$;
  var whenever = $module$fritz2_styling_js_legacy.dev.fritz2.styling.whenever_lyupls$;
  var get_name = $module$fritz2_styling_js_legacy.dev.fritz2.styling.get_name_s0usf7$;
  var header = $module$fritz2_styling_js_legacy.dev.fritz2.styling.header_p4gu9x$;
  var section = $module$fritz2_styling_js_legacy.dev.fritz2.styling.section_p4gu9x$;
  var aside = $module$fritz2_styling_js_legacy.dev.fritz2.styling.aside_p4gu9x$;
  var main = $module$fritz2_styling_js_legacy.dev.fritz2.styling.main_p4gu9x$;
  var storeOf = $module$fritz2_core_js_legacy.dev.fritz2.binding.storeOf_le71cu$;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var staticStyle_0 = $module$fritz2_styling_js_legacy.dev.fritz2.styling.staticStyle_puj7f4$;
  var Scope$Key = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.Scope.Key;
  var Throwable = Error;
  var div_0 = $module$fritz2_styling_js_legacy.dev.fritz2.styling.div_d6b1kh$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var button = $module$fritz2_styling_js_legacy.dev.fritz2.styling.button_b6506s$;
  var BoxParams = $module$fritz2_styling_js_legacy.dev.fritz2.styling.params.BoxParams;
  var throwCCE = Kotlin.throwCCE;
  var footer = $module$fritz2_styling_js_legacy.dev.fritz2.styling.footer_p4gu9x$;
  var EventContext = $module$fritz2_core_js_legacy.dev.fritz2.dom.EventContext;
  var WithJob = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.WithJob;
  var WithEvents = $module$fritz2_core_js_legacy.dev.fritz2.dom.WithEvents;
  var identification = $module$fritz2_core_js_legacy.dev.fritz2.identification;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var distinctUntilChanged = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.distinctUntilChanged_x2ftfk$;
  var states = $module$fritz2_core_js_legacy.dev.fritz2.dom.states_2p6s6c$;
  var toString = Kotlin.toString;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
  var Flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.Flow;
  var input = $module$fritz2_styling_js_legacy.dev.fritz2.styling.input_yr4kwa$;
  var label = $module$fritz2_styling_js_legacy.dev.fritz2.styling.label_qw6w4g$;
  var equals = Kotlin.equals;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var combine = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.combine_8gk0tw$;
  var withIndex = Kotlin.kotlin.collections.withIndex_7wnvza$;
  var toList = Kotlin.kotlin.collections.toList_7wnvza$;
  var IndexedValue = Kotlin.kotlin.collections.IndexedValue;
  var RootStore = $module$fritz2_core_js_legacy.dev.fritz2.binding.RootStore;
  var Store = $module$fritz2_core_js_legacy.dev.fritz2.binding.Store;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_2p1efm$;
  var params = $module$fritz2_styling_js_legacy.dev.fritz2.styling.params;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var table = $module$fritz2_styling_js_legacy.dev.fritz2.styling.table_h3gfd2$;
  var th = $module$fritz2_styling_js_legacy.dev.fritz2.styling.th_p8jhcw$;
  var thead = $module$fritz2_styling_js_legacy.dev.fritz2.styling.thead_x0p84g$;
  var toList_0 = Kotlin.kotlin.collections.toList_abgq59$;
  var sub = $module$fritz2_core_js_legacy.dev.fritz2.binding.sub_h6nur8$;
  var Any = Object;
  var td = $module$fritz2_styling_js_legacy.dev.fritz2.styling.td_h3gcws$;
  var tbody = $module$fritz2_styling_js_legacy.dev.fritz2.styling.tbody_1n7zc2$;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var Map = Kotlin.kotlin.collections.Map;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var sortedWith = Kotlin.kotlin.collections.sortedWith_eknfly$;
  var wrapFunction = Kotlin.wrapFunction;
  var Comparator = Kotlin.kotlin.Comparator;
  var compareBy = Kotlin.kotlin.comparisons.compareBy_bvgy4j$;
  var emptyFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.emptyFlow_287e2$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var NoSuchElementException_init = Kotlin.kotlin.NoSuchElementException_init;
  var hashCode = Kotlin.hashCode;
  var drop = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.drop_9ty2u6$;
  var minus = Kotlin.kotlin.collections.minus_2ws7j4$;
  var plus = Kotlin.kotlin.collections.plus_qloxvw$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var Collection = Kotlin.kotlin.collections.Collection;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var reversed = Kotlin.kotlin.comparisons.reversed_2avth4$;
  var throwUPAE = Kotlin.throwUPAE;
  var L100 = Kotlin.Long.fromInt(100);
  var debounce = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.debounce_6bsce5$;
  var section_0 = $module$fritz2_styling_js_legacy.dev.fritz2.styling.section_bjh3ub$;
  var indexOf = Kotlin.kotlin.text.indexOf_l5u8uk$;
  var numberToLong = Kotlin.numberToLong;
  var awaitClose = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.awaitClose_msfyrq$;
  var callbackFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.callbackFlow_b9ud7o$;
  var toList_1 = Kotlin.kotlin.collections.toList_us0mfu$;
  var emitAll = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.emitAll_c14n1u$;
  var transformLatest = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.transformLatest_ig04k9$;
  var combineInternal = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.internal.combineInternal_tbd5el$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var maxOrNull = Kotlin.kotlin.collections.maxOrNull_exjks8$;
  var sequenceOf = Kotlin.kotlin.sequences.sequenceOf_i5x0yv$;
  var p = $module$fritz2_styling_js_legacy.dev.fritz2.styling.p_v079lo$;
  var legend = $module$fritz2_styling_js_legacy.dev.fritz2.styling.legend_ilyhq1$;
  var fieldset = $module$fritz2_styling_js_legacy.dev.fritz2.styling.fieldset_17j04$;
  var mutableMapOf = Kotlin.kotlin.collections.mutableMapOf_qfcya0$;
  var Tag = $module$fritz2_core_js_legacy.dev.fritz2.dom.Tag;
  var RenderContext = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.RenderContext;
  var Div = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.Div;
  var Random = Kotlin.kotlin.random.Random;
  var UInt = Kotlin.kotlin.UInt;
  var nextUInt = Kotlin.kotlin.random.nextUInt_3yup1w$;
  var svg = $module$fritz2_styling_js_legacy.dev.fritz2.styling.svg_hblefk$;
  var IconDefinition = $module$fritz2_styling_js_legacy.dev.fritz2.styling.theme.IconDefinition;
  var values = $module$fritz2_core_js_legacy.dev.fritz2.dom.values_2p6s6c$;
  var input_0 = $module$fritz2_styling_js_legacy.dev.fritz2.styling.input_ewsvuw$;
  var button_0 = $module$fritz2_styling_js_legacy.dev.fritz2.styling.button_bwirvi$;
  var getCallableRef = Kotlin.getCallableRef;
  var a = $module$fritz2_styling_js_legacy.dev.fritz2.styling.a_c6ej65$;
  var hr = $module$fritz2_styling_js_legacy.dev.fritz2.styling.hr_tr0uq2$;
  var dropLast = Kotlin.kotlin.collections.dropLast_yzln2o$;
  var Job = $module$kotlinx_coroutines_core.kotlinx.coroutines.Job_5dx9e$;
  var Scope = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.Scope;
  var handledBy = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.handledBy_706ovd$;
  var nav = $module$fritz2_styling_js_legacy.dev.fritz2.styling.nav_p4gu9x$;
  var dom = $module$fritz2_core_js_legacy.dev.fritz2.dom;
  var shortcutOf = $module$fritz2_core_js_legacy.dev.fritz2.dom.html.shortcutOf_kc24xn$;
  var html = $module$fritz2_core_js_legacy.dev.fritz2.dom.html;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var numberToInt = Kotlin.numberToInt;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var indexOf_0 = Kotlin.kotlin.collections.indexOf_bv23uc$;
  var style_0 = $module$fritz2_styling_js_legacy.dev.fritz2.styling.style_puj7f4$;
  var selectedValue = $module$fritz2_core_js_legacy.dev.fritz2.dom.selectedValue_avuryo$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var select = $module$fritz2_styling_js_legacy.dev.fritz2.styling.select_2e7yty$;
  var core = $module$fritz2_styling_js_legacy.dev.fritz2.styling.theme.core_ze7s3n$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var JsMath = Math;
  var values_0 = $module$fritz2_core_js_legacy.dev.fritz2.dom.values_wbjycy$;
  var textarea = $module$fritz2_styling_js_legacy.dev.fritz2.styling.textarea_c6fzik$;
  var setOf = Kotlin.kotlin.collections.setOf_i5x0yv$;
  var asReversed = Kotlin.kotlin.collections.asReversed_2p1efm$;
  var ul = $module$fritz2_styling_js_legacy.dev.fritz2.styling.ul_4zdscd$;
  var MainScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.MainScope;
  var plus_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.plus_7n4184$;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var li = $module$fritz2_styling_js_legacy.dev.fritz2.styling.li_3sfbdj$;
  var L5000 = Kotlin.Long.fromInt(5000);
  var asList = Kotlin.kotlin.collections.asList_us0mfu$;
  var contains = Kotlin.kotlin.text.contains_li3zpu$;
  var take = Kotlin.kotlin.collections.take_ba2ldo$;
  var first_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.first_x2ftfk$;
  var onEach = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onEach_706ovd$;
  var L250 = Kotlin.Long.fromInt(250);
  var MutableStateFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.MutableStateFlow_mh5how$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var SubStore = $module$fritz2_core_js_legacy.dev.fritz2.binding.SubStore;
  Severity.prototype = Object.create(Enum.prototype);
  Severity.prototype.constructor = Severity;
  ComponentValidator.prototype = Object.create(Validator.prototype);
  ComponentValidator.prototype.constructor = ComponentValidator;
  AlertComponent$Variant.prototype = Object.create(Enum.prototype);
  AlertComponent$Variant.prototype.constructor = AlertComponent$Variant;
  AppFrameScope.prototype = Object.create(Scope$Key.prototype);
  AppFrameScope.prototype.constructor = AppFrameScope;
  AppFrameScope$Header.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Header.prototype.constructor = AppFrameScope$Header;
  AppFrameScope$Brand.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Brand.prototype.constructor = AppFrameScope$Brand;
  AppFrameScope$Actions.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Actions.prototype.constructor = AppFrameScope$Actions;
  AppFrameScope$Navigation.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Navigation.prototype.constructor = AppFrameScope$Navigation;
  AppFrameScope$Content.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Content.prototype.constructor = AppFrameScope$Content;
  AppFrameScope$Complementary.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Complementary.prototype.constructor = AppFrameScope$Complementary;
  AppFrameScope$Tablist.prototype = Object.create(AppFrameScope.prototype);
  AppFrameScope$Tablist.prototype.constructor = AppFrameScope$Tablist;
  PushButtonComponent$ButtonVariant.prototype = Object.create(Enum.prototype);
  PushButtonComponent$ButtonVariant.prototype.constructor = PushButtonComponent$ButtonVariant;
  PushButtonComponent$IconPlacement.prototype = Object.create(Enum.prototype);
  PushButtonComponent$IconPlacement.prototype.constructor = PushButtonComponent$IconPlacement;
  LinkButtonComponent.prototype = Object.create(PushButtonComponent.prototype);
  LinkButtonComponent.prototype.constructor = LinkButtonComponent;
  CardComponent$Sizes.prototype = Object.create(Enum.prototype);
  CardComponent$Sizes.prototype.constructor = CardComponent$Sizes;
  StateStore.prototype = Object.create(RootStore.prototype);
  StateStore.prototype.constructor = StateStore;
  SelectionContext$StrategyContext$StrategySpecifier.prototype = Object.create(Enum.prototype);
  SelectionContext$StrategyContext$StrategySpecifier.prototype.constructor = SelectionContext$StrategyContext$StrategySpecifier;
  Sorting.prototype = Object.create(Enum.prototype);
  Sorting.prototype.constructor = Sorting;
  SelectionMode.prototype = Object.create(Enum.prototype);
  SelectionMode.prototype.constructor = SelectionMode;
  RowSelectionStore.prototype = Object.create(RootStore.prototype);
  RowSelectionStore.prototype.constructor = RowSelectionStore;
  DropdownComponent$Placement.prototype = Object.create(Enum.prototype);
  DropdownComponent$Placement.prototype.constructor = DropdownComponent$Placement;
  DropdownComponent$Alignment.prototype = Object.create(Enum.prototype);
  DropdownComponent$Alignment.prototype.constructor = DropdownComponent$Alignment;
  DropdownComponent$visible$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  DropdownComponent$visible$ObjectLiteral.prototype.constructor = DropdownComponent$visible$ObjectLiteral;
  SingleFileSelectionComponent.prototype = Object.create(FileSelectionBaseComponent.prototype);
  SingleFileSelectionComponent.prototype.constructor = SingleFileSelectionComponent;
  MultiFileSelectionComponent.prototype = Object.create(FileSelectionBaseComponent.prototype);
  MultiFileSelectionComponent.prototype.constructor = MultiFileSelectionComponent;
  FormControlComponent$FormSizeContext$FormSizeSpecifier.prototype = Object.create(Enum.prototype);
  FormControlComponent$FormSizeContext$FormSizeSpecifier.prototype.constructor = FormControlComponent$FormSizeContext$FormSizeSpecifier;
  FormGroupComponent$LabelPlacement.prototype = Object.create(Enum.prototype);
  FormGroupComponent$LabelPlacement.prototype.constructor = FormGroupComponent$LabelPlacement;
  ManagedComponent$Companion$ManagedTag.prototype = Object.create(Tag.prototype);
  ManagedComponent$Companion$ManagedTag.prototype.constructor = ManagedComponent$Companion$ManagedTag;
  InputFormMixin.prototype = Object.create(FormMixin.prototype);
  InputFormMixin.prototype.constructor = InputFormMixin;
  Orientation.prototype = Object.create(Enum.prototype);
  Orientation.prototype.constructor = Orientation;
  MultiSelectionStore.prototype = Object.create(RootStore.prototype);
  MultiSelectionStore.prototype.constructor = MultiSelectionStore;
  SingleSelectionStore.prototype = Object.create(RootStore.prototype);
  SingleSelectionStore.prototype.constructor = SingleSelectionStore;
  MenuComponent.prototype = Object.create(MenuContext.prototype);
  MenuComponent.prototype.constructor = MenuComponent;
  SubMenuComponent.prototype = Object.create(MenuContext.prototype);
  SubMenuComponent.prototype.constructor = SubMenuComponent;
  OverlayMethod.prototype = Object.create(Enum.prototype);
  OverlayMethod.prototype.constructor = OverlayMethod;
  ModalComponent$ModalsStack.prototype = Object.create(RootStore.prototype);
  ModalComponent$ModalsStack.prototype.constructor = ModalComponent$ModalsStack;
  ModalComponent$Placement.prototype = Object.create(Enum.prototype);
  ModalComponent$Placement.prototype.constructor = ModalComponent$Placement;
  PaperComponent$Sizes.prototype = Object.create(Enum.prototype);
  PaperComponent$Sizes.prototype.constructor = PaperComponent$Sizes;
  PaperComponent$Types.prototype = Object.create(Enum.prototype);
  PaperComponent$Types.prototype.constructor = PaperComponent$Types;
  PopoverComponent$visible$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  PopoverComponent$visible$ObjectLiteral.prototype.constructor = PopoverComponent$visible$ObjectLiteral;
  Placement$Top.prototype = Object.create(Placement.prototype);
  Placement$Top.prototype.constructor = Placement$Top;
  Placement$TopStart.prototype = Object.create(Placement.prototype);
  Placement$TopStart.prototype.constructor = Placement$TopStart;
  Placement$TopEnd.prototype = Object.create(Placement.prototype);
  Placement$TopEnd.prototype.constructor = Placement$TopEnd;
  Placement$Bottom.prototype = Object.create(Placement.prototype);
  Placement$Bottom.prototype.constructor = Placement$Bottom;
  Placement$BottomStart.prototype = Object.create(Placement.prototype);
  Placement$BottomStart.prototype.constructor = Placement$BottomStart;
  Placement$BottomEnd.prototype = Object.create(Placement.prototype);
  Placement$BottomEnd.prototype.constructor = Placement$BottomEnd;
  Placement$Left.prototype = Object.create(Placement.prototype);
  Placement$Left.prototype.constructor = Placement$Left;
  Placement$LeftStart.prototype = Object.create(Placement.prototype);
  Placement$LeftStart.prototype.constructor = Placement$LeftStart;
  Placement$LeftEnd.prototype = Object.create(Placement.prototype);
  Placement$LeftEnd.prototype.constructor = Placement$LeftEnd;
  Placement$Right.prototype = Object.create(Placement.prototype);
  Placement$Right.prototype.constructor = Placement$Right;
  Placement$RightStart.prototype = Object.create(Placement.prototype);
  Placement$RightStart.prototype.constructor = Placement$RightStart;
  Placement$RightEnd.prototype = Object.create(Placement.prototype);
  Placement$RightEnd.prototype.constructor = Placement$RightEnd;
  PopupComponent$popupStore$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  PopupComponent$popupStore$ObjectLiteral.prototype.constructor = PopupComponent$popupStore$ObjectLiteral;
  Direction.prototype = Object.create(Enum.prototype);
  Direction.prototype.constructor = Direction;
  StateStore_0.prototype = Object.create(RootStore.prototype);
  StateStore_0.prototype.constructor = StateStore_0;
  StackUpComponent.prototype = Object.create(StackComponent.prototype);
  StackUpComponent.prototype.constructor = StackUpComponent;
  LineUpComponent.prototype = Object.create(StackComponent.prototype);
  LineUpComponent.prototype.constructor = LineUpComponent;
  asHandler$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  asHandler$ObjectLiteral.prototype.constructor = asHandler$ObjectLiteral;
  ToastComponentBase$ToastStore.prototype = Object.create(RootStore.prototype);
  ToastComponentBase$ToastStore.prototype.constructor = ToastComponentBase$ToastStore;
  ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral.prototype.constructor = ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral;
  ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral.prototype = Object.create(RootStore.prototype);
  ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral.prototype.constructor = ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral;
  ToastComponentBase$Companion.prototype = Object.create(ToastComponentBase$CloseMethodCompanion.prototype);
  ToastComponentBase$Companion.prototype.constructor = ToastComponentBase$Companion;
  ToastComponent$Companion.prototype = Object.create(ToastComponentBase$CloseMethodCompanion.prototype);
  ToastComponent$Companion.prototype.constructor = ToastComponent$Companion;
  ToastComponent.prototype = Object.create(ToastComponentBase.prototype);
  ToastComponent.prototype.constructor = ToastComponent;
  AlertToastComponent$Companion.prototype = Object.create(ToastComponentBase$CloseMethodCompanion.prototype);
  AlertToastComponent$Companion.prototype.constructor = AlertToastComponent$Companion;
  AlertToastComponent.prototype = Object.create(ToastComponentBase.prototype);
  AlertToastComponent.prototype.constructor = AlertToastComponent;
  StateStore_1.prototype = Object.create(RootStore.prototype);
  StateStore_1.prototype.constructor = StateStore_1;
  function File(name, type, size, content) {
    this.name = name;
    this.type = type;
    this.size = size;
    this.content = content;
  }
  File.prototype.toString = function () {
    return 'File(name=' + this.name + ', type=' + this.type + ', size=' + this.size.toString() + ', content: ' + this.content + ')';
  };
  File.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'File',
    interfaces: []
  };
  function ComponentValidationMessage(path, severity, message, details) {
    if (details === void 0)
      details = null;
    this.path = path;
    this.severity = severity;
    this.message = message;
    this.details = details;
  }
  ComponentValidationMessage.prototype.isError = function () {
    return this.severity.compareTo_11rb$(Severity$Warning_getInstance()) > 0;
  };
  ComponentValidationMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentValidationMessage',
    interfaces: [ValidationMessage]
  };
  ComponentValidationMessage.prototype.component1 = function () {
    return this.path;
  };
  ComponentValidationMessage.prototype.component2 = function () {
    return this.severity;
  };
  ComponentValidationMessage.prototype.component3 = function () {
    return this.message;
  };
  ComponentValidationMessage.prototype.component4 = function () {
    return this.details;
  };
  ComponentValidationMessage.prototype.copy_tw295j$ = function (path, severity, message, details) {
    return new ComponentValidationMessage(path === void 0 ? this.path : path, severity === void 0 ? this.severity : severity, message === void 0 ? this.message : message, details === void 0 ? this.details : details);
  };
  ComponentValidationMessage.prototype.toString = function () {
    return 'ComponentValidationMessage(path=' + Kotlin.toString(this.path) + (', severity=' + Kotlin.toString(this.severity)) + (', message=' + Kotlin.toString(this.message)) + (', details=' + Kotlin.toString(this.details)) + ')';
  };
  ComponentValidationMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.path) | 0;
    result = result * 31 + Kotlin.hashCode(this.severity) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    result = result * 31 + Kotlin.hashCode(this.details) | 0;
    return result;
  };
  ComponentValidationMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.path, other.path) && Kotlin.equals(this.severity, other.severity) && Kotlin.equals(this.message, other.message) && Kotlin.equals(this.details, other.details)))));
  };
  function Severity(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Severity_initFields() {
    Severity_initFields = function () {
    };
    Severity$Info_instance = new Severity('Info', 0);
    Severity$Success_instance = new Severity('Success', 1);
    Severity$Warning_instance = new Severity('Warning', 2);
    Severity$Error_instance = new Severity('Error', 3);
  }
  var Severity$Info_instance;
  function Severity$Info_getInstance() {
    Severity_initFields();
    return Severity$Info_instance;
  }
  var Severity$Success_instance;
  function Severity$Success_getInstance() {
    Severity_initFields();
    return Severity$Success_instance;
  }
  var Severity$Warning_instance;
  function Severity$Warning_getInstance() {
    Severity_initFields();
    return Severity$Warning_instance;
  }
  var Severity$Error_instance;
  function Severity$Error_getInstance() {
    Severity_initFields();
    return Severity$Error_instance;
  }
  Severity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Severity',
    interfaces: [Enum]
  };
  function Severity$values() {
    return [Severity$Info_getInstance(), Severity$Success_getInstance(), Severity$Warning_getInstance(), Severity$Error_getInstance()];
  }
  Severity.values = Severity$values;
  function Severity$valueOf(name) {
    switch (name) {
      case 'Info':
        return Severity$Info_getInstance();
      case 'Success':
        return Severity$Success_getInstance();
      case 'Warning':
        return Severity$Warning_getInstance();
      case 'Error':
        return Severity$Error_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.validation.Severity.' + name);
    }
  }
  Severity.valueOf_61zpoe$ = Severity$valueOf;
  function infoMessage(path, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(path, Severity$Info_getInstance(), message, details);
  }
  function infoMessage_0($receiver, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage($receiver.path, Severity$Info_getInstance(), message, details);
  }
  function successMessage(path, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(path, Severity$Success_getInstance(), message, details);
  }
  function successMessage_0($receiver, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage($receiver.path, Severity$Success_getInstance(), message, details);
  }
  function warningMessage(path, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(path, Severity$Warning_getInstance(), message, details);
  }
  function warningMessage_0($receiver, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage($receiver.path, Severity$Warning_getInstance(), message, details);
  }
  function errorMessage(path, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage(path, Severity$Error_getInstance(), message, details);
  }
  function errorMessage_0($receiver, message, details) {
    if (details === void 0)
      details = null;
    return new ComponentValidationMessage($receiver.path, Severity$Error_getInstance(), message, details);
  }
  function ComponentValidator() {
    Validator.call(this);
  }
  ComponentValidator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentValidator',
    interfaces: [Validator]
  };
  function alert$lambda($receiver) {
    return Unit;
  }
  function alert($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = alert$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'alert';
    var $receiver_0 = new AlertComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function asAlert$lambda($receiver) {
    return Unit;
  }
  function asAlert$lambda_0($receiver) {
    return Unit;
  }
  function asAlert$lambda$lambda(closure$receiver) {
    return function ($receiver) {
      switch (closure$receiver.severity.name) {
        case 'Info':
          return $receiver.info;
        case 'Success':
          return $receiver.success;
        case 'Warning':
          return $receiver.warning;
        case 'Error':
          return $receiver.error;
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function asAlert$lambda_1(closure$receiver, this$asAlert, closure$build) {
    return function ($receiver) {
      $receiver.severity.invoke_11rb$(asAlert$lambda$lambda(closure$receiver));
      $receiver.content_61zpoe$(this$asAlert.message);
      closure$build($receiver);
      return Unit;
    };
  }
  function asAlert($receiver, styling, renderContext, build) {
    if (styling === void 0)
      styling = asAlert$lambda;
    if (build === void 0)
      build = asAlert$lambda_0;
    var receiver = $receiver;
    alert(renderContext, styling, void 0, void 0, void 0, asAlert$lambda_1(receiver, $receiver, build));
  }
  function asAlert$lambda_2($receiver) {
    return Unit;
  }
  function asAlert$lambda_3($receiver) {
    return Unit;
  }
  function asAlert_0($receiver, renderContext, build) {
    if (build === void 0)
      build = asAlert$lambda_2;
    asAlert($receiver, asAlert$lambda_3, renderContext, build);
  }
  function AlertComponent() {
    AlertComponent$Companion_getInstance();
    this.icon = new ComponentProperty(null);
    this.severity = new ComponentProperty(AlertComponent$severity$lambda);
    this.variant = new ComponentProperty(AlertComponent$variant$lambda);
    this.size = new ComponentProperty(AlertComponent$size$lambda);
    this.stacking = new ComponentProperty(AlertComponent$stacking$lambda);
    this.title_f4vu97$_0 = null;
    this.content_5lh5ey$_0 = null;
  }
  function AlertComponent$Companion() {
    AlertComponent$Companion_instance = this;
    this.alertCss_0 = style('alert', AlertComponent$Companion$alertCss$lambda);
    this.alertContentCss_0 = style('alert-content', AlertComponent$Companion$alertContentCss$lambda);
  }
  function AlertComponent$Companion$alertCss$lambda$lambda($receiver) {
    return $receiver.flex;
  }
  function AlertComponent$Companion$alertCss$lambda$lambda_0($receiver) {
    return $receiver.center;
  }
  function AlertComponent$Companion$alertCss$lambda($receiver) {
    $receiver.display_1gh9wc$(AlertComponent$Companion$alertCss$lambda$lambda);
    $receiver.alignItems_tsd917$(AlertComponent$Companion$alertCss$lambda$lambda_0);
    return Unit;
  }
  function AlertComponent$Companion$alertContentCss$lambda$lambda($receiver) {
    return $receiver.inlineBlock;
  }
  function AlertComponent$Companion$alertContentCss$lambda$lambda_0($receiver) {
    return '100%';
  }
  function AlertComponent$Companion$alertContentCss$lambda$lambda_1($receiver) {
    return '1.2em';
  }
  function AlertComponent$Companion$alertContentCss$lambda($receiver) {
    $receiver.display_1gh9wc$(AlertComponent$Companion$alertContentCss$lambda$lambda);
    $receiver.width_wpghq5$(AlertComponent$Companion$alertContentCss$lambda$lambda_0);
    $receiver.lineHeight_bcpvvc$(AlertComponent$Companion$alertContentCss$lambda$lambda_1);
    return Unit;
  }
  AlertComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AlertComponent$Companion_instance = null;
  function AlertComponent$Companion_getInstance() {
    if (AlertComponent$Companion_instance === null) {
      new AlertComponent$Companion();
    }return AlertComponent$Companion_instance;
  }
  function AlertComponent$Variant(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function AlertComponent$Variant_initFields() {
    AlertComponent$Variant_initFields = function () {
    };
    AlertComponent$Variant$SOLID_instance = new AlertComponent$Variant('SOLID', 0);
    AlertComponent$Variant$SUBTLE_instance = new AlertComponent$Variant('SUBTLE', 1);
    AlertComponent$Variant$LEFT_ACCENT_instance = new AlertComponent$Variant('LEFT_ACCENT', 2);
    AlertComponent$Variant$TOP_ACCENT_instance = new AlertComponent$Variant('TOP_ACCENT', 3);
    AlertComponent$Variant$GHOST_instance = new AlertComponent$Variant('GHOST', 4);
  }
  var AlertComponent$Variant$SOLID_instance;
  function AlertComponent$Variant$SOLID_getInstance() {
    AlertComponent$Variant_initFields();
    return AlertComponent$Variant$SOLID_instance;
  }
  var AlertComponent$Variant$SUBTLE_instance;
  function AlertComponent$Variant$SUBTLE_getInstance() {
    AlertComponent$Variant_initFields();
    return AlertComponent$Variant$SUBTLE_instance;
  }
  var AlertComponent$Variant$LEFT_ACCENT_instance;
  function AlertComponent$Variant$LEFT_ACCENT_getInstance() {
    AlertComponent$Variant_initFields();
    return AlertComponent$Variant$LEFT_ACCENT_instance;
  }
  var AlertComponent$Variant$TOP_ACCENT_instance;
  function AlertComponent$Variant$TOP_ACCENT_getInstance() {
    AlertComponent$Variant_initFields();
    return AlertComponent$Variant$TOP_ACCENT_instance;
  }
  var AlertComponent$Variant$GHOST_instance;
  function AlertComponent$Variant$GHOST_getInstance() {
    AlertComponent$Variant_initFields();
    return AlertComponent$Variant$GHOST_instance;
  }
  AlertComponent$Variant.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Variant',
    interfaces: [Enum]
  };
  function AlertComponent$Variant$values() {
    return [AlertComponent$Variant$SOLID_getInstance(), AlertComponent$Variant$SUBTLE_getInstance(), AlertComponent$Variant$LEFT_ACCENT_getInstance(), AlertComponent$Variant$TOP_ACCENT_getInstance(), AlertComponent$Variant$GHOST_getInstance()];
  }
  AlertComponent$Variant.values = AlertComponent$Variant$values;
  function AlertComponent$Variant$valueOf(name) {
    switch (name) {
      case 'SOLID':
        return AlertComponent$Variant$SOLID_getInstance();
      case 'SUBTLE':
        return AlertComponent$Variant$SUBTLE_getInstance();
      case 'LEFT_ACCENT':
        return AlertComponent$Variant$LEFT_ACCENT_getInstance();
      case 'TOP_ACCENT':
        return AlertComponent$Variant$TOP_ACCENT_getInstance();
      case 'GHOST':
        return AlertComponent$Variant$GHOST_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.alert.AlertComponent.Variant.' + name);
    }
  }
  AlertComponent$Variant.valueOf_61zpoe$ = AlertComponent$Variant$valueOf;
  function AlertComponent$VariantContext() {
    AlertComponent$VariantContext_instance = this;
    this.solid = AlertComponent$Variant$SOLID_getInstance();
    this.subtle = AlertComponent$Variant$SUBTLE_getInstance();
    this.leftAccent = AlertComponent$Variant$LEFT_ACCENT_getInstance();
    this.topAccent = AlertComponent$Variant$TOP_ACCENT_getInstance();
    this.ghost = AlertComponent$Variant$GHOST_getInstance();
  }
  AlertComponent$VariantContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'VariantContext',
    interfaces: []
  };
  var AlertComponent$VariantContext_instance = null;
  function AlertComponent$VariantContext_getInstance() {
    if (AlertComponent$VariantContext_instance === null) {
      new AlertComponent$VariantContext();
    }return AlertComponent$VariantContext_instance;
  }
  Object.defineProperty(AlertComponent.prototype, 'actualIcon_nknsza$_0', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this.icon.value) != null ? tmp$(Theme.Companion.invoke().icons) : null) != null ? tmp$_0 : this.severity.value(Theme.Companion.invoke().alert.severities).icon;
    }
  });
  AlertComponent.prototype.title_9c978p$ = function (value) {
    this.title_f4vu97$_0 = value;
  };
  function AlertComponent$title$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.smaller;
  }
  function AlertComponent$title$lambda$lambda$lambda($receiver) {
    $receiver.right_bcpvvc$(AlertComponent$title$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AlertComponent$title$lambda$lambda$lambda_0($receiver) {
    return $receiver.bold;
  }
  function AlertComponent$title$lambda$lambda($receiver) {
    $receiver.margins_ptb4s1$(AlertComponent$title$lambda$lambda$lambda);
    $receiver.fontWeight_wyjwgc$(AlertComponent$title$lambda$lambda$lambda_0);
    return Unit;
  }
  function AlertComponent$title$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function AlertComponent$title$lambda(closure$value) {
    return function ($receiver) {
      span($receiver, AlertComponent$title$lambda$lambda, void 0, void 0, void 0, void 0, AlertComponent$title$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  AlertComponent.prototype.title_p81yox$ = function (value) {
    this.title_9c978p$(AlertComponent$title$lambda(value));
  };
  AlertComponent.prototype.title_61zpoe$ = function (value) {
    this.title_p81yox$(flowOf(value));
  };
  AlertComponent.prototype.content_9c978p$ = function (value) {
    this.content_5lh5ey$_0 = value;
  };
  function AlertComponent$content$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function AlertComponent$content$lambda(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, AlertComponent$content$lambda$lambda(closure$value));
      return Unit;
    };
  }
  AlertComponent.prototype.content_p81yox$ = function (value) {
    this.content_9c978p$(AlertComponent$content$lambda(value));
  };
  AlertComponent.prototype.content_61zpoe$ = function (value) {
    this.content_p81yox$(flowOf(value));
  };
  function AlertComponent$render$lambda$lambda(this$AlertComponent, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.invoke_qkhqzy$(this$AlertComponent.size.value(Theme.Companion.invoke().alert.sizes));
      $receiver.invoke_qkhqzy$(this$AlertComponent.stacking.value(Theme.Companion.invoke().alert.stacking));
      switch (this$AlertComponent.variant.value(AlertComponent$VariantContext_getInstance()).name) {
        case 'SOLID':
          tmp$ = Theme.Companion.invoke().alert.variants.solid;
          break;
        case 'SUBTLE':
          tmp$ = Theme.Companion.invoke().alert.variants.subtle;
          break;
        case 'LEFT_ACCENT':
          tmp$ = Theme.Companion.invoke().alert.variants.leftAccent;
          break;
        case 'TOP_ACCENT':
          tmp$ = Theme.Companion.invoke().alert.variants.topAccent;
          break;
        case 'GHOST':
          tmp$ = Theme.Companion.invoke().alert.variants.ghost;
          break;
        default:tmp$ = Kotlin.noWhenBranchMatched();
          break;
      }
      tmp$($receiver, this$AlertComponent.severity.value(Theme.Companion.invoke().alert.severities).colorScheme);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.inlineFlex;
  }
  function AlertComponent$render$lambda$lambda$lambda($receiver) {
    $receiver.display_1gh9wc$(AlertComponent$render$lambda$lambda$lambda$lambda);
    $receiver.css_61zpoe$('margin-right: var(--al-icon-margin)');
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_0($receiver) {
    $receiver.css_61zpoe$('width: var(--al-icon-size)');
    $receiver.css_61zpoe$('height: var(--al-icon-size)');
    return Unit;
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda$lambda(this$AlertComponent) {
    return function ($receiver) {
      return this$AlertComponent.actualIcon_nknsza$_0;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda$lambda_1(this$AlertComponent) {
    return function ($receiver) {
      $receiver.fromTheme_q0wvou$(AlertComponent$render$lambda$lambda$lambda$lambda$lambda(this$AlertComponent));
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda_0(this$AlertComponent) {
    return function ($receiver) {
      icon($receiver, AlertComponent$render$lambda$lambda$lambda$lambda_0, void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda$lambda_1(this$AlertComponent));
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda$lambda_1(this$AlertComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      (tmp$ = this$AlertComponent.title_f4vu97$_0) != null ? tmp$($receiver) : null;
      (tmp$_0 = this$AlertComponent.content_5lh5ey$_0) != null ? tmp$_0($receiver) : null;
      return Unit;
    };
  }
  function AlertComponent$render$lambda$lambda_0(this$AlertComponent) {
    return function ($receiver) {
      div($receiver, AlertComponent$render$lambda$lambda$lambda, void 0, void 0, void 0, void 0, AlertComponent$render$lambda$lambda$lambda_0(this$AlertComponent));
      $receiver.div_iz87dk$(AlertComponent$Companion_getInstance().alertContentCss_0.name, void 0, void 0, AlertComponent$render$lambda$lambda$lambda_1(this$AlertComponent));
      return Unit;
    };
  }
  AlertComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    div(context, AlertComponent$render$lambda$lambda(this, styling), AlertComponent$Companion_getInstance().alertCss_0, void 0, void 0, void 0, AlertComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  function AlertComponent$severity$lambda($receiver) {
    return $receiver.info;
  }
  function AlertComponent$variant$lambda($receiver) {
    return $receiver.solid;
  }
  function AlertComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function AlertComponent$stacking$lambda($receiver) {
    return $receiver.separated;
  }
  AlertComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AlertComponent',
    interfaces: [Component]
  };
  function appFrame$lambda($receiver) {
    return Unit;
  }
  function appFrame$lambda_0($receiver) {
    return Unit;
  }
  function appFrame($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = appFrame$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'appFrame';
    if (build === void 0)
      build = appFrame$lambda_0;
    var $receiver_0 = new AppFrameComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function AppFrameSection(styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (context === void 0)
      context = AppFrameSection_init$lambda;
    this.styling = styling;
    this.baseClass = baseClass;
    this.id = id;
    this.context = context;
  }
  function AppFrameSection_init$lambda($receiver) {
    return Unit;
  }
  AppFrameSection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AppFrameSection',
    interfaces: []
  };
  function AppFrameComponent() {
    AppFrameComponent$Companion_getInstance();
    this.$delegate_vtr3vl$_0 = new CloseButtonMixin('sidebar-close-button', AppFrameComponent_init$lambda);
    this.sidebarWidth_1wsv19$_0 = null;
    this.mobileSidebarWidth_nfgwm9$_0 = null;
    this.sidebarStatus_t9n0l5$_0 = storeOf(false);
    this.toggleSidebar_a3aqkh$_0 = this.sidebarStatus_t9n0l5$_0.handle_7ib3lp$(void 0, AppFrameComponent$toggleSidebar$lambda);
    this.closeSidebar = this.sidebarStatus_t9n0l5$_0.handle_7ib3lp$(void 0, AppFrameComponent$closeSidebar$lambda);
    this.openSideBar_a12es5$_0 = staticStyle_0('open-sidebar', trimIndent('@media (max-width: ' + Theme.Companion.invoke().breakPoints.md + ') {' + '\n' + '                transform: translateX(0) !important;' + '\n' + '         }'));
    this.showBackdrop_16dl5m$_0 = staticStyle_0('show-backdrop', trimIndent('@media (max-width: ' + Theme.Companion.invoke().breakPoints.md + ') {' + '\n' + '                left : 0 !important;' + '\n' + '                opacity: 1 !important;' + '\n' + '        }'));
    this.brand_gw1yv4$_0 = new AppFrameSection();
    this.header_xrp6io$_0 = new AppFrameSection();
    this.actions_9nymdm$_0 = new AppFrameSection();
    this.content_ro8fke$_0 = new AppFrameSection();
    this.complementary_4sgrad$_0 = null;
    this.tablist_m8z4r8$_0 = null;
    this.navigation_682kiv$_0 = new AppFrameSection();
    this.sidebarToggle = new ComponentProperty(AppFrameComponent$sidebarToggle$lambda);
  }
  function AppFrameComponent$Companion() {
    AppFrameComponent$Companion_instance = this;
    staticStyle(trimIndent('\n' + '                body {' + '\n' + '                    position: relative;' + '\n' + '                    height: 100vh;' + '\n' + '                    overflow: hidden;' + '\n' + '                    max-height: -webkit-fill-available;' + '\n' + '                    width: 100vw;' + '\n' + '                    display: grid;' + '\n' + '                    grid-template-areas:' + '\n' + '                        ' + '"' + 'brand header' + '"' + '\n' + '                        ' + '"' + 'sidebar content' + '"' + '\n' + '                        ' + '"' + 'sidebar tablist' + '"' + ';' + '\n' + '                    grid-template-rows: ' + Theme.Companion.invoke().appFrame.headerHeight + ' 1fr min-content;' + '\n' + '                    grid-auto-columns: min-content 1fr;' + '\n' + '                    padding: 0;' + '\n' + '                    margin: 0; ' + '\n' + '                }' + '\n' + '                '));
  }
  AppFrameComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AppFrameComponent$Companion_instance = null;
  function AppFrameComponent$Companion_getInstance() {
    if (AppFrameComponent$Companion_instance === null) {
      new AppFrameComponent$Companion();
    }return AppFrameComponent$Companion_instance;
  }
  AppFrameComponent.prototype.sidebarWidth_za3lpa$ = function (value) {
    this.sidebarWidth_1wsv19$_0 = value.toString() + 'vw';
  };
  AppFrameComponent.prototype.sidebarWidth_61zpoe$ = function (value) {
    this.sidebarWidth_1wsv19$_0 = value;
  };
  AppFrameComponent.prototype.mobileSidebarWidth_za3lpa$ = function (value) {
    this.mobileSidebarWidth_nfgwm9$_0 = value.toString() + 'vw';
  };
  AppFrameComponent.prototype.mobileSidebarWidth_61zpoe$ = function (value) {
    this.mobileSidebarWidth_nfgwm9$_0 = value;
  };
  function AppFrameComponent$mobileSidebar$lambda$lambda($receiver) {
    return $receiver.appFrame;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_0(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      return (tmp$ = this$AppFrameComponent.mobileSidebarWidth_nfgwm9$_0) != null ? tmp$ : Theme.Companion.invoke().appFrame.mobileSidebarWidth;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_1($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda(closure$topPosition) {
    return function ($receiver) {
      return closure$topPosition;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda(closure$topPosition) {
    return function ($receiver) {
      $receiver.top_bcpvvc$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda(closure$topPosition));
      return Unit;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_2(closure$topPosition) {
    return function ($receiver) {
      $receiver.fixed_dkjn9d$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda(closure$topPosition));
      return Unit;
    };
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda$lambda_0($receiver) {
    $receiver.top_bcpvvc$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_3($receiver) {
    $receiver.relative_dkjn9d$(AppFrameComponent$mobileSidebar$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_4($receiver) {
    return $receiver.flat;
  }
  function AppFrameComponent$mobileSidebar$lambda$lambda_5($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$mobileSidebar$lambda(this$AppFrameComponent, closure$topPosition) {
    return function ($receiver) {
      $receiver.zIndex_yiflju$(AppFrameComponent$mobileSidebar$lambda$lambda);
      $receiver.width_5la74k$(AppFrameComponent$mobileSidebar$lambda$lambda_0(this$AppFrameComponent), AppFrameComponent$mobileSidebar$lambda$lambda_1);
      $receiver.css_d8n4vg$('transform: translateX(-110vw);', 'transform: unset;');
      $receiver.position_vgpajw$(AppFrameComponent$mobileSidebar$lambda$lambda_2(closure$topPosition), AppFrameComponent$mobileSidebar$lambda$lambda_3);
      $receiver.css_61zpoe$(trimIndent('\n            max-height: -webkit-fill-available;\n            will-change: transform;\n            transition: \n                transform .4s ease-in,\n                visibility .4s linear;\n            '));
      $receiver.boxShadow_h2dnmw$(AppFrameComponent$mobileSidebar$lambda$lambda_4, AppFrameComponent$mobileSidebar$lambda$lambda_5);
      return Unit;
    };
  }
  AppFrameComponent.prototype.mobileSidebar_kz2ru7$_0 = function (topPosition) {
    return AppFrameComponent$mobileSidebar$lambda(this, topPosition);
  };
  AppFrameComponent.prototype.brand_75qqyn$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.brand_gw1yv4$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  AppFrameComponent.prototype.header_75qqyn$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.header_xrp6io$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  AppFrameComponent.prototype.actions_2ziwwb$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.actions_9nymdm$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  AppFrameComponent.prototype.content_2ziwwb$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.content_ro8fke$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  AppFrameComponent.prototype.complementary_2ziwwb$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.complementary_4sgrad$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  AppFrameComponent.prototype.tablist_75qqyn$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.tablist_m8z4r8$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  AppFrameComponent.prototype.navigation_2ziwwb$ = function (styling, baseClass, id, context) {
    if (styling === void 0)
      styling = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    this.navigation_682kiv$_0 = new AppFrameSection(styling, baseClass, id, context);
  };
  function AppFrameComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.block;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '0';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return '-110vh';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda($receiver) {
    $receiver.top_bcpvvc$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda);
    $receiver.left_bcpvvc$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_1($receiver) {
    $receiver.fixed_dkjn9d$(AppFrameComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_2($receiver) {
    return '100vw';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_3($receiver) {
    return 'min(100vh, 100%)';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_4($receiver) {
    return $receiver.raiseBy_6ic1pp$($receiver.appFrame, -10);
  }
  function AppFrameComponent$render$lambda$lambda($receiver) {
    $receiver.display_76osno$(AppFrameComponent$render$lambda$lambda$lambda, AppFrameComponent$render$lambda$lambda$lambda_0);
    $receiver.position_wp9r2r$(AppFrameComponent$render$lambda$lambda$lambda_1);
    $receiver.width_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda_2);
    $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda_3);
    $receiver.css_61zpoe$('height: -webkit-fill-available;');
    $receiver.zIndex_yiflju$(AppFrameComponent$render$lambda$lambda$lambda_4);
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.backdrop);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda_0(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(whenever(this$AppFrameComponent.showBackdrop_16dl5m$_0, this$AppFrameComponent.sidebarStatus_t9n0l5$_0.data)));
      $receiver.handledBy_jora5j$($receiver.clicks, this$AppFrameComponent.toggleSidebar_a3aqkh$_0);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_0() {
    return 'header';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_5($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_1() {
    return 'brand';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_6($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_7($receiver) {
    return Theme.Companion.invoke().appFrame.headerHeight;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_8($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent$render$lambda$lambda_1(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.grid_jhf0yc$(AppFrameComponent$render$lambda$lambda$lambda_5, AppFrameComponent$render$lambda$lambda$lambda_6);
      $receiver.invoke_qkhqzy$(this$AppFrameComponent.mobileSidebar_kz2ru7$_0('none'));
      $receiver.height_5la74k$(AppFrameComponent$render$lambda$lambda$lambda_7, AppFrameComponent$render$lambda$lambda$lambda_8);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_2($receiver) {
    $receiver.set_vjtlun$(AppFrameScope$Brand_getInstance(), true);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_2($receiver) {
    return Theme.Companion.invoke().appFrame.headerHeight;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_9(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_2);
      $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.brand);
      (tmp$ = this$AppFrameComponent.brand_gw1yv4$_0.styling) != null ? ($receiver.invoke_5yoziz$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda_10(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.brand_gw1yv4$_0.context($receiver);
      if (this$AppFrameComponent.hasCloseButton.value) {
        $receiver.handledBy_jora5j$(this$AppFrameComponent.closeButtonRendering.value($receiver), this$AppFrameComponent.closeSidebar);
      }return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_3(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(whenever(this$AppFrameComponent.openSideBar_a12es5$_0, this$AppFrameComponent.sidebarStatus_t9n0l5$_0.data)));
      flexBox($receiver, AppFrameComponent$render$lambda$lambda$lambda_9(this$AppFrameComponent), this$AppFrameComponent.brand_gw1yv4$_0.baseClass, this$AppFrameComponent.brand_gw1yv4$_0.id, 'brand', void 0, AppFrameComponent$render$lambda$lambda$lambda_10(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_3() {
    return 'header';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_11($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_3);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda_4($receiver) {
    $receiver.grid_5hf0eu$(AppFrameComponent$render$lambda$lambda$lambda_11);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda_5($receiver) {
    $receiver.set_vjtlun$(AppFrameScope$Header_getInstance(), true);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_4($receiver) {
    return Theme.Companion.invoke().appFrame.headerHeight;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_12(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_4);
      $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.header);
      (tmp$ = this$AppFrameComponent.header_xrp6io$_0.styling) != null ? ($receiver.invoke_5yoziz$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    return $receiver.center;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_5($receiver) {
    $receiver.alignItems_tsd917$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_2($receiver) {
    return $receiver.tiny;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '-.5rem';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    $receiver.left_bcpvvc$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.display_76osno$(void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda);
    $receiver.padding_bcpvvc$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0);
    $receiver.margins_ptb4s1$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.sidebarToggle.value($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_3(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.handledBy_jora5j$(clickButton($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(this$AppFrameComponent)), this$AppFrameComponent.toggleSidebar_a3aqkh$_0);
      this$AppFrameComponent.header_xrp6io$_0.context($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_6(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_2);
      $receiver.items.invoke_11rb$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_3(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_7(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      (tmp$ = this$AppFrameComponent.actions_9nymdm$_0.styling) != null ? ($receiver.invoke_4my6up$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_8(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.actions_9nymdm$_0.context($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda_13(this$AppFrameComponent) {
    return function ($receiver) {
      lineUp($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda_5, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda_6(this$AppFrameComponent));
      section($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda_7(this$AppFrameComponent), this$AppFrameComponent.actions_9nymdm$_0.baseClass, this$AppFrameComponent.actions_9nymdm$_0.id, 'actions', void 0, AppFrameComponent$render$lambda$lambda$lambda$lambda_8(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_6(this$AppFrameComponent) {
    return function ($receiver) {
      flexBox($receiver, AppFrameComponent$render$lambda$lambda$lambda_12(this$AppFrameComponent), this$AppFrameComponent.header_xrp6io$_0.baseClass, this$AppFrameComponent.header_xrp6io$_0.id, 'header', void 0, AppFrameComponent$render$lambda$lambda$lambda_13(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_9() {
    return 'content';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_14($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_9);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_10() {
    return 'sidebar';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_15($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_10);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_16($receiver) {
    return $receiver.hidden;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_17($receiver) {
    return 'calc(100% - ' + Theme.Companion.invoke().appFrame.headerHeight + ')';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_18($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_19(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      return (tmp$ = this$AppFrameComponent.sidebarWidth_1wsv19$_0) != null ? tmp$ : Theme.Companion.invoke().appFrame.sidebarWidth;
    };
  }
  function AppFrameComponent$render$lambda$lambda_7(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.grid_jhf0yc$(AppFrameComponent$render$lambda$lambda$lambda_14, AppFrameComponent$render$lambda$lambda$lambda_15);
      $receiver.invoke_qkhqzy$(this$AppFrameComponent.mobileSidebar_kz2ru7$_0(Theme.Companion.invoke().appFrame.headerHeight));
      $receiver.overflow_c5t1z2$(AppFrameComponent$render$lambda$lambda$lambda_16);
      $receiver.height_5la74k$(AppFrameComponent$render$lambda$lambda$lambda_17, AppFrameComponent$render$lambda$lambda$lambda_18);
      $receiver.minWidth_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda_19(this$AppFrameComponent));
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.sidebar);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_11($receiver) {
    return $receiver.column;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_12($receiver) {
    return $receiver.stretch;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_13($receiver) {
    return $receiver.spaceBetween;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_14($receiver) {
    return $receiver.full;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_15($receiver) {
    return '-webkit-fill-available';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_16($receiver) {
    return $receiver.auto;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_20($receiver) {
    $receiver.direction_la6ffj$(AppFrameComponent$render$lambda$lambda$lambda$lambda_11);
    $receiver.alignItems_tsd917$(AppFrameComponent$render$lambda$lambda$lambda$lambda_12);
    $receiver.justifyContent_vlnw1j$(AppFrameComponent$render$lambda$lambda$lambda$lambda_13);
    $receiver.height_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_14);
    $receiver.maxHeight_wpghq5$(AppFrameComponent$render$lambda$lambda$lambda$lambda_15);
    $receiver.overflow_c5t1z2$(AppFrameComponent$render$lambda$lambda$lambda$lambda_16);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_17(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.navigation);
      (tmp$ = this$AppFrameComponent.navigation_682kiv$_0.styling) != null ? ($receiver.invoke_4my6up$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_18($receiver) {
    $receiver.set_vjtlun$(AppFrameScope$Navigation_getInstance(), true);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_19(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.navigation_682kiv$_0.context($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_4(closure$complementary) {
    return function ($receiver) {
      var tmp$;
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.complementary);
      (tmp$ = closure$complementary.styling) != null ? ($receiver.invoke_4my6up$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_5($receiver) {
    $receiver.set_vjtlun$(AppFrameScope$Complementary_getInstance(), true);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_6(closure$complementary) {
    return function ($receiver) {
      closure$complementary.context($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda_21(this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      section($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda_17(this$AppFrameComponent), this$AppFrameComponent.navigation_682kiv$_0.baseClass, this$AppFrameComponent.navigation_682kiv$_0.id, 'navigation', AppFrameComponent$render$lambda$lambda$lambda$lambda_18, AppFrameComponent$render$lambda$lambda$lambda$lambda_19(this$AppFrameComponent));
      if ((tmp$ = this$AppFrameComponent.complementary_4sgrad$_0) != null) {
        section($receiver, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_4(tmp$), tmp$.baseClass, tmp$.id, 'complementary', AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_5, AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_6(tmp$));
      }return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_8(this$AppFrameComponent) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(whenever(this$AppFrameComponent.openSideBar_a12es5$_0, this$AppFrameComponent.sidebarStatus_t9n0l5$_0.data)));
      flexBox($receiver, AppFrameComponent$render$lambda$lambda$lambda_20, void 0, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda$lambda_21(this$AppFrameComponent));
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_20($receiver) {
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_22($receiver) {
    $receiver.relative_dkjn9d$(AppFrameComponent$render$lambda$lambda$lambda$lambda_20);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_21() {
    return 'content';
  }
  function AppFrameComponent$render$lambda$lambda$lambda_23($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_21);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_24($receiver) {
    return $receiver.auto;
  }
  function AppFrameComponent$render$lambda$lambda_9(closure$styling, this$AppFrameComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.position_wp9r2r$(AppFrameComponent$render$lambda$lambda$lambda_22);
      $receiver.grid_5hf0eu$(AppFrameComponent$render$lambda$lambda$lambda_23);
      $receiver.overflow_c5t1z2$(AppFrameComponent$render$lambda$lambda$lambda_24);
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.content);
      $receiver.invoke_4my6up$(closure$styling);
      (tmp$ = this$AppFrameComponent.content_ro8fke$_0.styling) != null ? ($receiver.invoke_4my6up$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda_10($receiver) {
    $receiver.set_vjtlun$(AppFrameScope$Content_getInstance(), true);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda_11(this$AppFrameComponent) {
    return function ($receiver) {
      this$AppFrameComponent.content_ro8fke$_0.context($receiver);
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_7() {
    return 'tablist';
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_22($receiver) {
    $receiver.area_h4ejuu$(AppFrameComponent$render$lambda$lambda$lambda$lambda$lambda_7);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_23($receiver) {
    return $receiver.row;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_24($receiver) {
    return $receiver.center;
  }
  function AppFrameComponent$render$lambda$lambda$lambda$lambda_25($receiver) {
    return $receiver.spaceEvenly;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_25(closure$tablist) {
    return function ($receiver) {
      var tmp$;
      $receiver.grid_5hf0eu$(AppFrameComponent$render$lambda$lambda$lambda$lambda_22);
      $receiver.direction_la6ffj$(AppFrameComponent$render$lambda$lambda$lambda$lambda_23);
      $receiver.alignItems_tsd917$(AppFrameComponent$render$lambda$lambda$lambda$lambda_24);
      $receiver.justifyContent_vlnw1j$(AppFrameComponent$render$lambda$lambda$lambda$lambda_25);
      $receiver.invoke_5yoziz$(Theme.Companion.invoke().appFrame.tablist);
      (tmp$ = closure$tablist.styling) != null ? ($receiver.invoke_5yoziz$(tmp$), Unit) : null;
      return Unit;
    };
  }
  function AppFrameComponent$render$lambda$lambda$lambda_26($receiver) {
    $receiver.set_vjtlun$(AppFrameScope$Tablist_getInstance(), true);
    return Unit;
  }
  function AppFrameComponent$render$lambda$lambda$lambda_27(closure$tablist) {
    return function ($receiver) {
      closure$tablist.context($receiver);
      return Unit;
    };
  }
  AppFrameComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var tmp$, tmp$_0;
    div(context, AppFrameComponent$render$lambda$lambda, void 0, void 0, 'backdrop', void 0, AppFrameComponent$render$lambda$lambda_0(this));
    header(context, AppFrameComponent$render$lambda$lambda_1(this), void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda_2, AppFrameComponent$render$lambda$lambda_3(this));
    header(context, AppFrameComponent$render$lambda$lambda_4, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda_5, AppFrameComponent$render$lambda$lambda_6(this));
    aside(context, AppFrameComponent$render$lambda$lambda_7(this), void 0, void 0, void 0, void 0, AppFrameComponent$render$lambda$lambda_8(this));
    main(context, AppFrameComponent$render$lambda$lambda_9(styling, this), this.content_ro8fke$_0.baseClass.plus_fox8kt$(baseClass), (tmp$ = this.content_ro8fke$_0.id) != null ? tmp$ : id, 'content', AppFrameComponent$render$lambda$lambda_10, AppFrameComponent$render$lambda$lambda_11(this));
    if ((tmp$_0 = this.tablist_m8z4r8$_0) != null) {
      flexBox(context, AppFrameComponent$render$lambda$lambda$lambda_25(tmp$_0), tmp$_0.baseClass, tmp$_0.id, 'tablist', AppFrameComponent$render$lambda$lambda$lambda_26, AppFrameComponent$render$lambda$lambda$lambda_27(tmp$_0));
    }return Unit;
  };
  Object.defineProperty(AppFrameComponent.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_vtr3vl$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(AppFrameComponent.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_vtr3vl$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(AppFrameComponent.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_vtr3vl$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(AppFrameComponent.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_vtr3vl$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(AppFrameComponent.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_vtr3vl$_0.hasCloseButton;
    }
  });
  function AppFrameComponent_init$lambda$lambda$lambda($receiver) {
    return $receiver.auto;
  }
  function AppFrameComponent_init$lambda$lambda($receiver) {
    $receiver.left_bcpvvc$(AppFrameComponent_init$lambda$lambda$lambda);
    return Unit;
  }
  function AppFrameComponent_init$lambda$lambda_0($receiver) {
    return $receiver.unset;
  }
  function AppFrameComponent_init$lambda$lambda_1($receiver) {
    return $receiver.none;
  }
  function AppFrameComponent_init$lambda($receiver) {
    $receiver.margins_ptb4s1$(AppFrameComponent_init$lambda$lambda);
    $receiver.display_76osno$(AppFrameComponent_init$lambda$lambda_0, AppFrameComponent_init$lambda$lambda_1);
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().appFrame.sidebarClose);
    return Unit;
  }
  function Coroutine$AppFrameComponent$toggleSidebar$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$AppFrameComponent$toggleSidebar$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$AppFrameComponent$toggleSidebar$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$AppFrameComponent$toggleSidebar$lambda.prototype.constructor = Coroutine$AppFrameComponent$toggleSidebar$lambda;
  Coroutine$AppFrameComponent$toggleSidebar$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function AppFrameComponent$toggleSidebar$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$AppFrameComponent$toggleSidebar$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$AppFrameComponent$closeSidebar$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$AppFrameComponent$closeSidebar$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$AppFrameComponent$closeSidebar$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$AppFrameComponent$closeSidebar$lambda.prototype.constructor = Coroutine$AppFrameComponent$closeSidebar$lambda;
  Coroutine$AppFrameComponent$closeSidebar$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return false;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function AppFrameComponent$closeSidebar$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$AppFrameComponent$closeSidebar$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda($receiver) {
    return $receiver.ghost;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda_0($receiver) {
    return $receiver.menu;
  }
  function AppFrameComponent$sidebarToggle$lambda$lambda_1($receiver) {
    return Theme.Companion.invoke().colors.neutral;
  }
  function AppFrameComponent$sidebarToggle$lambda($receiver) {
    $receiver.variant.invoke_11rb$(AppFrameComponent$sidebarToggle$lambda$lambda);
    $receiver.icon.invoke_11rb$(AppFrameComponent$sidebarToggle$lambda$lambda_0);
    $receiver.type.invoke_11rb$(AppFrameComponent$sidebarToggle$lambda$lambda_1);
    return Unit;
  }
  AppFrameComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AppFrameComponent',
    interfaces: [CloseButtonProperty, Component]
  };
  function AppFrameScope(name) {
    Scope$Key.call(this, 'appFrame-' + name);
  }
  function AppFrameScope$Header() {
    AppFrameScope$Header_instance = this;
    AppFrameScope.call(this, 'header');
  }
  AppFrameScope$Header.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Header',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Header_instance = null;
  function AppFrameScope$Header_getInstance() {
    if (AppFrameScope$Header_instance === null) {
      new AppFrameScope$Header();
    }return AppFrameScope$Header_instance;
  }
  function AppFrameScope$Brand() {
    AppFrameScope$Brand_instance = this;
    AppFrameScope.call(this, 'brand');
  }
  AppFrameScope$Brand.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Brand',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Brand_instance = null;
  function AppFrameScope$Brand_getInstance() {
    if (AppFrameScope$Brand_instance === null) {
      new AppFrameScope$Brand();
    }return AppFrameScope$Brand_instance;
  }
  function AppFrameScope$Actions() {
    AppFrameScope$Actions_instance = this;
    AppFrameScope.call(this, 'actions');
  }
  AppFrameScope$Actions.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Actions',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Actions_instance = null;
  function AppFrameScope$Actions_getInstance() {
    if (AppFrameScope$Actions_instance === null) {
      new AppFrameScope$Actions();
    }return AppFrameScope$Actions_instance;
  }
  function AppFrameScope$Navigation() {
    AppFrameScope$Navigation_instance = this;
    AppFrameScope.call(this, 'navigation');
  }
  AppFrameScope$Navigation.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Navigation',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Navigation_instance = null;
  function AppFrameScope$Navigation_getInstance() {
    if (AppFrameScope$Navigation_instance === null) {
      new AppFrameScope$Navigation();
    }return AppFrameScope$Navigation_instance;
  }
  function AppFrameScope$Content() {
    AppFrameScope$Content_instance = this;
    AppFrameScope.call(this, 'content');
  }
  AppFrameScope$Content.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Content',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Content_instance = null;
  function AppFrameScope$Content_getInstance() {
    if (AppFrameScope$Content_instance === null) {
      new AppFrameScope$Content();
    }return AppFrameScope$Content_instance;
  }
  function AppFrameScope$Complementary() {
    AppFrameScope$Complementary_instance = this;
    AppFrameScope.call(this, 'complementary');
  }
  AppFrameScope$Complementary.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Complementary',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Complementary_instance = null;
  function AppFrameScope$Complementary_getInstance() {
    if (AppFrameScope$Complementary_instance === null) {
      new AppFrameScope$Complementary();
    }return AppFrameScope$Complementary_instance;
  }
  function AppFrameScope$Tablist() {
    AppFrameScope$Tablist_instance = this;
    AppFrameScope.call(this, 'tablist');
  }
  AppFrameScope$Tablist.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Tablist',
    interfaces: [AppFrameScope]
  };
  var AppFrameScope$Tablist_instance = null;
  function AppFrameScope$Tablist_getInstance() {
    if (AppFrameScope$Tablist_instance === null) {
      new AppFrameScope$Tablist();
    }return AppFrameScope$Tablist_instance;
  }
  AppFrameScope.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AppFrameScope',
    interfaces: [Scope$Key]
  };
  function registerServiceWorker$lambda(closure$jsFileName) {
    return function (it) {
      window.navigator.serviceWorker.register(closure$jsFileName);
      return Unit;
    };
  }
  function registerServiceWorker(jsFileName) {
    if (jsFileName === void 0)
      jsFileName = 'serviceWorker.js';
    try {
      window.addEventListener('load', registerServiceWorker$lambda(jsFileName));
      console.log('ServiceWorker registered');
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        console.log('Error registering ServiceWorker:', t);
      } else
        throw t;
    }
  }
  function box$lambda($receiver) {
    return Unit;
  }
  function box$lambda_0(closure$content) {
    return function ($receiver) {
      closure$content($receiver);
      return Unit;
    };
  }
  function box($receiver, styling, baseClass, id, prefix, content) {
    if (styling === void 0)
      styling = box$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'box';
    return div($receiver, styling, baseClass, id, prefix, void 0, box$lambda_0(content));
  }
  function flexBox$lambda($receiver) {
    return Unit;
  }
  function flexBox$lambda_0($receiver) {
    return Unit;
  }
  function flexBox$lambda$lambda($receiver) {
    return $receiver.flex;
  }
  function flexBox$lambda_1($receiver) {
    $receiver.display_1gh9wc$(flexBox$lambda$lambda);
    return Unit;
  }
  function flexBox$lambda_2(closure$content) {
    return function ($receiver) {
      closure$content($receiver);
      return Unit;
    };
  }
  function flexBox($receiver, styling, baseClass, id, prefix, scope, content) {
    if (styling === void 0)
      styling = flexBox$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'flex-box';
    if (scope === void 0)
      scope = flexBox$lambda_0;
    return div_0($receiver, flexBox$lambda_1, styling, baseClass, id, prefix, scope, flexBox$lambda_2(content));
  }
  function gridBox$lambda($receiver) {
    return Unit;
  }
  function gridBox$lambda_0($receiver) {
    return Unit;
  }
  function gridBox$lambda$lambda($receiver) {
    return $receiver.grid;
  }
  function gridBox$lambda_1($receiver) {
    $receiver.display_1gh9wc$(gridBox$lambda$lambda);
    return Unit;
  }
  function gridBox$lambda_2(closure$content) {
    return function ($receiver) {
      closure$content($receiver);
      return Unit;
    };
  }
  function gridBox($receiver, styling, baseClass, id, prefix, scope, content) {
    if (styling === void 0)
      styling = gridBox$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'grid-box';
    if (scope === void 0)
      scope = gridBox$lambda_0;
    return div_0($receiver, gridBox$lambda_1, styling, baseClass, id, prefix, scope, gridBox$lambda_2(content));
  }
  function pushButton$lambda($receiver) {
    return Unit;
  }
  function pushButton$lambda_0($receiver) {
    return Unit;
  }
  function pushButton($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = pushButton$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'push-button';
    if (build === void 0)
      build = pushButton$lambda_0;
    var $receiver_0 = new PushButtonComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function clickButton$lambda($receiver) {
    return Unit;
  }
  function clickButton$lambda_0($receiver) {
    return Unit;
  }
  function clickButton$lambda$lambda(closure$clickEvents) {
    return function ($receiver) {
      closure$clickEvents.v = $receiver.clicks;
      return Unit;
    };
  }
  function clickButton$lambda_1(closure$build, closure$clickEvents) {
    return function ($receiver) {
      closure$build($receiver);
      $receiver.events.invoke_11rb$(clickButton$lambda$lambda(closure$clickEvents));
      return Unit;
    };
  }
  function clickButton($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = clickButton$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'click-button';
    if (build === void 0)
      build = clickButton$lambda_0;
    var clickEvents = {v: null};
    pushButton($receiver, styling, baseClass, id, prefix, clickButton$lambda_1(build, clickEvents));
    return ensureNotNull(clickEvents.v);
  }
  function linkButton$lambda($receiver) {
    return Unit;
  }
  function linkButton$lambda_0($receiver) {
    return Unit;
  }
  function linkButton($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = linkButton$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'link-button';
    if (build === void 0)
      build = linkButton$lambda_0;
    var $receiver_0 = new LinkButtonComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function PushButtonComponent() {
    PushButtonComponent$Companion_getInstance();
    this.$delegate_aqzi7i$_0 = new EventMixin();
    this.$delegate_aqzi7i$_1 = new ElementMixin();
    this.$delegate_aqzi7i$_2 = new FormMixin();
    this.$delegate_aqzi7i$_3 = new TooltipMixin();
    this.iconSize_mp4jgc$_0 = '1.15em';
    this.marginToText_lqysnc$_0 = '0.35rem';
    this.marginToBorder_sp64pj$_0 = '-0.2rem';
    this.centerIconStyle = PushButtonComponent$centerIconStyle$lambda;
    this.centerSpinnerStyle = PushButtonComponent$centerSpinnerStyle$lambda(this);
    this.leftSpinnerStyle = PushButtonComponent$leftSpinnerStyle$lambda(this);
    this.rightSpinnerStyle = PushButtonComponent$rightSpinnerStyle$lambda(this);
    this.leftIconStyle = PushButtonComponent$leftIconStyle$lambda(this);
    this.rightIconStyle = PushButtonComponent$rightIconStyle$lambda(this);
    this.type = new ComponentProperty(PushButtonComponent$type$lambda);
    this.variant = new ComponentProperty(PushButtonComponent$variant$lambda);
    this.size = new ComponentProperty(PushButtonComponent$size$lambda);
    this.text_nkcgk1$_0 = null;
    this.loadingText_1tku25$_0 = null;
    this.loading_7mvz6i$_0 = null;
    this.icon = new ComponentProperty(null);
    this.iconPlacement = new ComponentProperty(PushButtonComponent$iconPlacement$lambda);
  }
  function PushButtonComponent$Companion() {
    PushButtonComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('button', '\n                appearance: none;\n                display: inline-flex;\n                align-items : center;\n                justify-content: center;\n                transition: all 250ms;\n                user-select: none;\n                white-space: nowrap;\n                vertical-align: middle;\n                outline: none;\n                text-overflow: ellipsis;\n                \n                &:disabled {\n                    opacity: 0.4;\n                    cursor: not-allowed;\n                    boxShadow: none;\n                }\n            ');
    this.hidden_8be2vx$ = staticStyle_0('hidden', 'visibility: hidden;');
    this.iconPlacementContext = new PushButtonComponent$IconPlacementContext();
  }
  PushButtonComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PushButtonComponent$Companion_instance = null;
  function PushButtonComponent$Companion_getInstance() {
    if (PushButtonComponent$Companion_instance === null) {
      new PushButtonComponent$Companion();
    }return PushButtonComponent$Companion_instance;
  }
  function PushButtonComponent$ButtonVariant(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PushButtonComponent$ButtonVariant_initFields() {
    PushButtonComponent$ButtonVariant_initFields = function () {
    };
    PushButtonComponent$ButtonVariant$OUTLINE_instance = new PushButtonComponent$ButtonVariant('OUTLINE', 0);
    PushButtonComponent$ButtonVariant$SOLID_instance = new PushButtonComponent$ButtonVariant('SOLID', 1);
    PushButtonComponent$ButtonVariant$GHOST_instance = new PushButtonComponent$ButtonVariant('GHOST', 2);
    PushButtonComponent$ButtonVariant$LINK_instance = new PushButtonComponent$ButtonVariant('LINK', 3);
  }
  var PushButtonComponent$ButtonVariant$OUTLINE_instance;
  function PushButtonComponent$ButtonVariant$OUTLINE_getInstance() {
    PushButtonComponent$ButtonVariant_initFields();
    return PushButtonComponent$ButtonVariant$OUTLINE_instance;
  }
  var PushButtonComponent$ButtonVariant$SOLID_instance;
  function PushButtonComponent$ButtonVariant$SOLID_getInstance() {
    PushButtonComponent$ButtonVariant_initFields();
    return PushButtonComponent$ButtonVariant$SOLID_instance;
  }
  var PushButtonComponent$ButtonVariant$GHOST_instance;
  function PushButtonComponent$ButtonVariant$GHOST_getInstance() {
    PushButtonComponent$ButtonVariant_initFields();
    return PushButtonComponent$ButtonVariant$GHOST_instance;
  }
  var PushButtonComponent$ButtonVariant$LINK_instance;
  function PushButtonComponent$ButtonVariant$LINK_getInstance() {
    PushButtonComponent$ButtonVariant_initFields();
    return PushButtonComponent$ButtonVariant$LINK_instance;
  }
  PushButtonComponent$ButtonVariant.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ButtonVariant',
    interfaces: [Enum]
  };
  function PushButtonComponent$ButtonVariant$values() {
    return [PushButtonComponent$ButtonVariant$OUTLINE_getInstance(), PushButtonComponent$ButtonVariant$SOLID_getInstance(), PushButtonComponent$ButtonVariant$GHOST_getInstance(), PushButtonComponent$ButtonVariant$LINK_getInstance()];
  }
  PushButtonComponent$ButtonVariant.values = PushButtonComponent$ButtonVariant$values;
  function PushButtonComponent$ButtonVariant$valueOf(name) {
    switch (name) {
      case 'OUTLINE':
        return PushButtonComponent$ButtonVariant$OUTLINE_getInstance();
      case 'SOLID':
        return PushButtonComponent$ButtonVariant$SOLID_getInstance();
      case 'GHOST':
        return PushButtonComponent$ButtonVariant$GHOST_getInstance();
      case 'LINK':
        return PushButtonComponent$ButtonVariant$LINK_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.buttons.PushButtonComponent.ButtonVariant.' + name);
    }
  }
  PushButtonComponent$ButtonVariant.valueOf_61zpoe$ = PushButtonComponent$ButtonVariant$valueOf;
  function PushButtonComponent$VariantContext() {
    PushButtonComponent$VariantContext_instance = this;
    this.outline = PushButtonComponent$ButtonVariant$OUTLINE_getInstance();
    this.solid = PushButtonComponent$ButtonVariant$SOLID_getInstance();
    this.ghost = PushButtonComponent$ButtonVariant$GHOST_getInstance();
    this.link = PushButtonComponent$ButtonVariant$LINK_getInstance();
  }
  PushButtonComponent$VariantContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'VariantContext',
    interfaces: []
  };
  var PushButtonComponent$VariantContext_instance = null;
  function PushButtonComponent$VariantContext_getInstance() {
    if (PushButtonComponent$VariantContext_instance === null) {
      new PushButtonComponent$VariantContext();
    }return PushButtonComponent$VariantContext_instance;
  }
  function PushButtonComponent$text$lambda$lambda(closure$value, closure$hide) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      if (closure$hide)
        $receiver.className_61zpoe$(PushButtonComponent$Companion_getInstance().hidden_8be2vx$.name);
      return Unit;
    };
  }
  function PushButtonComponent$text$lambda(closure$value) {
    return function ($receiver, hide) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, PushButtonComponent$text$lambda$lambda(closure$value, hide));
      return Unit;
    };
  }
  PushButtonComponent.prototype.text_61zpoe$ = function (value) {
    this.text_nkcgk1$_0 = PushButtonComponent$text$lambda(value);
  };
  function PushButtonComponent$text$lambda$lambda_0(closure$value, closure$hide) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      if (closure$hide)
        $receiver.className_61zpoe$(PushButtonComponent$Companion_getInstance().hidden_8be2vx$.name);
      return Unit;
    };
  }
  function PushButtonComponent$text$lambda_0(closure$value) {
    return function ($receiver, hide) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, PushButtonComponent$text$lambda$lambda_0(closure$value, hide));
      return Unit;
    };
  }
  PushButtonComponent.prototype.text_p81yox$ = function (value) {
    this.text_nkcgk1$_0 = PushButtonComponent$text$lambda_0(value);
  };
  function PushButtonComponent$loadingText$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  function PushButtonComponent$loadingText$lambda(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, PushButtonComponent$loadingText$lambda$lambda(closure$value));
      return Unit;
    };
  }
  PushButtonComponent.prototype.loadingText_61zpoe$ = function (value) {
    this.loadingText_1tku25$_0 = PushButtonComponent$loadingText$lambda(value);
  };
  function PushButtonComponent$loadingText$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function PushButtonComponent$loadingText$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, PushButtonComponent$loadingText$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PushButtonComponent.prototype.loadingText_p81yox$ = function (value) {
    this.loadingText_1tku25$_0 = PushButtonComponent$loadingText$lambda_0(value);
  };
  PushButtonComponent.prototype.loading_433wua$ = function (value) {
    this.loading_7mvz6i$_0 = value;
  };
  function PushButtonComponent$IconPlacement(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PushButtonComponent$IconPlacement_initFields() {
    PushButtonComponent$IconPlacement_initFields = function () {
    };
    PushButtonComponent$IconPlacement$Right_instance = new PushButtonComponent$IconPlacement('Right', 0);
    PushButtonComponent$IconPlacement$Left_instance = new PushButtonComponent$IconPlacement('Left', 1);
  }
  var PushButtonComponent$IconPlacement$Right_instance;
  function PushButtonComponent$IconPlacement$Right_getInstance() {
    PushButtonComponent$IconPlacement_initFields();
    return PushButtonComponent$IconPlacement$Right_instance;
  }
  var PushButtonComponent$IconPlacement$Left_instance;
  function PushButtonComponent$IconPlacement$Left_getInstance() {
    PushButtonComponent$IconPlacement_initFields();
    return PushButtonComponent$IconPlacement$Left_instance;
  }
  PushButtonComponent$IconPlacement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IconPlacement',
    interfaces: [Enum]
  };
  function PushButtonComponent$IconPlacement$values() {
    return [PushButtonComponent$IconPlacement$Right_getInstance(), PushButtonComponent$IconPlacement$Left_getInstance()];
  }
  PushButtonComponent$IconPlacement.values = PushButtonComponent$IconPlacement$values;
  function PushButtonComponent$IconPlacement$valueOf(name) {
    switch (name) {
      case 'Right':
        return PushButtonComponent$IconPlacement$Right_getInstance();
      case 'Left':
        return PushButtonComponent$IconPlacement$Left_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.buttons.PushButtonComponent.IconPlacement.' + name);
    }
  }
  PushButtonComponent$IconPlacement.valueOf_61zpoe$ = PushButtonComponent$IconPlacement$valueOf;
  function PushButtonComponent$IconPlacementContext() {
    this.right = PushButtonComponent$IconPlacement$Right_getInstance();
    this.left = PushButtonComponent$IconPlacement$Left_getInstance();
  }
  PushButtonComponent$IconPlacementContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IconPlacementContext',
    interfaces: []
  };
  function PushButtonComponent$render$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      switch (this$PushButtonComponent.variant.value(PushButtonComponent$VariantContext_getInstance()).name) {
        case 'SOLID':
          Theme.Companion.invoke().button.variants.solid($receiver, this$PushButtonComponent.type.value(Theme.Companion.invoke().button.types));
          break;
        case 'LINK':
          Theme.Companion.invoke().button.variants.link($receiver, this$PushButtonComponent.type.value(Theme.Companion.invoke().button.types));
          break;
        case 'OUTLINE':
          Theme.Companion.invoke().button.variants.outline($receiver, this$PushButtonComponent.type.value(Theme.Companion.invoke().button.types));
          break;
        case 'GHOST':
          Theme.Companion.invoke().button.variants.ghost($receiver, this$PushButtonComponent.type.value(Theme.Companion.invoke().button.types));
          break;
      }
      $receiver.invoke_qkhqzy$(this$PushButtonComponent.size.value(Theme.Companion.invoke().button.sizes));
      return Unit;
    };
  }
  function PushButtonComponent$render$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.disabled_f1igrw$(this$PushButtonComponent.disabled.values);
      if (this$PushButtonComponent.text_nkcgk1$_0 == null) {
        this$PushButtonComponent.renderIcon_zcrkp0$_0($receiver, this$PushButtonComponent.centerIconStyle, this$PushButtonComponent.centerSpinnerStyle);
      } else {
        if (this$PushButtonComponent.icon.value != null && this$PushButtonComponent.iconPlacement.value(PushButtonComponent$Companion_getInstance().iconPlacementContext) === PushButtonComponent$IconPlacement$Left_getInstance()) {
          this$PushButtonComponent.renderIcon_zcrkp0$_0($receiver, this$PushButtonComponent.leftIconStyle, this$PushButtonComponent.leftSpinnerStyle);
        }this$PushButtonComponent.renderText_cswvvm$_0($receiver);
        if (this$PushButtonComponent.icon.value != null && this$PushButtonComponent.iconPlacement.value(PushButtonComponent$Companion_getInstance().iconPlacementContext) === PushButtonComponent$IconPlacement$Right_getInstance()) {
          this$PushButtonComponent.renderIcon_zcrkp0$_0($receiver, this$PushButtonComponent.rightIconStyle, this$PushButtonComponent.rightSpinnerStyle);
        }}
      this$PushButtonComponent.events.value($receiver);
      this$PushButtonComponent.element.value($receiver);
      this$PushButtonComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  PushButtonComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    button(context, PushButtonComponent$render$lambda$lambda(this), styling, baseClass.plus_fox8kt$(PushButtonComponent$Companion_getInstance().staticCss), id, prefix, void 0, PushButtonComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  function PushButtonComponent$renderIcon$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.def.invoke_11rb$((tmp$ = this$PushButtonComponent.icon.value) != null ? tmp$(Theme.Companion.invoke().icons) : null);
      return Unit;
    };
  }
  function PushButtonComponent$renderIcon$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function PushButtonComponent$renderIcon$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.def.invoke_11rb$((tmp$ = this$PushButtonComponent.icon.value) != null ? tmp$(Theme.Companion.invoke().icons) : null);
      return Unit;
    };
  }
  function PushButtonComponent$renderIcon$lambda$lambda_0(closure$spinnerStyle, closure$iconStyle, this$PushButtonComponent) {
    return function ($receiver, running) {
      if (running) {
        spinner($receiver, closure$spinnerStyle, void 0, void 0, void 0, PushButtonComponent$renderIcon$lambda$lambda$lambda);
      } else {
        icon($receiver, closure$iconStyle, void 0, void 0, void 0, PushButtonComponent$renderIcon$lambda$lambda$lambda_0(this$PushButtonComponent));
      }
      return Unit;
    };
  }
  PushButtonComponent.prototype.renderIcon_zcrkp0$_0 = function (renderContext, iconStyle, spinnerStyle) {
    if (this.loading_7mvz6i$_0 == null) {
      icon(renderContext, iconStyle, void 0, void 0, void 0, PushButtonComponent$renderIcon$lambda$lambda(this));
    } else {
      var tmp$;
      (tmp$ = this.loading_7mvz6i$_0) != null ? (renderContext.render_a5p5o5$(tmp$, void 0, PushButtonComponent$renderIcon$lambda$lambda_0(spinnerStyle, iconStyle, this)), Unit) : null;
    }
  };
  function PushButtonComponent$renderText$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      if (this$PushButtonComponent.loadingText_1tku25$_0 == null) {
        $receiver.css_61zpoe$('position: absolute;');
        $receiver.invoke_qkhqzy$(this$PushButtonComponent.centerSpinnerStyle);
      } else
        $receiver.invoke_qkhqzy$(this$PushButtonComponent.leftSpinnerStyle);
      return Unit;
    };
  }
  function PushButtonComponent$renderText$lambda$lambda$lambda_0($receiver) {
    return Unit;
  }
  function PushButtonComponent$renderText$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver, running) {
      var tmp$, tmp$_0;
      if (running) {
        spinner($receiver, PushButtonComponent$renderText$lambda$lambda$lambda(this$PushButtonComponent), void 0, void 0, void 0, PushButtonComponent$renderText$lambda$lambda$lambda_0);
        if (this$PushButtonComponent.loadingText_1tku25$_0 != null) {
          ensureNotNull(this$PushButtonComponent.loadingText_1tku25$_0)($receiver);
        } else {
          (tmp$ = this$PushButtonComponent.text_nkcgk1$_0) != null ? tmp$($receiver, true) : null;
        }
      } else {
        (tmp$_0 = this$PushButtonComponent.text_nkcgk1$_0) != null ? tmp$_0($receiver, false) : null;
      }
      return Unit;
    };
  }
  PushButtonComponent.prototype.renderText_cswvvm$_0 = function (renderContext) {
    var tmp$;
    if (this.loading_7mvz6i$_0 == null || this.icon.value != null) {
      (tmp$ = this.text_nkcgk1$_0) != null ? tmp$(renderContext, false) : null;
    } else {
      var tmp$_0;
      (tmp$_0 = this.loading_7mvz6i$_0) != null ? (renderContext.render_a5p5o5$(tmp$_0, void 0, PushButtonComponent$renderText$lambda$lambda(this)), Unit) : null;
    }
  };
  Object.defineProperty(PushButtonComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_aqzi7i$_0.events;
    }
  });
  Object.defineProperty(PushButtonComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_aqzi7i$_1.element;
    }
  });
  Object.defineProperty(PushButtonComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_aqzi7i$_2.disabled;
    }
  });
  PushButtonComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_aqzi7i$_2.enabled_6taknv$(value);
  };
  PushButtonComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_aqzi7i$_2.enabled_433wua$(value);
  };
  Object.defineProperty(PushButtonComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_aqzi7i$_3.renderTooltip;
    }
  });
  PushButtonComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_aqzi7i$_3.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  PushButtonComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_aqzi7i$_3.tooltip_h43rbb$(text, build);
  };
  function PushButtonComponent$centerIconStyle$lambda$lambda($receiver) {
    return '1.5em';
  }
  function PushButtonComponent$centerIconStyle$lambda$lambda_0($receiver) {
    return '1.5em';
  }
  function PushButtonComponent$centerIconStyle$lambda($receiver) {
    $receiver.width_wpghq5$(PushButtonComponent$centerIconStyle$lambda$lambda);
    $receiver.height_wpghq5$(PushButtonComponent$centerIconStyle$lambda$lambda_0);
    return Unit;
  }
  function PushButtonComponent$centerSpinnerStyle$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_mp4jgc$_0;
    };
  }
  function PushButtonComponent$centerSpinnerStyle$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_mp4jgc$_0;
    };
  }
  function PushButtonComponent$centerSpinnerStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$centerSpinnerStyle$lambda$lambda(this$PushButtonComponent));
      $receiver.height_wpghq5$(PushButtonComponent$centerSpinnerStyle$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda_0($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_sp64pj$_0;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_lqysnc$_0;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.right_bcpvvc$(PushButtonComponent$leftSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftSpinnerStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$leftSpinnerStyle$lambda$lambda);
      $receiver.height_wpghq5$(PushButtonComponent$leftSpinnerStyle$lambda$lambda_0);
      $receiver.margins_ptb4s1$(PushButtonComponent$leftSpinnerStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda_0($receiver) {
    return '1.0em';
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_lqysnc$_0;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_sp64pj$_0;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.right_bcpvvc$(PushButtonComponent$rightSpinnerStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightSpinnerStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$rightSpinnerStyle$lambda$lambda);
      $receiver.height_wpghq5$(PushButtonComponent$rightSpinnerStyle$lambda$lambda_0);
      $receiver.margins_ptb4s1$(PushButtonComponent$rightSpinnerStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_mp4jgc$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_mp4jgc$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_sp64pj$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_lqysnc$_0;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(PushButtonComponent$leftIconStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.right_bcpvvc$(PushButtonComponent$leftIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$leftIconStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$leftIconStyle$lambda$lambda(this$PushButtonComponent));
      $receiver.height_wpghq5$(PushButtonComponent$leftIconStyle$lambda$lambda_0(this$PushButtonComponent));
      $receiver.margins_ptb4s1$(PushButtonComponent$leftIconStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_mp4jgc$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.iconSize_mp4jgc$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToBorder_sp64pj$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent) {
    return function ($receiver) {
      return this$PushButtonComponent.marginToText_lqysnc$_0;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda$lambda_1(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.right_bcpvvc$(PushButtonComponent$rightIconStyle$lambda$lambda$lambda(this$PushButtonComponent));
      $receiver.left_bcpvvc$(PushButtonComponent$rightIconStyle$lambda$lambda$lambda_0(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$rightIconStyle$lambda(this$PushButtonComponent) {
    return function ($receiver) {
      $receiver.width_wpghq5$(PushButtonComponent$rightIconStyle$lambda$lambda(this$PushButtonComponent));
      $receiver.height_wpghq5$(PushButtonComponent$rightIconStyle$lambda$lambda_0(this$PushButtonComponent));
      $receiver.margins_ptb4s1$(PushButtonComponent$rightIconStyle$lambda$lambda_1(this$PushButtonComponent));
      return Unit;
    };
  }
  function PushButtonComponent$type$lambda($receiver) {
    return Theme.Companion.invoke().button.types.primary;
  }
  function PushButtonComponent$variant$lambda($receiver) {
    return $receiver.solid;
  }
  function PushButtonComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().button.sizes.normal;
  }
  function PushButtonComponent$iconPlacement$lambda($receiver) {
    return PushButtonComponent$IconPlacement$Left_getInstance();
  }
  PushButtonComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PushButtonComponent',
    interfaces: [TooltipProperties, FormProperties, ElementProperties, EventProperties, Component]
  };
  function LinkButtonComponent() {
    PushButtonComponent.call(this);
    this.href_ty5ob1$_0 = LinkButtonComponent$href$lambda_1;
    this.target_cx311p$_0 = LinkButtonComponent$target$lambda_1;
  }
  function LinkButtonComponent$href$lambda(closure$value) {
    return function ($receiver) {
      $receiver.href_61zpoe$(closure$value);
      return Unit;
    };
  }
  LinkButtonComponent.prototype.href_61zpoe$ = function (value) {
    this.href_ty5ob1$_0 = LinkButtonComponent$href$lambda(value);
  };
  function LinkButtonComponent$href$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.href_p81yox$(closure$value);
      return Unit;
    };
  }
  LinkButtonComponent.prototype.href_p81yox$ = function (value) {
    this.href_ty5ob1$_0 = LinkButtonComponent$href$lambda_0(value);
  };
  function LinkButtonComponent$target$lambda(closure$value) {
    return function ($receiver) {
      $receiver.target_61zpoe$(closure$value);
      return Unit;
    };
  }
  LinkButtonComponent.prototype.target_61zpoe$ = function (value) {
    this.target_cx311p$_0 = LinkButtonComponent$target$lambda(value);
  };
  function LinkButtonComponent$target$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.target_p81yox$(closure$value);
      return Unit;
    };
  }
  LinkButtonComponent.prototype.target_p81yox$ = function (value) {
    this.target_cx311p$_0 = LinkButtonComponent$target$lambda_0(value);
  };
  function LinkButtonComponent$render$lambda$lambda(this$LinkButtonComponent, closure$styling, closure$baseClass, closure$id, closure$prefix) {
    return function ($receiver) {
      this$LinkButtonComponent.href_ty5ob1$_0($receiver);
      this$LinkButtonComponent.target_cx311p$_0($receiver);
      PushButtonComponent.prototype.render_3fp8sc$.call(this$LinkButtonComponent, $receiver, closure$styling, closure$baseClass, closure$id, closure$prefix);
      return Unit;
    };
  }
  LinkButtonComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    context.a_o5b0mg$(void 0, void 0, void 0, LinkButtonComponent$render$lambda$lambda(this, styling, baseClass, id, prefix));
    return Unit;
  };
  function LinkButtonComponent$href$lambda_1($receiver) {
    return Unit;
  }
  function LinkButtonComponent$target$lambda_1($receiver) {
    return Unit;
  }
  LinkButtonComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LinkButtonComponent',
    interfaces: [PushButtonComponent]
  };
  function card$lambda($receiver) {
    return Unit;
  }
  function card($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = card$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'card';
    var $receiver_0 = new CardComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function plus$lambda(this$plus, closure$other) {
    return function ($receiver) {
      this$plus($receiver);
      closure$other($receiver);
      return Unit;
    };
  }
  function CardComponent() {
    CardComponent$Companion_getInstance();
    this.size = new ComponentProperty(CardComponent$size$lambda);
    this.header = null;
    this.footer = null;
    this.content = null;
    this.type = new ComponentProperty(CardComponent$type$lambda);
  }
  function CardComponent$Companion() {
    CardComponent$Companion_instance = this;
    this.headerStylePrefix_0 = 'card-header';
    this.footerStylePrefix_0 = 'card-footer';
    this.contentStylePrefix_0 = 'card-content';
  }
  CardComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CardComponent$Companion_instance = null;
  function CardComponent$Companion_getInstance() {
    if (CardComponent$Companion_instance === null) {
      new CardComponent$Companion();
    }return CardComponent$Companion_instance;
  }
  function CardComponent$Sizes(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function CardComponent$Sizes_initFields() {
    CardComponent$Sizes_initFields = function () {
    };
    CardComponent$Sizes$SMALL_instance = new CardComponent$Sizes('SMALL', 0);
    CardComponent$Sizes$NORMAL_instance = new CardComponent$Sizes('NORMAL', 1);
    CardComponent$Sizes$LARGE_instance = new CardComponent$Sizes('LARGE', 2);
  }
  var CardComponent$Sizes$SMALL_instance;
  function CardComponent$Sizes$SMALL_getInstance() {
    CardComponent$Sizes_initFields();
    return CardComponent$Sizes$SMALL_instance;
  }
  var CardComponent$Sizes$NORMAL_instance;
  function CardComponent$Sizes$NORMAL_getInstance() {
    CardComponent$Sizes_initFields();
    return CardComponent$Sizes$NORMAL_instance;
  }
  var CardComponent$Sizes$LARGE_instance;
  function CardComponent$Sizes$LARGE_getInstance() {
    CardComponent$Sizes_initFields();
    return CardComponent$Sizes$LARGE_instance;
  }
  CardComponent$Sizes.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sizes',
    interfaces: [Enum]
  };
  function CardComponent$Sizes$values() {
    return [CardComponent$Sizes$SMALL_getInstance(), CardComponent$Sizes$NORMAL_getInstance(), CardComponent$Sizes$LARGE_getInstance()];
  }
  CardComponent$Sizes.values = CardComponent$Sizes$values;
  function CardComponent$Sizes$valueOf(name) {
    switch (name) {
      case 'SMALL':
        return CardComponent$Sizes$SMALL_getInstance();
      case 'NORMAL':
        return CardComponent$Sizes$NORMAL_getInstance();
      case 'LARGE':
        return CardComponent$Sizes$LARGE_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.card.CardComponent.Sizes.' + name);
    }
  }
  CardComponent$Sizes.valueOf_61zpoe$ = CardComponent$Sizes$valueOf;
  function CardComponent$SizesContext() {
    CardComponent$SizesContext_instance = this;
    this.small = CardComponent$Sizes$SMALL_getInstance();
    this.normal = CardComponent$Sizes$NORMAL_getInstance();
    this.large = CardComponent$Sizes$LARGE_getInstance();
  }
  CardComponent$SizesContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SizesContext',
    interfaces: []
  };
  var CardComponent$SizesContext_instance = null;
  function CardComponent$SizesContext_getInstance() {
    if (CardComponent$SizesContext_instance === null) {
      new CardComponent$SizesContext();
    }return CardComponent$SizesContext_instance;
  }
  function CardComponent$CardSection(styling, value) {
    if (styling === void 0)
      styling = CardComponent$CardComponent$CardSection_init$lambda;
    this.styling = styling;
    this.value = value;
  }
  function CardComponent$CardComponent$CardSection_init$lambda($receiver) {
    return Unit;
  }
  CardComponent$CardSection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CardSection',
    interfaces: []
  };
  CardComponent$CardSection.prototype.component1 = function () {
    return this.styling;
  };
  CardComponent$CardSection.prototype.component2 = function () {
    return this.value;
  };
  CardComponent$CardSection.prototype.copy_hn5ufr$ = function (styling, value) {
    return new CardComponent$CardSection(styling === void 0 ? this.styling : styling, value === void 0 ? this.value : value);
  };
  CardComponent$CardSection.prototype.toString = function () {
    return 'CardSection(styling=' + Kotlin.toString(this.styling) + (', value=' + Kotlin.toString(this.value)) + ')';
  };
  CardComponent$CardSection.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.styling) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  CardComponent$CardSection.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.styling, other.styling) && Kotlin.equals(this.value, other.value)))));
  };
  function CardComponent$header$lambda($receiver) {
    return Unit;
  }
  CardComponent.prototype.header_hn5ufr$ = function (styling, value) {
    if (styling === void 0)
      styling = CardComponent$header$lambda;
    this.header = new CardComponent$CardSection(styling, value);
  };
  CardComponent.prototype.header_61zpoe$ = function (value) {
    this.header_p81yox$(flowOf(value));
  };
  function CardComponent$header$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function CardComponent$header$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, CardComponent$header$lambda$lambda(closure$value));
      return Unit;
    };
  }
  CardComponent.prototype.header_p81yox$ = function (value) {
    this.header = new CardComponent$CardSection(void 0, CardComponent$header$lambda_0(value));
  };
  function CardComponent$footer$lambda($receiver) {
    return Unit;
  }
  CardComponent.prototype.footer_hn5ufr$ = function (styling, value) {
    if (styling === void 0)
      styling = CardComponent$footer$lambda;
    this.footer = new CardComponent$CardSection(styling, value);
  };
  CardComponent.prototype.footer_61zpoe$ = function (value) {
    this.footer_p81yox$(flowOf(value));
  };
  function CardComponent$footer$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function CardComponent$footer$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, CardComponent$footer$lambda$lambda(closure$value));
      return Unit;
    };
  }
  CardComponent.prototype.footer_p81yox$ = function (value) {
    this.footer = new CardComponent$CardSection(void 0, CardComponent$footer$lambda_0(value));
  };
  function CardComponent$content$lambda($receiver) {
    return Unit;
  }
  CardComponent.prototype.content_hn5ufr$ = function (styling, value) {
    if (styling === void 0)
      styling = CardComponent$content$lambda;
    this.content = new CardComponent$CardSection(styling, value);
  };
  CardComponent.prototype.content_61zpoe$ = function (value) {
    this.content_p81yox$(flowOf(value));
  };
  function CardComponent$content$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function CardComponent$content$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, CardComponent$content$lambda$lambda(closure$value));
      return Unit;
    };
  }
  CardComponent.prototype.content_p81yox$ = function (value) {
    this.content = new CardComponent$CardSection(void 0, CardComponent$content$lambda_0(value));
  };
  function CardComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      var tmp$;
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function CardComponent$render$lambda$lambda$lambda(this$CardComponent) {
    return function ($receiver) {
      switch (this$CardComponent.size.value(CardComponent$SizesContext_getInstance()).name) {
        case 'SMALL':
          return PaperComponent$Sizes$SMALL_getInstance();
        case 'NORMAL':
          return PaperComponent$Sizes$NORMAL_getInstance();
        case 'LARGE':
          return PaperComponent$Sizes$LARGE_getInstance();
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function CardComponent$render$lambda$lambda$lambda_0(this$CardComponent) {
    return function ($receiver) {
      return this$CardComponent.type.value(PaperComponent$TypesContext_getInstance());
    };
  }
  function CardComponent$render$lambda$lambda$lambda$lambda(this$CardComponent) {
    return function ($receiver) {
      var tmp$;
      switch (this$CardComponent.size.value(CardComponent$SizesContext_getInstance()).name) {
        case 'SMALL':
          tmp$ = Theme.Companion.invoke().card.sizes.small;
          break;
        case 'NORMAL':
          tmp$ = Theme.Companion.invoke().card.sizes.normal;
          break;
        case 'LARGE':
          tmp$ = Theme.Companion.invoke().card.sizes.large;
          break;
        default:tmp$ = Kotlin.noWhenBranchMatched();
          break;
      }
      $receiver.invoke_4my6up$(tmp$);
      return Unit;
    };
  }
  function CardComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      closure$it.value($receiver);
      return Unit;
    };
  }
  function CardComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      closure$it.value($receiver);
      return Unit;
    };
  }
  function CardComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_1(closure$it) {
    return function ($receiver) {
      closure$it.value($receiver);
      return Unit;
    };
  }
  function CardComponent$render$lambda$lambda$lambda$lambda_0(this$CardComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      if ((tmp$ = this$CardComponent.header) != null) {
        header($receiver, plus$lambda(Theme.Companion.invoke().card.header, tmp$.styling), void 0, void 0, CardComponent$Companion_getInstance().headerStylePrefix_0, void 0, CardComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(tmp$));
      }if ((tmp$_0 = this$CardComponent.content) != null) {
        section($receiver, plus$lambda(Theme.Companion.invoke().card.content, tmp$_0.styling), void 0, void 0, CardComponent$Companion_getInstance().contentStylePrefix_0, void 0, CardComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(tmp$_0));
      }if ((tmp$_1 = this$CardComponent.footer) != null) {
        footer($receiver, plus$lambda(Theme.Companion.invoke().card.footer, tmp$_1.styling), void 0, void 0, CardComponent$Companion_getInstance().footerStylePrefix_0, void 0, CardComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_1(tmp$_1));
      }return Unit;
    };
  }
  function CardComponent$render$lambda$lambda$lambda_1(this$CardComponent) {
    return function ($receiver) {
      div($receiver, CardComponent$render$lambda$lambda$lambda$lambda(this$CardComponent), void 0, void 0, void 0, void 0, CardComponent$render$lambda$lambda$lambda$lambda_0(this$CardComponent));
      return Unit;
    };
  }
  function CardComponent$render$lambda$lambda_0(this$CardComponent) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(CardComponent$render$lambda$lambda$lambda(this$CardComponent));
      $receiver.type.invoke_11rb$(CardComponent$render$lambda$lambda$lambda_0(this$CardComponent));
      $receiver.content_hn5ufr$(void 0, CardComponent$render$lambda$lambda$lambda_1(this$CardComponent));
      return Unit;
    };
  }
  CardComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    paper(context, CardComponent$render$lambda$lambda(styling), baseClass, id, prefix, CardComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  function CardComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function CardComponent$type$lambda($receiver) {
    return $receiver.normal;
  }
  CardComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CardComponent',
    interfaces: [Component]
  };
  function checkbox$lambda($receiver) {
    return Unit;
  }
  function checkbox$lambda_0($receiver) {
    return Unit;
  }
  function checkbox($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = checkbox$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'checkboxComponent';
    if (build === void 0)
      build = checkbox$lambda_0;
    var $receiver_0 = new CheckboxComponent(value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function checkboxGroup$lambda($receiver) {
    return Unit;
  }
  function checkboxGroup$lambda_0($receiver) {
    return Unit;
  }
  function checkboxGroup($receiver, styling, items, values, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = checkboxGroup$lambda;
    if (values === void 0)
      values = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'checkboxGroupComponent';
    if (build === void 0)
      build = checkboxGroup$lambda_0;
    var $receiver_0 = new CheckboxGroupComponent(items, values);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$.prototype.constructor = Coroutine$collect_42ocv1$;
  Coroutine$collect_42ocv1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda;
  Coroutine$unsafeTransform$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
  Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda.prototype.constructor = Coroutine$map$lambda;
  Coroutine$map$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function CheckboxGroupComponent(items, values) {
    CheckboxGroupComponent$Companion_getInstance();
    this.items = items;
    this.values = values;
    this.$delegate_unqj2k$_0 = new InputFormMixin();
    this.$delegate_unqj2k$_1 = new SeverityMixin();
    this.$delegate_unqj2k$_2 = new OrientationMixin(Orientation$VERTICAL_getInstance());
    this.$delegate_unqj2k$_3 = new TooltipMixin();
    this.icon = new ComponentProperty(CheckboxGroupComponent$icon$lambda);
    this.label = new ComponentProperty(CheckboxGroupComponent$label$lambda);
    this.labelRendering = new ComponentProperty(CheckboxGroupComponent$labelRendering$lambda(this));
    this.size = new ComponentProperty(CheckboxGroupComponent$size$lambda);
    this.itemStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.default);
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.label);
    this.checkedStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.checked);
    this.selectedItems = new DynamicComponentProperty(flowOf(emptyList()));
    this.events = new ComponentProperty(CheckboxGroupComponent$events$lambda);
  }
  function CheckboxGroupComponent$Companion() {
    CheckboxGroupComponent$Companion_instance = this;
  }
  function CheckboxGroupComponent$Companion$layoutOf$lambda$lambda(closure$orientation) {
    return function ($receiver) {
      switch (closure$orientation.name) {
        case 'HORIZONTAL':
          return $receiver.inlineFlex;
        case 'VERTICAL':
          return $receiver.inlineGrid;
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function CheckboxGroupComponent$Companion$layoutOf$lambda(closure$orientation) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(CheckboxGroupComponent$Companion$layoutOf$lambda$lambda(closure$orientation));
      return Unit;
    };
  }
  CheckboxGroupComponent$Companion.prototype.layoutOf_spnxqo$ = function (orientation) {
    return CheckboxGroupComponent$Companion$layoutOf$lambda(orientation);
  };
  CheckboxGroupComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CheckboxGroupComponent$Companion_instance = null;
  function CheckboxGroupComponent$Companion_getInstance() {
    if (CheckboxGroupComponent$Companion_instance === null) {
      new CheckboxGroupComponent$Companion();
    }return CheckboxGroupComponent$Companion_instance;
  }
  function CheckboxGroupComponent$EventsContext(element, selected) {
    this.element_0 = element;
    this.selected = selected;
  }
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'aborts', {
    configurable: true,
    get: function () {
      return this.element_0.aborts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'afterprints', {
    configurable: true,
    get: function () {
      return this.element_0.afterprints;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'beforeprints', {
    configurable: true,
    get: function () {
      return this.element_0.beforeprints;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'beforeunloads', {
    configurable: true,
    get: function () {
      return this.element_0.beforeunloads;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'blurs', {
    configurable: true,
    get: function () {
      return this.element_0.blurs;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'canplays', {
    configurable: true,
    get: function () {
      return this.element_0.canplays;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'canplaythroughs', {
    configurable: true,
    get: function () {
      return this.element_0.canplaythroughs;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'changes', {
    configurable: true,
    get: function () {
      return this.element_0.changes;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'clicks', {
    configurable: true,
    get: function () {
      return this.element_0.clicks;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'contextmenus', {
    configurable: true,
    get: function () {
      return this.element_0.contextmenus;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'copys', {
    configurable: true,
    get: function () {
      return this.element_0.copys;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'cuts', {
    configurable: true,
    get: function () {
      return this.element_0.cuts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'dblclicks', {
    configurable: true,
    get: function () {
      return this.element_0.dblclicks;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'domNode', {
    configurable: true,
    get: function () {
      return this.element_0.domNode;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'dragends', {
    configurable: true,
    get: function () {
      return this.element_0.dragends;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'dragenters', {
    configurable: true,
    get: function () {
      return this.element_0.dragenters;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'dragleaves', {
    configurable: true,
    get: function () {
      return this.element_0.dragleaves;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'dragovers', {
    configurable: true,
    get: function () {
      return this.element_0.dragovers;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'drags', {
    configurable: true,
    get: function () {
      return this.element_0.drags;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'dragstarts', {
    configurable: true,
    get: function () {
      return this.element_0.dragstarts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'drops', {
    configurable: true,
    get: function () {
      return this.element_0.drops;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'durationchanges', {
    configurable: true,
    get: function () {
      return this.element_0.durationchanges;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'endeds', {
    configurable: true,
    get: function () {
      return this.element_0.endeds;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'focusins', {
    configurable: true,
    get: function () {
      return this.element_0.focusins;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'focusouts', {
    configurable: true,
    get: function () {
      return this.element_0.focusouts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'focuss', {
    configurable: true,
    get: function () {
      return this.element_0.focuss;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'fullscreenchanges', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenchanges;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'fullscreenerrors', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenerrors;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'hashchanges', {
    configurable: true,
    get: function () {
      return this.element_0.hashchanges;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'inputs', {
    configurable: true,
    get: function () {
      return this.element_0.inputs;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'invalids', {
    configurable: true,
    get: function () {
      return this.element_0.invalids;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'job', {
    configurable: true,
    get: function () {
      return this.element_0.job;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'keydowns', {
    configurable: true,
    get: function () {
      return this.element_0.keydowns;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'keypresss', {
    configurable: true,
    get: function () {
      return this.element_0.keypresss;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'keyups', {
    configurable: true,
    get: function () {
      return this.element_0.keyups;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'loadeddatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadeddatas;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'loadedmetadatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadedmetadatas;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'loads', {
    configurable: true,
    get: function () {
      return this.element_0.loads;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'loadstarts', {
    configurable: true,
    get: function () {
      return this.element_0.loadstarts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'messages', {
    configurable: true,
    get: function () {
      return this.element_0.messages;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mousedowns', {
    configurable: true,
    get: function () {
      return this.element_0.mousedowns;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mouseenters', {
    configurable: true,
    get: function () {
      return this.element_0.mouseenters;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mouseleaves', {
    configurable: true,
    get: function () {
      return this.element_0.mouseleaves;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mousemoves', {
    configurable: true,
    get: function () {
      return this.element_0.mousemoves;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mouseouts', {
    configurable: true,
    get: function () {
      return this.element_0.mouseouts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mouseovers', {
    configurable: true,
    get: function () {
      return this.element_0.mouseovers;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'mouseups', {
    configurable: true,
    get: function () {
      return this.element_0.mouseups;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'offlines', {
    configurable: true,
    get: function () {
      return this.element_0.offlines;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'onlines', {
    configurable: true,
    get: function () {
      return this.element_0.onlines;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'opens', {
    configurable: true,
    get: function () {
      return this.element_0.opens;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'pagehides', {
    configurable: true,
    get: function () {
      return this.element_0.pagehides;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'pageshows', {
    configurable: true,
    get: function () {
      return this.element_0.pageshows;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'pastes', {
    configurable: true,
    get: function () {
      return this.element_0.pastes;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'pauses', {
    configurable: true,
    get: function () {
      return this.element_0.pauses;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'playings', {
    configurable: true,
    get: function () {
      return this.element_0.playings;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'plays', {
    configurable: true,
    get: function () {
      return this.element_0.plays;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'popstates', {
    configurable: true,
    get: function () {
      return this.element_0.popstates;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'progresss', {
    configurable: true,
    get: function () {
      return this.element_0.progresss;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'ratechanges', {
    configurable: true,
    get: function () {
      return this.element_0.ratechanges;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'resets', {
    configurable: true,
    get: function () {
      return this.element_0.resets;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'resizes', {
    configurable: true,
    get: function () {
      return this.element_0.resizes;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'scrolls', {
    configurable: true,
    get: function () {
      return this.element_0.scrolls;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'searchs', {
    configurable: true,
    get: function () {
      return this.element_0.searchs;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'seekeds', {
    configurable: true,
    get: function () {
      return this.element_0.seekeds;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'seekings', {
    configurable: true,
    get: function () {
      return this.element_0.seekings;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'selects', {
    configurable: true,
    get: function () {
      return this.element_0.selects;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'shows', {
    configurable: true,
    get: function () {
      return this.element_0.shows;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'stalleds', {
    configurable: true,
    get: function () {
      return this.element_0.stalleds;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'storages', {
    configurable: true,
    get: function () {
      return this.element_0.storages;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'submits', {
    configurable: true,
    get: function () {
      return this.element_0.submits;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'suspends', {
    configurable: true,
    get: function () {
      return this.element_0.suspends;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'timeupdates', {
    configurable: true,
    get: function () {
      return this.element_0.timeupdates;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'toggles', {
    configurable: true,
    get: function () {
      return this.element_0.toggles;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'touchcancels', {
    configurable: true,
    get: function () {
      return this.element_0.touchcancels;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'touchends', {
    configurable: true,
    get: function () {
      return this.element_0.touchends;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'touchmoves', {
    configurable: true,
    get: function () {
      return this.element_0.touchmoves;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'touchstarts', {
    configurable: true,
    get: function () {
      return this.element_0.touchstarts;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'unloads', {
    configurable: true,
    get: function () {
      return this.element_0.unloads;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'volumechanges', {
    configurable: true,
    get: function () {
      return this.element_0.volumechanges;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'waitings', {
    configurable: true,
    get: function () {
      return this.element_0.waitings;
    }
  });
  Object.defineProperty(CheckboxGroupComponent$EventsContext.prototype, 'wheels', {
    configurable: true,
    get: function () {
      return this.element_0.wheels;
    }
  });
  CheckboxGroupComponent$EventsContext.prototype.handledBy_jora5j$ = function ($receiver, handler) {
    return this.element_0.handledBy_jora5j$($receiver, handler);
  };
  CheckboxGroupComponent$EventsContext.prototype.handledBy_lesqyu$ = function ($receiver, execute) {
    return this.element_0.handledBy_lesqyu$($receiver, execute);
  };
  CheckboxGroupComponent$EventsContext.prototype.handledBy_hlmqex$ = function ($receiver, handler) {
    return this.element_0.handledBy_hlmqex$($receiver, handler);
  };
  CheckboxGroupComponent$EventsContext.prototype.handledBy_uhegz2$ = function ($receiver, execute) {
    return this.element_0.handledBy_uhegz2$($receiver, execute);
  };
  CheckboxGroupComponent$EventsContext.prototype.handledBy_ytah3h$ = function ($receiver, handler) {
    return this.element_0.handledBy_ytah3h$($receiver, handler);
  };
  CheckboxGroupComponent$EventsContext.prototype.handledBy_706ovd$ = function ($receiver, execute) {
    return this.element_0.handledBy_706ovd$($receiver, execute);
  };
  CheckboxGroupComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: [EventContext]
  };
  function CheckboxGroupComponent$render$lambda$lambda(this$CheckboxGroupComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(CheckboxGroupComponent$Companion_getInstance().layoutOf_spnxqo$(this$CheckboxGroupComponent.orientation.value(OrientationContext_getInstance())));
      return Unit;
    };
  }
  function Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$item = closure$item_0;
    this.local$it = it_0;
  }
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.contains_11rb$(this.local$closure$item);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(closure$item_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$CheckboxGroupComponent) {
    return function ($receiver) {
      return this$CheckboxGroupComponent.size.value(Theme.Companion.invoke().checkbox.sizes);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent) {
    return function ($receiver) {
      return this$CheckboxGroupComponent.icon.value(Theme.Companion.invoke().icons);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_1(this$CheckboxGroupComponent, closure$item) {
    return function ($receiver) {
      this$CheckboxGroupComponent.labelRendering.value($receiver, closure$item);
      return Unit;
    };
  }
  function Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$item = closure$item_0;
  }
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$item;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_2(closure$item, closure$multiSelectionStore) {
    return function ($receiver) {
      var $receiver_0 = states($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$item)), $receiver_0)), closure$multiSelectionStore.toggle);
      return Unit;
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent, closure$item, closure$checkedFlow, closure$multiSelectionStore) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$CheckboxGroupComponent));
      $receiver.icon.invoke_11rb$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent));
      $receiver.labelStyle.invoke_11rb$(this$CheckboxGroupComponent.labelStyle.value);
      $receiver.checkedStyle.invoke_11rb$(this$CheckboxGroupComponent.checkedStyle.value);
      $receiver.label_9c978p$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_1(this$CheckboxGroupComponent, closure$item));
      $receiver.checked.invoke_ror2s8$(closure$checkedFlow);
      $receiver.disabled.invoke_ror2s8$(this$CheckboxGroupComponent.disabled.values);
      $receiver.severity.invoke_ror2s8$(this$CheckboxGroupComponent.severity.values);
      $receiver.events.invoke_11rb$(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda$lambda_2(closure$item, closure$multiSelectionStore));
      return Unit;
    };
  }
  function CheckboxGroupComponent$render$lambda$lambda_0(this$CheckboxGroupComponent, closure$multiSelectionStore, closure$grpId) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      $receiver.handledBy_ytah3h$((tmp$_0 = (tmp$ = this$CheckboxGroupComponent.values) != null ? tmp$.data : null) != null ? tmp$_0 : this$CheckboxGroupComponent.selectedItems.values, closure$multiSelectionStore.update);
      var $receiver_0 = this$CheckboxGroupComponent.items;
      var tmp$_1;
      tmp$_1 = $receiver_0.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        var closure$multiSelectionStore_0 = closure$multiSelectionStore;
        var this$CheckboxGroupComponent_0 = this$CheckboxGroupComponent;
        var closure$grpId_0 = closure$grpId;
        var $receiver_1 = closure$multiSelectionStore_0.data;
        var checkedFlow = distinctUntilChanged(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(CheckboxGroupComponent$render$lambda$lambda$lambda$lambda(element)), $receiver_1)));
        checkbox($receiver, this$CheckboxGroupComponent_0.itemStyle.value, void 0, void 0, closure$grpId_0 + '-grp-item-' + identification.Id.next_za3lpa$(), void 0, CheckboxGroupComponent$render$lambda$lambda$lambda$lambda_0(this$CheckboxGroupComponent_0, element, checkedFlow, closure$multiSelectionStore_0));
      }
      var $receiver_2 = new CheckboxGroupComponent$EventsContext($receiver, closure$multiSelectionStore.toggle);
      var this$CheckboxGroupComponent_1 = this$CheckboxGroupComponent;
      var tmp$_2;
      this$CheckboxGroupComponent_1.events.value($receiver_2);
      if ((tmp$_2 = this$CheckboxGroupComponent_1.values) != null) {
        $receiver_2.handledBy_ytah3h$($receiver_2.selected, tmp$_2.update);
      }this$CheckboxGroupComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  CheckboxGroupComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var multiSelectionStore = new MultiSelectionStore();
    var grpId = id != null ? id : identification.Id.next_za3lpa$();
    return div_0(context, CheckboxGroupComponent$render$lambda$lambda(this), styling, baseClass, id, prefix, void 0, CheckboxGroupComponent$render$lambda$lambda_0(this, multiSelectionStore, grpId));
  };
  Object.defineProperty(CheckboxGroupComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_unqj2k$_0.disabled;
    }
  });
  Object.defineProperty(CheckboxGroupComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_unqj2k$_0.readonly;
    }
  });
  CheckboxGroupComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_unqj2k$_0.enabled_6taknv$(value);
  };
  CheckboxGroupComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_unqj2k$_0.enabled_433wua$(value);
  };
  Object.defineProperty(CheckboxGroupComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_unqj2k$_1.severity;
    }
  });
  CheckboxGroupComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_unqj2k$_1.severity_ietawi$(value);
  };
  CheckboxGroupComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_unqj2k$_1.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(CheckboxGroupComponent.prototype, 'orientation', {
    configurable: true,
    get: function () {
      return this.$delegate_unqj2k$_2.orientation;
    }
  });
  Object.defineProperty(CheckboxGroupComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_unqj2k$_3.renderTooltip;
    }
  });
  CheckboxGroupComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_unqj2k$_3.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  CheckboxGroupComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_unqj2k$_3.tooltip_h43rbb$(text, build);
  };
  function CheckboxGroupComponent$icon$lambda($receiver) {
    return Theme.Companion.invoke().icons.check;
  }
  function CheckboxGroupComponent$label$lambda(it) {
    return toString(it);
  }
  function CheckboxGroupComponent$labelRendering$lambda$lambda(this$CheckboxGroupComponent, closure$it) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$CheckboxGroupComponent.label.value(closure$it));
      return Unit;
    };
  }
  function CheckboxGroupComponent$labelRendering$lambda(this$CheckboxGroupComponent) {
    return function ($receiver, it) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, CheckboxGroupComponent$labelRendering$lambda$lambda(this$CheckboxGroupComponent, it));
      return Unit;
    };
  }
  function CheckboxGroupComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().checkbox.sizes.normal;
  }
  function CheckboxGroupComponent$events$lambda($receiver) {
    return Unit;
  }
  CheckboxGroupComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CheckboxGroupComponent',
    interfaces: [TooltipProperties, OrientationProperty, SeverityProperties, InputFormProperties, Component]
  };
  function CheckboxComponent(value) {
    CheckboxComponent$Companion_getInstance();
    this.value = value;
    this.$delegate_kwoj8v$_0 = new EventMixin();
    this.$delegate_kwoj8v$_1 = new ElementMixin();
    this.$delegate_kwoj8v$_2 = new InputFormMixin();
    this.$delegate_kwoj8v$_3 = new SeverityMixin();
    this.$delegate_kwoj8v$_4 = new TooltipMixin();
    this.size = new ComponentProperty(CheckboxComponent$size$lambda);
    this.icon = new ComponentProperty(CheckboxComponent$icon$lambda);
    this.label_h9zh7$_0 = null;
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.label);
    this.checked = new DynamicComponentProperty(flowOf(false));
    this.checkedStyle = new ComponentProperty(Theme.Companion.invoke().checkbox.checked);
  }
  function CheckboxComponent$Companion() {
    CheckboxComponent$Companion_instance = this;
    this.checkboxInputStaticCss = staticStyle_0('checkbox', '\n            position: absolute;\n            border: 0px;\n            clip: rect(0px, 0px, 0px, 0px);\n            height: 0px;\n            width: 0px;\n            overflow: hidden;\n            white-space: nowrap;\n            outline: none;\n            &:focus{\n                outline: none;\n            }           \n            ');
  }
  CheckboxComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CheckboxComponent$Companion_instance = null;
  function CheckboxComponent$Companion_getInstance() {
    if (CheckboxComponent$Companion_instance === null) {
      new CheckboxComponent$Companion();
    }return CheckboxComponent$Companion_instance;
  }
  function CheckboxComponent$label$lambda$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  function CheckboxComponent$label$lambda(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, CheckboxComponent$label$lambda$lambda(closure$value));
      return Unit;
    };
  }
  CheckboxComponent.prototype.label_61zpoe$ = function (value) {
    this.label_h9zh7$_0 = CheckboxComponent$label$lambda(value);
  };
  function CheckboxComponent$label$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function CheckboxComponent$label$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.span_dzf5a3$(void 0, void 0, void 0, CheckboxComponent$label$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  CheckboxComponent.prototype.label_p81yox$ = function (value) {
    this.label_h9zh7$_0 = CheckboxComponent$label$lambda_0(value);
  };
  CheckboxComponent.prototype.label_9c978p$ = function (value) {
    this.label_h9zh7$_0 = value;
  };
  function CheckboxComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.inlineFlex;
  }
  function CheckboxComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.center;
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function CheckboxComponent$render$lambda$lambda$lambda_1($receiver) {
    $receiver.relative_dkjn9d$(CheckboxComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function CheckboxComponent$render$lambda$lambda(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(CheckboxComponent$render$lambda$lambda$lambda);
      $receiver.alignItems_tsd917$(CheckboxComponent$render$lambda$lambda$lambda_0);
      $receiver.invoke_qkhqzy$(this$CheckboxComponent.size.value(Theme.Companion.invoke().checkbox.sizes));
      $receiver.position_wp9r2r$(CheckboxComponent$render$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_0(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CheckboxComponent.checkedStyle.value);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_2(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().checkbox.input);
      $receiver.children_qlrppv$('&[checked] + div', CheckboxComponent$render$lambda$lambda$lambda$lambda_0(this$CheckboxComponent));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_3(this$CheckboxComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.disabled_f1igrw$(this$CheckboxComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$CheckboxComponent.readonly.values);
      $receiver.type_61zpoe$('checkbox');
      $receiver.checked_f1igrw$((tmp$_0 = (tmp$ = this$CheckboxComponent.value) != null ? tmp$.data : null) != null ? tmp$_0 : this$CheckboxComponent.checked.values);
      $receiver.className_p81yox$(get_name(this$CheckboxComponent.severityClassOf_i6436e$(Theme.Companion.invoke().checkbox.severity)));
      if ((tmp$_1 = this$CheckboxComponent.value) != null) {
        $receiver.handledBy_ytah3h$(states($receiver.changes), tmp$_1.update);
      }this$CheckboxComponent.events.value($receiver);
      this$CheckboxComponent.element.value($receiver);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_4(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().checkbox.default);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().checkbox.icon);
    return Unit;
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_2(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(this$CheckboxComponent.icon.value(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda_5(this$CheckboxComponent) {
    return function ($receiver) {
      icon($receiver, CheckboxComponent$render$lambda$lambda$lambda$lambda_1, void 0, void 0, void 0, CheckboxComponent$render$lambda$lambda$lambda$lambda_2(this$CheckboxComponent));
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_3(this$CheckboxComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CheckboxComponent.labelStyle.value);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda$lambda$lambda_4(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function CheckboxComponent$render$lambda$lambda_0(closure$id, this$CheckboxComponent, closure$prefix, closure$styling) {
    return function ($receiver) {
      var tmp$;
      if (closure$id != null)
        $receiver.for_61zpoe$(closure$id);
      input($receiver, CheckboxComponent$render$lambda$lambda$lambda_2(this$CheckboxComponent), CheckboxComponent$Companion_getInstance().checkboxInputStaticCss, closure$id, closure$prefix, void 0, CheckboxComponent$render$lambda$lambda$lambda_3(this$CheckboxComponent));
      div($receiver, CheckboxComponent$render$lambda$lambda$lambda_4(closure$styling), void 0, void 0, void 0, void 0, CheckboxComponent$render$lambda$lambda$lambda_5(this$CheckboxComponent));
      if ((tmp$ = this$CheckboxComponent.label_h9zh7$_0) != null) {
        div($receiver, CheckboxComponent$render$lambda$lambda$lambda$lambda_3(this$CheckboxComponent), void 0, void 0, void 0, void 0, CheckboxComponent$render$lambda$lambda$lambda$lambda_4(tmp$));
      }this$CheckboxComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  CheckboxComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    return label(context, CheckboxComponent$render$lambda$lambda(this), baseClass, void 0, prefix, void 0, CheckboxComponent$render$lambda$lambda_0(id, this, prefix, styling));
  };
  Object.defineProperty(CheckboxComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_kwoj8v$_0.events;
    }
  });
  Object.defineProperty(CheckboxComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_kwoj8v$_1.element;
    }
  });
  Object.defineProperty(CheckboxComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_kwoj8v$_2.disabled;
    }
  });
  Object.defineProperty(CheckboxComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_kwoj8v$_2.readonly;
    }
  });
  CheckboxComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_kwoj8v$_2.enabled_6taknv$(value);
  };
  CheckboxComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_kwoj8v$_2.enabled_433wua$(value);
  };
  Object.defineProperty(CheckboxComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_kwoj8v$_3.severity;
    }
  });
  CheckboxComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_kwoj8v$_3.severity_ietawi$(value);
  };
  CheckboxComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_kwoj8v$_3.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(CheckboxComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_kwoj8v$_4.renderTooltip;
    }
  });
  CheckboxComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_kwoj8v$_4.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  CheckboxComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_kwoj8v$_4.tooltip_h43rbb$(text, build);
  };
  function CheckboxComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().checkbox.sizes.normal;
  }
  function CheckboxComponent$icon$lambda($receiver) {
    return Theme.Companion.invoke().icons.check;
  }
  CheckboxComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CheckboxComponent',
    interfaces: [TooltipProperties, SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function dataTable$lambda($receiver) {
    return Unit;
  }
  function dataTable$lambda_0($receiver) {
    return Unit;
  }
  function dataTable($receiver, styling, rows, rowIdProvider, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = dataTable$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = DataTableComponent$Companion_getInstance().prefix;
    if (build === void 0)
      build = dataTable$lambda_0;
    var $receiver_0 = new DataTableComponent(rows, rowIdProvider);
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function dataTable$lambda_1($receiver) {
    return Unit;
  }
  function dataTable$lambda_2($receiver) {
    return Unit;
  }
  function dataTable$lambda$lambda$lambda(closure$selection) {
    return function ($receiver) {
      $receiver.store.invoke_11rb$(closure$selection);
      return Unit;
    };
  }
  function dataTable$lambda$lambda(closure$selection) {
    return function ($receiver) {
      $receiver.multi_80fo8$(dataTable$lambda$lambda$lambda(closure$selection));
      return Unit;
    };
  }
  function dataTable_0($receiver, styling, rows, rowIdProvider, selection, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = dataTable$lambda_1;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = DataTableComponent$Companion_getInstance().prefix;
    if (build === void 0)
      build = dataTable$lambda_2;
    var $receiver_0 = new DataTableComponent(rows, rowIdProvider);
    build($receiver_0);
    $receiver_0.selection_5o6y5j$(dataTable$lambda$lambda(selection));
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function dataTable$lambda_3($receiver) {
    return Unit;
  }
  function dataTable$lambda_4($receiver) {
    return Unit;
  }
  function dataTable$lambda$lambda$lambda_0(closure$selection) {
    return function ($receiver) {
      $receiver.store.invoke_11rb$(closure$selection);
      return Unit;
    };
  }
  function dataTable$lambda$lambda_0(closure$selection) {
    return function ($receiver) {
      $receiver.single_2kq2rf$(dataTable$lambda$lambda$lambda_0(closure$selection));
      return Unit;
    };
  }
  function dataTable_1($receiver, styling, rows, rowIdProvider, selection, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = dataTable$lambda_3;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = DataTableComponent$Companion_getInstance().prefix;
    if (build === void 0)
      build = dataTable$lambda_4;
    var $receiver_0 = new DataTableComponent(rows, rowIdProvider);
    build($receiver_0);
    $receiver_0.selection_5o6y5j$(dataTable$lambda$lambda_0(selection));
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_0(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_0($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_0.prototype.constructor = Coroutine$collect_42ocv1$_0;
  Coroutine$collect_42ocv1$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_0.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_0(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_0.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_0.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_0;
  Coroutine$unsafeTransform$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_0(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_0.prototype.constructor = Coroutine$unsafeTransform$lambda_0;
  Coroutine$unsafeTransform$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_0(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_0(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_0(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_0(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_0.prototype.constructor = Coroutine$map$lambda_0;
  Coroutine$map$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_0(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_0(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var compareBy$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function State(order, sortingPlan) {
    this.order = order;
    this.sortingPlan = sortingPlan;
  }
  State.prototype.orderedColumnsWithSorting_xsr5nn$ = function (columns) {
    var $receiver = this.order;
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    loop_label: while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var transform$result;
      var $receiver_0 = this.sortingPlan;
      var indexOfFirst$result;
      indexOfFirst$break: do {
        var tmp$_1;
        var index = 0;
        tmp$_1 = $receiver_0.iterator();
        while (tmp$_1.hasNext()) {
          var item_0 = tmp$_1.next();
          var id = item_0.component1();
          if (equals(id, item)) {
            indexOfFirst$result = index;
            break indexOfFirst$break;
          }index = index + 1 | 0;
        }
        indexOfFirst$result = -1;
      }
       while (false);
      var sortingIndexForCurrentColumn = indexOfFirst$result;
      if (sortingIndexForCurrentColumn !== -1) {
        transform$result = to(ensureNotNull(columns.get_11rb$(item)), this.sortingPlan.get_za3lpa$(sortingIndexForCurrentColumn));
      } else {
        transform$result = to(ensureNotNull(columns.get_11rb$(item)), ColumnIdSorting$Companion_getInstance().noSorting());
      }
      tmp$_0.call(destination, transform$result);
    }
    return destination;
  };
  State.prototype.columnSortingPlan_xsr5nn$ = function (columns) {
    var $receiver = this.sortingPlan;
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var colId = item.component1()
      , sorting = item.component2();
      var tmp$_1;
      tmp$_0.call(destination, to(ensureNotNull((Kotlin.isType(tmp$_1 = columns, Map) ? tmp$_1 : throwCCE()).get_11rb$(colId)), sorting));
    }
    return destination;
  };
  State.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'State',
    interfaces: []
  };
  State.prototype.component1 = function () {
    return this.order;
  };
  State.prototype.component2 = function () {
    return this.sortingPlan;
  };
  State.prototype.copy_s60nfj$ = function (order, sortingPlan) {
    return new State(order === void 0 ? this.order : order, sortingPlan === void 0 ? this.sortingPlan : sortingPlan);
  };
  State.prototype.toString = function () {
    return 'State(order=' + Kotlin.toString(this.order) + (', sortingPlan=' + Kotlin.toString(this.sortingPlan)) + ')';
  };
  State.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.order) | 0;
    result = result * 31 + Kotlin.hashCode(this.sortingPlan) | 0;
    return result;
  };
  State.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.order, other.order) && Kotlin.equals(this.sortingPlan, other.sortingPlan)))));
  };
  function StateStore(sortingPlanReducer) {
    RootStore.call(this, new State(emptyList(), emptyList()));
    this.sortingPlanReducer_0 = sortingPlanReducer;
    this.sortingChanged = this.handle_ajdi87$(void 0, StateStore$sortingChanged$lambda(this));
  }
  function Coroutine$StateStore$renderingHeaderData$lambda(closure$component_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$component = closure$component_0;
    this.local$it = it_0;
  }
  Coroutine$StateStore$renderingHeaderData$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$renderingHeaderData$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$renderingHeaderData$lambda.prototype.constructor = Coroutine$StateStore$renderingHeaderData$lambda;
  Coroutine$StateStore$renderingHeaderData$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.orderedColumnsWithSorting_xsr5nn$(this.local$closure$component.columns.value.columns);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$renderingHeaderData$lambda(closure$component_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$renderingHeaderData$lambda(closure$component_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  StateStore.prototype.renderingHeaderData_udrkn6$ = function (component) {
    var $receiver = this.data;
    return new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(StateStore$renderingHeaderData$lambda(component)), $receiver));
  };
  function Coroutine$StateStore$renderingRowsData$lambda(data_0, state_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$data = data_0;
    this.local$state = state_0;
  }
  Coroutine$StateStore$renderingRowsData$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$renderingRowsData$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$renderingRowsData$lambda.prototype.constructor = Coroutine$StateStore$renderingRowsData$lambda;
  Coroutine$StateStore$renderingRowsData$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return to(this.local$data, this.local$state);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$renderingRowsData$lambda(data_0, state_0, continuation_0, suspended) {
    var instance = new Coroutine$StateStore$renderingRowsData$lambda(data_0, state_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$StateStore$renderingRowsData$lambda_0(closure$component_0, closure$rowIdProvider_0, f_0, selectedItems_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$component = closure$component_0;
    this.local$closure$rowIdProvider = closure$rowIdProvider_0;
    this.local$f = f_0;
    this.local$selectedItems = selectedItems_0;
  }
  Coroutine$StateStore$renderingRowsData$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$renderingRowsData$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$renderingRowsData$lambda_0.prototype.constructor = Coroutine$StateStore$renderingRowsData$lambda_0;
  Coroutine$StateStore$renderingRowsData$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var data = this.local$f.component1()
            , state = this.local$f.component2();
            var renderingRowsData = toList(withIndex(this.local$closure$component.options.value.sorting.value.sorter.value.sortedBy_v023n7$(data, state.columnSortingPlan_xsr5nn$(this.local$closure$component.columns.value.columns))));
            var columnsSorting = state.orderedColumnsWithSorting_xsr5nn$(this.local$closure$component.columns.value.columns);
            var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault(renderingRowsData, 10)), 16);
            var destination = LinkedHashMap_init(capacity);
            var tmp$;
            tmp$ = renderingRowsData.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              var closure$rowIdProvider = this.local$closure$rowIdProvider;
              var index = element.component1()
              , row = element.component2();
              var tmp$_0 = closure$rowIdProvider(row);
              var destination_0 = ArrayList_init(collectionSizeOrDefault(columnsSorting, 10));
              var tmp$_1;
              tmp$_1 = columnsSorting.iterator();
              while (tmp$_1.hasNext()) {
                var item = tmp$_1.next();
                var tmp$_2 = destination_0.add_11rb$;
                var column = item.component1()
                , columnIdSorting = item.component2();
                tmp$_2.call(destination_0, to(column, new IndexedValue(index, new StatefulItem(row, this.local$selectedItems.contains_11rb$(row), columnIdSorting.strategy))));
              }
              var pair = to(tmp$_0, destination_0);
              destination.put_xwzc9p$(pair.first, pair.second);
            }

            var renderingColumnsData = destination;
            return to(renderingRowsData, renderingColumnsData);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$renderingRowsData$lambda_0(closure$component_0, closure$rowIdProvider_0) {
    return function (f_0, selectedItems_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$renderingRowsData$lambda_0(closure$component_0, closure$rowIdProvider_0, f_0, selectedItems_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  StateStore.prototype.renderingRowsData_ybrt4l$ = function (component, rowIdProvider) {
    return combine(combine(component.dataStore.data, this.data, StateStore$renderingRowsData$lambda), component.selectionStore.data, StateStore$renderingRowsData$lambda_0(component, rowIdProvider));
  };
  function Coroutine$StateStore$sortingChanged$lambda(this$StateStore_0, state_0, activated_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$StateStore = this$StateStore_0;
    this.local$state = state_0;
    this.local$activated = activated_0;
  }
  Coroutine$StateStore$sortingChanged$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$sortingChanged$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$sortingChanged$lambda.prototype.constructor = Coroutine$StateStore$sortingChanged$lambda;
  Coroutine$StateStore$sortingChanged$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$state.copy_s60nfj$(void 0, this.local$this$StateStore.sortingPlanReducer_0.reduce_pt1wo5$(this.local$state.sortingPlan, this.local$activated));
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$sortingChanged$lambda(this$StateStore_0) {
    return function (state_0, activated_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$sortingChanged$lambda(this$StateStore_0, state_0, activated_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  StateStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StateStore',
    interfaces: [RootStore]
  };
  function DataTableComponent(dataStore, rowIdProvider) {
    DataTableComponent$Companion_getInstance();
    this.dataStore = dataStore;
    this.rowIdProvider = rowIdProvider;
    this.$delegate_w7qvhn$_0 = new DefaultContext(rowIdProvider);
    this.columnStateIdProvider_b0lp64$_0 = DataTableComponent$columnStateIdProvider$lambda;
    this.stateStore_y3afwx$_j7in3g$_0 = lazy(DataTableComponent$stateStore$lambda(this));
  }
  function DataTableComponent$Companion() {
    DataTableComponent$Companion_instance = this;
    this.prefix = 'table';
    this.staticCss = staticStyle_0(this.prefix, '\n                display:grid;\n                min-width:100%;\n                flex: 1;\n                border-collapse: collapse;\n                text-align: left;\n                \n                thead,tbody,tr {\n                    display:contents;\n                }\n                             \n                thead {             \n                  grid-area:main;  \n                }\n                \n                tbody {             \n                  grid-area:main;  \n                }\n                                \n                th,\n                td {                 \n                  &:last-child {\n                    border-right: none;\n                  }\n                }\n            ');
  }
  DataTableComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DataTableComponent$Companion_instance = null;
  function DataTableComponent$Companion_getInstance() {
    if (DataTableComponent$Companion_instance === null) {
      new DataTableComponent$Companion();
    }return DataTableComponent$Companion_instance;
  }
  Object.defineProperty(DataTableComponent.prototype, 'stateStore_y3afwx$_0', {
    configurable: true,
    get: function () {
      return this.stateStore_y3afwx$_j7in3g$_0.value;
    }
  });
  function DataTableComponent$render$lambda(it) {
    return it.position;
  }
  function Coroutine$DataTableComponent$render$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$DataTableComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DataTableComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DataTableComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$DataTableComponent$render$lambda$lambda$lambda;
  Coroutine$DataTableComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return firstOrNull(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DataTableComponent$render$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$DataTableComponent$render$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function DataTableComponent$render$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      return closure$it;
    };
  }
  function DataTableComponent$render$lambda$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      return closure$it;
    };
  }
  function DataTableComponent$render$lambda$lambda$lambda$lambda_1(closure$it) {
    return function ($receiver) {
      return closure$it;
    };
  }
  function DataTableComponent$render$lambda$lambda$lambda$lambda_2(closure$it) {
    return function ($receiver) {
      return closure$it;
    };
  }
  function DataTableComponent$render$lambda$lambda$lambda_0($receiver) {
    return params.OverflowValues.auto;
  }
  function DataTableComponent$render$lambda$lambda$lambda$lambda_3($receiver) {
    return Unit;
  }
  function DataTableComponent$render$lambda$lambda$lambda_1($receiver) {
    $receiver.relative_dkjn9d$(DataTableComponent$render$lambda$lambda$lambda$lambda_3);
    return Unit;
  }
  function DataTableComponent$render$lambda$lambda(closure$styling, this$DataTableComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      $receiver.invoke_4my6up$(closure$styling);
      if ((tmp$ = this$DataTableComponent.options.value.width.value) != null) {
        $receiver.width_wpghq5$(DataTableComponent$render$lambda$lambda$lambda$lambda(tmp$));
      }if ((tmp$_0 = this$DataTableComponent.options.value.height.value) != null) {
        $receiver.height_wpghq5$(DataTableComponent$render$lambda$lambda$lambda$lambda_0(tmp$_0));
      }if ((tmp$_1 = this$DataTableComponent.options.value.maxHeight.value) != null) {
        $receiver.maxHeight_wpghq5$(DataTableComponent$render$lambda$lambda$lambda$lambda_1(tmp$_1));
      }if ((tmp$_2 = this$DataTableComponent.options.value.maxWidth.value) != null) {
        $receiver.maxWidth_wpghq5$(DataTableComponent$render$lambda$lambda$lambda$lambda_2(tmp$_2));
      }if (this$DataTableComponent.options.value.height.value != null || this$DataTableComponent.options.value.width.value != null) {
        $receiver.overflow_c5t1z2$(DataTableComponent$render$lambda$lambda$lambda_0);
      }$receiver.css_61zpoe$('overscroll-behavior: contain');
      $receiver.position_wp9r2r$(DataTableComponent$render$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  function DataTableComponent$render$lambda$lambda_0(this$DataTableComponent, closure$baseClass, closure$id, closure$prefix) {
    return function ($receiver) {
      this$DataTableComponent.renderTable_yv4lr5$_0(closure$baseClass, closure$id, closure$prefix, this$DataTableComponent.rowIdProvider, $receiver);
      var $receiver_0 = new EventsContext($receiver, this$DataTableComponent.selectionStore);
      this$DataTableComponent.events.value($receiver_0);
      return Unit;
    };
  }
  DataTableComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var tmp$;
    (tmp$ = this.selection.value.strategy.value) != null ? (tmp$.manageSelectionByExtraColumn_udrkn6$(this), Unit) : null;
    var tmp$_0 = this.stateStore_y3afwx$_0.update;
    var $receiver = this.columns.value.columns.values;
    var destination = ArrayList_init_0();
    var tmp$_1;
    tmp$_1 = $receiver.iterator();
    while (tmp$_1.hasNext()) {
      var element = tmp$_1.next();
      if (!element.hidden)
        destination.add_11rb$(element);
    }
    var $receiver_0 = sortedWith(destination, new Comparator(compareBy$lambda(DataTableComponent$render$lambda)));
    var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
    var tmp$_2;
    tmp$_2 = $receiver_0.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      destination_0.add_11rb$(item.id);
    }
    tmp$_0.invoke_11rb$(new State(destination_0, emptyList()));
    var tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10, tmp$_11, tmp$_12, tmp$_13, tmp$_14;
    context.handledBy_ytah3h$(this.dataStore.data, this.selectionStore.syncHandler);
    switch (this.selection.value.selectionMode.name) {
      case 'Single':
        context.handledBy_ytah3h$((tmp$_7 = (tmp$_5 = (tmp$_4 = (tmp$_3 = this.selection.value.single_8be2vx$) != null ? tmp$_3.store : null) != null ? tmp$_4.value : null) != null ? tmp$_5.data : null) != null ? tmp$_7 : ensureNotNull((tmp$_6 = this.selection.value.single_8be2vx$) != null ? tmp$_6.row : null).values, this.selectionStore.updateRow);
        if ((tmp$_8 = ensureNotNull(this.selection.value.single_8be2vx$).store.value) != null) {
          var $receiver_1 = this.selectionStore.selectedData;
          context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(DataTableComponent$render$lambda$lambda$lambda), $receiver_1)), tmp$_8.update);
        }
        break;
      case 'Multi':
        context.handledBy_ytah3h$((tmp$_13 = (tmp$_11 = (tmp$_10 = (tmp$_9 = this.selection.value.multi_8be2vx$) != null ? tmp$_9.store : null) != null ? tmp$_10.value : null) != null ? tmp$_11.data : null) != null ? tmp$_13 : ensureNotNull((tmp$_12 = this.selection.value.multi_8be2vx$) != null ? tmp$_12.rows : null).values, this.selectionStore.update);
        if ((tmp$_14 = ensureNotNull(this.selection.value.multi_8be2vx$).store.value) != null) {
          context.handledBy_ytah3h$(this.selectionStore.selectedData, tmp$_14.update);
        }
        break;
      default:break;
    }
    div(context, DataTableComponent$render$lambda$lambda(styling, this), void 0, void 0, void 0, void 0, DataTableComponent$render$lambda$lambda_0(this, baseClass, id, prefix));
    return Unit;
  };
  function Coroutine$DataTableComponent$renderTable$lambda(closure$component_0, f_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$component = closure$component_0;
    this.local$f = f_0;
  }
  Coroutine$DataTableComponent$renderTable$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DataTableComponent$renderTable$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DataTableComponent$renderTable$lambda.prototype.constructor = Coroutine$DataTableComponent$renderTable$lambda;
  Coroutine$DataTableComponent$renderTable$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var order = this.local$f.component1();
            var minmax = {v: ''};
            var tmp$;
            tmp$ = order.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              var closure$component = this.local$closure$component;
              var tmp$_0;
              if ((tmp$_0 = closure$component.columns.value.columns.get_11rb$(element)) != null) {
                var tmp$_1, tmp$_2, tmp$_3, tmp$_4;
                var min = (tmp$_1 = tmp$_0.minWidth) != null ? tmp$_1 : closure$component.options.value.cellMinWidth.value;
                var max = (tmp$_2 = tmp$_0.maxWidth) != null ? tmp$_2 : closure$component.options.value.cellMaxWidth.value;
                tmp$_4 = minmax.v;
                if (equals(min, max)) {
                  tmp$_3 = max;
                } else {
                  if (!Regex_init('px|%').containsMatchIn_6bul2c$(min)) {
                    tmp$_3 = 'minmax(' + closure$component.options.value.cellMinWidth.value + ', ' + max + ')';
                  } else {
                    tmp$_3 = 'minmax(' + min + ', ' + max + ')';
                  }
                }
                minmax.v = tmp$_4 + ('\n' + tmp$_3);
              }}

            return '\n' + '                    grid-template-columns: ' + minmax.v + ';                ' + '\n' + '                    grid-template-rows: auto;' + '\n' + '                   ';
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DataTableComponent$renderTable$lambda(closure$component_0) {
    return function (f_0, continuation_0, suspended) {
      var instance = new Coroutine$DataTableComponent$renderTable$lambda(closure$component_0, f_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  DataTableComponent.prototype.renderTable_yv4lr5$_0 = function (baseClass, id, prefix, rowIdProvider, RenderContext) {
    var tmp$;
    var component = this;
    if (baseClass != null) {
      tmp$ = baseClass.plus_fox8kt$(DataTableComponent$Companion_getInstance().staticCss);
    } else {
      tmp$ = DataTableComponent$Companion_getInstance().staticCss;
    }
    var tableBaseClass = tmp$;
    var $receiver = component.stateStore_y3afwx$_0.data;
    var gridCols = new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(DataTableComponent$renderTable$lambda(component)), $receiver));
    if (component.header.value.fixedHeader.value) {
      this.renderFixedHeaderTable_e3cfg2$_0(rowIdProvider, gridCols, tableBaseClass, id, prefix, RenderContext);
    } else {
      this.renderSimpleTable_h3qkyp$_0(rowIdProvider, gridCols, tableBaseClass, id, prefix, RenderContext);
    }
  };
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda(closure$component) {
    return function ($receiver) {
      return closure$component.header.value.fixedHeaderHeight.value;
    };
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_0($receiver) {
    return params.OverflowValues.hidden;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '0';
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda$lambda($receiver) {
    $receiver.top_bcpvvc$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_1($receiver) {
    $receiver.sticky_dkjn9d$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_2($receiver) {
    return $receiver.tableHeader;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda(closure$component) {
    return function ($receiver) {
      $receiver.height_wpghq5$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda(closure$component));
      $receiver.overflow_c5t1z2$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_0);
      $receiver.position_wp9r2r$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_1);
      $receiver.zIndex_yiflju$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_2);
      return Unit;
    };
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_3($receiver) {
    return Unit;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_4($receiver) {
    $receiver.css_61zpoe$('visibility:hidden');
    return Unit;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda_0(closure$gridCols, this$DataTableComponent, closure$rowIdProvider) {
    return function ($receiver) {
      $receiver.attr_i7f8q9$('style', closure$gridCols);
      this$DataTableComponent.renderHeader_ji41fz$_0(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_3, $receiver);
      this$DataTableComponent.renderRows_7wpp2g$_0(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_4, closure$rowIdProvider, $receiver);
      return Unit;
    };
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda$lambda_0(closure$component) {
    return function ($receiver) {
      return '-' + closure$component.header.value.fixedHeaderHeight.value;
    };
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_5(closure$component) {
    return function ($receiver) {
      $receiver.top_bcpvvc$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda$lambda_0(closure$component));
      return Unit;
    };
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_6($receiver) {
    return 'fit-content';
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda_1(closure$component) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_5(closure$component));
      $receiver.height_wpghq5$(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_6);
      return Unit;
    };
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_7($receiver) {
    $receiver.css_61zpoe$('visibility:hidden');
    return Unit;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_8($receiver) {
    return Unit;
  }
  function DataTableComponent$renderFixedHeaderTable$lambda$lambda_2(closure$gridCols, this$DataTableComponent, closure$rowIdProvider) {
    return function ($receiver) {
      $receiver.attr_i7f8q9$('style', closure$gridCols);
      this$DataTableComponent.renderHeader_ji41fz$_0(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_7, $receiver);
      this$DataTableComponent.renderRows_7wpp2g$_0(DataTableComponent$renderFixedHeaderTable$lambda$lambda$lambda_8, closure$rowIdProvider, $receiver);
      return Unit;
    };
  }
  DataTableComponent.prototype.renderFixedHeaderTable_e3cfg2$_0 = function (rowIdProvider, gridCols, baseClass, id, prefix, RenderContext) {
    var component = this;
    table(RenderContext, DataTableComponent$renderFixedHeaderTable$lambda$lambda(component), baseClass, toString(id) + '-fixedHeader', prefix + '-fixedHeader', void 0, DataTableComponent$renderFixedHeaderTable$lambda$lambda_0(gridCols, this, rowIdProvider));
    table(RenderContext, DataTableComponent$renderFixedHeaderTable$lambda$lambda_1(component), baseClass, id, prefix, void 0, DataTableComponent$renderFixedHeaderTable$lambda$lambda_2(gridCols, this, rowIdProvider));
  };
  function DataTableComponent$renderSimpleTable$lambda$lambda($receiver) {
    return Unit;
  }
  function DataTableComponent$renderSimpleTable$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function DataTableComponent$renderSimpleTable$lambda$lambda$lambda_0($receiver) {
    return Unit;
  }
  function DataTableComponent$renderSimpleTable$lambda$lambda_0(closure$gridCols, this$DataTableComponent, closure$rowIdProvider) {
    return function ($receiver) {
      $receiver.attr_i7f8q9$('style', closure$gridCols);
      this$DataTableComponent.renderHeader_ji41fz$_0(DataTableComponent$renderSimpleTable$lambda$lambda$lambda, $receiver);
      this$DataTableComponent.renderRows_7wpp2g$_0(DataTableComponent$renderSimpleTable$lambda$lambda$lambda_0, closure$rowIdProvider, $receiver);
      return Unit;
    };
  }
  DataTableComponent.prototype.renderSimpleTable_h3qkyp$_0 = function (rowIdProvider, gridCols, baseClass, id, prefix, RenderContext) {
    table(RenderContext, DataTableComponent$renderSimpleTable$lambda$lambda, baseClass, id, prefix, void 0, DataTableComponent$renderSimpleTable$lambda$lambda_0(gridCols, this, rowIdProvider));
  };
  function DataTableComponent$renderHeader$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_tdl3c$(closure$styling);
      return Unit;
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda(closure$sorting, closure$component, closure$column) {
    return function ($receiver) {
      Sorting$Companion_getInstance().sorted_f02lu0$(closure$sorting.strategy);
      Theme.Companion.invoke().dataTableStyles.headerStyle($receiver, Sorting$Companion_getInstance().sorted_f02lu0$(closure$sorting.strategy));
      $receiver.invoke_qkhqzy$(closure$component.header.value.styling.value);
      closure$column.headerStyling($receiver, closure$sorting.strategy);
      return Unit;
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '100%';
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    $receiver.relative_dkjn9d$(DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    return $receiver.center;
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.height_wpghq5$(DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda);
    $receiver.position_wp9r2r$(DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0);
    $receiver.alignItems_tsd917$(DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_2(closure$sorting) {
    return function ($receiver) {
      Sorting$Companion_getInstance().sorted_f02lu0$(closure$sorting.strategy);
      Theme.Companion.invoke().dataTableStyles.sorterStyle($receiver, Sorting$Companion_getInstance().sorted_f02lu0$(closure$sorting.strategy));
      return Unit;
    };
  }
  function Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda(closure$column_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$column = closure$column_0;
  }
  Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return ColumnIdSorting$Companion_getInstance().of_4wzt4c$(this.local$closure$column);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(closure$column_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda(closure$column_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_3(closure$component, closure$sorting, closure$column) {
    return function ($receiver) {
      if (equals(closure$column.id, closure$sorting.id))
        closure$component.options.value.sorting.value.renderer.value.renderSortingActive_5r7g3g$($receiver, closure$sorting.strategy);
      else if (closure$column.sorting !== Sorting$DISABLED_getInstance())
        closure$component.options.value.sorting.value.renderer.value.renderSortingLost_dsmk0w$($receiver);
      else {
        closure$component.options.value.sorting.value.renderer.value.renderSortingDisabled_dsmk0w$($receiver);
      }
      var $receiver_0 = $receiver.clicks.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(closure$column)), $receiver_0)), closure$component.stateStore_y3afwx$_0.sortingChanged);
      return Unit;
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda_0(closure$column, closure$sorting, closure$component) {
    return function ($receiver) {
      closure$column.headerContent($receiver, closure$column);
      div($receiver, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_2(closure$sorting), void 0, void 0, void 0, void 0, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda$lambda_3(closure$component, closure$sorting, closure$column));
      return Unit;
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda_0(closure$column, closure$sorting, closure$component) {
    return function ($receiver) {
      flexBox($receiver, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda, void 0, void 0, void 0, void 0, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda$lambda_0(closure$column, closure$sorting, closure$component));
      return Unit;
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda$lambda(closure$component) {
    return function ($receiver, f) {
      var column = f.component1()
      , sorting = f.component2();
      return th($receiver, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda(sorting, closure$component, column), void 0, void 0, void 0, void 0, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda$lambda_0(column, sorting, closure$component));
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda$lambda(closure$component) {
    return function ($receiver) {
      $receiver.renderEach_ywitts$(closure$component.stateStore_y3afwx$_0.renderingHeaderData_udrkn6$(closure$component), closure$component.columnStateIdProvider_b0lp64$_0, $receiver, DataTableComponent$renderHeader$lambda$lambda$lambda$lambda(closure$component));
      return Unit;
    };
  }
  function DataTableComponent$renderHeader$lambda$lambda_0(closure$component) {
    return function ($receiver) {
      $receiver.tr_qw3s33$(void 0, void 0, void 0, DataTableComponent$renderHeader$lambda$lambda$lambda(closure$component));
      return Unit;
    };
  }
  DataTableComponent.prototype.renderHeader_ji41fz$_0 = function (styling, renderContext) {
    var component = this;
    thead(renderContext, DataTableComponent$renderHeader$lambda$lambda(styling), void 0, void 0, void 0, void 0, DataTableComponent$renderHeader$lambda$lambda_0(component));
  };
  function DataTableComponent$renderRows$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_tdl3c$(closure$styling);
      return Unit;
    };
  }
  function Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda(closure$rowIdProvider_0, data_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowIdProvider = closure$rowIdProvider_0;
    this.local$data = data_0;
  }
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda;
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var $receiver = this.local$data.first;
            var result = LinkedHashMap_init(coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16));
            var tmp$;
            tmp$ = $receiver.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              result.put_xwzc9p$(element, this.local$data.second.get_11rb$(this.local$closure$rowIdProvider(element.value)));
            }

            return toList_0(result);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DataTableComponent$renderRows$lambda$lambda$lambda$lambda(closure$rowIdProvider_0) {
    return function (data_0, continuation_0, suspended) {
      var instance = new Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda(closure$rowIdProvider_0, data_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda(closure$rowStore_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowStore = closure$rowStore_0;
  }
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$rowStore.current;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda(closure$rowStore_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda(closure$rowStore_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda$lambda(closure$index, closure$stateful, closure$statefulIndex, this$DataTableComponent, closure$column) {
    return function ($receiver) {
      var tmp$;
      Theme.Companion.invoke().dataTableStyles.cellStyle($receiver, new IndexedValue(closure$index, Kotlin.isType(tmp$ = closure$stateful.item, Any) ? tmp$ : throwCCE()), closure$stateful.selected, Sorting$Companion_getInstance().sorted_f02lu0$(closure$statefulIndex.value.sorting));
      this$DataTableComponent.columns.value.styling.value($receiver, closure$statefulIndex);
      closure$column.styling($receiver, closure$statefulIndex);
      return Unit;
    };
  }
  function DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(this$DataTableComponent, this$, closure$stateful, closure$index, closure$column, closure$statefulIndex, closure$rowStore) {
    return function ($receiver) {
      this$DataTableComponent.applySelectionStyle_ds0ldd$_0(this$, closure$stateful.selected, closure$index, closure$stateful.item);
      closure$column.content($receiver, closure$statefulIndex, closure$column.lens != null ? closure$rowStore.sub_h801vt$(closure$column.lens) : null, closure$rowStore);
      return Unit;
    };
  }
  function DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda(this$DataTableComponent, closure$rowStore, closure$fields) {
    return function ($receiver) {
      var tmp$;
      (tmp$ = this$DataTableComponent.selection.value.strategy.value) != null ? (tmp$.manageSelectionByRowEvents_ri6i38$(this$DataTableComponent, closure$rowStore, $receiver), Unit) : null;
      var $receiver_0 = $receiver.dblclicks.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda(closure$rowStore)), $receiver_0)), this$DataTableComponent.selectionStore.dbClickedRow);
      if (closure$fields != null) {
        var $receiver_1 = closure$fields;
        var tmp$_0;
        tmp$_0 = $receiver_1.iterator();
        while (tmp$_0.hasNext()) {
          var element = tmp$_0.next();
          var this$DataTableComponent_0 = this$DataTableComponent;
          var closure$rowStore_0 = closure$rowStore;
          var column = element.component1()
          , statefulIndex = element.component2();
          var index = statefulIndex.component1()
          , stateful = statefulIndex.component2();
          td($receiver, DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda$lambda(index, stateful, statefulIndex, this$DataTableComponent_0, column), void 0, void 0, void 0, void 0, DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(this$DataTableComponent_0, $receiver, stateful, index, column, statefulIndex, closure$rowStore_0));
        }
      }return Unit;
    };
  }
  function DataTableComponent$renderRows$lambda$lambda$lambda$lambda_0(this$DataTableComponent, closure$rowIdProvider) {
    return function ($receiver, it) {
      var tmp = it.component1()
      , fields = it.component2();
      var rowData = tmp.component2();
      var rowStore = sub(this$DataTableComponent.dataStore, rowData, closure$rowIdProvider);
      return $receiver.tr_qw3s33$(void 0, void 0, void 0, DataTableComponent$renderRows$lambda$lambda$lambda$lambda$lambda(this$DataTableComponent, rowStore, fields));
    };
  }
  function DataTableComponent$renderRows$lambda$lambda_0(this$DataTableComponent, closure$rowIdProvider) {
    return function ($receiver) {
      var $receiver_0 = this$DataTableComponent.stateStore_y3afwx$_0.renderingRowsData_ybrt4l$(this$DataTableComponent, closure$rowIdProvider);
      var closure$rowIdProvider_0 = closure$rowIdProvider;
      var this$DataTableComponent_0 = this$DataTableComponent;
      $receiver.renderEach_ywitts$(new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda_0(DataTableComponent$renderRows$lambda$lambda$lambda$lambda(closure$rowIdProvider_0)), $receiver_0)), void 0, $receiver, DataTableComponent$renderRows$lambda$lambda$lambda$lambda_0(this$DataTableComponent_0, closure$rowIdProvider_0));
      return Unit;
    };
  }
  DataTableComponent.prototype.renderRows_7wpp2g$_0 = function (styling, rowIdProvider, renderContext) {
    tbody(renderContext, DataTableComponent$renderRows$lambda$lambda(styling), void 0, void 0, void 0, void 0, DataTableComponent$renderRows$lambda$lambda_0(this, rowIdProvider));
  };
  function DataTableComponent$applySelectionStyle$lambda$lambda$lambda(closure$index, closure$rowData, closure$isSelected, this$DataTableComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      tmp$_1 = Theme.Companion.invoke().dataTableStyles.hoveringStyle;
      tmp$_0 = Kotlin.isType(tmp$ = closure$rowData, Any) ? tmp$ : throwCCE();
      tmp$_1($receiver, new IndexedValue(closure$index, tmp$_0), closure$isSelected, false);
      this$DataTableComponent.options.value.hovering.value.style.value($receiver, new IndexedValue(closure$index, new StatefulItem(closure$rowData, closure$isSelected, Sorting$NONE_getInstance())));
      return Unit;
    };
  }
  function DataTableComponent$applySelectionStyle$lambda$lambda(closure$index, closure$rowData, closure$isSelected, this$DataTableComponent) {
    return function ($receiver) {
      $receiver.children_qlrppv$('&:hover td', DataTableComponent$applySelectionStyle$lambda$lambda$lambda(closure$index, closure$rowData, closure$isSelected, this$DataTableComponent));
      return Unit;
    };
  }
  DataTableComponent.prototype.applySelectionStyle_ds0ldd$_0 = function (renderContext, isSelected, index, rowData) {
    if (this.options.value.hovering.value.active.value) {
      renderContext.className_61zpoe$(style(void 0, DataTableComponent$applySelectionStyle$lambda$lambda(index, rowData, isSelected, this)).name);
    }};
  Object.defineProperty(DataTableComponent.prototype, 'columns', {
    configurable: true,
    get: function () {
      return this.$delegate_w7qvhn$_0.columns;
    }
  });
  Object.defineProperty(DataTableComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_w7qvhn$_0.events;
    }
  });
  Object.defineProperty(DataTableComponent.prototype, 'header', {
    configurable: true,
    get: function () {
      return this.$delegate_w7qvhn$_0.header;
    }
  });
  Object.defineProperty(DataTableComponent.prototype, 'options', {
    configurable: true,
    get: function () {
      return this.$delegate_w7qvhn$_0.options;
    }
  });
  Object.defineProperty(DataTableComponent.prototype, 'selection', {
    configurable: true,
    get: function () {
      return this.$delegate_w7qvhn$_0.selection;
    }
  });
  Object.defineProperty(DataTableComponent.prototype, 'selectionStore', {
    configurable: true,
    get: function () {
      return this.$delegate_w7qvhn$_0.selectionStore;
    }
  });
  DataTableComponent.prototype.columns_qvsxfn$$default = function (styling, expression) {
    return this.$delegate_w7qvhn$_0.columns_qvsxfn$$default(styling, expression);
  };
  DataTableComponent.prototype.header_81hq22$$default = function (styling, expression) {
    return this.$delegate_w7qvhn$_0.header_81hq22$$default(styling, expression);
  };
  DataTableComponent.prototype.options_agnprp$ = function (value) {
    return this.$delegate_w7qvhn$_0.options_agnprp$(value);
  };
  DataTableComponent.prototype.prependAdditionalColumns_g7bbd8$ = function (expression) {
    return this.$delegate_w7qvhn$_0.prependAdditionalColumns_g7bbd8$(expression);
  };
  DataTableComponent.prototype.selection_5o6y5j$ = function (value) {
    return this.$delegate_w7qvhn$_0.selection_5o6y5j$(value);
  };
  function DataTableComponent$columnStateIdProvider$lambda(it) {
    return it.first.id + toString(it.second);
  }
  function DataTableComponent$stateStore$lambda(this$DataTableComponent) {
    return function () {
      return new StateStore(this$DataTableComponent.options.value.sorting.value.reducer.value);
    };
  }
  DataTableComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DataTableComponent',
    interfaces: [DataTableContext, Component]
  };
  var compareBy$lambda_0 = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function unsafeFlow$ObjectLiteral_1(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_1($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_1.prototype.constructor = Coroutine$collect_42ocv1$_1;
  Coroutine$collect_42ocv1$_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_1.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_1(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_1.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_1.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_1;
  Coroutine$unsafeTransform$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_1(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_1.prototype.constructor = Coroutine$unsafeTransform$lambda_1;
  Coroutine$unsafeTransform$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_1(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_1(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_1(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_1(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_1.prototype.constructor = Coroutine$map$lambda_1;
  Coroutine$map$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_1(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_1(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ColumnsContext() {
    this.columns = LinkedHashMap_init_0();
    this.styling = new ComponentProperty(ColumnsContext$styling$lambda);
  }
  function ColumnsContext$ColumnContext() {
    this.id = new ComponentProperty(identification.Id.next_za3lpa$());
    this.lens = new ComponentProperty(null);
    this.width_0 = new ColumnsContext$ColumnContext$WidthContext();
    this.header = new ColumnsContext$ColumnContext$Header();
    this.title = new ComponentProperty('');
    this.hidden = new ComponentProperty(false);
    this.position = new ComponentProperty(0);
    this.sorting = new ComponentProperty(ColumnsContext$ColumnContext$sorting$lambda);
    this.sortBy = new ComponentProperty(null);
    this.styling = new ComponentProperty(ColumnsContext$ColumnContext$styling$lambda);
    this.content = new ComponentProperty(ColumnsContext$ColumnContext$content$lambda);
  }
  ColumnsContext$ColumnContext.prototype.build = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    return new Column(this.id.value, this.lens.value, this.title.value, (tmp$_0 = (tmp$ = this.width_0) != null ? tmp$.min : null) != null ? tmp$_0.value : null, (tmp$_2 = (tmp$_1 = this.width_0) != null ? tmp$_1.max : null) != null ? tmp$_2.value : null, this.hidden.value, this.position.value, this.sorting.value(ColumnsContext$ColumnContext$SortingContext_getInstance()), this.sortBy.value, this.styling.value, this.content.value, this.header.styling, this.header.content);
  };
  function ColumnsContext$ColumnContext$WidthContext() {
    this.min = new ComponentProperty(null);
    this.max = new ComponentProperty(null);
  }
  ColumnsContext$ColumnContext$WidthContext.prototype.minmax_61zpoe$ = function (value) {
    this.max.invoke_11rb$(value);
    this.min.invoke_11rb$(value);
  };
  ColumnsContext$ColumnContext$WidthContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WidthContext',
    interfaces: []
  };
  ColumnsContext$ColumnContext.prototype.width_ie1rgt$ = function (expression) {
    var $receiver = new ColumnsContext$ColumnContext$WidthContext();
    expression($receiver);
    this.width_0 = $receiver;
  };
  function ColumnsContext$ColumnContext$Header(styling, content) {
    if (styling === void 0)
      styling = ColumnsContext$ColumnContext$ColumnsContext$ColumnContext$Header_init$lambda;
    if (content === void 0)
      content = ColumnsContext$ColumnContext$ColumnsContext$ColumnContext$Header_init$lambda_0;
    this.styling = styling;
    this.content = content;
  }
  function ColumnsContext$ColumnContext$ColumnsContext$ColumnContext$Header_init$lambda($receiver, it) {
    return Unit;
  }
  function ColumnsContext$ColumnContext$ColumnsContext$ColumnContext$Header_init$lambda_0($receiver, column) {
    $receiver.unaryPlus_pdl1vz$(column.title);
    return Unit;
  }
  ColumnsContext$ColumnContext$Header.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Header',
    interfaces: []
  };
  ColumnsContext$ColumnContext$Header.prototype.component1 = function () {
    return this.styling;
  };
  ColumnsContext$ColumnContext$Header.prototype.component2 = function () {
    return this.content;
  };
  ColumnsContext$ColumnContext$Header.prototype.copy_dxk5zr$ = function (styling, content) {
    return new ColumnsContext$ColumnContext$Header(styling === void 0 ? this.styling : styling, content === void 0 ? this.content : content);
  };
  ColumnsContext$ColumnContext$Header.prototype.toString = function () {
    return 'Header(styling=' + Kotlin.toString(this.styling) + (', content=' + Kotlin.toString(this.content)) + ')';
  };
  ColumnsContext$ColumnContext$Header.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.styling) | 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    return result;
  };
  ColumnsContext$ColumnContext$Header.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.styling, other.styling) && Kotlin.equals(this.content, other.content)))));
  };
  function ColumnsContext$ColumnContext$header$lambda($receiver, it) {
    return Unit;
  }
  ColumnsContext$ColumnContext.prototype.header_dxk5zr$ = function (styling, content) {
    if (styling === void 0)
      styling = ColumnsContext$ColumnContext$header$lambda;
    this.header = new ColumnsContext$ColumnContext$Header(styling, content);
  };
  function ColumnsContext$ColumnContext$SortingContext() {
    ColumnsContext$ColumnContext$SortingContext_instance = this;
    this.disabled = Sorting$DISABLED_getInstance();
    this.none = Sorting$NONE_getInstance();
    this.asc = Sorting$ASC_getInstance();
    this.desc = Sorting$DESC_getInstance();
  }
  ColumnsContext$ColumnContext$SortingContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SortingContext',
    interfaces: []
  };
  var ColumnsContext$ColumnContext$SortingContext_instance = null;
  function ColumnsContext$ColumnContext$SortingContext_getInstance() {
    if (ColumnsContext$ColumnContext$SortingContext_instance === null) {
      new ColumnsContext$ColumnContext$SortingContext();
    }return ColumnsContext$ColumnContext$SortingContext_instance;
  }
  ColumnsContext$ColumnContext.prototype.sortBy_74wbhw$ = function (expression) {
    this.sortBy.invoke_11rb$(new Comparator(compareBy$lambda_0(expression)));
  };
  ColumnsContext$ColumnContext.prototype.sortBy_erbdv1$ = function (expressions) {
    this.sortBy.invoke_11rb$(compareBy(expressions.slice()));
  };
  function ColumnsContext$ColumnContext$sorting$lambda($receiver) {
    return $receiver.none;
  }
  function ColumnsContext$ColumnContext$styling$lambda($receiver, it) {
    return Unit;
  }
  function ColumnsContext$ColumnContext$content$lambda($receiver, f, store, f_0) {
    var tmp$;
    (tmp$ = store != null ? store.data : null) != null ? ($receiver.renderText_ntmorv$(tmp$), Unit) : null;
    return Unit;
  }
  ColumnsContext$ColumnContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColumnContext',
    interfaces: []
  };
  function ColumnsContext$column$lambda($receiver, it) {
    return Unit;
  }
  ColumnsContext.prototype.column_obnj8v$ = function (styling, expression) {
    if (styling === void 0)
      styling = ColumnsContext$column$lambda;
    var $receiver = new ColumnsContext$ColumnContext();
    expression($receiver);
    $receiver.styling.invoke_11rb$(styling);
    var $receiver_0 = $receiver.build();
    var $receiver_1 = this.columns;
    var key = $receiver_0.id;
    $receiver_1.put_xwzc9p$(key, $receiver_0);
  };
  function ColumnsContext$column$lambda_0($receiver, it) {
    return Unit;
  }
  ColumnsContext.prototype.column_yn05hb$ = function (styling, title, expression) {
    if (styling === void 0)
      styling = ColumnsContext$column$lambda_0;
    var $receiver = new ColumnsContext$ColumnContext();
    $receiver.title.invoke_11rb$(title);
    expression($receiver);
    $receiver.styling.invoke_11rb$(styling);
    var $receiver_0 = $receiver.build();
    var $receiver_1 = this.columns;
    var key = $receiver_0.id;
    $receiver_1.put_xwzc9p$(key, $receiver_0);
  };
  function ColumnsContext$styling$lambda($receiver, it) {
    return Unit;
  }
  ColumnsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColumnsContext',
    interfaces: []
  };
  function EventsContext(element, rowSelectionStore) {
    this.$delegate_598gme$_0 = element;
    this.selectedRows = rowSelectionStore.selectedData;
    var $receiver = rowSelectionStore.selectedData;
    this.selectedRow = new unsafeFlow$ObjectLiteral_1(unsafeTransform$lambda_1(map$lambda_1(EventsContext$selectedRow$lambda), $receiver));
    this.dbClicks = rowSelectionStore.dbClickedRow;
  }
  Object.defineProperty(EventsContext.prototype, 'aborts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.aborts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'afterprints', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.afterprints;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'beforeprints', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.beforeprints;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'beforeunloads', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.beforeunloads;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'blurs', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.blurs;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'canplays', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.canplays;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'canplaythroughs', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.canplaythroughs;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'changes', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.changes;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'clicks', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.clicks;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'contextmenus', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.contextmenus;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'copys', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.copys;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'cuts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.cuts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'dblclicks', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.dblclicks;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'domNode', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.domNode;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'dragends', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.dragends;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'dragenters', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.dragenters;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'dragleaves', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.dragleaves;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'dragovers', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.dragovers;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'drags', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.drags;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'dragstarts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.dragstarts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'drops', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.drops;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'durationchanges', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.durationchanges;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'endeds', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.endeds;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'focusins', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.focusins;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'focusouts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.focusouts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'focuss', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.focuss;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'fullscreenchanges', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.fullscreenchanges;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'fullscreenerrors', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.fullscreenerrors;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'hashchanges', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.hashchanges;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'inputs', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.inputs;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'invalids', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.invalids;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'job', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.job;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'keydowns', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.keydowns;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'keypresss', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.keypresss;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'keyups', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.keyups;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'loadeddatas', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.loadeddatas;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'loadedmetadatas', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.loadedmetadatas;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'loads', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.loads;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'loadstarts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.loadstarts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'messages', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.messages;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mousedowns', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mousedowns;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mouseenters', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mouseenters;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mouseleaves', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mouseleaves;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mousemoves', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mousemoves;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mouseouts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mouseouts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mouseovers', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mouseovers;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'mouseups', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.mouseups;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'offlines', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.offlines;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'onlines', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.onlines;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'opens', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.opens;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'pagehides', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.pagehides;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'pageshows', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.pageshows;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'pastes', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.pastes;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'pauses', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.pauses;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'playings', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.playings;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'plays', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.plays;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'popstates', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.popstates;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'progresss', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.progresss;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'ratechanges', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.ratechanges;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'resets', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.resets;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'resizes', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.resizes;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'scrolls', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.scrolls;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'searchs', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.searchs;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'seekeds', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.seekeds;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'seekings', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.seekings;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'selects', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.selects;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'shows', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.shows;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'stalleds', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.stalleds;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'storages', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.storages;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'submits', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.submits;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'suspends', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.suspends;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'timeupdates', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.timeupdates;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'toggles', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.toggles;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'touchcancels', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.touchcancels;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'touchends', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.touchends;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'touchmoves', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.touchmoves;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'touchstarts', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.touchstarts;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'unloads', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.unloads;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'volumechanges', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.volumechanges;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'waitings', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.waitings;
    }
  });
  Object.defineProperty(EventsContext.prototype, 'wheels', {
    configurable: true,
    get: function () {
      return this.$delegate_598gme$_0.wheels;
    }
  });
  EventsContext.prototype.handledBy_jora5j$ = function ($receiver, handler) {
    return this.$delegate_598gme$_0.handledBy_jora5j$($receiver, handler);
  };
  EventsContext.prototype.handledBy_lesqyu$ = function ($receiver, execute) {
    return this.$delegate_598gme$_0.handledBy_lesqyu$($receiver, execute);
  };
  EventsContext.prototype.handledBy_hlmqex$ = function ($receiver, handler) {
    return this.$delegate_598gme$_0.handledBy_hlmqex$($receiver, handler);
  };
  EventsContext.prototype.handledBy_uhegz2$ = function ($receiver, execute) {
    return this.$delegate_598gme$_0.handledBy_uhegz2$($receiver, execute);
  };
  EventsContext.prototype.handledBy_ytah3h$ = function ($receiver, handler) {
    return this.$delegate_598gme$_0.handledBy_ytah3h$($receiver, handler);
  };
  EventsContext.prototype.handledBy_706ovd$ = function ($receiver, execute) {
    return this.$delegate_598gme$_0.handledBy_706ovd$($receiver, execute);
  };
  function Coroutine$EventsContext$selectedRow$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$EventsContext$selectedRow$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$EventsContext$selectedRow$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$EventsContext$selectedRow$lambda.prototype.constructor = Coroutine$EventsContext$selectedRow$lambda;
  Coroutine$EventsContext$selectedRow$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return firstOrNull(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function EventsContext$selectedRow$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$EventsContext$selectedRow$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: [EventContext]
  };
  function SelectionContext() {
    this.single_8be2vx$ = null;
    this.multi_8be2vx$ = null;
    this.strategy = new ComponentProperty(null);
    this.selectionMode_l3vb4q$_0 = lazy(SelectionContext$selectionMode$lambda(this));
  }
  function SelectionContext$StrategyContext() {
    SelectionContext$StrategyContext_instance = this;
    this.checkbox = SelectionContext$StrategyContext$StrategySpecifier$Checkbox_getInstance();
    this.click = SelectionContext$StrategyContext$StrategySpecifier$Click_getInstance();
  }
  function SelectionContext$StrategyContext$StrategySpecifier(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function SelectionContext$StrategyContext$StrategySpecifier_initFields() {
    SelectionContext$StrategyContext$StrategySpecifier_initFields = function () {
    };
    SelectionContext$StrategyContext$StrategySpecifier$Checkbox_instance = new SelectionContext$StrategyContext$StrategySpecifier('Checkbox', 0);
    SelectionContext$StrategyContext$StrategySpecifier$Click_instance = new SelectionContext$StrategyContext$StrategySpecifier('Click', 1);
  }
  var SelectionContext$StrategyContext$StrategySpecifier$Checkbox_instance;
  function SelectionContext$StrategyContext$StrategySpecifier$Checkbox_getInstance() {
    SelectionContext$StrategyContext$StrategySpecifier_initFields();
    return SelectionContext$StrategyContext$StrategySpecifier$Checkbox_instance;
  }
  var SelectionContext$StrategyContext$StrategySpecifier$Click_instance;
  function SelectionContext$StrategyContext$StrategySpecifier$Click_getInstance() {
    SelectionContext$StrategyContext$StrategySpecifier_initFields();
    return SelectionContext$StrategyContext$StrategySpecifier$Click_instance;
  }
  SelectionContext$StrategyContext$StrategySpecifier.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StrategySpecifier',
    interfaces: [Enum]
  };
  function SelectionContext$StrategyContext$StrategySpecifier$values() {
    return [SelectionContext$StrategyContext$StrategySpecifier$Checkbox_getInstance(), SelectionContext$StrategyContext$StrategySpecifier$Click_getInstance()];
  }
  SelectionContext$StrategyContext$StrategySpecifier.values = SelectionContext$StrategyContext$StrategySpecifier$values;
  function SelectionContext$StrategyContext$StrategySpecifier$valueOf(name) {
    switch (name) {
      case 'Checkbox':
        return SelectionContext$StrategyContext$StrategySpecifier$Checkbox_getInstance();
      case 'Click':
        return SelectionContext$StrategyContext$StrategySpecifier$Click_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.datatable.SelectionContext.StrategyContext.StrategySpecifier.' + name);
    }
  }
  SelectionContext$StrategyContext$StrategySpecifier.valueOf_61zpoe$ = SelectionContext$StrategyContext$StrategySpecifier$valueOf;
  SelectionContext$StrategyContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'StrategyContext',
    interfaces: []
  };
  var SelectionContext$StrategyContext_instance = null;
  function SelectionContext$StrategyContext_getInstance() {
    if (SelectionContext$StrategyContext_instance === null) {
      new SelectionContext$StrategyContext();
    }return SelectionContext$StrategyContext_instance;
  }
  function SelectionContext$Single() {
    this.store = new ComponentProperty(null);
    this.row = new NullableDynamicComponentProperty(emptyFlow());
  }
  SelectionContext$Single.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Single',
    interfaces: []
  };
  SelectionContext.prototype.single_2kq2rf$ = function (value) {
    var $receiver = new SelectionContext$Single();
    value($receiver);
    this.single_8be2vx$ = $receiver;
  };
  function SelectionContext$Multi() {
    this.store = new ComponentProperty(null);
    this.rows = new DynamicComponentProperty(emptyFlow());
  }
  SelectionContext$Multi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Multi',
    interfaces: []
  };
  SelectionContext.prototype.multi_80fo8$ = function (value) {
    var $receiver = new SelectionContext$Multi();
    value($receiver);
    this.multi_8be2vx$ = $receiver;
  };
  SelectionContext.prototype.strategy_893gsr$ = function (expression) {
    switch (expression(SelectionContext$StrategyContext_getInstance()).name) {
      case 'Checkbox':
        this.strategy.invoke_11rb$(new SelectionByCheckBox());
        break;
      case 'Click':
        this.strategy.invoke_11rb$(new SelectionByClick());
        break;
    }
  };
  Object.defineProperty(SelectionContext.prototype, 'selectionMode', {
    configurable: true,
    get: function () {
      return this.selectionMode_l3vb4q$_0.value;
    }
  });
  function SelectionContext$selectionMode$lambda(this$SelectionContext) {
    return function () {
      if (this$SelectionContext.single_8be2vx$ != null)
        return SelectionMode$Single_getInstance();
      else if (this$SelectionContext.multi_8be2vx$ != null)
        return SelectionMode$Multi_getInstance();
      else {
        return SelectionMode$None_getInstance();
      }
    };
  }
  SelectionContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SelectionContext',
    interfaces: []
  };
  function OptionsContext() {
    this.sorting = new ComponentProperty(new OptionsContext$SortingContext());
    this.hovering = new ComponentProperty(new OptionsContext$HoveringContext());
    this.width = new ComponentProperty('100%');
    this.maxWidth = new ComponentProperty(null);
    this.height = new ComponentProperty(null);
    this.maxHeight = new ComponentProperty('97vh');
    this.cellMinWidth = new ComponentProperty('130px');
    this.cellMaxWidth = new ComponentProperty('1fr');
  }
  function OptionsContext$SortingContext() {
    this.reducer = new ComponentProperty(new TogglingSortingPlanReducer());
    this.sorter = new ComponentProperty(new OneColumnSorter());
    this.renderer = new ComponentProperty(new SingleArrowSortingRenderer());
  }
  OptionsContext$SortingContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SortingContext',
    interfaces: []
  };
  OptionsContext.prototype.sorting_5oy434$ = function (value) {
    value(this.sorting.value);
  };
  function OptionsContext$HoveringContext() {
    this.active = new ComponentProperty(true);
    this.style = new ComponentProperty(OptionsContext$HoveringContext$style$lambda);
  }
  function OptionsContext$HoveringContext$style$lambda($receiver, it) {
    return Unit;
  }
  OptionsContext$HoveringContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HoveringContext',
    interfaces: []
  };
  OptionsContext.prototype.hovering_gtjubq$ = function (value) {
    value(this.hovering.value);
  };
  OptionsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionsContext',
    interfaces: []
  };
  function HeaderContext() {
    this.fixedHeader = new ComponentProperty(true);
    this.fixedHeaderHeight = new ComponentProperty('37px');
    this.styling = new ComponentProperty(HeaderContext$styling$lambda);
  }
  function HeaderContext$styling$lambda($receiver) {
    return Unit;
  }
  HeaderContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HeaderContext',
    interfaces: []
  };
  function DataTableContext() {
  }
  function DataTableContext$columns$lambda($receiver, it) {
    return Unit;
  }
  DataTableContext.prototype.columns_qvsxfn$ = function (styling, expression, callback$default) {
    if (styling === void 0)
      styling = DataTableContext$columns$lambda;
    callback$default ? callback$default(styling, expression) : this.columns_qvsxfn$$default(styling, expression);
  };
  function DataTableContext$header$lambda($receiver) {
    return Unit;
  }
  DataTableContext.prototype.header_81hq22$ = function (styling, expression, callback$default) {
    if (styling === void 0)
      styling = DataTableContext$header$lambda;
    callback$default ? callback$default(styling, expression) : this.header_81hq22$$default(styling, expression);
  };
  DataTableContext.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DataTableContext',
    interfaces: []
  };
  function DefaultContext(rowIdProvider) {
    this.columns_s52wqp$_0 = new ComponentProperty(new ColumnsContext());
    this.events_qlcvb1$_0 = new ComponentProperty(DefaultContext$events$lambda);
    this.selectionStore_bocj33$_0 = new RowSelectionStore(rowIdProvider);
    this.selection_bprclq$_0 = new ComponentProperty(new SelectionContext());
    this.options_xvwq5c$_0 = new ComponentProperty(new OptionsContext());
    this.header_8ips3b$_0 = new ComponentProperty(new HeaderContext());
  }
  Object.defineProperty(DefaultContext.prototype, 'columns', {
    configurable: true,
    get: function () {
      return this.columns_s52wqp$_0;
    }
  });
  DefaultContext.prototype.columns_qvsxfn$$default = function (styling, expression) {
    var $receiver = this.columns.value;
    expression($receiver);
    $receiver.styling.invoke_11rb$(styling);
  };
  DefaultContext.prototype.prependAdditionalColumns_g7bbd8$ = function (expression) {
    var iterator = this.columns.value.columns.values.iterator();
    if (!iterator.hasNext())
      throw NoSuchElementException_init();
    var minValue = iterator.next().position;
    while (iterator.hasNext()) {
      var v = iterator.next().position;
      if (Kotlin.compareTo(minValue, v) > 0) {
        minValue = v;
      }}
    var minPos = minValue;
    var tmp$ = this.columns.value.columns;
    var $receiver = new ColumnsContext();
    expression($receiver);
    var $receiver_0 = $receiver.columns;
    var destination = LinkedHashMap_init(mapCapacity($receiver_0.size));
    var tmp$_0;
    tmp$_0 = $receiver_0.entries.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      destination.put_xwzc9p$(element.key, element.value.copy_82mk2o$(void 0, void 0, void 0, void 0, void 0, void 0, minPos - 1 | 0));
    }
    var $receiver_1 = destination.entries;
    var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
    var tmp$_1;
    tmp$_1 = $receiver_1.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      var tmp$_2 = destination_0.add_11rb$;
      var a = item.key;
      var b = item.value;
      tmp$_2.call(destination_0, to(a, b));
    }
    tmp$.putAll_a2k3zr$(toMap(destination_0));
  };
  Object.defineProperty(DefaultContext.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.events_qlcvb1$_0;
    }
  });
  Object.defineProperty(DefaultContext.prototype, 'selectionStore', {
    configurable: true,
    get: function () {
      return this.selectionStore_bocj33$_0;
    }
  });
  Object.defineProperty(DefaultContext.prototype, 'selection', {
    configurable: true,
    get: function () {
      return this.selection_bprclq$_0;
    }
  });
  DefaultContext.prototype.selection_5o6y5j$ = function (value) {
    value(this.selection.value);
    if (this.selection.value.strategy.value == null) {
      switch (this.selection.value.selectionMode.name) {
        case 'Single':
          this.selection.value.strategy.invoke_11rb$(new SelectionByClick());
          break;
        case 'Multi':
          this.selection.value.strategy.invoke_11rb$(new SelectionByCheckBox());
          break;
        default:this.selection.value.strategy.invoke_11rb$(new NoSelection());
          break;
      }
    }};
  Object.defineProperty(DefaultContext.prototype, 'options', {
    configurable: true,
    get: function () {
      return this.options_xvwq5c$_0;
    }
  });
  DefaultContext.prototype.options_agnprp$ = function (value) {
    value(this.options.value);
  };
  Object.defineProperty(DefaultContext.prototype, 'header', {
    configurable: true,
    get: function () {
      return this.header_8ips3b$_0;
    }
  });
  DefaultContext.prototype.header_81hq22$$default = function (styling, expression) {
    var $receiver = this.header.value;
    expression($receiver);
    $receiver.styling.invoke_11rb$(styling);
  };
  function DefaultContext$events$lambda($receiver) {
    return Unit;
  }
  DefaultContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultContext',
    interfaces: [DataTableContext]
  };
  function Sorting(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Sorting_initFields() {
    Sorting_initFields = function () {
    };
    Sorting$DISABLED_instance = new Sorting('DISABLED', 0);
    Sorting$NONE_instance = new Sorting('NONE', 1);
    Sorting$ASC_instance = new Sorting('ASC', 2);
    Sorting$DESC_instance = new Sorting('DESC', 3);
    Sorting$Companion_getInstance();
  }
  var Sorting$DISABLED_instance;
  function Sorting$DISABLED_getInstance() {
    Sorting_initFields();
    return Sorting$DISABLED_instance;
  }
  var Sorting$NONE_instance;
  function Sorting$NONE_getInstance() {
    Sorting_initFields();
    return Sorting$NONE_instance;
  }
  var Sorting$ASC_instance;
  function Sorting$ASC_getInstance() {
    Sorting_initFields();
    return Sorting$ASC_instance;
  }
  var Sorting$DESC_instance;
  function Sorting$DESC_getInstance() {
    Sorting_initFields();
    return Sorting$DESC_instance;
  }
  function Sorting$Companion() {
    Sorting$Companion_instance = this;
  }
  Sorting$Companion.prototype.sorted_f02lu0$ = function (sorting) {
    return sorting === Sorting$ASC_getInstance() || sorting === Sorting$DESC_getInstance();
  };
  Sorting$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Sorting$Companion_instance = null;
  function Sorting$Companion_getInstance() {
    Sorting_initFields();
    if (Sorting$Companion_instance === null) {
      new Sorting$Companion();
    }return Sorting$Companion_instance;
  }
  Sorting.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sorting',
    interfaces: [Enum]
  };
  function Sorting$values() {
    return [Sorting$DISABLED_getInstance(), Sorting$NONE_getInstance(), Sorting$ASC_getInstance(), Sorting$DESC_getInstance()];
  }
  Sorting.values = Sorting$values;
  function Sorting$valueOf(name) {
    switch (name) {
      case 'DISABLED':
        return Sorting$DISABLED_getInstance();
      case 'NONE':
        return Sorting$NONE_getInstance();
      case 'ASC':
        return Sorting$ASC_getInstance();
      case 'DESC':
        return Sorting$DESC_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.datatable.Sorting.' + name);
    }
  }
  Sorting.valueOf_61zpoe$ = Sorting$valueOf;
  function SelectionMode(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function SelectionMode_initFields() {
    SelectionMode_initFields = function () {
    };
    SelectionMode$None_instance = new SelectionMode('None', 0);
    SelectionMode$Single_instance = new SelectionMode('Single', 1);
    SelectionMode$Multi_instance = new SelectionMode('Multi', 2);
  }
  var SelectionMode$None_instance;
  function SelectionMode$None_getInstance() {
    SelectionMode_initFields();
    return SelectionMode$None_instance;
  }
  var SelectionMode$Single_instance;
  function SelectionMode$Single_getInstance() {
    SelectionMode_initFields();
    return SelectionMode$Single_instance;
  }
  var SelectionMode$Multi_instance;
  function SelectionMode$Multi_getInstance() {
    SelectionMode_initFields();
    return SelectionMode$Multi_instance;
  }
  SelectionMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SelectionMode',
    interfaces: [Enum]
  };
  function SelectionMode$values() {
    return [SelectionMode$None_getInstance(), SelectionMode$Single_getInstance(), SelectionMode$Multi_getInstance()];
  }
  SelectionMode.values = SelectionMode$values;
  function SelectionMode$valueOf(name) {
    switch (name) {
      case 'None':
        return SelectionMode$None_getInstance();
      case 'Single':
        return SelectionMode$Single_getInstance();
      case 'Multi':
        return SelectionMode$Multi_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.datatable.SelectionMode.' + name);
    }
  }
  SelectionMode.valueOf_61zpoe$ = SelectionMode$valueOf;
  function StatefulItem(item, selected, sorting) {
    this.item = item;
    this.selected = selected;
    this.sorting = sorting;
  }
  StatefulItem.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StatefulItem',
    interfaces: []
  };
  StatefulItem.prototype.component1 = function () {
    return this.item;
  };
  StatefulItem.prototype.component2 = function () {
    return this.selected;
  };
  StatefulItem.prototype.component3 = function () {
    return this.sorting;
  };
  StatefulItem.prototype.copy_rbkasc$ = function (item, selected, sorting) {
    return new StatefulItem(item === void 0 ? this.item : item, selected === void 0 ? this.selected : selected, sorting === void 0 ? this.sorting : sorting);
  };
  StatefulItem.prototype.toString = function () {
    return 'StatefulItem(item=' + Kotlin.toString(this.item) + (', selected=' + Kotlin.toString(this.selected)) + (', sorting=' + Kotlin.toString(this.sorting)) + ')';
  };
  StatefulItem.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.item) | 0;
    result = result * 31 + Kotlin.hashCode(this.selected) | 0;
    result = result * 31 + Kotlin.hashCode(this.sorting) | 0;
    return result;
  };
  StatefulItem.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.item, other.item) && Kotlin.equals(this.selected, other.selected) && Kotlin.equals(this.sorting, other.sorting)))));
  };
  function Column(id, lens, title, minWidth, maxWidth, hidden, position, sorting, sortBy, styling, content, headerStyling, headerContent) {
    if (lens === void 0)
      lens = null;
    if (title === void 0)
      title = '';
    if (minWidth === void 0)
      minWidth = null;
    if (maxWidth === void 0)
      maxWidth = null;
    if (hidden === void 0)
      hidden = false;
    if (position === void 0)
      position = 0;
    if (sorting === void 0)
      sorting = Sorting$NONE_getInstance();
    if (sortBy === void 0)
      sortBy = null;
    if (styling === void 0)
      styling = Column_init$lambda;
    if (headerStyling === void 0)
      headerStyling = Column_init$lambda_0;
    this.id = id;
    this.lens = lens;
    this.title = title;
    this.minWidth = minWidth;
    this.maxWidth = maxWidth;
    this.hidden = hidden;
    this.position = position;
    this.sorting = sorting;
    this.sortBy = sortBy;
    this.styling = styling;
    this.content = content;
    this.headerStyling = headerStyling;
    this.headerContent = headerContent;
  }
  function Column_init$lambda($receiver, f) {
    return Unit;
  }
  function Column_init$lambda_0($receiver, it) {
    return Unit;
  }
  Column.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Column',
    interfaces: []
  };
  Column.prototype.component1 = function () {
    return this.id;
  };
  Column.prototype.component2 = function () {
    return this.lens;
  };
  Column.prototype.component3 = function () {
    return this.title;
  };
  Column.prototype.component4 = function () {
    return this.minWidth;
  };
  Column.prototype.component5 = function () {
    return this.maxWidth;
  };
  Column.prototype.component6 = function () {
    return this.hidden;
  };
  Column.prototype.component7 = function () {
    return this.position;
  };
  Column.prototype.component8 = function () {
    return this.sorting;
  };
  Column.prototype.component9 = function () {
    return this.sortBy;
  };
  Column.prototype.component10 = function () {
    return this.styling;
  };
  Column.prototype.component11 = function () {
    return this.content;
  };
  Column.prototype.component12 = function () {
    return this.headerStyling;
  };
  Column.prototype.component13 = function () {
    return this.headerContent;
  };
  Column.prototype.copy_82mk2o$ = function (id, lens, title, minWidth, maxWidth, hidden, position, sorting, sortBy, styling, content, headerStyling, headerContent) {
    return new Column(id === void 0 ? this.id : id, lens === void 0 ? this.lens : lens, title === void 0 ? this.title : title, minWidth === void 0 ? this.minWidth : minWidth, maxWidth === void 0 ? this.maxWidth : maxWidth, hidden === void 0 ? this.hidden : hidden, position === void 0 ? this.position : position, sorting === void 0 ? this.sorting : sorting, sortBy === void 0 ? this.sortBy : sortBy, styling === void 0 ? this.styling : styling, content === void 0 ? this.content : content, headerStyling === void 0 ? this.headerStyling : headerStyling, headerContent === void 0 ? this.headerContent : headerContent);
  };
  Column.prototype.toString = function () {
    return 'Column(id=' + Kotlin.toString(this.id) + (', lens=' + Kotlin.toString(this.lens)) + (', title=' + Kotlin.toString(this.title)) + (', minWidth=' + Kotlin.toString(this.minWidth)) + (', maxWidth=' + Kotlin.toString(this.maxWidth)) + (', hidden=' + Kotlin.toString(this.hidden)) + (', position=' + Kotlin.toString(this.position)) + (', sorting=' + Kotlin.toString(this.sorting)) + (', sortBy=' + Kotlin.toString(this.sortBy)) + (', styling=' + Kotlin.toString(this.styling)) + (', content=' + Kotlin.toString(this.content)) + (', headerStyling=' + Kotlin.toString(this.headerStyling)) + (', headerContent=' + Kotlin.toString(this.headerContent)) + ')';
  };
  Column.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.lens) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.minWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.hidden) | 0;
    result = result * 31 + Kotlin.hashCode(this.position) | 0;
    result = result * 31 + Kotlin.hashCode(this.sorting) | 0;
    result = result * 31 + Kotlin.hashCode(this.sortBy) | 0;
    result = result * 31 + Kotlin.hashCode(this.styling) | 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    result = result * 31 + Kotlin.hashCode(this.headerStyling) | 0;
    result = result * 31 + Kotlin.hashCode(this.headerContent) | 0;
    return result;
  };
  Column.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.lens, other.lens) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.minWidth, other.minWidth) && Kotlin.equals(this.maxWidth, other.maxWidth) && Kotlin.equals(this.hidden, other.hidden) && Kotlin.equals(this.position, other.position) && Kotlin.equals(this.sorting, other.sorting) && Kotlin.equals(this.sortBy, other.sortBy) && Kotlin.equals(this.styling, other.styling) && Kotlin.equals(this.content, other.content) && Kotlin.equals(this.headerStyling, other.headerStyling) && Kotlin.equals(this.headerContent, other.headerContent)))));
  };
  function columnIdProvider(param) {
    var tmp$;
    var $receiver = (tmp$ = param.first.lens) != null ? tmp$.get_11rb$(param.second.value.item) : null;
    var tmp$_0;
    return (((tmp$_0 = $receiver != null ? hashCode($receiver) : null) != null ? tmp$_0 : 0) * 31 | 0) + (param.second.index * 31 | 0) + (hashCode(param.second.value.selected) * 31 | 0) + (param.second.value.sorting.hashCode() * 31 | 0) | 0;
  }
  function ColumnIdSorting(id, strategy) {
    ColumnIdSorting$Companion_getInstance();
    if (strategy === void 0)
      strategy = Sorting$NONE_getInstance();
    this.id = id;
    this.strategy = strategy;
  }
  function ColumnIdSorting$Companion() {
    ColumnIdSorting$Companion_instance = this;
  }
  ColumnIdSorting$Companion.prototype.noSorting = function () {
    return new ColumnIdSorting(null);
  };
  ColumnIdSorting$Companion.prototype.of_4wzt4c$ = function (column) {
    return new ColumnIdSorting(column.id, column.sorting);
  };
  ColumnIdSorting$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ColumnIdSorting$Companion_instance = null;
  function ColumnIdSorting$Companion_getInstance() {
    if (ColumnIdSorting$Companion_instance === null) {
      new ColumnIdSorting$Companion();
    }return ColumnIdSorting$Companion_instance;
  }
  ColumnIdSorting.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColumnIdSorting',
    interfaces: []
  };
  ColumnIdSorting.prototype.component1 = function () {
    return this.id;
  };
  ColumnIdSorting.prototype.component2 = function () {
    return this.strategy;
  };
  ColumnIdSorting.prototype.copy_4sv7tv$ = function (id, strategy) {
    return new ColumnIdSorting(id === void 0 ? this.id : id, strategy === void 0 ? this.strategy : strategy);
  };
  ColumnIdSorting.prototype.toString = function () {
    return 'ColumnIdSorting(id=' + Kotlin.toString(this.id) + (', strategy=' + Kotlin.toString(this.strategy)) + ')';
  };
  ColumnIdSorting.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.strategy) | 0;
    return result;
  };
  ColumnIdSorting.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.strategy, other.strategy)))));
  };
  function unsafeFlow$ObjectLiteral_2(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_2($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_2.prototype.constructor = Coroutine$collect_42ocv1$_2;
  Coroutine$collect_42ocv1$_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_2.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_2(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_2.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_2.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_2;
  Coroutine$unsafeTransform$lambda$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_2(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_2.prototype.constructor = Coroutine$unsafeTransform$lambda_2;
  Coroutine$unsafeTransform$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_2(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_2(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_2(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_2(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_2.prototype.constructor = Coroutine$map$lambda_2;
  Coroutine$map$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_2(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_2(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RowSelectionStore(rowIdProvider) {
    RootStore.call(this, emptyList());
    this.rowIdProvider_0 = rowIdProvider;
    this.selectedData = drop(this.data, 1);
    this.syncHandler = this.handle_ajdi87$(void 0, RowSelectionStore$syncHandler$lambda(this));
    this.selectRows = this.handleAndEmit_6gppb5$(void 0, RowSelectionStore$selectRows$lambda(this));
    this.selectRow = this.handle_ajdi87$(void 0, RowSelectionStore$selectRow$lambda);
    this.updateRow = this.handle_ajdi87$(void 0, RowSelectionStore$updateRow$lambda);
    this.dbClickedRow = this.handleAndEmit_6gppb5$(void 0, RowSelectionStore$dbClickedRow$lambda);
  }
  function Coroutine$RowSelectionStore$isDataRowSelected$lambda(closure$item_0, selectedRows_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$item = closure$item_0;
    this.local$selectedRows = selectedRows_0;
  }
  Coroutine$RowSelectionStore$isDataRowSelected$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RowSelectionStore$isDataRowSelected$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RowSelectionStore$isDataRowSelected$lambda.prototype.constructor = Coroutine$RowSelectionStore$isDataRowSelected$lambda;
  Coroutine$RowSelectionStore$isDataRowSelected$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$selectedRows.contains_11rb$(this.local$closure$item);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RowSelectionStore$isDataRowSelected$lambda(closure$item_0) {
    return function (selectedRows_0, continuation_0, suspended) {
      var instance = new Coroutine$RowSelectionStore$isDataRowSelected$lambda(closure$item_0, selectedRows_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  RowSelectionStore.prototype.isDataRowSelected_11rb$ = function (item) {
    var $receiver = this.data;
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(RowSelectionStore$isDataRowSelected$lambda(item)), $receiver));
  };
  function Coroutine$RowSelectionStore$syncHandler$lambda(this$RowSelectionStore_0, old_0, allItems_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$RowSelectionStore = this$RowSelectionStore_0;
    this.local$old = old_0;
    this.local$allItems = allItems_0;
  }
  Coroutine$RowSelectionStore$syncHandler$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RowSelectionStore$syncHandler$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RowSelectionStore$syncHandler$lambda.prototype.constructor = Coroutine$RowSelectionStore$syncHandler$lambda;
  Coroutine$RowSelectionStore$syncHandler$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var destination = ArrayList_init_0();
            var tmp$;
            tmp$ = this.local$old.iterator();
            loop_label: while (tmp$.hasNext()) {
              var element = tmp$.next();
              var tmp$_0;
              var this$RowSelectionStore = this.local$this$RowSelectionStore;
              var firstOrNull$result;
              firstOrNull$break: do {
                var tmp$_1;
                tmp$_1 = this.local$allItems.iterator();
                while (tmp$_1.hasNext()) {
                  var element_0 = tmp$_1.next();
                  if (equals(this$RowSelectionStore.rowIdProvider_0(element_0), this$RowSelectionStore.rowIdProvider_0(element))) {
                    firstOrNull$result = element_0;
                    break firstOrNull$break;
                  }}
                firstOrNull$result = null;
              }
               while (false);
              if ((tmp$_0 = firstOrNull$result) != null) {
                destination.add_11rb$(tmp$_0);
              }}

            return destination;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RowSelectionStore$syncHandler$lambda(this$RowSelectionStore_0) {
    return function (old_0, allItems_0, continuation_0, suspended) {
      var instance = new Coroutine$RowSelectionStore$syncHandler$lambda(this$RowSelectionStore_0, old_0, allItems_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$RowSelectionStore$selectRows$lambda(this$RowSelectionStore_0, $receiver_0, selectedRows_0, new_1, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$RowSelectionStore = this$RowSelectionStore_0;
    this.local$newSelection = void 0;
    this.local$$receiver = $receiver_0;
    this.local$selectedRows = selectedRows_0;
    this.local$new = new_1;
  }
  Coroutine$RowSelectionStore$selectRows$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RowSelectionStore$selectRows$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RowSelectionStore$selectRows$lambda.prototype.constructor = Coroutine$RowSelectionStore$selectRows$lambda;
  Coroutine$RowSelectionStore$selectRows$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            if (this.local$selectedRows.contains_11rb$(this.local$new))
              tmp$ = minus(this.local$selectedRows, this.local$new);
            else {
              var destination = ArrayList_init(collectionSizeOrDefault(this.local$selectedRows, 10));
              var tmp$_0;
              tmp$_0 = this.local$selectedRows.iterator();
              while (tmp$_0.hasNext()) {
                var item = tmp$_0.next();
                var tmp$_1 = destination.add_11rb$;
                var this$RowSelectionStore = this.local$this$RowSelectionStore;
                tmp$_1.call(destination, equals(this$RowSelectionStore.rowIdProvider_0(item), this$RowSelectionStore.rowIdProvider_0(this.local$new)) ? this.local$new : item);
              }
              var temp = destination;
              var any$result;
              any$break: do {
                var tmp$_2;
                if (Kotlin.isType(temp, Collection) && temp.isEmpty()) {
                  any$result = false;
                  break any$break;
                }tmp$_2 = temp.iterator();
                while (tmp$_2.hasNext()) {
                  var element = tmp$_2.next();
                  var this$RowSelectionStore_0 = this.local$this$RowSelectionStore;
                  if (equals(this$RowSelectionStore_0.rowIdProvider_0(element), this$RowSelectionStore_0.rowIdProvider_0(this.local$new))) {
                    any$result = true;
                    break any$break;
                  }}
                any$result = false;
              }
               while (false);
              tmp$ = any$result ? temp : plus(temp, this.local$new);
            }

            this.local$newSelection = tmp$;
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(this.local$newSelection, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$newSelection;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RowSelectionStore$selectRows$lambda(this$RowSelectionStore_0) {
    return function ($receiver_0, selectedRows_0, new_1, continuation_0, suspended) {
      var instance = new Coroutine$RowSelectionStore$selectRows$lambda(this$RowSelectionStore_0, $receiver_0, selectedRows_0, new_1, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$RowSelectionStore$selectRow$lambda(old_0, new_1, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$old = old_0;
    this.local$new = new_1;
  }
  Coroutine$RowSelectionStore$selectRow$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RowSelectionStore$selectRow$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RowSelectionStore$selectRow$lambda.prototype.constructor = Coroutine$RowSelectionStore$selectRow$lambda;
  Coroutine$RowSelectionStore$selectRow$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            if (this.local$new == null || equals(firstOrNull(this.local$old), this.local$new)) {
              tmp$ = emptyList();
            } else {
              tmp$ = listOf(this.local$new);
            }

            var newSelection = tmp$;
            return newSelection;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RowSelectionStore$selectRow$lambda(old_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$RowSelectionStore$selectRow$lambda(old_0, new_1, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$RowSelectionStore$updateRow$lambda(f_0, new_1, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$new = new_1;
  }
  Coroutine$RowSelectionStore$updateRow$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RowSelectionStore$updateRow$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RowSelectionStore$updateRow$lambda.prototype.constructor = Coroutine$RowSelectionStore$updateRow$lambda;
  Coroutine$RowSelectionStore$updateRow$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$new == null ? emptyList() : listOf(this.local$new);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RowSelectionStore$updateRow$lambda(f_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$RowSelectionStore$updateRow$lambda(f_0, new_1, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$RowSelectionStore$dbClickedRow$lambda($receiver_0, selectedRows_0, new_1, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$selectedRows = selectedRows_0;
    this.local$new = new_1;
  }
  Coroutine$RowSelectionStore$dbClickedRow$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RowSelectionStore$dbClickedRow$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RowSelectionStore$dbClickedRow$lambda.prototype.constructor = Coroutine$RowSelectionStore$dbClickedRow$lambda;
  Coroutine$RowSelectionStore$dbClickedRow$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(this.local$new, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$selectedRows;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RowSelectionStore$dbClickedRow$lambda($receiver_0, selectedRows_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$RowSelectionStore$dbClickedRow$lambda($receiver_0, selectedRows_0, new_1, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  RowSelectionStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RowSelectionStore',
    interfaces: [RootStore]
  };
  function SelectionStrategy() {
  }
  SelectionStrategy.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SelectionStrategy',
    interfaces: []
  };
  function NoSelection() {
  }
  NoSelection.prototype.manageSelectionByExtraColumn_udrkn6$ = function (component) {
  };
  NoSelection.prototype.manageSelectionByRowEvents_ri6i38$ = function (component, rowStore, renderContext) {
  };
  NoSelection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NoSelection',
    interfaces: [SelectionStrategy]
  };
  function SelectionByCheckBox() {
    this.commonSettings_0 = SelectionByCheckBox$commonSettings$lambda;
    this.headerSettings_0 = SelectionByCheckBox$headerSettings$lambda;
  }
  function SelectionByCheckBox$manageSelectionByExtraColumn$lambda$lambda$lambda(this$SelectionByCheckBox, closure$component) {
    return function ($receiver) {
      this$SelectionByCheckBox.headerSettings_0($receiver, closure$component);
      this$SelectionByCheckBox.commonSettings_0($receiver, closure$component);
      return Unit;
    };
  }
  function SelectionByCheckBox$manageSelectionByExtraColumn$lambda$lambda$lambda_0(this$SelectionByCheckBox, closure$component) {
    return function ($receiver) {
      this$SelectionByCheckBox.commonSettings_0($receiver, closure$component);
      return Unit;
    };
  }
  function SelectionByCheckBox$manageSelectionByExtraColumn$lambda$lambda(this$, this$SelectionByCheckBox, closure$component) {
    return function ($receiver) {
      switch (this$.selection.value.selectionMode.name) {
        case 'Multi':
          $receiver.column_obnj8v$(void 0, SelectionByCheckBox$manageSelectionByExtraColumn$lambda$lambda$lambda(this$SelectionByCheckBox, closure$component));
          break;
        case 'Single':
          $receiver.column_obnj8v$(void 0, SelectionByCheckBox$manageSelectionByExtraColumn$lambda$lambda$lambda_0(this$SelectionByCheckBox, closure$component));
          break;
        default:break;
      }
      return Unit;
    };
  }
  SelectionByCheckBox.prototype.manageSelectionByExtraColumn_udrkn6$ = function (component) {
    component.prependAdditionalColumns_g7bbd8$(SelectionByCheckBox$manageSelectionByExtraColumn$lambda$lambda(component, this, component));
  };
  SelectionByCheckBox.prototype.manageSelectionByRowEvents_ri6i38$ = function (component, rowStore, renderContext) {
  };
  function SelectionByCheckBox$commonSettings$lambda$lambda($receiver) {
    $receiver.min.invoke_11rb$('60px');
    $receiver.max.invoke_11rb$('60px');
    return Unit;
  }
  function SelectionByCheckBox$commonSettings$lambda$lambda_0($receiver) {
    return $receiver.disabled;
  }
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda($receiver) {
    return '0';
  }
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda($receiver) {
    $receiver.margin_bcpvvc$(SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda(closure$rowStore_0, selectedRows_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowStore = closure$rowStore_0;
    this.local$selectedRows = selectedRows_0;
  }
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda;
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$selectedRows.contains_11rb$(this.local$closure$rowStore.current);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda_0(closure$rowStore_0) {
    return function (selectedRows_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda(closure$rowStore_0, selectedRows_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda(closure$rowStore_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowStore = closure$rowStore_0;
  }
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda;
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$rowStore.current;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda(closure$rowStore_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda(closure$rowStore_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0(closure$rowStore_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowStore = closure$rowStore_0;
  }
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0;
  Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$rowStore.current;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0(closure$rowStore_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0(closure$rowStore_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda_1(closure$component, closure$rowStore) {
    return function ($receiver) {
      switch (closure$component.selection.value.selectionMode.name) {
        case 'Single':
          var $receiver_0 = $receiver.clicks.events;
          $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda(closure$rowStore)), $receiver_0)), closure$component.selectionStore.selectRow);
          break;
        case 'Multi':
          var $receiver_1 = $receiver.clicks.events;
          $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda$lambda_0(closure$rowStore)), $receiver_1)), closure$component.selectionStore.selectRows);
          break;
        default:break;
      }
      return Unit;
    };
  }
  function SelectionByCheckBox$commonSettings$lambda$lambda$lambda_0(closure$component, closure$rowStore) {
    return function ($receiver) {
      var tmp$ = $receiver.checked;
      var $receiver_0 = closure$component.selectionStore.data;
      tmp$.invoke_ror2s8$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda_0(closure$rowStore)), $receiver_0)));
      $receiver.events.invoke_11rb$(SelectionByCheckBox$commonSettings$lambda$lambda$lambda$lambda_1(closure$component, closure$rowStore));
      return Unit;
    };
  }
  function SelectionByCheckBox$commonSettings$lambda$lambda_1(closure$component) {
    return function ($receiver, f, f_0, rowStore) {
      checkbox($receiver, SelectionByCheckBox$commonSettings$lambda$lambda$lambda, void 0, void 0, identification.Id.next_za3lpa$(), void 0, SelectionByCheckBox$commonSettings$lambda$lambda$lambda_0(closure$component, rowStore));
      return Unit;
    };
  }
  function SelectionByCheckBox$commonSettings$lambda($receiver, component) {
    $receiver.width_ie1rgt$(SelectionByCheckBox$commonSettings$lambda$lambda);
    $receiver.sorting.invoke_11rb$(SelectionByCheckBox$commonSettings$lambda$lambda_0);
    $receiver.content.invoke_11rb$(SelectionByCheckBox$commonSettings$lambda$lambda_1(component));
    return Unit;
  }
  function SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.inlineBlock;
  }
  function SelectionByCheckBox$headerSettings$lambda$lambda$lambda($receiver) {
    $receiver.display_1gh9wc$(SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda(closure$component_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$component = closure$component_0;
    this.local$it = it_0;
  }
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda;
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it.isEmpty() && equals(this.local$it, this.local$closure$component.dataStore.current);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda_0(closure$component_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda(closure$component_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda(closure$component_0, selected_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$component = closure$component_0;
    this.local$selected = selected_0;
  }
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda;
  Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$selected) {
              return this.local$closure$component.dataStore.current;
            } else {
              return emptyList();
            }

          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda(closure$component_0) {
    return function (selected_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda(closure$component_0, selected_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda_1(closure$component) {
    return function ($receiver) {
      var $receiver_0 = states($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda$lambda(closure$component)), $receiver_0)), closure$component.selectionStore.update);
      return Unit;
    };
  }
  function SelectionByCheckBox$headerSettings$lambda$lambda$lambda_0(closure$component) {
    return function ($receiver) {
      var tmp$ = $receiver.checked;
      var $receiver_0 = closure$component.selectionStore.data;
      tmp$.invoke_ror2s8$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda_0(closure$component)), $receiver_0)));
      $receiver.events.invoke_11rb$(SelectionByCheckBox$headerSettings$lambda$lambda$lambda$lambda_1(closure$component));
      return Unit;
    };
  }
  function SelectionByCheckBox$headerSettings$lambda$lambda(closure$component) {
    return function ($receiver, it) {
      checkbox($receiver, SelectionByCheckBox$headerSettings$lambda$lambda$lambda, void 0, void 0, identification.Id.next_za3lpa$(), void 0, SelectionByCheckBox$headerSettings$lambda$lambda$lambda_0(closure$component));
      return Unit;
    };
  }
  function SelectionByCheckBox$headerSettings$lambda($receiver, component) {
    $receiver.header_dxk5zr$(void 0, SelectionByCheckBox$headerSettings$lambda$lambda(component));
    return Unit;
  }
  SelectionByCheckBox.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SelectionByCheckBox',
    interfaces: [SelectionStrategy]
  };
  function SelectionByClick() {
  }
  SelectionByClick.prototype.manageSelectionByExtraColumn_udrkn6$ = function (component) {
  };
  function Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda(closure$rowStore_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowStore = closure$rowStore_0;
  }
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda.prototype.constructor = Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda;
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$rowStore.current;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByClick$manageSelectionByRowEvents$lambda$lambda(closure$rowStore_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda(closure$rowStore_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0(closure$rowStore_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$rowStore = closure$rowStore_0;
  }
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0.prototype.constructor = Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0;
  Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$rowStore.current;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0(closure$rowStore_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0(closure$rowStore_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  SelectionByClick.prototype.manageSelectionByRowEvents_ri6i38$ = function (component, rowStore, renderContext) {
    switch (component.selection.value.selectionMode.name) {
      case 'Single':
        var $receiver = renderContext.clicks.events;
        renderContext.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByClick$manageSelectionByRowEvents$lambda$lambda(rowStore)), $receiver)), component.selectionStore.selectRow);
        break;
      case 'Multi':
        var $receiver_0 = renderContext.clicks.events;
        renderContext.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_2(SelectionByClick$manageSelectionByRowEvents$lambda$lambda_0(rowStore)), $receiver_0)), component.selectionStore.selectRows);
        break;
      default:break;
    }
  };
  SelectionByClick.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SelectionByClick',
    interfaces: [SelectionStrategy]
  };
  var compareBy$lambda_1 = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  var compareByDescending$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(b), selector(a));
      };
    };
  });
  function RowSorter() {
  }
  RowSorter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'RowSorter',
    interfaces: []
  };
  function OneColumnSorter() {
  }
  OneColumnSorter.prototype.sortedBy_v023n7$ = function (rows, columnSortingPlan) {
    if (!columnSortingPlan.isEmpty()) {
      var tmp$ = first(columnSortingPlan);
      var config = tmp$.component1()
      , sorting = tmp$.component2();
      if (sorting !== Sorting$DISABLED_getInstance() && sorting !== Sorting$NONE_getInstance() && (config.lens != null || config.sortBy != null)) {
        return sortedWith(rows, this.createComparator_0(config, sorting));
      } else
        return rows;
    } else {
      return rows;
    }
  };
  function OneColumnSorter$createComparator$lambda(closure$column) {
    return function (it) {
      return ensureNotNull(closure$column.lens).get_11rb$(it);
    };
  }
  function OneColumnSorter$createComparator$lambda_0(closure$column) {
    return function (it) {
      return ensureNotNull(closure$column.lens).get_11rb$(it);
    };
  }
  OneColumnSorter.prototype.createComparator_0 = function (column, sorting) {
    var tmp$, tmp$_0;
    if (column.sortBy == null) {
      if (equals(sorting, Sorting$ASC_getInstance())) {
        tmp$ = new Comparator(compareBy$lambda_1(OneColumnSorter$createComparator$lambda(column)));
      } else {
        tmp$ = new Comparator(compareByDescending$lambda(OneColumnSorter$createComparator$lambda_0(column)));
      }
      return tmp$;
    } else {
      if (equals(sorting, Sorting$ASC_getInstance()))
        tmp$_0 = column.sortBy;
      else {
        tmp$_0 = reversed(column.sortBy);
      }
      return tmp$_0;
    }
  };
  OneColumnSorter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OneColumnSorter',
    interfaces: [RowSorter]
  };
  function SortingRenderer() {
  }
  SortingRenderer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SortingRenderer',
    interfaces: []
  };
  function SingleArrowSortingRenderer() {
  }
  function SingleArrowSortingRenderer$renderSortingActive$lambda$lambda$lambda(closure$sorting) {
    return function ($receiver) {
      return closure$sorting === Sorting$ASC_getInstance() ? $receiver.arrowUp : $receiver.arrowDown;
    };
  }
  function SingleArrowSortingRenderer$renderSortingActive$lambda$lambda(closure$sorting) {
    return function ($receiver) {
      $receiver.fromTheme_q0wvou$(SingleArrowSortingRenderer$renderSortingActive$lambda$lambda$lambda(closure$sorting));
      return Unit;
    };
  }
  SingleArrowSortingRenderer.prototype.renderSortingActive_5r7g3g$ = function (context, sorting) {
    if (equals(sorting, Sorting$NONE_getInstance()))
      this.renderSortingLost_dsmk0w$(context);
    else
      icon(context, void 0, void 0, void 0, void 0, SingleArrowSortingRenderer$renderSortingActive$lambda$lambda(sorting));
  };
  function SingleArrowSortingRenderer$renderSortingLost$lambda$lambda$lambda($receiver) {
    return $receiver.sort;
  }
  function SingleArrowSortingRenderer$renderSortingLost$lambda$lambda($receiver) {
    $receiver.fromTheme_q0wvou$(SingleArrowSortingRenderer$renderSortingLost$lambda$lambda$lambda);
    return Unit;
  }
  SingleArrowSortingRenderer.prototype.renderSortingLost_dsmk0w$ = function (context) {
    icon(context, void 0, void 0, void 0, void 0, SingleArrowSortingRenderer$renderSortingLost$lambda$lambda);
  };
  SingleArrowSortingRenderer.prototype.renderSortingDisabled_dsmk0w$ = function (context) {
  };
  SingleArrowSortingRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleArrowSortingRenderer',
    interfaces: [SortingRenderer]
  };
  function SortingPlanReducer() {
  }
  SortingPlanReducer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SortingPlanReducer',
    interfaces: []
  };
  function TogglingSortingPlanReducer() {
  }
  TogglingSortingPlanReducer.prototype.reduce_pt1wo5$ = function (sortingPlan, activated) {
    var tmp$, tmp$_0;
    if (activated.strategy === Sorting$DISABLED_getInstance()) {
      return sortingPlan;
    } else {
      tmp$ = activated.id;
      if (!sortingPlan.isEmpty() && equals(first(sortingPlan).id, activated.id)) {
        switch (first(sortingPlan).strategy.name) {
          case 'ASC':
            tmp$_0 = Sorting$DESC_getInstance();
            break;
          case 'DESC':
            tmp$_0 = Sorting$NONE_getInstance();
            break;
          default:tmp$_0 = Sorting$ASC_getInstance();
            break;
        }
      } else {
        tmp$_0 = Sorting$ASC_getInstance();
      }
      return listOf(new ColumnIdSorting(tmp$, tmp$_0));
    }
  };
  TogglingSortingPlanReducer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TogglingSortingPlanReducer',
    interfaces: [SortingPlanReducer]
  };
  function DropdownComponent() {
    this.toggle = new ComponentProperty(DropdownComponent$toggle$lambda);
    this.placement = new ComponentProperty(DropdownComponent$placement$lambda);
    this.alignment = new ComponentProperty(DropdownComponent$alignment$lambda);
    this.content = new ComponentProperty(DropdownComponent$content$lambda);
    this.visible_qvw1h8$_0 = new DropdownComponent$visible$ObjectLiteral(false);
  }
  function DropdownComponent$Placement(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function DropdownComponent$Placement_initFields() {
    DropdownComponent$Placement_initFields = function () {
    };
    DropdownComponent$Placement$Left_instance = new DropdownComponent$Placement('Left', 0);
    DropdownComponent$Placement$Right_instance = new DropdownComponent$Placement('Right', 1);
    DropdownComponent$Placement$Top_instance = new DropdownComponent$Placement('Top', 2);
    DropdownComponent$Placement$Bottom_instance = new DropdownComponent$Placement('Bottom', 3);
  }
  var DropdownComponent$Placement$Left_instance;
  function DropdownComponent$Placement$Left_getInstance() {
    DropdownComponent$Placement_initFields();
    return DropdownComponent$Placement$Left_instance;
  }
  var DropdownComponent$Placement$Right_instance;
  function DropdownComponent$Placement$Right_getInstance() {
    DropdownComponent$Placement_initFields();
    return DropdownComponent$Placement$Right_instance;
  }
  var DropdownComponent$Placement$Top_instance;
  function DropdownComponent$Placement$Top_getInstance() {
    DropdownComponent$Placement_initFields();
    return DropdownComponent$Placement$Top_instance;
  }
  var DropdownComponent$Placement$Bottom_instance;
  function DropdownComponent$Placement$Bottom_getInstance() {
    DropdownComponent$Placement_initFields();
    return DropdownComponent$Placement$Bottom_instance;
  }
  DropdownComponent$Placement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Placement',
    interfaces: [Enum]
  };
  function DropdownComponent$Placement$values() {
    return [DropdownComponent$Placement$Left_getInstance(), DropdownComponent$Placement$Right_getInstance(), DropdownComponent$Placement$Top_getInstance(), DropdownComponent$Placement$Bottom_getInstance()];
  }
  DropdownComponent$Placement.values = DropdownComponent$Placement$values;
  function DropdownComponent$Placement$valueOf(name) {
    switch (name) {
      case 'Left':
        return DropdownComponent$Placement$Left_getInstance();
      case 'Right':
        return DropdownComponent$Placement$Right_getInstance();
      case 'Top':
        return DropdownComponent$Placement$Top_getInstance();
      case 'Bottom':
        return DropdownComponent$Placement$Bottom_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.DropdownComponent.Placement.' + name);
    }
  }
  DropdownComponent$Placement.valueOf_61zpoe$ = DropdownComponent$Placement$valueOf;
  function DropdownComponent$PlacementContext() {
    DropdownComponent$PlacementContext_instance = this;
    this.left = DropdownComponent$Placement$Left_getInstance();
    this.right = DropdownComponent$Placement$Right_getInstance();
    this.top = DropdownComponent$Placement$Top_getInstance();
    this.bottom = DropdownComponent$Placement$Bottom_getInstance();
  }
  DropdownComponent$PlacementContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'PlacementContext',
    interfaces: []
  };
  var DropdownComponent$PlacementContext_instance = null;
  function DropdownComponent$PlacementContext_getInstance() {
    if (DropdownComponent$PlacementContext_instance === null) {
      new DropdownComponent$PlacementContext();
    }return DropdownComponent$PlacementContext_instance;
  }
  function DropdownComponent$Alignment(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function DropdownComponent$Alignment_initFields() {
    DropdownComponent$Alignment_initFields = function () {
    };
    DropdownComponent$Alignment$Start_instance = new DropdownComponent$Alignment('Start', 0);
    DropdownComponent$Alignment$End_instance = new DropdownComponent$Alignment('End', 1);
  }
  var DropdownComponent$Alignment$Start_instance;
  function DropdownComponent$Alignment$Start_getInstance() {
    DropdownComponent$Alignment_initFields();
    return DropdownComponent$Alignment$Start_instance;
  }
  var DropdownComponent$Alignment$End_instance;
  function DropdownComponent$Alignment$End_getInstance() {
    DropdownComponent$Alignment_initFields();
    return DropdownComponent$Alignment$End_instance;
  }
  DropdownComponent$Alignment.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Alignment',
    interfaces: [Enum]
  };
  function DropdownComponent$Alignment$values() {
    return [DropdownComponent$Alignment$Start_getInstance(), DropdownComponent$Alignment$End_getInstance()];
  }
  DropdownComponent$Alignment.values = DropdownComponent$Alignment$values;
  function DropdownComponent$Alignment$valueOf(name) {
    switch (name) {
      case 'Start':
        return DropdownComponent$Alignment$Start_getInstance();
      case 'End':
        return DropdownComponent$Alignment$End_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.DropdownComponent.Alignment.' + name);
    }
  }
  DropdownComponent$Alignment.valueOf_61zpoe$ = DropdownComponent$Alignment$valueOf;
  function DropdownComponent$AlignmentContext() {
    DropdownComponent$AlignmentContext_instance = this;
    this.start = DropdownComponent$Alignment$Start_getInstance();
    this.end = DropdownComponent$Alignment$End_getInstance();
  }
  DropdownComponent$AlignmentContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'AlignmentContext',
    interfaces: []
  };
  var DropdownComponent$AlignmentContext_instance = null;
  function DropdownComponent$AlignmentContext_getInstance() {
    if (DropdownComponent$AlignmentContext_instance === null) {
      new DropdownComponent$AlignmentContext();
    }return DropdownComponent$AlignmentContext_instance;
  }
  function DropdownComponent$render$lambda$lambda$lambda(this$DropdownComponent) {
    return function ($receiver) {
      this$DropdownComponent.toggle.value($receiver);
      $receiver.handledBy_jora5j$($receiver.clicks, this$DropdownComponent.visible_qvw1h8$_0.toggle);
      return Unit;
    };
  }
  function DropdownComponent$render$lambda$lambda$lambda_0(this$DropdownComponent, closure$styling, closure$baseClass, closure$prefix, closure$dropDown) {
    return function ($receiver, visible) {
      if (visible) {
        closure$dropDown.v = this$DropdownComponent.renderDropdown_m3rryq$_0($receiver, closure$styling, closure$baseClass, closure$prefix);
      }return Unit;
    };
  }
  function Coroutine$DropdownComponent$render$lambda$lambda$lambda(closure$dropDown_0, visible_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$dropDown = closure$dropDown_0;
    this.local$visible = visible_0;
  }
  Coroutine$DropdownComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DropdownComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DropdownComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$DropdownComponent$render$lambda$lambda$lambda;
  Coroutine$DropdownComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$visible)
              return (this.local$closure$dropDown.v == null ? throwUPAE('dropDown') : this.local$closure$dropDown.v).focus(), Unit;
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DropdownComponent$render$lambda$lambda$lambda_1(closure$dropDown_0) {
    return function (visible_0, continuation_0, suspended) {
      var instance = new Coroutine$DropdownComponent$render$lambda$lambda$lambda(closure$dropDown_0, visible_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function DropdownComponent$render$lambda$lambda(this$DropdownComponent, closure$styling, closure$baseClass, closure$prefix) {
    return function ($receiver) {
      $receiver.div_iz87dk$(void 0, void 0, void 0, DropdownComponent$render$lambda$lambda$lambda(this$DropdownComponent));
      var dropDown = {v: null};
      $receiver.render_a5p5o5$(this$DropdownComponent.visible_qvw1h8$_0.data, void 0, DropdownComponent$render$lambda$lambda$lambda_0(this$DropdownComponent, closure$styling, closure$baseClass, closure$prefix, dropDown));
      $receiver.handledBy_706ovd$(this$DropdownComponent.visible_qvw1h8$_0.data, DropdownComponent$render$lambda$lambda$lambda_1(dropDown));
      return Unit;
    };
  }
  DropdownComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    div(context, Theme.Companion.invoke().dropdown.container, void 0, id, void 0, void 0, DropdownComponent$render$lambda$lambda(this, styling, baseClass, prefix));
    return Unit;
  };
  function DropdownComponent$renderDropdown$lambda$lambda(this$DropdownComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().dropdown.dropdown);
      var placement = this$DropdownComponent.placement.value(DropdownComponent$PlacementContext_getInstance());
      var isVerticalPlacement = placement === DropdownComponent$Placement$Top_getInstance() || placement === DropdownComponent$Placement$Bottom_getInstance();
      switch (placement.name) {
        case 'Left':
          tmp$ = Theme.Companion.invoke().dropdown.placements.left;
          break;
        case 'Right':
          tmp$ = Theme.Companion.invoke().dropdown.placements.right;
          break;
        case 'Top':
          tmp$ = Theme.Companion.invoke().dropdown.placements.top;
          break;
        case 'Bottom':
          tmp$ = Theme.Companion.invoke().dropdown.placements.bottom;
          break;
        default:tmp$ = Kotlin.noWhenBranchMatched();
          break;
      }
      $receiver.invoke_qkhqzy$(tmp$);
      var alignments = Theme.Companion.invoke().dropdown.alignments;
      switch (this$DropdownComponent.alignment.value(DropdownComponent$AlignmentContext_getInstance()).name) {
        case 'Start':
          tmp$_0 = isVerticalPlacement ? alignments.horizontalStart : alignments.verticalStart;
          break;
        case 'End':
          tmp$_0 = isVerticalPlacement ? alignments.horizontalEnd : alignments.verticalEnd;
          break;
        default:tmp$_0 = Kotlin.noWhenBranchMatched();
          break;
      }
      $receiver.invoke_qkhqzy$(tmp$_0);
      return Unit;
    };
  }
  function Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda.prototype.constructor = Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda;
  Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DropdownComponent$renderDropdown$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$DropdownComponent$renderDropdown$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function DropdownComponent$renderDropdown$lambda$lambda_0(this$DropdownComponent) {
    return function ($receiver) {
      $receiver.attr_puj7f4$('tabindex', '-1');
      $receiver.handledBy_ytah3h$(debounce($receiver.blurs.map_wcw67s$(DropdownComponent$renderDropdown$lambda$lambda$lambda), L100), this$DropdownComponent.visible_qvw1h8$_0.toggle);
      this$DropdownComponent.content.value($receiver);
      return Unit;
    };
  }
  DropdownComponent.prototype.renderDropdown_m3rryq$_0 = function (context, styling, baseClass, prefix) {
    return section_0(context, DropdownComponent$renderDropdown$lambda$lambda(this), styling, baseClass, void 0, prefix, void 0, DropdownComponent$renderDropdown$lambda$lambda_0(this)).domNode;
  };
  function DropdownComponent$toggle$lambda$lambda$lambda($receiver) {
    return $receiver.menu;
  }
  function DropdownComponent$toggle$lambda$lambda$lambda_0($receiver) {
    return $receiver.ghost;
  }
  function DropdownComponent$toggle$lambda$lambda($receiver) {
    $receiver.icon.invoke_11rb$(DropdownComponent$toggle$lambda$lambda$lambda);
    $receiver.variant.invoke_11rb$(DropdownComponent$toggle$lambda$lambda$lambda_0);
    return Unit;
  }
  function DropdownComponent$toggle$lambda($receiver) {
    pushButton($receiver, void 0, void 0, void 0, void 0, DropdownComponent$toggle$lambda$lambda);
    return Unit;
  }
  function DropdownComponent$placement$lambda($receiver) {
    return $receiver.bottom;
  }
  function DropdownComponent$alignment$lambda($receiver) {
    return $receiver.start;
  }
  function DropdownComponent$content$lambda($receiver) {
    return Unit;
  }
  function DropdownComponent$visible$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.toggle = this.handle_7ib3lp$(void 0, DropdownComponent$visible$ObjectLiteral$toggle$lambda);
  }
  function Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda.prototype.constructor = Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda;
  Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function DropdownComponent$visible$ObjectLiteral$toggle$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$DropdownComponent$visible$ObjectLiteral$toggle$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  DropdownComponent$visible$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  DropdownComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DropdownComponent',
    interfaces: [Component]
  };
  function dropdown$lambda($receiver) {
    return Unit;
  }
  function dropdown($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = dropdown$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'dropdown';
    var $receiver_0 = new DropdownComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function file$lambda($receiver) {
    return Unit;
  }
  function file$lambda_0($receiver) {
    return Unit;
  }
  function file($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = file$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'file';
    if (build === void 0)
      build = file$lambda_0;
    var $receiver_0 = new SingleFileSelectionComponent();
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function files$lambda($receiver) {
    return Unit;
  }
  function files$lambda_0($receiver) {
    return Unit;
  }
  function files($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = files$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'file';
    if (build === void 0)
      build = files$lambda_0;
    var $receiver_0 = new MultiFileSelectionComponent();
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_3(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_3($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_3.prototype.constructor = Coroutine$collect_42ocv1$_3;
  Coroutine$collect_42ocv1$_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_3.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_3(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_3.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_3.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_3;
  Coroutine$unsafeTransform$lambda$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_3(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_3.prototype.constructor = Coroutine$unsafeTransform$lambda_3;
  Coroutine$unsafeTransform$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_3(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_3(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_3(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$mapNotNull$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$tmp$ = void 0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$mapNotNull$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$mapNotNull$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$mapNotNull$lambda.prototype.constructor = Coroutine$mapNotNull$lambda;
  Coroutine$mapNotNull$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            if (this.local$tmp$ == null) {
              return;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            var transformed = this.local$tmp$;
            this.state_0 = 4;
            this.result_0 = this.local$$receiver.emit_11rb$(transformed, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function mapNotNull$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$mapNotNull$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$flatMapLatest$lambda(closure$transform_0, $receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$it = it_0;
  }
  Coroutine$flatMapLatest$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$flatMapLatest$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$flatMapLatest$lambda.prototype.constructor = Coroutine$flatMapLatest$lambda;
  Coroutine$flatMapLatest$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$it, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = emitAll(this.local$$receiver, this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function flatMapLatest$lambda(closure$transform_0) {
    return function ($receiver_0, it_0, continuation_0, suspended) {
      var instance = new Coroutine$flatMapLatest$lambda(closure$transform_0, $receiver_0, it_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_4(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_4($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_4.prototype.constructor = Coroutine$collect_42ocv1$_4;
  Coroutine$collect_42ocv1$_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_4.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_4(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_4.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function combine$lambda$lambda(closure$flowArray) {
    return function () {
      return Kotlin.newArray(closure$flowArray.length, null);
    };
  }
  function Coroutine$combine$lambda$lambda(closure$transform_0, $receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$it = it_0;
  }
  Coroutine$combine$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$combine$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$combine$lambda$lambda.prototype.constructor = Coroutine$combine$lambda$lambda;
  Coroutine$combine$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$it, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function combine$lambda$lambda_0(closure$transform_0) {
    return function ($receiver_0, it_0, continuation_0, suspended) {
      var instance = new Coroutine$combine$lambda$lambda(closure$transform_0, $receiver_0, it_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$combine$lambda(closure$flowArray_0, closure$transform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$flowArray = closure$flowArray_0;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$combine$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$combine$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$combine$lambda.prototype.constructor = Coroutine$combine$lambda;
  Coroutine$combine$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = combineInternal(this.local$$receiver, this.local$closure$flowArray, combine$lambda$lambda(this.local$closure$flowArray), combine$lambda$lambda_0(this.local$closure$transform), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function combine$lambda(closure$flowArray_0, closure$transform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$combine$lambda(closure$flowArray_0, closure$transform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FileSelectionBaseComponent() {
    FileSelectionBaseComponent$Companion_getInstance();
    this.accept = null;
    this.base64 = FileSelectionBaseComponent$base64$lambda;
    this.plainText = FileSelectionBaseComponent$plainText$lambda;
    this.fileReadingStrategy = new ComponentProperty(FileSelectionBaseComponent$fileReadingStrategy$lambda);
    this.context = FileSelectionBaseComponent$context$lambda;
  }
  function FileSelectionBaseComponent$Companion() {
    FileSelectionBaseComponent$Companion_instance = this;
    this.eventName = 'loadend';
    this.inputStyle = staticStyle_0('file-input', 'display: none;');
  }
  FileSelectionBaseComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FileSelectionBaseComponent$Companion_instance = null;
  function FileSelectionBaseComponent$Companion_getInstance() {
    if (FileSelectionBaseComponent$Companion_instance === null) {
      new FileSelectionBaseComponent$Companion();
    }return FileSelectionBaseComponent$Companion_instance;
  }
  function FileSelectionBaseComponent$accept$lambda(closure$value) {
    return function ($receiver) {
      $receiver.attr_puj7f4$('accept', closure$value);
      return Unit;
    };
  }
  FileSelectionBaseComponent.prototype.accept_61zpoe$ = function (value) {
    this.accept = FileSelectionBaseComponent$accept$lambda(value);
  };
  function FileSelectionBaseComponent$accept$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.attr_i7f8q9$('accept', closure$value);
      return Unit;
    };
  }
  FileSelectionBaseComponent.prototype.accept_p81yox$ = function (value) {
    this.accept = FileSelectionBaseComponent$accept$lambda_0(value);
  };
  function FileSelectionBaseComponent$encoding$lambda(closure$value) {
    return function ($receiver) {
      return $receiver.plainText(closure$value);
    };
  }
  FileSelectionBaseComponent.prototype.encoding_61zpoe$ = function (value) {
    this.fileReadingStrategy.invoke_11rb$(FileSelectionBaseComponent$encoding$lambda(value));
  };
  function FileSelectionBaseComponent$button$lambda$lambda$lambda$lambda(closure$input) {
    return function (it) {
      closure$input.click();
      return Unit;
    };
  }
  function FileSelectionBaseComponent$button$lambda$lambda$lambda(closure$input) {
    return function ($receiver) {
      $receiver.domNode.onclick = FileSelectionBaseComponent$button$lambda$lambda$lambda$lambda(closure$input);
      return Unit;
    };
  }
  function FileSelectionBaseComponent$button$lambda$lambda(closure$build, closure$input) {
    return function ($receiver) {
      closure$build($receiver);
      $receiver.element.invoke_11rb$(FileSelectionBaseComponent$button$lambda$lambda$lambda(closure$input));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$button$lambda(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build) {
    return function ($receiver, input) {
      pushButton($receiver, closure$styling, closure$baseClass, closure$id, closure$prefix, FileSelectionBaseComponent$button$lambda$lambda(closure$build, input));
      return Unit;
    };
  }
  FileSelectionBaseComponent.prototype.button_lhsdhu$$default = function (styling, baseClass, id, prefix, build) {
    this.context = FileSelectionBaseComponent$button$lambda(styling, baseClass, id, prefix, build);
  };
  function FileSelectionBaseComponent$button$lambda_0($receiver) {
    return Unit;
  }
  function FileSelectionBaseComponent$button$lambda_1($receiver) {
    return Unit;
  }
  FileSelectionBaseComponent.prototype.button_lhsdhu$ = function (styling, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = FileSelectionBaseComponent$button$lambda_0;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'file-button';
    if (build === void 0)
      build = FileSelectionBaseComponent$button$lambda_1;
    callback$default ? callback$default(styling, baseClass, id, prefix, build) : this.button_lhsdhu$$default(styling, baseClass, id, prefix, build);
  };
  function FileSelectionBaseComponent$base64$lambda$lambda$lambda(closure$reader, closure$file, this$) {
    return function (f) {
      var content = closure$reader.result.toString();
      var index = indexOf(content, 'base64,');
      if (index > -1) {
        var $receiver = content;
        var startIndex = index + 7 | 0;
        content = $receiver.substring(startIndex);
      }this$.trySend_11rb$(new File(closure$file.name, closure$file.type, numberToLong(closure$file.size), content));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$base64$lambda$lambda$lambda_0(closure$reader, closure$listener) {
    return function () {
      closure$reader.removeEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, closure$listener);
      return Unit;
    };
  }
  function Coroutine$FileSelectionBaseComponent$base64$lambda$lambda(closure$file_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$file = closure$file_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.prototype.constructor = Coroutine$FileSelectionBaseComponent$base64$lambda$lambda;
  Coroutine$FileSelectionBaseComponent$base64$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var reader = new FileReader();
            var listener = FileSelectionBaseComponent$base64$lambda$lambda$lambda(reader, this.local$closure$file, this.local$$receiver);
            reader.addEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, listener);
            reader.readAsDataURL(this.local$closure$file);
            this.state_0 = 2;
            this.result_0 = awaitClose(this.local$$receiver, FileSelectionBaseComponent$base64$lambda$lambda$lambda_0(reader, listener), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FileSelectionBaseComponent$base64$lambda$lambda(closure$file_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$FileSelectionBaseComponent$base64$lambda$lambda(closure$file_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FileSelectionBaseComponent$base64$lambda(file) {
    return callbackFlow(FileSelectionBaseComponent$base64$lambda$lambda(file));
  }
  function FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda(closure$file, closure$reader, this$) {
    return function (f) {
      this$.trySend_11rb$(new File(closure$file.name, closure$file.type, numberToLong(closure$file.size), closure$reader.result.toString()));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda_0(closure$reader, closure$listener) {
    return function () {
      closure$reader.removeEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, closure$listener);
      return Unit;
    };
  }
  function Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda(closure$file_0, closure$encoding_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$file = closure$file_0;
    this.local$closure$encoding = closure$encoding_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.prototype.constructor = Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda;
  Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var reader = new FileReader();
            var listener = FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda(this.local$closure$file, reader, this.local$$receiver);
            reader.addEventListener(FileSelectionBaseComponent$Companion_getInstance().eventName, listener);
            reader.readAsText(this.local$closure$file, this.local$closure$encoding);
            this.state_0 = 2;
            this.result_0 = awaitClose(this.local$$receiver, FileSelectionBaseComponent$plainText$lambda$lambda$lambda$lambda_0(reader, listener), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FileSelectionBaseComponent$plainText$lambda$lambda$lambda(closure$file_0, closure$encoding_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$FileSelectionBaseComponent$plainText$lambda$lambda$lambda(closure$file_0, closure$encoding_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function FileSelectionBaseComponent$plainText$lambda$lambda(closure$encoding) {
    return function (file) {
      return callbackFlow(FileSelectionBaseComponent$plainText$lambda$lambda$lambda(file, closure$encoding));
    };
  }
  function FileSelectionBaseComponent$plainText$lambda(encoding) {
    return FileSelectionBaseComponent$plainText$lambda$lambda(encoding);
  }
  function FileSelectionBaseComponent$fileReadingStrategy$lambda($receiver) {
    return $receiver.base64;
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda($receiver) {
    return $receiver.cloudUpload;
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda$lambda(closure$input) {
    return function (it) {
      closure$input.click();
      return Unit;
    };
  }
  function FileSelectionBaseComponent$context$lambda$lambda$lambda_0(closure$input) {
    return function ($receiver) {
      $receiver.domNode.onclick = FileSelectionBaseComponent$context$lambda$lambda$lambda$lambda(closure$input);
      return Unit;
    };
  }
  function FileSelectionBaseComponent$context$lambda$lambda(closure$input) {
    return function ($receiver) {
      $receiver.icon.invoke_11rb$(FileSelectionBaseComponent$context$lambda$lambda$lambda);
      $receiver.element.invoke_11rb$(FileSelectionBaseComponent$context$lambda$lambda$lambda_0(closure$input));
      return Unit;
    };
  }
  function FileSelectionBaseComponent$context$lambda($receiver, input) {
    pushButton($receiver, void 0, void 0, void 0, 'file-button', FileSelectionBaseComponent$context$lambda$lambda(input));
    return Unit;
  }
  FileSelectionBaseComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSelectionBaseComponent',
    interfaces: []
  };
  function SingleFileSelectionComponent() {
    FileSelectionBaseComponent.call(this);
  }
  function SingleFileSelectionComponent$render$lambda$lambda($receiver) {
    return Unit;
  }
  function Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
  }
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return (tmp$ = this.local$this$.domNode.files) != null ? tmp$.item(0) : null;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, this$SingleFileSelectionComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$this$SingleFileSelectionComponent = this$SingleFileSelectionComponent_0;
    this.local$it = it_0;
  }
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0;
  Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$this$.domNode.value = '';
            return this.local$this$SingleFileSelectionComponent.fileReadingStrategy.value(this.local$this$SingleFileSelectionComponent)(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, this$SingleFileSelectionComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, this$SingleFileSelectionComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SingleFileSelectionComponent$render$lambda$lambda$lambda(this$SingleFileSelectionComponent, closure$file) {
    return function ($receiver) {
      var tmp$;
      $receiver.type_61zpoe$('file');
      (tmp$ = this$SingleFileSelectionComponent.accept) != null ? tmp$($receiver) : null;
      var tmp$_0 = closure$file;
      var $receiver_0 = $receiver.changes.events;
      tmp$_0.v = transformLatest(new unsafeFlow$ObjectLiteral_3(unsafeTransform$lambda_3(mapNotNull$lambda(SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda($receiver)), $receiver_0)), flatMapLatest$lambda(SingleFileSelectionComponent$render$lambda$lambda$lambda$lambda_0($receiver, this$SingleFileSelectionComponent)));
      return Unit;
    };
  }
  function SingleFileSelectionComponent$render$lambda$lambda_0(this$SingleFileSelectionComponent, closure$file) {
    return function ($receiver) {
      var inputElement = $receiver.input_g7msy9$(FileSelectionBaseComponent$Companion_getInstance().inputStyle.name, void 0, void 0, SingleFileSelectionComponent$render$lambda$lambda$lambda(this$SingleFileSelectionComponent, closure$file)).domNode;
      this$SingleFileSelectionComponent.context($receiver, inputElement);
      return Unit;
    };
  }
  SingleFileSelectionComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var file = {v: null};
    div_0(context, SingleFileSelectionComponent$render$lambda$lambda, styling, baseClass, id, prefix, void 0, SingleFileSelectionComponent$render$lambda$lambda_0(this, file));
    return ensureNotNull(file.v);
  };
  SingleFileSelectionComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleFileSelectionComponent',
    interfaces: [Component, FileSelectionBaseComponent]
  };
  function MultiFileSelectionComponent() {
    FileSelectionBaseComponent.call(this);
  }
  function MultiFileSelectionComponent$render$lambda$lambda($receiver) {
    return Unit;
  }
  function Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, this$MultiFileSelectionComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$this$MultiFileSelectionComponent = this$MultiFileSelectionComponent_0;
  }
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var tmp$_0;
            if ((tmp$ = this.local$this$.domNode.files) != null) {
              var this$MultiFileSelectionComponent = this.local$this$MultiFileSelectionComponent;
              var $receiver = ArrayList_init_0();
              var tmp$_1;
              tmp$_1 = tmp$.length;
              for (var i = 0; i <= tmp$_1; i++) {
                var file = tmp$.item(i);
                if (file != null)
                  $receiver.add_11rb$(this$MultiFileSelectionComponent.fileReadingStrategy.value(this$MultiFileSelectionComponent)(file));
              }
              tmp$_0 = $receiver.build();
            } else
              tmp$_0 = null;
            return tmp$_0;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, this$MultiFileSelectionComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda(this$_0, this$MultiFileSelectionComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda;
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return toList_1(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, files_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$files = files_0;
  }
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0;
  Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$this$.domNode.value = '';
            var flowArray = copyToArray(toList(this.local$files));
            return new unsafeFlow$ObjectLiteral_4(combine$lambda(flowArray, MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda$lambda));
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0) {
    return function (files_0, continuation_0, suspended) {
      var instance = new Coroutine$MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0(this$_0, files_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function MultiFileSelectionComponent$render$lambda$lambda$lambda(this$MultiFileSelectionComponent, closure$files) {
    return function ($receiver) {
      var tmp$;
      $receiver.type_61zpoe$('file');
      $receiver.multiple_8kj6y5$(true);
      (tmp$ = this$MultiFileSelectionComponent.accept) != null ? tmp$($receiver) : null;
      var tmp$_0 = closure$files;
      var $receiver_0 = $receiver.changes.events;
      tmp$_0.v = transformLatest(new unsafeFlow$ObjectLiteral_3(unsafeTransform$lambda_3(mapNotNull$lambda(MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda($receiver, this$MultiFileSelectionComponent)), $receiver_0)), flatMapLatest$lambda(MultiFileSelectionComponent$render$lambda$lambda$lambda$lambda_0($receiver)));
      return Unit;
    };
  }
  function MultiFileSelectionComponent$render$lambda$lambda_0(this$MultiFileSelectionComponent, closure$files) {
    return function ($receiver) {
      var inputElement = $receiver.input_g7msy9$(FileSelectionBaseComponent$Companion_getInstance().inputStyle.name, void 0, void 0, MultiFileSelectionComponent$render$lambda$lambda$lambda(this$MultiFileSelectionComponent, closure$files)).domNode;
      this$MultiFileSelectionComponent.context($receiver, inputElement);
      return Unit;
    };
  }
  MultiFileSelectionComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var files = {v: null};
    div_0(context, MultiFileSelectionComponent$render$lambda$lambda, styling, baseClass, id, prefix, void 0, MultiFileSelectionComponent$render$lambda$lambda_0(this, files));
    return ensureNotNull(files.v);
  };
  MultiFileSelectionComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultiFileSelectionComponent',
    interfaces: [Component, FileSelectionBaseComponent]
  };
  function formGroup$lambda($receiver) {
    return Unit;
  }
  function formGroup$lambda_0($receiver) {
    return Unit;
  }
  function formGroup($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = formGroup$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'formGroup';
    if (build === void 0)
      build = formGroup$lambda_0;
    var $receiver_0 = new FormGroupComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function formControl$lambda($receiver) {
    return Unit;
  }
  function formControl$lambda_0($receiver) {
    return Unit;
  }
  function formControl($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = formControl$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'formControl';
    if (build === void 0)
      build = formControl$lambda_0;
    var $receiver_0 = new FormControlComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  var formGroupElementContainerMarker;
  var formGroupElementLabelMarker;
  var formGroupElementLegendMarker;
  function unsafeFlow$ObjectLiteral_5(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_5($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_5.prototype.constructor = Coroutine$collect_42ocv1$_5;
  Coroutine$collect_42ocv1$_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_5.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_5(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_5.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_4(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_4.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_4;
  Coroutine$unsafeTransform$lambda$lambda_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_4(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_4(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_4(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_4.prototype.constructor = Coroutine$unsafeTransform$lambda_4;
  Coroutine$unsafeTransform$lambda_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_4(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_4(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_4(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_3(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_3.prototype.constructor = Coroutine$map$lambda_3;
  Coroutine$map$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_3(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_3(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ControlRenderer() {
  }
  function ControlRenderer$render$lambda($receiver) {
    return Unit;
  }
  ControlRenderer.prototype.render_6w4774$ = function (styling, baseClass, id, prefix, context, control, callback$default) {
    if (styling === void 0)
      styling = ControlRenderer$render$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'formControl';
    callback$default ? callback$default(styling, baseClass, id, prefix, context, control) : this.render_6w4774$$default(styling, baseClass, id, prefix, context, control);
  };
  ControlRenderer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ControlRenderer',
    interfaces: []
  };
  function FormControlComponent() {
    FormControlComponent$Companion_getInstance();
    this.controlRegistration = new FormControlComponent$ControlRegistration();
    this.size = new ComponentProperty(FormControlComponent$size$lambda);
    this.sizeBuilder = FormControlComponent$sizeBuilder$lambda(this);
    this.label = new DynamicComponentProperty(emptyFlow());
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().formControl.label);
    this.helperText = new ComponentProperty(null);
    this.helperTextStyle = new ComponentProperty(Theme.Companion.invoke().formControl.helperText);
    this.validationMessagesBuilder = null;
    this.validationMessage = new ComponentProperty(FormControlComponent$validationMessage$lambda);
    this.validationMessages = new ComponentProperty(FormControlComponent$validationMessages$lambda);
    this.validationMessageRendering = new ComponentProperty(FormControlComponent$validationMessageRendering$lambda(this));
  }
  function FormControlComponent$Companion() {
    FormControlComponent$Companion_instance = this;
  }
  function FormControlComponent$Companion$ControlNames() {
    FormControlComponent$Companion$ControlNames_instance = this;
    this.inputField = 'inputField';
    this.textArea = 'textArea';
    this.switch = 'switch';
    this.selectField = 'selectField';
    this.radioGroup = 'radioGroup';
    this.checkbox = 'checkbox';
    this.checkboxGroup = 'checkboxGroup';
    this.slider = 'slider';
    this.typeAhead = 'typeAhead';
  }
  FormControlComponent$Companion$ControlNames.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ControlNames',
    interfaces: []
  };
  var FormControlComponent$Companion$ControlNames_instance = null;
  function FormControlComponent$Companion$ControlNames_getInstance() {
    if (FormControlComponent$Companion$ControlNames_instance === null) {
      new FormControlComponent$Companion$ControlNames();
    }return FormControlComponent$Companion$ControlNames_instance;
  }
  FormControlComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FormControlComponent$Companion_instance = null;
  function FormControlComponent$Companion_getInstance() {
    if (FormControlComponent$Companion_instance === null) {
      new FormControlComponent$Companion();
    }return FormControlComponent$Companion_instance;
  }
  function FormControlComponent$Control(id, name, rendering) {
    this.id = id;
    this.name = name;
    this.rendering = rendering;
  }
  FormControlComponent$Control.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Control',
    interfaces: []
  };
  FormControlComponent$Control.prototype.component1 = function () {
    return this.id;
  };
  FormControlComponent$Control.prototype.component2 = function () {
    return this.name;
  };
  FormControlComponent$Control.prototype.component3 = function () {
    return this.rendering;
  };
  FormControlComponent$Control.prototype.copy_qjtbll$ = function (id, name, rendering) {
    return new FormControlComponent$Control(id === void 0 ? this.id : id, name === void 0 ? this.name : name, rendering === void 0 ? this.rendering : rendering);
  };
  FormControlComponent$Control.prototype.toString = function () {
    return 'Control(id=' + Kotlin.toString(this.id) + (', name=' + Kotlin.toString(this.name)) + (', rendering=' + Kotlin.toString(this.rendering)) + ')';
  };
  FormControlComponent$Control.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.rendering) | 0;
    return result;
  };
  FormControlComponent$Control.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.rendering, other.rendering)))));
  };
  function FormControlComponent$ControlRegistration() {
    this.overflows_0 = ArrayList_init_0();
    this.assignee = null;
  }
  FormControlComponent$ControlRegistration.prototype.set_qjtbll$ = function (controlId, controlName, component) {
    var control = new FormControlComponent$Control(controlId, controlName, component);
    if (this.assignee == null) {
      this.assignee = control;
      return true;
    } else {
      this.overflows_0.add_11rb$(control);
    }
    return false;
  };
  function FormControlComponent$ControlRegistration$assert$lambda(it) {
    return it.name + ' (' + toString(it.id) + ')';
  }
  FormControlComponent$ControlRegistration.prototype.assert = function () {
    var tmp$, tmp$_0, tmp$_1;
    if (!this.overflows_0.isEmpty()) {
      tmp$_1 = UnsupportedOperationException_init('Only one control within a formControl is allowed! Accepted control:' + (toString((tmp$ = this.assignee) != null ? tmp$.name : null) + ' (' + toString((tmp$_0 = this.assignee) != null ? tmp$_0.id : null) + ')') + ' The following controls are not applied and overflow this form: ' + joinToString(this.overflows_0, ', ', void 0, void 0, void 0, void 0, FormControlComponent$ControlRegistration$assert$lambda) + ' Please remove those!');
      console.error(tmp$_1);
    }};
  FormControlComponent$ControlRegistration.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ControlRegistration',
    interfaces: []
  };
  FormControlComponent.prototype.registerControl_ljqz0$$default = function (controlId, controlName, component, onSuccess) {
    if (this.controlRegistration.set_qjtbll$(controlId, controlName, component)) {
      onSuccess(this);
    }};
  function FormControlComponent$registerControl$lambda($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.registerControl_ljqz0$ = function (controlId, controlName, component, onSuccess, callback$default) {
    if (onSuccess === void 0)
      onSuccess = FormControlComponent$registerControl$lambda;
    callback$default ? callback$default(controlId, controlName, component, onSuccess) : this.registerControl_ljqz0$$default(controlId, controlName, component, onSuccess);
  };
  function FormControlComponent$FormSizeContext() {
    FormControlComponent$FormSizeContext_instance = this;
    this.small = FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_getInstance();
    this.normal = FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_getInstance();
    this.large = FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_getInstance();
  }
  function FormControlComponent$FormSizeContext$FormSizeSpecifier(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields = function () {
    };
    FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_instance = new FormControlComponent$FormSizeContext$FormSizeSpecifier('SMALL', 0);
    FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_instance = new FormControlComponent$FormSizeContext$FormSizeSpecifier('NORMAL', 1);
    FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_instance = new FormControlComponent$FormSizeContext$FormSizeSpecifier('LARGE', 2);
  }
  var FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_instance;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_getInstance() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields();
    return FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_instance;
  }
  var FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_instance;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_getInstance() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields();
    return FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_instance;
  }
  var FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_instance;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_getInstance() {
    FormControlComponent$FormSizeContext$FormSizeSpecifier_initFields();
    return FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_instance;
  }
  FormControlComponent$FormSizeContext$FormSizeSpecifier.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormSizeSpecifier',
    interfaces: [Enum]
  };
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$values() {
    return [FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_getInstance(), FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_getInstance(), FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_getInstance()];
  }
  FormControlComponent$FormSizeContext$FormSizeSpecifier.values = FormControlComponent$FormSizeContext$FormSizeSpecifier$values;
  function FormControlComponent$FormSizeContext$FormSizeSpecifier$valueOf(name) {
    switch (name) {
      case 'SMALL':
        return FormControlComponent$FormSizeContext$FormSizeSpecifier$SMALL_getInstance();
      case 'NORMAL':
        return FormControlComponent$FormSizeContext$FormSizeSpecifier$NORMAL_getInstance();
      case 'LARGE':
        return FormControlComponent$FormSizeContext$FormSizeSpecifier$LARGE_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.forms.control.FormControlComponent.FormSizeContext.FormSizeSpecifier.' + name);
    }
  }
  FormControlComponent$FormSizeContext$FormSizeSpecifier.valueOf_61zpoe$ = FormControlComponent$FormSizeContext$FormSizeSpecifier$valueOf;
  FormControlComponent$FormSizeContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'FormSizeContext',
    interfaces: []
  };
  var FormControlComponent$FormSizeContext_instance = null;
  function FormControlComponent$FormSizeContext_getInstance() {
    if (FormControlComponent$FormSizeContext_instance === null) {
      new FormControlComponent$FormSizeContext();
    }return FormControlComponent$FormSizeContext_instance;
  }
  Object.defineProperty(FormControlComponent.prototype, 'ownSize', {
    configurable: true,
    get: function () {
      switch (this.size.value(FormControlComponent$FormSizeContext_getInstance()).name) {
        case 'SMALL':
          return Theme.Companion.invoke().formControl.sizes.small;
        case 'NORMAL':
          return Theme.Companion.invoke().formControl.sizes.normal;
        case 'LARGE':
          return Theme.Companion.invoke().formControl.sizes.large;
        default:return Kotlin.noWhenBranchMatched();
      }
    }
  });
  function FormControlComponent$ValidationResult(messages) {
    FormControlComponent$ValidationResult$Companion_getInstance();
    this.messages = messages;
  }
  function FormControlComponent$ValidationResult$Companion() {
    FormControlComponent$ValidationResult$Companion_instance = this;
  }
  function Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.prototype.constructor = Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda;
  Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it == null ? emptyList() : listOf(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function FormControlComponent$ValidationResult$Companion$builderOf$lambda(closure$formControl, closure$store) {
    return function () {
      var tmp$, tmp$_0, tmp$_1;
      return new FormControlComponent$ValidationResult((tmp$_1 = (tmp$_0 = (tmp$ = closure$formControl.validationMessage.value()) != null ? new unsafeFlow$ObjectLiteral_5(unsafeTransform$lambda_4(map$lambda_3(FormControlComponent$ValidationResult$Companion$builderOf$lambda$lambda), tmp$)) : null) != null ? tmp$_0 : closure$formControl.validationMessages.value()) != null ? tmp$_1 : closure$store != null ? validationMessages(closure$store) : null);
    };
  }
  FormControlComponent$ValidationResult$Companion.prototype.builderOf_fv7hjh$ = function (formControl, store) {
    if (store === void 0)
      store = null;
    return FormControlComponent$ValidationResult$Companion$builderOf$lambda(formControl, store);
  };
  FormControlComponent$ValidationResult$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FormControlComponent$ValidationResult$Companion_instance = null;
  function FormControlComponent$ValidationResult$Companion_getInstance() {
    if (FormControlComponent$ValidationResult$Companion_instance === null) {
      new FormControlComponent$ValidationResult$Companion();
    }return FormControlComponent$ValidationResult$Companion_instance;
  }
  function Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda(messages_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$messages = messages_0;
  }
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.prototype.constructor = Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda;
  Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var destination = ArrayList_init(collectionSizeOrDefault(this.local$messages, 10));
            var tmp$;
            tmp$ = this.local$messages.iterator();
            while (tmp$.hasNext()) {
              var item = tmp$.next();
              destination.add_11rb$(item.severity);
            }

            return maxOrNull(destination);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda(messages_0, continuation_0, suspended) {
    var instance = new Coroutine$FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda(messages_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  Object.defineProperty(FormControlComponent$ValidationResult.prototype, 'hasSeverity', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this.messages) != null ? new unsafeFlow$ObjectLiteral_5(unsafeTransform$lambda_4(map$lambda_3(FormControlComponent$ValidationResult$get_FormControlComponent$ValidationResult$hasSeverity$lambda), tmp$)) : null) != null ? tmp$_0 : flowOf(null);
    }
  });
  FormControlComponent$ValidationResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ValidationResult',
    interfaces: []
  };
  FormControlComponent.prototype.initRenderStrategies_sp0qdh$_0 = function () {
    var $receiver = LinkedHashMap_init_0();
    var singleRenderer = new SingleControlRenderer(this);
    var groupRenderer = new ControlGroupRenderer(this);
    var tmp$;
    tmp$ = sequenceOf([FormControlComponent$Companion$ControlNames_getInstance().inputField, FormControlComponent$Companion$ControlNames_getInstance().switch, FormControlComponent$Companion$ControlNames_getInstance().textArea, FormControlComponent$Companion$ControlNames_getInstance().selectField, FormControlComponent$Companion$ControlNames_getInstance().checkbox, FormControlComponent$Companion$ControlNames_getInstance().slider, FormControlComponent$Companion$ControlNames_getInstance().typeAhead]).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      $receiver.put_xwzc9p$(element, singleRenderer);
    }
    $receiver.put_xwzc9p$(FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup, groupRenderer);
    $receiver.put_xwzc9p$(FormControlComponent$Companion$ControlNames_getInstance().radioGroup, groupRenderer);
    this.finalizeRenderStrategies_gttq4y$($receiver, singleRenderer, groupRenderer);
    return $receiver.build();
  };
  FormControlComponent.prototype.finalizeRenderStrategies_gttq4y$ = function (strategies, single, group) {
  };
  function FormControlComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  FormControlComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var tmp$, tmp$_0;
    var renderStrategies = this.initRenderStrategies_sp0qdh$_0();
    if ((tmp$_0 = (tmp$ = this.controlRegistration.assignee) != null ? tmp$.rendering : null) != null) {
      var tmp$_1, tmp$_2, tmp$_3;
      tmp$_2 = (tmp$_1 = this.controlRegistration.assignee) != null ? tmp$_1.name : null;
      var tmp$_4;
      (tmp$_3 = (Kotlin.isType(tmp$_4 = renderStrategies, Map) ? tmp$_4 : throwCCE()).get_11rb$(tmp$_2)) != null && (tmp$_3.render_6w4774$(FormControlComponent$render$lambda$lambda(styling), baseClass, id, prefix, context, tmp$_0), Unit);
    }this.controlRegistration.assert();
    return Unit;
  };
  function FormControlComponent$renderHelperText$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$FormControlComponent.helperTextStyle.value);
      return Unit;
    };
  }
  function FormControlComponent$renderHelperText$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$it);
      return Unit;
    };
  }
  FormControlComponent.prototype.renderHelperText_1s6vjs$ = function (renderContext) {
    var tmp$;
    if ((tmp$ = this.helperText.value) != null) {
      p(renderContext, FormControlComponent$renderHelperText$lambda$lambda$lambda(this), void 0, void 0, void 0, void 0, FormControlComponent$renderHelperText$lambda$lambda$lambda_0(tmp$));
    }};
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda($receiver) {
    return '100%';
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda($receiver) {
    $receiver.width_wpghq5$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda);
    return Unit;
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda_0($receiver) {
    return $receiver.none;
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '100%';
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.width_wpghq5$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda_0(this$FormControlComponent, closure$message) {
    return function ($receiver) {
      this$FormControlComponent.validationMessageRendering.value($receiver, closure$message);
      return Unit;
    };
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver, message) {
      return div($receiver, FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda, void 0, void 0, void 0, void 0, FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda$lambda_0(this$FormControlComponent, message));
    };
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda$lambda_1(this$FormControlComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      (tmp$_1 = (tmp$_0 = (tmp$ = this$FormControlComponent.validationMessagesBuilder) != null ? tmp$() : null) != null ? tmp$_0.messages : null) != null ? ($receiver.renderEach_ywitts$(tmp$_1, void 0, void 0, FormControlComponent$renderValidationMessages$lambda$lambda$lambda$lambda(this$FormControlComponent)), Unit) : null;
      return Unit;
    };
  }
  function FormControlComponent$renderValidationMessages$lambda$lambda_0(this$FormControlComponent) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda_0);
      $receiver.items.invoke_11rb$(FormControlComponent$renderValidationMessages$lambda$lambda$lambda_1(this$FormControlComponent));
      return Unit;
    };
  }
  FormControlComponent.prototype.renderValidationMessages_1s6vjs$ = function (renderContext) {
    stackUp(renderContext, FormControlComponent$renderValidationMessages$lambda$lambda, void 0, void 0, void 0, FormControlComponent$renderValidationMessages$lambda$lambda_0(this));
  };
  function FormControlComponent$inputField$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$inputField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$inputField$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$inputField$lambda(closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return inputField($receiver, closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$inputField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$inputField$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.inputField_3zr6qg$$default = function (styling, value, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().inputField, FormControlComponent$inputField$lambda(styling, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$inputField$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$inputField$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$inputField$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.inputField_3zr6qg$ = function (styling, value, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$inputField$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().inputField + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().inputField;
    if (build === void 0)
      build = FormControlComponent$inputField$lambda_2;
    callback$default ? callback$default(styling, value, baseClass, id, prefix, build) : this.inputField_3zr6qg$$default(styling, value, baseClass, id, prefix, build);
  };
  function FormControlComponent$typeAhead$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$typeAhead$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$typeAhead$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$typeAhead$lambda(closure$styling, closure$value, closure$items, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return typeAhead($receiver, closure$styling, closure$value, closure$items, closure$baseClass, closure$id, closure$prefix, FormControlComponent$typeAhead$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$typeAhead$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.typeAhead_vd8rkn$$default = function (styling, value, items, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().typeAhead, FormControlComponent$typeAhead$lambda(styling, value, items, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$typeAhead$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$typeAhead$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$typeAhead$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.typeAhead_vd8rkn$ = function (styling, value, items, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$typeAhead$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().typeAhead + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().typeAhead;
    if (build === void 0)
      build = FormControlComponent$typeAhead$lambda_2;
    callback$default ? callback$default(styling, value, items, baseClass, id, prefix, build) : this.typeAhead_vd8rkn$$default(styling, value, items, baseClass, id, prefix, build);
  };
  function FormControlComponent$switch$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$switch$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$switch$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$switch$lambda(closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return switch_0($receiver, closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$switch$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$switch$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.switch_2hzd77$$default = function (styling, value, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().switch, FormControlComponent$switch$lambda(styling, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$switch$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$switch$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$switch$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.switch_2hzd77$ = function (styling, value, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$switch$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().switch + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().switch;
    if (build === void 0)
      build = FormControlComponent$switch$lambda_2;
    callback$default ? callback$default(styling, value, baseClass, id, prefix, build) : this.switch_2hzd77$$default(styling, value, baseClass, id, prefix, build);
  };
  function FormControlComponent$textArea$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$textArea$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$textArea$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$textArea$lambda(closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return textArea($receiver, closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$textArea$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$textArea$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.textArea_bidw1k$$default = function (styling, value, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().textArea, FormControlComponent$textArea$lambda(styling, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$textArea$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$textArea$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$textArea$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.textArea_bidw1k$ = function (styling, value, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$textArea$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().textArea + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().textArea;
    if (build === void 0)
      build = FormControlComponent$textArea$lambda_2;
    callback$default ? callback$default(styling, value, baseClass, id, prefix, build) : this.textArea_bidw1k$$default(styling, value, baseClass, id, prefix, build);
  };
  function FormControlComponent$checkbox$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(closure$styling);
      return Unit;
    };
  }
  function FormControlComponent$checkbox$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$checkbox$lambda$lambda_0(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$checkbox$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$checkbox$lambda(closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return checkbox($receiver, FormControlComponent$checkbox$lambda$lambda(closure$styling), closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$checkbox$lambda$lambda_0(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$checkbox$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.checkbox_ghw7dt$$default = function (styling, baseClass, value, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().checkbox, FormControlComponent$checkbox$lambda(styling, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$checkbox$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$checkbox$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$checkbox$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.checkbox_ghw7dt$ = function (styling, baseClass, value, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$checkbox$lambda_1;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (value === void 0)
      value = null;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().checkbox + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().checkbox;
    if (build === void 0)
      build = FormControlComponent$checkbox$lambda_2;
    callback$default ? callback$default(styling, baseClass, value, id, prefix, build) : this.checkbox_ghw7dt$$default(styling, baseClass, value, id, prefix, build);
  };
  function FormControlComponent$checkboxGroup$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$checkboxGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$checkboxGroup$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$checkboxGroup$lambda(closure$styling, closure$items, closure$values, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return checkboxGroup($receiver, closure$styling, closure$items, closure$values, closure$baseClass, closure$id, closure$prefix, FormControlComponent$checkboxGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$checkboxGroup$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.checkboxGroup_9wm8g9$$default = function (styling, items, values, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, values);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup, FormControlComponent$checkboxGroup$lambda(styling, items, values, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$checkboxGroup$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$checkboxGroup$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$checkboxGroup$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.checkboxGroup_9wm8g9$ = function (styling, items, values, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$checkboxGroup$lambda_1;
    if (values === void 0)
      values = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = values != null ? values.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().checkboxGroup;
    if (build === void 0)
      build = FormControlComponent$checkboxGroup$lambda_2;
    callback$default ? callback$default(styling, items, values, baseClass, id, prefix, build) : this.checkboxGroup_9wm8g9$$default(styling, items, values, baseClass, id, prefix, build);
  };
  function FormControlComponent$radioGroup$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$radioGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$radioGroup$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$radioGroup$lambda(closure$styling, closure$items, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return radioGroup($receiver, closure$styling, closure$items, closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$radioGroup$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$radioGroup$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.radioGroup_hvbba7$$default = function (styling, items, value, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().radioGroup, FormControlComponent$radioGroup$lambda(styling, items, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$radioGroup$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$radioGroup$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$radioGroup$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.radioGroup_hvbba7$ = function (styling, items, value, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$radioGroup$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().radioGroup + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().radioGroup;
    if (build === void 0)
      build = FormControlComponent$radioGroup$lambda_2;
    callback$default ? callback$default(styling, items, value, baseClass, id, prefix, build) : this.radioGroup_hvbba7$$default(styling, items, value, baseClass, id, prefix, build);
  };
  function FormControlComponent$selectField$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$selectField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$selectField$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$selectField$lambda(closure$styling, closure$items, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return selectField($receiver, closure$styling, closure$items, closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$selectField$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$selectField$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.selectField_ygui23$$default = function (styling, items, value, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().selectField, FormControlComponent$selectField$lambda(styling, items, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$selectField$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$selectField$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$selectField$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.selectField_ygui23$ = function (styling, items, value, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$selectField$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().selectField + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().selectField;
    if (build === void 0)
      build = FormControlComponent$selectField$lambda_2;
    callback$default ? callback$default(styling, items, value, baseClass, id, prefix, build) : this.selectField_ygui23$$default(styling, items, value, baseClass, id, prefix, build);
  };
  function FormControlComponent$slider$lambda$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      return this$FormControlComponent.sizeBuilder($receiver);
    };
  }
  function FormControlComponent$slider$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(FormControlComponent$slider$lambda$lambda$lambda(this$FormControlComponent));
      $receiver.severity.invoke_ror2s8$(closure$validationMessagesBuilder().hasSeverity);
      closure$build($receiver);
      return Unit;
    };
  }
  function FormControlComponent$slider$lambda(closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, this$FormControlComponent, closure$validationMessagesBuilder, closure$build) {
    return function ($receiver) {
      return slider($receiver, closure$styling, closure$value, closure$baseClass, closure$id, closure$prefix, FormControlComponent$slider$lambda$lambda(this$FormControlComponent, closure$validationMessagesBuilder, closure$build));
    };
  }
  function FormControlComponent$slider$lambda_0(closure$validationMessagesBuilder) {
    return function ($receiver) {
      $receiver.validationMessagesBuilder = closure$validationMessagesBuilder;
      return Unit;
    };
  }
  FormControlComponent.prototype.slider_1i75tm$$default = function (styling, value, baseClass, id, prefix, build) {
    var validationMessagesBuilder = FormControlComponent$ValidationResult$Companion_getInstance().builderOf_fv7hjh$(this, value);
    this.registerControl_ljqz0$(id, FormControlComponent$Companion$ControlNames_getInstance().slider, FormControlComponent$slider$lambda(styling, value, baseClass, id, prefix, this, validationMessagesBuilder, build), FormControlComponent$slider$lambda_0(validationMessagesBuilder));
  };
  function FormControlComponent$slider$lambda_1($receiver) {
    return Unit;
  }
  function FormControlComponent$slider$lambda_2($receiver) {
    return Unit;
  }
  FormControlComponent.prototype.slider_1i75tm$ = function (styling, value, baseClass, id, prefix, build, callback$default) {
    var tmp$;
    if (styling === void 0)
      styling = FormControlComponent$slider$lambda_1;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = (tmp$ = value != null ? value.id : null) != null ? tmp$ : FormControlComponent$Companion$ControlNames_getInstance().slider + '-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = FormControlComponent$Companion$ControlNames_getInstance().slider;
    if (build === void 0)
      build = FormControlComponent$slider$lambda_2;
    callback$default ? callback$default(styling, value, baseClass, id, prefix, build) : this.slider_1i75tm$$default(styling, value, baseClass, id, prefix, build);
  };
  function FormControlComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function FormControlComponent$sizeBuilder$lambda(this$FormControlComponent) {
    return function (sizes) {
      switch (this$FormControlComponent.size.value(FormControlComponent$FormSizeContext_getInstance()).name) {
        case 'SMALL':
          return sizes.small;
        case 'NORMAL':
          return sizes.normal;
        case 'LARGE':
          return sizes.large;
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function FormControlComponent$validationMessage$lambda() {
    return null;
  }
  function FormControlComponent$validationMessages$lambda() {
    return null;
  }
  function FormControlComponent$validationMessageRendering$lambda$lambda$lambda($receiver) {
    return $receiver.compact;
  }
  function FormControlComponent$validationMessageRendering$lambda$lambda$lambda_0($receiver) {
    return $receiver.ghost;
  }
  function FormControlComponent$validationMessageRendering$lambda$lambda(this$FormControlComponent) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(this$FormControlComponent.sizeBuilder);
      $receiver.stacking.invoke_11rb$(FormControlComponent$validationMessageRendering$lambda$lambda$lambda);
      $receiver.variant.invoke_11rb$(FormControlComponent$validationMessageRendering$lambda$lambda$lambda_0);
      return Unit;
    };
  }
  function FormControlComponent$validationMessageRendering$lambda(this$FormControlComponent) {
    return function ($receiver, message) {
      asAlert_0(message, $receiver, FormControlComponent$validationMessageRendering$lambda$lambda(this$FormControlComponent));
      return Unit;
    };
  }
  FormControlComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormControlComponent',
    interfaces: [Component]
  };
  function SingleControlRenderer(component) {
    this.component_0 = component;
  }
  function SingleControlRenderer$render$lambda$lambda($receiver) {
    return $receiver.start;
  }
  function SingleControlRenderer$render$lambda$lambda_0($receiver) {
    return $receiver.full;
  }
  function SingleControlRenderer$render$lambda(this$SingleControlRenderer, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.alignItems_tsd917$(SingleControlRenderer$render$lambda$lambda);
      $receiver.width_wpghq5$(SingleControlRenderer$render$lambda$lambda_0);
      $receiver.invoke_qkhqzy$(this$SingleControlRenderer.component_0.ownSize);
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda_1($receiver) {
    return $receiver.tiny;
  }
  function SingleControlRenderer$render$lambda$lambda$lambda(this$SingleControlRenderer) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SingleControlRenderer.component_0.labelStyle.value);
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda$lambda_0(this$SingleControlRenderer) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      if ((tmp$_0 = (tmp$ = this$SingleControlRenderer.component_0.controlRegistration.assignee) != null ? tmp$.id : null) != null) {
        $receiver.for_61zpoe$(tmp$_0);
      }$receiver.className_61zpoe$(formGroupElementLabelMarker);
      $receiver.renderText_ntmorv$(this$SingleControlRenderer.component_0.label.values);
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.start;
  }
  function SingleControlRenderer$render$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.full;
  }
  function SingleControlRenderer$render$lambda$lambda$lambda_1($receiver) {
    $receiver.alignItems_tsd917$(SingleControlRenderer$render$lambda$lambda$lambda$lambda);
    $receiver.width_wpghq5$(SingleControlRenderer$render$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function SingleControlRenderer$render$lambda$lambda$lambda$lambda_1($receiver) {
    return $receiver.none;
  }
  function SingleControlRenderer$render$lambda$lambda$lambda$lambda_2(closure$control, this$SingleControlRenderer) {
    return function ($receiver) {
      closure$control($receiver);
      this$SingleControlRenderer.component_0.renderHelperText_1s6vjs$($receiver);
      this$SingleControlRenderer.component_0.renderValidationMessages_1s6vjs$($receiver);
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda$lambda_2(closure$control, this$SingleControlRenderer) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(SingleControlRenderer$render$lambda$lambda$lambda$lambda_1);
      $receiver.items.invoke_11rb$(SingleControlRenderer$render$lambda$lambda$lambda$lambda_2(closure$control, this$SingleControlRenderer));
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda$lambda_2(this$SingleControlRenderer, closure$control) {
    return function ($receiver) {
      label($receiver, SingleControlRenderer$render$lambda$lambda$lambda(this$SingleControlRenderer), void 0, void 0, void 0, void 0, SingleControlRenderer$render$lambda$lambda$lambda_0(this$SingleControlRenderer));
      stackUp($receiver, SingleControlRenderer$render$lambda$lambda$lambda_1, void 0, void 0, void 0, SingleControlRenderer$render$lambda$lambda$lambda_2(closure$control, this$SingleControlRenderer));
      return Unit;
    };
  }
  function SingleControlRenderer$render$lambda_0(this$SingleControlRenderer, closure$control) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(SingleControlRenderer$render$lambda$lambda_1);
      $receiver.items.invoke_11rb$(SingleControlRenderer$render$lambda$lambda_2(this$SingleControlRenderer, closure$control));
      return Unit;
    };
  }
  SingleControlRenderer.prototype.render_6w4774$$default = function (styling, baseClass, id, prefix, context, control) {
    stackUp(context, SingleControlRenderer$render$lambda(this, styling), baseClass, id, prefix, SingleControlRenderer$render$lambda_0(this, control)).className_61zpoe$(formGroupElementContainerMarker);
  };
  SingleControlRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleControlRenderer',
    interfaces: [ControlRenderer]
  };
  function ControlGroupRenderer(component) {
    this.component_0 = component;
  }
  function ControlGroupRenderer$render$lambda$lambda($receiver) {
    return $receiver.full;
  }
  function ControlGroupRenderer$render$lambda($receiver) {
    $receiver.width_wpghq5$(ControlGroupRenderer$render$lambda$lambda);
    return Unit;
  }
  function ControlGroupRenderer$render$lambda$lambda_0(this$ControlGroupRenderer, closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$ControlGroupRenderer.component_0.ownSize);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda(this$ControlGroupRenderer) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$ControlGroupRenderer.component_0.labelStyle.value);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda_0(this$ControlGroupRenderer) {
    return function ($receiver) {
      $receiver.className_61zpoe$(formGroupElementLegendMarker);
      $receiver.renderText_ntmorv$(this$ControlGroupRenderer.component_0.label.values);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.none;
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda$lambda_0(closure$control, this$ControlGroupRenderer) {
    return function ($receiver) {
      closure$control($receiver);
      this$ControlGroupRenderer.component_0.renderHelperText_1s6vjs$($receiver);
      this$ControlGroupRenderer.component_0.renderValidationMessages_1s6vjs$($receiver);
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda$lambda_1(closure$control, this$ControlGroupRenderer) {
    return function ($receiver) {
      $receiver.spacing.invoke_11rb$(ControlGroupRenderer$render$lambda$lambda$lambda$lambda);
      $receiver.items.invoke_11rb$(ControlGroupRenderer$render$lambda$lambda$lambda$lambda_0(closure$control, this$ControlGroupRenderer));
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda$lambda_1(this$ControlGroupRenderer, closure$control) {
    return function ($receiver) {
      $receiver.className_61zpoe$(formGroupElementContainerMarker);
      legend($receiver, ControlGroupRenderer$render$lambda$lambda$lambda(this$ControlGroupRenderer), void 0, void 0, void 0, void 0, ControlGroupRenderer$render$lambda$lambda$lambda_0(this$ControlGroupRenderer));
      stackUp($receiver, void 0, void 0, void 0, void 0, ControlGroupRenderer$render$lambda$lambda$lambda_1(closure$control, this$ControlGroupRenderer));
      return Unit;
    };
  }
  function ControlGroupRenderer$render$lambda_0(this$ControlGroupRenderer, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$control) {
    return function ($receiver) {
      $receiver.className_61zpoe$(formGroupElementContainerMarker);
      fieldset($receiver, ControlGroupRenderer$render$lambda$lambda_0(this$ControlGroupRenderer, closure$styling), closure$baseClass, closure$id, closure$prefix, void 0, ControlGroupRenderer$render$lambda$lambda_1(this$ControlGroupRenderer, closure$control));
      return Unit;
    };
  }
  ControlGroupRenderer.prototype.render_6w4774$$default = function (styling, baseClass, id, prefix, context, control) {
    div(context, ControlGroupRenderer$render$lambda, void 0, void 0, void 0, void 0, ControlGroupRenderer$render$lambda_0(this, styling, baseClass, id, prefix, control));
  };
  ControlGroupRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ControlGroupRenderer',
    interfaces: [ControlRenderer]
  };
  function FormGroupComponent() {
    FormGroupComponent$Companion_getInstance();
    this.items = new ComponentProperty(FormGroupComponent$items$lambda);
    var tmp$ = FormGroupComponent$Companion_getInstance().sm;
    var $receiver = new FormGroupComponent$LabelContext();
    $receiver.placement.invoke_11rb$(FormGroupComponent$labelValues$lambda$lambda);
    this.labelValues = mutableMapOf([to(tmp$, $receiver)]);
  }
  function FormGroupComponent$Companion() {
    FormGroupComponent$Companion_instance = this;
    this.sm = 'sm';
    this.md = 'md';
    this.lg = 'lg';
    this.xl = 'xl';
  }
  FormGroupComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FormGroupComponent$Companion_instance = null;
  function FormGroupComponent$Companion_getInstance() {
    if (FormGroupComponent$Companion_instance === null) {
      new FormGroupComponent$Companion();
    }return FormGroupComponent$Companion_instance;
  }
  function FormGroupComponent$LabelPlacement(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function FormGroupComponent$LabelPlacement_initFields() {
    FormGroupComponent$LabelPlacement_initFields = function () {
    };
    FormGroupComponent$LabelPlacement$TOP_instance = new FormGroupComponent$LabelPlacement('TOP', 0);
    FormGroupComponent$LabelPlacement$LEFT_instance = new FormGroupComponent$LabelPlacement('LEFT', 1);
  }
  var FormGroupComponent$LabelPlacement$TOP_instance;
  function FormGroupComponent$LabelPlacement$TOP_getInstance() {
    FormGroupComponent$LabelPlacement_initFields();
    return FormGroupComponent$LabelPlacement$TOP_instance;
  }
  var FormGroupComponent$LabelPlacement$LEFT_instance;
  function FormGroupComponent$LabelPlacement$LEFT_getInstance() {
    FormGroupComponent$LabelPlacement_initFields();
    return FormGroupComponent$LabelPlacement$LEFT_instance;
  }
  FormGroupComponent$LabelPlacement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LabelPlacement',
    interfaces: [Enum]
  };
  function FormGroupComponent$LabelPlacement$values() {
    return [FormGroupComponent$LabelPlacement$TOP_getInstance(), FormGroupComponent$LabelPlacement$LEFT_getInstance()];
  }
  FormGroupComponent$LabelPlacement.values = FormGroupComponent$LabelPlacement$values;
  function FormGroupComponent$LabelPlacement$valueOf(name) {
    switch (name) {
      case 'TOP':
        return FormGroupComponent$LabelPlacement$TOP_getInstance();
      case 'LEFT':
        return FormGroupComponent$LabelPlacement$LEFT_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.forms.group.FormGroupComponent.LabelPlacement.' + name);
    }
  }
  FormGroupComponent$LabelPlacement.valueOf_61zpoe$ = FormGroupComponent$LabelPlacement$valueOf;
  function FormGroupComponent$LabelPlacementContext() {
    FormGroupComponent$LabelPlacementContext_instance = this;
    this.top = FormGroupComponent$LabelPlacement$TOP_getInstance();
    this.left = FormGroupComponent$LabelPlacement$LEFT_getInstance();
  }
  FormGroupComponent$LabelPlacementContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'LabelPlacementContext',
    interfaces: []
  };
  var FormGroupComponent$LabelPlacementContext_instance = null;
  function FormGroupComponent$LabelPlacementContext_getInstance() {
    if (FormGroupComponent$LabelPlacementContext_instance === null) {
      new FormGroupComponent$LabelPlacementContext();
    }return FormGroupComponent$LabelPlacementContext_instance;
  }
  function FormGroupComponent$LabelContext() {
    this.placement = new ComponentProperty(FormGroupComponent$LabelContext$placement$lambda);
    this.width = new ComponentProperty('auto');
  }
  function FormGroupComponent$LabelContext$placement$lambda($receiver) {
    return $receiver.top;
  }
  FormGroupComponent$LabelContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LabelContext',
    interfaces: []
  };
  FormGroupComponent.prototype.labels_mzedhm$ = function (expression) {
    var tmp$ = this.labelValues;
    var tmp$_0 = FormGroupComponent$Companion_getInstance().sm;
    var $receiver = new FormGroupComponent$LabelContext();
    expression($receiver);
    tmp$.put_xwzc9p$(tmp$_0, $receiver);
  };
  FormGroupComponent.prototype.labels_y2r53o$ = function (sm, md, lg, xl) {
    if (sm === void 0)
      sm = null;
    if (md === void 0)
      md = null;
    if (lg === void 0)
      lg = null;
    if (xl === void 0)
      xl = null;
    if (sm != null) {
      var tmp$ = this.labelValues;
      var tmp$_0 = FormGroupComponent$Companion_getInstance().sm;
      var $receiver = new FormGroupComponent$LabelContext();
      sm($receiver);
      tmp$.put_xwzc9p$(tmp$_0, $receiver);
    }if (md != null) {
      var tmp$_1 = this.labelValues;
      var tmp$_2 = FormGroupComponent$Companion_getInstance().md;
      var $receiver_0 = new FormGroupComponent$LabelContext();
      md($receiver_0);
      tmp$_1.put_xwzc9p$(tmp$_2, $receiver_0);
    }if (lg != null) {
      var tmp$_3 = this.labelValues;
      var tmp$_4 = FormGroupComponent$Companion_getInstance().lg;
      var $receiver_1 = new FormGroupComponent$LabelContext();
      lg($receiver_1);
      tmp$_3.put_xwzc9p$(tmp$_4, $receiver_1);
    }if (xl != null) {
      var tmp$_5 = this.labelValues;
      var tmp$_6 = FormGroupComponent$Companion_getInstance().xl;
      var $receiver_2 = new FormGroupComponent$LabelContext();
      xl($receiver_2);
      tmp$_5.put_xwzc9p$(tmp$_6, $receiver_2);
    }};
  function FormGroupComponent$cssLabelColumnWidth$lambda(this$FormGroupComponent, closure$breakpoint) {
    return function ($receiver) {
      return ensureNotNull(this$FormGroupComponent.labelValues.get_11rb$(closure$breakpoint)).width.value + ' 1fr';
    };
  }
  FormGroupComponent.prototype.cssLabelColumnWidth_61zpoe$ = function (breakpoint) {
    var tmp$;
    if (this.labelValues.get_11rb$(breakpoint) != null) {
      switch (ensureNotNull(this.labelValues.get_11rb$(breakpoint)).placement.value(FormGroupComponent$LabelPlacementContext_getInstance()).name) {
        case 'LEFT':
          tmp$ = FormGroupComponent$cssLabelColumnWidth$lambda(this, breakpoint);
          break;
        case 'TOP':
          tmp$ = null;
          break;
        default:tmp$ = Kotlin.noWhenBranchMatched();
          break;
      }
    } else
      tmp$ = null;
    return tmp$;
  };
  function FormGroupComponent$cssDisplayValue$lambda($receiver) {
    return $receiver.contents;
  }
  FormGroupComponent.prototype.cssDisplayValue_61zpoe$ = function (breakpoint) {
    var tmp$;
    var context = this.labelValues.get_11rb$(breakpoint);
    if (context != null && context.placement.value(FormGroupComponent$LabelPlacementContext_getInstance()) === FormGroupComponent$LabelPlacement$LEFT_getInstance()) {
      tmp$ = FormGroupComponent$cssDisplayValue$lambda;
    } else
      tmp$ = null;
    return tmp$;
  };
  FormGroupComponent.prototype.placementMappingForLabelAlignment = function () {
    var $receiver = this.labelValues;
    var destination = ArrayList_init($receiver.size);
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var key = item.key;
      var value = item.value;
      tmp$_0.call(destination, to(key, value != null && value.placement.value(FormGroupComponent$LabelPlacementContext_getInstance()) === FormGroupComponent$LabelPlacement$LEFT_getInstance() ? 'left' : 'top'));
    }
    return toMap(destination);
  };
  function FormGroupComponent$render$lambda$lambda$lambda(this$FormGroupComponent) {
    return function ($receiver) {
      $receiver.display_76osno$(this$FormGroupComponent.cssDisplayValue_61zpoe$(FormGroupComponent$Companion_getInstance().sm), this$FormGroupComponent.cssDisplayValue_61zpoe$(FormGroupComponent$Companion_getInstance().md), this$FormGroupComponent.cssDisplayValue_61zpoe$(FormGroupComponent$Companion_getInstance().lg), this$FormGroupComponent.cssDisplayValue_61zpoe$(FormGroupComponent$Companion_getInstance().xl));
      return Unit;
    };
  }
  function FormGroupComponent$render$lambda$lambda$lambda_0(this$FormGroupComponent) {
    return function ($receiver) {
      Theme.Companion.invoke().formGroup.label.alignmentLabel($receiver, this$FormGroupComponent.placementMappingForLabelAlignment());
      return Unit;
    };
  }
  function FormGroupComponent$render$lambda$lambda$lambda_1(this$FormGroupComponent) {
    return function ($receiver) {
      Theme.Companion.invoke().formGroup.label.alignmentLegend($receiver, this$FormGroupComponent.placementMappingForLabelAlignment());
      return Unit;
    };
  }
  function FormGroupComponent$render$lambda$lambda(this$FormGroupComponent, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.columns_ti9a38$(this$FormGroupComponent.cssLabelColumnWidth_61zpoe$(FormGroupComponent$Companion_getInstance().sm), this$FormGroupComponent.cssLabelColumnWidth_61zpoe$(FormGroupComponent$Companion_getInstance().md), this$FormGroupComponent.cssLabelColumnWidth_61zpoe$(FormGroupComponent$Companion_getInstance().lg), this$FormGroupComponent.cssLabelColumnWidth_61zpoe$(FormGroupComponent$Companion_getInstance().xl));
      $receiver.children_qlrppv$('.formGroupElementContainerMarker', FormGroupComponent$render$lambda$lambda$lambda(this$FormGroupComponent));
      $receiver.invoke_tdl3c$(Theme.Companion.invoke().formGroup.base);
      $receiver.children_qlrppv$('.formGroupElementLabelMarker', FormGroupComponent$render$lambda$lambda$lambda_0(this$FormGroupComponent));
      $receiver.children_qlrppv$('.formGroupElementLegendMarker', FormGroupComponent$render$lambda$lambda$lambda_1(this$FormGroupComponent));
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function FormGroupComponent$render$lambda$lambda_0(this$FormGroupComponent) {
    return function ($receiver) {
      this$FormGroupComponent.items.value($receiver);
      return Unit;
    };
  }
  FormGroupComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    gridBox(context, FormGroupComponent$render$lambda$lambda(this, styling), baseClass, id, prefix, void 0, FormGroupComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  function FormGroupComponent$items$lambda($receiver) {
    return Unit;
  }
  function FormGroupComponent$labelValues$lambda$lambda($receiver) {
    if (equals(Theme.Companion.invoke().formGroup.label.placement.toLowerCase(), 'left'))
      return $receiver.left;
    else
      return $receiver.top;
  }
  FormGroupComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormGroupComponent',
    interfaces: [Component]
  };
  function Component() {
  }
  Component.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Component',
    interfaces: []
  };
  function ManagedComponent() {
    ManagedComponent$Companion_getInstance();
  }
  function ManagedComponent$Companion() {
    ManagedComponent$Companion_instance = this;
  }
  function ManagedComponent$Companion$ManagedTag(element, job, scope) {
    Tag.call(this, 'div', element.id, void 0, job, scope);
    this.domNode_ddlc95$_0 = element;
  }
  Object.defineProperty(ManagedComponent$Companion$ManagedTag.prototype, 'domNode', {
    configurable: true,
    get: function () {
      return this.domNode_ddlc95$_0;
    }
  });
  ManagedComponent$Companion$ManagedTag.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ManagedTag',
    interfaces: [Tag]
  };
  ManagedComponent$Companion.prototype.managedRenderContext_rcagsd$ = function (id, job, scope) {
    var tmp$, tmp$_0;
    var element = document.getElementById(id);
    if (element != null) {
      tmp$_0 = new ManagedComponent$Companion$ManagedTag(Kotlin.isType(tmp$ = element, HTMLElement) ? tmp$ : throwCCE(), job, scope);
    } else {
      var $receiver = new Div(id, void 0, job, scope);
      var tmp$_1;
      (tmp$_1 = document.body) != null ? tmp$_1.appendChild($receiver.domNode) : null;
      tmp$_0 = $receiver;
    }
    var $receiver_0 = tmp$_0;
    $receiver_0.domNode.innerHTML = '';
    return $receiver_0;
  };
  ManagedComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ManagedComponent$Companion_instance = null;
  function ManagedComponent$Companion_getInstance() {
    if (ManagedComponent$Companion_instance === null) {
      new ManagedComponent$Companion();
    }return ManagedComponent$Companion_instance;
  }
  ManagedComponent.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ManagedComponent',
    interfaces: []
  };
  function randomId() {
    var random = nextUInt(Random.Default, new UInt(10000), new UInt(99999)).toString();
    var time = (new Date()).getMilliseconds().toString();
    var startIndex = time.length - 3 | 0;
    return random + time.substring(startIndex);
  }
  function unsafeFlow$ObjectLiteral_6(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_6($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_6.prototype.constructor = Coroutine$collect_42ocv1$_6;
  Coroutine$collect_42ocv1$_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_6.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_6(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_6.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_5(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_5.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_5;
  Coroutine$unsafeTransform$lambda$lambda_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_5(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_5(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_5(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_5.prototype.constructor = Coroutine$unsafeTransform$lambda_5;
  Coroutine$unsafeTransform$lambda_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_5(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_5(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_5(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_4(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_4.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_4.prototype.constructor = Coroutine$map$lambda_4;
  Coroutine$map$lambda_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_4(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_4(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ElementProperties() {
  }
  ElementProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ElementProperties',
    interfaces: []
  };
  function ElementMixin() {
    this.element_meehrb$_0 = new ComponentProperty(ElementMixin$element$lambda);
  }
  Object.defineProperty(ElementMixin.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.element_meehrb$_0;
    }
  });
  function ElementMixin$element$lambda($receiver) {
    return Unit;
  }
  ElementMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ElementMixin',
    interfaces: [ElementProperties]
  };
  function EventProperties() {
  }
  EventProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EventProperties',
    interfaces: []
  };
  function EventMixin() {
    this.events_2b5v2y$_0 = new ComponentProperty(EventMixin$events$lambda);
  }
  Object.defineProperty(EventMixin.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.events_2b5v2y$_0;
    }
  });
  function EventMixin$events$lambda($receiver) {
    return Unit;
  }
  EventMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventMixin',
    interfaces: [EventProperties]
  };
  function FormProperties() {
  }
  function Coroutine$FormProperties$enabled$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$FormProperties$enabled$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$FormProperties$enabled$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$FormProperties$enabled$lambda.prototype.constructor = Coroutine$FormProperties$enabled$lambda;
  Coroutine$FormProperties$enabled$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function FormProperties$enabled$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$FormProperties$enabled$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  FormProperties.prototype.enabled_433wua$ = function (value) {
    this.disabled.invoke_ror2s8$(new unsafeFlow$ObjectLiteral_6(unsafeTransform$lambda_5(map$lambda_4(FormProperties$enabled$lambda), value)));
  };
  FormProperties.prototype.enabled_6taknv$ = function (value) {
    this.enabled_433wua$(flowOf(value));
  };
  FormProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'FormProperties',
    interfaces: []
  };
  function FormMixin() {
    this.disabled_jn3er1$_0 = new DynamicComponentProperty(flowOf(false));
  }
  Object.defineProperty(FormMixin.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.disabled_jn3er1$_0;
    }
  });
  FormMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormMixin',
    interfaces: [FormProperties]
  };
  function InputFormProperties() {
  }
  InputFormProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InputFormProperties',
    interfaces: [FormProperties]
  };
  function InputFormMixin() {
    FormMixin.call(this);
    this.readonly_jv0ocj$_0 = new DynamicComponentProperty(flowOf(false));
  }
  Object.defineProperty(InputFormMixin.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.readonly_jv0ocj$_0;
    }
  });
  InputFormMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InputFormMixin',
    interfaces: [FormMixin, InputFormProperties]
  };
  function InputFieldProperties() {
  }
  InputFieldProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InputFieldProperties',
    interfaces: []
  };
  function InputFieldMixin() {
    this.variant_hpbwoe$_0 = new ComponentProperty(InputFieldMixin$variant$lambda);
    this.size_grhhqc$_0 = new ComponentProperty(InputFieldMixin$size$lambda);
    this.placeholder_3t8ue4$_0 = new DynamicComponentProperty(flowOf(''));
  }
  Object.defineProperty(InputFieldMixin.prototype, 'variant', {
    configurable: true,
    get: function () {
      return this.variant_hpbwoe$_0;
    }
  });
  Object.defineProperty(InputFieldMixin.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.size_grhhqc$_0;
    }
  });
  Object.defineProperty(InputFieldMixin.prototype, 'placeholder', {
    configurable: true,
    get: function () {
      return this.placeholder_3t8ue4$_0;
    }
  });
  function InputFieldMixin$variant$lambda($receiver) {
    return Theme.Companion.invoke().input.variants.outline;
  }
  function InputFieldMixin$size$lambda($receiver) {
    return Theme.Companion.invoke().input.sizes.normal;
  }
  InputFieldMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InputFieldMixin',
    interfaces: [InputFieldProperties]
  };
  function SeverityProperties() {
  }
  function SeverityProperties$SeverityContext() {
    this.info = Severity$Info_getInstance();
    this.success = Severity$Success_getInstance();
    this.warning = Severity$Warning_getInstance();
    this.error = Severity$Error_getInstance();
  }
  SeverityProperties$SeverityContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SeverityContext',
    interfaces: []
  };
  SeverityProperties.prototype.severity_ietawi$ = function (value) {
    this.severity.invoke_11rb$(value(new SeverityProperties$SeverityContext()));
  };
  function Coroutine$SeverityProperties$severityClassOf$lambda(closure$severityStyle_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$severityStyle = closure$severityStyle_0;
    this.local$it = it_0;
  }
  Coroutine$SeverityProperties$severityClassOf$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SeverityProperties$severityClassOf$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SeverityProperties$severityClassOf$lambda.prototype.constructor = Coroutine$SeverityProperties$severityClassOf$lambda;
  Coroutine$SeverityProperties$severityClassOf$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (equals(this.local$it, Severity$Info_getInstance()))
              return style('severity-info', this.local$closure$severityStyle.info);
            else if (equals(this.local$it, Severity$Success_getInstance()))
              return style('severity-success', this.local$closure$severityStyle.success);
            else if (equals(this.local$it, Severity$Warning_getInstance()))
              return style('severity-warning', this.local$closure$severityStyle.warning);
            else if (equals(this.local$it, Severity$Error_getInstance()))
              return style('severity-error', this.local$closure$severityStyle.error);
            else
              return StyleClass.Companion.None;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SeverityProperties$severityClassOf$lambda(closure$severityStyle_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SeverityProperties$severityClassOf$lambda(closure$severityStyle_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  SeverityProperties.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    var $receiver = this.severity.values;
    return new unsafeFlow$ObjectLiteral_6(unsafeTransform$lambda_5(map$lambda_4(SeverityProperties$severityClassOf$lambda(severityStyle)), $receiver));
  };
  SeverityProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SeverityProperties',
    interfaces: []
  };
  function SeverityMixin() {
    this.severity_cbhd1p$_0 = new NullableDynamicComponentProperty(emptyFlow());
  }
  Object.defineProperty(SeverityMixin.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.severity_cbhd1p$_0;
    }
  });
  SeverityMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SeverityMixin',
    interfaces: [SeverityProperties]
  };
  function CloseButtonProperty() {
  }
  CloseButtonProperty.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CloseButtonProperty',
    interfaces: []
  };
  function CloseButtonMixin(closeButtonPrefix, defaultStyle) {
    if (closeButtonPrefix === void 0)
      closeButtonPrefix = 'close-button';
    this.closeButtonPrefix_c1n2t1$_0 = closeButtonPrefix;
    this.defaultStyle_0 = defaultStyle;
    this.resetButtonStyles_0 = CloseButtonMixin$resetButtonStyles$lambda;
    this.closeButtonStyle_ghbh1g$_0 = new ComponentProperty(CloseButtonMixin$closeButtonStyle$lambda);
    this.closeButtonIcon_3w12y6$_0 = new ComponentProperty(CloseButtonMixin$closeButtonIcon$lambda);
    this.hasCloseButton_vmrdrh$_0 = new ComponentProperty(true);
    this.closeButtonRendering_r7p8n3$_0 = new ComponentProperty(CloseButtonMixin$closeButtonRendering$lambda(this));
  }
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonPrefix', {
    get: function () {
      return this.closeButtonPrefix_c1n2t1$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.closeButtonStyle_ghbh1g$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.closeButtonIcon_3w12y6$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.hasCloseButton_vmrdrh$_0;
    }
  });
  Object.defineProperty(CloseButtonMixin.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.closeButtonRendering_r7p8n3$_0;
    }
  });
  function CloseButtonMixin$resetButtonStyles$lambda$lambda($receiver) {
    return 'unset';
  }
  function CloseButtonMixin$resetButtonStyles$lambda$lambda_0($receiver) {
    return 'unset';
  }
  function CloseButtonMixin$resetButtonStyles$lambda$lambda_1($receiver) {
    return 'unset';
  }
  function CloseButtonMixin$resetButtonStyles$lambda$lambda_2($receiver) {
    return 'unset';
  }
  function CloseButtonMixin$resetButtonStyles$lambda$lambda_3($receiver) {
    return 'unset';
  }
  function CloseButtonMixin$resetButtonStyles$lambda$lambda_4($receiver) {
    return 'unset';
  }
  function CloseButtonMixin$resetButtonStyles$lambda($receiver) {
    $receiver.lineHeight_bcpvvc$(CloseButtonMixin$resetButtonStyles$lambda$lambda);
    $receiver.radius_bcpvvc$(CloseButtonMixin$resetButtonStyles$lambda$lambda_0);
    $receiver.fontWeight_wyjwgc$(CloseButtonMixin$resetButtonStyles$lambda$lambda_1);
    $receiver.padding_bcpvvc$(CloseButtonMixin$resetButtonStyles$lambda$lambda_2);
    $receiver.height_wpghq5$(CloseButtonMixin$resetButtonStyles$lambda$lambda_3);
    $receiver.minWidth_wpghq5$(CloseButtonMixin$resetButtonStyles$lambda$lambda_4);
    return Unit;
  }
  function CloseButtonMixin$closeButtonStyle$lambda($receiver) {
    return Unit;
  }
  function CloseButtonMixin$closeButtonIcon$lambda($receiver) {
    return Theme.Companion.invoke().icons.close;
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda(this$CloseButtonMixin) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$CloseButtonMixin.resetButtonStyles_0);
      $receiver.invoke_qkhqzy$(this$CloseButtonMixin.defaultStyle_0);
      $receiver.invoke_qkhqzy$(this$CloseButtonMixin.closeButtonStyle.value);
      return Unit;
    };
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda($receiver) {
    return PushButtonComponent$VariantContext_getInstance().ghost;
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda_0(this$CloseButtonMixin) {
    return function ($receiver) {
      return this$CloseButtonMixin.closeButtonIcon.value(Theme.Companion.invoke().icons);
    };
  }
  function CloseButtonMixin$closeButtonRendering$lambda$lambda_0(this$CloseButtonMixin) {
    return function ($receiver) {
      $receiver.variant.invoke_11rb$(CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda);
      $receiver.icon.invoke_11rb$(CloseButtonMixin$closeButtonRendering$lambda$lambda$lambda_0(this$CloseButtonMixin));
      return Unit;
    };
  }
  function CloseButtonMixin$closeButtonRendering$lambda(this$CloseButtonMixin) {
    return function ($receiver) {
      return clickButton($receiver, CloseButtonMixin$closeButtonRendering$lambda$lambda(this$CloseButtonMixin), void 0, void 0, this$CloseButtonMixin.closeButtonPrefix, CloseButtonMixin$closeButtonRendering$lambda$lambda_0(this$CloseButtonMixin));
    };
  }
  CloseButtonMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CloseButtonMixin',
    interfaces: [CloseButtonProperty]
  };
  function Orientation(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Orientation_initFields() {
    Orientation_initFields = function () {
    };
    Orientation$HORIZONTAL_instance = new Orientation('HORIZONTAL', 0);
    Orientation$VERTICAL_instance = new Orientation('VERTICAL', 1);
  }
  var Orientation$HORIZONTAL_instance;
  function Orientation$HORIZONTAL_getInstance() {
    Orientation_initFields();
    return Orientation$HORIZONTAL_instance;
  }
  var Orientation$VERTICAL_instance;
  function Orientation$VERTICAL_getInstance() {
    Orientation_initFields();
    return Orientation$VERTICAL_instance;
  }
  Orientation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Orientation',
    interfaces: [Enum]
  };
  function Orientation$values() {
    return [Orientation$HORIZONTAL_getInstance(), Orientation$VERTICAL_getInstance()];
  }
  Orientation.values = Orientation$values;
  function Orientation$valueOf(name) {
    switch (name) {
      case 'HORIZONTAL':
        return Orientation$HORIZONTAL_getInstance();
      case 'VERTICAL':
        return Orientation$VERTICAL_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.foundations.Orientation.' + name);
    }
  }
  Orientation.valueOf_61zpoe$ = Orientation$valueOf;
  function OrientationContext() {
    OrientationContext_instance = this;
    this.horizontal = Orientation$HORIZONTAL_getInstance();
    this.vertical = Orientation$VERTICAL_getInstance();
  }
  OrientationContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'OrientationContext',
    interfaces: []
  };
  var OrientationContext_instance = null;
  function OrientationContext_getInstance() {
    if (OrientationContext_instance === null) {
      new OrientationContext();
    }return OrientationContext_instance;
  }
  function OrientationProperty() {
  }
  OrientationProperty.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OrientationProperty',
    interfaces: []
  };
  function OrientationMixin(default_0) {
    this.orientation_gyqzdl$_0 = lazy(OrientationMixin$orientation$lambda(default_0));
  }
  Object.defineProperty(OrientationMixin.prototype, 'orientation', {
    configurable: true,
    get: function () {
      return this.orientation_gyqzdl$_0.value;
    }
  });
  function OrientationMixin$orientation$lambda$lambda(closure$default) {
    return function ($receiver) {
      return closure$default;
    };
  }
  function OrientationMixin$orientation$lambda(closure$default) {
    return function () {
      return new ComponentProperty(OrientationMixin$orientation$lambda$lambda(closure$default));
    };
  }
  OrientationMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OrientationMixin',
    interfaces: [OrientationProperty]
  };
  function TooltipProperties() {
  }
  function TooltipProperties$tooltip$lambda$lambda(closure$build) {
    return function ($receiver) {
      closure$build($receiver);
      return Unit;
    };
  }
  function TooltipProperties$tooltip$lambda(closure$styling, closure$text, closure$baseClass, closure$id, closure$prefix, closure$build) {
    return function ($receiver) {
      tooltip_1($receiver, closure$styling, closure$text, closure$baseClass, closure$id, closure$prefix, TooltipProperties$tooltip$lambda$lambda(closure$build));
      return Unit;
    };
  }
  TooltipProperties.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    this.renderTooltip.invoke_11rb$(TooltipProperties$tooltip$lambda(styling, text, baseClass, id, prefix, build));
  };
  function TooltipProperties$tooltip$lambda_0($receiver) {
    return Unit;
  }
  TooltipProperties.prototype.tooltip_of5yat$ = function (styling, text, baseClass, id, prefix, build, callback$default) {
    if (styling === void 0)
      styling = TooltipProperties$tooltip$lambda_0;
    if (text === void 0)
      text = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = 'fc2-tooltip-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = 'tooltip';
    callback$default ? callback$default(styling, text, baseClass, id, prefix, build) : this.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  function TooltipProperties$tooltip$lambda$lambda_0($receiver) {
    return Unit;
  }
  function TooltipProperties$tooltip$lambda$lambda_1(closure$build, closure$text) {
    return function ($receiver) {
      closure$build($receiver);
      $receiver.text_vqirvp$(closure$text.slice());
      return Unit;
    };
  }
  function TooltipProperties$tooltip$lambda_1(closure$build, closure$text) {
    return function ($receiver) {
      tooltip_1($receiver, TooltipProperties$tooltip$lambda$lambda_0, void 0, void 0, void 0, void 0, TooltipProperties$tooltip$lambda$lambda_1(closure$build, closure$text));
      return Unit;
    };
  }
  TooltipProperties.prototype.tooltip_h43rbb$ = function (text, build) {
    this.renderTooltip.invoke_11rb$(TooltipProperties$tooltip$lambda_1(build, text));
  };
  TooltipProperties.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TooltipProperties',
    interfaces: []
  };
  function TooltipMixin() {
    this.renderTooltip_wgd22l$_0 = new ComponentProperty(TooltipMixin$renderTooltip$lambda);
  }
  Object.defineProperty(TooltipMixin.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.renderTooltip_wgd22l$_0;
    }
  });
  function TooltipMixin$renderTooltip$lambda($receiver) {
    return Unit;
  }
  TooltipMixin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TooltipMixin',
    interfaces: [TooltipProperties]
  };
  function ComponentProperty(value) {
    this.value = value;
  }
  ComponentProperty.prototype.invoke_11rb$ = function (newValue) {
    this.value = newValue;
  };
  ComponentProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentProperty',
    interfaces: []
  };
  function DynamicComponentProperty(values) {
    if (values === void 0)
      values = emptyFlow();
    this.values = values;
  }
  DynamicComponentProperty.prototype.invoke_11rb$ = function (newValue) {
    this.values = flowOf(newValue);
  };
  DynamicComponentProperty.prototype.invoke_ror2s8$ = function (newValues) {
    this.values = newValues;
  };
  DynamicComponentProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DynamicComponentProperty',
    interfaces: []
  };
  function NullableDynamicComponentProperty(values) {
    this.values = values;
  }
  NullableDynamicComponentProperty.prototype.invoke_11rb$ = function (newValue) {
    this.values = flowOf(newValue);
  };
  NullableDynamicComponentProperty.prototype.invoke_ror2s8$ = function (newValues) {
    this.values = newValues;
  };
  NullableDynamicComponentProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NullableDynamicComponentProperty',
    interfaces: []
  };
  function MultiSelectionStore() {
    RootStore.call(this, emptyList());
    this.toggle = this.handleAndEmit_6gppb5$(void 0, MultiSelectionStore$toggle$lambda);
  }
  function Coroutine$MultiSelectionStore$toggle$lambda($receiver_0, selectedRows_0, new_1, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$newSelection = void 0;
    this.local$$receiver = $receiver_0;
    this.local$selectedRows = selectedRows_0;
    this.local$new = new_1;
  }
  Coroutine$MultiSelectionStore$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MultiSelectionStore$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MultiSelectionStore$toggle$lambda.prototype.constructor = Coroutine$MultiSelectionStore$toggle$lambda;
  Coroutine$MultiSelectionStore$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$newSelection = this.local$selectedRows.contains_11rb$(this.local$new) ? minus(this.local$selectedRows, this.local$new) : plus(this.local$selectedRows, this.local$new);
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(this.local$newSelection, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$newSelection;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MultiSelectionStore$toggle$lambda($receiver_0, selectedRows_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$MultiSelectionStore$toggle$lambda($receiver_0, selectedRows_0, new_1, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  MultiSelectionStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultiSelectionStore',
    interfaces: [RootStore]
  };
  function SingleSelectionStore() {
    RootStore.call(this, null);
    this.toggle = this.handleAndEmit_6gppb5$(void 0, SingleSelectionStore$toggle$lambda);
  }
  function Coroutine$SingleSelectionStore$toggle$lambda($receiver_0, f_0, new_1, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$new = new_1;
  }
  Coroutine$SingleSelectionStore$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SingleSelectionStore$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SingleSelectionStore$toggle$lambda.prototype.constructor = Coroutine$SingleSelectionStore$toggle$lambda;
  Coroutine$SingleSelectionStore$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(this.local$new, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$new;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SingleSelectionStore$toggle$lambda($receiver_0, f_0, new_1, continuation_0, suspended) {
    var instance = new Coroutine$SingleSelectionStore$toggle$lambda($receiver_0, f_0, new_1, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  SingleSelectionStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SingleSelectionStore',
    interfaces: [RootStore]
  };
  function IconComponent() {
    IconComponent$Companion_getInstance();
    this.$delegate_yku6rj$_0 = new EventMixin();
    this.def = new ComponentProperty(null);
    this.displayName = new ComponentProperty(null);
    this.viewBox = new ComponentProperty('0 0 24 24');
    this.svg = new ComponentProperty(null);
  }
  function IconComponent$Companion() {
    IconComponent$Companion_instance = this;
    this.prefix = 'icon';
    this.staticCss = staticStyle_0(this.prefix, '\n                width: 1.25rem;\n                height: 1.25rem;\n                color: currentColor;\n                display: inline-block;\n                vertical-align: middle;\n                flex-shrink: 0;\n                backface-visibility: hidden;\n            ');
  }
  IconComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var IconComponent$Companion_instance = null;
  function IconComponent$Companion_getInstance() {
    if (IconComponent$Companion_instance === null) {
      new IconComponent$Companion();
    }return IconComponent$Companion_instance;
  }
  IconComponent.prototype.fromTheme_q0wvou$ = function (value) {
    this.def.invoke_11rb$(value(Theme.Companion.invoke().icons));
  };
  function IconComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function IconComponent$render$lambda$lambda_0(this$IconComponent) {
    return function ($receiver) {
      var tmp$;
      if ((tmp$ = this$IconComponent.def.value) != null) {
        $receiver.attr_puj7f4$('viewBox', tmp$.viewBox);
        $receiver.attr_puj7f4$('focusable', 'false');
        $receiver.attr_puj7f4$('role', 'presentation');
        $receiver.content_61zpoe$(tmp$.svg);
      }this$IconComponent.events.value($receiver);
      return Unit;
    };
  }
  IconComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    svg(context, IconComponent$render$lambda$lambda(styling), baseClass.plus_fox8kt$(IconComponent$Companion_getInstance().staticCss), id, prefix, void 0, IconComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  Object.defineProperty(IconComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_yku6rj$_0.events;
    }
  });
  IconComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IconComponent',
    interfaces: [EventProperties, Component]
  };
  function icon$lambda($receiver) {
    return Unit;
  }
  function icon$lambda_0($receiver) {
    return Unit;
  }
  function icon($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = icon$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = IconComponent$Companion_getInstance().prefix;
    if (build === void 0)
      build = icon$lambda_0;
    var $receiver_0 = new IconComponent();
    build($receiver_0);
    if ($receiver_0.displayName.value != null && $receiver_0.svg.value != null) {
      $receiver_0.def.invoke_11rb$(new IconDefinition(ensureNotNull($receiver_0.displayName.value), $receiver_0.viewBox.value, ensureNotNull($receiver_0.svg.value)));
    }$receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function inputField$lambda($receiver) {
    return Unit;
  }
  function inputField$lambda_0($receiver) {
    return Unit;
  }
  function inputField($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = inputField$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'inputField';
    if (build === void 0)
      build = inputField$lambda_0;
    var $receiver_0 = new InputFieldComponent(value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function InputFieldComponent(valueStore) {
    InputFieldComponent$Companion_getInstance();
    this.valueStore = valueStore;
    this.$delegate_q2xu3j$_0 = new EventMixin();
    this.$delegate_q2xu3j$_1 = new ElementMixin();
    this.$delegate_q2xu3j$_2 = new InputFormMixin();
    this.$delegate_q2xu3j$_3 = new SeverityMixin();
    this.$delegate_q2xu3j$_4 = new InputFieldMixin();
    this.$delegate_q2xu3j$_5 = new TooltipMixin();
    this.value = new DynamicComponentProperty();
    this.type = new DynamicComponentProperty(flowOf('text'));
    this.step = new DynamicComponentProperty();
  }
  function InputFieldComponent$Companion() {
    InputFieldComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('inputBox', '\n                display: inline-flex;\n                position: relative;\n                vertical-align: middle;\n                height: 2.5rem;\n                appearance: none;\n                align-items : center;\n                justify-content: center;\n                transition: all 250ms;\n                white-space: nowrap;\n                outline: none;\n                width: 100%;\n                -webkit-appearance: none;\n            ');
  }
  InputFieldComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InputFieldComponent$Companion_instance = null;
  function InputFieldComponent$Companion_getInstance() {
    if (InputFieldComponent$Companion_instance === null) {
      new InputFieldComponent$Companion();
    }return InputFieldComponent$Companion_instance;
  }
  function InputFieldComponent$render$lambda$lambda(this$InputFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$InputFieldComponent.size.value(Theme.Companion.invoke().input.sizes));
      $receiver.invoke_qkhqzy$(this$InputFieldComponent.variant.value(Theme.Companion.invoke().input.variants));
      return Unit;
    };
  }
  function InputFieldComponent$render$lambda$lambda_0(this$InputFieldComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.disabled_f1igrw$(this$InputFieldComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$InputFieldComponent.readonly.values);
      $receiver.placeholder_p81yox$(this$InputFieldComponent.placeholder.values);
      $receiver.value_p81yox$(this$InputFieldComponent.value.values);
      $receiver.type_p81yox$(this$InputFieldComponent.type.values);
      $receiver.step_p81yox$(this$InputFieldComponent.step.values);
      $receiver.className_p81yox$(get_name(this$InputFieldComponent.severityClassOf_i6436e$(Theme.Companion.invoke().input.severity)));
      if ((tmp$ = this$InputFieldComponent.valueStore) != null) {
        $receiver.value_p81yox$(tmp$.data);
        $receiver.handledBy_ytah3h$(values($receiver.changes), tmp$.update);
      }this$InputFieldComponent.events.value($receiver);
      this$InputFieldComponent.element.value($receiver);
      this$InputFieldComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  InputFieldComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    return input_0(context, InputFieldComponent$render$lambda$lambda(this), styling, baseClass.plus_fox8kt$(InputFieldComponent$Companion_getInstance().staticCss), id, prefix, void 0, InputFieldComponent$render$lambda$lambda_0(this));
  };
  Object.defineProperty(InputFieldComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_0.events;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_1.element;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_2.disabled;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_2.readonly;
    }
  });
  InputFieldComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_q2xu3j$_2.enabled_6taknv$(value);
  };
  InputFieldComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_q2xu3j$_2.enabled_433wua$(value);
  };
  Object.defineProperty(InputFieldComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_3.severity;
    }
  });
  InputFieldComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_q2xu3j$_3.severity_ietawi$(value);
  };
  InputFieldComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_q2xu3j$_3.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(InputFieldComponent.prototype, 'placeholder', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_4.placeholder;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_4.size;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'variant', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_4.variant;
    }
  });
  Object.defineProperty(InputFieldComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_q2xu3j$_5.renderTooltip;
    }
  });
  InputFieldComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_q2xu3j$_5.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  InputFieldComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_q2xu3j$_5.tooltip_h43rbb$(text, build);
  };
  InputFieldComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InputFieldComponent',
    interfaces: [TooltipProperties, InputFieldProperties, SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function menu$lambda($receiver) {
    return Unit;
  }
  function menu($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = menu$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'menu';
    var $receiver_0 = new MenuComponent($receiver.scope);
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function plus$lambda_0(this$plus, closure$other) {
    return function ($receiver) {
      this$plus($receiver);
      closure$other($receiver);
      return Unit;
    };
  }
  function unsafeFlow$ObjectLiteral_7(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_7($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_7.prototype.constructor = Coroutine$collect_42ocv1$_7;
  Coroutine$collect_42ocv1$_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_7.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_7(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_7.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_6(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_6.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_6;
  Coroutine$unsafeTransform$lambda$lambda_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_6(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_6(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_6(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_6.prototype.constructor = Coroutine$unsafeTransform$lambda_6;
  Coroutine$unsafeTransform$lambda_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_6(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_6(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_6(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_5(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_5.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_5.prototype.constructor = Coroutine$map$lambda_5;
  Coroutine$map$lambda_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_5(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_5(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function MenuComponent(scope) {
    MenuContext.call(this);
    this.styles = scope.get_ktgxi1$(AppFrameScope$Navigation_getInstance()) === true ? Theme.Companion.invoke().appFrame.menu : Theme.Companion.invoke().menu;
  }
  function MenuComponent$render$lambda$lambda(this$MenuComponent) {
    return function ($receiver) {
      var $receiver_0 = this$MenuComponent.children;
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        element.render_wcjbs8$($receiver, this$MenuComponent.styles);
      }
      return Unit;
    };
  }
  MenuComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    div(context, plus$lambda_0(this.styles.container, styling), baseClass, id, prefix, void 0, MenuComponent$render$lambda$lambda(this));
    return Unit;
  };
  MenuComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MenuComponent',
    interfaces: [MenuContext, Component]
  };
  function SubMenuComponent(styling, value, baseClass, id, prefix) {
    SubMenuComponent$Companion_getInstance();
    if (value === void 0)
      value = null;
    MenuContext.call(this);
    this.styling = styling;
    this.value = value;
    this.baseClass = baseClass;
    this.id = id;
    this.prefix = prefix;
    this.$delegate_lykwed$_0 = new EventMixin();
    this.$delegate_lykwed$_1 = new FormMixin();
    this.icon = null;
    this.text = new ComponentProperty(null);
    var tmp$;
    this.visible_ci3885$_0 = (tmp$ = this.value) != null ? tmp$ : storeOf(false);
  }
  function SubMenuComponent$Companion() {
    SubMenuComponent$Companion_instance = this;
    this.hidden = staticStyle_0('hidden', 'display: none');
  }
  SubMenuComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SubMenuComponent$Companion_instance = null;
  function SubMenuComponent$Companion_getInstance() {
    if (SubMenuComponent$Companion_instance === null) {
      new SubMenuComponent$Companion();
    }return SubMenuComponent$Companion_instance;
  }
  SubMenuComponent.prototype.icon_q0wvou$ = function (def) {
    this.icon = flowOf(def(Theme.Companion.invoke().icons));
  };
  SubMenuComponent.prototype.icon_pvhbyw$ = function (def) {
    this.icon = def;
  };
  function SubMenuComponent$render$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(closure$it);
      return Unit;
    };
  }
  function SubMenuComponent$render$lambda$lambda$lambda(closure$styles) {
    return function ($receiver, it) {
      icon($receiver, closure$styles.icon, void 0, void 0, void 0, SubMenuComponent$render$lambda$lambda$lambda$lambda(it));
      return Unit;
    };
  }
  function SubMenuComponent$render$lambda$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$it);
      return Unit;
    };
  }
  function Coroutine$SubMenuComponent$render$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$SubMenuComponent$render$lambda$lambda$lambda;
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SubMenuComponent$render$lambda$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SubMenuComponent$render$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SubMenuComponent$render$lambda$lambda(this$SubMenuComponent, closure$styles) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      (tmp$ = this$SubMenuComponent.icon) != null ? ($receiver.render_a5p5o5$(tmp$, void 0, SubMenuComponent$render$lambda$lambda$lambda(closure$styles)), Unit) : null;
      if ((tmp$_0 = this$SubMenuComponent.text.value) != null) {
        $receiver.span_dzf5a3$(void 0, void 0, void 0, SubMenuComponent$render$lambda$lambda$lambda$lambda_0(tmp$_0));
      }$receiver.disabled_f1igrw$(this$SubMenuComponent.disabled.values);
      $receiver.handledBy_jora5j$($receiver.clicks, this$SubMenuComponent.visible_ci3885$_0.handle_7ib3lp$(void 0, SubMenuComponent$render$lambda$lambda$lambda_0));
      this$SubMenuComponent.events.value($receiver);
      return Unit;
    };
  }
  function Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0.prototype.constructor = Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0;
  Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SubMenuComponent$render$lambda$lambda$lambda_1(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SubMenuComponent$render$lambda$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SubMenuComponent$render$lambda$lambda_0(this$SubMenuComponent, closure$styles) {
    return function ($receiver) {
      var tmp$ = SubMenuComponent$Companion_getInstance().hidden;
      var $receiver_0 = this$SubMenuComponent.visible_ci3885$_0.data;
      $receiver.className_p81yox$(get_name(whenever(tmp$, new unsafeFlow$ObjectLiteral_7(unsafeTransform$lambda_6(map$lambda_5(SubMenuComponent$render$lambda$lambda$lambda_1), $receiver_0)))));
      var $receiver_1 = this$SubMenuComponent.children;
      var tmp$_0;
      tmp$_0 = $receiver_1.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        element.render_wcjbs8$($receiver, closure$styles);
      }
      return Unit;
    };
  }
  SubMenuComponent.prototype.render_wcjbs8$ = function (context, styles) {
    button_0(context, plus$lambda_0(styles.entry, this.styling), void 0, void 0, void 0, void 0, SubMenuComponent$render$lambda$lambda(this, styles));
    div(context, styles.sub, this.baseClass, this.id, this.prefix, void 0, SubMenuComponent$render$lambda$lambda_0(this, styles));
  };
  Object.defineProperty(SubMenuComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_lykwed$_0.events;
    }
  });
  Object.defineProperty(SubMenuComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_lykwed$_1.disabled;
    }
  });
  SubMenuComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_lykwed$_1.enabled_6taknv$(value);
  };
  SubMenuComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_lykwed$_1.enabled_433wua$(value);
  };
  SubMenuComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SubMenuComponent',
    interfaces: [MenuContext, FormProperties, EventProperties, MenuChild]
  };
  function MenuContext() {
    this.children = ArrayList_init_0();
  }
  MenuContext.prototype.addChild_kbnlgg$ = function (child) {
    return this.children.add_11rb$(child);
  };
  function MenuContext$header$lambda($receiver) {
    return Unit;
  }
  MenuContext.prototype.header_61zpoe$ = function (text) {
    this.header_m1f4c0$(MenuContext$header$lambda, text);
  };
  MenuContext.prototype.header_m1f4c0$ = function (styling, text) {
    var $receiver = new MenuHeader(styling);
    $receiver.text.invoke_11rb$(text);
    getCallableRef('addChild', function ($receiver, p1) {
      return $receiver.addChild_kbnlgg$(p1);
    }.bind(null, this))($receiver);
  };
  function MenuContext$entry$lambda($receiver) {
    return Unit;
  }
  MenuContext.prototype.entry_htvi1r$ = function (build) {
    this.entry_680rlf$(MenuContext$entry$lambda, build);
  };
  MenuContext.prototype.entry_680rlf$ = function (styling, build) {
    var $receiver = new MenuEntry(styling);
    build($receiver);
    getCallableRef('addChild', function ($receiver, p1) {
      return $receiver.addChild_kbnlgg$(p1);
    }.bind(null, this))($receiver);
  };
  function MenuContext$link$lambda($receiver) {
    return Unit;
  }
  MenuContext.prototype.link_zc2uit$ = function (build) {
    this.link_bn9sev$(MenuContext$link$lambda, build);
  };
  MenuContext.prototype.link_bn9sev$ = function (styling, build) {
    var $receiver = new MenuLink(styling);
    build($receiver);
    getCallableRef('addChild', function ($receiver, p1) {
      return $receiver.addChild_kbnlgg$(p1);
    }.bind(null, this))($receiver);
  };
  function MenuContext$custom$lambda($receiver) {
    return Unit;
  }
  MenuContext.prototype.custom_9c978p$ = function (build) {
    this.custom_hn5ufr$(MenuContext$custom$lambda, build);
  };
  MenuContext.prototype.custom_hn5ufr$ = function (styling, build) {
    var $receiver = new CustomMenuEntry(styling);
    $receiver.content.invoke_11rb$(build);
    getCallableRef('addChild', function ($receiver, p1) {
      return $receiver.addChild_kbnlgg$(p1);
    }.bind(null, this))($receiver);
  };
  function MenuContext$divider$lambda($receiver) {
    return Unit;
  }
  MenuContext.prototype.divider_krrttq$ = function (styling) {
    if (styling === void 0)
      styling = MenuContext$divider$lambda;
    this.addChild_kbnlgg$(new MenuDivider(styling));
  };
  function MenuContext$submenu$lambda($receiver) {
    return Unit;
  }
  MenuContext.prototype.submenu_7bl4rg$ = function (styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = MenuContext$submenu$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'submenu';
    var $receiver = new SubMenuComponent(styling, value, baseClass, id, prefix);
    build($receiver);
    return getCallableRef('addChild', function ($receiver, p1) {
      return $receiver.addChild_kbnlgg$(p1);
    }.bind(null, this))($receiver);
  };
  MenuContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MenuContext',
    interfaces: []
  };
  function plus$lambda_1(this$plus, closure$other) {
    return function ($receiver) {
      this$plus($receiver);
      closure$other($receiver);
      return Unit;
    };
  }
  function MenuChild() {
  }
  MenuChild.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MenuChild',
    interfaces: []
  };
  function MenuEntry(styling) {
    if (styling === void 0)
      styling = MenuEntry_init$lambda;
    this.styling_lqznb8$_0 = styling;
    this.$delegate_kafy16$_0 = new EventMixin();
    this.$delegate_kafy16$_1 = new ElementMixin();
    this.$delegate_kafy16$_2 = new FormMixin();
    this.$delegate_kafy16$_3 = new TooltipMixin();
    this.icon = new ComponentProperty(null);
    this.text = new ComponentProperty(null);
  }
  function MenuEntry$render$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(closure$it(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function MenuEntry$render$lambda$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$it);
      return Unit;
    };
  }
  function MenuEntry$render$lambda$lambda(this$MenuEntry, closure$styles) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      if ((tmp$ = this$MenuEntry.icon.value) != null) {
        icon($receiver, closure$styles.icon, void 0, void 0, void 0, MenuEntry$render$lambda$lambda$lambda$lambda(tmp$));
      }if ((tmp$_0 = this$MenuEntry.text.value) != null) {
        $receiver.span_dzf5a3$(void 0, void 0, void 0, MenuEntry$render$lambda$lambda$lambda$lambda_0(tmp$_0));
      }$receiver.disabled_f1igrw$(this$MenuEntry.disabled.values);
      this$MenuEntry.element.value($receiver);
      this$MenuEntry.events.value($receiver);
      this$MenuEntry.renderTooltip.value($receiver);
      return Unit;
    };
  }
  MenuEntry.prototype.render_wcjbs8$ = function (context, styles) {
    button_0(context, plus$lambda_1(styles.entry, this.styling_lqznb8$_0), void 0, void 0, void 0, void 0, MenuEntry$render$lambda$lambda(this, styles));
  };
  Object.defineProperty(MenuEntry.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_kafy16$_0.events;
    }
  });
  Object.defineProperty(MenuEntry.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_kafy16$_1.element;
    }
  });
  Object.defineProperty(MenuEntry.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_kafy16$_2.disabled;
    }
  });
  MenuEntry.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_kafy16$_2.enabled_6taknv$(value);
  };
  MenuEntry.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_kafy16$_2.enabled_433wua$(value);
  };
  Object.defineProperty(MenuEntry.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_kafy16$_3.renderTooltip;
    }
  });
  MenuEntry.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_kafy16$_3.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  MenuEntry.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_kafy16$_3.tooltip_h43rbb$(text, build);
  };
  function MenuEntry_init$lambda($receiver) {
    return Unit;
  }
  MenuEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MenuEntry',
    interfaces: [TooltipProperties, FormProperties, ElementProperties, EventProperties, MenuChild]
  };
  function MenuLink(styling) {
    if (styling === void 0)
      styling = MenuLink_init$lambda;
    this.styling_j253gk$_0 = styling;
    this.$delegate_fdyygm$_0 = new EventMixin();
    this.$delegate_fdyygm$_1 = new ElementMixin();
    this.$delegate_fdyygm$_2 = new FormMixin();
    this.$delegate_fdyygm$_3 = new TooltipMixin();
    this.icon = new ComponentProperty(null);
    this.text = new ComponentProperty(null);
    this.href = new ComponentProperty(null);
    this.target = new ComponentProperty(null);
  }
  function MenuLink$render$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(closure$it(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function MenuLink$render$lambda$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$it);
      return Unit;
    };
  }
  function MenuLink$render$lambda$lambda(this$MenuLink, closure$styles) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      if ((tmp$ = this$MenuLink.icon.value) != null) {
        icon($receiver, closure$styles.icon, void 0, void 0, void 0, MenuLink$render$lambda$lambda$lambda$lambda(tmp$));
      }if ((tmp$_0 = this$MenuLink.text.value) != null) {
        $receiver.span_dzf5a3$(void 0, void 0, void 0, MenuLink$render$lambda$lambda$lambda$lambda_0(tmp$_0));
      }if ((tmp$_1 = this$MenuLink.href.value) != null) {
        $receiver.href_61zpoe$(tmp$_1);
      }if ((tmp$_2 = this$MenuLink.target.value) != null) {
        $receiver.target_61zpoe$(tmp$_2);
      }$receiver.attr_mzp0ey$('disabled', this$MenuLink.disabled.values);
      this$MenuLink.element.value($receiver);
      this$MenuLink.events.value($receiver);
      this$MenuLink.renderTooltip.value($receiver);
      return Unit;
    };
  }
  MenuLink.prototype.render_wcjbs8$ = function (context, styles) {
    a(context, plus$lambda_1(styles.entry, this.styling_j253gk$_0), void 0, void 0, void 0, void 0, MenuLink$render$lambda$lambda(this, styles));
  };
  Object.defineProperty(MenuLink.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_fdyygm$_0.events;
    }
  });
  Object.defineProperty(MenuLink.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_fdyygm$_1.element;
    }
  });
  Object.defineProperty(MenuLink.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_fdyygm$_2.disabled;
    }
  });
  MenuLink.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_fdyygm$_2.enabled_6taknv$(value);
  };
  MenuLink.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_fdyygm$_2.enabled_433wua$(value);
  };
  Object.defineProperty(MenuLink.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_fdyygm$_3.renderTooltip;
    }
  });
  MenuLink.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_fdyygm$_3.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  MenuLink.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_fdyygm$_3.tooltip_h43rbb$(text, build);
  };
  function MenuLink_init$lambda($receiver) {
    return Unit;
  }
  MenuLink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MenuLink',
    interfaces: [TooltipProperties, FormProperties, ElementProperties, EventProperties, MenuChild]
  };
  function CustomMenuEntry(styling) {
    if (styling === void 0)
      styling = CustomMenuEntry_init$lambda;
    this.styling_s5yslx$_0 = styling;
    this.$delegate_2l43t1$_0 = new TooltipMixin();
    this.content = new ComponentProperty(CustomMenuEntry$content$lambda);
  }
  function CustomMenuEntry$render$lambda$lambda(this$CustomMenuEntry) {
    return function ($receiver) {
      this$CustomMenuEntry.content.value($receiver);
      this$CustomMenuEntry.renderTooltip.value($receiver);
      return Unit;
    };
  }
  CustomMenuEntry.prototype.render_wcjbs8$ = function (context, styles) {
    div(context, plus$lambda_1(styles.custom, this.styling_s5yslx$_0), void 0, void 0, void 0, void 0, CustomMenuEntry$render$lambda$lambda(this));
  };
  Object.defineProperty(CustomMenuEntry.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_2l43t1$_0.renderTooltip;
    }
  });
  CustomMenuEntry.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_2l43t1$_0.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  CustomMenuEntry.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_2l43t1$_0.tooltip_h43rbb$(text, build);
  };
  function CustomMenuEntry_init$lambda($receiver) {
    return Unit;
  }
  function CustomMenuEntry$content$lambda($receiver) {
    return Unit;
  }
  CustomMenuEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CustomMenuEntry',
    interfaces: [TooltipProperties, MenuChild]
  };
  function MenuHeader(styling) {
    if (styling === void 0)
      styling = MenuHeader_init$lambda;
    this.styling_u3tpch$_0 = styling;
    this.text = new ComponentProperty('');
  }
  function MenuHeader$render$lambda$lambda(this$MenuHeader) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$MenuHeader.text.value);
      return Unit;
    };
  }
  MenuHeader.prototype.render_wcjbs8$ = function (context, styles) {
    div(context, plus$lambda_1(styles.header, this.styling_u3tpch$_0), void 0, void 0, void 0, void 0, MenuHeader$render$lambda$lambda(this));
  };
  function MenuHeader_init$lambda($receiver) {
    return Unit;
  }
  MenuHeader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MenuHeader',
    interfaces: [MenuChild]
  };
  function MenuDivider(styling) {
    if (styling === void 0)
      styling = MenuDivider_init$lambda;
    this.styling_de6nzx$_0 = styling;
  }
  function MenuDivider$render$lambda$lambda($receiver) {
    return Unit;
  }
  MenuDivider.prototype.render_wcjbs8$ = function (context, styles) {
    hr(context, plus$lambda_1(styles.divider, this.styling_de6nzx$_0), void 0, void 0, void 0, void 0, MenuDivider$render$lambda$lambda);
  };
  function MenuDivider_init$lambda($receiver) {
    return Unit;
  }
  MenuDivider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MenuDivider',
    interfaces: [MenuChild]
  };
  function modal$lambda($receiver) {
    return Unit;
  }
  function modal(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = modal$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'modal';
    var $receiver = new ModalComponent();
    build($receiver);
    return $receiver.render_n7482o$(styling, baseClass, id, prefix);
  }
  function OverlayMethod(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OverlayMethod_initFields() {
    OverlayMethod_initFields = function () {
    };
    OverlayMethod$CoveringTopMost_instance = new OverlayMethod('CoveringTopMost', 0);
    OverlayMethod$CoveringEach_instance = new OverlayMethod('CoveringEach', 1);
  }
  var OverlayMethod$CoveringTopMost_instance;
  function OverlayMethod$CoveringTopMost_getInstance() {
    OverlayMethod_initFields();
    return OverlayMethod$CoveringTopMost_instance;
  }
  var OverlayMethod$CoveringEach_instance;
  function OverlayMethod$CoveringEach_getInstance() {
    OverlayMethod_initFields();
    return OverlayMethod$CoveringEach_instance;
  }
  OverlayMethod.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OverlayMethod',
    interfaces: [Enum]
  };
  function OverlayMethod$values() {
    return [OverlayMethod$CoveringTopMost_getInstance(), OverlayMethod$CoveringEach_getInstance()];
  }
  OverlayMethod.values = OverlayMethod$values;
  function OverlayMethod$valueOf(name) {
    switch (name) {
      case 'CoveringTopMost':
        return OverlayMethod$CoveringTopMost_getInstance();
      case 'CoveringEach':
        return OverlayMethod$CoveringEach_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.modal.OverlayMethod.' + name);
    }
  }
  OverlayMethod.valueOf_61zpoe$ = OverlayMethod$valueOf;
  function Overlay() {
  }
  Overlay.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Overlay',
    interfaces: []
  };
  function modal_0($receiver, level, offset) {
    if (offset === void 0)
      offset = 0;
    return $receiver.raiseBy_6ic1pp$($receiver.modal, (10 * (level - 1 | 0) | 0) + offset | 0);
  }
  function DefaultOverlay(method, styling) {
    if (method === void 0)
      method = OverlayMethod$CoveringTopMost_getInstance();
    if (styling === void 0)
      styling = Theme.Companion.invoke().modal.overlay;
    this.method_9ekctp$_0 = method;
    this.styling_n8kpig$_0 = styling;
  }
  Object.defineProperty(DefaultOverlay.prototype, 'method', {
    get: function () {
      return this.method_9ekctp$_0;
    }
  });
  Object.defineProperty(DefaultOverlay.prototype, 'styling', {
    get: function () {
      return this.styling_n8kpig$_0;
    }
  });
  function DefaultOverlay$render$lambda$lambda(closure$level) {
    return function ($receiver) {
      return modal_0($receiver, closure$level, -1);
    };
  }
  function DefaultOverlay$render$lambda(closure$level, this$DefaultOverlay) {
    return function ($receiver) {
      $receiver.zIndex_yiflju$(DefaultOverlay$render$lambda$lambda(closure$level));
      $receiver.invoke_qkhqzy$(this$DefaultOverlay.styling);
      return Unit;
    };
  }
  function DefaultOverlay$render$lambda_0($receiver) {
    return Unit;
  }
  DefaultOverlay.prototype.render_6x5jgm$ = function (renderContext, level) {
    div(renderContext, DefaultOverlay$render$lambda(level, this), void 0, void 0, 'modal-overlay', void 0, DefaultOverlay$render$lambda_0);
  };
  DefaultOverlay.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultOverlay',
    interfaces: [Overlay]
  };
  function ModalComponent() {
    ModalComponent$Companion_getInstance();
    this.$delegate_f1zhct$_0 = new CloseButtonMixin('modal-close-button', ModalComponent_init$lambda);
    this.content = new ComponentProperty(null);
    this.size = new ComponentProperty(null);
    this.variant = new ComponentProperty(ModalComponent$variant$lambda);
    this.placement = new ComponentProperty(ModalComponent$placement$lambda);
    this.width = new ComponentProperty(ModalComponent$width$lambda);
  }
  function ModalComponent$ModalsStack() {
    RootStore.call(this, emptyList());
    this.pop = this.handle_7ib3lp$(void 0, ModalComponent$ModalsStack$pop$lambda);
  }
  function Coroutine$ModalComponent$ModalsStack$push$lambda(closure$dialog_0, stack_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$dialog = closure$dialog_0;
    this.local$stack = stack_0;
  }
  Coroutine$ModalComponent$ModalsStack$push$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ModalComponent$ModalsStack$push$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ModalComponent$ModalsStack$push$lambda.prototype.constructor = Coroutine$ModalComponent$ModalsStack$push$lambda;
  Coroutine$ModalComponent$ModalsStack$push$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return plus(this.local$stack, this.local$closure$dialog);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ModalComponent$ModalsStack$push$lambda(closure$dialog_0) {
    return function (stack_0, continuation_0, suspended) {
      var instance = new Coroutine$ModalComponent$ModalsStack$push$lambda(closure$dialog_0, stack_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ModalComponent$ModalsStack.prototype.push_m4fcom$ = function (dialog) {
    return this.handle_7ib3lp$(void 0, ModalComponent$ModalsStack$push$lambda(dialog));
  };
  function Coroutine$ModalComponent$ModalsStack$pop$lambda(stack_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$stack = stack_0;
  }
  Coroutine$ModalComponent$ModalsStack$pop$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ModalComponent$ModalsStack$pop$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ModalComponent$ModalsStack$pop$lambda.prototype.constructor = Coroutine$ModalComponent$ModalsStack$pop$lambda;
  Coroutine$ModalComponent$ModalsStack$pop$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return dropLast(this.local$stack, 1);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ModalComponent$ModalsStack$pop$lambda(stack_0, continuation_0, suspended) {
    var instance = new Coroutine$ModalComponent$ModalsStack$pop$lambda(stack_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ModalComponent$ModalsStack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModalsStack',
    interfaces: [RootStore]
  };
  function ModalComponent$Companion() {
    ModalComponent$Companion_instance = this;
    this.stack_0 = new ModalComponent$ModalsStack();
    this.overlay = storeOf(new DefaultOverlay());
    this.globalId_0 = 'f2c-modals-' + identification.Id.next_za3lpa$();
    this.job_0 = Job();
    this.scope_0 = new Scope();
    this.myStaticStyle_0 = staticStyle_0('disableOverflowForModal', 'overflow:hidden !important;');
    handledBy(this.stack_0.data, ModalComponent$ModalComponent$Companion_init$lambda(this));
  }
  ModalComponent$Companion.prototype.setOverlayHandler_vxklr1$ = function (overlay) {
    ModalComponent$Companion_getInstance().overlay.update.invoke_11rb$(overlay);
  };
  ModalComponent$Companion.prototype.configureBodyScrolling_0 = function (modals) {
    var tmp$;
    var bodyElementClasses = (tmp$ = document.getElementsByTagName('body')[0]) != null ? tmp$.classList : null;
    if (!modals.isEmpty()) {
      bodyElementClasses != null ? (bodyElementClasses.add(this.myStaticStyle_0.name), Unit) : null;
    } else {
      bodyElementClasses != null ? (bodyElementClasses.remove(this.myStaticStyle_0.name), Unit) : null;
    }
  };
  function ModalComponent$ModalComponent$Companion_init$lambda$lambda$lambda$lambda(closure$currentOverlay, closure$index, closure$modal) {
    return function ($receiver) {
      closure$currentOverlay.render_6x5jgm$($receiver, closure$index + 1 | 0);
      closure$modal($receiver, closure$index + 1 | 0);
      return Unit;
    };
  }
  function Coroutine$ModalComponent$ModalComponent$Companion_init$lambda(this$ModalComponent$_0, modals_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ModalComponent$ = this$ModalComponent$_0;
    this.local$modals = modals_0;
  }
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.prototype.constructor = Coroutine$ModalComponent$ModalComponent$Companion_init$lambda;
  Coroutine$ModalComponent$ModalComponent$Companion_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$this$ModalComponent$.configureBodyScrolling_0(this.local$modals);
            var $receiver = ManagedComponent$Companion_getInstance().managedRenderContext_rcagsd$(this.local$this$ModalComponent$.globalId_0, this.local$this$ModalComponent$.job_0, this.local$this$ModalComponent$.scope_0);
            var currentOverlay = this.local$this$ModalComponent$.overlay.current;
            var tmp$ = currentOverlay.method === OverlayMethod$CoveringTopMost_getInstance();
            if (tmp$) {
              tmp$ = !this.local$modals.isEmpty();
            }
            if (tmp$) {
              currentOverlay.render_6x5jgm$($receiver, this.local$modals.size);
            }
            var tmp$_0;
            tmp$_0 = toList(withIndex(this.local$modals)).iterator();
            while (tmp$_0.hasNext()) {
              var element = tmp$_0.next();
              var index = element.component1()
              , modal = element.component2();
              if (currentOverlay.method === OverlayMethod$CoveringEach_getInstance()) {
                $receiver.div_iz87dk$(void 0, void 0, void 0, ModalComponent$ModalComponent$Companion_init$lambda$lambda$lambda$lambda(currentOverlay, index, modal));
              } else
                modal($receiver, index + 1 | 0);
            }

            return $receiver;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ModalComponent$ModalComponent$Companion_init$lambda(this$ModalComponent$_0) {
    return function (modals_0, continuation_0, suspended) {
      var instance = new Coroutine$ModalComponent$ModalComponent$Companion_init$lambda(this$ModalComponent$_0, modals_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ModalComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ModalComponent$Companion_instance = null;
  function ModalComponent$Companion_getInstance() {
    if (ModalComponent$Companion_instance === null) {
      new ModalComponent$Companion();
    }return ModalComponent$Companion_instance;
  }
  function ModalComponent$Placement(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ModalComponent$Placement_initFields() {
    ModalComponent$Placement_initFields = function () {
    };
    ModalComponent$Placement$TOP_instance = new ModalComponent$Placement('TOP', 0);
    ModalComponent$Placement$CENTER_instance = new ModalComponent$Placement('CENTER', 1);
    ModalComponent$Placement$BOTTOM_instance = new ModalComponent$Placement('BOTTOM', 2);
    ModalComponent$Placement$STRETCH_instance = new ModalComponent$Placement('STRETCH', 3);
  }
  var ModalComponent$Placement$TOP_instance;
  function ModalComponent$Placement$TOP_getInstance() {
    ModalComponent$Placement_initFields();
    return ModalComponent$Placement$TOP_instance;
  }
  var ModalComponent$Placement$CENTER_instance;
  function ModalComponent$Placement$CENTER_getInstance() {
    ModalComponent$Placement_initFields();
    return ModalComponent$Placement$CENTER_instance;
  }
  var ModalComponent$Placement$BOTTOM_instance;
  function ModalComponent$Placement$BOTTOM_getInstance() {
    ModalComponent$Placement_initFields();
    return ModalComponent$Placement$BOTTOM_instance;
  }
  var ModalComponent$Placement$STRETCH_instance;
  function ModalComponent$Placement$STRETCH_getInstance() {
    ModalComponent$Placement_initFields();
    return ModalComponent$Placement$STRETCH_instance;
  }
  ModalComponent$Placement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Placement',
    interfaces: [Enum]
  };
  function ModalComponent$Placement$values() {
    return [ModalComponent$Placement$TOP_getInstance(), ModalComponent$Placement$CENTER_getInstance(), ModalComponent$Placement$BOTTOM_getInstance(), ModalComponent$Placement$STRETCH_getInstance()];
  }
  ModalComponent$Placement.values = ModalComponent$Placement$values;
  function ModalComponent$Placement$valueOf(name) {
    switch (name) {
      case 'TOP':
        return ModalComponent$Placement$TOP_getInstance();
      case 'CENTER':
        return ModalComponent$Placement$CENTER_getInstance();
      case 'BOTTOM':
        return ModalComponent$Placement$BOTTOM_getInstance();
      case 'STRETCH':
        return ModalComponent$Placement$STRETCH_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.modal.ModalComponent.Placement.' + name);
    }
  }
  ModalComponent$Placement.valueOf_61zpoe$ = ModalComponent$Placement$valueOf;
  function ModalComponent$PlacementContext() {
    ModalComponent$PlacementContext_instance = this;
    this.top = ModalComponent$Placement$TOP_getInstance();
    this.center = ModalComponent$Placement$CENTER_getInstance();
    this.bottom = ModalComponent$Placement$BOTTOM_getInstance();
    this.stretch = ModalComponent$Placement$STRETCH_getInstance();
  }
  ModalComponent$PlacementContext.prototype.flexValueOf_f7jv22$ = function (placement) {
    switch (placement.name) {
      case 'TOP':
        return 'flex-start';
      case 'CENTER':
        return 'center';
      case 'BOTTOM':
        return 'flex-end';
      case 'STRETCH':
        return 'stretch';
      default:return Kotlin.noWhenBranchMatched();
    }
  };
  ModalComponent$PlacementContext.prototype.externalScrollingPossible_f7jv22$ = function (placement) {
    return placement === ModalComponent$Placement$TOP_getInstance();
  };
  ModalComponent$PlacementContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'PlacementContext',
    interfaces: []
  };
  var ModalComponent$PlacementContext_instance = null;
  function ModalComponent$PlacementContext_getInstance() {
    if (ModalComponent$PlacementContext_instance === null) {
      new ModalComponent$PlacementContext();
    }return ModalComponent$PlacementContext_instance;
  }
  function ModalComponent$WidthContext() {
    ModalComponent$WidthContext_instance = this;
    this.small = 'small';
    this.normal = 'normal';
    this.large = 'large';
    this.full = 'full';
  }
  ModalComponent$WidthContext.prototype.asCssWidthExpression_61zpoe$ = function (value) {
    switch (value) {
      case 'small':
        return Theme.Companion.invoke().modal.widths.small;
      case 'normal':
        return Theme.Companion.invoke().modal.widths.normal;
      case 'large':
        return Theme.Companion.invoke().modal.widths.large;
      case 'full':
        return Theme.Companion.invoke().modal.widths.full;
      default:return value;
    }
  };
  ModalComponent$WidthContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'WidthContext',
    interfaces: []
  };
  var ModalComponent$WidthContext_instance = null;
  function ModalComponent$WidthContext_getInstance() {
    if (ModalComponent$WidthContext_instance === null) {
      new ModalComponent$WidthContext();
    }return ModalComponent$WidthContext_instance;
  }
  function ModalComponent$render$lambda$lambda$lambda(closure$level) {
    return function ($receiver) {
      return modal_0($receiver, closure$level);
    };
  }
  function ModalComponent$render$lambda$lambda$lambda$lambda$lambda($receiver) {
    return '0px';
  }
  function ModalComponent$render$lambda$lambda$lambda$lambda$lambda_0($receiver) {
    return '0px';
  }
  function ModalComponent$render$lambda$lambda$lambda$lambda($receiver) {
    $receiver.left_bcpvvc$(ModalComponent$render$lambda$lambda$lambda$lambda$lambda);
    $receiver.top_bcpvvc$(ModalComponent$render$lambda$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function ModalComponent$render$lambda$lambda$lambda_0($receiver) {
    $receiver.fixed_dkjn9d$(ModalComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function ModalComponent$render$lambda$lambda$lambda_1($receiver) {
    return '100vw';
  }
  function ModalComponent$render$lambda$lambda$lambda_2($receiver) {
    return '100vh';
  }
  function ModalComponent$render$lambda$lambda$lambda_3($receiver) {
    return $receiver.auto;
  }
  function ModalComponent$render$lambda$lambda$lambda_4($receiver) {
    return $receiver.center;
  }
  function ModalComponent$render$lambda$lambda$lambda_5(this$ModalComponent) {
    return function ($receiver) {
      return ModalComponent$PlacementContext_getInstance().flexValueOf_f7jv22$(this$ModalComponent.placement.value(ModalComponent$PlacementContext_getInstance()));
    };
  }
  function ModalComponent$render$lambda$lambda(closure$level, this$ModalComponent) {
    return function ($receiver) {
      $receiver.zIndex_yiflju$(ModalComponent$render$lambda$lambda$lambda(closure$level));
      $receiver.position_wp9r2r$(ModalComponent$render$lambda$lambda$lambda_0);
      $receiver.width_wpghq5$(ModalComponent$render$lambda$lambda$lambda_1);
      $receiver.height_wpghq5$(ModalComponent$render$lambda$lambda$lambda_2);
      if (ModalComponent$PlacementContext_getInstance().externalScrollingPossible_f7jv22$(this$ModalComponent.placement.value(ModalComponent$PlacementContext_getInstance()))) {
        $receiver.overflow_c5t1z2$(ModalComponent$render$lambda$lambda$lambda_3);
      }$receiver.justifyContent_vlnw1j$(ModalComponent$render$lambda$lambda$lambda_4);
      $receiver.alignItems_tsd917$(ModalComponent$render$lambda$lambda$lambda_5(this$ModalComponent));
      return Unit;
    };
  }
  function ModalComponent$render$lambda$lambda$lambda$lambda_0(closure$level) {
    return function ($receiver) {
      return modal_0($receiver, closure$level, 1);
    };
  }
  function ModalComponent$render$lambda$lambda$lambda$lambda$lambda_1($receiver) {
    return Unit;
  }
  function ModalComponent$render$lambda$lambda$lambda$lambda_1($receiver) {
    $receiver.relative_dkjn9d$(ModalComponent$render$lambda$lambda$lambda$lambda$lambda_1);
    return Unit;
  }
  function ModalComponent$render$lambda$lambda$lambda_6(closure$level, this$ModalComponent, closure$styling) {
    return function ($receiver) {
      $receiver.css_61zpoe$('--modal-level: ' + closure$level + 'rem;');
      $receiver.zIndex_yiflju$(ModalComponent$render$lambda$lambda$lambda$lambda_0(closure$level));
      $receiver.position_wp9r2r$(ModalComponent$render$lambda$lambda$lambda$lambda_1);
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().modal.base);
      if (this$ModalComponent.size.value != null) {
        $receiver.invoke_qkhqzy$(ensureNotNull(this$ModalComponent.size.value)(Theme.Companion.invoke().modal.sizes));
      } else {
        Theme.Companion.invoke().modal.width($receiver, this$ModalComponent.width.value(ModalComponent$WidthContext_getInstance()), ModalComponent$WidthContext_getInstance().asCssWidthExpression_61zpoe$(this$ModalComponent.width.value(ModalComponent$WidthContext_getInstance())));
      }
      if (!ModalComponent$PlacementContext_getInstance().externalScrollingPossible_f7jv22$(this$ModalComponent.placement.value(ModalComponent$PlacementContext_getInstance()))) {
        $receiver.invoke_qkhqzy$(Theme.Companion.invoke().modal.internalScrolling);
      }closure$styling($receiver);
      return Unit;
    };
  }
  function ModalComponent$render$lambda$lambda$lambda_7(this$ModalComponent, closure$close) {
    return function ($receiver) {
      var tmp$;
      if (this$ModalComponent.hasCloseButton.value) {
        $receiver.handledBy_jora5j$(this$ModalComponent.closeButtonRendering.value($receiver), closure$close);
      }if ((tmp$ = this$ModalComponent.content.value) != null) {
        tmp$($receiver, closure$close);
      }return Unit;
    };
  }
  function ModalComponent$render$lambda$lambda_0(closure$level, this$ModalComponent, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$close) {
    return function ($receiver) {
      div($receiver, ModalComponent$render$lambda$lambda$lambda_6(closure$level, this$ModalComponent, closure$styling), closure$baseClass, closure$id, closure$prefix, void 0, ModalComponent$render$lambda$lambda$lambda_7(this$ModalComponent, closure$close));
      return Unit;
    };
  }
  function ModalComponent$render$lambda(this$ModalComponent, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$close) {
    return function ($receiver, level) {
      return flexBox($receiver, ModalComponent$render$lambda$lambda(level, this$ModalComponent), void 0, void 0, void 0, void 0, ModalComponent$render$lambda$lambda_0(level, this$ModalComponent, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$close));
    };
  }
  ModalComponent.prototype.render_n7482o$ = function (styling, baseClass, id, prefix) {
    var close = ModalComponent$Companion_getInstance().stack_0.pop;
    var modal = ModalComponent$render$lambda(this, styling, baseClass, id, prefix, close);
    return ModalComponent$Companion_getInstance().stack_0.push_m4fcom$(modal);
  };
  Object.defineProperty(ModalComponent.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_f1zhct$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_f1zhct$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_f1zhct$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_f1zhct$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(ModalComponent.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_f1zhct$_0.hasCloseButton;
    }
  });
  function ModalComponent_init$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.smaller;
  }
  function ModalComponent_init$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.smaller;
  }
  function ModalComponent_init$lambda$lambda$lambda($receiver) {
    $receiver.right_bcpvvc$(ModalComponent_init$lambda$lambda$lambda$lambda);
    $receiver.top_bcpvvc$(ModalComponent_init$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function ModalComponent_init$lambda$lambda($receiver) {
    $receiver.absolute_dkjn9d$(ModalComponent_init$lambda$lambda$lambda);
    return Unit;
  }
  function ModalComponent_init$lambda($receiver) {
    $receiver.position_wp9r2r$(ModalComponent_init$lambda$lambda);
    return Unit;
  }
  function ModalComponent$variant$lambda($receiver) {
    return Theme.Companion.invoke().modal.variants.auto;
  }
  function ModalComponent$placement$lambda($receiver) {
    return ModalComponent$Placement$TOP_getInstance();
  }
  function ModalComponent$width$lambda($receiver) {
    return $receiver.normal;
  }
  ModalComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModalComponent',
    interfaces: [CloseButtonProperty, ManagedComponent]
  };
  function NavbarComponent() {
    NavbarComponent$Companion_getInstance();
    this.brand = new ComponentProperty(NavbarComponent$brand$lambda);
    this.actions = new ComponentProperty(NavbarComponent$actions$lambda);
  }
  function NavbarComponent$Companion() {
    NavbarComponent$Companion_instance = this;
    this.staticHeaderCss = staticStyle_0('navbar-header', '\n                transition: box-shadow 0.2s;\n                position: fixed;\n                top: 0;\n                left: 0;\n                right: 0;\n                width: 100%;\n            ');
    this.staticContentCss = staticStyle_0('navbar-content', '\n                display: flex;\n                align-items: center;\n                justify-content: space-between;\n                width: 100%;\n            ');
    this.staticBrandCss = staticStyle_0('navbar-brand', '\n                display: flex;\n                align-items: center;\n            ');
    this.staticActionsCss = staticStyle_0('navbar-actions', '\n                display: flex;\n                align-items: center;\n            ');
  }
  NavbarComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var NavbarComponent$Companion_instance = null;
  function NavbarComponent$Companion_getInstance() {
    if (NavbarComponent$Companion_instance === null) {
      new NavbarComponent$Companion();
    }return NavbarComponent$Companion_instance;
  }
  function NavbarComponent$render$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().navBar.header);
    return Unit;
  }
  function NavbarComponent$render$lambda$lambda$lambda(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().navBar.content);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda(this$NavbarComponent) {
    return function ($receiver) {
      this$NavbarComponent.brand.value($receiver);
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda$lambda$lambda_0(this$NavbarComponent) {
    return function ($receiver) {
      this$NavbarComponent.actions.value($receiver);
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda$lambda_0(this$NavbarComponent) {
    return function ($receiver) {
      $receiver.div_iz87dk$(NavbarComponent$Companion_getInstance().staticBrandCss.name, void 0, void 0, NavbarComponent$render$lambda$lambda$lambda$lambda(this$NavbarComponent));
      $receiver.div_iz87dk$(NavbarComponent$Companion_getInstance().staticActionsCss.name, void 0, void 0, NavbarComponent$render$lambda$lambda$lambda$lambda_0(this$NavbarComponent));
      return Unit;
    };
  }
  function NavbarComponent$render$lambda$lambda_0(closure$styling, closure$prefix, this$NavbarComponent) {
    return function ($receiver) {
      div($receiver, NavbarComponent$render$lambda$lambda$lambda(closure$styling), NavbarComponent$Companion_getInstance().staticContentCss, closure$prefix, void 0, void 0, NavbarComponent$render$lambda$lambda$lambda_0(this$NavbarComponent));
      return Unit;
    };
  }
  NavbarComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    nav(context, NavbarComponent$render$lambda$lambda, NavbarComponent$Companion_getInstance().staticHeaderCss.plus_fox8kt$(baseClass), id, void 0, void 0, NavbarComponent$render$lambda$lambda_0(styling, prefix, this));
    return Unit;
  };
  function NavbarComponent$brand$lambda($receiver) {
    return Unit;
  }
  function NavbarComponent$actions$lambda($receiver) {
    return Unit;
  }
  NavbarComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NavbarComponent',
    interfaces: [Component]
  };
  function navBar$lambda($receiver) {
    return Unit;
  }
  function navBar$lambda_0($receiver) {
    return Unit;
  }
  function navBar($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = navBar$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'navbar';
    if (build === void 0)
      build = navBar$lambda_0;
    var $receiver_0 = new NavbarComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function paper$lambda($receiver) {
    return Unit;
  }
  function paper($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = paper$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'paper';
    var $receiver_0 = new PaperComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function PaperComponent() {
    this.size = new ComponentProperty(PaperComponent$size$lambda);
    this.type = new ComponentProperty(PaperComponent$type$lambda);
    this.content = null;
  }
  function PaperComponent$Sizes(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PaperComponent$Sizes_initFields() {
    PaperComponent$Sizes_initFields = function () {
    };
    PaperComponent$Sizes$SMALL_instance = new PaperComponent$Sizes('SMALL', 0);
    PaperComponent$Sizes$NORMAL_instance = new PaperComponent$Sizes('NORMAL', 1);
    PaperComponent$Sizes$LARGE_instance = new PaperComponent$Sizes('LARGE', 2);
  }
  var PaperComponent$Sizes$SMALL_instance;
  function PaperComponent$Sizes$SMALL_getInstance() {
    PaperComponent$Sizes_initFields();
    return PaperComponent$Sizes$SMALL_instance;
  }
  var PaperComponent$Sizes$NORMAL_instance;
  function PaperComponent$Sizes$NORMAL_getInstance() {
    PaperComponent$Sizes_initFields();
    return PaperComponent$Sizes$NORMAL_instance;
  }
  var PaperComponent$Sizes$LARGE_instance;
  function PaperComponent$Sizes$LARGE_getInstance() {
    PaperComponent$Sizes_initFields();
    return PaperComponent$Sizes$LARGE_instance;
  }
  PaperComponent$Sizes.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sizes',
    interfaces: [Enum]
  };
  function PaperComponent$Sizes$values() {
    return [PaperComponent$Sizes$SMALL_getInstance(), PaperComponent$Sizes$NORMAL_getInstance(), PaperComponent$Sizes$LARGE_getInstance()];
  }
  PaperComponent$Sizes.values = PaperComponent$Sizes$values;
  function PaperComponent$Sizes$valueOf(name) {
    switch (name) {
      case 'SMALL':
        return PaperComponent$Sizes$SMALL_getInstance();
      case 'NORMAL':
        return PaperComponent$Sizes$NORMAL_getInstance();
      case 'LARGE':
        return PaperComponent$Sizes$LARGE_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.paper.PaperComponent.Sizes.' + name);
    }
  }
  PaperComponent$Sizes.valueOf_61zpoe$ = PaperComponent$Sizes$valueOf;
  function PaperComponent$SizesContext() {
    PaperComponent$SizesContext_instance = this;
    this.small = PaperComponent$Sizes$SMALL_getInstance();
    this.normal = PaperComponent$Sizes$NORMAL_getInstance();
    this.large = PaperComponent$Sizes$LARGE_getInstance();
  }
  PaperComponent$SizesContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SizesContext',
    interfaces: []
  };
  var PaperComponent$SizesContext_instance = null;
  function PaperComponent$SizesContext_getInstance() {
    if (PaperComponent$SizesContext_instance === null) {
      new PaperComponent$SizesContext();
    }return PaperComponent$SizesContext_instance;
  }
  function PaperComponent$Types(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PaperComponent$Types_initFields() {
    PaperComponent$Types_initFields = function () {
    };
    PaperComponent$Types$NORMAL_instance = new PaperComponent$Types('NORMAL', 0);
    PaperComponent$Types$OUTLINE_instance = new PaperComponent$Types('OUTLINE', 1);
    PaperComponent$Types$GHOST_instance = new PaperComponent$Types('GHOST', 2);
  }
  var PaperComponent$Types$NORMAL_instance;
  function PaperComponent$Types$NORMAL_getInstance() {
    PaperComponent$Types_initFields();
    return PaperComponent$Types$NORMAL_instance;
  }
  var PaperComponent$Types$OUTLINE_instance;
  function PaperComponent$Types$OUTLINE_getInstance() {
    PaperComponent$Types_initFields();
    return PaperComponent$Types$OUTLINE_instance;
  }
  var PaperComponent$Types$GHOST_instance;
  function PaperComponent$Types$GHOST_getInstance() {
    PaperComponent$Types_initFields();
    return PaperComponent$Types$GHOST_instance;
  }
  PaperComponent$Types.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Types',
    interfaces: [Enum]
  };
  function PaperComponent$Types$values() {
    return [PaperComponent$Types$NORMAL_getInstance(), PaperComponent$Types$OUTLINE_getInstance(), PaperComponent$Types$GHOST_getInstance()];
  }
  PaperComponent$Types.values = PaperComponent$Types$values;
  function PaperComponent$Types$valueOf(name) {
    switch (name) {
      case 'NORMAL':
        return PaperComponent$Types$NORMAL_getInstance();
      case 'OUTLINE':
        return PaperComponent$Types$OUTLINE_getInstance();
      case 'GHOST':
        return PaperComponent$Types$GHOST_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.paper.PaperComponent.Types.' + name);
    }
  }
  PaperComponent$Types.valueOf_61zpoe$ = PaperComponent$Types$valueOf;
  function PaperComponent$TypesContext() {
    PaperComponent$TypesContext_instance = this;
    this.normal = PaperComponent$Types$NORMAL_getInstance();
    this.outline = PaperComponent$Types$OUTLINE_getInstance();
    this.ghost = PaperComponent$Types$GHOST_getInstance();
  }
  PaperComponent$TypesContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TypesContext',
    interfaces: []
  };
  var PaperComponent$TypesContext_instance = null;
  function PaperComponent$TypesContext_getInstance() {
    if (PaperComponent$TypesContext_instance === null) {
      new PaperComponent$TypesContext();
    }return PaperComponent$TypesContext_instance;
  }
  function PaperComponent$PaperContent(styling, value) {
    this.styling = styling;
    this.value = value;
  }
  PaperComponent$PaperContent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PaperContent',
    interfaces: []
  };
  PaperComponent$PaperContent.prototype.component1 = function () {
    return this.styling;
  };
  PaperComponent$PaperContent.prototype.component2 = function () {
    return this.value;
  };
  PaperComponent$PaperContent.prototype.copy_hn5ufr$ = function (styling, value) {
    return new PaperComponent$PaperContent(styling === void 0 ? this.styling : styling, value === void 0 ? this.value : value);
  };
  PaperComponent$PaperContent.prototype.toString = function () {
    return 'PaperContent(styling=' + Kotlin.toString(this.styling) + (', value=' + Kotlin.toString(this.value)) + ')';
  };
  PaperComponent$PaperContent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.styling) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  PaperComponent$PaperContent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.styling, other.styling) && Kotlin.equals(this.value, other.value)))));
  };
  function PaperComponent$content$lambda($receiver) {
    return Unit;
  }
  PaperComponent.prototype.content_hn5ufr$ = function (styling, value) {
    if (styling === void 0)
      styling = PaperComponent$content$lambda;
    this.content = new PaperComponent$PaperContent(styling, value);
  };
  function PaperComponent$render$lambda$lambda(this$PaperComponent, closure$styling) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      switch (this$PaperComponent.size.value(PaperComponent$SizesContext_getInstance()).name) {
        case 'SMALL':
          tmp$ = Theme.Companion.invoke().paper.sizes.small;
          break;
        case 'NORMAL':
          tmp$ = Theme.Companion.invoke().paper.sizes.normal;
          break;
        case 'LARGE':
          tmp$ = Theme.Companion.invoke().paper.sizes.large;
          break;
        default:tmp$ = Kotlin.noWhenBranchMatched();
          break;
      }
      $receiver.invoke_4my6up$(tmp$);
      switch (this$PaperComponent.type.value(PaperComponent$TypesContext_getInstance()).name) {
        case 'NORMAL':
          tmp$_0 = Theme.Companion.invoke().paper.types.normal;
          break;
        case 'OUTLINE':
          tmp$_0 = Theme.Companion.invoke().paper.types.outline;
          break;
        case 'GHOST':
          tmp$_0 = Theme.Companion.invoke().paper.types.ghost;
          break;
        default:tmp$_0 = Kotlin.noWhenBranchMatched();
          break;
      }
      $receiver.invoke_4my6up$(tmp$_0);
      $receiver.invoke_4my6up$(Theme.Companion.invoke().paper.background);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function PaperComponent$render$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      closure$it.value($receiver);
      return Unit;
    };
  }
  function PaperComponent$render$lambda$lambda_0(this$PaperComponent) {
    return function ($receiver) {
      var tmp$;
      if ((tmp$ = this$PaperComponent.content) != null) {
        div($receiver, tmp$.styling, void 0, void 0, void 0, void 0, PaperComponent$render$lambda$lambda$lambda$lambda(tmp$));
      }return Unit;
    };
  }
  PaperComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    div(context, PaperComponent$render$lambda$lambda(this, styling), baseClass, id, prefix, void 0, PaperComponent$render$lambda$lambda_0(this));
    return Unit;
  };
  function PaperComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function PaperComponent$type$lambda($receiver) {
    return $receiver.normal;
  }
  PaperComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PaperComponent',
    interfaces: [Component]
  };
  function unsafeFlow$ObjectLiteral_8(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_8($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_8.prototype.constructor = Coroutine$collect_42ocv1$_8;
  Coroutine$collect_42ocv1$_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_8.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_8(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_8.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_7(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_7.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_7;
  Coroutine$unsafeTransform$lambda$lambda_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_7(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_7(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_7(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_7.prototype.constructor = Coroutine$unsafeTransform$lambda_7;
  Coroutine$unsafeTransform$lambda_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_7(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_7(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_7(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$filter$lambda(closure$predicate_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$predicate = closure$predicate_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$filter$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$filter$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$filter$lambda.prototype.constructor = Coroutine$filter$lambda;
  Coroutine$filter$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$predicate(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.result_0) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(this.local$value, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            return Unit;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function filter$lambda(closure$predicate_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$filter$lambda(closure$predicate_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_9(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_9($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_9.prototype.constructor = Coroutine$collect_42ocv1$_9;
  Coroutine$collect_42ocv1$_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_9.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_9(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_9.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_8(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_8.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_8;
  Coroutine$unsafeTransform$lambda$lambda_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_8(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_8(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_8(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_8.prototype.constructor = Coroutine$unsafeTransform$lambda_8;
  Coroutine$unsafeTransform$lambda_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_8(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_8(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_8(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_6(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_6.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_6.prototype.constructor = Coroutine$map$lambda_6;
  Coroutine$map$lambda_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_6(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_6(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function PopoverComponent() {
    PopoverComponent$Companion_getInstance();
    this.$delegate_677i8a$_0 = new CloseButtonMixin('popover-close-button', Theme.Companion.invoke().popover.closeButton);
    this.size = new ComponentProperty(PopoverComponent$size$lambda);
    this.placementStyle_nwfc3a$_0 = PopoverComponent$placementStyle$lambda;
    this.closeOnBlur = new ComponentProperty(true);
    this.closeOnEscape = new ComponentProperty(true);
    this.hasArrow = new ComponentProperty(true);
    this.arrowPlacement = new ComponentProperty(PopoverComponent$arrowPlacement$lambda);
    this.toggle = new ComponentProperty(null);
    this.header_huufl5$_0 = null;
    this.footer_6jikth$_0 = null;
    this.content_5mgsl7$_0 = null;
    this.visible_tygl0s$_0 = new PopoverComponent$visible$ObjectLiteral(false);
  }
  function PopoverComponent$Companion() {
    PopoverComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('popover', '\n              display: inline-block;\n              position: relative;\n            ');
  }
  PopoverComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PopoverComponent$Companion_instance = null;
  function PopoverComponent$Companion_getInstance() {
    if (PopoverComponent$Companion_instance === null) {
      new PopoverComponent$Companion();
    }return PopoverComponent$Companion_instance;
  }
  function PopoverComponent$placement$lambda($receiver) {
    return $receiver.bottom;
  }
  function PopoverComponent$placement$lambda_0($receiver) {
    return $receiver.left;
  }
  function PopoverComponent$placement$lambda_1($receiver) {
    return $receiver.top;
  }
  function PopoverComponent$placement$lambda_2($receiver) {
    return $receiver.right;
  }
  PopoverComponent.prototype.placement_aes0rj$ = function (value) {
    var tmp$;
    tmp$ = value(Theme.Companion.invoke().popover.placement);
    if (equals(tmp$, Theme.Companion.invoke().popover.placement.top))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda);
    else if (equals(tmp$, Theme.Companion.invoke().popover.placement.right))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda_0);
    else if (equals(tmp$, Theme.Companion.invoke().popover.placement.bottom))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda_1);
    else if (equals(tmp$, Theme.Companion.invoke().popover.placement.left))
      this.arrowPlacement.invoke_11rb$(PopoverComponent$placement$lambda_2);
    this.placementStyle_nwfc3a$_0 = value;
  };
  function PopoverComponent$header$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.header);
    return Unit;
  }
  function PopoverComponent$header$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      closure$value($receiver);
      return Unit;
    };
  }
  function PopoverComponent$header$lambda(closure$value) {
    return function ($receiver) {
      header($receiver, PopoverComponent$header$lambda$lambda, void 0, void 0, 'popover-header', void 0, PopoverComponent$header$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.header_9c978p$ = function (value) {
    this.header_huufl5$_0 = PopoverComponent$header$lambda(value);
  };
  PopoverComponent.prototype.header_61zpoe$ = function (value) {
    this.header_p81yox$(flowOf(value));
  };
  function PopoverComponent$header$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.header);
    return Unit;
  }
  function PopoverComponent$header$lambda$lambda_2(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function PopoverComponent$header$lambda_0(closure$value) {
    return function ($receiver) {
      header($receiver, PopoverComponent$header$lambda$lambda_1, void 0, void 0, 'popover-header', void 0, PopoverComponent$header$lambda$lambda_2(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.header_p81yox$ = function (value) {
    this.header_huufl5$_0 = PopoverComponent$header$lambda_0(value);
  };
  function PopoverComponent$footer$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.footer);
    return Unit;
  }
  function PopoverComponent$footer$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      closure$value($receiver);
      return Unit;
    };
  }
  function PopoverComponent$footer$lambda(closure$value) {
    return function ($receiver) {
      footer($receiver, PopoverComponent$footer$lambda$lambda, void 0, void 0, 'popover-footer', void 0, PopoverComponent$footer$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.footer_9c978p$ = function (value) {
    this.footer_6jikth$_0 = PopoverComponent$footer$lambda(value);
  };
  PopoverComponent.prototype.footer_61zpoe$ = function (value) {
    this.footer_p81yox$(flowOf(value));
  };
  function PopoverComponent$footer$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.footer);
    return Unit;
  }
  function PopoverComponent$footer$lambda$lambda_2(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function PopoverComponent$footer$lambda_0(closure$value) {
    return function ($receiver) {
      footer($receiver, PopoverComponent$footer$lambda$lambda_1, void 0, void 0, 'popover-footer', void 0, PopoverComponent$footer$lambda$lambda_2(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.footer_p81yox$ = function (value) {
    this.footer_6jikth$_0 = PopoverComponent$footer$lambda_0(value);
  };
  function PopoverComponent$content$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.section);
    return Unit;
  }
  function PopoverComponent$content$lambda$lambda_0(closure$value) {
    return function ($receiver) {
      closure$value($receiver);
      return Unit;
    };
  }
  function PopoverComponent$content$lambda(closure$value) {
    return function ($receiver) {
      section($receiver, PopoverComponent$content$lambda$lambda, void 0, void 0, 'popover-content', void 0, PopoverComponent$content$lambda$lambda_0(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.content_9c978p$ = function (value) {
    this.content_5mgsl7$_0 = PopoverComponent$content$lambda(value);
  };
  PopoverComponent.prototype.content_61zpoe$ = function (value) {
    this.content_p81yox$(flowOf(value));
  };
  function PopoverComponent$content$lambda$lambda_1($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.section);
    return Unit;
  }
  function PopoverComponent$content$lambda$lambda_2(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  function PopoverComponent$content$lambda_0(closure$value) {
    return function ($receiver) {
      section($receiver, PopoverComponent$content$lambda$lambda_1, void 0, void 0, 'popover-content', void 0, PopoverComponent$content$lambda$lambda_2(closure$value));
      return Unit;
    };
  }
  PopoverComponent.prototype.content_p81yox$ = function (value) {
    this.content_5mgsl7$_0 = PopoverComponent$content$lambda_0(value);
  };
  function Coroutine$PopoverComponent$render$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$PopoverComponent$render$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$lambda$lambda.prototype.constructor = Coroutine$PopoverComponent$render$lambda$lambda;
  Coroutine$PopoverComponent$render$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return (tmp$ = shortcutOf(this.local$it)) != null ? tmp$.equals(html.Keys.Escape) : null;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$render$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$PopoverComponent$render$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$PopoverComponent$render$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$lambda$lambda_0.prototype.constructor = Coroutine$PopoverComponent$render$lambda$lambda_0;
  Coroutine$PopoverComponent$render$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$render$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function PopoverComponent$render$lambda$lambda$lambda($receiver) {
    $receiver.invoke_qkhqzy$(Theme.Companion.invoke().popover.toggle);
    return Unit;
  }
  function PopoverComponent$render$lambda$lambda$lambda_0(this$PopoverComponent) {
    return function ($receiver) {
      var tmp$;
      (tmp$ = this$PopoverComponent.toggle.value) != null ? tmp$($receiver) : null;
      $receiver.handledBy_jora5j$($receiver.clicks, this$PopoverComponent.visible_tygl0s$_0.toggle);
      return Unit;
    };
  }
  function PopoverComponent$render$lambda$lambda$lambda_1(this$PopoverComponent, closure$styling, closure$baseClass, closure$prefix, closure$popoverElement) {
    return function ($receiver, it) {
      if (it) {
        closure$popoverElement.v = this$PopoverComponent.renderPopover_ltf9a6$_0($receiver, closure$styling, closure$baseClass, closure$prefix);
      }return Unit;
    };
  }
  function Coroutine$PopoverComponent$render$lambda$lambda$lambda(closure$popoverElement_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$popoverElement = closure$popoverElement_0;
    this.local$it = it_0;
  }
  Coroutine$PopoverComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$PopoverComponent$render$lambda$lambda$lambda;
  Coroutine$PopoverComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$it)
              return (this.local$closure$popoverElement.v == null ? throwUPAE('popoverElement') : this.local$closure$popoverElement.v).focus(), Unit;
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$render$lambda$lambda$lambda_2(closure$popoverElement_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$PopoverComponent$render$lambda$lambda$lambda(closure$popoverElement_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function PopoverComponent$render$lambda$lambda_1(this$PopoverComponent, closure$styling, closure$baseClass, closure$prefix) {
    return function ($receiver) {
      div($receiver, PopoverComponent$render$lambda$lambda$lambda, void 0, void 0, 'popover-toggle', void 0, PopoverComponent$render$lambda$lambda$lambda_0(this$PopoverComponent));
      var popoverElement = {v: null};
      $receiver.render_a5p5o5$(this$PopoverComponent.visible_tygl0s$_0.data, void 0, PopoverComponent$render$lambda$lambda$lambda_1(this$PopoverComponent, closure$styling, closure$baseClass, closure$prefix, popoverElement));
      $receiver.handledBy_706ovd$(this$PopoverComponent.visible_tygl0s$_0.data, PopoverComponent$render$lambda$lambda$lambda_2(popoverElement));
      return Unit;
    };
  }
  PopoverComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    if (this.closeOnEscape.value) {
      var $receiver = dom.Window.keyups.events;
      var $receiver_0 = new unsafeFlow$ObjectLiteral_8(unsafeTransform$lambda_7(filter$lambda(PopoverComponent$render$lambda$lambda), $receiver));
      context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_9(unsafeTransform$lambda_8(map$lambda_6(PopoverComponent$render$lambda$lambda_0), $receiver_0)), this.visible_tygl0s$_0.closeOnKey);
    }context.div_iz87dk$(PopoverComponent$Companion_getInstance().staticCss.name, id, void 0, PopoverComponent$render$lambda$lambda_1(this, styling, baseClass, prefix));
    return Unit;
  };
  function PopoverComponent$renderPopover$lambda($receiver) {
    return Unit;
  }
  function PopoverComponent$renderPopover$lambda$lambda$lambda($receiver) {
    $receiver.css_61zpoe$('outline:none');
    return Unit;
  }
  function PopoverComponent$renderPopover$lambda$lambda(this$PopoverComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$PopoverComponent.placementStyle_nwfc3a$_0(Theme.Companion.invoke().popover.placement));
      $receiver.invoke_qkhqzy$(this$PopoverComponent.size.value(Theme.Companion.invoke().popover.size));
      $receiver.focus_xighi7$(PopoverComponent$renderPopover$lambda$lambda$lambda);
      return Unit;
    };
  }
  function PopoverComponent$renderPopover$lambda$lambda$lambda_0(this$PopoverComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$PopoverComponent.arrowPlacement.value(Theme.Companion.invoke().popover.arrowPlacement));
      return Unit;
    };
  }
  function PopoverComponent$renderPopover$lambda$lambda$lambda_1($receiver) {
    return Unit;
  }
  function Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda(focusEvent_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$focusEvent = focusEvent_0;
  }
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.prototype.constructor = Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda;
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0, tmp$_1, tmp$_2;
            var tmp$_3;
            if ((tmp$ = this.local$focusEvent.currentTarget) != null) {
              var tmp$_4;
              tmp$_3 = Kotlin.isType(tmp$_4 = tmp$, HTMLElement) ? tmp$_4 : null;
            } else
              tmp$_3 = null;
            tmp$_0 = tmp$_3;
            if (tmp$_0 == null) {
              return true;
            }
            var currentTargetElement = tmp$_0;
            var tmp$_5;
            if ((tmp$_1 = this.local$focusEvent.relatedTarget) != null) {
              var tmp$_6;
              tmp$_5 = Kotlin.isType(tmp$_6 = tmp$_1, HTMLElement) ? tmp$_6 : null;
            } else
              tmp$_5 = null;
            tmp$_2 = tmp$_5;
            if (tmp$_2 == null) {
              return true;
            }
            var relatedTargetElement = tmp$_2;
            return !currentTargetElement.contains(relatedTargetElement);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$renderPopover$lambda$lambda$lambda_2(focusEvent_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda(focusEvent_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0.prototype.constructor = Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0;
  Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$renderPopover$lambda$lambda$lambda_3(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$renderPopover$lambda$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function PopoverComponent$renderPopover$lambda$lambda_0(this$PopoverComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.attr_puj7f4$('tabindex', '-1');
      if (this$PopoverComponent.hasArrow.value) {
        div($receiver, PopoverComponent$renderPopover$lambda$lambda$lambda_0(this$PopoverComponent), void 0, void 0, 'popover-arrow', void 0, PopoverComponent$renderPopover$lambda$lambda$lambda_1);
      }if (this$PopoverComponent.hasCloseButton.value) {
        $receiver.handledBy_jora5j$(this$PopoverComponent.closeButtonRendering.value($receiver), this$PopoverComponent.visible_tygl0s$_0.toggle);
      }(tmp$ = this$PopoverComponent.header_huufl5$_0) != null ? tmp$($receiver) : null;
      (tmp$_0 = this$PopoverComponent.content_5mgsl7$_0) != null ? tmp$_0($receiver) : null;
      (tmp$_1 = this$PopoverComponent.footer_6jikth$_0) != null ? tmp$_1($receiver) : null;
      if (this$PopoverComponent.closeOnBlur.value) {
        var $receiver_0 = debounce($receiver.blurs.events, L100);
        var $receiver_1 = new unsafeFlow$ObjectLiteral_8(unsafeTransform$lambda_7(filter$lambda(PopoverComponent$renderPopover$lambda$lambda$lambda_2), $receiver_0));
        $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_9(unsafeTransform$lambda_8(map$lambda_6(PopoverComponent$renderPopover$lambda$lambda$lambda_3), $receiver_1)), this$PopoverComponent.visible_tygl0s$_0.toggle);
      }return Unit;
    };
  }
  PopoverComponent.prototype.renderPopover_ltf9a6$_0 = function (context, styling, baseClass, prefix) {
    if (styling === void 0)
      styling = PopoverComponent$renderPopover$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    return section_0(context, PopoverComponent$renderPopover$lambda$lambda(this), styling, baseClass, void 0, prefix, void 0, PopoverComponent$renderPopover$lambda$lambda_0(this)).domNode;
  };
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(PopoverComponent.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_677i8a$_0.hasCloseButton;
    }
  });
  function PopoverComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().popover.size.normal;
  }
  function PopoverComponent$placementStyle$lambda($receiver) {
    return Theme.Companion.invoke().popover.placement.top;
  }
  function PopoverComponent$arrowPlacement$lambda($receiver) {
    return Theme.Companion.invoke().popover.arrowPlacement.bottom;
  }
  function PopoverComponent$visible$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.toggle = this.handle_7ib3lp$(void 0, PopoverComponent$visible$ObjectLiteral$toggle$lambda);
    this.closeOnKey = this.handle_ajdi87$(void 0, PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda);
  }
  function Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda.prototype.constructor = Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda;
  Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$visible$ObjectLiteral$toggle$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$visible$ObjectLiteral$toggle$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda(f_1, f_2, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda.prototype.constructor = Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda;
  Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return false;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda(f_1, f_2, continuation_0, suspended) {
    var instance = new Coroutine$PopoverComponent$visible$ObjectLiteral$closeOnKey$lambda(f_1, f_2, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  PopoverComponent$visible$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  PopoverComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PopoverComponent',
    interfaces: [CloseButtonProperty, Component]
  };
  function popover$lambda($receiver) {
    return Unit;
  }
  function popover$lambda_0($receiver) {
    return Unit;
  }
  function popover($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = popover$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'popover';
    if (build === void 0)
      build = popover$lambda_0;
    var $receiver_0 = new PopoverComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function popup$lambda($receiver) {
    return Unit;
  }
  function popup($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = popup$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = 'fc2-popup-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = 'popup';
    var $receiver_0 = new PopupComponent();
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function Placement(position, flips) {
    if (flips === void 0)
      flips = emptyList();
    this.position = position;
    this.flips = flips;
  }
  function Placement$Top() {
    Placement$Top_instance = this;
    Placement.call(this, Placement$Placement$Top_init$lambda, listOf_0([Placement$Bottom_getInstance(), Placement$Left_getInstance(), Placement$Right_getInstance()]));
  }
  function Placement$Placement$Top_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + triggerInformation.domRect.left + triggerInformation.domRect.width * 0.5 - element.offsetWidth * 0.5;
    var top = triggerInformation.domRect.top - offset - element.offsetHeight;
    return to(left, top);
  }
  Placement$Top.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Top',
    interfaces: [Placement]
  };
  var Placement$Top_instance = null;
  function Placement$Top_getInstance() {
    if (Placement$Top_instance === null) {
      new Placement$Top();
    }return Placement$Top_instance;
  }
  function Placement$TopStart() {
    Placement$TopStart_instance = this;
    Placement.call(this, Placement$Placement$TopStart_init$lambda, listOf_0([Placement$BottomStart_getInstance(), Placement$LeftStart_getInstance(), Placement$RightStart_getInstance(), Placement$TopEnd_getInstance(), Placement$BottomEnd_getInstance(), Placement$LeftEnd_getInstance(), Placement$RightEnd_getInstance()]));
  }
  function Placement$Placement$TopStart_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + triggerInformation.domRect.left;
    var top = triggerInformation.domRect.top - offset - element.offsetHeight;
    return to(left, top);
  }
  Placement$TopStart.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TopStart',
    interfaces: [Placement]
  };
  var Placement$TopStart_instance = null;
  function Placement$TopStart_getInstance() {
    if (Placement$TopStart_instance === null) {
      new Placement$TopStart();
    }return Placement$TopStart_instance;
  }
  function Placement$TopEnd() {
    Placement$TopEnd_instance = this;
    Placement.call(this, Placement$Placement$TopEnd_init$lambda, listOf_0([Placement$BottomEnd_getInstance(), Placement$LeftEnd_getInstance(), Placement$RightEnd_getInstance(), Placement$TopStart_getInstance(), Placement$BottomStart_getInstance(), Placement$LeftStart_getInstance(), Placement$RightStart_getInstance()]));
  }
  function Placement$Placement$TopEnd_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + triggerInformation.domRect.left + triggerInformation.domRect.width - element.offsetWidth;
    var top = triggerInformation.domRect.top - offset - element.offsetHeight;
    return to(left, top);
  }
  Placement$TopEnd.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TopEnd',
    interfaces: [Placement]
  };
  var Placement$TopEnd_instance = null;
  function Placement$TopEnd_getInstance() {
    if (Placement$TopEnd_instance === null) {
      new Placement$TopEnd();
    }return Placement$TopEnd_instance;
  }
  function Placement$Bottom() {
    Placement$Bottom_instance = this;
    Placement.call(this, Placement$Placement$Bottom_init$lambda, listOf_0([Placement$Top_getInstance(), Placement$Left_getInstance(), Placement$Right_getInstance()]));
  }
  function Placement$Placement$Bottom_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + triggerInformation.domRect.left + triggerInformation.domRect.width * 0.5 - element.offsetWidth * 0.5;
    var top = triggerInformation.domRect.top + offset + triggerInformation.domRect.height;
    return to(left, top);
  }
  Placement$Bottom.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Bottom',
    interfaces: [Placement]
  };
  var Placement$Bottom_instance = null;
  function Placement$Bottom_getInstance() {
    if (Placement$Bottom_instance === null) {
      new Placement$Bottom();
    }return Placement$Bottom_instance;
  }
  function Placement$BottomStart() {
    Placement$BottomStart_instance = this;
    Placement.call(this, Placement$Placement$BottomStart_init$lambda, listOf_0([Placement$TopStart_getInstance(), Placement$LeftStart_getInstance(), Placement$RightStart_getInstance(), Placement$BottomEnd_getInstance(), Placement$TopEnd_getInstance(), Placement$LeftEnd_getInstance(), Placement$RightEnd_getInstance()]));
  }
  function Placement$Placement$BottomStart_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + triggerInformation.domRect.left;
    var top = triggerInformation.domRect.top + offset + triggerInformation.domRect.height;
    return to(left, top);
  }
  Placement$BottomStart.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BottomStart',
    interfaces: [Placement]
  };
  var Placement$BottomStart_instance = null;
  function Placement$BottomStart_getInstance() {
    if (Placement$BottomStart_instance === null) {
      new Placement$BottomStart();
    }return Placement$BottomStart_instance;
  }
  function Placement$BottomEnd() {
    Placement$BottomEnd_instance = this;
    Placement.call(this, Placement$Placement$BottomEnd_init$lambda, listOf_0([Placement$TopEnd_getInstance(), Placement$LeftEnd_getInstance(), Placement$RightEnd_getInstance(), Placement$TopStart_getInstance(), Placement$BottomStart_getInstance(), Placement$LeftStart_getInstance(), Placement$RightStart_getInstance()]));
  }
  function Placement$Placement$BottomEnd_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + triggerInformation.domRect.left + triggerInformation.domRect.width - element.offsetWidth;
    var top = triggerInformation.domRect.top + offset + triggerInformation.domRect.height;
    return to(left, top);
  }
  Placement$BottomEnd.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BottomEnd',
    interfaces: [Placement]
  };
  var Placement$BottomEnd_instance = null;
  function Placement$BottomEnd_getInstance() {
    if (Placement$BottomEnd_instance === null) {
      new Placement$BottomEnd();
    }return Placement$BottomEnd_instance;
  }
  function Placement$Left() {
    Placement$Left_instance = this;
    Placement.call(this, Placement$Placement$Left_init$lambda, listOf_0([Placement$Right_getInstance(), Placement$Top_getInstance(), Placement$Bottom_getInstance()]));
  }
  function Placement$Placement$Left_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition - offset + triggerInformation.domRect.left - element.offsetWidth;
    var top = triggerInformation.domRect.top + triggerInformation.domRect.height * 0.5 - element.offsetHeight * 0.5;
    return to(left, top);
  }
  Placement$Left.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Left',
    interfaces: [Placement]
  };
  var Placement$Left_instance = null;
  function Placement$Left_getInstance() {
    if (Placement$Left_instance === null) {
      new Placement$Left();
    }return Placement$Left_instance;
  }
  function Placement$LeftStart() {
    Placement$LeftStart_instance = this;
    Placement.call(this, Placement$Placement$LeftStart_init$lambda, listOf_0([Placement$LeftEnd_getInstance(), Placement$Left_getInstance(), Placement$RightStart_getInstance(), Placement$RightEnd_getInstance(), Placement$Right_getInstance(), Placement$TopStart_getInstance(), Placement$BottomStart_getInstance(), Placement$Top_getInstance(), Placement$Bottom_getInstance()]));
  }
  function Placement$Placement$LeftStart_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition - offset + triggerInformation.domRect.left - element.offsetWidth;
    var top = triggerInformation.domRect.top;
    return to(left, top);
  }
  Placement$LeftStart.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'LeftStart',
    interfaces: [Placement]
  };
  var Placement$LeftStart_instance = null;
  function Placement$LeftStart_getInstance() {
    if (Placement$LeftStart_instance === null) {
      new Placement$LeftStart();
    }return Placement$LeftStart_instance;
  }
  function Placement$LeftEnd() {
    Placement$LeftEnd_instance = this;
    Placement.call(this, Placement$Placement$LeftEnd_init$lambda, listOf_0([Placement$LeftStart_getInstance(), Placement$Left_getInstance(), Placement$RightEnd_getInstance(), Placement$RightStart_getInstance(), Placement$Right_getInstance(), Placement$TopEnd_getInstance(), Placement$BottomEnd_getInstance(), Placement$Top_getInstance(), Placement$Bottom_getInstance()]));
  }
  function Placement$Placement$LeftEnd_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition - offset + triggerInformation.domRect.left - element.offsetWidth;
    var top = triggerInformation.domRect.top + triggerInformation.domRect.height - element.offsetHeight;
    return to(left, top);
  }
  Placement$LeftEnd.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'LeftEnd',
    interfaces: [Placement]
  };
  var Placement$LeftEnd_instance = null;
  function Placement$LeftEnd_getInstance() {
    if (Placement$LeftEnd_instance === null) {
      new Placement$LeftEnd();
    }return Placement$LeftEnd_instance;
  }
  function Placement$Right() {
    Placement$Right_instance = this;
    Placement.call(this, Placement$Placement$Right_init$lambda, listOf_0([Placement$Left_getInstance(), Placement$Top_getInstance(), Placement$Bottom_getInstance()]));
  }
  function Placement$Placement$Right_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + offset + triggerInformation.domRect.left + triggerInformation.domRect.width;
    var top = triggerInformation.domRect.top + triggerInformation.domRect.height * 0.5 - element.offsetHeight * 0.5;
    return to(left, top);
  }
  Placement$Right.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Right',
    interfaces: [Placement]
  };
  var Placement$Right_instance = null;
  function Placement$Right_getInstance() {
    if (Placement$Right_instance === null) {
      new Placement$Right();
    }return Placement$Right_instance;
  }
  function Placement$RightStart() {
    Placement$RightStart_instance = this;
    Placement.call(this, Placement$Placement$RightStart_init$lambda, listOf_0([Placement$RightEnd_getInstance(), Placement$LeftStart_getInstance(), Placement$LeftEnd_getInstance(), Placement$TopStart_getInstance(), Placement$BottomStart_getInstance(), Placement$TopEnd_getInstance(), Placement$BottomEnd_getInstance()]));
  }
  function Placement$Placement$RightStart_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + offset + triggerInformation.domRect.left + triggerInformation.domRect.width;
    var top = triggerInformation.domRect.top;
    return to(left, top);
  }
  Placement$RightStart.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RightStart',
    interfaces: [Placement]
  };
  var Placement$RightStart_instance = null;
  function Placement$RightStart_getInstance() {
    if (Placement$RightStart_instance === null) {
      new Placement$RightStart();
    }return Placement$RightStart_instance;
  }
  function Placement$RightEnd() {
    Placement$RightEnd_instance = this;
    Placement.call(this, Placement$Placement$RightEnd_init$lambda, listOf_0([Placement$RightStart_getInstance(), Placement$LeftEnd_getInstance(), Placement$LeftStart_getInstance(), Placement$TopEnd_getInstance(), Placement$BottomEnd_getInstance(), Placement$TopStart_getInstance(), Placement$BottomStart_getInstance()]));
  }
  function Placement$Placement$RightEnd_init$lambda(triggerInformation, element, offset) {
    var left = PopupComponent$Companion_getInstance().leftRenderPosition + offset + triggerInformation.domRect.left + triggerInformation.domRect.width;
    var top = triggerInformation.domRect.top + triggerInformation.domRect.height - element.offsetHeight;
    return to(left, top);
  }
  Placement$RightEnd.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RightEnd',
    interfaces: [Placement]
  };
  var Placement$RightEnd_instance = null;
  function Placement$RightEnd_getInstance() {
    if (Placement$RightEnd_instance === null) {
      new Placement$RightEnd();
    }return Placement$RightEnd_instance;
  }
  Placement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Placement',
    interfaces: []
  };
  function Positioning(triggerInformation, element, offset, placement, flipping) {
    if (flipping === void 0)
      flipping = true;
    this.triggerInformation_0 = triggerInformation;
    this.element_0 = element;
    this.offset_0 = offset;
    this.placement_0 = placement;
    this.flipping_0 = flipping;
    this.defaultPosition_0 = this.placement_0.position(this.triggerInformation_0, this.element_0, this.offset_0);
    this.topAvailable_0 = this.triggerInformation_0.domRect.top - this.offset_0 - this.element_0.offsetHeight > 0;
    this.bottomAvailable_0 = this.triggerInformation_0.domRect.top + this.offset_0 + this.element_0.offsetHeight - window.innerHeight < 0;
    this.leftAvailable_0 = this.triggerInformation_0.domRect.left - this.offset_0 - this.element_0.offsetWidth > 0;
    this.rightAvailable_0 = this.triggerInformation_0.domRect.left + this.triggerInformation_0.domRect.width + this.offset_0 + this.element_0.offsetWidth - window.innerWidth < 0;
    this.horizontalStartAvailable_0 = this.triggerInformation_0.domRect.left + this.element_0.offsetWidth - window.innerWidth < 0;
    this.horizontalEndAvailable_0 = this.triggerInformation_0.domRect.left + this.triggerInformation_0.domRect.width - this.element_0.offsetWidth > 0;
    this.verticalStartAvailable_0 = this.triggerInformation_0.domRect.top + this.element_0.offsetHeight > 0;
    this.verticalEndAvailable_0 = this.triggerInformation_0.domRect.top + this.triggerInformation_0.domRect.height - this.element_0.offsetHeight > 0;
    var $receiver = StringBuilder_init();
    if (this.triggerInformation_0.active) {
      $receiver.append_pdl1vj$('transform: translate(' + numberToInt(this.position_0.first + window.scrollX) + 'px, ' + (numberToInt(this.position_0.second + window.scrollY).toString() + 'px);'));
    }this.inlineStyle = $receiver.toString();
  }
  Positioning.prototype.spaceAvailable_0 = function (placement) {
    var tmp$;
    if (equals(placement, Placement$Top_getInstance()))
      tmp$ = this.topAvailable_0;
    else if (equals(placement, Placement$TopStart_getInstance()))
      tmp$ = (this.topAvailable_0 && this.horizontalStartAvailable_0);
    else if (equals(placement, Placement$TopEnd_getInstance()))
      tmp$ = (this.topAvailable_0 && this.horizontalEndAvailable_0);
    else if (equals(placement, Placement$Bottom_getInstance()))
      tmp$ = this.bottomAvailable_0;
    else if (equals(placement, Placement$BottomStart_getInstance()))
      tmp$ = (this.bottomAvailable_0 && this.horizontalStartAvailable_0);
    else if (equals(placement, Placement$BottomEnd_getInstance()))
      tmp$ = (this.bottomAvailable_0 && this.horizontalEndAvailable_0);
    else if (equals(placement, Placement$Left_getInstance()))
      tmp$ = this.leftAvailable_0;
    else if (equals(placement, Placement$LeftStart_getInstance()))
      tmp$ = (this.leftAvailable_0 && this.verticalStartAvailable_0);
    else if (equals(placement, Placement$LeftEnd_getInstance()))
      tmp$ = (this.leftAvailable_0 && this.verticalEndAvailable_0);
    else if (equals(placement, Placement$Right_getInstance()))
      tmp$ = this.rightAvailable_0;
    else if (equals(placement, Placement$RightStart_getInstance()))
      tmp$ = (this.rightAvailable_0 && this.verticalStartAvailable_0);
    else if (equals(placement, Placement$RightEnd_getInstance()))
      tmp$ = (this.rightAvailable_0 && this.verticalEndAvailable_0);
    else
      tmp$ = true;
    return tmp$;
  };
  Object.defineProperty(Positioning.prototype, 'position_0', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0, tmp$_1;
      if (this.flipping_0) {
        if (this.spaceAvailable_0(this.placement_0)) {
          tmp$_1 = this.defaultPosition_0;
        } else {
          var $receiver = this.placement_0.flips;
          var firstOrNull$result;
          firstOrNull$break: do {
            var tmp$_2;
            tmp$_2 = $receiver.iterator();
            while (tmp$_2.hasNext()) {
              var element = tmp$_2.next();
              if (this.spaceAvailable_0(element)) {
                firstOrNull$result = element;
                break firstOrNull$break;
              }}
            firstOrNull$result = null;
          }
           while (false);
          tmp$_1 = (tmp$_0 = (tmp$ = firstOrNull$result) != null ? tmp$.position(this.triggerInformation_0, this.element_0, this.offset_0) : null) != null ? tmp$_0 : this.defaultPosition_0;
        }
      } else {
        tmp$_1 = this.defaultPosition_0;
      }
      return tmp$_1;
    }
  });
  Positioning.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Positioning',
    interfaces: []
  };
  function TriggerInformation(id, active, domRect) {
    if (id === void 0)
      id = '';
    if (active === void 0)
      active = false;
    if (domRect === void 0)
      domRect = new DOMRect();
    this.id = id;
    this.active = active;
    this.domRect = domRect;
  }
  TriggerInformation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TriggerInformation',
    interfaces: []
  };
  TriggerInformation.prototype.component1 = function () {
    return this.id;
  };
  TriggerInformation.prototype.component2 = function () {
    return this.active;
  };
  TriggerInformation.prototype.component3 = function () {
    return this.domRect;
  };
  TriggerInformation.prototype.copy_jzuv4q$ = function (id, active, domRect) {
    return new TriggerInformation(id === void 0 ? this.id : id, active === void 0 ? this.active : active, domRect === void 0 ? this.domRect : domRect);
  };
  TriggerInformation.prototype.toString = function () {
    return 'TriggerInformation(id=' + Kotlin.toString(this.id) + (', active=' + Kotlin.toString(this.active)) + (', domRect=' + Kotlin.toString(this.domRect)) + ')';
  };
  TriggerInformation.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.active) | 0;
    result = result * 31 + Kotlin.hashCode(this.domRect) | 0;
    return result;
  };
  TriggerInformation.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.active, other.active) && Kotlin.equals(this.domRect, other.domRect)))));
  };
  function unsafeFlow$ObjectLiteral_10(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_10($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_10.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_10.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_10.prototype.constructor = Coroutine$collect_42ocv1$_10;
  Coroutine$collect_42ocv1$_10.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_10.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_10(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_10.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_9(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_9.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_9;
  Coroutine$unsafeTransform$lambda$lambda_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_9(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_9(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_9(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_9.prototype.constructor = Coroutine$unsafeTransform$lambda_9;
  Coroutine$unsafeTransform$lambda_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_9(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_9(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_9(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_7(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_7.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_7.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_7.prototype.constructor = Coroutine$map$lambda_7;
  Coroutine$map$lambda_7.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_7(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_7(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function PlacementContext() {
    PlacementContext_instance = this;
    this.top = Placement$Top_getInstance();
    this.topStart = Placement$TopStart_getInstance();
    this.topEnd = Placement$TopEnd_getInstance();
    this.bottom = Placement$Bottom_getInstance();
    this.bottomStart = Placement$BottomStart_getInstance();
    this.bottomEnd = Placement$BottomEnd_getInstance();
    this.left = Placement$Left_getInstance();
    this.leftStart = Placement$LeftStart_getInstance();
    this.leftEnd = Placement$LeftEnd_getInstance();
    this.right = Placement$Right_getInstance();
    this.rightStart = Placement$RightStart_getInstance();
    this.rightEnd = Placement$RightEnd_getInstance();
  }
  PlacementContext.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'PlacementContext',
    interfaces: []
  };
  var PlacementContext_instance = null;
  function PlacementContext_getInstance() {
    if (PlacementContext_instance === null) {
      new PlacementContext();
    }return PlacementContext_instance;
  }
  function PopupComponent() {
    PopupComponent$Companion_getInstance();
    this.$delegate_c9ej$_0 = new EventMixin();
    this.offset = new ComponentProperty(10.0);
    this.flipping = new ComponentProperty(true);
    this.content = new ComponentProperty(null);
    this.trigger = new ComponentProperty(null);
    this.placement = new ComponentProperty(PopupComponent$placement$lambda);
    this.popupStore_lhssec$_0 = new PopupComponent$popupStore$ObjectLiteral(new TriggerInformation());
  }
  function PopupComponent$Companion() {
    PopupComponent$Companion_instance = this;
    this.leftRenderPosition = 9999.0;
  }
  PopupComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PopupComponent$Companion_instance = null;
  function PopupComponent$Companion_getInstance() {
    if (PopupComponent$Companion_instance === null) {
      new PopupComponent$Companion();
    }return PopupComponent$Companion_instance;
  }
  function Coroutine$PopupComponent$renderPopup$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$PopupComponent$renderPopup$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopupComponent$renderPopup$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopupComponent$renderPopup$lambda.prototype.constructor = Coroutine$PopupComponent$renderPopup$lambda;
  Coroutine$PopupComponent$renderPopup$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.active;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopupComponent$renderPopup$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$PopupComponent$renderPopup$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function PopupComponent$renderPopup$lambda$lambda(closure$styling) {
    return function ($receiver) {
      Theme.Companion.invoke().popup.wrapper($receiver, 9999);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function PopupComponent$renderPopup$lambda$lambda_0(closure$style, closure$active, this$PopupComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.attr_i7f8q9$('style', closure$style.data);
      $receiver.attr_mzp0ey$('data-active', closure$active);
      (tmp$ = this$PopupComponent.content.value) != null ? tmp$($receiver, this$PopupComponent.popupStore_lhssec$_0.close) : null;
      return Unit;
    };
  }
  function Coroutine$PopupComponent$renderPopup$lambda$lambda(this$PopupComponent_0, closure$popupElement_0, triggerInformation_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$PopupComponent = this$PopupComponent_0;
    this.local$closure$popupElement = closure$popupElement_0;
    this.local$triggerInformation = triggerInformation_0;
  }
  Coroutine$PopupComponent$renderPopup$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopupComponent$renderPopup$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopupComponent$renderPopup$lambda$lambda.prototype.constructor = Coroutine$PopupComponent$renderPopup$lambda$lambda;
  Coroutine$PopupComponent$renderPopup$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$PopupComponent.getStyling_iti2bv$_0(this.local$triggerInformation, this.local$closure$popupElement.v == null ? throwUPAE('popupElement') : this.local$closure$popupElement.v);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopupComponent$renderPopup$lambda$lambda_1(this$PopupComponent_0, closure$popupElement_0) {
    return function (triggerInformation_0, continuation_0, suspended) {
      var instance = new Coroutine$PopupComponent$renderPopup$lambda$lambda(this$PopupComponent_0, closure$popupElement_0, triggerInformation_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  PopupComponent.prototype.renderPopup_zfzkx6$_0 = function (styling, baseClass, id, prefix) {
    var style = storeOf('');
    var job = Job();
    var scope = new Scope();
    var popupElement = {v: null};
    var $receiver = this.popupStore_lhssec$_0.data;
    var active = new unsafeFlow$ObjectLiteral_10(unsafeTransform$lambda_9(map$lambda_7(PopupComponent$renderPopup$lambda), $receiver));
    var $receiver_0 = ManagedComponent$Companion_getInstance().managedRenderContext_rcagsd$(id + 'ctx', job, scope);
    popupElement.v = div($receiver_0, PopupComponent$renderPopup$lambda$lambda(styling), baseClass, id, prefix, void 0, PopupComponent$renderPopup$lambda$lambda_0(style, active, this));
    var $receiver_1 = debounce(this.popupStore_lhssec$_0.data, L100);
    $receiver_0.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_10(unsafeTransform$lambda_9(map$lambda_7(PopupComponent$renderPopup$lambda$lambda_1(this, popupElement)), $receiver_1)), style.update);
    return popupElement.v == null ? throwUPAE('popupElement') : popupElement.v;
  };
  PopupComponent.prototype.getStyling_iti2bv$_0 = function (triggerInformation, element) {
    var tmp$;
    if (triggerInformation.id.length > 0) {
      tmp$ = (new Positioning(triggerInformation, element.domNode, this.offset.value, this.placement.value(PlacementContext_getInstance()), this.flipping.value)).inlineStyle;
    } else {
      tmp$ = '';
    }
    return tmp$;
  };
  PopupComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    var popupId = id != null ? id : 'fc2-popup-' + identification.Id.next_za3lpa$();
    var tmp$;
    (tmp$ = this.trigger.value) != null ? tmp$(context, this.popupStore_lhssec$_0.toggle_61zpoe$(popupId), this.popupStore_lhssec$_0.close) : null;
    return this.renderPopup_zfzkx6$_0(styling, baseClass, popupId, prefix);
  };
  Object.defineProperty(PopupComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_c9ej$_0.events;
    }
  });
  function PopupComponent$placement$lambda($receiver) {
    return Placement$Top_getInstance();
  }
  function PopupComponent$popupStore$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.close = this.handle_7ib3lp$(void 0, PopupComponent$popupStore$ObjectLiteral$close$lambda);
  }
  function Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda(closure$id_0, triggerInformation_0, eventTarget_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$id = closure$id_0;
    this.local$triggerInformation = triggerInformation_0;
    this.local$eventTarget = eventTarget_0;
  }
  Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda.prototype.constructor = Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda;
  Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            if (this.local$triggerInformation.active)
              return this.local$triggerInformation.copy_jzuv4q$(void 0, false);
            else if (this.local$eventTarget != null) {
              var target = Kotlin.isType(tmp$ = this.local$eventTarget, HTMLElement) ? tmp$ : throwCCE();
              return new TriggerInformation(this.local$closure$id, true, target.getBoundingClientRect());
            } else {
              return this.local$triggerInformation;
            }

          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopupComponent$popupStore$ObjectLiteral$toggle$lambda(closure$id_0) {
    return function (triggerInformation_0, eventTarget_0, continuation_0, suspended) {
      var instance = new Coroutine$PopupComponent$popupStore$ObjectLiteral$toggle$lambda(closure$id_0, triggerInformation_0, eventTarget_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  PopupComponent$popupStore$ObjectLiteral.prototype.toggle_61zpoe$ = function (id) {
    return this.handle_ajdi87$(void 0, PopupComponent$popupStore$ObjectLiteral$toggle$lambda(id));
  };
  function Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda(triggerInformation_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$triggerInformation = triggerInformation_0;
  }
  Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda.prototype.constructor = Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda;
  Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$triggerInformation.copy_jzuv4q$(void 0, false);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PopupComponent$popupStore$ObjectLiteral$close$lambda(triggerInformation_0, continuation_0, suspended) {
    var instance = new Coroutine$PopupComponent$popupStore$ObjectLiteral$close$lambda(triggerInformation_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  PopupComponent$popupStore$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  PopupComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PopupComponent',
    interfaces: [EventProperties]
  };
  function radio$lambda($receiver) {
    return Unit;
  }
  function radio$lambda_0($receiver) {
    return Unit;
  }
  function radio($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = radio$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'radioComponent';
    if (build === void 0)
      build = radio$lambda_0;
    var $receiver_0 = new RadioComponent(value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function radioGroup$lambda($receiver) {
    return Unit;
  }
  function radioGroup$lambda_0($receiver) {
    return Unit;
  }
  function radioGroup($receiver, styling, items, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = radioGroup$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'radioGroupComponent';
    if (build === void 0)
      build = radioGroup$lambda_0;
    var $receiver_0 = new RadioGroupComponent(items, value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_11(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_11($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_11.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_11.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_11.prototype.constructor = Coroutine$collect_42ocv1$_11;
  Coroutine$collect_42ocv1$_11.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_11.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_11(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_11.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_10(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_10.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_10.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_10.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_10;
  Coroutine$unsafeTransform$lambda$lambda_10.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_10(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_10(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_10(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_10.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_10.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_10.prototype.constructor = Coroutine$unsafeTransform$lambda_10;
  Coroutine$unsafeTransform$lambda_10.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_10(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_10(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_10(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_8(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_8.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_8.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_8.prototype.constructor = Coroutine$map$lambda_8;
  Coroutine$map$lambda_8.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_8(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_8(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent(items, value) {
    RadioGroupComponent$Companion_getInstance();
    if (value === void 0)
      value = null;
    this.items = items;
    this.value = value;
    this.$delegate_mrm99x$_0 = new InputFormMixin();
    this.$delegate_mrm99x$_1 = new SeverityMixin();
    this.$delegate_mrm99x$_2 = new OrientationMixin(Orientation$VERTICAL_getInstance());
    this.$delegate_mrm99x$_3 = new TooltipMixin();
    this.label = new ComponentProperty(RadioGroupComponent$label$lambda);
    this.labelRendering = new ComponentProperty(RadioGroupComponent$labelRendering$lambda(this));
    this.size = new ComponentProperty(RadioGroupComponent$size$lambda);
    this.itemStyle = new ComponentProperty(Theme.Companion.invoke().radio.default);
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().radio.label);
    this.selectedStyle = new ComponentProperty(Theme.Companion.invoke().radio.selected);
    this.selectedItem = new NullableDynamicComponentProperty(emptyFlow());
    this.events = new ComponentProperty(RadioGroupComponent$events$lambda);
  }
  function RadioGroupComponent$Companion() {
    RadioGroupComponent$Companion_instance = this;
  }
  function RadioGroupComponent$Companion$layoutOf$lambda$lambda(closure$orientation) {
    return function ($receiver) {
      switch (closure$orientation.name) {
        case 'HORIZONTAL':
          return $receiver.inlineFlex;
        case 'VERTICAL':
          return $receiver.inlineGrid;
        default:return Kotlin.noWhenBranchMatched();
      }
    };
  }
  function RadioGroupComponent$Companion$layoutOf$lambda(closure$orientation) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(RadioGroupComponent$Companion$layoutOf$lambda$lambda(closure$orientation));
      return Unit;
    };
  }
  RadioGroupComponent$Companion.prototype.layoutOf_spnxqo$ = function (orientation) {
    return RadioGroupComponent$Companion$layoutOf$lambda(orientation);
  };
  RadioGroupComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RadioGroupComponent$Companion_instance = null;
  function RadioGroupComponent$Companion_getInstance() {
    if (RadioGroupComponent$Companion_instance === null) {
      new RadioGroupComponent$Companion();
    }return RadioGroupComponent$Companion_instance;
  }
  function RadioGroupComponent$EventsContext(element, selected) {
    this.element_0 = element;
    this.selected = selected;
  }
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'aborts', {
    configurable: true,
    get: function () {
      return this.element_0.aborts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'afterprints', {
    configurable: true,
    get: function () {
      return this.element_0.afterprints;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'beforeprints', {
    configurable: true,
    get: function () {
      return this.element_0.beforeprints;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'beforeunloads', {
    configurable: true,
    get: function () {
      return this.element_0.beforeunloads;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'blurs', {
    configurable: true,
    get: function () {
      return this.element_0.blurs;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'canplays', {
    configurable: true,
    get: function () {
      return this.element_0.canplays;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'canplaythroughs', {
    configurable: true,
    get: function () {
      return this.element_0.canplaythroughs;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'changes', {
    configurable: true,
    get: function () {
      return this.element_0.changes;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'clicks', {
    configurable: true,
    get: function () {
      return this.element_0.clicks;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'contextmenus', {
    configurable: true,
    get: function () {
      return this.element_0.contextmenus;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'copys', {
    configurable: true,
    get: function () {
      return this.element_0.copys;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'cuts', {
    configurable: true,
    get: function () {
      return this.element_0.cuts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'dblclicks', {
    configurable: true,
    get: function () {
      return this.element_0.dblclicks;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'domNode', {
    configurable: true,
    get: function () {
      return this.element_0.domNode;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'dragends', {
    configurable: true,
    get: function () {
      return this.element_0.dragends;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'dragenters', {
    configurable: true,
    get: function () {
      return this.element_0.dragenters;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'dragleaves', {
    configurable: true,
    get: function () {
      return this.element_0.dragleaves;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'dragovers', {
    configurable: true,
    get: function () {
      return this.element_0.dragovers;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'drags', {
    configurable: true,
    get: function () {
      return this.element_0.drags;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'dragstarts', {
    configurable: true,
    get: function () {
      return this.element_0.dragstarts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'drops', {
    configurable: true,
    get: function () {
      return this.element_0.drops;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'durationchanges', {
    configurable: true,
    get: function () {
      return this.element_0.durationchanges;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'endeds', {
    configurable: true,
    get: function () {
      return this.element_0.endeds;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'focusins', {
    configurable: true,
    get: function () {
      return this.element_0.focusins;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'focusouts', {
    configurable: true,
    get: function () {
      return this.element_0.focusouts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'focuss', {
    configurable: true,
    get: function () {
      return this.element_0.focuss;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'fullscreenchanges', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenchanges;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'fullscreenerrors', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenerrors;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'hashchanges', {
    configurable: true,
    get: function () {
      return this.element_0.hashchanges;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'inputs', {
    configurable: true,
    get: function () {
      return this.element_0.inputs;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'invalids', {
    configurable: true,
    get: function () {
      return this.element_0.invalids;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'job', {
    configurable: true,
    get: function () {
      return this.element_0.job;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'keydowns', {
    configurable: true,
    get: function () {
      return this.element_0.keydowns;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'keypresss', {
    configurable: true,
    get: function () {
      return this.element_0.keypresss;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'keyups', {
    configurable: true,
    get: function () {
      return this.element_0.keyups;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'loadeddatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadeddatas;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'loadedmetadatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadedmetadatas;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'loads', {
    configurable: true,
    get: function () {
      return this.element_0.loads;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'loadstarts', {
    configurable: true,
    get: function () {
      return this.element_0.loadstarts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'messages', {
    configurable: true,
    get: function () {
      return this.element_0.messages;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mousedowns', {
    configurable: true,
    get: function () {
      return this.element_0.mousedowns;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mouseenters', {
    configurable: true,
    get: function () {
      return this.element_0.mouseenters;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mouseleaves', {
    configurable: true,
    get: function () {
      return this.element_0.mouseleaves;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mousemoves', {
    configurable: true,
    get: function () {
      return this.element_0.mousemoves;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mouseouts', {
    configurable: true,
    get: function () {
      return this.element_0.mouseouts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mouseovers', {
    configurable: true,
    get: function () {
      return this.element_0.mouseovers;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'mouseups', {
    configurable: true,
    get: function () {
      return this.element_0.mouseups;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'offlines', {
    configurable: true,
    get: function () {
      return this.element_0.offlines;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'onlines', {
    configurable: true,
    get: function () {
      return this.element_0.onlines;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'opens', {
    configurable: true,
    get: function () {
      return this.element_0.opens;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'pagehides', {
    configurable: true,
    get: function () {
      return this.element_0.pagehides;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'pageshows', {
    configurable: true,
    get: function () {
      return this.element_0.pageshows;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'pastes', {
    configurable: true,
    get: function () {
      return this.element_0.pastes;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'pauses', {
    configurable: true,
    get: function () {
      return this.element_0.pauses;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'playings', {
    configurable: true,
    get: function () {
      return this.element_0.playings;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'plays', {
    configurable: true,
    get: function () {
      return this.element_0.plays;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'popstates', {
    configurable: true,
    get: function () {
      return this.element_0.popstates;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'progresss', {
    configurable: true,
    get: function () {
      return this.element_0.progresss;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'ratechanges', {
    configurable: true,
    get: function () {
      return this.element_0.ratechanges;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'resets', {
    configurable: true,
    get: function () {
      return this.element_0.resets;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'resizes', {
    configurable: true,
    get: function () {
      return this.element_0.resizes;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'scrolls', {
    configurable: true,
    get: function () {
      return this.element_0.scrolls;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'searchs', {
    configurable: true,
    get: function () {
      return this.element_0.searchs;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'seekeds', {
    configurable: true,
    get: function () {
      return this.element_0.seekeds;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'seekings', {
    configurable: true,
    get: function () {
      return this.element_0.seekings;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'selects', {
    configurable: true,
    get: function () {
      return this.element_0.selects;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'shows', {
    configurable: true,
    get: function () {
      return this.element_0.shows;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'stalleds', {
    configurable: true,
    get: function () {
      return this.element_0.stalleds;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'storages', {
    configurable: true,
    get: function () {
      return this.element_0.storages;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'submits', {
    configurable: true,
    get: function () {
      return this.element_0.submits;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'suspends', {
    configurable: true,
    get: function () {
      return this.element_0.suspends;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'timeupdates', {
    configurable: true,
    get: function () {
      return this.element_0.timeupdates;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'toggles', {
    configurable: true,
    get: function () {
      return this.element_0.toggles;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'touchcancels', {
    configurable: true,
    get: function () {
      return this.element_0.touchcancels;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'touchends', {
    configurable: true,
    get: function () {
      return this.element_0.touchends;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'touchmoves', {
    configurable: true,
    get: function () {
      return this.element_0.touchmoves;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'touchstarts', {
    configurable: true,
    get: function () {
      return this.element_0.touchstarts;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'unloads', {
    configurable: true,
    get: function () {
      return this.element_0.unloads;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'volumechanges', {
    configurable: true,
    get: function () {
      return this.element_0.volumechanges;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'waitings', {
    configurable: true,
    get: function () {
      return this.element_0.waitings;
    }
  });
  Object.defineProperty(RadioGroupComponent$EventsContext.prototype, 'wheels', {
    configurable: true,
    get: function () {
      return this.element_0.wheels;
    }
  });
  RadioGroupComponent$EventsContext.prototype.handledBy_jora5j$ = function ($receiver, handler) {
    return this.element_0.handledBy_jora5j$($receiver, handler);
  };
  RadioGroupComponent$EventsContext.prototype.handledBy_lesqyu$ = function ($receiver, execute) {
    return this.element_0.handledBy_lesqyu$($receiver, execute);
  };
  RadioGroupComponent$EventsContext.prototype.handledBy_hlmqex$ = function ($receiver, handler) {
    return this.element_0.handledBy_hlmqex$($receiver, handler);
  };
  RadioGroupComponent$EventsContext.prototype.handledBy_uhegz2$ = function ($receiver, execute) {
    return this.element_0.handledBy_uhegz2$($receiver, execute);
  };
  RadioGroupComponent$EventsContext.prototype.handledBy_ytah3h$ = function ($receiver, handler) {
    return this.element_0.handledBy_ytah3h$($receiver, handler);
  };
  RadioGroupComponent$EventsContext.prototype.handledBy_706ovd$ = function ($receiver, execute) {
    return this.element_0.handledBy_706ovd$($receiver, execute);
  };
  RadioGroupComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: [EventContext]
  };
  function RadioGroupComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.top;
  }
  function RadioGroupComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.center;
  }
  function RadioGroupComponent$render$lambda$lambda(this$RadioGroupComponent) {
    return function ($receiver) {
      $receiver.verticalAlign_qe4rxr$(RadioGroupComponent$render$lambda$lambda$lambda);
      $receiver.css_61zpoe$('-webkit-box-align: center;');
      $receiver.alignItems_tsd917$(RadioGroupComponent$render$lambda$lambda$lambda_0);
      $receiver.invoke_qkhqzy$(RadioGroupComponent$Companion_getInstance().layoutOf_spnxqo$(this$RadioGroupComponent.orientation.value(OrientationContext_getInstance())));
      return Unit;
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda(this$RadioGroupComponent_0, selectedItem_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$RadioGroupComponent = this$RadioGroupComponent_0;
    this.local$selectedItem = selectedItem_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var it = indexOf_0(this.local$this$RadioGroupComponent.items, this.local$selectedItem);
            return it === -1 ? null : it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda_1(this$RadioGroupComponent_0) {
    return function (selectedItem_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda(this$RadioGroupComponent_0, selectedItem_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$index = closure$index_0;
    this.local$it = it_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it === this.local$closure$index;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda(closure$index_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$RadioGroupComponent) {
    return function ($receiver) {
      return this$RadioGroupComponent.size.value(Theme.Companion.invoke().radio.sizes);
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$RadioGroupComponent, closure$item) {
    return function ($receiver) {
      this$RadioGroupComponent.labelRendering.value($receiver, closure$item);
      return Unit;
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$index = closure$index_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$index;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda_1(closure$index, closure$internalStore) {
    return function ($receiver) {
      var $receiver_0 = states($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_11(unsafeTransform$lambda_10(map$lambda_8(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index)), $receiver_0)), closure$internalStore.toggle);
      return Unit;
    };
  }
  function RadioGroupComponent$render$lambda$lambda$lambda$lambda_0(this$RadioGroupComponent, closure$groupName, closure$item, closure$checkedFlow, closure$index, closure$internalStore) {
    return function ($receiver) {
      $receiver.size.invoke_11rb$(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda(this$RadioGroupComponent));
      $receiver.groupName.invoke_11rb$(closure$groupName);
      $receiver.labelStyle.invoke_11rb$(this$RadioGroupComponent.labelStyle.value);
      $receiver.selectedStyle.invoke_11rb$(this$RadioGroupComponent.selectedStyle.value);
      $receiver.label_wqyjv5$(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$RadioGroupComponent, closure$item));
      $receiver.selected.invoke_ror2s8$(closure$checkedFlow);
      $receiver.disabled.invoke_ror2s8$(this$RadioGroupComponent.disabled.values);
      $receiver.severity.invoke_ror2s8$(this$RadioGroupComponent.severity.values);
      $receiver.events.invoke_11rb$(RadioGroupComponent$render$lambda$lambda$lambda$lambda$lambda_1(closure$index, closure$internalStore));
      return Unit;
    };
  }
  function Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0(this$RadioGroupComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$RadioGroupComponent = this$RadioGroupComponent_0;
    this.local$it = it_0;
  }
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0.prototype.constructor = Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0;
  Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$RadioGroupComponent.items.get_za3lpa$(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function RadioGroupComponent$render$lambda$lambda$lambda_2(this$RadioGroupComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$RadioGroupComponent$render$lambda$lambda$lambda_0(this$RadioGroupComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function RadioGroupComponent$render$lambda$lambda_0(this$RadioGroupComponent, closure$internalStore, closure$id, closure$groupName) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      var $receiver_0 = (tmp$_0 = (tmp$ = this$RadioGroupComponent.value) != null ? tmp$.data : null) != null ? tmp$_0 : this$RadioGroupComponent.selectedItem.values;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_11(unsafeTransform$lambda_10(map$lambda_8(RadioGroupComponent$render$lambda$lambda$lambda_1(this$RadioGroupComponent)), $receiver_0)), closure$internalStore.update);
      var $receiver_1 = withIndex(this$RadioGroupComponent.items);
      var tmp$_1;
      tmp$_1 = $receiver_1.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        var closure$internalStore_0 = closure$internalStore;
        var this$RadioGroupComponent_0 = this$RadioGroupComponent;
        var closure$id_0 = closure$id;
        var closure$groupName_0 = closure$groupName;
        var index = element.component1()
        , item = element.component2();
        var $receiver_2 = closure$internalStore_0.data;
        var checkedFlow = distinctUntilChanged(new unsafeFlow$ObjectLiteral_11(unsafeTransform$lambda_10(map$lambda_8(RadioGroupComponent$render$lambda$lambda$lambda$lambda(index)), $receiver_2)));
        radio($receiver, this$RadioGroupComponent_0.itemStyle.value, void 0, void 0, toString(closure$id_0) + '.' + index, void 0, RadioGroupComponent$render$lambda$lambda$lambda$lambda_0(this$RadioGroupComponent_0, closure$groupName_0, item, checkedFlow, index, closure$internalStore_0));
      }
      var $receiver_3 = closure$internalStore.toggle;
      var $receiver_4 = new RadioGroupComponent$EventsContext($receiver, new unsafeFlow$ObjectLiteral_11(unsafeTransform$lambda_10(map$lambda_8(RadioGroupComponent$render$lambda$lambda$lambda_2(this$RadioGroupComponent)), $receiver_3)));
      var this$RadioGroupComponent_1 = this$RadioGroupComponent;
      var tmp$_2;
      this$RadioGroupComponent_1.events.value($receiver_4);
      if ((tmp$_2 = this$RadioGroupComponent_1.value) != null) {
        $receiver_4.handledBy_ytah3h$($receiver_4.selected, tmp$_2.update);
      }this$RadioGroupComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  RadioGroupComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var internalStore = new SingleSelectionStore();
    var groupName = 'radioGroup-' + identification.Id.next_za3lpa$();
    return div_0(context, RadioGroupComponent$render$lambda$lambda(this), styling, baseClass, id, prefix, void 0, RadioGroupComponent$render$lambda$lambda_0(this, internalStore, id, groupName));
  };
  Object.defineProperty(RadioGroupComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_mrm99x$_0.disabled;
    }
  });
  Object.defineProperty(RadioGroupComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_mrm99x$_0.readonly;
    }
  });
  RadioGroupComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_mrm99x$_0.enabled_6taknv$(value);
  };
  RadioGroupComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_mrm99x$_0.enabled_433wua$(value);
  };
  Object.defineProperty(RadioGroupComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_mrm99x$_1.severity;
    }
  });
  RadioGroupComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_mrm99x$_1.severity_ietawi$(value);
  };
  RadioGroupComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_mrm99x$_1.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(RadioGroupComponent.prototype, 'orientation', {
    configurable: true,
    get: function () {
      return this.$delegate_mrm99x$_2.orientation;
    }
  });
  Object.defineProperty(RadioGroupComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_mrm99x$_3.renderTooltip;
    }
  });
  RadioGroupComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_mrm99x$_3.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  RadioGroupComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_mrm99x$_3.tooltip_h43rbb$(text, build);
  };
  function RadioGroupComponent$label$lambda(it) {
    return toString(it);
  }
  function RadioGroupComponent$labelRendering$lambda(this$RadioGroupComponent) {
    return function ($receiver, it) {
      $receiver.unaryPlus_pdl1vz$(this$RadioGroupComponent.label.value(it));
      return Unit;
    };
  }
  function RadioGroupComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().radio.sizes.normal;
  }
  function RadioGroupComponent$events$lambda($receiver) {
    return Unit;
  }
  RadioGroupComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RadioGroupComponent',
    interfaces: [TooltipProperties, OrientationProperty, SeverityProperties, InputFormProperties, Component]
  };
  function RadioComponent(value) {
    if (value === void 0)
      value = null;
    this.value = value;
    this.$delegate_msv89m$_0 = new EventMixin();
    this.$delegate_msv89m$_1 = new ElementMixin();
    this.$delegate_msv89m$_2 = new InputFormMixin();
    this.$delegate_msv89m$_3 = new SeverityMixin();
    this.$delegate_msv89m$_4 = new TooltipMixin();
    this.radioInputStaticCss_35pg84$_0 = style_0(trimIndent('\n' + '            position: absolute;' + '\n' + '            border: 0px;' + '\n' + '            clip: rect(0px, 0px, 0px, 0px);' + '\n' + '            height: 0px;' + '\n' + '            width: 0px;' + '\n' + '            overflow: hidden;' + '\n' + '            white-space: nowrap;' + '\n' + '            &:focus{' + '\n' + '                outline: none;' + '\n' + '            }' + '\n' + '            &:focus + label::before {' + '\n' + '                box-shadow: 0 0 1px ' + Theme.Companion.invoke().colors.gray700 + ';' + '\n' + '            }' + '\n' + '            &:disabled + label {' + '\n' + '                color: ' + Theme.Companion.invoke().colors.disabled + ';' + '\n' + '                cursor: not-allowed;' + '\n' + '            }' + '\n' + '            &:disabled + label::before {' + '\n' + '                opacity: 0.3;' + '\n' + '                cursor: not-allowed;' + '\n' + '                boxShadow: none;' + '\n' + '                color: ' + Theme.Companion.invoke().colors.disabled + ';' + '\n' + '            }' + '\n' + '        '), 'radioInput');
    this.size = new ComponentProperty(RadioComponent$size$lambda);
    this.label_ffqedq$_0 = null;
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().radio.label);
    this.selectedStyle = new ComponentProperty(Theme.Companion.invoke().radio.selected);
    this.selected = new DynamicComponentProperty(flowOf(false));
    this.groupName = new ComponentProperty(null);
  }
  function RadioComponent$label$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  RadioComponent.prototype.label_61zpoe$ = function (value) {
    this.label_ffqedq$_0 = RadioComponent$label$lambda(value);
  };
  function RadioComponent$label$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  RadioComponent.prototype.label_p81yox$ = function (value) {
    this.label_ffqedq$_0 = RadioComponent$label$lambda_0(value);
  };
  RadioComponent.prototype.label_wqyjv5$ = function (value) {
    this.label_ffqedq$_0 = value;
  };
  function RadioComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.inlineFlex;
  }
  function RadioComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.center;
  }
  function RadioComponent$render$lambda$lambda$lambda_1($receiver) {
    return $receiver.top;
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function RadioComponent$render$lambda$lambda$lambda_2($receiver) {
    $receiver.relative_dkjn9d$(RadioComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function RadioComponent$render$lambda$lambda(this$RadioComponent) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(RadioComponent$render$lambda$lambda$lambda);
      $receiver.alignItems_tsd917$(RadioComponent$render$lambda$lambda$lambda_0);
      $receiver.verticalAlign_qe4rxr$(RadioComponent$render$lambda$lambda$lambda_1);
      $receiver.css_61zpoe$('-webkit-box-align: center;');
      $receiver.invoke_qkhqzy$(this$RadioComponent.size.value(Theme.Companion.invoke().radio.sizes));
      $receiver.position_wp9r2r$(RadioComponent$render$lambda$lambda$lambda_2);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda_0(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$RadioComponent.selectedStyle.value);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_3(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().radio.input);
      $receiver.children_qlrppv$('&[checked] + div', RadioComponent$render$lambda$lambda$lambda$lambda_0(this$RadioComponent));
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_4(this$RadioComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      $receiver.disabled_f1igrw$(this$RadioComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$RadioComponent.readonly.values);
      $receiver.type_61zpoe$('radio');
      if ((tmp$ = this$RadioComponent.groupName.value) != null) {
        $receiver.name_61zpoe$(tmp$);
      }$receiver.checked_f1igrw$((tmp$_1 = (tmp$_0 = this$RadioComponent.value) != null ? tmp$_0.data : null) != null ? tmp$_1 : this$RadioComponent.selected.values);
      $receiver.value_61zpoe$('X');
      $receiver.className_p81yox$(get_name(this$RadioComponent.severityClassOf_i6436e$(Theme.Companion.invoke().radio.severity)));
      if ((tmp$_2 = this$RadioComponent.value) != null) {
        $receiver.handledBy_ytah3h$(states($receiver.changes), tmp$_2.update);
      }this$RadioComponent.events.value($receiver);
      this$RadioComponent.element.value($receiver);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_5(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().radio.default);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda_6($receiver) {
    return Unit;
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda_1(this$RadioComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$RadioComponent.labelStyle.value);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda$lambda$lambda_2(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function RadioComponent$render$lambda$lambda_0(closure$id, this$RadioComponent, closure$prefix, closure$styling) {
    return function ($receiver) {
      var tmp$;
      if (closure$id != null)
        $receiver.for_61zpoe$(closure$id);
      input($receiver, RadioComponent$render$lambda$lambda$lambda_3(this$RadioComponent), this$RadioComponent.radioInputStaticCss_35pg84$_0, closure$id, closure$prefix, void 0, RadioComponent$render$lambda$lambda$lambda_4(this$RadioComponent));
      div($receiver, RadioComponent$render$lambda$lambda$lambda_5(closure$styling), void 0, void 0, void 0, void 0, RadioComponent$render$lambda$lambda$lambda_6);
      if ((tmp$ = this$RadioComponent.label_ffqedq$_0) != null) {
        div($receiver, RadioComponent$render$lambda$lambda$lambda$lambda_1(this$RadioComponent), void 0, void 0, void 0, void 0, RadioComponent$render$lambda$lambda$lambda$lambda_2(tmp$));
      }this$RadioComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  RadioComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    return label(context, RadioComponent$render$lambda$lambda(this), baseClass, void 0, prefix, void 0, RadioComponent$render$lambda$lambda_0(id, this, prefix, styling));
  };
  Object.defineProperty(RadioComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_msv89m$_0.events;
    }
  });
  Object.defineProperty(RadioComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_msv89m$_1.element;
    }
  });
  Object.defineProperty(RadioComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_msv89m$_2.disabled;
    }
  });
  Object.defineProperty(RadioComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_msv89m$_2.readonly;
    }
  });
  RadioComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_msv89m$_2.enabled_6taknv$(value);
  };
  RadioComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_msv89m$_2.enabled_433wua$(value);
  };
  Object.defineProperty(RadioComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_msv89m$_3.severity;
    }
  });
  RadioComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_msv89m$_3.severity_ietawi$(value);
  };
  RadioComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_msv89m$_3.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(RadioComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_msv89m$_4.renderTooltip;
    }
  });
  RadioComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_msv89m$_4.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  RadioComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_msv89m$_4.tooltip_h43rbb$(text, build);
  };
  function RadioComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().radio.sizes.normal;
  }
  RadioComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RadioComponent',
    interfaces: [TooltipProperties, SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function selectField$lambda($receiver) {
    return Unit;
  }
  function selectField($receiver, styling, items, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = selectField$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'selectField';
    var $receiver_0 = new SelectFieldComponent(items, value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_12(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_12($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_12.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_12.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_12.prototype.constructor = Coroutine$collect_42ocv1$_12;
  Coroutine$collect_42ocv1$_12.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_12.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_12(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_12.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_11(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_11.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_11.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_11.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_11;
  Coroutine$unsafeTransform$lambda$lambda_11.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_11(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_11(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_11(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_11.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_11.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_11.prototype.constructor = Coroutine$unsafeTransform$lambda_11;
  Coroutine$unsafeTransform$lambda_11.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_11(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_11(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_11(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_9(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_9.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_9.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_9.prototype.constructor = Coroutine$map$lambda_9;
  Coroutine$map$lambda_9.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_9(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_9(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent(items, value) {
    SelectFieldComponent$Companion_getInstance();
    if (value === void 0)
      value = null;
    this.items = items;
    this.value = value;
    this.$delegate_nr9a81$_0 = new InputFormMixin();
    this.$delegate_nr9a81$_1 = new SeverityMixin();
    this.$delegate_nr9a81$_2 = new TooltipMixin();
    this.iconWrapperStyle = SelectFieldComponent$iconWrapperStyle$lambda;
    this.iconStyle = SelectFieldComponent$iconStyle$lambda;
    this.placeholder = new ComponentProperty('...');
    this.variant = new ComponentProperty(SelectFieldComponent$variant$lambda);
    this.label = new ComponentProperty(SelectFieldComponent$label$lambda);
    this.size = new ComponentProperty(SelectFieldComponent$size$lambda);
    this.icon = new ComponentProperty(SelectFieldComponent$icon$lambda);
    this.selectedItem = new NullableDynamicComponentProperty(emptyFlow());
    this.events = new ComponentProperty(SelectFieldComponent$events$lambda);
  }
  function SelectFieldComponent$Companion() {
    SelectFieldComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('selectFieldContainer', trimIndent('\n                  width: 100%;\n                  height: fit-content;\n                  position: relative;\n                  outline:none;\n                  appearance:none;\n                  -webkit-appearance: none;\n              '));
    this.staticCssSelect = staticStyle_0('selectFieldContainer', trimIndent('\n                  -webkit-appearance: none;            \n            '));
  }
  SelectFieldComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SelectFieldComponent$Companion_instance = null;
  function SelectFieldComponent$Companion_getInstance() {
    if (SelectFieldComponent$Companion_instance === null) {
      new SelectFieldComponent$Companion();
    }return SelectFieldComponent$Companion_instance;
  }
  function SelectFieldComponent$EventsContext(element, selected) {
    this.element_0 = element;
    this.selected = selected;
  }
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'aborts', {
    configurable: true,
    get: function () {
      return this.element_0.aborts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'afterprints', {
    configurable: true,
    get: function () {
      return this.element_0.afterprints;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'beforeprints', {
    configurable: true,
    get: function () {
      return this.element_0.beforeprints;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'beforeunloads', {
    configurable: true,
    get: function () {
      return this.element_0.beforeunloads;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'blurs', {
    configurable: true,
    get: function () {
      return this.element_0.blurs;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'canplays', {
    configurable: true,
    get: function () {
      return this.element_0.canplays;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'canplaythroughs', {
    configurable: true,
    get: function () {
      return this.element_0.canplaythroughs;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'changes', {
    configurable: true,
    get: function () {
      return this.element_0.changes;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'clicks', {
    configurable: true,
    get: function () {
      return this.element_0.clicks;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'contextmenus', {
    configurable: true,
    get: function () {
      return this.element_0.contextmenus;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'copys', {
    configurable: true,
    get: function () {
      return this.element_0.copys;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'cuts', {
    configurable: true,
    get: function () {
      return this.element_0.cuts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'dblclicks', {
    configurable: true,
    get: function () {
      return this.element_0.dblclicks;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'domNode', {
    configurable: true,
    get: function () {
      return this.element_0.domNode;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'dragends', {
    configurable: true,
    get: function () {
      return this.element_0.dragends;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'dragenters', {
    configurable: true,
    get: function () {
      return this.element_0.dragenters;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'dragleaves', {
    configurable: true,
    get: function () {
      return this.element_0.dragleaves;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'dragovers', {
    configurable: true,
    get: function () {
      return this.element_0.dragovers;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'drags', {
    configurable: true,
    get: function () {
      return this.element_0.drags;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'dragstarts', {
    configurable: true,
    get: function () {
      return this.element_0.dragstarts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'drops', {
    configurable: true,
    get: function () {
      return this.element_0.drops;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'durationchanges', {
    configurable: true,
    get: function () {
      return this.element_0.durationchanges;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'endeds', {
    configurable: true,
    get: function () {
      return this.element_0.endeds;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'focusins', {
    configurable: true,
    get: function () {
      return this.element_0.focusins;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'focusouts', {
    configurable: true,
    get: function () {
      return this.element_0.focusouts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'focuss', {
    configurable: true,
    get: function () {
      return this.element_0.focuss;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'fullscreenchanges', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenchanges;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'fullscreenerrors', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenerrors;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'hashchanges', {
    configurable: true,
    get: function () {
      return this.element_0.hashchanges;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'inputs', {
    configurable: true,
    get: function () {
      return this.element_0.inputs;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'invalids', {
    configurable: true,
    get: function () {
      return this.element_0.invalids;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'job', {
    configurable: true,
    get: function () {
      return this.element_0.job;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'keydowns', {
    configurable: true,
    get: function () {
      return this.element_0.keydowns;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'keypresss', {
    configurable: true,
    get: function () {
      return this.element_0.keypresss;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'keyups', {
    configurable: true,
    get: function () {
      return this.element_0.keyups;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'loadeddatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadeddatas;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'loadedmetadatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadedmetadatas;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'loads', {
    configurable: true,
    get: function () {
      return this.element_0.loads;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'loadstarts', {
    configurable: true,
    get: function () {
      return this.element_0.loadstarts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'messages', {
    configurable: true,
    get: function () {
      return this.element_0.messages;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mousedowns', {
    configurable: true,
    get: function () {
      return this.element_0.mousedowns;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mouseenters', {
    configurable: true,
    get: function () {
      return this.element_0.mouseenters;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mouseleaves', {
    configurable: true,
    get: function () {
      return this.element_0.mouseleaves;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mousemoves', {
    configurable: true,
    get: function () {
      return this.element_0.mousemoves;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mouseouts', {
    configurable: true,
    get: function () {
      return this.element_0.mouseouts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mouseovers', {
    configurable: true,
    get: function () {
      return this.element_0.mouseovers;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'mouseups', {
    configurable: true,
    get: function () {
      return this.element_0.mouseups;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'offlines', {
    configurable: true,
    get: function () {
      return this.element_0.offlines;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'onlines', {
    configurable: true,
    get: function () {
      return this.element_0.onlines;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'opens', {
    configurable: true,
    get: function () {
      return this.element_0.opens;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'pagehides', {
    configurable: true,
    get: function () {
      return this.element_0.pagehides;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'pageshows', {
    configurable: true,
    get: function () {
      return this.element_0.pageshows;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'pastes', {
    configurable: true,
    get: function () {
      return this.element_0.pastes;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'pauses', {
    configurable: true,
    get: function () {
      return this.element_0.pauses;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'playings', {
    configurable: true,
    get: function () {
      return this.element_0.playings;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'plays', {
    configurable: true,
    get: function () {
      return this.element_0.plays;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'popstates', {
    configurable: true,
    get: function () {
      return this.element_0.popstates;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'progresss', {
    configurable: true,
    get: function () {
      return this.element_0.progresss;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'ratechanges', {
    configurable: true,
    get: function () {
      return this.element_0.ratechanges;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'resets', {
    configurable: true,
    get: function () {
      return this.element_0.resets;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'resizes', {
    configurable: true,
    get: function () {
      return this.element_0.resizes;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'scrolls', {
    configurable: true,
    get: function () {
      return this.element_0.scrolls;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'searchs', {
    configurable: true,
    get: function () {
      return this.element_0.searchs;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'seekeds', {
    configurable: true,
    get: function () {
      return this.element_0.seekeds;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'seekings', {
    configurable: true,
    get: function () {
      return this.element_0.seekings;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'selects', {
    configurable: true,
    get: function () {
      return this.element_0.selects;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'shows', {
    configurable: true,
    get: function () {
      return this.element_0.shows;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'stalleds', {
    configurable: true,
    get: function () {
      return this.element_0.stalleds;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'storages', {
    configurable: true,
    get: function () {
      return this.element_0.storages;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'submits', {
    configurable: true,
    get: function () {
      return this.element_0.submits;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'suspends', {
    configurable: true,
    get: function () {
      return this.element_0.suspends;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'timeupdates', {
    configurable: true,
    get: function () {
      return this.element_0.timeupdates;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'toggles', {
    configurable: true,
    get: function () {
      return this.element_0.toggles;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'touchcancels', {
    configurable: true,
    get: function () {
      return this.element_0.touchcancels;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'touchends', {
    configurable: true,
    get: function () {
      return this.element_0.touchends;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'touchmoves', {
    configurable: true,
    get: function () {
      return this.element_0.touchmoves;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'touchstarts', {
    configurable: true,
    get: function () {
      return this.element_0.touchstarts;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'unloads', {
    configurable: true,
    get: function () {
      return this.element_0.unloads;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'volumechanges', {
    configurable: true,
    get: function () {
      return this.element_0.volumechanges;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'waitings', {
    configurable: true,
    get: function () {
      return this.element_0.waitings;
    }
  });
  Object.defineProperty(SelectFieldComponent$EventsContext.prototype, 'wheels', {
    configurable: true,
    get: function () {
      return this.element_0.wheels;
    }
  });
  SelectFieldComponent$EventsContext.prototype.handledBy_jora5j$ = function ($receiver, handler) {
    return this.element_0.handledBy_jora5j$($receiver, handler);
  };
  SelectFieldComponent$EventsContext.prototype.handledBy_lesqyu$ = function ($receiver, execute) {
    return this.element_0.handledBy_lesqyu$($receiver, execute);
  };
  SelectFieldComponent$EventsContext.prototype.handledBy_hlmqex$ = function ($receiver, handler) {
    return this.element_0.handledBy_hlmqex$($receiver, handler);
  };
  SelectFieldComponent$EventsContext.prototype.handledBy_uhegz2$ = function ($receiver, execute) {
    return this.element_0.handledBy_uhegz2$($receiver, execute);
  };
  SelectFieldComponent$EventsContext.prototype.handledBy_ytah3h$ = function ($receiver, handler) {
    return this.element_0.handledBy_ytah3h$($receiver, handler);
  };
  SelectFieldComponent$EventsContext.prototype.handledBy_706ovd$ = function ($receiver, execute) {
    return this.element_0.handledBy_706ovd$($receiver, execute);
  };
  SelectFieldComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: [EventContext]
  };
  function Coroutine$SelectFieldComponent$render$lambda$lambda(this$SelectFieldComponent_0, selectedItem_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$SelectFieldComponent = this$SelectFieldComponent_0;
    this.local$selectedItem = selectedItem_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var it = indexOf_0(this.local$this$SelectFieldComponent.items, this.local$selectedItem);
            return it === -1 ? null : it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda(this$SelectFieldComponent_0) {
    return function (selectedItem_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda(this$SelectFieldComponent_0, selectedItem_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.variant.value(Theme.Companion.invoke().select.variants));
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.size.value(Theme.Companion.invoke().select.sizes));
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.value_61zpoe$('null');
      $receiver.selected_8kj6y5$(true);
      $receiver.unaryPlus_pdl1vz$(this$SelectFieldComponent.placeholder.value);
      return Unit;
    };
  }
  function Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$index = closure$index_0;
    this.local$it = it_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it === this.local$closure$index;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(closure$index_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(closure$index, closure$checkedFlow, this$SelectFieldComponent, closure$item) {
    return function ($receiver) {
      $receiver.value_61zpoe$(closure$index.toString());
      $receiver.selected_f1igrw$(closure$checkedFlow);
      $receiver.unaryPlus_pdl1vz$(this$SelectFieldComponent.label.value(closure$item));
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda(this$SelectFieldComponent, closure$internalStore) {
    return function ($receiver, it) {
      if (it == null) {
        $receiver.option_m0do7u$(void 0, void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda(this$SelectFieldComponent));
      }var $receiver_0 = withIndex(this$SelectFieldComponent.items);
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var closure$internalStore_0 = closure$internalStore;
        var this$SelectFieldComponent_0 = this$SelectFieldComponent;
        var index = element.component1()
        , item = element.component2();
        var $receiver_1 = closure$internalStore_0.data;
        var checkedFlow = distinctUntilChanged(new unsafeFlow$ObjectLiteral_12(unsafeTransform$lambda_11(map$lambda_9(SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(index)), $receiver_1)));
        $receiver.option_m0do7u$(void 0, void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(index, checkedFlow, this$SelectFieldComponent_0, item));
      }
      return Unit;
    };
  }
  function Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return toInt(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SelectFieldComponent$render$lambda$lambda$lambda_0(this$SelectFieldComponent, closure$internalStore) {
    return function ($receiver) {
      $receiver.disabled_f1igrw$(this$SelectFieldComponent.disabled.values);
      $receiver.render_a5p5o5$(closure$internalStore.data, $receiver, SelectFieldComponent$render$lambda$lambda$lambda$lambda(this$SelectFieldComponent, closure$internalStore));
      $receiver.className_p81yox$(get_name(this$SelectFieldComponent.severityClassOf_i6436e$(Theme.Companion.invoke().select.severity)));
      var $receiver_0 = selectedValue($receiver.changes);
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_12(unsafeTransform$lambda_11(map$lambda_9(SelectFieldComponent$render$lambda$lambda$lambda$lambda_0), $receiver_0)), closure$internalStore.toggle);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda_1(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.size.value(Theme.Companion.invoke().select.sizes));
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.iconWrapperStyle);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda_1(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SelectFieldComponent.iconStyle);
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda$lambda_2(this$SelectFieldComponent) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(this$SelectFieldComponent.icon.value(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function SelectFieldComponent$render$lambda$lambda$lambda_2(this$SelectFieldComponent) {
    return function ($receiver) {
      icon($receiver, SelectFieldComponent$render$lambda$lambda$lambda$lambda_1(this$SelectFieldComponent), void 0, void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda$lambda_2(this$SelectFieldComponent));
      return Unit;
    };
  }
  function Coroutine$SelectFieldComponent$render$lambda$lambda$lambda(this$SelectFieldComponent_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$SelectFieldComponent = this$SelectFieldComponent_0;
    this.local$it = it_0;
  }
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda.prototype.constructor = Coroutine$SelectFieldComponent$render$lambda$lambda$lambda;
  Coroutine$SelectFieldComponent$render$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$SelectFieldComponent.items.get_za3lpa$(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SelectFieldComponent$render$lambda$lambda$lambda_3(this$SelectFieldComponent_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$SelectFieldComponent$render$lambda$lambda$lambda(this$SelectFieldComponent_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function SelectFieldComponent$render$lambda$lambda_0(this$SelectFieldComponent, closure$styling, closure$baseClass, closure$id, closure$internalStore) {
    return function ($receiver) {
      select($receiver, SelectFieldComponent$render$lambda$lambda$lambda(this$SelectFieldComponent), closure$styling, closure$baseClass.plus_fox8kt$(SelectFieldComponent$Companion_getInstance().staticCssSelect), closure$id, void 0, void 0, SelectFieldComponent$render$lambda$lambda$lambda_0(this$SelectFieldComponent, closure$internalStore));
      div($receiver, SelectFieldComponent$render$lambda$lambda$lambda_1(this$SelectFieldComponent), void 0, void 0, 'icon-wrapper', void 0, SelectFieldComponent$render$lambda$lambda$lambda_2(this$SelectFieldComponent));
      var $receiver_0 = closure$internalStore.toggle;
      var $receiver_1 = new SelectFieldComponent$EventsContext($receiver, new unsafeFlow$ObjectLiteral_12(unsafeTransform$lambda_11(map$lambda_9(SelectFieldComponent$render$lambda$lambda$lambda_3(this$SelectFieldComponent)), $receiver_0)));
      var this$SelectFieldComponent_0 = this$SelectFieldComponent;
      var tmp$;
      this$SelectFieldComponent_0.events.value($receiver_1);
      if ((tmp$ = this$SelectFieldComponent_0.value) != null) {
        $receiver_1.handledBy_ytah3h$($receiver_1.selected, tmp$.update);
      }this$SelectFieldComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  SelectFieldComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var internalStore = new SingleSelectionStore();
    var tmp$, tmp$_0;
    var $receiver = (tmp$_0 = (tmp$ = this.value) != null ? tmp$.data : null) != null ? tmp$_0 : this.selectedItem.values;
    context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_12(unsafeTransform$lambda_11(map$lambda_9(SelectFieldComponent$render$lambda$lambda(this)), $receiver)), internalStore.update);
    return label(context, styling, baseClass.plus_fox8kt$(SelectFieldComponent$Companion_getInstance().staticCss), id, prefix, void 0, SelectFieldComponent$render$lambda$lambda_0(this, styling, baseClass, id, internalStore));
  };
  Object.defineProperty(SelectFieldComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_nr9a81$_0.disabled;
    }
  });
  Object.defineProperty(SelectFieldComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_nr9a81$_0.readonly;
    }
  });
  SelectFieldComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_nr9a81$_0.enabled_6taknv$(value);
  };
  SelectFieldComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_nr9a81$_0.enabled_433wua$(value);
  };
  Object.defineProperty(SelectFieldComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_nr9a81$_1.severity;
    }
  });
  SelectFieldComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_nr9a81$_1.severity_ietawi$(value);
  };
  SelectFieldComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_nr9a81$_1.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(SelectFieldComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_nr9a81$_2.renderTooltip;
    }
  });
  SelectFieldComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_nr9a81$_2.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  SelectFieldComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_nr9a81$_2.tooltip_h43rbb$(text, build);
  };
  function SelectFieldComponent$iconWrapperStyle$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda$lambda($receiver) {
    $receiver.absolute_dkjn9d$(SelectFieldComponent$iconWrapperStyle$lambda$lambda$lambda);
    return Unit;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda$lambda_0($receiver) {
    return $receiver.inlineFlex;
  }
  function SelectFieldComponent$iconWrapperStyle$lambda($receiver) {
    $receiver.position_wp9r2r$(SelectFieldComponent$iconWrapperStyle$lambda$lambda);
    $receiver.display_1gh9wc$(SelectFieldComponent$iconWrapperStyle$lambda$lambda_0);
    $receiver.css_61zpoe$('-webkit-box-align: center;');
    $receiver.css_61zpoe$('align-items: center;');
    $receiver.css_61zpoe$('-webkit-box-pack: center;');
    $receiver.css_61zpoe$('justify-content: center;');
    $receiver.css_61zpoe$('right: 0.5rem;');
    $receiver.css_61zpoe$('pointer-events: none;');
    $receiver.css_61zpoe$('top: 50%;');
    $receiver.css_61zpoe$('transform: translateY(-50%);');
    return Unit;
  }
  function SelectFieldComponent$iconStyle$lambda$lambda($receiver) {
    return 'var(--select-icon-size)';
  }
  function SelectFieldComponent$iconStyle$lambda($receiver) {
    $receiver.height_wpghq5$(SelectFieldComponent$iconStyle$lambda$lambda);
    return Unit;
  }
  function SelectFieldComponent$variant$lambda($receiver) {
    return $receiver.outline;
  }
  function SelectFieldComponent$label$lambda(it) {
    return toString(it);
  }
  function SelectFieldComponent$size$lambda($receiver) {
    return $receiver.normal;
  }
  function SelectFieldComponent$icon$lambda($receiver) {
    return $receiver.chevronDown;
  }
  function SelectFieldComponent$events$lambda($receiver) {
    return Unit;
  }
  SelectFieldComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SelectFieldComponent',
    interfaces: [TooltipProperties, SeverityProperties, InputFormProperties, Component]
  };
  function slider$lambda($receiver) {
    return Unit;
  }
  function slider$lambda_0($receiver) {
    return Unit;
  }
  function slider($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = slider$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'slider';
    if (build === void 0)
      build = slider$lambda_0;
    var $receiver_0 = new SliderComponent(value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function slider$lambda_1($receiver) {
    return Unit;
  }
  function slider$lambda_2($receiver) {
    return Unit;
  }
  function slider_0($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = slider$lambda_1;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'slider';
    if (build === void 0)
      build = slider$lambda_2;
    var $receiver_0 = new SliderComponent();
    build($receiver_0);
    $receiver_0.value.invoke_11rb$(value);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_13(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_13($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_13.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_13.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_13.prototype.constructor = Coroutine$collect_42ocv1$_13;
  Coroutine$collect_42ocv1$_13.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_13.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_13(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_13.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_12(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_12.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_12.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_12.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_12;
  Coroutine$unsafeTransform$lambda$lambda_12.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_12(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_12(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_12(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_12.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_12.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_12.prototype.constructor = Coroutine$unsafeTransform$lambda_12;
  Coroutine$unsafeTransform$lambda_12.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_12(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_12(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_12(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$filter$lambda_0(closure$predicate_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$predicate = closure$predicate_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$filter$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$filter$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$filter$lambda_0.prototype.constructor = Coroutine$filter$lambda_0;
  Coroutine$filter$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$predicate(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.result_0) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(this.local$value, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            return Unit;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function filter$lambda_0(closure$predicate_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$filter$lambda_0(closure$predicate_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_14(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_14($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_14.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_14.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_14.prototype.constructor = Coroutine$collect_42ocv1$_14;
  Coroutine$collect_42ocv1$_14.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_14.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_14(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_14.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_13(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_13.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_13.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_13.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_13;
  Coroutine$unsafeTransform$lambda$lambda_13.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_13(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_13(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_13(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_13.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_13.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_13.prototype.constructor = Coroutine$unsafeTransform$lambda_13;
  Coroutine$unsafeTransform$lambda_13.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_13(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_13(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_13(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_10(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_10.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_10.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_10.prototype.constructor = Coroutine$map$lambda_10;
  Coroutine$map$lambda_10.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_10(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_10(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_15(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_15($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_15.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_15.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_15.prototype.constructor = Coroutine$collect_42ocv1$_15;
  Coroutine$collect_42ocv1$_15.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_15.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_15(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_15.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_14(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_14.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_14.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_14.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_14;
  Coroutine$unsafeTransform$lambda$lambda_14.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_14(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_14(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_14(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_14.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_14.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_14.prototype.constructor = Coroutine$unsafeTransform$lambda_14;
  Coroutine$unsafeTransform$lambda_14.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_14(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_14(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_14(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$mapNotNull$lambda_0(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$tmp$ = void 0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$mapNotNull$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$mapNotNull$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$mapNotNull$lambda_0.prototype.constructor = Coroutine$mapNotNull$lambda_0;
  Coroutine$mapNotNull$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            if (this.local$tmp$ == null) {
              return;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            var transformed = this.local$tmp$;
            this.state_0 = 4;
            this.result_0 = this.local$$receiver.emit_11rb$(transformed, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function mapNotNull$lambda_0(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$mapNotNull$lambda_0(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Progress(percent, value) {
    if (percent === void 0)
      percent = 0;
    if (value === void 0)
      value = 0;
    this.percent = percent;
    this.value = value;
  }
  Progress.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Progress',
    interfaces: []
  };
  Progress.prototype.component1 = function () {
    return this.percent;
  };
  Progress.prototype.component2 = function () {
    return this.value;
  };
  Progress.prototype.copy_vux9f0$ = function (percent, value) {
    return new Progress(percent === void 0 ? this.percent : percent, value === void 0 ? this.value : value);
  };
  Progress.prototype.toString = function () {
    return 'Progress(percent=' + Kotlin.toString(this.percent) + (', value=' + Kotlin.toString(this.value)) + ')';
  };
  Progress.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.percent) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  Progress.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.percent, other.percent) && Kotlin.equals(this.value, other.value)))));
  };
  function Direction(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Direction_initFields() {
    Direction_initFields = function () {
    };
    Direction$UP_instance = new Direction('UP', 0);
    Direction$DOWN_instance = new Direction('DOWN', 1);
  }
  var Direction$UP_instance;
  function Direction$UP_getInstance() {
    Direction_initFields();
    return Direction$UP_instance;
  }
  var Direction$DOWN_instance;
  function Direction$DOWN_getInstance() {
    Direction_initFields();
    return Direction$DOWN_instance;
  }
  Direction.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Direction',
    interfaces: [Enum]
  };
  function Direction$values() {
    return [Direction$UP_getInstance(), Direction$DOWN_getInstance()];
  }
  Direction.values = Direction$values;
  function Direction$valueOf(name) {
    switch (name) {
      case 'UP':
        return Direction$UP_getInstance();
      case 'DOWN':
        return Direction$DOWN_getInstance();
      default:throwISE('No enum constant dev.fritz2.components.slider.Direction.' + name);
    }
  }
  Direction.valueOf_61zpoe$ = Direction$valueOf;
  function State_0(progress, movementTracking, interactive) {
    if (progress === void 0)
      progress = new Progress();
    if (movementTracking === void 0)
      movementTracking = false;
    if (interactive === void 0)
      interactive = true;
    this.progress = progress;
    this.movementTracking = movementTracking;
    this.interactive = interactive;
  }
  State_0.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'State',
    interfaces: []
  };
  State_0.prototype.component1 = function () {
    return this.progress;
  };
  State_0.prototype.component2 = function () {
    return this.movementTracking;
  };
  State_0.prototype.component3 = function () {
    return this.interactive;
  };
  State_0.prototype.copy_84xb48$ = function (progress, movementTracking, interactive) {
    return new State_0(progress === void 0 ? this.progress : progress, movementTracking === void 0 ? this.movementTracking : movementTracking, interactive === void 0 ? this.interactive : interactive);
  };
  State_0.prototype.toString = function () {
    return 'State(progress=' + Kotlin.toString(this.progress) + (', movementTracking=' + Kotlin.toString(this.movementTracking)) + (', interactive=' + Kotlin.toString(this.interactive)) + ')';
  };
  State_0.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.progress) | 0;
    result = result * 31 + Kotlin.hashCode(this.movementTracking) | 0;
    result = result * 31 + Kotlin.hashCode(this.interactive) | 0;
    return result;
  };
  State_0.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.progress, other.progress) && Kotlin.equals(this.movementTracking, other.movementTracking) && Kotlin.equals(this.interactive, other.interactive)))));
  };
  function Range(lower, upper, step) {
    if (lower === void 0)
      lower = 0;
    if (upper === void 0)
      upper = 100;
    if (step === void 0)
      step = 1;
    this.lower = lower;
    this.upper = upper;
    this.step = step;
    if (!(this.upper > this.lower)) {
      var message = 'upper bound must greater than lower bound!';
      throw IllegalArgumentException_init(message.toString());
    }if (!(this.step > 0)) {
      var message_0 = 'step must be positive!';
      throw IllegalArgumentException_init(message_0.toString());
    }this.distance = this.upper - this.lower | 0;
  }
  Range.prototype.absolute_za3lpa$ = function (value) {
    return 0 - this.lower + value | 0;
  };
  Range.prototype.ranged_za3lpa$ = function (value) {
    return this.lower + value | 0;
  };
  Range.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Range',
    interfaces: []
  };
  Range.prototype.component1 = function () {
    return this.lower;
  };
  Range.prototype.component2 = function () {
    return this.upper;
  };
  Range.prototype.component3 = function () {
    return this.step;
  };
  Range.prototype.copy_qt1dr2$ = function (lower, upper, step) {
    return new Range(lower === void 0 ? this.lower : lower, upper === void 0 ? this.upper : upper, step === void 0 ? this.step : step);
  };
  Range.prototype.toString = function () {
    return 'Range(lower=' + Kotlin.toString(this.lower) + (', upper=' + Kotlin.toString(this.upper)) + (', step=' + Kotlin.toString(this.step)) + ')';
  };
  Range.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lower) | 0;
    result = result * 31 + Kotlin.hashCode(this.upper) | 0;
    result = result * 31 + Kotlin.hashCode(this.step) | 0;
    return result;
  };
  Range.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lower, other.lower) && Kotlin.equals(this.upper, other.upper) && Kotlin.equals(this.step, other.step)))));
  };
  function StateStore_0(range, orientation, initialData) {
    RootStore.call(this, initialData);
    this.range_0 = range;
    this.orientation_0 = orientation;
    this.sliderElement_ez2ibi$_0 = this.sliderElement_ez2ibi$_0;
    var $receiver = this.data;
    var $receiver_0 = new unsafeFlow$ObjectLiteral_13(unsafeTransform$lambda_12(filter$lambda_0(StateStore$value$lambda), $receiver));
    this.value = new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(StateStore$value$lambda_0), $receiver_0));
    var $receiver_1 = this.data;
    this.currentValue = new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(StateStore$currentValue$lambda), $receiver_1));
    this.updateInteractive = this.handle_ajdi87$(void 0, StateStore$updateInteractive$lambda);
    this.updateMovementTracking = this.handle_ajdi87$(void 0, StateStore$updateMovementTracking$lambda);
    this.updateByValue = this.handle_ajdi87$(void 0, StateStore$updateByValue$lambda(this));
    this.updateByKeystroke = this.handle_ajdi87$(void 0, StateStore$updateByKeystroke$lambda(this));
    this.updateByClick = this.handle_ajdi87$(void 0, StateStore$updateByClick$lambda(this));
    this.updateByMovement = this.handle_ajdi87$(void 0, StateStore$updateByMovement$lambda(this));
    this.updateByValue.invoke_11rb$(this.current.progress.value);
  }
  Object.defineProperty(StateStore_0.prototype, 'sliderElement', {
    configurable: true,
    get: function () {
      if (this.sliderElement_ez2ibi$_0 == null)
        return throwUPAE('sliderElement');
      return this.sliderElement_ez2ibi$_0;
    },
    set: function (sliderElement) {
      this.sliderElement_ez2ibi$_0 = sliderElement;
    }
  });
  StateStore_0.prototype.updateSliderByValue_0 = function (state, newValue) {
    var tmp$;
    var rangedNewValue = this.range_0.ranged_za3lpa$(newValue);
    if (rangedNewValue >= this.range_0.lower && rangedNewValue <= this.range_0.upper) {
      var percent = (newValue * 100 | 0) / this.range_0.distance | 0;
      tmp$ = state.copy_84xb48$(new Progress(percent, rangedNewValue));
    } else
      tmp$ = state;
    return tmp$;
  };
  StateStore_0.prototype.updateSliderByUi_0 = function (state, event) {
    var tmp$;
    if (state.interactive) {
      var containerRect = this.sliderElement.domNode.getBoundingClientRect();
      var percentage = this.percentageFromRect_0(containerRect, event);
      if (percentage === state.progress.percent) {
        tmp$ = state;
      } else {
        tmp$ = state.copy_84xb48$(this.nextProgress_0(percentage, percentage > state.progress.percent ? Direction$UP_getInstance() : Direction$DOWN_getInstance()));
      }
    } else
      tmp$ = state;
    return tmp$;
  };
  StateStore_0.prototype.percentageFromRect_0 = function (containerRect, event) {
    switch (this.orientation_0.name) {
      case 'HORIZONTAL':
        var offset = numberToInt(containerRect.left);
        var a = event.clientX;
        var b = numberToInt(containerRect.right);
        var b_0 = JsMath.min(a, b) - offset | 0;
        var positionAbsolute = JsMath.max(0, b_0);
        var percentage = (positionAbsolute * 100 | 0) / numberToInt(containerRect.width) | 0;
        return percentage;
      case 'VERTICAL':
        var offset_0 = numberToInt(containerRect.top);
        var a_0 = event.clientY;
        var b_1 = numberToInt(containerRect.bottom);
        var b_2 = JsMath.min(a_0, b_1) - offset_0 | 0;
        var positionAbsolute_0 = JsMath.max(0, b_2);
        var percentage_0 = (positionAbsolute_0 * 100 | 0) / numberToInt(containerRect.height) | 0;
        return 100 - percentage_0 | 0;
      default:return Kotlin.noWhenBranchMatched();
    }
  };
  StateStore_0.prototype.nextProgress_0 = function (percent, direction) {
    var tmp$;
    var scaledValue = Kotlin.imul(this.range_0.distance, percent) / 100 | 0;
    var remainder = scaledValue % this.range_0.step;
    switch (direction.name) {
      case 'UP':
        tmp$ = scaledValue - remainder | 0;
        break;
      case 'DOWN':
        tmp$ = remainder > 0 ? scaledValue - remainder + this.range_0.step | 0 : scaledValue;
        break;
      default:tmp$ = Kotlin.noWhenBranchMatched();
        break;
    }
    var steppedValue = tmp$;
    var steppedPercentage = (steppedValue * 100 | 0) / this.range_0.distance | 0;
    return new Progress(steppedPercentage, this.range_0.ranged_za3lpa$(steppedValue));
  };
  function Coroutine$StateStore$value$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$StateStore$value$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$value$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$value$lambda.prototype.constructor = Coroutine$StateStore$value$lambda;
  Coroutine$StateStore$value$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it.movementTracking;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$value$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$StateStore$value$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$StateStore$value$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$StateStore$value$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$value$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$value$lambda_0.prototype.constructor = Coroutine$StateStore$value$lambda_0;
  Coroutine$StateStore$value$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.progress.value;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$value$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$StateStore$value$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$StateStore$currentValue$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$StateStore$currentValue$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$currentValue$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$currentValue$lambda.prototype.constructor = Coroutine$StateStore$currentValue$lambda;
  Coroutine$StateStore$currentValue$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.progress.value;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$currentValue$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$StateStore$currentValue$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$StateStore$updateInteractive$lambda(state_0, interactive_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$state = state_0;
    this.local$interactive = interactive_0;
  }
  Coroutine$StateStore$updateInteractive$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$updateInteractive$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$updateInteractive$lambda.prototype.constructor = Coroutine$StateStore$updateInteractive$lambda;
  Coroutine$StateStore$updateInteractive$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$state.copy_84xb48$(void 0, void 0, this.local$interactive);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$updateInteractive$lambda(state_0, interactive_0, continuation_0, suspended) {
    var instance = new Coroutine$StateStore$updateInteractive$lambda(state_0, interactive_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$StateStore$updateMovementTracking$lambda(value_0, tracking_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$value = value_0;
    this.local$tracking = tracking_0;
  }
  Coroutine$StateStore$updateMovementTracking$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$updateMovementTracking$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$updateMovementTracking$lambda.prototype.constructor = Coroutine$StateStore$updateMovementTracking$lambda;
  Coroutine$StateStore$updateMovementTracking$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$value.copy_84xb48$(void 0, this.local$tracking);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$updateMovementTracking$lambda(value_0, tracking_0, continuation_0, suspended) {
    var instance = new Coroutine$StateStore$updateMovementTracking$lambda(value_0, tracking_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$StateStore$updateByValue$lambda(this$StateStore_0, state_0, initialValue_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$StateStore = this$StateStore_0;
    this.local$state = state_0;
    this.local$initialValue = initialValue_0;
  }
  Coroutine$StateStore$updateByValue$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$updateByValue$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$updateByValue$lambda.prototype.constructor = Coroutine$StateStore$updateByValue$lambda;
  Coroutine$StateStore$updateByValue$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var $receiver = this.local$this$StateStore.range_0.absolute_za3lpa$(this.local$initialValue);
            var newValue = $receiver - $receiver % this.local$this$StateStore.range_0.step | 0;
            return this.local$this$StateStore.updateSliderByValue_0(this.local$state, newValue);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$updateByValue$lambda(this$StateStore_0) {
    return function (state_0, initialValue_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$updateByValue$lambda(this$StateStore_0, state_0, initialValue_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$StateStore$updateByKeystroke$lambda(this$StateStore_0, state_0, direction_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$StateStore = this$StateStore_0;
    this.local$state = state_0;
    this.local$direction = direction_0;
  }
  Coroutine$StateStore$updateByKeystroke$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$updateByKeystroke$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$updateByKeystroke$lambda.prototype.constructor = Coroutine$StateStore$updateByKeystroke$lambda;
  Coroutine$StateStore$updateByKeystroke$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            if (this.local$state.interactive) {
              tmp$_0 = this.local$this$StateStore.range_0.absolute_za3lpa$(this.local$state.progress.value);
              switch (this.local$direction.name) {
                case 'UP':
                  tmp$ = this.local$this$StateStore.range_0.step;
                  break;
                case 'DOWN':
                  tmp$ = -this.local$this$StateStore.range_0.step | 0;
                  break;
                default:tmp$ = Kotlin.noWhenBranchMatched();
                  break;
              }
              var newValue = tmp$_0 + tmp$ | 0;
              return this.local$this$StateStore.updateSliderByValue_0(this.local$state, newValue);
            } else
              return this.local$state;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$updateByKeystroke$lambda(this$StateStore_0) {
    return function (state_0, direction_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$updateByKeystroke$lambda(this$StateStore_0, state_0, direction_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$StateStore$updateByClick$lambda(this$StateStore_0, value_0, event_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$StateStore = this$StateStore_0;
    this.local$value = value_0;
    this.local$event = event_0;
  }
  Coroutine$StateStore$updateByClick$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$updateByClick$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$updateByClick$lambda.prototype.constructor = Coroutine$StateStore$updateByClick$lambda;
  Coroutine$StateStore$updateByClick$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$StateStore.updateSliderByUi_0(this.local$value, this.local$event);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$updateByClick$lambda(this$StateStore_0) {
    return function (value_0, event_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$updateByClick$lambda(this$StateStore_0, value_0, event_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$StateStore$updateByMovement$lambda(this$StateStore_0, value_0, event_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$StateStore = this$StateStore_0;
    this.local$value = value_0;
    this.local$event = event_0;
  }
  Coroutine$StateStore$updateByMovement$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$StateStore$updateByMovement$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$StateStore$updateByMovement$lambda.prototype.constructor = Coroutine$StateStore$updateByMovement$lambda;
  Coroutine$StateStore$updateByMovement$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$value.movementTracking ? this.local$this$StateStore.updateSliderByUi_0(this.local$value, this.local$event) : this.local$value;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function StateStore$updateByMovement$lambda(this$StateStore_0) {
    return function (value_0, event_0, continuation_0, suspended) {
      var instance = new Coroutine$StateStore$updateByMovement$lambda(this$StateStore_0, value_0, event_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  StateStore_0.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StateStore',
    interfaces: [RootStore]
  };
  function SliderComponent(store) {
    SliderComponent$Companion_getInstance();
    if (store === void 0)
      store = null;
    this.store = store;
    this.$delegate_44rvjz$_0 = new FormMixin();
    this.$delegate_44rvjz$_1 = new SeverityMixin();
    this.$delegate_44rvjz$_2 = new OrientationMixin(Orientation$HORIZONTAL_getInstance());
    this.$delegate_44rvjz$_3 = new TooltipMixin();
    this.range = new ComponentProperty(new Range());
    this.value = new NullableDynamicComponentProperty(emptyFlow());
    this.events = new ComponentProperty(SliderComponent$events$lambda);
    this.icon = new ComponentProperty(null);
    this.thumbStyle = new ComponentProperty(SliderComponent$thumbStyle$lambda);
    this.thumbContent = new ComponentProperty(SliderComponent$thumbContent$lambda(this));
    this.track = new ComponentProperty(SliderComponent$track$lambda);
    this.trackFilled = new ComponentProperty(SliderComponent$trackFilled$lambda);
    this.size = new ComponentProperty(SliderComponent$size$lambda);
  }
  function SliderComponent$Companion() {
    SliderComponent$Companion_instance = this;
    this.cssDataFocus = 'data-focus';
    this.cssDataDisabled = 'data-disabled';
  }
  SliderComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SliderComponent$Companion_instance = null;
  function SliderComponent$Companion_getInstance() {
    if (SliderComponent$Companion_instance === null) {
      new SliderComponent$Companion();
    }return SliderComponent$Companion_instance;
  }
  function SliderComponent$RangeContext() {
    this.lower = new ComponentProperty(0);
    this.upper = new ComponentProperty(100);
    this.step = new ComponentProperty(1);
  }
  SliderComponent$RangeContext.prototype.toRange = function () {
    return new Range(this.lower.value, this.upper.value, this.step.value);
  };
  SliderComponent$RangeContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RangeContext',
    interfaces: []
  };
  SliderComponent.prototype.range_870d76$ = function (expr) {
    var tmp$ = this.range;
    var $receiver = new SliderComponent$RangeContext();
    expr($receiver);
    tmp$.invoke_11rb$($receiver.toRange());
  };
  function SliderComponent$EventsContext(element, value, currentValue) {
    this.element_0 = element;
    this.value = value;
    this.currentValue = currentValue;
  }
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'aborts', {
    configurable: true,
    get: function () {
      return this.element_0.aborts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'afterprints', {
    configurable: true,
    get: function () {
      return this.element_0.afterprints;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'beforeprints', {
    configurable: true,
    get: function () {
      return this.element_0.beforeprints;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'beforeunloads', {
    configurable: true,
    get: function () {
      return this.element_0.beforeunloads;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'blurs', {
    configurable: true,
    get: function () {
      return this.element_0.blurs;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'canplays', {
    configurable: true,
    get: function () {
      return this.element_0.canplays;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'canplaythroughs', {
    configurable: true,
    get: function () {
      return this.element_0.canplaythroughs;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'changes', {
    configurable: true,
    get: function () {
      return this.element_0.changes;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'clicks', {
    configurable: true,
    get: function () {
      return this.element_0.clicks;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'contextmenus', {
    configurable: true,
    get: function () {
      return this.element_0.contextmenus;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'copys', {
    configurable: true,
    get: function () {
      return this.element_0.copys;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'cuts', {
    configurable: true,
    get: function () {
      return this.element_0.cuts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'dblclicks', {
    configurable: true,
    get: function () {
      return this.element_0.dblclicks;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'domNode', {
    configurable: true,
    get: function () {
      return this.element_0.domNode;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'dragends', {
    configurable: true,
    get: function () {
      return this.element_0.dragends;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'dragenters', {
    configurable: true,
    get: function () {
      return this.element_0.dragenters;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'dragleaves', {
    configurable: true,
    get: function () {
      return this.element_0.dragleaves;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'dragovers', {
    configurable: true,
    get: function () {
      return this.element_0.dragovers;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'drags', {
    configurable: true,
    get: function () {
      return this.element_0.drags;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'dragstarts', {
    configurable: true,
    get: function () {
      return this.element_0.dragstarts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'drops', {
    configurable: true,
    get: function () {
      return this.element_0.drops;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'durationchanges', {
    configurable: true,
    get: function () {
      return this.element_0.durationchanges;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'endeds', {
    configurable: true,
    get: function () {
      return this.element_0.endeds;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'focusins', {
    configurable: true,
    get: function () {
      return this.element_0.focusins;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'focusouts', {
    configurable: true,
    get: function () {
      return this.element_0.focusouts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'focuss', {
    configurable: true,
    get: function () {
      return this.element_0.focuss;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'fullscreenchanges', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenchanges;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'fullscreenerrors', {
    configurable: true,
    get: function () {
      return this.element_0.fullscreenerrors;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'hashchanges', {
    configurable: true,
    get: function () {
      return this.element_0.hashchanges;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'inputs', {
    configurable: true,
    get: function () {
      return this.element_0.inputs;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'invalids', {
    configurable: true,
    get: function () {
      return this.element_0.invalids;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'job', {
    configurable: true,
    get: function () {
      return this.element_0.job;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'keydowns', {
    configurable: true,
    get: function () {
      return this.element_0.keydowns;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'keypresss', {
    configurable: true,
    get: function () {
      return this.element_0.keypresss;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'keyups', {
    configurable: true,
    get: function () {
      return this.element_0.keyups;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'loadeddatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadeddatas;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'loadedmetadatas', {
    configurable: true,
    get: function () {
      return this.element_0.loadedmetadatas;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'loads', {
    configurable: true,
    get: function () {
      return this.element_0.loads;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'loadstarts', {
    configurable: true,
    get: function () {
      return this.element_0.loadstarts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'messages', {
    configurable: true,
    get: function () {
      return this.element_0.messages;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mousedowns', {
    configurable: true,
    get: function () {
      return this.element_0.mousedowns;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mouseenters', {
    configurable: true,
    get: function () {
      return this.element_0.mouseenters;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mouseleaves', {
    configurable: true,
    get: function () {
      return this.element_0.mouseleaves;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mousemoves', {
    configurable: true,
    get: function () {
      return this.element_0.mousemoves;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mouseouts', {
    configurable: true,
    get: function () {
      return this.element_0.mouseouts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mouseovers', {
    configurable: true,
    get: function () {
      return this.element_0.mouseovers;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'mouseups', {
    configurable: true,
    get: function () {
      return this.element_0.mouseups;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'offlines', {
    configurable: true,
    get: function () {
      return this.element_0.offlines;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'onlines', {
    configurable: true,
    get: function () {
      return this.element_0.onlines;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'opens', {
    configurable: true,
    get: function () {
      return this.element_0.opens;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'pagehides', {
    configurable: true,
    get: function () {
      return this.element_0.pagehides;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'pageshows', {
    configurable: true,
    get: function () {
      return this.element_0.pageshows;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'pastes', {
    configurable: true,
    get: function () {
      return this.element_0.pastes;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'pauses', {
    configurable: true,
    get: function () {
      return this.element_0.pauses;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'playings', {
    configurable: true,
    get: function () {
      return this.element_0.playings;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'plays', {
    configurable: true,
    get: function () {
      return this.element_0.plays;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'popstates', {
    configurable: true,
    get: function () {
      return this.element_0.popstates;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'progresss', {
    configurable: true,
    get: function () {
      return this.element_0.progresss;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'ratechanges', {
    configurable: true,
    get: function () {
      return this.element_0.ratechanges;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'resets', {
    configurable: true,
    get: function () {
      return this.element_0.resets;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'resizes', {
    configurable: true,
    get: function () {
      return this.element_0.resizes;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'scrolls', {
    configurable: true,
    get: function () {
      return this.element_0.scrolls;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'searchs', {
    configurable: true,
    get: function () {
      return this.element_0.searchs;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'seekeds', {
    configurable: true,
    get: function () {
      return this.element_0.seekeds;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'seekings', {
    configurable: true,
    get: function () {
      return this.element_0.seekings;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'selects', {
    configurable: true,
    get: function () {
      return this.element_0.selects;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'shows', {
    configurable: true,
    get: function () {
      return this.element_0.shows;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'stalleds', {
    configurable: true,
    get: function () {
      return this.element_0.stalleds;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'storages', {
    configurable: true,
    get: function () {
      return this.element_0.storages;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'submits', {
    configurable: true,
    get: function () {
      return this.element_0.submits;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'suspends', {
    configurable: true,
    get: function () {
      return this.element_0.suspends;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'timeupdates', {
    configurable: true,
    get: function () {
      return this.element_0.timeupdates;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'toggles', {
    configurable: true,
    get: function () {
      return this.element_0.toggles;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'touchcancels', {
    configurable: true,
    get: function () {
      return this.element_0.touchcancels;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'touchends', {
    configurable: true,
    get: function () {
      return this.element_0.touchends;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'touchmoves', {
    configurable: true,
    get: function () {
      return this.element_0.touchmoves;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'touchstarts', {
    configurable: true,
    get: function () {
      return this.element_0.touchstarts;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'unloads', {
    configurable: true,
    get: function () {
      return this.element_0.unloads;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'volumechanges', {
    configurable: true,
    get: function () {
      return this.element_0.volumechanges;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'waitings', {
    configurable: true,
    get: function () {
      return this.element_0.waitings;
    }
  });
  Object.defineProperty(SliderComponent$EventsContext.prototype, 'wheels', {
    configurable: true,
    get: function () {
      return this.element_0.wheels;
    }
  });
  SliderComponent$EventsContext.prototype.handledBy_jora5j$ = function ($receiver, handler) {
    return this.element_0.handledBy_jora5j$($receiver, handler);
  };
  SliderComponent$EventsContext.prototype.handledBy_lesqyu$ = function ($receiver, execute) {
    return this.element_0.handledBy_lesqyu$($receiver, execute);
  };
  SliderComponent$EventsContext.prototype.handledBy_hlmqex$ = function ($receiver, handler) {
    return this.element_0.handledBy_hlmqex$($receiver, handler);
  };
  SliderComponent$EventsContext.prototype.handledBy_uhegz2$ = function ($receiver, execute) {
    return this.element_0.handledBy_uhegz2$($receiver, execute);
  };
  SliderComponent$EventsContext.prototype.handledBy_ytah3h$ = function ($receiver, handler) {
    return this.element_0.handledBy_ytah3h$($receiver, handler);
  };
  SliderComponent$EventsContext.prototype.handledBy_706ovd$ = function ($receiver, execute) {
    return this.element_0.handledBy_706ovd$($receiver, execute);
  };
  SliderComponent$EventsContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EventsContext',
    interfaces: [EventContext]
  };
  function SliderComponent$thumb$lambda($receiver, it) {
    return Unit;
  }
  SliderComponent.prototype.thumb_bn8exz$ = function (styling, content) {
    if (styling === void 0)
      styling = SliderComponent$thumb$lambda;
    this.thumbStyle.invoke_11rb$(styling);
    this.thumbContent.invoke_11rb$(content);
  };
  function Coroutine$SliderComponent$render$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda;
  Coroutine$SliderComponent$render$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it != null ? this.local$it : 0;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$SliderComponent$render$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda_0.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda_0;
  Coroutine$SliderComponent$render$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SliderComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.full;
  }
  function SliderComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.full;
  }
  function SliderComponent$render$lambda$lambda_1(this$SliderComponent, closure$styling) {
    return function ($receiver) {
      switch (this$SliderComponent.orientation.value(OrientationContext_getInstance()).name) {
        case 'HORIZONTAL':
          $receiver.width_wpghq5$(SliderComponent$render$lambda$lambda$lambda);
          break;
        case 'VERTICAL':
          $receiver.height_wpghq5$(SliderComponent$render$lambda$lambda$lambda_0);
          break;
      }
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda_1(this$SliderComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SliderComponent.size.value(Theme.Companion.invoke().slider.sizes));
      this$SliderComponent.coreStyles_8aucc4$_0().main($receiver);
      return Unit;
    };
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.interactive ? 0 : -1;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0(this$_0, state_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ = this$_0;
    this.local$state = state_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$state.movementTracking) {
              this.local$this$.domNode.focus();
              return Unit;
            }
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda_0(this$_0) {
    return function (state_0, continuation_0, suspended) {
      var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_0(this$_0, state_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return false;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda_1(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_1(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2(event_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$event = event_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            tmp$ = shortcutOf(this.local$event);
            if (equals(tmp$, html.Keys.ArrowDown) || equals(tmp$, html.Keys.ArrowLeft))
              tmp$_0 = Direction$DOWN_getInstance();
            else if (equals(tmp$, html.Keys.ArrowUp) || equals(tmp$, html.Keys.ArrowRight))
              tmp$_0 = Direction$UP_getInstance();
            else
              tmp$_0 = null;
            var $receiver = tmp$_0;
            if ($receiver != null)
              this.local$event.preventDefault();
            return $receiver;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda_2(event_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda_2(event_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda(this$SliderComponent) {
    return function ($receiver) {
      this$SliderComponent.coreStyles_8aucc4$_0().track($receiver);
      this$SliderComponent.track.value($receiver);
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(this$SliderComponent, closure$state) {
    return function ($receiver) {
      this$SliderComponent.coreStyles_8aucc4$_0().trackFilled($receiver, closure$state.progress.percent);
      this$SliderComponent.trackFilled.value($receiver, closure$state.progress.percent);
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda(this$SliderComponent, closure$state) {
    return function ($receiver) {
      this$SliderComponent.coreStyles_8aucc4$_0().thumb($receiver, closure$state.progress.percent);
      this$SliderComponent.thumbStyle.value($receiver, closure$state.progress.percent);
      return Unit;
    };
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda(a_0, b_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$a = a_0;
    this.local$b = b_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return to(this.local$a, this.local$b);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda(a_0, b_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda(a_0, b_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.second.interactive;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1.prototype.constructor = Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1;
  Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return true;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(this$SliderComponent, closure$internalStore, closure$state) {
    return function ($receiver) {
      this$SliderComponent.addDataAttributes_an3vra$_0($receiver, closure$internalStore);
      this$SliderComponent.thumbContent.value($receiver, closure$state);
      var $receiver_0 = combine($receiver.mousedowns.events, closure$internalStore.data, SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda);
      var $receiver_1 = new unsafeFlow$ObjectLiteral_13(unsafeTransform$lambda_12(filter$lambda_0(SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0), $receiver_0));
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda$lambda_1), $receiver_1)), closure$internalStore.updateMovementTracking);
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(this$SliderComponent, closure$internalStore, closure$state) {
    return function ($receiver) {
      this$SliderComponent.addDataAttributes_an3vra$_0($receiver, closure$internalStore);
      div($receiver, SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda(this$SliderComponent, closure$state), void 0, void 0, 'thumb', void 0, SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda$lambda_0(this$SliderComponent, closure$internalStore, closure$state));
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$SliderComponent, closure$state, closure$internalStore) {
    return function ($receiver) {
      div($receiver, SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda(this$SliderComponent, closure$state), void 0, void 0, 'track-filled', void 0, SliderComponent$render$lambda$lambda$lambda$lambda$lambda$lambda_0(this$SliderComponent, closure$internalStore, closure$state));
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda$lambda_3(this$SliderComponent, closure$internalStore) {
    return function ($receiver, state) {
      div($receiver, SliderComponent$render$lambda$lambda$lambda$lambda$lambda(this$SliderComponent), void 0, void 0, 'track', void 0, SliderComponent$render$lambda$lambda$lambda$lambda$lambda_0(this$SliderComponent, state, closure$internalStore));
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda$lambda_2(this$SliderComponent, closure$internalStore) {
    return function ($receiver) {
      this$SliderComponent.addDataAttributes_an3vra$_0($receiver, closure$internalStore);
      var $receiver_0 = closure$internalStore.data;
      $receiver.attr_eyi041$('tabindex', new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$render$lambda$lambda$lambda$lambda), $receiver_0)));
      $receiver.handledBy_706ovd$(closure$internalStore.data, SliderComponent$render$lambda$lambda$lambda$lambda_0($receiver));
      $receiver.handledBy_ytah3h$($receiver.clicks.events, closure$internalStore.updateByClick);
      $receiver.handledBy_ytah3h$(dom.Window.mousemoves.events, closure$internalStore.updateByMovement);
      var $receiver_1 = dom.Window.mouseups.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$render$lambda$lambda$lambda$lambda_1), $receiver_1)), closure$internalStore.updateMovementTracking);
      var $receiver_2 = $receiver.keydowns.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_15(unsafeTransform$lambda_14(mapNotNull$lambda_0(SliderComponent$render$lambda$lambda$lambda$lambda_2), $receiver_2)), closure$internalStore.updateByKeystroke);
      $receiver.render_a5p5o5$(closure$internalStore.data, void 0, SliderComponent$render$lambda$lambda$lambda$lambda_3(this$SliderComponent, closure$internalStore));
      return Unit;
    };
  }
  function SliderComponent$render$lambda$lambda_2(this$SliderComponent, closure$internalStore) {
    return function ($receiver) {
      $receiver.className_p81yox$(get_name(this$SliderComponent.severityClassOf_i6436e$(Theme.Companion.invoke().slider.severity)));
      closure$internalStore.sliderElement = flexBox($receiver, SliderComponent$render$lambda$lambda$lambda_1(this$SliderComponent), void 0, void 0, void 0, void 0, SliderComponent$render$lambda$lambda$lambda_2(this$SliderComponent, closure$internalStore));
      var $receiver_0 = new SliderComponent$EventsContext($receiver, closure$internalStore.value, closure$internalStore.currentValue);
      var this$SliderComponent_0 = this$SliderComponent;
      var tmp$;
      this$SliderComponent_0.events.value($receiver_0);
      if ((tmp$ = this$SliderComponent_0.store) != null) {
        $receiver_0.handledBy_ytah3h$($receiver_0.value, tmp$.update);
      }this$SliderComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  SliderComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var internalStore = new StateStore_0(this.range.value, this.orientation.value(OrientationContext_getInstance()), new State_0());
    var tmp$, tmp$_0;
    var $receiver = (tmp$_0 = (tmp$ = this.store) != null ? tmp$.data : null) != null ? tmp$_0 : this.value.values;
    context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$render$lambda$lambda), $receiver)), internalStore.updateByValue);
    var $receiver_0 = this.disabled.values;
    context.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$render$lambda$lambda_0), $receiver_0)), internalStore.updateInteractive);
    div(context, SliderComponent$render$lambda$lambda_1(this, styling), baseClass, id, prefix, void 0, SliderComponent$render$lambda$lambda_2(this, internalStore));
    return internalStore.sliderElement;
  };
  SliderComponent.prototype.coreStyles_8aucc4$_0 = function () {
    return core(Theme.Companion.invoke().slider, this.orientation.value(OrientationContext_getInstance()).name);
  };
  function Coroutine$SliderComponent$addDataAttributes$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda.prototype.constructor = Coroutine$SliderComponent$addDataAttributes$lambda$lambda;
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.movementTracking;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$addDataAttributes$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$addDataAttributes$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0.prototype.constructor = Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0;
  Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return !this.local$it.interactive;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SliderComponent$addDataAttributes$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$SliderComponent$addDataAttributes$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  SliderComponent.prototype.addDataAttributes_an3vra$_0 = function (node, store) {
    var tmp$ = SliderComponent$Companion_getInstance().cssDataFocus;
    var $receiver = store.data;
    node.attr_mzp0ey$(tmp$, new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$addDataAttributes$lambda$lambda), $receiver)));
    var tmp$_0 = SliderComponent$Companion_getInstance().cssDataDisabled;
    var $receiver_0 = store.data;
    node.attr_mzp0ey$(tmp$_0, new unsafeFlow$ObjectLiteral_14(unsafeTransform$lambda_13(map$lambda_10(SliderComponent$addDataAttributes$lambda$lambda_0), $receiver_0)));
  };
  Object.defineProperty(SliderComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_44rvjz$_0.disabled;
    }
  });
  SliderComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_44rvjz$_0.enabled_6taknv$(value);
  };
  SliderComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_44rvjz$_0.enabled_433wua$(value);
  };
  Object.defineProperty(SliderComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_44rvjz$_1.severity;
    }
  });
  SliderComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_44rvjz$_1.severity_ietawi$(value);
  };
  SliderComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_44rvjz$_1.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(SliderComponent.prototype, 'orientation', {
    configurable: true,
    get: function () {
      return this.$delegate_44rvjz$_2.orientation;
    }
  });
  Object.defineProperty(SliderComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_44rvjz$_3.renderTooltip;
    }
  });
  SliderComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_44rvjz$_3.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  SliderComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_44rvjz$_3.tooltip_h43rbb$(text, build);
  };
  function SliderComponent$events$lambda($receiver) {
    return Unit;
  }
  function SliderComponent$thumbStyle$lambda($receiver, it) {
    return Unit;
  }
  function SliderComponent$thumbContent$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.primary.main;
  }
  function SliderComponent$thumbContent$lambda$lambda$lambda$lambda_0($receiver) {
    return $receiver.auto;
  }
  function SliderComponent$thumbContent$lambda$lambda$lambda($receiver) {
    $receiver.color_jl9ed9$(SliderComponent$thumbContent$lambda$lambda$lambda$lambda);
    $receiver.size_wpghq5$(SliderComponent$thumbContent$lambda$lambda$lambda$lambda_0);
    return Unit;
  }
  function SliderComponent$thumbContent$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(closure$it(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function SliderComponent$thumbContent$lambda(this$SliderComponent) {
    return function ($receiver, it) {
      var tmp$;
      if ((tmp$ = this$SliderComponent.icon.value) != null) {
        icon($receiver, SliderComponent$thumbContent$lambda$lambda$lambda, void 0, void 0, void 0, SliderComponent$thumbContent$lambda$lambda$lambda_0(tmp$));
      }return Unit;
    };
  }
  function SliderComponent$track$lambda($receiver) {
    return Unit;
  }
  function SliderComponent$trackFilled$lambda($receiver, it) {
    return Unit;
  }
  function SliderComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().slider.sizes.normal;
  }
  SliderComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SliderComponent',
    interfaces: [TooltipProperties, OrientationProperty, SeverityProperties, FormProperties, Component]
  };
  function spinner$lambda($receiver) {
    return Unit;
  }
  function spinner($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = spinner$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'spinner';
    var $receiver_0 = new SpinnerComponent();
    build($receiver_0);
    $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function SpinnerComponent() {
    SpinnerComponent$Companion_getInstance();
    this.$delegate_rsi2et$_0 = new EventMixin();
    this.icon = new ComponentProperty(null);
    this.speed = new ComponentProperty('0.5s');
    this.thickness = new ComponentProperty(SpinnerComponent$thickness$lambda);
  }
  function SpinnerComponent$Companion() {
    SpinnerComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('spinner', ' \n            display: inline-block;\n            border-color: currentColor;\n            border-style: solid;\n            border-radius: 99999px;\n            border-bottom-color: transparent;\n            border-left-color: transparent;\n            color: currentColor;\n            \n            @keyframes loading {\n              to {transform: rotate(360deg);}\n            }            \n        ');
  }
  SpinnerComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SpinnerComponent$Companion_instance = null;
  function SpinnerComponent$Companion_getInstance() {
    if (SpinnerComponent$Companion_instance === null) {
      new SpinnerComponent$Companion();
    }return SpinnerComponent$Companion_instance;
  }
  function SpinnerComponent$render$lambda$lambda$lambda$lambda(this$SpinnerComponent) {
    return function ($receiver) {
      return this$SpinnerComponent.thickness.value(Theme.Companion.invoke().borderWidths);
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda(this$SpinnerComponent) {
    return function ($receiver) {
      $receiver.width_qwzhsr$(SpinnerComponent$render$lambda$lambda$lambda$lambda(this$SpinnerComponent));
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda_0($receiver) {
    return '1rem';
  }
  function SpinnerComponent$render$lambda$lambda$lambda_1($receiver) {
    return '1rem';
  }
  function SpinnerComponent$render$lambda$lambda(this$SpinnerComponent) {
    return function ($receiver) {
      $receiver.css_61zpoe$('animation: loading ' + this$SpinnerComponent.speed.value + ' linear infinite;');
      $receiver.border_4a22k0$(SpinnerComponent$render$lambda$lambda$lambda(this$SpinnerComponent));
      $receiver.width_wpghq5$(SpinnerComponent$render$lambda$lambda$lambda_0);
      $receiver.height_wpghq5$(SpinnerComponent$render$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda_0(this$SpinnerComponent) {
    return function ($receiver) {
      this$SpinnerComponent.events.value($receiver);
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda_2(this$SpinnerComponent, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.css_61zpoe$(trimIndent('\n' + '                @keyframes spinner {' + '\n' + '                  to {transform: rotate(360deg);}' + '\n' + '                }    ' + '\n' + '                animation: spinner ' + this$SpinnerComponent.speed.value + ' linear infinite;' + '\n' + '            '));
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda$lambda_3(this$SpinnerComponent) {
    return function ($receiver) {
      $receiver.def.invoke_11rb$(ensureNotNull(this$SpinnerComponent.icon.value)(Theme.Companion.invoke().icons));
      return Unit;
    };
  }
  function SpinnerComponent$render$lambda$lambda_1(this$SpinnerComponent, closure$styling, closure$baseClass, closure$id, closure$prefix) {
    return function ($receiver) {
      icon($receiver, SpinnerComponent$render$lambda$lambda$lambda_2(this$SpinnerComponent, closure$styling), closure$baseClass, closure$id, closure$prefix, SpinnerComponent$render$lambda$lambda$lambda_3(this$SpinnerComponent));
      this$SpinnerComponent.events.value($receiver);
      return Unit;
    };
  }
  SpinnerComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    if (this.icon.value == null) {
      div_0(context, SpinnerComponent$render$lambda$lambda(this), styling, baseClass.plus_fox8kt$(SpinnerComponent$Companion_getInstance().staticCss), id, prefix, void 0, SpinnerComponent$render$lambda$lambda_0(this));
    } else {
      context.div_iz87dk$(void 0, void 0, void 0, SpinnerComponent$render$lambda$lambda_1(this, styling, baseClass, id, prefix));
    }
    return Unit;
  };
  Object.defineProperty(SpinnerComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_rsi2et$_0.events;
    }
  });
  function SpinnerComponent$thickness$lambda($receiver) {
    return Theme.Companion.invoke().borderWidths.normal;
  }
  SpinnerComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SpinnerComponent',
    interfaces: [EventProperties, Component]
  };
  function stackUp$lambda($receiver) {
    return Unit;
  }
  function stackUp$lambda_0($receiver) {
    return Unit;
  }
  function stackUp($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = stackUp$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'stack-up';
    if (build === void 0)
      build = stackUp$lambda_0;
    var $receiver_0 = new StackUpComponent();
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function lineUp$lambda($receiver) {
    return Unit;
  }
  function lineUp$lambda_0($receiver) {
    return Unit;
  }
  function lineUp($receiver, styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = lineUp$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'line-up';
    if (build === void 0)
      build = lineUp$lambda_0;
    var $receiver_0 = new LineUpComponent();
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function StackComponent() {
    StackComponent$Companion_getInstance();
    this.$delegate_c3wcmy$_0 = new EventMixin();
    this.reversed = new ComponentProperty(false);
    this.spacing = new ComponentProperty(StackComponent$spacing$lambda);
    this.items = new ComponentProperty(StackComponent$items$lambda);
  }
  function StackComponent$Companion() {
    StackComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('stack', 'align-items: flex-start;');
  }
  StackComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var StackComponent$Companion_instance = null;
  function StackComponent$Companion_getInstance() {
    if (StackComponent$Companion_instance === null) {
      new StackComponent$Companion();
    }return StackComponent$Companion_instance;
  }
  function StackComponent$render$lambda(this$StackComponent, closure$styling) {
    return function ($receiver) {
      var tmp$;
      $receiver.invoke_5yoziz$(this$StackComponent.stackStyles);
      closure$styling(Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function StackComponent$render$lambda_0(this$StackComponent) {
    return function ($receiver) {
      this$StackComponent.items.value($receiver);
      this$StackComponent.events.value($receiver);
      return Unit;
    };
  }
  StackComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    return flexBox(context, StackComponent$render$lambda(this, styling), baseClass.plus_fox8kt$(StackComponent$Companion_getInstance().staticCss), id, prefix, void 0, StackComponent$render$lambda_0(this));
  };
  Object.defineProperty(StackComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_c3wcmy$_0.events;
    }
  });
  function StackComponent$spacing$lambda($receiver) {
    return $receiver.normal;
  }
  function StackComponent$items$lambda($receiver) {
    return Unit;
  }
  StackComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StackComponent',
    interfaces: [EventProperties, Component]
  };
  function StackUpComponent() {
    StackComponent.call(this);
    this.stackStyles_s7qmc3$_0 = StackUpComponent$stackStyles$lambda(this);
  }
  Object.defineProperty(StackUpComponent.prototype, 'stackStyles', {
    configurable: true,
    get: function () {
      return this.stackStyles_s7qmc3$_0;
    }
  });
  function StackUpComponent$stackStyles$lambda$lambda($receiver) {
    return $receiver.columnReverse;
  }
  function StackUpComponent$stackStyles$lambda$lambda$lambda(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.bottom_bcpvvc$(this$StackUpComponent.spacing.value);
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda$lambda_0(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(StackUpComponent$stackStyles$lambda$lambda$lambda(this$StackUpComponent));
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda$lambda_1($receiver) {
    return $receiver.column;
  }
  function StackUpComponent$stackStyles$lambda$lambda$lambda_0(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.top_bcpvvc$(this$StackUpComponent.spacing.value);
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda$lambda_2(this$StackUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(StackUpComponent$stackStyles$lambda$lambda$lambda_0(this$StackUpComponent));
      return Unit;
    };
  }
  function StackUpComponent$stackStyles$lambda(this$StackUpComponent) {
    return function ($receiver) {
      if (this$StackUpComponent.reversed.value) {
        $receiver.direction_la6ffj$(StackUpComponent$stackStyles$lambda$lambda);
        $receiver.children_qlrppv$(' > :not(:first-child)', StackUpComponent$stackStyles$lambda$lambda_0(this$StackUpComponent));
      } else {
        $receiver.direction_la6ffj$(StackUpComponent$stackStyles$lambda$lambda_1);
        $receiver.children_qlrppv$(' > :not(:first-child)', StackUpComponent$stackStyles$lambda$lambda_2(this$StackUpComponent));
      }
      return Unit;
    };
  }
  StackUpComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StackUpComponent',
    interfaces: [StackComponent]
  };
  function LineUpComponent() {
    StackComponent.call(this);
    this.stackStyles_cpi2f5$_0 = LineUpComponent$stackStyles$lambda(this);
  }
  Object.defineProperty(LineUpComponent.prototype, 'stackStyles', {
    configurable: true,
    get: function () {
      return this.stackStyles_cpi2f5$_0;
    }
  });
  function LineUpComponent$stackStyles$lambda$lambda($receiver) {
    return $receiver.rowReverse;
  }
  function LineUpComponent$stackStyles$lambda$lambda$lambda(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.right_bcpvvc$(this$LineUpComponent.spacing.value);
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda$lambda_0(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(LineUpComponent$stackStyles$lambda$lambda$lambda(this$LineUpComponent));
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda$lambda_1($receiver) {
    return $receiver.row;
  }
  function LineUpComponent$stackStyles$lambda$lambda$lambda_0(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.left_bcpvvc$(this$LineUpComponent.spacing.value);
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda$lambda_2(this$LineUpComponent) {
    return function ($receiver) {
      $receiver.margins_ptb4s1$(LineUpComponent$stackStyles$lambda$lambda$lambda_0(this$LineUpComponent));
      return Unit;
    };
  }
  function LineUpComponent$stackStyles$lambda(this$LineUpComponent) {
    return function ($receiver) {
      if (this$LineUpComponent.reversed.value) {
        $receiver.direction_la6ffj$(LineUpComponent$stackStyles$lambda$lambda);
        $receiver.children_qlrppv$(' > :not(:first-child)', LineUpComponent$stackStyles$lambda$lambda_0(this$LineUpComponent));
      } else {
        $receiver.direction_la6ffj$(LineUpComponent$stackStyles$lambda$lambda_1);
        $receiver.children_qlrppv$(' > :not(:first-child)', LineUpComponent$stackStyles$lambda$lambda_2(this$LineUpComponent));
      }
      return Unit;
    };
  }
  LineUpComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineUpComponent',
    interfaces: [StackComponent]
  };
  function switch$lambda($receiver) {
    return Unit;
  }
  function switch$lambda_0($receiver) {
    return Unit;
  }
  function switch_0($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = switch$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'switchComponent';
    if (build === void 0)
      build = switch$lambda_0;
    var $receiver_0 = new SwitchComponent(value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function SwitchComponent(value) {
    SwitchComponent$Companion_getInstance();
    if (value === void 0)
      value = null;
    this.value = value;
    this.$delegate_9awwkh$_0 = new EventMixin();
    this.$delegate_9awwkh$_1 = new ElementMixin();
    this.$delegate_9awwkh$_2 = new InputFormMixin();
    this.$delegate_9awwkh$_3 = new SeverityMixin();
    this.$delegate_9awwkh$_4 = new TooltipMixin();
    this.size = new ComponentProperty(SwitchComponent$size$lambda);
    this.label_ivyp9v$_0 = null;
    this.labelStyle = new ComponentProperty(Theme.Companion.invoke().switch.label);
    this.dotStyle = new ComponentProperty(SwitchComponent$dotStyle$lambda);
    this.checkedStyle = new ComponentProperty(Theme.Companion.invoke().switch.checked);
    this.checked = new DynamicComponentProperty(flowOf(false));
  }
  function SwitchComponent$Companion() {
    SwitchComponent$Companion_instance = this;
    this.switchInputStaticCss = staticStyle_0('switch', '\n            position: absolute;\n            border: 0px;\n            clip: rect(0px, 0px, 0px, 0px);\n            height: 0px;\n            width: 0px;\n            white-space: nowrap;\n            overflow: hidden;\n            outline: none;\n            &:focus{\n                outline: none;\n            }           \n            ');
  }
  SwitchComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SwitchComponent$Companion_instance = null;
  function SwitchComponent$Companion_getInstance() {
    if (SwitchComponent$Companion_instance === null) {
      new SwitchComponent$Companion();
    }return SwitchComponent$Companion_instance;
  }
  function SwitchComponent$label$lambda(closure$value) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$value);
      return Unit;
    };
  }
  SwitchComponent.prototype.label_61zpoe$ = function (value) {
    this.label_ivyp9v$_0 = SwitchComponent$label$lambda(value);
  };
  function SwitchComponent$label$lambda_0(closure$value) {
    return function ($receiver) {
      $receiver.renderText_ntmorv$(closure$value);
      return Unit;
    };
  }
  SwitchComponent.prototype.label_p81yox$ = function (value) {
    this.label_ivyp9v$_0 = SwitchComponent$label$lambda_0(value);
  };
  SwitchComponent.prototype.label_wqyjv5$ = function (value) {
    this.label_ivyp9v$_0 = value;
  };
  function SwitchComponent$render$lambda$lambda$lambda($receiver) {
    return $receiver.inlineFlex;
  }
  function SwitchComponent$render$lambda$lambda$lambda_0($receiver) {
    return $receiver.center;
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda($receiver) {
    return Unit;
  }
  function SwitchComponent$render$lambda$lambda$lambda_1($receiver) {
    $receiver.relative_dkjn9d$(SwitchComponent$render$lambda$lambda$lambda$lambda);
    return Unit;
  }
  function SwitchComponent$render$lambda$lambda(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.display_1gh9wc$(SwitchComponent$render$lambda$lambda$lambda);
      $receiver.alignItems_tsd917$(SwitchComponent$render$lambda$lambda$lambda_0);
      $receiver.invoke_qkhqzy$(this$SwitchComponent.size.value(Theme.Companion.invoke().switch.sizes));
      $receiver.position_wp9r2r$(SwitchComponent$render$lambda$lambda$lambda_1);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_0(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SwitchComponent.checkedStyle.value);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda_2(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().switch.input);
      $receiver.children_qlrppv$('&[checked] + div', SwitchComponent$render$lambda$lambda$lambda$lambda_0(this$SwitchComponent));
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda_3(this$SwitchComponent) {
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      $receiver.disabled_f1igrw$(this$SwitchComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$SwitchComponent.readonly.values);
      $receiver.type_61zpoe$('checkbox');
      $receiver.checked_f1igrw$((tmp$_0 = (tmp$ = this$SwitchComponent.value) != null ? tmp$.data : null) != null ? tmp$_0 : this$SwitchComponent.checked.values);
      this$SwitchComponent.events.value($receiver);
      if ((tmp$_1 = this$SwitchComponent.value) != null) {
        $receiver.handledBy_ytah3h$(states($receiver.changes), tmp$_1.update);
      }$receiver.className_p81yox$(get_name(this$SwitchComponent.severityClassOf_i6436e$(Theme.Companion.invoke().switch.severity)));
      this$SwitchComponent.element.value($receiver);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda_4(closure$styling) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().switch.default);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_1(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(Theme.Companion.invoke().switch.dot);
      $receiver.invoke_qkhqzy$(this$SwitchComponent.dotStyle.value);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_2($receiver) {
    return Unit;
  }
  function SwitchComponent$render$lambda$lambda$lambda_5(this$SwitchComponent) {
    return function ($receiver) {
      div($receiver, SwitchComponent$render$lambda$lambda$lambda$lambda_1(this$SwitchComponent), void 0, void 0, void 0, void 0, SwitchComponent$render$lambda$lambda$lambda$lambda_2);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_3(this$SwitchComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$SwitchComponent.labelStyle.value);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda$lambda$lambda_4(closure$it) {
    return function ($receiver) {
      closure$it($receiver);
      return Unit;
    };
  }
  function SwitchComponent$render$lambda$lambda_0(closure$id, this$SwitchComponent, closure$prefix, closure$styling) {
    return function ($receiver) {
      var tmp$;
      if (closure$id != null)
        $receiver.for_61zpoe$(closure$id);
      input($receiver, SwitchComponent$render$lambda$lambda$lambda_2(this$SwitchComponent), SwitchComponent$Companion_getInstance().switchInputStaticCss, closure$id, closure$prefix, void 0, SwitchComponent$render$lambda$lambda$lambda_3(this$SwitchComponent));
      div($receiver, SwitchComponent$render$lambda$lambda$lambda_4(closure$styling), void 0, void 0, void 0, void 0, SwitchComponent$render$lambda$lambda$lambda_5(this$SwitchComponent));
      if ((tmp$ = this$SwitchComponent.label_ivyp9v$_0) != null) {
        div($receiver, SwitchComponent$render$lambda$lambda$lambda$lambda_3(this$SwitchComponent), void 0, void 0, void 0, void 0, SwitchComponent$render$lambda$lambda$lambda$lambda_4(tmp$));
      }this$SwitchComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  SwitchComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    return label(context, SwitchComponent$render$lambda$lambda(this), baseClass, void 0, prefix, void 0, SwitchComponent$render$lambda$lambda_0(id, this, prefix, styling));
  };
  Object.defineProperty(SwitchComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_9awwkh$_0.events;
    }
  });
  Object.defineProperty(SwitchComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_9awwkh$_1.element;
    }
  });
  Object.defineProperty(SwitchComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_9awwkh$_2.disabled;
    }
  });
  Object.defineProperty(SwitchComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_9awwkh$_2.readonly;
    }
  });
  SwitchComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_9awwkh$_2.enabled_6taknv$(value);
  };
  SwitchComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_9awwkh$_2.enabled_433wua$(value);
  };
  Object.defineProperty(SwitchComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_9awwkh$_3.severity;
    }
  });
  SwitchComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_9awwkh$_3.severity_ietawi$(value);
  };
  SwitchComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_9awwkh$_3.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(SwitchComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_9awwkh$_4.renderTooltip;
    }
  });
  SwitchComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_9awwkh$_4.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  SwitchComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_9awwkh$_4.tooltip_h43rbb$(text, build);
  };
  function SwitchComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().switch.sizes.normal;
  }
  function SwitchComponent$dotStyle$lambda($receiver) {
    return Unit;
  }
  SwitchComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SwitchComponent',
    interfaces: [TooltipProperties, SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function textArea$lambda($receiver) {
    return Unit;
  }
  function textArea($receiver, styling, value, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = textArea$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'textArea';
    var $receiver_0 = new TextAreaComponent(value);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function TextAreaComponent(valueStore) {
    TextAreaComponent$Companion_getInstance();
    if (valueStore === void 0)
      valueStore = null;
    this.valueStore = valueStore;
    this.$delegate_plgsqn$_0 = new EventMixin();
    this.$delegate_plgsqn$_1 = new ElementMixin();
    this.$delegate_plgsqn$_2 = new InputFormMixin();
    this.$delegate_plgsqn$_3 = new SeverityMixin();
    this.$delegate_plgsqn$_4 = new TooltipMixin();
    this.value = new DynamicComponentProperty(flowOf(''));
    this.variant = new ComponentProperty(TextAreaComponent$variant$lambda);
    this.placeholder = new DynamicComponentProperty(flowOf(''));
    this.resizeBehavior = new ComponentProperty(TextAreaComponent$resizeBehavior$lambda);
    this.size = new ComponentProperty(TextAreaComponent$size$lambda);
  }
  function TextAreaComponent$Companion() {
    TextAreaComponent$Companion_instance = this;
    this.staticCss = staticStyle_0('textAreaContainer', '\n            outline: 0px;\n            position: relative;\n            appearance: none;\n            transition: all 0.2s ease 0s;\n            min-height: 80px;\n            -webkit-appearance: none;\n            ');
  }
  TextAreaComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextAreaComponent$Companion_instance = null;
  function TextAreaComponent$Companion_getInstance() {
    if (TextAreaComponent$Companion_instance === null) {
      new TextAreaComponent$Companion();
    }return TextAreaComponent$Companion_instance;
  }
  function TextAreaComponent$render$lambda$lambda(this$TextAreaComponent) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(this$TextAreaComponent.resizeBehavior.value(Theme.Companion.invoke().textArea.resize));
      $receiver.invoke_qkhqzy$(this$TextAreaComponent.size.value(Theme.Companion.invoke().textArea.sizes));
      $receiver.invoke_qkhqzy$(this$TextAreaComponent.variant.value(Theme.Companion.invoke().textArea.variants));
      return Unit;
    };
  }
  function TextAreaComponent$render$lambda$lambda_0(this$TextAreaComponent) {
    return function ($receiver) {
      var tmp$;
      $receiver.disabled_f1igrw$(this$TextAreaComponent.disabled.values);
      $receiver.readOnly_f1igrw$(this$TextAreaComponent.readonly.values);
      $receiver.placeholder_p81yox$(this$TextAreaComponent.placeholder.values);
      $receiver.value_p81yox$(this$TextAreaComponent.value.values);
      $receiver.className_p81yox$(get_name(this$TextAreaComponent.severityClassOf_i6436e$(Theme.Companion.invoke().textArea.severity)));
      if ((tmp$ = this$TextAreaComponent.valueStore) != null) {
        $receiver.value_p81yox$(tmp$.data);
        $receiver.handledBy_ytah3h$(values_0($receiver.changes), tmp$.update);
      }this$TextAreaComponent.events.value($receiver);
      this$TextAreaComponent.element.value($receiver);
      this$TextAreaComponent.renderTooltip.value($receiver);
      return Unit;
    };
  }
  TextAreaComponent.prototype.render_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    return textarea(context, TextAreaComponent$render$lambda$lambda(this), styling, baseClass.plus_fox8kt$(TextAreaComponent$Companion_getInstance().staticCss), id, prefix, void 0, TextAreaComponent$render$lambda$lambda_0(this));
  };
  Object.defineProperty(TextAreaComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_plgsqn$_0.events;
    }
  });
  Object.defineProperty(TextAreaComponent.prototype, 'element', {
    configurable: true,
    get: function () {
      return this.$delegate_plgsqn$_1.element;
    }
  });
  Object.defineProperty(TextAreaComponent.prototype, 'disabled', {
    configurable: true,
    get: function () {
      return this.$delegate_plgsqn$_2.disabled;
    }
  });
  Object.defineProperty(TextAreaComponent.prototype, 'readonly', {
    configurable: true,
    get: function () {
      return this.$delegate_plgsqn$_2.readonly;
    }
  });
  TextAreaComponent.prototype.enabled_6taknv$ = function (value) {
    return this.$delegate_plgsqn$_2.enabled_6taknv$(value);
  };
  TextAreaComponent.prototype.enabled_433wua$ = function (value) {
    return this.$delegate_plgsqn$_2.enabled_433wua$(value);
  };
  Object.defineProperty(TextAreaComponent.prototype, 'severity', {
    configurable: true,
    get: function () {
      return this.$delegate_plgsqn$_3.severity;
    }
  });
  TextAreaComponent.prototype.severity_ietawi$ = function (value) {
    return this.$delegate_plgsqn$_3.severity_ietawi$(value);
  };
  TextAreaComponent.prototype.severityClassOf_i6436e$ = function (severityStyle) {
    return this.$delegate_plgsqn$_3.severityClassOf_i6436e$(severityStyle);
  };
  Object.defineProperty(TextAreaComponent.prototype, 'renderTooltip', {
    configurable: true,
    get: function () {
      return this.$delegate_plgsqn$_4.renderTooltip;
    }
  });
  TextAreaComponent.prototype.tooltip_of5yat$$default = function (styling, text, baseClass, id, prefix, build) {
    return this.$delegate_plgsqn$_4.tooltip_of5yat$$default(styling, text, baseClass, id, prefix, build);
  };
  TextAreaComponent.prototype.tooltip_h43rbb$ = function (text, build) {
    return this.$delegate_plgsqn$_4.tooltip_h43rbb$(text, build);
  };
  function TextAreaComponent$variant$lambda($receiver) {
    return $receiver.basic;
  }
  function TextAreaComponent$resizeBehavior$lambda($receiver) {
    return Theme.Companion.invoke().textArea.resize.both;
  }
  function TextAreaComponent$size$lambda($receiver) {
    return Theme.Companion.invoke().textArea.sizes.normal;
  }
  TextAreaComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextAreaComponent',
    interfaces: [TooltipProperties, SeverityProperties, InputFormProperties, ElementProperties, EventProperties, Component]
  };
  function showToast$lambda($receiver) {
    return Unit;
  }
  function showToast(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = showToast$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'toast';
    var $receiver = new ToastComponent();
    build($receiver);
    $receiver.render_n7482o$(styling, baseClass, id, prefix);
  }
  function toast$lambda($receiver) {
    return Unit;
  }
  function toast$lambda_0(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build) {
    return function () {
      showToast(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build);
      return Unit;
    };
  }
  function toast(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = toast$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'toast';
    return asHandler(toast$lambda_0(styling, baseClass, id, prefix, build));
  }
  function showAlertToast$lambda($receiver) {
    return Unit;
  }
  function showAlertToast(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = showAlertToast$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'toast-alert';
    var $receiver = new AlertToastComponent();
    build($receiver);
    $receiver.render_n7482o$(styling, baseClass, id, prefix);
  }
  function alertToast$lambda($receiver) {
    return Unit;
  }
  function alertToast$lambda_0(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build) {
    return function () {
      showAlertToast(closure$styling, closure$baseClass, closure$id, closure$prefix, closure$build);
      return Unit;
    };
  }
  function alertToast(styling, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = alertToast$lambda;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = null;
    if (prefix === void 0)
      prefix = 'toast-alert';
    return asHandler(alertToast$lambda_0(styling, baseClass, id, prefix, build));
  }
  function unsafeFlow$ObjectLiteral_16(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_16($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_16.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_16.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_16.prototype.constructor = Coroutine$collect_42ocv1$_16;
  Coroutine$collect_42ocv1$_16.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_16.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_16(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_16.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_15(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_15.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_15.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_15.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_15;
  Coroutine$unsafeTransform$lambda$lambda_15.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_15(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_15(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_15(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_15.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_15.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_15.prototype.constructor = Coroutine$unsafeTransform$lambda_15;
  Coroutine$unsafeTransform$lambda_15.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_15(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_15(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_15(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_11(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_11.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_11.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_11.prototype.constructor = Coroutine$map$lambda_11;
  Coroutine$map$lambda_11.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_11(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_11(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function asHandler$ObjectLiteral(closure$action, initialData, id) {
    RootStore.call(this, initialData, id);
    this.handler = this.handle_7ib3lp$(void 0, asHandler$ObjectLiteral$handler$lambda(closure$action));
  }
  function Coroutine$asHandler$ObjectLiteral$handler$lambda(closure$action_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$action = closure$action_0;
  }
  Coroutine$asHandler$ObjectLiteral$handler$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$asHandler$ObjectLiteral$handler$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$asHandler$ObjectLiteral$handler$lambda.prototype.constructor = Coroutine$asHandler$ObjectLiteral$handler$lambda;
  Coroutine$asHandler$ObjectLiteral$handler$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$action();
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function asHandler$ObjectLiteral$handler$lambda(closure$action_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$asHandler$ObjectLiteral$handler$lambda(closure$action_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  asHandler$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  function asHandler(action) {
    return (new asHandler$ObjectLiteral(action, Unit)).handler;
  }
  function ToastComponentBase() {
    ToastComponentBase$Companion_getInstance();
    this.$delegate_hw5qsg$_0 = new CloseButtonMixin('toast-close-button', Theme.Companion.invoke().toast.closeButton.close);
    this.placement = new ComponentProperty(ToastComponentBase$placement$lambda);
    this.duration = new ComponentProperty(L5000);
    this.background = new ComponentProperty(ToastComponentBase$background$lambda);
  }
  function ToastComponentBase$ToastFragment(id, placement, render) {
    this.id = id;
    this.placement = placement;
    this.render = render;
  }
  ToastComponentBase$ToastFragment.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ToastFragment',
    interfaces: []
  };
  ToastComponentBase$ToastFragment.prototype.component1 = function () {
    return this.id;
  };
  ToastComponentBase$ToastFragment.prototype.component2 = function () {
    return this.placement;
  };
  ToastComponentBase$ToastFragment.prototype.component3 = function () {
    return this.render;
  };
  ToastComponentBase$ToastFragment.prototype.copy_a76peq$ = function (id, placement, render) {
    return new ToastComponentBase$ToastFragment(id === void 0 ? this.id : id, placement === void 0 ? this.placement : placement, render === void 0 ? this.render : render);
  };
  ToastComponentBase$ToastFragment.prototype.toString = function () {
    return 'ToastFragment(id=' + Kotlin.toString(this.id) + (', placement=' + Kotlin.toString(this.placement)) + (', render=' + Kotlin.toString(this.render)) + ')';
  };
  ToastComponentBase$ToastFragment.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.placement) | 0;
    result = result * 31 + Kotlin.hashCode(this.render) | 0;
    return result;
  };
  ToastComponentBase$ToastFragment.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.placement, other.placement) && Kotlin.equals(this.render, other.render)))));
  };
  function ToastComponentBase$Placement() {
    ToastComponentBase$Placement_instance = this;
    this.bottom = 'bottom';
    this.bottomLeft = 'bottomLeft';
    this.bottomRight = 'bottomRight';
    this.top = 'top';
    this.topLeft = 'topLeft';
    this.topRight = 'topRight';
    this.placements = listOf_0([this.bottom, this.bottomLeft, this.bottomRight, this.top, this.topLeft, this.topRight]);
  }
  ToastComponentBase$Placement.prototype.appearsFromBottom_8hiaea$ = function (toasts) {
    return !toasts.isEmpty() && setOf([this.bottom, this.bottomRight, this.bottomLeft]).contains_11rb$(first(toasts).placement);
  };
  ToastComponentBase$Placement.prototype.alignmentOf_61zpoe$ = function (placement) {
    switch (placement) {
      case 'bottom':
        return 'center';
      case 'top':
        return 'center';
      case 'bottomLeft':
        return 'left';
      case 'topLeft':
        return 'left';
      case 'bottomRight':
        return 'right';
      case 'topRight':
        return 'right';
      default:return 'center';
    }
  };
  ToastComponentBase$Placement.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Placement',
    interfaces: []
  };
  var ToastComponentBase$Placement_instance = null;
  function ToastComponentBase$Placement_getInstance() {
    if (ToastComponentBase$Placement_instance === null) {
      new ToastComponentBase$Placement();
    }return ToastComponentBase$Placement_instance;
  }
  function ToastComponentBase$ToastStore() {
    ToastComponentBase$ToastStore_instance = this;
    RootStore.call(this, emptyList(), 'toast-store');
    this.add = this.handle_ajdi87$(void 0, ToastComponentBase$ToastStore$add$lambda);
    this.remove = this.handle_ajdi87$(void 0, ToastComponentBase$ToastStore$remove$lambda);
    this.removeAll = this.handle_7ib3lp$(void 0, ToastComponentBase$ToastStore$removeAll$lambda);
    this.removeLast = this.handle_7ib3lp$(void 0, ToastComponentBase$ToastStore$removeLast$lambda);
  }
  function Coroutine$ToastComponentBase$ToastStore$add$lambda(allToasts_0, newToast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$allToasts = allToasts_0;
    this.local$newToast = newToast_0;
  }
  Coroutine$ToastComponentBase$ToastStore$add$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$ToastStore$add$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$ToastStore$add$lambda.prototype.constructor = Coroutine$ToastComponentBase$ToastStore$add$lambda;
  Coroutine$ToastComponentBase$ToastStore$add$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return plus(this.local$allToasts, this.local$newToast);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$ToastStore$add$lambda(allToasts_0, newToast_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$ToastStore$add$lambda(allToasts_0, newToast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ToastComponentBase$ToastStore$remove$lambda(allToasts_0, toastId_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$allToasts = allToasts_0;
    this.local$toastId = toastId_0;
  }
  Coroutine$ToastComponentBase$ToastStore$remove$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$ToastStore$remove$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$ToastStore$remove$lambda.prototype.constructor = Coroutine$ToastComponentBase$ToastStore$remove$lambda;
  Coroutine$ToastComponentBase$ToastStore$remove$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            var firstOrNull$result;
            firstOrNull$break: do {
              var tmp$_1;
              tmp$_1 = this.local$allToasts.iterator();
              while (tmp$_1.hasNext()) {
                var element = tmp$_1.next();
                if (equals(element.id, this.local$toastId)) {
                  firstOrNull$result = element;
                  break firstOrNull$break;
                }}
              firstOrNull$result = null;
            }
             while (false);
            return (tmp$_0 = (tmp$ = firstOrNull$result) != null ? minus(this.local$allToasts, tmp$) : null) != null ? tmp$_0 : this.local$allToasts;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$ToastStore$remove$lambda(allToasts_0, toastId_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$ToastStore$remove$lambda(allToasts_0, toastId_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ToastComponentBase$ToastStore$removeAll$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ToastComponentBase$ToastStore$removeAll$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$ToastStore$removeAll$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$ToastStore$removeAll$lambda.prototype.constructor = Coroutine$ToastComponentBase$ToastStore$removeAll$lambda;
  Coroutine$ToastComponentBase$ToastStore$removeAll$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return emptyList();
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$ToastStore$removeAll$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$ToastStore$removeAll$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ToastComponentBase$ToastStore$removeLast$lambda(allToasts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$allToasts = allToasts_0;
  }
  Coroutine$ToastComponentBase$ToastStore$removeLast$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$ToastStore$removeLast$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$ToastStore$removeLast$lambda.prototype.constructor = Coroutine$ToastComponentBase$ToastStore$removeLast$lambda;
  Coroutine$ToastComponentBase$ToastStore$removeLast$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return dropLast(this.local$allToasts, 1);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$ToastStore$removeLast$lambda(allToasts_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$ToastStore$removeLast$lambda(allToasts_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ToastComponentBase$ToastStore.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ToastStore',
    interfaces: [RootStore]
  };
  var ToastComponentBase$ToastStore_instance = null;
  function ToastComponentBase$ToastStore_getInstance() {
    if (ToastComponentBase$ToastStore_instance === null) {
      new ToastComponentBase$ToastStore();
    }return ToastComponentBase$ToastStore_instance;
  }
  function ToastComponentBase$CloseMethodCompanion() {
  }
  function ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.closeAll = this.handle_7ib3lp$(void 0, ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda);
  }
  function Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda.prototype.constructor = Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda;
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            ToastComponentBase$ToastStore_getInstance().removeAll.invoke();
            return this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral$closeAll$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  ToastComponentBase$CloseMethodCompanion.prototype.closeAllToasts = function () {
    var store = new ToastComponentBase$CloseMethodCompanion$closeAllToasts$ObjectLiteral('');
    return store.closeAll;
  };
  function ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral(initialData, id) {
    RootStore.call(this, initialData, id);
    this.closeLatest = this.handle_7ib3lp$(void 0, ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda);
  }
  function Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda.prototype.constructor = Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda;
  Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            ToastComponentBase$ToastStore_getInstance().removeLast.invoke();
            return this.local$it;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral$closeLatest$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [RootStore]
  };
  ToastComponentBase$CloseMethodCompanion.prototype.closeLastToast = function () {
    var store = new ToastComponentBase$CloseMethodCompanion$closeLastToast$ObjectLiteral('');
    return store.closeLatest;
  };
  ToastComponentBase$CloseMethodCompanion.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CloseMethodCompanion',
    interfaces: []
  };
  function ToastComponentBase$Companion() {
    ToastComponentBase$Companion_instance = this;
    ToastComponentBase$CloseMethodCompanion.call(this);
    this.toastContainerStaticCss_0 = staticStyle_0('toastContainer', '\n               position: fixed; \n               pointer-events: none;\n               display: flex;\n               flex-direction: column;\n               ');
    this.globalId_0 = 'f2c-toasts-' + identification.Id.next_za3lpa$();
    this.job_0 = Job();
    this.scope_0 = new Scope();
    var $receiver = ManagedComponent$Companion_getInstance().managedRenderContext_rcagsd$(this.globalId_0, this.job_0, this.scope_0);
    var tmp$;
    tmp$ = ToastComponentBase$Placement_getInstance().placements.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      switch (element) {
        case 'bottom':
          tmp$_0 = Theme.Companion.invoke().toast.placement.bottom;
          break;
        case 'bottomLeft':
          tmp$_0 = Theme.Companion.invoke().toast.placement.bottomLeft;
          break;
        case 'bottomRight':
          tmp$_0 = Theme.Companion.invoke().toast.placement.bottomRight;
          break;
        case 'top':
          tmp$_0 = Theme.Companion.invoke().toast.placement.top;
          break;
        case 'topLeft':
          tmp$_0 = Theme.Companion.invoke().toast.placement.topLeft;
          break;
        case 'topRight':
          tmp$_0 = Theme.Companion.invoke().toast.placement.topRight;
          break;
        default:tmp$_0 = Theme.Companion.invoke().toast.placement.bottom;
          break;
      }
      var placementStyle = tmp$_0;
      ul($receiver, ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda(placementStyle), this.toastContainerStaticCss_0, identification.Id.next_za3lpa$(), 'ul-toast-container', void 0, ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda_0(element));
    }
  }
  function ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda($receiver) {
    return $receiver.toast;
  }
  function ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda(closure$placementStyle) {
    return function ($receiver) {
      $receiver.invoke_qkhqzy$(closure$placementStyle);
      $receiver.zIndex_yiflju$(ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda);
      return Unit;
    };
  }
  function Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda(closure$it_0, toasts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$it = closure$it_0;
    this.local$toasts = toasts_0;
  }
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda;
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var destination = ArrayList_init_0();
            var tmp$;
            tmp$ = this.local$toasts.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              if (equals(element.placement, this.local$closure$it))
                destination.add_11rb$(element);
            }

            return destination;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0(closure$it_0) {
    return function (toasts_0, continuation_0, suspended) {
      var instance = new Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda(closure$it_0, toasts_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0(toasts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$toasts = toasts_0;
  }
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0;
  Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (ToastComponentBase$Placement_getInstance().appearsFromBottom_8hiaea$(this.local$toasts)) {
              return asReversed(this.local$toasts);
            } else {
              return this.local$toasts;
            }

          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_1(toasts_0, continuation_0, suspended) {
    var instance = new Coroutine$ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0(toasts_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_2($receiver, toast) {
    return toast.render($receiver);
  }
  function ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda_0(closure$it) {
    return function ($receiver) {
      var $receiver_0 = ToastComponentBase$ToastStore_getInstance().data;
      var $receiver_1 = new unsafeFlow$ObjectLiteral_16(unsafeTransform$lambda_15(map$lambda_11(ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_0(closure$it)), $receiver_0));
      $receiver.renderEach_ywitts$(new unsafeFlow$ObjectLiteral_16(unsafeTransform$lambda_15(map$lambda_11(ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_1), $receiver_1)), void 0, void 0, ToastComponentBase$ToastComponentBase$Companion_init$lambda$lambda$lambda$lambda_2);
      return Unit;
    };
  }
  ToastComponentBase$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [ToastComponentBase$CloseMethodCompanion]
  };
  var ToastComponentBase$Companion_instance = null;
  function ToastComponentBase$Companion_getInstance() {
    if (ToastComponentBase$Companion_instance === null) {
      new ToastComponentBase$Companion();
    }return ToastComponentBase$Companion_instance;
  }
  function Coroutine$ToastComponentBase$render$lambda(this$ToastComponentBase_0, closure$localId_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$ToastComponentBase = this$ToastComponentBase_0;
    this.local$closure$localId = closure$localId_0;
  }
  Coroutine$ToastComponentBase$render$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$render$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$render$lambda.prototype.constructor = Coroutine$ToastComponentBase$render$lambda;
  Coroutine$ToastComponentBase$render$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = delay(this.local$this$ToastComponentBase.duration.value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return ToastComponentBase$ToastStore_getInstance().remove.invoke_11rb$(this.local$closure$localId), Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$render$lambda(this$ToastComponentBase_0, closure$localId_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ToastComponentBase$render$lambda(this$ToastComponentBase_0, closure$localId_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ToastComponentBase$render$lambda$lambda(this$ToastComponentBase) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(Theme.Companion.invoke().toast.list);
      Theme.Companion.invoke().toast.alignment($receiver, ToastComponentBase$Placement_getInstance().alignmentOf_61zpoe$(this$ToastComponentBase.placement.value(ToastComponentBase$Placement_getInstance())));
      return Unit;
    };
  }
  function ToastComponentBase$render$lambda$lambda$lambda$lambda(this$ToastComponentBase) {
    return function ($receiver) {
      $receiver.color_jl9ed9$(this$ToastComponentBase.background.value);
      return Unit;
    };
  }
  function ToastComponentBase$render$lambda$lambda$lambda(this$ToastComponentBase, closure$styling) {
    return function ($receiver) {
      $receiver.invoke_4my6up$(Theme.Companion.invoke().toast.body);
      $receiver.background_f5fcq6$(ToastComponentBase$render$lambda$lambda$lambda$lambda(this$ToastComponentBase));
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda(closure$localId_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$localId = closure$localId_0;
  }
  Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda;
  Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$localId;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ToastComponentBase$render$lambda$lambda$lambda$lambda_0(closure$localId_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$ToastComponentBase$render$lambda$lambda$lambda$lambda(closure$localId_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ToastComponentBase$render$lambda$lambda$lambda_0(this$ToastComponentBase, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$localId) {
    return function ($receiver) {
      this$ToastComponentBase.renderContent_3fp8sc$($receiver, closure$styling, closure$baseClass, closure$id, closure$prefix);
      if (this$ToastComponentBase.hasCloseButton.value) {
        $receiver.handledBy_ytah3h$(this$ToastComponentBase.closeButtonRendering.value($receiver).map_wcw67s$(ToastComponentBase$render$lambda$lambda$lambda$lambda_0(closure$localId)), ToastComponentBase$ToastStore_getInstance().remove);
      }return Unit;
    };
  }
  function ToastComponentBase$render$lambda$lambda_0(this$ToastComponentBase, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$localId) {
    return function ($receiver) {
      div($receiver, ToastComponentBase$render$lambda$lambda$lambda(this$ToastComponentBase, closure$styling), void 0, void 0, void 0, void 0, ToastComponentBase$render$lambda$lambda$lambda_0(this$ToastComponentBase, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$localId));
      return Unit;
    };
  }
  function ToastComponentBase$render$lambda_0(this$ToastComponentBase, closure$baseClass, closure$id, closure$prefix, closure$styling, closure$localId) {
    return function ($receiver) {
      return li($receiver, ToastComponentBase$render$lambda$lambda(this$ToastComponentBase), closure$baseClass, closure$id, closure$prefix, void 0, ToastComponentBase$render$lambda$lambda_0(this$ToastComponentBase, closure$styling, closure$baseClass, closure$id, closure$prefix, closure$localId));
    };
  }
  ToastComponentBase.prototype.render_n7482o$ = function (styling, baseClass, id, prefix) {
    var localId = id != null ? id : identification.Id.next_za3lpa$();
    launch(plus_0(MainScope(), ToastComponentBase$Companion_getInstance().job_0), void 0, void 0, ToastComponentBase$render$lambda(this, localId));
    ToastComponentBase$ToastStore_getInstance().add.invoke_11rb$(new ToastComponentBase$ToastFragment(localId, this.placement.value(ToastComponentBase$Placement_getInstance()), ToastComponentBase$render$lambda_0(this, baseClass, id, prefix, styling, localId)));
    return Unit;
  };
  Object.defineProperty(ToastComponentBase.prototype, 'closeButtonIcon', {
    configurable: true,
    get: function () {
      return this.$delegate_hw5qsg$_0.closeButtonIcon;
    }
  });
  Object.defineProperty(ToastComponentBase.prototype, 'closeButtonPrefix', {
    configurable: true,
    get: function () {
      return this.$delegate_hw5qsg$_0.closeButtonPrefix;
    }
  });
  Object.defineProperty(ToastComponentBase.prototype, 'closeButtonRendering', {
    configurable: true,
    get: function () {
      return this.$delegate_hw5qsg$_0.closeButtonRendering;
    }
  });
  Object.defineProperty(ToastComponentBase.prototype, 'closeButtonStyle', {
    configurable: true,
    get: function () {
      return this.$delegate_hw5qsg$_0.closeButtonStyle;
    }
  });
  Object.defineProperty(ToastComponentBase.prototype, 'hasCloseButton', {
    configurable: true,
    get: function () {
      return this.$delegate_hw5qsg$_0.hasCloseButton;
    }
  });
  function ToastComponentBase$placement$lambda($receiver) {
    return $receiver.bottomRight;
  }
  function ToastComponentBase$background$lambda($receiver) {
    return $receiver.info.main;
  }
  ToastComponentBase.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ToastComponentBase',
    interfaces: [CloseButtonProperty, ManagedComponent]
  };
  function ToastComponent() {
    ToastComponent$Companion_getInstance();
    ToastComponentBase.call(this);
    this.content = new ComponentProperty(null);
  }
  function ToastComponent$Companion() {
    ToastComponent$Companion_instance = this;
    ToastComponentBase$CloseMethodCompanion.call(this);
  }
  ToastComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [ToastComponentBase$CloseMethodCompanion]
  };
  var ToastComponent$Companion_instance = null;
  function ToastComponent$Companion_getInstance() {
    if (ToastComponent$Companion_instance === null) {
      new ToastComponent$Companion();
    }return ToastComponent$Companion_instance;
  }
  ToastComponent.prototype.renderContent_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var tmp$;
    (tmp$ = this.content.value) != null ? tmp$(context) : null;
  };
  ToastComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ToastComponent',
    interfaces: [ToastComponentBase]
  };
  function AlertToastComponent() {
    AlertToastComponent$Companion_getInstance();
    ToastComponentBase.call(this);
    this.alert = new ComponentProperty(AlertToastComponent$alert$lambda);
  }
  function AlertToastComponent$Companion() {
    AlertToastComponent$Companion_instance = this;
    ToastComponentBase$CloseMethodCompanion.call(this);
  }
  AlertToastComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [ToastComponentBase$CloseMethodCompanion]
  };
  var AlertToastComponent$Companion_instance = null;
  function AlertToastComponent$Companion_getInstance() {
    if (AlertToastComponent$Companion_instance === null) {
      new AlertToastComponent$Companion();
    }return AlertToastComponent$Companion_instance;
  }
  function AlertToastComponent$renderContent$lambda$lambda$lambda($receiver) {
    return $receiver.toast;
  }
  function AlertToastComponent$renderContent$lambda$lambda$lambda_0(closure$alertComponent) {
    return function ($receiver) {
      var colorScheme = closure$alertComponent.severity.value(Theme.Companion.invoke().alert.severities).colorScheme;
      switch (closure$alertComponent.variant.value(AlertComponent$VariantContext_getInstance()).name) {
        case 'SUBTLE':
          return colorScheme.main;
        case 'TOP_ACCENT':
          return colorScheme.main;
        case 'LEFT_ACCENT':
          return colorScheme.main;
        default:return colorScheme.mainContrast;
      }
    };
  }
  function AlertToastComponent$renderContent$lambda$lambda(closure$alertComponent) {
    return function ($receiver) {
      Theme.Companion.invoke().toast.closeButton.close;
      $receiver.color_jl9ed9$(AlertToastComponent$renderContent$lambda$lambda$lambda_0(closure$alertComponent));
      return Unit;
    };
  }
  AlertToastComponent.prototype.renderContent_3fp8sc$ = function (context, styling, baseClass, id, prefix) {
    var $receiver = new AlertComponent();
    this.alert.value($receiver);
    $receiver.stacking.invoke_11rb$(AlertToastComponent$renderContent$lambda$lambda$lambda);
    var alertComponent = $receiver;
    this.closeButtonStyle.invoke_11rb$(AlertToastComponent$renderContent$lambda$lambda(alertComponent));
    alertComponent.render_3fp8sc$(context, styling, baseClass, id, prefix);
  };
  function AlertToastComponent$alert$lambda($receiver) {
    return Unit;
  }
  AlertToastComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AlertToastComponent',
    interfaces: [ToastComponentBase]
  };
  function tooltip($receiver, text) {
    return Theme.Companion.invoke().tooltip.write_vqirvp$(text.slice());
  }
  function tooltip_0($receiver, text, tooltipPlacement) {
    return Theme.Companion.invoke().tooltip.write_39nqze$(text.slice(), tooltipPlacement);
  }
  function tooltip$lambda($receiver) {
    return Unit;
  }
  function tooltip_1($receiver, styling, text, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = tooltip$lambda;
    if (text === void 0)
      text = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = 'fc2-tooltip-' + identification.Id.next_za3lpa$();
    if (prefix === void 0)
      prefix = 'tooltip';
    var $receiver_0 = new TooltipComponent(text);
    build($receiver_0);
    return $receiver_0.render_1f8u23$($receiver, styling, baseClass, id, prefix);
  }
  function tooltip$lambda_0($receiver) {
    return Unit;
  }
  function tooltip$lambda_1(closure$build, closure$text) {
    return function ($receiver) {
      closure$build($receiver);
      $receiver.text_vqirvp$(closure$text.slice());
      return Unit;
    };
  }
  function tooltip_2($receiver, text, build) {
    tooltip_1($receiver, tooltip$lambda_0, void 0, void 0, void 0, void 0, tooltip$lambda_1(build, text));
  }
  function unsafeFlow$ObjectLiteral_17(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_17($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_17.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_17.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_17.prototype.constructor = Coroutine$collect_42ocv1$_17;
  Coroutine$collect_42ocv1$_17.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_17.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_17(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_17.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_16(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_16.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_16.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_16.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_16;
  Coroutine$unsafeTransform$lambda$lambda_16.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_16(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_16(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_16(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_16.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_16.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_16.prototype.constructor = Coroutine$unsafeTransform$lambda_16;
  Coroutine$unsafeTransform$lambda_16.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_16(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_16(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_16(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_12(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_12.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_12.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_12.prototype.constructor = Coroutine$map$lambda_12;
  Coroutine$map$lambda_12.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_12(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_12(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function TooltipComponent(textFromParam) {
    this.textFromParam_p44eit$_0 = textFromParam;
    this.$delegate_1nh6uv$_0 = new EventMixin();
    this.textFromContext_daf8iv$_0 = emptyFlow();
    this.placement = new ComponentProperty(TooltipComponent$placement$lambda);
  }
  TooltipComponent.prototype.text_vqirvp$ = function (value) {
    this.textFromContext_daf8iv$_0 = flowOf(asList(value));
  };
  TooltipComponent.prototype.text_61zpoe$ = function (value) {
    this.textFromContext_daf8iv$_0 = flowOf(listOf(value));
  };
  function Coroutine$TooltipComponent$text$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$TooltipComponent$text$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TooltipComponent$text$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TooltipComponent$text$lambda.prototype.constructor = Coroutine$TooltipComponent$text$lambda;
  Coroutine$TooltipComponent$text$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return listOf(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TooltipComponent$text$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$TooltipComponent$text$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  TooltipComponent.prototype.text_p81yox$ = function (value) {
    this.textFromContext_daf8iv$_0 = new unsafeFlow$ObjectLiteral_17(unsafeTransform$lambda_16(map$lambda_12(TooltipComponent$text$lambda), value));
  };
  TooltipComponent.prototype.text_mhpeer$ = function (value) {
    this.textFromContext_daf8iv$_0 = flowOf(value);
  };
  TooltipComponent.prototype.text_u70378$ = function (value) {
    this.textFromContext_daf8iv$_0 = value;
  };
  TooltipComponent.prototype.content_t1hzwo$_0 = function () {
    return this.textFromParam_p44eit$_0 != null ? flowOf(listOf(this.textFromParam_p44eit$_0)) : this.textFromContext_daf8iv$_0;
  };
  function TooltipComponent$render$lambda$lambda(closure$styling) {
    return function ($receiver) {
      var tmp$;
      Kotlin.isType(tmp$ = $receiver, BoxParams) ? tmp$ : throwCCE();
      $receiver.invoke_4my6up$(Theme.Companion.invoke().tooltip.base);
      $receiver.invoke_4my6up$(closure$styling);
      return Unit;
    };
  }
  function TooltipComponent$render$lambda$lambda$lambda(this$TooltipComponent) {
    return function ($receiver) {
      return this$TooltipComponent.placement.value(PlacementContext_getInstance());
    };
  }
  function Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda;
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.currentTarget;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TooltipComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0.prototype.constructor = Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0;
  Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function TooltipComponent$render$lambda$lambda$lambda_0(closure$context) {
    return function ($receiver, toggle, close) {
      closure$context.domNode;
      var $receiver_0 = $receiver.mouseenters.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_17(unsafeTransform$lambda_16(map$lambda_12(TooltipComponent$render$lambda$lambda$lambda$lambda$lambda), $receiver_0)), toggle);
      var $receiver_1 = $receiver.mouseleaves.events;
      $receiver.handledBy_ytah3h$(new unsafeFlow$ObjectLiteral_17(unsafeTransform$lambda_16(map$lambda_12(TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_0), $receiver_1)), close);
      return Unit;
    };
  }
  function TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_1(closure$text) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(closure$text);
      return Unit;
    };
  }
  function TooltipComponent$render$lambda$lambda$lambda$lambda($receiver, text) {
    return $receiver.span_dzf5a3$(void 0, void 0, void 0, TooltipComponent$render$lambda$lambda$lambda$lambda$lambda_1(text));
  }
  function TooltipComponent$render$lambda$lambda$lambda_1(this$TooltipComponent) {
    return function ($receiver, it) {
      $receiver.renderEach_ywitts$(this$TooltipComponent.content_t1hzwo$_0(), void 0, void 0, TooltipComponent$render$lambda$lambda$lambda$lambda);
      return Unit;
    };
  }
  function TooltipComponent$render$lambda$lambda_0(this$TooltipComponent, closure$context) {
    return function ($receiver) {
      $receiver.placement.invoke_11rb$(TooltipComponent$render$lambda$lambda$lambda(this$TooltipComponent));
      $receiver.offset.invoke_11rb$(5.0);
      $receiver.trigger.invoke_11rb$(TooltipComponent$render$lambda$lambda$lambda_0(closure$context));
      $receiver.content.invoke_11rb$(TooltipComponent$render$lambda$lambda$lambda_1(this$TooltipComponent));
      return Unit;
    };
  }
  TooltipComponent.prototype.render_1f8u23$ = function (context, styling, baseClass, id, prefix) {
    return popup(context, TooltipComponent$render$lambda$lambda(styling), void 0, id != null ? id : '', void 0, TooltipComponent$render$lambda$lambda_0(this, context));
  };
  Object.defineProperty(TooltipComponent.prototype, 'events', {
    configurable: true,
    get: function () {
      return this.$delegate_1nh6uv$_0.events;
    }
  });
  function TooltipComponent$placement$lambda($receiver) {
    return Placement$Top_getInstance();
  }
  TooltipComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TooltipComponent',
    interfaces: [EventProperties]
  };
  function typeAhead$lambda($receiver) {
    return Unit;
  }
  function typeAhead$lambda_0($receiver) {
    return Unit;
  }
  function typeAhead($receiver, styling, value, items, baseClass, id, prefix, build) {
    if (styling === void 0)
      styling = typeAhead$lambda;
    if (value === void 0)
      value = null;
    if (baseClass === void 0)
      baseClass = StyleClass.Companion.None;
    if (id === void 0)
      id = value != null ? value.id : null;
    if (prefix === void 0)
      prefix = 'typeAhead';
    if (build === void 0)
      build = typeAhead$lambda_0;
    var $receiver_0 = new TypeAheadComponent(value, items);
    build($receiver_0);
    return $receiver_0.render_3fp8sc$($receiver, styling, baseClass, id, prefix);
  }
  function unsafeFlow$ObjectLiteral_18(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_18($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_18.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_18.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_18.prototype.constructor = Coroutine$collect_42ocv1$_18;
  Coroutine$collect_42ocv1$_18.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_18.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_18(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_18.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_17(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_17.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_17.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_17.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_17;
  Coroutine$unsafeTransform$lambda$lambda_17.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_17(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_17(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_17(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_17.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_17.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_17.prototype.constructor = Coroutine$unsafeTransform$lambda_17;
  Coroutine$unsafeTransform$lambda_17.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_17(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_17(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_17(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_13(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_13.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_13.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_13.prototype.constructor = Coroutine$map$lambda_13;
  Coroutine$map$lambda_13.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_13(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_13(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$flatMapLatest$lambda_0(closure$transform_0, $receiver_0, it_0, controller, c