/*
 * Decompiled with CFR 0.152.
 */
package dev.fomenko.springundocore.service;

import dev.fomenko.springundocore.UndoEventListener;
import dev.fomenko.springundocore.dto.ActionRecord;
import dev.fomenko.springundocore.property.UndoProperties;
import dev.fomenko.springundocore.service.ActionIdGenerator;
import dev.fomenko.springundocore.service.EventRecorder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class UndoService {
    private static final Log log = LogFactory.getLog(UndoService.class);
    private final Map<Class<?>, List<UndoEventListener<?>>> listeners;
    private final Supplier<LocalDateTime> timeSupplier;
    private final ActionIdGenerator idGenerator;
    private final EventRecorder eventRecorder;
    private final UndoProperties properties;

    public void deleteExpiredRecords() {
        LocalDateTime now = this.timeSupplier.get();
        List records = this.eventRecorder.getAllRecords().stream().filter(record -> now.isAfter(record.getExpiresAt())).collect(Collectors.toList());
        for (ActionRecord record2 : records) {
            boolean wasDeleted = this.eventRecorder.deleteRecordById(record2.getRecordId());
            if (!wasDeleted) continue;
            this.invokeListenersForRecord(record2, UndoEventListener::onPersist);
        }
    }

    public <T> String saveEventRecord(T action, Duration expirationTime) {
        Duration timeout = Optional.ofNullable(expirationTime).orElse(this.properties.getDefaultExpirationSec());
        LocalDateTime expiresAt = this.timeSupplier.get().plus(timeout);
        String recordId = this.idGenerator.generateId();
        ActionRecord record = ActionRecord.builder().action(action).expiresAt(expiresAt).recordId(recordId).build();
        this.eventRecorder.saveRecord(record);
        return recordId;
    }

    public void invokeListenerByRecordId(String recordId) {
        Optional<ActionRecord<?>> recordOptional = this.eventRecorder.getRecordById(recordId);
        boolean wasDeleted = this.eventRecorder.deleteRecordById(recordId);
        if (!wasDeleted) {
            return;
        }
        recordOptional.ifPresent(record -> this.invokeListenersForRecord((ActionRecord<?>)record, UndoEventListener::onUndo));
    }

    private void invokeListenersForRecord(ActionRecord<?> record, BiConsumer<UndoEventListener<? super Object>, Object> methodReference) {
        Object action = record.getAction();
        List<UndoEventListener<?>> undoEventListeners = this.listeners.get(action.getClass());
        if (!CollectionUtils.isEmpty(undoEventListeners)) {
            for (UndoEventListener<?> listener : undoEventListeners) {
                methodReference.accept(listener, action);
            }
        } else {
            log.warn((Object)("There are no listeners for " + action.getClass()));
        }
    }

    public UndoService(Map<Class<?>, List<UndoEventListener<?>>> listeners, Supplier<LocalDateTime> timeSupplier, ActionIdGenerator idGenerator, EventRecorder eventRecorder, UndoProperties properties) {
        this.listeners = listeners;
        this.timeSupplier = timeSupplier;
        this.idGenerator = idGenerator;
        this.eventRecorder = eventRecorder;
        this.properties = properties;
    }
}

