/*
 * Decompiled with CFR 0.152.
 */
package dev.fomenko.springundocore;

import dev.fomenko.springundocore.service.UndoService;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Undo {
    private final UndoService undoService;

    public <T> String publish(T action, Duration expirationTime) {
        Assert.notNull(action, (String)"action can not be null!");
        Assert.notNull((Object)expirationTime, (String)"expirationTime can not be null!");
        return this.undoService.saveEventRecord(action, expirationTime);
    }

    public <T> String publish(T action) {
        Assert.notNull(action, (String)"action can not be null!");
        return this.undoService.saveEventRecord(action, null);
    }

    public void undo(String recordId) {
        if (!StringUtils.hasLength((String)recordId)) {
            return;
        }
        this.undoService.invokeListenerByRecordId(recordId);
    }

    public Undo(UndoService undoService) {
        this.undoService = undoService;
    }
}

