package feast.proto.core;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.30.2)",
    comments = "Source: feast/core/JobService.proto")
public final class JobServiceGrpc {

  private JobServiceGrpc() {}

  public static final String SERVICE_NAME = "feast.core.JobService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest,
      feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse> getStartOfflineToOnlineIngestionJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StartOfflineToOnlineIngestionJob",
      requestType = feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest.class,
      responseType = feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest,
      feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse> getStartOfflineToOnlineIngestionJobMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest, feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse> getStartOfflineToOnlineIngestionJobMethod;
    if ((getStartOfflineToOnlineIngestionJobMethod = JobServiceGrpc.getStartOfflineToOnlineIngestionJobMethod) == null) {
      synchronized (JobServiceGrpc.class) {
        if ((getStartOfflineToOnlineIngestionJobMethod = JobServiceGrpc.getStartOfflineToOnlineIngestionJobMethod) == null) {
          JobServiceGrpc.getStartOfflineToOnlineIngestionJobMethod = getStartOfflineToOnlineIngestionJobMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest, feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "StartOfflineToOnlineIngestionJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobServiceMethodDescriptorSupplier("StartOfflineToOnlineIngestionJob"))
              .build();
        }
      }
    }
    return getStartOfflineToOnlineIngestionJobMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest,
      feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse> getGetHistoricalFeaturesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetHistoricalFeatures",
      requestType = feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest.class,
      responseType = feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest,
      feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse> getGetHistoricalFeaturesMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest, feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse> getGetHistoricalFeaturesMethod;
    if ((getGetHistoricalFeaturesMethod = JobServiceGrpc.getGetHistoricalFeaturesMethod) == null) {
      synchronized (JobServiceGrpc.class) {
        if ((getGetHistoricalFeaturesMethod = JobServiceGrpc.getGetHistoricalFeaturesMethod) == null) {
          JobServiceGrpc.getGetHistoricalFeaturesMethod = getGetHistoricalFeaturesMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest, feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetHistoricalFeatures"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobServiceMethodDescriptorSupplier("GetHistoricalFeatures"))
              .build();
        }
      }
    }
    return getGetHistoricalFeaturesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest,
      feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse> getStartStreamToOnlineIngestionJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StartStreamToOnlineIngestionJob",
      requestType = feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest.class,
      responseType = feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest,
      feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse> getStartStreamToOnlineIngestionJobMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest, feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse> getStartStreamToOnlineIngestionJobMethod;
    if ((getStartStreamToOnlineIngestionJobMethod = JobServiceGrpc.getStartStreamToOnlineIngestionJobMethod) == null) {
      synchronized (JobServiceGrpc.class) {
        if ((getStartStreamToOnlineIngestionJobMethod = JobServiceGrpc.getStartStreamToOnlineIngestionJobMethod) == null) {
          JobServiceGrpc.getStartStreamToOnlineIngestionJobMethod = getStartStreamToOnlineIngestionJobMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest, feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "StartStreamToOnlineIngestionJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobServiceMethodDescriptorSupplier("StartStreamToOnlineIngestionJob"))
              .build();
        }
      }
    }
    return getStartStreamToOnlineIngestionJobMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.ListJobsRequest,
      feast.proto.core.JobServiceProto.ListJobsResponse> getListJobsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListJobs",
      requestType = feast.proto.core.JobServiceProto.ListJobsRequest.class,
      responseType = feast.proto.core.JobServiceProto.ListJobsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.ListJobsRequest,
      feast.proto.core.JobServiceProto.ListJobsResponse> getListJobsMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.ListJobsRequest, feast.proto.core.JobServiceProto.ListJobsResponse> getListJobsMethod;
    if ((getListJobsMethod = JobServiceGrpc.getListJobsMethod) == null) {
      synchronized (JobServiceGrpc.class) {
        if ((getListJobsMethod = JobServiceGrpc.getListJobsMethod) == null) {
          JobServiceGrpc.getListJobsMethod = getListJobsMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.JobServiceProto.ListJobsRequest, feast.proto.core.JobServiceProto.ListJobsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListJobs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.ListJobsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.ListJobsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobServiceMethodDescriptorSupplier("ListJobs"))
              .build();
        }
      }
    }
    return getListJobsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.CancelJobRequest,
      feast.proto.core.JobServiceProto.CancelJobResponse> getCancelJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CancelJob",
      requestType = feast.proto.core.JobServiceProto.CancelJobRequest.class,
      responseType = feast.proto.core.JobServiceProto.CancelJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.CancelJobRequest,
      feast.proto.core.JobServiceProto.CancelJobResponse> getCancelJobMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.CancelJobRequest, feast.proto.core.JobServiceProto.CancelJobResponse> getCancelJobMethod;
    if ((getCancelJobMethod = JobServiceGrpc.getCancelJobMethod) == null) {
      synchronized (JobServiceGrpc.class) {
        if ((getCancelJobMethod = JobServiceGrpc.getCancelJobMethod) == null) {
          JobServiceGrpc.getCancelJobMethod = getCancelJobMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.JobServiceProto.CancelJobRequest, feast.proto.core.JobServiceProto.CancelJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CancelJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.CancelJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.CancelJobResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobServiceMethodDescriptorSupplier("CancelJob"))
              .build();
        }
      }
    }
    return getCancelJobMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.GetJobRequest,
      feast.proto.core.JobServiceProto.GetJobResponse> getGetJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetJob",
      requestType = feast.proto.core.JobServiceProto.GetJobRequest.class,
      responseType = feast.proto.core.JobServiceProto.GetJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.GetJobRequest,
      feast.proto.core.JobServiceProto.GetJobResponse> getGetJobMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.JobServiceProto.GetJobRequest, feast.proto.core.JobServiceProto.GetJobResponse> getGetJobMethod;
    if ((getGetJobMethod = JobServiceGrpc.getGetJobMethod) == null) {
      synchronized (JobServiceGrpc.class) {
        if ((getGetJobMethod = JobServiceGrpc.getGetJobMethod) == null) {
          JobServiceGrpc.getGetJobMethod = getGetJobMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.JobServiceProto.GetJobRequest, feast.proto.core.JobServiceProto.GetJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.GetJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.JobServiceProto.GetJobResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobServiceMethodDescriptorSupplier("GetJob"))
              .build();
        }
      }
    }
    return getGetJobMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static JobServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<JobServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<JobServiceStub>() {
        @java.lang.Override
        public JobServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new JobServiceStub(channel, callOptions);
        }
      };
    return JobServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static JobServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<JobServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<JobServiceBlockingStub>() {
        @java.lang.Override
        public JobServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new JobServiceBlockingStub(channel, callOptions);
        }
      };
    return JobServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static JobServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<JobServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<JobServiceFutureStub>() {
        @java.lang.Override
        public JobServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new JobServiceFutureStub(channel, callOptions);
        }
      };
    return JobServiceFutureStub.newStub(factory, channel);
  }

  /**
   */
  public static abstract class JobServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Start job to ingest data from offline store into online store
     * </pre>
     */
    public void startOfflineToOnlineIngestionJob(feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getStartOfflineToOnlineIngestionJobMethod(), responseObserver);
    }

    /**
     * <pre>
     * Produce a training dataset, return a job id that will provide a file reference
     * </pre>
     */
    public void getHistoricalFeatures(feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetHistoricalFeaturesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Start job to ingest data from stream into online store
     * </pre>
     */
    public void startStreamToOnlineIngestionJob(feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getStartStreamToOnlineIngestionJobMethod(), responseObserver);
    }

    /**
     * <pre>
     * List all types of jobs
     * </pre>
     */
    public void listJobs(feast.proto.core.JobServiceProto.ListJobsRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.ListJobsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListJobsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Cancel a single job
     * </pre>
     */
    public void cancelJob(feast.proto.core.JobServiceProto.CancelJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.CancelJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCancelJobMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get details of a single job
     * </pre>
     */
    public void getJob(feast.proto.core.JobServiceProto.GetJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.GetJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetJobMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getStartOfflineToOnlineIngestionJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest,
                feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse>(
                  this, METHODID_START_OFFLINE_TO_ONLINE_INGESTION_JOB)))
          .addMethod(
            getGetHistoricalFeaturesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest,
                feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse>(
                  this, METHODID_GET_HISTORICAL_FEATURES)))
          .addMethod(
            getStartStreamToOnlineIngestionJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest,
                feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse>(
                  this, METHODID_START_STREAM_TO_ONLINE_INGESTION_JOB)))
          .addMethod(
            getListJobsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.JobServiceProto.ListJobsRequest,
                feast.proto.core.JobServiceProto.ListJobsResponse>(
                  this, METHODID_LIST_JOBS)))
          .addMethod(
            getCancelJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.JobServiceProto.CancelJobRequest,
                feast.proto.core.JobServiceProto.CancelJobResponse>(
                  this, METHODID_CANCEL_JOB)))
          .addMethod(
            getGetJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.JobServiceProto.GetJobRequest,
                feast.proto.core.JobServiceProto.GetJobResponse>(
                  this, METHODID_GET_JOB)))
          .build();
    }
  }

  /**
   */
  public static final class JobServiceStub extends io.grpc.stub.AbstractAsyncStub<JobServiceStub> {
    private JobServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new JobServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Start job to ingest data from offline store into online store
     * </pre>
     */
    public void startOfflineToOnlineIngestionJob(feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getStartOfflineToOnlineIngestionJobMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Produce a training dataset, return a job id that will provide a file reference
     * </pre>
     */
    public void getHistoricalFeatures(feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetHistoricalFeaturesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Start job to ingest data from stream into online store
     * </pre>
     */
    public void startStreamToOnlineIngestionJob(feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getStartStreamToOnlineIngestionJobMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List all types of jobs
     * </pre>
     */
    public void listJobs(feast.proto.core.JobServiceProto.ListJobsRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.ListJobsResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListJobsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Cancel a single job
     * </pre>
     */
    public void cancelJob(feast.proto.core.JobServiceProto.CancelJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.CancelJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCancelJobMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get details of a single job
     * </pre>
     */
    public void getJob(feast.proto.core.JobServiceProto.GetJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.GetJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetJobMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class JobServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<JobServiceBlockingStub> {
    private JobServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new JobServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Start job to ingest data from offline store into online store
     * </pre>
     */
    public feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse startOfflineToOnlineIngestionJob(feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getStartOfflineToOnlineIngestionJobMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Produce a training dataset, return a job id that will provide a file reference
     * </pre>
     */
    public feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse getHistoricalFeatures(feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetHistoricalFeaturesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Start job to ingest data from stream into online store
     * </pre>
     */
    public feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse startStreamToOnlineIngestionJob(feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getStartStreamToOnlineIngestionJobMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List all types of jobs
     * </pre>
     */
    public feast.proto.core.JobServiceProto.ListJobsResponse listJobs(feast.proto.core.JobServiceProto.ListJobsRequest request) {
      return blockingUnaryCall(
          getChannel(), getListJobsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Cancel a single job
     * </pre>
     */
    public feast.proto.core.JobServiceProto.CancelJobResponse cancelJob(feast.proto.core.JobServiceProto.CancelJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getCancelJobMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get details of a single job
     * </pre>
     */
    public feast.proto.core.JobServiceProto.GetJobResponse getJob(feast.proto.core.JobServiceProto.GetJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetJobMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class JobServiceFutureStub extends io.grpc.stub.AbstractFutureStub<JobServiceFutureStub> {
    private JobServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new JobServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Start job to ingest data from offline store into online store
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse> startOfflineToOnlineIngestionJob(
        feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getStartOfflineToOnlineIngestionJobMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Produce a training dataset, return a job id that will provide a file reference
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse> getHistoricalFeatures(
        feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetHistoricalFeaturesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Start job to ingest data from stream into online store
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse> startStreamToOnlineIngestionJob(
        feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getStartStreamToOnlineIngestionJobMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List all types of jobs
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.JobServiceProto.ListJobsResponse> listJobs(
        feast.proto.core.JobServiceProto.ListJobsRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListJobsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Cancel a single job
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.JobServiceProto.CancelJobResponse> cancelJob(
        feast.proto.core.JobServiceProto.CancelJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCancelJobMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get details of a single job
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.JobServiceProto.GetJobResponse> getJob(
        feast.proto.core.JobServiceProto.GetJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetJobMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_START_OFFLINE_TO_ONLINE_INGESTION_JOB = 0;
  private static final int METHODID_GET_HISTORICAL_FEATURES = 1;
  private static final int METHODID_START_STREAM_TO_ONLINE_INGESTION_JOB = 2;
  private static final int METHODID_LIST_JOBS = 3;
  private static final int METHODID_CANCEL_JOB = 4;
  private static final int METHODID_GET_JOB = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final JobServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(JobServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_START_OFFLINE_TO_ONLINE_INGESTION_JOB:
          serviceImpl.startOfflineToOnlineIngestionJob((feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.StartOfflineToOnlineIngestionJobResponse>) responseObserver);
          break;
        case METHODID_GET_HISTORICAL_FEATURES:
          serviceImpl.getHistoricalFeatures((feast.proto.core.JobServiceProto.GetHistoricalFeaturesRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.GetHistoricalFeaturesResponse>) responseObserver);
          break;
        case METHODID_START_STREAM_TO_ONLINE_INGESTION_JOB:
          serviceImpl.startStreamToOnlineIngestionJob((feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.StartStreamToOnlineIngestionJobResponse>) responseObserver);
          break;
        case METHODID_LIST_JOBS:
          serviceImpl.listJobs((feast.proto.core.JobServiceProto.ListJobsRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.ListJobsResponse>) responseObserver);
          break;
        case METHODID_CANCEL_JOB:
          serviceImpl.cancelJob((feast.proto.core.JobServiceProto.CancelJobRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.CancelJobResponse>) responseObserver);
          break;
        case METHODID_GET_JOB:
          serviceImpl.getJob((feast.proto.core.JobServiceProto.GetJobRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.JobServiceProto.GetJobResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class JobServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    JobServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return feast.proto.core.JobServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("JobService");
    }
  }

  private static final class JobServiceFileDescriptorSupplier
      extends JobServiceBaseDescriptorSupplier {
    JobServiceFileDescriptorSupplier() {}
  }

  private static final class JobServiceMethodDescriptorSupplier
      extends JobServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    JobServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (JobServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new JobServiceFileDescriptorSupplier())
              .addMethod(getStartOfflineToOnlineIngestionJobMethod())
              .addMethod(getGetHistoricalFeaturesMethod())
              .addMethod(getStartStreamToOnlineIngestionJobMethod())
              .addMethod(getListJobsMethod())
              .addMethod(getCancelJobMethod())
              .addMethod(getGetJobMethod())
              .build();
        }
      }
    }
    return result;
  }
}
