package feast.proto.core;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.30.2)",
    comments = "Source: feast/core/CoreService.proto")
public final class JobControllerServiceGrpc {

  private JobControllerServiceGrpc() {}

  public static final String SERVICE_NAME = "feast.core.JobControllerService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.ListIngestionJobsRequest,
      feast.proto.core.CoreServiceProto.ListIngestionJobsResponse> getListIngestionJobsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListIngestionJobs",
      requestType = feast.proto.core.CoreServiceProto.ListIngestionJobsRequest.class,
      responseType = feast.proto.core.CoreServiceProto.ListIngestionJobsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.ListIngestionJobsRequest,
      feast.proto.core.CoreServiceProto.ListIngestionJobsResponse> getListIngestionJobsMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.ListIngestionJobsRequest, feast.proto.core.CoreServiceProto.ListIngestionJobsResponse> getListIngestionJobsMethod;
    if ((getListIngestionJobsMethod = JobControllerServiceGrpc.getListIngestionJobsMethod) == null) {
      synchronized (JobControllerServiceGrpc.class) {
        if ((getListIngestionJobsMethod = JobControllerServiceGrpc.getListIngestionJobsMethod) == null) {
          JobControllerServiceGrpc.getListIngestionJobsMethod = getListIngestionJobsMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.CoreServiceProto.ListIngestionJobsRequest, feast.proto.core.CoreServiceProto.ListIngestionJobsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListIngestionJobs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.CoreServiceProto.ListIngestionJobsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.CoreServiceProto.ListIngestionJobsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobControllerServiceMethodDescriptorSupplier("ListIngestionJobs"))
              .build();
        }
      }
    }
    return getListIngestionJobsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.RestartIngestionJobRequest,
      feast.proto.core.CoreServiceProto.RestartIngestionJobResponse> getRestartIngestionJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RestartIngestionJob",
      requestType = feast.proto.core.CoreServiceProto.RestartIngestionJobRequest.class,
      responseType = feast.proto.core.CoreServiceProto.RestartIngestionJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.RestartIngestionJobRequest,
      feast.proto.core.CoreServiceProto.RestartIngestionJobResponse> getRestartIngestionJobMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.RestartIngestionJobRequest, feast.proto.core.CoreServiceProto.RestartIngestionJobResponse> getRestartIngestionJobMethod;
    if ((getRestartIngestionJobMethod = JobControllerServiceGrpc.getRestartIngestionJobMethod) == null) {
      synchronized (JobControllerServiceGrpc.class) {
        if ((getRestartIngestionJobMethod = JobControllerServiceGrpc.getRestartIngestionJobMethod) == null) {
          JobControllerServiceGrpc.getRestartIngestionJobMethod = getRestartIngestionJobMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.CoreServiceProto.RestartIngestionJobRequest, feast.proto.core.CoreServiceProto.RestartIngestionJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RestartIngestionJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.CoreServiceProto.RestartIngestionJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.CoreServiceProto.RestartIngestionJobResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobControllerServiceMethodDescriptorSupplier("RestartIngestionJob"))
              .build();
        }
      }
    }
    return getRestartIngestionJobMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.StopIngestionJobRequest,
      feast.proto.core.CoreServiceProto.StopIngestionJobResponse> getStopIngestionJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StopIngestionJob",
      requestType = feast.proto.core.CoreServiceProto.StopIngestionJobRequest.class,
      responseType = feast.proto.core.CoreServiceProto.StopIngestionJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.StopIngestionJobRequest,
      feast.proto.core.CoreServiceProto.StopIngestionJobResponse> getStopIngestionJobMethod() {
    io.grpc.MethodDescriptor<feast.proto.core.CoreServiceProto.StopIngestionJobRequest, feast.proto.core.CoreServiceProto.StopIngestionJobResponse> getStopIngestionJobMethod;
    if ((getStopIngestionJobMethod = JobControllerServiceGrpc.getStopIngestionJobMethod) == null) {
      synchronized (JobControllerServiceGrpc.class) {
        if ((getStopIngestionJobMethod = JobControllerServiceGrpc.getStopIngestionJobMethod) == null) {
          JobControllerServiceGrpc.getStopIngestionJobMethod = getStopIngestionJobMethod =
              io.grpc.MethodDescriptor.<feast.proto.core.CoreServiceProto.StopIngestionJobRequest, feast.proto.core.CoreServiceProto.StopIngestionJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "StopIngestionJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.CoreServiceProto.StopIngestionJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.proto.core.CoreServiceProto.StopIngestionJobResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobControllerServiceMethodDescriptorSupplier("StopIngestionJob"))
              .build();
        }
      }
    }
    return getStopIngestionJobMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static JobControllerServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<JobControllerServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<JobControllerServiceStub>() {
        @java.lang.Override
        public JobControllerServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new JobControllerServiceStub(channel, callOptions);
        }
      };
    return JobControllerServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static JobControllerServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<JobControllerServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<JobControllerServiceBlockingStub>() {
        @java.lang.Override
        public JobControllerServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new JobControllerServiceBlockingStub(channel, callOptions);
        }
      };
    return JobControllerServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static JobControllerServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<JobControllerServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<JobControllerServiceFutureStub>() {
        @java.lang.Override
        public JobControllerServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new JobControllerServiceFutureStub(channel, callOptions);
        }
      };
    return JobControllerServiceFutureStub.newStub(factory, channel);
  }

  /**
   */
  public static abstract class JobControllerServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * List Ingestion Jobs given an optional filter.
     * Returns allow ingestions matching the given request filter.
     * Returns all ingestion jobs if no filter is provided.
     * Returns an empty list if no ingestion jobs match the filter.
     * </pre>
     */
    public void listIngestionJobs(feast.proto.core.CoreServiceProto.ListIngestionJobsRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.ListIngestionJobsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListIngestionJobsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Restart an Ingestion Job.  Restarts the ingestion job with the given job id.
     * NOTE: Data might be lost during the restart for some job runners.
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting),
     * terminal state (ie suspended or aborted) or unknown status
     * </pre>
     */
    public void restartIngestionJob(feast.proto.core.CoreServiceProto.RestartIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.RestartIngestionJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRestartIngestionJobMethod(), responseObserver);
    }

    /**
     * <pre>
     * Stop an Ingestion Job.  Stop (Aborts) the ingestion job with the given job id.
     * Does nothing if the target job if already in a terminal state (ie suspended or aborted).
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting) or unknown status
     * </pre>
     */
    public void stopIngestionJob(feast.proto.core.CoreServiceProto.StopIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.StopIngestionJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getStopIngestionJobMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getListIngestionJobsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.CoreServiceProto.ListIngestionJobsRequest,
                feast.proto.core.CoreServiceProto.ListIngestionJobsResponse>(
                  this, METHODID_LIST_INGESTION_JOBS)))
          .addMethod(
            getRestartIngestionJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.CoreServiceProto.RestartIngestionJobRequest,
                feast.proto.core.CoreServiceProto.RestartIngestionJobResponse>(
                  this, METHODID_RESTART_INGESTION_JOB)))
          .addMethod(
            getStopIngestionJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.proto.core.CoreServiceProto.StopIngestionJobRequest,
                feast.proto.core.CoreServiceProto.StopIngestionJobResponse>(
                  this, METHODID_STOP_INGESTION_JOB)))
          .build();
    }
  }

  /**
   */
  public static final class JobControllerServiceStub extends io.grpc.stub.AbstractAsyncStub<JobControllerServiceStub> {
    private JobControllerServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobControllerServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new JobControllerServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * List Ingestion Jobs given an optional filter.
     * Returns allow ingestions matching the given request filter.
     * Returns all ingestion jobs if no filter is provided.
     * Returns an empty list if no ingestion jobs match the filter.
     * </pre>
     */
    public void listIngestionJobs(feast.proto.core.CoreServiceProto.ListIngestionJobsRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.ListIngestionJobsResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListIngestionJobsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Restart an Ingestion Job.  Restarts the ingestion job with the given job id.
     * NOTE: Data might be lost during the restart for some job runners.
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting),
     * terminal state (ie suspended or aborted) or unknown status
     * </pre>
     */
    public void restartIngestionJob(feast.proto.core.CoreServiceProto.RestartIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.RestartIngestionJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRestartIngestionJobMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Stop an Ingestion Job.  Stop (Aborts) the ingestion job with the given job id.
     * Does nothing if the target job if already in a terminal state (ie suspended or aborted).
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting) or unknown status
     * </pre>
     */
    public void stopIngestionJob(feast.proto.core.CoreServiceProto.StopIngestionJobRequest request,
        io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.StopIngestionJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getStopIngestionJobMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class JobControllerServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<JobControllerServiceBlockingStub> {
    private JobControllerServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobControllerServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new JobControllerServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * List Ingestion Jobs given an optional filter.
     * Returns allow ingestions matching the given request filter.
     * Returns all ingestion jobs if no filter is provided.
     * Returns an empty list if no ingestion jobs match the filter.
     * </pre>
     */
    public feast.proto.core.CoreServiceProto.ListIngestionJobsResponse listIngestionJobs(feast.proto.core.CoreServiceProto.ListIngestionJobsRequest request) {
      return blockingUnaryCall(
          getChannel(), getListIngestionJobsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Restart an Ingestion Job.  Restarts the ingestion job with the given job id.
     * NOTE: Data might be lost during the restart for some job runners.
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting),
     * terminal state (ie suspended or aborted) or unknown status
     * </pre>
     */
    public feast.proto.core.CoreServiceProto.RestartIngestionJobResponse restartIngestionJob(feast.proto.core.CoreServiceProto.RestartIngestionJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getRestartIngestionJobMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Stop an Ingestion Job.  Stop (Aborts) the ingestion job with the given job id.
     * Does nothing if the target job if already in a terminal state (ie suspended or aborted).
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting) or unknown status
     * </pre>
     */
    public feast.proto.core.CoreServiceProto.StopIngestionJobResponse stopIngestionJob(feast.proto.core.CoreServiceProto.StopIngestionJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getStopIngestionJobMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class JobControllerServiceFutureStub extends io.grpc.stub.AbstractFutureStub<JobControllerServiceFutureStub> {
    private JobControllerServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobControllerServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new JobControllerServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * List Ingestion Jobs given an optional filter.
     * Returns allow ingestions matching the given request filter.
     * Returns all ingestion jobs if no filter is provided.
     * Returns an empty list if no ingestion jobs match the filter.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.CoreServiceProto.ListIngestionJobsResponse> listIngestionJobs(
        feast.proto.core.CoreServiceProto.ListIngestionJobsRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListIngestionJobsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Restart an Ingestion Job.  Restarts the ingestion job with the given job id.
     * NOTE: Data might be lost during the restart for some job runners.
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting),
     * terminal state (ie suspended or aborted) or unknown status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.CoreServiceProto.RestartIngestionJobResponse> restartIngestionJob(
        feast.proto.core.CoreServiceProto.RestartIngestionJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRestartIngestionJobMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Stop an Ingestion Job.  Stop (Aborts) the ingestion job with the given job id.
     * Does nothing if the target job if already in a terminal state (ie suspended or aborted).
     * Does not support stopping a job in a transitional (ie pending, suspending, aborting) or unknown status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.proto.core.CoreServiceProto.StopIngestionJobResponse> stopIngestionJob(
        feast.proto.core.CoreServiceProto.StopIngestionJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getStopIngestionJobMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_INGESTION_JOBS = 0;
  private static final int METHODID_RESTART_INGESTION_JOB = 1;
  private static final int METHODID_STOP_INGESTION_JOB = 2;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final JobControllerServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(JobControllerServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_INGESTION_JOBS:
          serviceImpl.listIngestionJobs((feast.proto.core.CoreServiceProto.ListIngestionJobsRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.ListIngestionJobsResponse>) responseObserver);
          break;
        case METHODID_RESTART_INGESTION_JOB:
          serviceImpl.restartIngestionJob((feast.proto.core.CoreServiceProto.RestartIngestionJobRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.RestartIngestionJobResponse>) responseObserver);
          break;
        case METHODID_STOP_INGESTION_JOB:
          serviceImpl.stopIngestionJob((feast.proto.core.CoreServiceProto.StopIngestionJobRequest) request,
              (io.grpc.stub.StreamObserver<feast.proto.core.CoreServiceProto.StopIngestionJobResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class JobControllerServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    JobControllerServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return feast.proto.core.CoreServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("JobControllerService");
    }
  }

  private static final class JobControllerServiceFileDescriptorSupplier
      extends JobControllerServiceBaseDescriptorSupplier {
    JobControllerServiceFileDescriptorSupplier() {}
  }

  private static final class JobControllerServiceMethodDescriptorSupplier
      extends JobControllerServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    JobControllerServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (JobControllerServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new JobControllerServiceFileDescriptorSupplier())
              .addMethod(getListIngestionJobsMethod())
              .addMethod(getRestartIngestionJobMethod())
              .addMethod(getStopIngestionJobMethod())
              .build();
        }
      }
    }
    return result;
  }
}
