package feast.core;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.17.1)",
    comments = "Source: feast/core/CoreService.proto")
public final class CoreServiceGrpc {

  private CoreServiceGrpc() {}

  public static final String SERVICE_NAME = "feast.core.CoreService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<feast.core.CoreServiceProto.GetFeastCoreVersionRequest,
      feast.core.CoreServiceProto.GetFeastCoreVersionResponse> getGetFeastCoreVersionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFeastCoreVersion",
      requestType = feast.core.CoreServiceProto.GetFeastCoreVersionRequest.class,
      responseType = feast.core.CoreServiceProto.GetFeastCoreVersionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.core.CoreServiceProto.GetFeastCoreVersionRequest,
      feast.core.CoreServiceProto.GetFeastCoreVersionResponse> getGetFeastCoreVersionMethod() {
    io.grpc.MethodDescriptor<feast.core.CoreServiceProto.GetFeastCoreVersionRequest, feast.core.CoreServiceProto.GetFeastCoreVersionResponse> getGetFeastCoreVersionMethod;
    if ((getGetFeastCoreVersionMethod = CoreServiceGrpc.getGetFeastCoreVersionMethod) == null) {
      synchronized (CoreServiceGrpc.class) {
        if ((getGetFeastCoreVersionMethod = CoreServiceGrpc.getGetFeastCoreVersionMethod) == null) {
          CoreServiceGrpc.getGetFeastCoreVersionMethod = getGetFeastCoreVersionMethod = 
              io.grpc.MethodDescriptor.<feast.core.CoreServiceProto.GetFeastCoreVersionRequest, feast.core.CoreServiceProto.GetFeastCoreVersionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "feast.core.CoreService", "GetFeastCoreVersion"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.GetFeastCoreVersionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.GetFeastCoreVersionResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CoreServiceMethodDescriptorSupplier("GetFeastCoreVersion"))
                  .build();
          }
        }
     }
     return getGetFeastCoreVersionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.core.CoreServiceProto.GetFeatureSetRequest,
      feast.core.CoreServiceProto.GetFeatureSetResponse> getGetFeatureSetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFeatureSet",
      requestType = feast.core.CoreServiceProto.GetFeatureSetRequest.class,
      responseType = feast.core.CoreServiceProto.GetFeatureSetResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.core.CoreServiceProto.GetFeatureSetRequest,
      feast.core.CoreServiceProto.GetFeatureSetResponse> getGetFeatureSetMethod() {
    io.grpc.MethodDescriptor<feast.core.CoreServiceProto.GetFeatureSetRequest, feast.core.CoreServiceProto.GetFeatureSetResponse> getGetFeatureSetMethod;
    if ((getGetFeatureSetMethod = CoreServiceGrpc.getGetFeatureSetMethod) == null) {
      synchronized (CoreServiceGrpc.class) {
        if ((getGetFeatureSetMethod = CoreServiceGrpc.getGetFeatureSetMethod) == null) {
          CoreServiceGrpc.getGetFeatureSetMethod = getGetFeatureSetMethod = 
              io.grpc.MethodDescriptor.<feast.core.CoreServiceProto.GetFeatureSetRequest, feast.core.CoreServiceProto.GetFeatureSetResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "feast.core.CoreService", "GetFeatureSet"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.GetFeatureSetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.GetFeatureSetResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CoreServiceMethodDescriptorSupplier("GetFeatureSet"))
                  .build();
          }
        }
     }
     return getGetFeatureSetMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ListFeatureSetsRequest,
      feast.core.CoreServiceProto.ListFeatureSetsResponse> getListFeatureSetsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListFeatureSets",
      requestType = feast.core.CoreServiceProto.ListFeatureSetsRequest.class,
      responseType = feast.core.CoreServiceProto.ListFeatureSetsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ListFeatureSetsRequest,
      feast.core.CoreServiceProto.ListFeatureSetsResponse> getListFeatureSetsMethod() {
    io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ListFeatureSetsRequest, feast.core.CoreServiceProto.ListFeatureSetsResponse> getListFeatureSetsMethod;
    if ((getListFeatureSetsMethod = CoreServiceGrpc.getListFeatureSetsMethod) == null) {
      synchronized (CoreServiceGrpc.class) {
        if ((getListFeatureSetsMethod = CoreServiceGrpc.getListFeatureSetsMethod) == null) {
          CoreServiceGrpc.getListFeatureSetsMethod = getListFeatureSetsMethod = 
              io.grpc.MethodDescriptor.<feast.core.CoreServiceProto.ListFeatureSetsRequest, feast.core.CoreServiceProto.ListFeatureSetsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "feast.core.CoreService", "ListFeatureSets"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.ListFeatureSetsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.ListFeatureSetsResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CoreServiceMethodDescriptorSupplier("ListFeatureSets"))
                  .build();
          }
        }
     }
     return getListFeatureSetsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ListStoresRequest,
      feast.core.CoreServiceProto.ListStoresResponse> getListStoresMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListStores",
      requestType = feast.core.CoreServiceProto.ListStoresRequest.class,
      responseType = feast.core.CoreServiceProto.ListStoresResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ListStoresRequest,
      feast.core.CoreServiceProto.ListStoresResponse> getListStoresMethod() {
    io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ListStoresRequest, feast.core.CoreServiceProto.ListStoresResponse> getListStoresMethod;
    if ((getListStoresMethod = CoreServiceGrpc.getListStoresMethod) == null) {
      synchronized (CoreServiceGrpc.class) {
        if ((getListStoresMethod = CoreServiceGrpc.getListStoresMethod) == null) {
          CoreServiceGrpc.getListStoresMethod = getListStoresMethod = 
              io.grpc.MethodDescriptor.<feast.core.CoreServiceProto.ListStoresRequest, feast.core.CoreServiceProto.ListStoresResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "feast.core.CoreService", "ListStores"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.ListStoresRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.ListStoresResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CoreServiceMethodDescriptorSupplier("ListStores"))
                  .build();
          }
        }
     }
     return getListStoresMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ApplyFeatureSetRequest,
      feast.core.CoreServiceProto.ApplyFeatureSetResponse> getApplyFeatureSetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ApplyFeatureSet",
      requestType = feast.core.CoreServiceProto.ApplyFeatureSetRequest.class,
      responseType = feast.core.CoreServiceProto.ApplyFeatureSetResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ApplyFeatureSetRequest,
      feast.core.CoreServiceProto.ApplyFeatureSetResponse> getApplyFeatureSetMethod() {
    io.grpc.MethodDescriptor<feast.core.CoreServiceProto.ApplyFeatureSetRequest, feast.core.CoreServiceProto.ApplyFeatureSetResponse> getApplyFeatureSetMethod;
    if ((getApplyFeatureSetMethod = CoreServiceGrpc.getApplyFeatureSetMethod) == null) {
      synchronized (CoreServiceGrpc.class) {
        if ((getApplyFeatureSetMethod = CoreServiceGrpc.getApplyFeatureSetMethod) == null) {
          CoreServiceGrpc.getApplyFeatureSetMethod = getApplyFeatureSetMethod = 
              io.grpc.MethodDescriptor.<feast.core.CoreServiceProto.ApplyFeatureSetRequest, feast.core.CoreServiceProto.ApplyFeatureSetResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "feast.core.CoreService", "ApplyFeatureSet"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.ApplyFeatureSetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.ApplyFeatureSetResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CoreServiceMethodDescriptorSupplier("ApplyFeatureSet"))
                  .build();
          }
        }
     }
     return getApplyFeatureSetMethod;
  }

  private static volatile io.grpc.MethodDescriptor<feast.core.CoreServiceProto.UpdateStoreRequest,
      feast.core.CoreServiceProto.UpdateStoreResponse> getUpdateStoreMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateStore",
      requestType = feast.core.CoreServiceProto.UpdateStoreRequest.class,
      responseType = feast.core.CoreServiceProto.UpdateStoreResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<feast.core.CoreServiceProto.UpdateStoreRequest,
      feast.core.CoreServiceProto.UpdateStoreResponse> getUpdateStoreMethod() {
    io.grpc.MethodDescriptor<feast.core.CoreServiceProto.UpdateStoreRequest, feast.core.CoreServiceProto.UpdateStoreResponse> getUpdateStoreMethod;
    if ((getUpdateStoreMethod = CoreServiceGrpc.getUpdateStoreMethod) == null) {
      synchronized (CoreServiceGrpc.class) {
        if ((getUpdateStoreMethod = CoreServiceGrpc.getUpdateStoreMethod) == null) {
          CoreServiceGrpc.getUpdateStoreMethod = getUpdateStoreMethod = 
              io.grpc.MethodDescriptor.<feast.core.CoreServiceProto.UpdateStoreRequest, feast.core.CoreServiceProto.UpdateStoreResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "feast.core.CoreService", "UpdateStore"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.UpdateStoreRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  feast.core.CoreServiceProto.UpdateStoreResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CoreServiceMethodDescriptorSupplier("UpdateStore"))
                  .build();
          }
        }
     }
     return getUpdateStoreMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static CoreServiceStub newStub(io.grpc.Channel channel) {
    return new CoreServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static CoreServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new CoreServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static CoreServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new CoreServiceFutureStub(channel);
  }

  /**
   */
  public static abstract class CoreServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Retrieve version information about this Feast deployment
     * </pre>
     */
    public void getFeastCoreVersion(feast.core.CoreServiceProto.GetFeastCoreVersionRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.GetFeastCoreVersionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetFeastCoreVersionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Returns a specific feature set
     * </pre>
     */
    public void getFeatureSet(feast.core.CoreServiceProto.GetFeatureSetRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.GetFeatureSetResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetFeatureSetMethod(), responseObserver);
    }

    /**
     * <pre>
     * Retrieve feature set details given a filter.
     * Returns all feature sets matching that filter. If none are found,
     * an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the feature
     * sets currently stored in the registry.
     * </pre>
     */
    public void listFeatureSets(feast.core.CoreServiceProto.ListFeatureSetsRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ListFeatureSetsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListFeatureSetsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Retrieve store details given a filter.
     * Returns all stores matching that filter. If none are found, an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the stores currently
     * stored in the registry.
     * </pre>
     */
    public void listStores(feast.core.CoreServiceProto.ListStoresRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ListStoresResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListStoresMethod(), responseObserver);
    }

    /**
     * <pre>
     * Create or update and existing feature set.
     * This function is idempotent - it will not create a new feature set if schema does not change.
     * If an existing feature set is updated, core will advance the version number, which will be
     * returned in response.
     * </pre>
     */
    public void applyFeatureSet(feast.core.CoreServiceProto.ApplyFeatureSetRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ApplyFeatureSetResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getApplyFeatureSetMethod(), responseObserver);
    }

    /**
     * <pre>
     * Updates core with the configuration of the store.
     * If the changes are valid, core will return the given store configuration in response, and
     * start or update the necessary feature population jobs for the updated store.
     * </pre>
     */
    public void updateStore(feast.core.CoreServiceProto.UpdateStoreRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.UpdateStoreResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUpdateStoreMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetFeastCoreVersionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.core.CoreServiceProto.GetFeastCoreVersionRequest,
                feast.core.CoreServiceProto.GetFeastCoreVersionResponse>(
                  this, METHODID_GET_FEAST_CORE_VERSION)))
          .addMethod(
            getGetFeatureSetMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.core.CoreServiceProto.GetFeatureSetRequest,
                feast.core.CoreServiceProto.GetFeatureSetResponse>(
                  this, METHODID_GET_FEATURE_SET)))
          .addMethod(
            getListFeatureSetsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.core.CoreServiceProto.ListFeatureSetsRequest,
                feast.core.CoreServiceProto.ListFeatureSetsResponse>(
                  this, METHODID_LIST_FEATURE_SETS)))
          .addMethod(
            getListStoresMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.core.CoreServiceProto.ListStoresRequest,
                feast.core.CoreServiceProto.ListStoresResponse>(
                  this, METHODID_LIST_STORES)))
          .addMethod(
            getApplyFeatureSetMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.core.CoreServiceProto.ApplyFeatureSetRequest,
                feast.core.CoreServiceProto.ApplyFeatureSetResponse>(
                  this, METHODID_APPLY_FEATURE_SET)))
          .addMethod(
            getUpdateStoreMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                feast.core.CoreServiceProto.UpdateStoreRequest,
                feast.core.CoreServiceProto.UpdateStoreResponse>(
                  this, METHODID_UPDATE_STORE)))
          .build();
    }
  }

  /**
   */
  public static final class CoreServiceStub extends io.grpc.stub.AbstractStub<CoreServiceStub> {
    private CoreServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CoreServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CoreServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CoreServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Retrieve version information about this Feast deployment
     * </pre>
     */
    public void getFeastCoreVersion(feast.core.CoreServiceProto.GetFeastCoreVersionRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.GetFeastCoreVersionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetFeastCoreVersionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Returns a specific feature set
     * </pre>
     */
    public void getFeatureSet(feast.core.CoreServiceProto.GetFeatureSetRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.GetFeatureSetResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetFeatureSetMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieve feature set details given a filter.
     * Returns all feature sets matching that filter. If none are found,
     * an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the feature
     * sets currently stored in the registry.
     * </pre>
     */
    public void listFeatureSets(feast.core.CoreServiceProto.ListFeatureSetsRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ListFeatureSetsResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListFeatureSetsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieve store details given a filter.
     * Returns all stores matching that filter. If none are found, an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the stores currently
     * stored in the registry.
     * </pre>
     */
    public void listStores(feast.core.CoreServiceProto.ListStoresRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ListStoresResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListStoresMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Create or update and existing feature set.
     * This function is idempotent - it will not create a new feature set if schema does not change.
     * If an existing feature set is updated, core will advance the version number, which will be
     * returned in response.
     * </pre>
     */
    public void applyFeatureSet(feast.core.CoreServiceProto.ApplyFeatureSetRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ApplyFeatureSetResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getApplyFeatureSetMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Updates core with the configuration of the store.
     * If the changes are valid, core will return the given store configuration in response, and
     * start or update the necessary feature population jobs for the updated store.
     * </pre>
     */
    public void updateStore(feast.core.CoreServiceProto.UpdateStoreRequest request,
        io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.UpdateStoreResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUpdateStoreMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class CoreServiceBlockingStub extends io.grpc.stub.AbstractStub<CoreServiceBlockingStub> {
    private CoreServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CoreServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CoreServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CoreServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Retrieve version information about this Feast deployment
     * </pre>
     */
    public feast.core.CoreServiceProto.GetFeastCoreVersionResponse getFeastCoreVersion(feast.core.CoreServiceProto.GetFeastCoreVersionRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetFeastCoreVersionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Returns a specific feature set
     * </pre>
     */
    public feast.core.CoreServiceProto.GetFeatureSetResponse getFeatureSet(feast.core.CoreServiceProto.GetFeatureSetRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetFeatureSetMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieve feature set details given a filter.
     * Returns all feature sets matching that filter. If none are found,
     * an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the feature
     * sets currently stored in the registry.
     * </pre>
     */
    public feast.core.CoreServiceProto.ListFeatureSetsResponse listFeatureSets(feast.core.CoreServiceProto.ListFeatureSetsRequest request) {
      return blockingUnaryCall(
          getChannel(), getListFeatureSetsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieve store details given a filter.
     * Returns all stores matching that filter. If none are found, an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the stores currently
     * stored in the registry.
     * </pre>
     */
    public feast.core.CoreServiceProto.ListStoresResponse listStores(feast.core.CoreServiceProto.ListStoresRequest request) {
      return blockingUnaryCall(
          getChannel(), getListStoresMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Create or update and existing feature set.
     * This function is idempotent - it will not create a new feature set if schema does not change.
     * If an existing feature set is updated, core will advance the version number, which will be
     * returned in response.
     * </pre>
     */
    public feast.core.CoreServiceProto.ApplyFeatureSetResponse applyFeatureSet(feast.core.CoreServiceProto.ApplyFeatureSetRequest request) {
      return blockingUnaryCall(
          getChannel(), getApplyFeatureSetMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Updates core with the configuration of the store.
     * If the changes are valid, core will return the given store configuration in response, and
     * start or update the necessary feature population jobs for the updated store.
     * </pre>
     */
    public feast.core.CoreServiceProto.UpdateStoreResponse updateStore(feast.core.CoreServiceProto.UpdateStoreRequest request) {
      return blockingUnaryCall(
          getChannel(), getUpdateStoreMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class CoreServiceFutureStub extends io.grpc.stub.AbstractStub<CoreServiceFutureStub> {
    private CoreServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CoreServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CoreServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CoreServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Retrieve version information about this Feast deployment
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.core.CoreServiceProto.GetFeastCoreVersionResponse> getFeastCoreVersion(
        feast.core.CoreServiceProto.GetFeastCoreVersionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetFeastCoreVersionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Returns a specific feature set
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.core.CoreServiceProto.GetFeatureSetResponse> getFeatureSet(
        feast.core.CoreServiceProto.GetFeatureSetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetFeatureSetMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Retrieve feature set details given a filter.
     * Returns all feature sets matching that filter. If none are found,
     * an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the feature
     * sets currently stored in the registry.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.core.CoreServiceProto.ListFeatureSetsResponse> listFeatureSets(
        feast.core.CoreServiceProto.ListFeatureSetsRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListFeatureSetsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Retrieve store details given a filter.
     * Returns all stores matching that filter. If none are found, an empty list will be returned.
     * If no filter is provided in the request, the response will contain all the stores currently
     * stored in the registry.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.core.CoreServiceProto.ListStoresResponse> listStores(
        feast.core.CoreServiceProto.ListStoresRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListStoresMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Create or update and existing feature set.
     * This function is idempotent - it will not create a new feature set if schema does not change.
     * If an existing feature set is updated, core will advance the version number, which will be
     * returned in response.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.core.CoreServiceProto.ApplyFeatureSetResponse> applyFeatureSet(
        feast.core.CoreServiceProto.ApplyFeatureSetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getApplyFeatureSetMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Updates core with the configuration of the store.
     * If the changes are valid, core will return the given store configuration in response, and
     * start or update the necessary feature population jobs for the updated store.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<feast.core.CoreServiceProto.UpdateStoreResponse> updateStore(
        feast.core.CoreServiceProto.UpdateStoreRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUpdateStoreMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_FEAST_CORE_VERSION = 0;
  private static final int METHODID_GET_FEATURE_SET = 1;
  private static final int METHODID_LIST_FEATURE_SETS = 2;
  private static final int METHODID_LIST_STORES = 3;
  private static final int METHODID_APPLY_FEATURE_SET = 4;
  private static final int METHODID_UPDATE_STORE = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final CoreServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(CoreServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_FEAST_CORE_VERSION:
          serviceImpl.getFeastCoreVersion((feast.core.CoreServiceProto.GetFeastCoreVersionRequest) request,
              (io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.GetFeastCoreVersionResponse>) responseObserver);
          break;
        case METHODID_GET_FEATURE_SET:
          serviceImpl.getFeatureSet((feast.core.CoreServiceProto.GetFeatureSetRequest) request,
              (io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.GetFeatureSetResponse>) responseObserver);
          break;
        case METHODID_LIST_FEATURE_SETS:
          serviceImpl.listFeatureSets((feast.core.CoreServiceProto.ListFeatureSetsRequest) request,
              (io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ListFeatureSetsResponse>) responseObserver);
          break;
        case METHODID_LIST_STORES:
          serviceImpl.listStores((feast.core.CoreServiceProto.ListStoresRequest) request,
              (io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ListStoresResponse>) responseObserver);
          break;
        case METHODID_APPLY_FEATURE_SET:
          serviceImpl.applyFeatureSet((feast.core.CoreServiceProto.ApplyFeatureSetRequest) request,
              (io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.ApplyFeatureSetResponse>) responseObserver);
          break;
        case METHODID_UPDATE_STORE:
          serviceImpl.updateStore((feast.core.CoreServiceProto.UpdateStoreRequest) request,
              (io.grpc.stub.StreamObserver<feast.core.CoreServiceProto.UpdateStoreResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class CoreServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    CoreServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return feast.core.CoreServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("CoreService");
    }
  }

  private static final class CoreServiceFileDescriptorSupplier
      extends CoreServiceBaseDescriptorSupplier {
    CoreServiceFileDescriptorSupplier() {}
  }

  private static final class CoreServiceMethodDescriptorSupplier
      extends CoreServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    CoreServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (CoreServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new CoreServiceFileDescriptorSupplier())
              .addMethod(getGetFeastCoreVersionMethod())
              .addMethod(getGetFeatureSetMethod())
              .addMethod(getListFeatureSetsMethod())
              .addMethod(getListStoresMethod())
              .addMethod(getApplyFeatureSetMethod())
              .addMethod(getUpdateStoreMethod())
              .build();
        }
      }
    }
    return result;
  }
}
