/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.util;

import dev.fastball.ui.common.ValidationRule;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class ValidationCompileUtils {
    private ValidationCompileUtils() {
    }

    public static List<ValidationRule> compileFieldJsr303(VariableElement field) {
        Pattern pattern;
        NotNull notNull;
        Size size;
        Max max;
        ArrayList<ValidationRule> validationRules = new ArrayList<ValidationRule>();
        Min min = field.getAnnotation(Min.class);
        if (min != null) {
            validationRules.add(ValidationRule.builder().type("number").min(min.value()).message(min.message()).build());
        }
        if ((max = field.getAnnotation(Max.class)) != null) {
            validationRules.add(ValidationRule.builder().type("number").max(max.value()).message(max.message()).build());
        }
        if ((size = field.getAnnotation(Size.class)) != null) {
            validationRules.add(ValidationRule.builder().type("string").min(size.min()).max(size.max()).message(size.message()).build());
        }
        if ((notNull = field.getAnnotation(NotNull.class)) != null) {
            validationRules.add(ValidationRule.builder().required(true).message(notNull.message()).build());
        }
        if ((pattern = field.getAnnotation(Pattern.class)) != null) {
            validationRules.add(ValidationRule.builder().pattern(pattern.regexp()).message(pattern.message()).build());
        }
        return validationRules;
    }
}

