/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.util;

import dev.fastball.ui.common.ValidationRule;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.VariableElement;

public class JakartaValidationCompileUtils {
    private JakartaValidationCompileUtils() {
    }

    public static List<ValidationRule> compileFieldJsr303(VariableElement field) {
        Pattern pattern;
        NotNull notNull;
        Size size;
        Max max;
        ArrayList<ValidationRule> validationRules = new ArrayList<ValidationRule>();
        Min min = field.getAnnotation(Min.class);
        if (min != null) {
            validationRules.add(ValidationRule.builder().type("number").min(min.value()).message(min.message()).build());
        }
        if ((max = field.getAnnotation(Max.class)) != null) {
            validationRules.add(ValidationRule.builder().type("number").max(max.value()).message(max.message()).build());
        }
        if ((size = field.getAnnotation(Size.class)) != null) {
            validationRules.add(ValidationRule.builder().type("string").min(size.min()).max(size.max()).message(size.message()).build());
        }
        if ((notNull = field.getAnnotation(NotNull.class)) != null) {
            validationRules.add(ValidationRule.builder().required(true).message(notNull.message()).build());
        }
        if ((pattern = field.getAnnotation(Pattern.class)) != null) {
            validationRules.add(ValidationRule.builder().pattern(pattern.regexp()).message(pattern.message()).build());
        }
        return validationRules;
    }
}

