/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.components.table;

import dev.fastball.compile.AbstractComponentCompiler;
import dev.fastball.compile.CompileContext;
import dev.fastball.compile.utils.CompileUtils;
import dev.fastball.core.component.Component;
import dev.fastball.ui.annotation.Action;
import dev.fastball.ui.annotation.RecordAction;
import dev.fastball.ui.common.ActionInfo;
import dev.fastball.ui.common.PopupActionInfo_AutoValue;
import dev.fastball.ui.common.RefreshApiActionInfo_AutoValue;
import dev.fastball.ui.common.RefreshPopupActionInfo_AutoValue;
import dev.fastball.ui.components.table.ColumnInfo;
import dev.fastball.ui.components.table.Table;
import dev.fastball.ui.components.table.TableProps;
import dev.fastball.ui.components.table.TableProps_AutoValue;
import dev.fastball.ui.util.TypeCompileUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class TableCompiler
extends AbstractComponentCompiler<Table<?, ?>, TableProps> {
    private static final String COMPONENT_TYPE = "FastballTable";

    protected TableProps compileProps(CompileContext compileContext) {
        TableProps_AutoValue props = new TableProps_AutoValue();
        this.compileBasicConfig(compileContext, props);
        this.compileButtons(compileContext, props);
        this.compileRecordActions(compileContext, props);
        return props;
    }

    protected String getComponentName() {
        return COMPONENT_TYPE;
    }

    private List<ColumnInfo> buildTableColumnsFromReturnType(TypeElement returnType, ProcessingEnvironment processingEnv) {
        return TypeCompileUtils.compileTypeFields(returnType, processingEnv, ColumnInfo::new, (field, tableColumn) -> {
            Table.Sortable sortable = field.getAnnotation(Table.Sortable.class);
            if (sortable != null) {
                tableColumn.setSortable(true);
            }
        });
    }

    private void compileRecordActions(CompileContext compileContext, TableProps_AutoValue props) {
        List<ActionInfo> recordActions = CompileUtils.getMethods((TypeElement)compileContext.getComponentElement(), (ProcessingEnvironment)compileContext.getProcessingEnv()).values().stream().map(method -> {
            RecordAction actionAnnotation = method.getAnnotation(RecordAction.class);
            if (actionAnnotation == null) {
                return null;
            }
            RefreshApiActionInfo_AutoValue actionInfo = new RefreshApiActionInfo_AutoValue();
            actionInfo.actionKey(method.getSimpleName().toString());
            actionInfo.actionName(actionAnnotation.value());
            actionInfo.refresh(true);
            return actionInfo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Table.Config tableConfig = compileContext.getComponentElement().getAnnotation(Table.Config.class);
        if (tableConfig != null) {
            for (Action action : tableConfig.recordActions()) {
                RefreshPopupActionInfo_AutoValue actionInfo = new RefreshPopupActionInfo_AutoValue();
                actionInfo.popupComponent(this.getReferencedComponentInfo(props, () -> ((Action)action).component()));
                actionInfo.refresh(true);
                actionInfo.popupTitle(action.popupTitle());
                actionInfo.popupType(action.popupType());
                actionInfo.drawerPlacementType(action.drawerPlacementType());
                actionInfo.actionName(action.value());
                recordActions.add(actionInfo);
            }
        }
        props.recordActions(recordActions);
    }

    private void compileButtons(CompileContext compileContext, TableProps_AutoValue props) {
        Table.Config tableConfig = compileContext.getComponentElement().getAnnotation(Table.Config.class);
        if (tableConfig == null) {
            return;
        }
        List<ActionInfo> actionInfoList = Arrays.stream(tableConfig.actions()).map(action -> {
            PopupActionInfo_AutoValue actionInfo = new PopupActionInfo_AutoValue();
            actionInfo.popupTitle(action.popupTitle());
            actionInfo.popupType(action.popupType());
            actionInfo.drawerPlacementType(action.drawerPlacementType());
            actionInfo.popupComponent(this.getReferencedComponentInfo(props, () -> ((Action)action).component()));
            actionInfo.actionName(action.value());
            return actionInfo;
        }).collect(Collectors.toList());
        props.actions(actionInfoList);
    }

    private void compileBasicConfig(CompileContext compileContext, TableProps_AutoValue props) {
        List genericTypes = this.getGenericTypes(compileContext);
        props.columns(this.buildTableColumnsFromReturnType((TypeElement)genericTypes.get(0), compileContext.getProcessingEnv()));
        props.queryFields(TypeCompileUtils.compileTypeFields((TypeElement)genericTypes.get(1), compileContext.getProcessingEnv()));
        Table.Config tableConfig = compileContext.getComponentElement().getAnnotation(Table.Config.class);
        if (tableConfig == null) {
            return;
        }
        TypeMirror rowExpandedComponent = CompileUtils.getTypeMirrorFromAnnotationValue(() -> ((Table.Config)tableConfig).rowExpandedComponent());
        if (rowExpandedComponent == null || !Component.class.getCanonicalName().equals(rowExpandedComponent.toString())) {
            TypeElement rowExpandedComponentElement = (TypeElement)compileContext.getProcessingEnv().getTypeUtils().asElement(rowExpandedComponent);
            props.rowExpandedComponent(this.getReferencedComponentInfo(props, rowExpandedComponentElement));
        }
        if (tableConfig.childrenFieldName().isEmpty()) {
            props.childrenFieldName(tableConfig.childrenFieldName());
        }
    }
}

