/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.components.layout;

import dev.fastball.compile.AbstractComponentCompiler;
import dev.fastball.compile.CompileContext;
import dev.fastball.compile.exception.CompilerException;
import dev.fastball.ui.components.layout.LayoutComponent;
import dev.fastball.ui.components.layout.LayoutProps;
import dev.fastball.ui.components.layout.LeftAndRightLayoutProps_AutoValue;
import dev.fastball.ui.components.layout.LeftAndTopBottomLayoutProps_AutoValue;
import dev.fastball.ui.components.layout.TopAndBottomLayoutProps_AutoValue;

public class LayoutCompiler
extends AbstractComponentCompiler<LayoutComponent, LayoutProps> {
    private static final String COMPONENT_TYPE = "FastballLayout";

    protected LayoutProps compileProps(CompileContext compileContext) {
        LayoutComponent.LeftAndRight leftAndRight = compileContext.getComponentElement().getAnnotation(LayoutComponent.LeftAndRight.class);
        if (leftAndRight != null) {
            LeftAndRightLayoutProps_AutoValue props = new LeftAndRightLayoutProps_AutoValue();
            props.left(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.LeftAndRight)leftAndRight).left()));
            props.right(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.LeftAndRight)leftAndRight).right()));
            return props;
        }
        LayoutComponent.TopAndBottom topAndBottom = compileContext.getComponentElement().getAnnotation(LayoutComponent.TopAndBottom.class);
        if (topAndBottom != null) {
            TopAndBottomLayoutProps_AutoValue props = new TopAndBottomLayoutProps_AutoValue();
            props.top(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.TopAndBottom)topAndBottom).top()));
            props.bottom(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.TopAndBottom)topAndBottom).bottom()));
            return props;
        }
        LayoutComponent.LeftAndTopBottom leftAndTopBottom = compileContext.getComponentElement().getAnnotation(LayoutComponent.LeftAndTopBottom.class);
        if (leftAndTopBottom != null) {
            LeftAndTopBottomLayoutProps_AutoValue props = new LeftAndTopBottomLayoutProps_AutoValue();
            props.left(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.LeftAndTopBottom)leftAndTopBottom).left()));
            props.top(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.LeftAndTopBottom)leftAndTopBottom).top()));
            props.bottom(this.getReferencedComponentInfo(props, () -> ((LayoutComponent.LeftAndTopBottom)leftAndTopBottom).bottom()));
            return props;
        }
        String message = String.format("LayoutComponent [%s] must add annotation @LeftAndRight or @TopAndBottom or LeftAndTopBottom", compileContext.getComponentElement().getQualifiedName());
        throw new CompilerException(message);
    }

    public String getComponentName() {
        return COMPONENT_TYPE;
    }
}

