/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.runtime.spring;

import dev.fastball.core.annotation.UIComponent;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.util.ClassUtils;

public class FastballComponentScanner
extends ClassPathBeanDefinitionScanner {
    private static final Class<? extends Annotation>[] INCLUDED_ANNOTATION_TYPES = new Class[]{UIComponent.class};

    public FastballComponentScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
        Arrays.stream(INCLUDED_ANNOTATION_TYPES).map(AnnotationTypeFilter::new).forEach(arg_0 -> ((FastballComponentScanner)this).addIncludeFilter(arg_0));
        this.setBeanNameGenerator((BeanNameGenerator)FullyQualifiedAnnotationBeanNameGenerator.INSTANCE);
    }

    public void scan(ResourceLoader resourceLoader) {
        this.setResourceLoader(resourceLoader);
        BeanDefinitionRegistry registry = this.getRegistry();
        assert (registry != null);
        Set<String> packages = FastballComponentScanner.findBasePackages(registry);
        this.scan(packages.toArray(new String[0]));
    }

    public static Set<String> findBasePackages(BeanDefinitionRegistry registry) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        for (String beanDefinitionName : registry.getBeanDefinitionNames()) {
            BeanDefinition definition = registry.getBeanDefinition(beanDefinitionName);
            packages.addAll(FastballComponentScanner.parseDefinition(definition));
        }
        return packages;
    }

    private static Set<String> parseDefinition(BeanDefinition definition) {
        if (definition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)definition;
            return FastballComponentScanner.parseComponentScan(annotatedBeanDefinition.getMetadata());
        }
        return Collections.emptySet();
    }

    private static Set<String> parseComponentScan(AnnotationMetadata metadata) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
        if (null == attributes) {
            return packages;
        }
        packages.addAll(Arrays.asList(attributes.getStringArray("value")));
        packages.addAll(Arrays.asList(attributes.getStringArray("basePackages")));
        packages.addAll(FastballComponentScanner.classToPackage(attributes.getStringArray("basePackageClasses")));
        if (packages.isEmpty()) {
            packages.add(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        return packages;
    }

    private static Collection<String> classToPackage(String[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(values).map(ClassUtils::getPackageName).collect(Collectors.toList());
    }
}

