/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.runtime.spring;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.fastball.core.Result;
import dev.fastball.core.component.DataRecord;
import dev.fastball.core.component.DataResult;
import dev.fastball.core.component.DownloadFile;
import dev.fastball.core.component.LookupActionComponent;
import dev.fastball.core.component.RecordActionFilter;
import dev.fastball.core.component.runtime.ComponentBean;
import dev.fastball.core.component.runtime.ComponentRegistry;
import dev.fastball.core.component.runtime.LookupActionBean;
import dev.fastball.core.component.runtime.LookupActionRegistry;
import dev.fastball.core.component.runtime.RecordActionFilterRegistry;
import dev.fastball.core.component.runtime.UIApiMethod;
import dev.fastball.core.exception.BusinessException;
import dev.fastball.core.intergration.storage.ObjectStorageService;
import dev.fastball.core.intergration.storage.ObjectStorageUpload;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/fastball"})
public class FastballComponentController {
    private static final Logger log = LoggerFactory.getLogger(FastballComponentController.class);
    private final ComponentRegistry componentRegistry;
    private final LookupActionRegistry lookupActionRegistry;
    private final RecordActionFilterRegistry recordActionFilterRegistry;
    private final ObjectMapper objectMapper;
    private final ObjectStorageService objectStorageService;

    @PostMapping(value={"/storage/generateUploadUrl"})
    public Result<ObjectStorageUpload> generateUploadUrl() {
        String url = this.objectStorageService.generateUploadUrl(this.objectStorageService.getDefaultBucket(), this.objectStorageService.generateObjectName("public"));
        return Result.success((Object)ObjectStorageUpload.builder().url(url).build());
    }

    @PostMapping(value={"/storage/upload"})
    public Result<String> uploadFiles(@RequestPart(value="file", required=false) MultipartFile file) {
        try {
            return Result.success((String)this.objectStorageService.upload(file.getInputStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Result.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/component/{componentKey}/action/{actionKey}"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public Object invokeAction(@PathVariable String componentKey, @PathVariable String actionKey, @RequestPart(value="data") String dataJson, @RequestPart(value="file", required=false) MultipartFile file) throws IOException, InvocationTargetException, IllegalAccessException {
        return this.invokeComponentAction(componentKey, actionKey, dataJson, file);
    }

    @PostMapping(value={"/component/{componentKey}/action/{actionKey}/json"})
    public Object invokeAction(@PathVariable String componentKey, @PathVariable String actionKey, @RequestBody String dataJson) throws IOException, InvocationTargetException, IllegalAccessException {
        return this.invokeComponentAction(componentKey, actionKey, dataJson, null);
    }

    @PostMapping(value={"/component/{componentKey}/downloadAction/{actionKey}"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public void invokeComponentDownloadAction(@PathVariable String componentKey, @PathVariable String actionKey, @RequestPart(value="data") String dataJson, @RequestPart(value="file", required=false) MultipartFile file, HttpServletResponse response) throws IOException, InvocationTargetException, IllegalAccessException {
        ComponentBean componentBean = this.componentRegistry.getComponentBean(componentKey);
        UIApiMethod actionMethod = (UIApiMethod)componentBean.getMethodMap().get(actionKey);
        Object result = this.invokeActionMethod((Object)componentBean.getComponent(), actionMethod.getMethod(), dataJson, file, response);
        if (result instanceof DownloadFile) {
            DownloadFile downloadFile = (DownloadFile)result;
            response.setContentType(downloadFile.getContentType());
            response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(downloadFile.getFileName(), "UTF-8"));
            response.addHeader("Cache-Control", "max-age=0");
            response.setCharacterEncoding("utf-8");
            IOUtils.copy((InputStream)downloadFile.getInputStream(), (OutputStream)response.getOutputStream());
        }
    }

    @PostMapping(value={"/lookup/{lookupKey}"})
    public Object loadLookupItems(@PathVariable String lookupKey, ServletRequest request) throws IOException, InvocationTargetException, IllegalAccessException {
        LookupActionBean lookupActionBean = this.lookupActionRegistry.getLookupActionBean(lookupKey);
        if (lookupActionBean == null) {
            throw new RuntimeException("Lookup action not found");
        }
        LookupActionComponent lookupActionComponent = lookupActionBean.getLookupAction();
        Method actionMethod = lookupActionBean.getLookupMethod();
        return this.invokeActionMethod(lookupActionComponent, actionMethod, request);
    }

    private void doRecordActionFilter(DataRecord record, ComponentBean componentBean) {
        HashMap recordActionAvailableFlags = new HashMap();
        componentBean.getRecordActionFilterClasses().forEach((key, value) -> {
            RecordActionFilter recordActionFilter = this.recordActionFilterRegistry.getRecordActionFilter(value);
            if (recordActionFilter != null) {
                recordActionAvailableFlags.put(key, recordActionFilter.filter((Object)record));
            }
        });
        record.setRecordActionAvailableFlags(recordActionAvailableFlags);
    }

    public Object invokeComponentAction(String componentKey, String actionKey, String dataJson, MultipartFile file) throws IOException, InvocationTargetException, IllegalAccessException {
        Result result;
        ComponentBean componentBean = this.componentRegistry.getComponentBean(componentKey);
        UIApiMethod actionMethod = (UIApiMethod)componentBean.getMethodMap().get(actionKey);
        Object data = this.invokeActionMethod((Object)componentBean.getComponent(), actionMethod.getMethod(), dataJson, file, null);
        if (data instanceof Result) {
            result = (Result)data;
            data = result.getData();
        } else {
            result = Result.success((Object)data);
        }
        if (actionMethod.isNeedRecordFilter()) {
            if (data instanceof DataResult) {
                DataResult dataResult = (DataResult)data;
                if (dataResult.getData() != null) {
                    dataResult.getData().stream().filter(DataRecord.class::isInstance).forEach(dataRecord -> this.doRecordActionFilter((DataRecord)dataRecord, componentBean));
                }
            } else if (data instanceof DataRecord) {
                this.doRecordActionFilter((DataRecord)data, componentBean);
            }
        }
        return result;
    }

    private Object invokeActionMethod(Object bean, Method actionMethod, ServletRequest request) throws IOException, IllegalAccessException {
        JsonNode jsonNode = this.objectMapper.readTree((InputStream)request.getInputStream());
        return this.invokeActionMethod(bean, actionMethod, jsonNode, null, null);
    }

    private Object invokeActionMethod(Object bean, Method actionMethod, String dataJson, MultipartFile file, HttpServletResponse response) throws IOException, IllegalAccessException {
        JsonNode jsonNode = this.objectMapper.readTree(dataJson);
        return this.invokeActionMethod(bean, actionMethod, jsonNode, file, response);
    }

    private Object invokeActionMethod(Object bean, Method actionMethod, JsonNode jsonNode, MultipartFile file, HttpServletResponse response) throws IOException, IllegalAccessException {
        int i;
        Parameter[] parameterList = actionMethod.getParameters();
        Object[] params = new Object[parameterList.length];
        for (i = 0; i < Math.min(jsonNode.size(), params.length); ++i) {
            final Parameter parameter = parameterList[i];
            if (jsonNode.get(i) == null) continue;
            try {
                Object param;
                params[i] = param = this.objectMapper.readValue(jsonNode.get(i).toString(), (TypeReference)new TypeReference<Object>(){

                    public Type getType() {
                        return parameter.getParameterizedType();
                    }
                });
                continue;
            }
            catch (Exception e) {
                log.warn("Method [{}] param [{}] read json failed", new Object[]{actionMethod, i, e});
            }
        }
        if (file != null) {
            for (i = 0; i < parameterList.length; ++i) {
                if (parameterList[i].getType() == MultipartFile.class) {
                    params[i] = file;
                }
                if (parameterList[i].getType() == InputStream.class) {
                    params[i] = file.getInputStream();
                }
                if (parameterList[i].getType() != Byte[].class) continue;
                params[i] = file.getBytes();
            }
        }
        try {
            return actionMethod.invoke(bean, params);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof BusinessException) {
                throw (BusinessException)e.getTargetException();
            }
            throw new BusinessException(e.getTargetException());
        }
    }

    public FastballComponentController(ComponentRegistry componentRegistry, LookupActionRegistry lookupActionRegistry, RecordActionFilterRegistry recordActionFilterRegistry, ObjectMapper objectMapper, ObjectStorageService objectStorageService) {
        this.componentRegistry = componentRegistry;
        this.lookupActionRegistry = lookupActionRegistry;
        this.recordActionFilterRegistry = recordActionFilterRegistry;
        this.objectMapper = objectMapper;
        this.objectStorageService = objectStorageService;
    }
}

