/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.okhttp;

import dev.failsafe.Call;
import dev.failsafe.ExecutionContext;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Policy;
import dev.failsafe.internal.util.Assert;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Callback;
import okhttp3.Response;

public final class FailsafeCall {
    private final FailsafeExecutor<Response> failsafe;
    private final okhttp3.Call initialCall;
    private volatile Call<Response> failsafeCall;
    private volatile CompletableFuture<Response> failsafeFuture;
    private AtomicBoolean cancelled = new AtomicBoolean();
    private AtomicBoolean executed = new AtomicBoolean();

    private FailsafeCall(FailsafeExecutor<Response> failsafe, okhttp3.Call call) {
        this.failsafe = failsafe;
        this.initialCall = call;
    }

    @SafeVarargs
    public static <P extends Policy<Response>> FailsafeCallBuilder with(P outerPolicy, P ... policies) {
        return new FailsafeCallBuilder(Failsafe.with(outerPolicy, policies));
    }

    public static FailsafeCallBuilder with(FailsafeExecutor<Response> failsafeExecutor) {
        return new FailsafeCallBuilder((FailsafeExecutor)Assert.notNull(failsafeExecutor, (String)"failsafeExecutor"));
    }

    public void cancel() {
        if (!this.cancelled.compareAndSet(false, true)) {
            return;
        }
        if (this.failsafeCall != null) {
            this.failsafeCall.cancel(false);
        }
        if (this.failsafeFuture != null) {
            this.failsafeFuture.cancel(false);
        }
    }

    public FailsafeCall clone() {
        return new FailsafeCall(this.failsafe, this.initialCall.clone());
    }

    public Response execute() throws IOException {
        Assert.isTrue((boolean)this.executed.compareAndSet(false, true), (String)"already executed", (Object[])new Object[0]);
        this.failsafeCall = this.failsafe.newCall(ctx -> this.prepareCall((ExecutionContext<Response>)ctx).execute());
        try {
            return (Response)this.failsafeCall.execute();
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<Response> executeAsync() {
        if (!this.executed.compareAndSet(false, true)) {
            CompletableFuture<Response> result = new CompletableFuture<Response>();
            result.completeExceptionally(new IllegalStateException("already executed"));
            return result;
        }
        this.failsafeFuture = this.failsafe.getAsyncExecution(exec -> this.prepareCall((ExecutionContext<Response>)exec).enqueue(new Callback(){

            public void onResponse(okhttp3.Call call, Response response) {
                exec.recordResult((Object)response);
            }

            public void onFailure(okhttp3.Call call, IOException e) {
                exec.recordException((Throwable)e);
            }
        }));
        return this.failsafeFuture;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public boolean isExecuted() {
        return this.executed.get();
    }

    private okhttp3.Call prepareCall(ExecutionContext<Response> ctx) {
        okhttp3.Call call;
        if (ctx.isFirstAttempt()) {
            call = this.initialCall;
        } else {
            Response response = (Response)ctx.getLastResult();
            if (response != null) {
                response.close();
            }
            call = this.initialCall.clone();
        }
        ctx.onCancel(() -> {
            this.cancelled.set(true);
            call.cancel();
        });
        return call;
    }

    public static final class FailsafeCallBuilder {
        private FailsafeExecutor<Response> failsafe;

        private FailsafeCallBuilder(FailsafeExecutor<Response> failsafe) {
            this.failsafe = failsafe;
        }

        public <P extends Policy<Response>> FailsafeCallBuilder compose(P innerPolicy) {
            this.failsafe = this.failsafe.compose(innerPolicy);
            return this;
        }

        public FailsafeCall compose(okhttp3.Call call) {
            return new FailsafeCall(this.failsafe, call);
        }
    }
}

