/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.tools.generator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceCleanerImpl;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceExtractorImpl;
import dev.dsf.tools.generator.CertificateGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BundleGenerator.class);
    private final FhirContext fhirContext = FhirContext.forR4();
    private final ReferenceExtractor extractor = new ReferenceExtractorImpl();
    private final ReferenceCleaner cleaner = new ReferenceCleanerImpl(this.extractor);
    private Bundle testBundle;

    private Bundle readAndCleanBundle(Path bundleTemplateFile) {
        Bundle bundle;
        block8: {
            InputStream in = Files.newInputStream(bundleTemplateFile, new OpenOption[0]);
            try {
                Bundle bundle2 = (Bundle)this.newXmlParser().parseResource(Bundle.class, in);
                bundle = (Bundle)this.cleaner.cleanReferenceResourcesIfBundle((Resource)bundle2);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error while reading bundle from {}", (Object)bundleTemplateFile.toString(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return bundle;
    }

    private void writeBundle(Path bundleFile, Bundle bundle) {
        try (OutputStream out = Files.newOutputStream(bundleFile, new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            this.newXmlParser().encodeResourceToWriter((IBaseResource)bundle, (Writer)writer);
        }
        catch (IOException e) {
            logger.error("Error while writing bundle to {}", (Object)bundleFile.toString(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private IParser newXmlParser() {
        IParser parser = this.fhirContext.newXmlParser();
        parser.setStripVersionsFromReferences(Boolean.valueOf(false));
        parser.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        parser.setPrettyPrint(true);
        return parser;
    }

    public void createTestBundle(Map<String, CertificateGenerator.CertificateFiles> clientCertificateFilesByCommonName) {
        Path testBundleTemplateFile = Paths.get("src/main/resources/bundle-templates/test-bundle.xml", new String[0]);
        this.testBundle = this.readAndCleanBundle(testBundleTemplateFile);
        Organization organization = (Organization)((Bundle.BundleEntryComponent)this.testBundle.getEntry().get(0)).getResource();
        Extension thumbprintExtension = organization.getExtensionByUrl("http://dsf.dev/fhir/StructureDefinition/extension-certificate-thumbprint");
        thumbprintExtension.setValue((Type)new StringType(clientCertificateFilesByCommonName.get("test-client").getCertificateSha512ThumbprintHex()));
        this.writeBundle(Paths.get("bundle/test-bundle.xml", new String[0]), this.testBundle);
    }

    public void copyJavaTestBundle() {
        Path javaTestBundleFile = Paths.get("../../dsf-fhir/dsf-fhir-server-jetty/conf/bundle.xml", new String[0]);
        logger.info("Copying fhir bundle to {}", (Object)javaTestBundleFile);
        this.writeBundle(javaTestBundleFile, this.testBundle);
    }
}

