/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.tools.generator;

import dev.dsf.tools.generator.CertificateGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigGenerator.class);
    private static final String P_KEY_ROLE_CONFIG = "dev.dsf.fhir.server.roleConfig";
    private Properties javaTestFhirConfigProperties;

    private Properties readProperties(Path propertiesFile) {
        Properties properties = new Properties(){

            @Override
            public Set<Map.Entry<Object, Object>> entrySet() {
                return Collections.synchronizedSet(super.entrySet().stream().sorted(Comparator.comparing(e -> e.getKey().toString())).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
        };
        try (InputStream in = Files.newInputStream(propertiesFile, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (IOException e) {
            logger.error("Error while reading properties from " + propertiesFile.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return properties;
    }

    private void writeProperties(Path propertiesFiles, Properties properties) {
        try (OutputStream out = Files.newOutputStream(propertiesFiles, new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            properties.store(writer, "Generated by test-data-generator");
        }
        catch (IOException e) {
            logger.error("Error while writing properties to " + propertiesFiles.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void modifyJavaTestFhirConfigProperties(Map<String, CertificateGenerator.CertificateFiles> clientCertificateFilesByCommonName) {
        CertificateGenerator.CertificateFiles webbrowserTestUser = clientCertificateFilesByCommonName.get("Webbrowser Test User");
        Path javaTestFhirConfigTemplateFile = Paths.get("src/main/resources/config-templates/java-test-fhir-config.properties", new String[0]);
        this.javaTestFhirConfigProperties = this.readProperties(javaTestFhirConfigTemplateFile);
        this.javaTestFhirConfigProperties.setProperty(P_KEY_ROLE_CONFIG, String.format("- webbrowser_test_user:\n    thumbprint: %s\n    token-role: admin\n    dsf-role:\n      - CREATE\n      - READ\n      - UPDATE\n      - DELETE\n      - SEARCH\n      - HISTORY\n      - PERMANENT_DELETE\n    practitioner-role:\n      - http://dsf.dev/fhir/CodeSystem/practitioner-role|DSF_ADMIN\n", webbrowserTestUser.getCertificateSha512ThumbprintHex()));
        this.writeProperties(Paths.get("config/java-test-fhir-config.properties", new String[0]), this.javaTestFhirConfigProperties);
    }

    public void copyJavaTestFhirConfigProperties() {
        Path javaTestConfigPropertiesFile = Paths.get("../../dsf-fhir/dsf-fhir-server-jetty/conf/config.properties", new String[0]);
        logger.info("Copying config.properties to {}", (Object)javaTestConfigPropertiesFile);
        this.writeProperties(javaTestConfigPropertiesFile, this.javaTestFhirConfigProperties);
    }
}

