/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.tools.generator;

import de.rwh.utils.crypto.CertificateAuthority;
import dev.dsf.tools.generator.BundleGenerator;
import dev.dsf.tools.generator.CertificateGenerator;
import dev.dsf.tools.generator.ConfigGenerator;
import dev.dsf.tools.generator.EnvGenerator;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TestDataGenerator.class);
    private static final CertificateGenerator certificateGenerator = new CertificateGenerator();
    private static final BundleGenerator bundleGenerator = new BundleGenerator();
    private static final ConfigGenerator configGenerator = new ConfigGenerator();
    private static final EnvGenerator envGenerator = new EnvGenerator();

    public static void main(String[] args) {
        certificateGenerator.generateCertificates();
        certificateGenerator.copyJavaTestCertificates();
        certificateGenerator.copyDockerTestCertificates();
        certificateGenerator.copyDockerTest3DicTtpCertificates();
        Map<String, CertificateGenerator.CertificateFiles> clientCertificateFilesByCommonName = certificateGenerator.getClientCertificateFilesByCommonName();
        CertificateGenerator.CertificateFiles webbrowserTestUser = clientCertificateFilesByCommonName.get("Webbrowser Test User");
        Path p12File = certificateGenerator.createP12(webbrowserTestUser);
        logger.warn("Install client-certificate and CA certificate from \"{}\" into your browsers certificate store to access fhir and bpe servers with your webbrowser", (Object)p12File.toAbsolutePath().toString());
        bundleGenerator.createTestBundle(clientCertificateFilesByCommonName);
        bundleGenerator.copyJavaTestBundle();
        configGenerator.modifyJavaTestFhirConfigProperties(clientCertificateFilesByCommonName);
        configGenerator.copyJavaTestFhirConfigProperties();
        envGenerator.generateAndWriteDockerTestFhirEnvFile(clientCertificateFilesByCommonName);
        envGenerator.generateAndWriteDockerTest3DicTtpDockerFhirEnvFiles(clientCertificateFilesByCommonName);
    }

    static {
        CertificateAuthority.registerBouncyCastleProvider();
    }
}

